/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.ui.IListEditor;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class MultipleChoiceFieldEditor
extends ExtendedFieldEditor
implements IPropertyFieldEditor,
IListEditor,
IFieldEditor,
PropertyChangeListener {
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected ILabelProvider labelProvider;
    protected IListContentProvider listContentProvider;
    protected Composite list;
    protected Button[] boxes = new Button[0];
    protected Composite buttonsParent;
    Map<String, Choice> choicesMap = new HashMap<String, Choice>();
    ArrayList<Choice> choicesArray = new ArrayList();
    boolean propertyChangeEnabled = true;
    Label empty = null;

    public MultipleChoiceFieldEditor() {
    }

    public MultipleChoiceFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    private void addChoice(Choice c) {
        this.choicesMap.put(c.name, c);
        this.choicesArray.add(c);
    }

    private void removeChoice(Choice c) {
        this.choicesMap.remove(c.name);
        this.choicesArray.remove((Object)c);
    }

    protected Choice getChoice(String name, boolean create) {
        Choice c = this.choicesMap.get(name);
        if (c == null && create) {
            c = new Choice(name);
        }
        if (c != null) {
            c.create();
        }
        return c;
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.listContentProvider = (IListContentProvider)propertyEditor.getAdapter(IListContentProvider.class);
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
        }
        this.valueProvider.addValueChangeListener(this);
    }

    protected void adjustForNumColumns(int numColumns) {
        Control control = this.getLabelComposite();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Control control = this.getLabelComposite(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.createListControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setListContentProvider(IListContentProvider listContentProvider) {
        this.listContentProvider = listContentProvider;
    }

    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createListControl(parent)};
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.propertyChangeEnabled) {
            return;
        }
        super.propertyChange(evt);
        this.valueProvider.removeValueChangeListener(this);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            this.updateChoices();
        } else if ("IPropertyEditor.listContent".equals(evt.getPropertyName())) {
            DefaultValueAdapter a = (DefaultValueAdapter)this.propertyEditor.getInput();
            a.load();
            String newValue = (String)this.valueProvider.getValue();
            this.valueProvider.setValue("");
            this.resetChoices();
            this.valueProvider.setValue(newValue);
        }
        this.valueProvider.addValueChangeListener(this);
    }

    protected Control getListControl() {
        return this.list;
    }

    protected Composite createListControl(Composite parent) {
        if (this.list == null || this.list.isDisposed()) {
            Composite c;
            ScrolledComposite sp = new ScrolledComposite(parent, 2816);
            sp.setLayoutData((Object)new GridData(1808));
            this.list = sp;
            sp.setLayout((Layout)new GridLayout());
            this.buttonsParent = c = new Composite((Composite)sp, 0);
            c.setLayoutData((Object)new GridData(1808));
            sp.setContent((Control)c);
            c.setLayout((Layout)new GridLayout());
            this.resetChoices();
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    protected void updateChoices() {
        Choice c;
        HashSet<String> m = new HashSet<String>();
        m.addAll(this.choicesMap.keySet());
        String[] es = (String[])this.listContentProvider.getElements(null);
        HashSet<String> ess = new HashSet<String>();
        int i = 0;
        while (i < es.length) {
            ess.add(es[i]);
            ++i;
        }
        String value = (String)this.valueProvider.getValue();
        if (value == null) {
            value = "";
        }
        StringTokenizer st = new StringTokenizer(value, ",;");
        String[] vs = new String[st.countTokens()];
        HashSet<String> vss = new HashSet<String>();
        int i2 = 0;
        while (i2 < vs.length) {
            vs[i2] = st.nextToken();
            vss.add(vs[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < vs.length) {
            c = this.getChoice(vs[i2], true);
            c.setSelected(true);
            c.setAllowed(ess.contains(vs[i2]));
            m.remove(vs[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < es.length) {
            c = this.getChoice(es[i2], true);
            c.setSelected(vss.contains(es[i2]));
            c.setAllowed(true);
            m.remove(es[i2]);
            ++i2;
        }
        String[] obs = m.toArray(new String[0]);
        int i3 = 0;
        while (i3 < obs.length) {
            Choice c2 = this.getChoice(obs[i3], false);
            if (c2 != null) {
                c2.dispose();
                this.choicesMap.remove(obs[i3]);
            }
            ++i3;
        }
        boolean isEmpty = es.length == 0 && vs.length == 0;
        this.updateEmpty(isEmpty);
    }

    void updateEmpty(boolean isEmpty) {
        if (isEmpty == (this.empty != null && !this.empty.isDisposed())) {
            return;
        }
        if (isEmpty) {
            this.empty = new Label(this.buttonsParent, 0);
            this.empty.setText("Choice list is empty.");
        } else if (this.empty != null) {
            if (!this.empty.isDisposed()) {
                this.empty.dispose();
            }
            this.empty = null;
        }
    }

    public void resetChoices() {
        this.updateChoices();
        this.buttonsParent.pack();
        this.buttonsParent.layout();
    }

    protected void fireValueChange() {
        StringBuffer sb = new StringBuffer();
        Choice[] cs = this.choicesArray.toArray(new Choice[0]);
        int i = 0;
        while (i < cs.length) {
            if (cs[i].selected) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(cs[i].name);
            }
            ++i;
        }
        this.propertyChangeEnabled = false;
        this.valueProvider.setValue(sb.toString());
        this.propertyChangeEnabled = true;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getListControl() != null) {
            this.getListControl().setEnabled(enabled);
        }
    }

    public void setFocus() {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.setFocus();
        }
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void delete() {
    }

    class Choice
    extends SelectionAdapter {
        String name;
        boolean selected;
        boolean allowed = true;
        Button box;

        public Choice(String name) {
            this.name = name;
            MultipleChoiceFieldEditor.this.addChoice(this);
        }

        public void setSelected(boolean b) {
            this.selected = b;
            if (this.box != null && !this.box.isDisposed()) {
                this.box.setSelection(this.selected);
            }
        }

        public void setAllowed(boolean b) {
            this.allowed = b;
            if (this.box != null && !this.box.isDisposed()) {
                int color = this.allowed ? 2 : 4;
                this.box.setForeground(Display.getDefault().getSystemColor(color));
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.selected = this.box.getSelection();
            MultipleChoiceFieldEditor.this.fireValueChange();
        }

        public void create() {
            if (MultipleChoiceFieldEditor.this.buttonsParent == null || MultipleChoiceFieldEditor.this.buttonsParent.isDisposed()) {
                return;
            }
            if (this.box == null || this.box.isDisposed()) {
                this.box = new Button(MultipleChoiceFieldEditor.this.buttonsParent, 32);
                this.box.setText(this.name);
                this.box.addSelectionListener((SelectionListener)this);
            }
        }

        public void dispose() {
            if (this.box != null && !this.box.isDisposed()) {
                this.box.dispose();
                this.box = null;
                MultipleChoiceFieldEditor.this.removeChoice(this);
            }
        }
    }
}

