/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.Properties;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.XAttributeConstraintL;
import org.jboss.tools.common.meta.constraint.XAttributeConstraintT;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.XAttributePropertyDescription;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class DefaultXAttributeTreeContentProvider
implements ITreeContentProvider {
    protected XAttribute attribute;
    protected XFilteredTree filteredTree;
    protected XModelObject object;
    protected XModel model;
    protected Properties properties = new Properties();

    public DefaultXAttributeTreeContentProvider(XAttribute attribute, XModel model, XModelObject object) {
        this.attribute = attribute;
        this.model = model;
        this.object = object;
        if (attribute != null && attribute.getConstraint() instanceof XAttributeConstraintT) {
            XAttributeConstraintT attributeConstraint = (XAttributeConstraintT)attribute.getConstraint();
            this.properties = attributeConstraint.getProperties();
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        if (parentElement instanceof XModelObject) {
            result = this.getFilteredTree().getChildren((XModelObject)parentElement);
        } else if (this.getFilteredTree() != null) {
            result = this.getFilteredTree().getChildren(this.getFilteredTree().getRoot());
        }
        return result;
    }

    public Object getParent(Object element) {
        XModelObject result = null;
        if (element instanceof XModelObject) {
            result = this.getFilteredTree().getParent((XModelObject)element);
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof XModelObject) {
            result = this.getFilteredTree().hasChildren((XModelObject)element);
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof XAttributePropertyDescription) {
            XAttribute attribute = ((XAttributePropertyDescription)inputElement).getAttribute();
            if (attribute != null && attribute.getConstraint() instanceof XAttributeConstraintT) {
                XAttributeConstraintT attributeConstraint = (XAttributeConstraintT)attribute.getConstraint();
                String filteredTreeName = attributeConstraint.getFilteredTreeName();
                this.filteredTree = this.createFilteredTree(filteredTreeName);
                return this.getChildren(this.filteredTree.getRoot());
            }
        } else if (this.attribute != null) {
            if (this.attribute != null && this.attribute.getConstraint() instanceof XAttributeConstraintT) {
                boolean hideRoot;
                XAttributeConstraintT attributeConstraint = (XAttributeConstraintT)this.attribute.getConstraint();
                String filteredTreeName = attributeConstraint.getFilteredTreeName();
                this.filteredTree = this.createFilteredTree(filteredTreeName);
                boolean bl = hideRoot = this.properties != null && "true".equals(this.properties.get("hideRoot"));
                if (hideRoot) {
                    return this.getChildren(this.filteredTree.getRoot());
                }
                return new Object[]{this.filteredTree.getRoot()};
            }
            if (this.attribute.getConstraint() instanceof XAttributeConstraintL) {
                return ((XAttributeConstraintL)this.attribute.getConstraint()).getValues();
            }
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        viewer.refresh();
    }

    void ignore() {
    }

    protected XFilteredTree createFilteredTree(String filteredTreeName) {
        String classname = this.model.getMetaData().getMapping("FilteredTrees").getValue(filteredTreeName);
        XFilteredTree tree = (XFilteredTree)ModelFeatureFactory.getInstance().createFeatureInstance(classname);
        if (tree == null) {
            return null;
        }
        tree.setModel(this.model);
        tree.setConstraint((Object)new Object[]{this.attribute, this.object});
        return tree;
    }

    public XFilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    public void setFilteredTree(XFilteredTree tree) {
        this.filteredTree = tree;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

