/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action;

import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CommandBarLayout
extends Layout {
    private static final int DEFAULT_GAP = 5;
    private static final int DEFAULT_LEFT = 5;
    private static final int DEFAULT_RIGHT = 5;
    private static final int DEFAULT_TOP = 5;
    private static final int DEFAULT_BOTTOM = 5;
    public int buttonWidth = -1;
    public int buttonHeight = -1;
    public int direction = 256;
    public int gap = -1;
    public int top = -1;
    public int left = -1;
    public int bottom = -1;
    public int right = -1;
    public boolean iconsOnly = false;
    public boolean asToolBar = false;
    public int alignment = 16384;

    public void setMargins(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int w = this.left() + this.right();
        int h = this.top() + this.bottom();
        Control[] cs = composite.getChildren();
        if (cs == null || cs.length == 0) {
            int width = this.left() + this.right() + (this.buttonWidth != -1 ? this.buttonWidth : 0);
            int height = this.top() + this.bottom() + (this.buttonHeight != -1 ? this.buttonHeight : 0);
            return new Point(width, height);
        }
        int bw = this.computeButtonWidth(cs);
        int bh = this.computeButtonHeight(cs);
        if (this.direction == 256) {
            w = w + (cs.length - 1) * this.gap() + cs.length * bw;
            h += bh;
        } else {
            w += bw;
            h = h + (cs.length - 1) * this.gap() + cs.length * bh;
        }
        return new Point(w, h);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Point size = composite.getSize();
        Point s = this.computeSize(composite, -1, -1, false);
        Control[] cs = composite.getChildren();
        int bw = this.computeButtonWidth(cs);
        int bh = this.computeButtonHeight(cs);
        int x = this.left();
        int y = this.top();
        int dx = this.gap() + bw;
        int dy = this.gap() + bh;
        if (this.alignment == 131072) {
            x = size.x - s.x + this.left();
        }
        if (this.direction == 256) {
            int i = 0;
            while (i < cs.length) {
                cs[i].setBounds(x, y, bw, bh);
                x += dx;
                ++i;
            }
        } else {
            int i = 0;
            while (i < cs.length) {
                cs[i].setBounds(x, y, bw, bh);
                y += dy;
                ++i;
            }
        }
    }

    private int computeButtonHeight(Control[] cs) {
        if (this.buttonHeight != -1 && !this.iconsOnly) {
            return this.buttonHeight;
        }
        int height = 0;
        int i = 0;
        while (i < cs.length) {
            int h = cs[i].computeSize((int)-1, (int)-1).y;
            if (this.iconsOnly) {
                h -= 6;
            }
            height = Math.max(h, height);
            ++i;
        }
        return height;
    }

    private int computeButtonWidth(Control[] cs) {
        if (this.buttonWidth != -1 && !this.iconsOnly) {
            return this.buttonWidth;
        }
        int width = 0;
        int i = 0;
        while (i < cs.length) {
            int w = cs[i].computeSize((int)-1, (int)-1).x;
            if (this.iconsOnly) {
                w -= 6;
            }
            width = Math.max(w, width);
            if (!this.iconsOnly) {
                int w1 = this.convertHorizontalDLUsToPixels(cs[i], 61);
                width = Math.max(w1, width);
            }
            ++i;
        }
        return width;
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    private int top() {
        return this.top != -1 ? this.top : 5;
    }

    private int left() {
        return this.left != -1 ? this.left : 5;
    }

    private int bottom() {
        return this.bottom != -1 ? this.bottom : 5;
    }

    private int right() {
        return this.right != -1 ? this.right : 5;
    }

    private int gap() {
        return this.gap != -1 ? this.gap : 5;
    }
}

