/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.RefreshAction;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddNatureActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    protected IProject project;
    protected boolean isWindowAction;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (action != null && !action.isEnabled()) {
            return;
        }
        if (this.project == null) {
            if (action != null) {
                action.setEnabled(false);
            }
            return;
        }
        this.doRun();
    }

    protected void doRun() {
        if (this.project == null) {
            return;
        }
        RefreshAction refreshAction = new RefreshAction(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell());
        refreshAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.project));
        refreshAction.run();
        IWizard wizard = this.getWizard(this.project);
        WizardDialog dialog = new WizardDialog(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), wizard);
        dialog.open();
    }

    protected abstract IWizard getWizard(IProject var1);

    protected abstract String getNatureID();

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.project = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object object = structuredSelection.getFirstElement();
            if (object instanceof IResource) {
                this.project = ((IResource)object).getProject();
            } else if (object instanceof IJavaElement) {
                this.project = ((IJavaElement)object).getJavaProject().getProject();
            }
            if (this.project != null) {
                try {
                    if (!this.project.isOpen() || this.project.hasNature(this.getNatureID())) {
                        this.project = null;
                    }
                }
                catch (CoreException ex) {
                    this.project = null;
                    ModelUIPlugin.getPluginLog().logError((Throwable)ex);
                }
            }
        }
        if (action != null) {
            action.setEnabled(this.project != null);
        }
    }

    protected String findWebXML(String root) {
        if (root == null) {
            return "";
        }
        File rf = new File(root);
        if (!rf.isDirectory()) {
            return "";
        }
        ArrayList<File> folders = new ArrayList<File>();
        folders.add(rf);
        return this.findWebXML(folders);
    }

    protected String findWebXML(List<File> folders) {
        if (folders == null || folders.size() == 0) {
            return "";
        }
        for (File f : folders) {
            String s;
            if (!f.isDirectory() || !new File(s = String.valueOf(f.getAbsolutePath().replace('\\', '/')) + "/WEB-INF/web.xml").isFile()) continue;
            return s;
        }
        ArrayList<File> nextLevelFolders = new ArrayList<File>();
        for (File f : folders) {
            File[] fs = f.listFiles();
            if (fs == null) continue;
            int i = 0;
            while (i < fs.length) {
                if (fs[i].isDirectory()) {
                    nextLevelFolders.add(fs[i]);
                }
                ++i;
            }
        }
        return this.findWebXML(nextLevelFolders);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.isWindowAction = true;
    }
}

