/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.reporting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.dialog.ErrorDialog;
import org.jboss.tools.common.model.ui.reporting.ReportPreference;
import org.jboss.tools.common.reporting.IProblemReporter;

public class ProblemReporter
implements IProblemReporter {
    static int DO_NOTNING_ACTION = 0;
    static int ADD_TO_BUFFER_ACTION = 1;
    static int REPORT_ACTION = 2;

    public void reportProblem(IStatus status) {
        if (this.isShowProblemDialogOn() && Display.getDefault() != null) {
            this.showProblemDialog(status);
        }
    }

    private boolean isShowProblemDialogOn() {
        return "yes".equals(ReportPreference.SHOW_ERROR_DIALOG_OPTION.getValue());
    }

    private boolean isSubmitProblemAutomaticallyOn() {
        return "yes".equals(ReportPreference.SUBMIT_AUTOMATICALLY_OPTION.getValue());
    }

    private int showProblemDialog(IStatus status) {
        Shell shell = null;
        shell = ModelPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        return ErrorDialog.openError(shell, "Error", status.getMessage(), status.getException());
    }

    public static String throwableToString(String message, Throwable t) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            if (message == null) {
                message = t.getMessage();
            }
            if (message != null) {
                ps.print(message);
                ps.print("\n");
            }
            t.printStackTrace(ps);
            if (t instanceof SWTError && ((SWTError)t).throwable != null) {
                ps.println("\n*** Stack trace of contained exception ***");
                ((SWTError)t).throwable.printStackTrace(ps);
            } else if (t instanceof SWTException && ((SWTException)t).throwable != null) {
                ps.println("\n*** Stack trace of contained exception ***");
                ((SWTException)t).throwable.printStackTrace(ps);
            }
            ps.flush();
            baos.flush();
            return baos.toString();
        }
        catch (IOException iOException) {
            return "Failed to read throwable.";
        }
    }
}

