/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.navigator;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class NavigatorStatusLineProvider {
    public String getStatusLineMessage(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof XModelObject) {
                return this.getStatusLineMessage((XModelObject)o);
            }
            return "";
        }
        if (selection.size() > 1) {
            return MessageFormat.format("{0} items selected", selection.size());
        }
        return "";
    }

    protected String getStatusLineMessage(XModelObject object) {
        if (object.getFileType() > 0) {
            return this.getStatusLineMessageForResource(object);
        }
        return this.getStatusLineMessageForFileFragment(object);
    }

    private String getStatusLineMessageForResource(XModelObject object) {
        String msg;
        IResource resource = EclipseResourceUtil.getResource((XModelObject)object);
        String string = msg = resource == null ? "" : resource.getFullPath().makeRelative().toString();
        if (msg.length() == 0 && object.getFileType() == 3) {
            msg = XModelObjectUtil.expand((String)object.get("location"), (XModel)object.getModel(), null);
        }
        return msg.length() == 0 ? object.getPathPart() : msg;
    }

    private String getStatusLineMessageForFileFragment(XModelObject object) {
        if (object == null) {
            return "";
        }
        if (!object.isActive()) {
            return object.getPresentationString();
        }
        XModelObject f = object.getParent();
        while (f != null && f.getFileType() == 0) {
            f = f.getParent();
        }
        if (f == null) {
            return object.getPath().replace('/', '.');
        }
        StringBuffer sb = new StringBuffer();
        XModelObject p = object;
        while (p != null && p != f) {
            if (sb.length() > 0) {
                sb.insert(0, '.');
            }
            sb.insert(0, p.getPresentationString());
            p = p.getParent();
        }
        String relative = sb.toString();
        String parent = this.getStatusLineMessageForResource(f);
        return String.valueOf(relative) + " - " + parent;
    }
}

