/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposal;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesComposite;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class DropUtils {
    public static final String HTML40_URI = "";

    public static IFile getResourceForMimeData(DropData dropData) {
        IFile file;
        boolean isWorkspaceFile = dropData.getMimeData() != null && dropData.getMimeData().startsWith("L/");
        IFile iFile = file = isWorkspaceFile ? ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(dropData.getMimeData()).removeFirstSegments(1)) : EclipseResourceUtil.getFile((String)dropData.getMimeData());
        if (file == null || !file.exists()) {
            URL newUrl = null;
            try {
                newUrl = new URL(dropData.getMimeData());
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(newUrl.getPath()));
            }
            catch (MalformedURLException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(newUrl.getPath()));
        }
        return file;
    }

    public static IContainer getWebRootContainer(IProject project) {
        IResource r;
        IProject container = project;
        IModelNature modelNature = EclipseResourceUtil.getModelNature((IProject)project);
        if (modelNature == null) {
            return project;
        }
        XModelObject o = modelNature.getModel().getByPath("FileSystems/WEB-ROOT");
        if (o != null) {
            container = (IContainer)EclipseResourceUtil.getResource((XModelObject)o);
        }
        if (container == null && (r = EclipseResourceUtil.getFirstWebContentResource((IProject)project)) instanceof IContainer) {
            container = (IContainer)r;
        }
        return container;
    }

    public static String convertPathToUrl(String path) {
        try {
            return new File(path).toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            return path;
        }
    }

    public static interface AttributeDescriptorValueProvider {
        public void initContext(Properties var1);

        public void setProposal(ITagProposal var1);

        public String getTag();

        public boolean canHaveBody();

        public TagAttributesComposite.AttributeDescriptorValue[] getValues();
    }
}

