/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.page;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.tools.struts.model.helpers.page.ReplaceConfirmedLinkHelper;
import org.jboss.tools.struts.model.helpers.page.link.Link;
import org.jboss.tools.struts.model.helpers.page.link.Links;
import org.jboss.tools.struts.webprj.pattern.UrlPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPLinksParser {
    private Set<String> toForwards = new HashSet<String>();
    private Set<String> toActions = new HashSet<String>();
    private Set<String> toPages = new HashSet<String>();
    private String source;
    private UrlPattern pattern;
    private Links links;

    public JSPLinksParser(Links links) {
        this.links = links;
    }

    public void setUrlPattern(UrlPattern pattern) {
        this.pattern = pattern;
    }

    public void setSource(String source) {
        source = JSPLinksParser.removeToken(source, "<!--", "-->");
        this.source = source = JSPLinksParser.removeToken(source, "<%", "%>");
    }

    private static String removeToken(String body, String start, String end) {
        int ib;
        int ia = 0;
        int n = ib = body == null ? -1 : body.indexOf(start);
        if (ib < 0) {
            return body;
        }
        int l = body.length();
        StringBuffer sb = new StringBuffer();
        while (true) {
            sb.append(body.substring(ia, ib));
            ia = body.indexOf(end, ib + start.length());
            if (ia < 0) break;
            ib = body.indexOf(start, ia += end.length());
            if (ib >= 0) continue;
            ib = l;
        }
        return sb.toString();
    }

    private Set<String> getForwards() {
        return this.toForwards;
    }

    private Set<String> getActions() {
        return this.toActions;
    }

    private Set<String> getPages() {
        return this.toPages;
    }

    public Set<String> getAllLinks() {
        HashSet<String> ls = new HashSet<String>();
        Iterator<String> it = this.getActions().iterator();
        while (it.hasNext()) {
            ls.add(it.next());
        }
        it = this.getForwards().iterator();
        while (it.hasNext()) {
            ls.add(it.next());
        }
        it = this.getPages().iterator();
        while (it.hasNext()) {
            ls.add(it.next());
        }
        return ls;
    }

    public boolean isForward(String s) {
        return this.toForwards.contains(s);
    }

    public void parse() {
        if (this.source == null) {
            return;
        }
        this.parseAdvanced(0, this.source.length());
    }

    private void parseAdvanced(int b, int e) {
        if (this.links == null) {
            return;
        }
        Set<String> tags = this.links.getTags();
        while (b < e) {
            int i = this.source.indexOf("<", b);
            if (i < 0) {
                return;
            }
            String n = ReplaceConfirmedLinkHelper.readTagName(this.source, i);
            int j = this.source.indexOf(62, i);
            if (j < 0) {
                j = e;
            }
            if (n != null) {
                b = i + 1 + n.length();
                if (tags.contains(n)) {
                    this.parseTagAdvanced(n, b, j);
                }
            }
            b = j;
        }
    }

    private void parseTagAdvanced(String n, int b, int e) {
        Link[] ls = this.links.getLinks(n);
        int k = 0;
        while (k < ls.length) {
            String attr = ls[k].getAttribute();
            String referTo = ls[k].getReferTo();
            if ("action".equals(referTo) ? this.processAttrAction(attr, b, e) != null : ("forward".equals(referTo) ? this.processAttrForward(attr, b, e) != null : ("page".equals(referTo) ? this.processAttrPage(attr, b, e) != null : this.processAttrAction(attr, b, e) != null))) {
                return;
            }
            ++k;
        }
    }

    private String processAttrAction(String name, int b, int e) {
        String s = this.readAttributeR(name, b, e);
        if (s == null || s.length() == 0) {
            return s;
        }
        if (this.pattern.isActionUrl(s)) {
            s = this.pattern.getActionUrl(s);
            this.toActions.add(s);
        } else {
            if (!s.startsWith("/")) {
                s = "/" + s;
            }
            this.toPages.add(s);
        }
        return s;
    }

    private String processAttrForward(String attr, int b, int e) {
        String s = this.readAttributeR(attr, b, e);
        if (s != null) {
            this.toForwards.add(s);
        }
        return s;
    }

    private String processAttrPage(String attr, int b, int e) {
        String s = this.readAttributeR(attr, b, e);
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.startsWith("http:")) {
            this.toPages.add(s);
        } else {
            if (!s.startsWith("/") && s.length() > 0) {
                s = "/" + s;
            }
            if (this.pattern.isActionUrl(s)) {
                this.toActions.add(s);
            } else {
                this.toPages.add(s);
            }
        }
        return s;
    }

    private String readAttributeR(String attr, int b, int e) {
        String s = this.readAttribute(attr, b, e);
        if (s == null || s.length() == 0) {
            return null;
        }
        int i = s.indexOf(63);
        if (i > 0) {
            s = s.substring(0, i);
        }
        return s;
    }

    private String readAttribute(String attr, int b, int e) {
        int i = this.indexOfAttribute(attr, b, e);
        if (i < 0) {
            return null;
        }
        return this.readAttrValue(i + attr.length(), e);
    }

    private boolean startsWith(String w, int b, int e) {
        int l = w.length();
        if (e - b < l) {
            return false;
        }
        int i = 0;
        while (i < l) {
            if (this.source.charAt(b + i) != w.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int indexOfAttribute(String w, int b, int e) {
        int l = e - w.length();
        char q = '\u0000';
        int i = b;
        while (i < l) {
            char c = this.source.charAt(i);
            if (q != '\u0000') {
                if (c == q) {
                    q = '\u0000';
                }
            } else if (c == '\"' || c == '\'') {
                q = c;
            } else if (this.startsWith(w, i, e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String readAttrValue(int b, int e) {
        char q = '\u0000';
        int ab = b;
        int ae = e;
        int i = b;
        while (i < e) {
            char c = this.source.charAt(i);
            if (q == '\u0000') {
                if (c == '\"' || c == '\'') {
                    q = c;
                }
                ab = i + 1;
            } else if (c == q) {
                ae = i;
                return this.source.substring(ab, ae);
            }
            ++i;
        }
        return "";
    }

    public boolean areLinksModified(JSPLinksParser p) {
        if (!this.areSetsEqual(this.toActions, p.getActions())) {
            return true;
        }
        if (!this.areSetsEqual(this.toForwards, p.getForwards())) {
            return true;
        }
        return !this.areSetsEqual(this.toPages, p.getPages());
    }

    private boolean areSetsEqual(Set<String> s1, Set<String> s2) {
        if (s1.size() != s2.size()) {
            return false;
        }
        Iterator<String> it = s1.iterator();
        while (it.hasNext()) {
            if (s2.contains(it.next())) continue;
            return false;
        }
        it = s2.iterator();
        while (it.hasNext()) {
            if (s1.contains(it.next())) continue;
            return false;
        }
        return true;
    }
}

