/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.util;

import de.tobject.findbugs.FindbugsPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class MutexSchedulingRule
implements ISchedulingRule {
    private static final boolean MULTICORE = Runtime.getRuntime().availableProcessors() > 1;
    private static final int MAX_JOBS = Runtime.getRuntime().availableProcessors();
    private final IProject project;

    public MutexSchedulingRule(IProject project) {
        this.project = project;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule instanceof MutexSchedulingRule) {
            if (this.project == null) {
                return true;
            }
            MutexSchedulingRule mRule = (MutexSchedulingRule)rule;
            if (MULTICORE) {
                return mRule.project.equals(this.project) || MutexSchedulingRule.tooManyJobsThere();
            }
            return true;
        }
        return false;
    }

    private static boolean tooManyJobsThere() {
        Job[] fbJobs = Job.getJobManager().find(FindbugsPlugin.class);
        int runningCount = 0;
        for (Job job : fbJobs) {
            if (job.getState() != 4) continue;
            ++runningCount;
        }
        return runningCount > MAX_JOBS;
    }

    public boolean contains(ISchedulingRule rule) {
        if (rule instanceof IProject && this.project != null) {
            return this.project.equals(rule);
        }
        return this.isConflicting(rule);
    }

    public String toString() {
        return "MutexSchedulingRule, project: " + this.project;
    }
}

