/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.EditorUtil;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BugInstanceSection
extends AbstractPropertySection {
    private Composite rootComposite;
    private List annotationList;
    private BugInstance bug;
    private IMarker marker;
    private IFile file;
    private String title;
    private IJavaElement javaElt;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Color background = tabbedPropertySheetPage.getWidgetFactory().getColors().getBackground();
        this.rootComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = 5;
        layout.marginTop = 5;
        this.rootComposite.setLayout((Layout)layout);
        this.rootComposite.setSize(-1, -1);
        Group group = new Group(this.rootComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Bug annotations:");
        this.rootComposite.setBackground(background);
        group.setBackground(background);
        this.annotationList = new List((Composite)group, 0);
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        this.annotationList.setLayoutData((Object)data);
        this.annotationList.setFont(JFaceResources.getDialogFont());
        this.annotationList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evnt) {
                BugInstanceSection.this.selectInEditor(false);
            }
        });
        this.annotationList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                BugInstanceSection.this.selectInEditor(true);
            }
        });
        Menu menu = new Menu((Control)this.annotationList);
        final MenuItem item = new MenuItem(menu, 8);
        item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        item.setText("Copy To Clipboard");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BugInstanceSection.this.copyInfoToClipboard();
            }
        });
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                item.setEnabled(BugInstanceSection.this.bug != null);
            }
        });
        this.annotationList.setMenu(menu);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.marker = MarkerUtil.getMarkerFromSingleSelection(selection);
        if (this.marker == null) {
            this.bug = null;
            this.file = null;
            this.title = null;
            this.javaElt = null;
        } else {
            this.bug = MarkerUtil.findBugInstanceForMarker(this.marker);
            this.file = (IFile)(this.marker.getResource() instanceof IFile ? this.marker.getResource() : null);
            this.javaElt = MarkerUtil.findJavaElementForMarker(this.marker);
            if (this.file == null && this.javaElt == null) {
                FindbugsPlugin.getDefault().logError("Could not find file for " + this.bug.getMessage());
            }
            this.refreshTitle();
        }
        this.refreshAnnotations();
    }

    public void refresh() {
        super.refresh();
    }

    public void dispose() {
        if (this.rootComposite != null) {
            this.rootComposite.dispose();
        }
        super.dispose();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private void selectInEditor(boolean openEditor) {
        IEditorInput input;
        if (this.bug == null || this.file == null && this.javaElt == null) {
            return;
        }
        IWorkbenchPage page = this.getPart().getSite().getPage();
        IEditorPart activeEditor = page.getActiveEditor();
        IEditorInput iEditorInput = input = activeEditor != null ? activeEditor.getEditorInput() : null;
        if (openEditor && !this.matchInput(input)) {
            try {
                if (this.file != null) {
                    activeEditor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.file);
                } else if (this.javaElt != null) {
                    activeEditor = JavaUI.openInEditor((IJavaElement)this.javaElt, (boolean)true, (boolean)true);
                }
                if (activeEditor != null) {
                    input = activeEditor.getEditorInput();
                }
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open editor for " + this.bug.getMessage());
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not open editor for " + this.bug.getMessage());
            }
        }
        if (this.matchInput(input)) {
            int startLine = this.getLineToSelect();
            EditorUtil.goToLine(activeEditor, startLine);
        }
    }

    private boolean matchInput(IEditorInput input) {
        if (this.file != null && input instanceof IFileEditorInput) {
            return this.file.equals(((IFileEditorInput)input).getFile());
        }
        if (this.javaElt != null && input != null) {
            IJavaElement parent;
            IJavaElement javaElement = JavaUI.getEditorInputJavaElement((IEditorInput)input);
            if (this.javaElt.equals(javaElement)) {
                return true;
            }
            for (parent = this.javaElt.getParent(); parent != null && !parent.equals(javaElement); parent = parent.getParent()) {
            }
            if (parent != null && parent.equals(javaElement)) {
                return true;
            }
        }
        return false;
    }

    private void refreshTitle() {
        String bugType = this.marker.getAttribute("BUGTYPE", "");
        BugPattern pattern = I18N.instance().lookupBugPattern(bugType);
        if (pattern == null || this.bug == null) {
            this.title = "";
            return;
        }
        String shortDescription = this.bug.getAbridgedMessage();
        String abbrev = "[" + this.bug.getPriorityAbbreviation() + " " + this.bug.getCategoryAbbrev() + " " + pattern.getAbbrev() + "] ";
        this.title = shortDescription == null ? abbrev : abbrev + shortDescription.trim() + " [" + pattern.getType() + "]";
    }

    private void refreshAnnotations() {
        this.annotationList.removeAll();
        if (this.bug != null) {
            Iterator<BugAnnotation> it = this.bug.annotationIterator();
            while (it.hasNext()) {
                BugAnnotation ba = it.next();
                this.annotationList.add(ba.toString());
            }
        }
    }

    private int getLineToSelect() {
        int index = this.annotationList.getSelectionIndex();
        Iterator<BugAnnotation> theIterator = this.bug.annotationIterator();
        BugAnnotation theAnnotation = theIterator.next();
        for (int i = 0; i < index; ++i) {
            theAnnotation = theIterator.next();
        }
        if (!(theAnnotation instanceof SourceLineAnnotation)) {
            return this.marker.getAttribute("lineNumber", 1);
        }
        SourceLineAnnotation sla = (SourceLineAnnotation)theAnnotation;
        int startLine = sla.getStartLine();
        return startLine <= 0 ? 1 : startLine;
    }

    private void copyInfoToClipboard() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.title);
        sb.append("\n");
        sb.append(this.bug.getPriorityTypeString()).append(" ");
        sb.append("\n");
        Iterator<BugAnnotation> iterator = this.bug.annotationIterator();
        while (iterator.hasNext()) {
            BugAnnotation bugAnnotation = iterator.next();
            sb.append(bugAnnotation.toString()).append("\n");
        }
        if (this.file != null) {
            sb.append(this.file.getLocation()).append("\n");
        }
        Util.copyToClipboard(sb.toString());
    }
}

