/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.launch.core.refactoring.ConsoleConfigurationEntityResolverChange;
import org.hibernate.eclipse.launch.core.refactoring.ConsoleConfigurationNamingStrategyChange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HibernateRefactoringUtil {
    private static final String ERROR_MESS = HibernateConsoleMessages.HibernateRefactoringUtil_error_during_refactoring;
    private static String[] ccKeys = new String[]{"org.hibernate.eclipse.launch.CFG_XML_FILE", "org.hibernate.eclipse.launch.PROPERTY_FILE", "org.hibernate.tools.templatepath", "org.hibernate.tools.outputdir", "org.hibernate.tools.revEngFile"};
    private static String[] cgKeys = new String[]{"org.hibernate.tools.templatepath", "org.hibernate.tools.outputdir", "org.hibernate.tools.revEngFile"};
    private static String[] ccListKeys = new String[]{"org.hibernate.eclipse.launch.FILE_MAPPINGS"};

    public static boolean isConsoleConfigAffected(ILaunchConfiguration config, IPath oldPath) throws CoreException {
        return HibernateRefactoringUtil.isAttributesAffected(config, oldPath, ccKeys) || HibernateRefactoringUtil.isListAttributesAffected(config, oldPath, ccListKeys) || HibernateRefactoringUtil.isClassPathAffected(config, oldPath);
    }

    public static boolean isCodeGenerationConfigAffected(ILaunchConfiguration config, IPath oldPath) throws CoreException {
        return HibernateRefactoringUtil.isAttributesAffected(config, oldPath, cgKeys) || HibernateRefactoringUtil.isExportersAffected(config, oldPath);
    }

    public static boolean isCodeGenerationConfigAffected(ILaunchConfiguration config, String oldCCName) throws CoreException {
        return HibernateRefactoringUtil.isAttributesAffected(config, oldCCName, "org.hibernate.tools.configurationname");
    }

    private static boolean isAttributesAffected(ILaunchConfiguration config, IPath oldPath, String[] paths) throws CoreException {
        String attrib = null;
        int i = 0;
        while (i < paths.length) {
            attrib = config.getAttribute(paths[i], null);
            if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isAttributesAffected(ILaunchConfiguration config, String oldValue, String attribute) throws CoreException {
        String value = config.getAttribute(attribute, null);
        return value == null ? oldValue == null : value.equals(oldValue);
    }

    private static boolean isProjectAffected(IProject project, String oldCCName) throws CoreException {
        if (project.isOpen() && project.hasNature("org.hibernate.eclipse.console.hibernateNature")) {
            ProjectScope scope = new ProjectScope(project);
            IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
            String defaultConfiguration = node.get("default.configuration", "");
            return defaultConfiguration.equals(oldCCName);
        }
        return false;
    }

    private static boolean isListAttributesAffected(ILaunchConfiguration config, IPath oldPath, String[] listPaths) throws CoreException {
        int i = 0;
        while (i < listPaths.length) {
            List list = config.getAttribute(listPaths[i], Collections.EMPTY_LIST);
            ArrayList<String> newMappings = new ArrayList<String>();
            for (String attrib : list) {
                if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath)) {
                    return true;
                }
                newMappings.add(attrib);
            }
            ++i;
        }
        return false;
    }

    private static boolean isExportersAffected(ILaunchConfiguration config, IPath oldPath) throws CoreException {
        String[] k = new String[]{"outputdir"};
        List exporterNames = config.getAttribute("org.hibernate.tools.exporters", Collections.EMPTY_LIST);
        for (String exporterName : exporterNames) {
            Map props = config.getAttribute("org.hibernate.tools.exporters." + exporterName + ".properties", new HashMap());
            String[] stringArray = k;
            int n = k.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                if (HibernateRefactoringUtil.isAttributeChanged((String)props.get(attribute), oldPath)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean isClassPathAffected(ILaunchConfiguration config, IPath oldPath) throws CoreException {
        boolean useDefault = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            try {
                if (JavaRuntime.getJavaProject((ILaunchConfiguration)config) == null) {
                    return false;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
            return HibernateRefactoringUtil.isRuntimeClassPathEntriesAffected(entries, oldPath);
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
            return false;
        }
    }

    public static boolean isRuntimeClassPathEntriesAffected(IRuntimeClasspathEntry[] entries, IPath oldPath) {
        String attrib = null;
        String projName = null;
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            attrib = entry.getPath() == null ? null : entry.getPath().toString();
            String string = projName = entry.getJavaProject() == null ? null : entry.getJavaProject().getElementName();
            if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath) || HibernateRefactoringUtil.isAttributeChanged(projName, oldPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAttributeChanged(String attrib, IPath path) {
        if (attrib == null || path == null) {
            return false;
        }
        return path.isPrefixOf((IPath)new Path(attrib));
    }

    public static ILaunchConfiguration updateConsoleConfig(ILaunchConfiguration config, IPath oldPath, IPath newPath) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        HibernateRefactoringUtil.updateAttributes(oldPath, newPath, wc, ccKeys);
        HibernateRefactoringUtil.updateListAttributes(oldPath, newPath, wc, ccListKeys);
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
            List oldMementos = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, Collections.EMPTY_LIST);
            ArrayList<String> newMementos = new ArrayList<String>();
            boolean isChanged = HibernateRefactoringUtil.updateClasspathEntries(entries, oldMementos, newMementos, oldPath, newPath);
            if (isChanged) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, newMementos);
            }
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
        if (wc.isDirty()) {
            return wc.doSave();
        }
        return config;
    }

    public static ILaunchConfiguration updateCodeGenerationConfig(ILaunchConfiguration config, IPath oldPath, IPath newPath) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        HibernateRefactoringUtil.updateAttributes(oldPath, newPath, wc, cgKeys);
        HibernateRefactoringUtil.updateExporters(oldPath, newPath, wc);
        if (wc.isDirty()) {
            return wc.doSave();
        }
        return config;
    }

    private static void updateExporters(IPath oldPath, IPath newPath, ILaunchConfigurationWorkingCopy wc) throws CoreException {
        String[] keys = new String[]{"outputdir"};
        List exporterNames = wc.getAttribute("org.hibernate.tools.exporters", Collections.EMPTY_LIST);
        for (String exporterName : exporterNames) {
            String exporterProp = "org.hibernate.tools.exporters." + exporterName + ".properties";
            Map props = wc.getAttribute(exporterProp, new HashMap());
            boolean isChanged = false;
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String attrib = (String)props.get(key);
                if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath)) {
                    attrib = HibernateRefactoringUtil.getUpdatedPath(attrib, oldPath, newPath);
                    props.put(key, attrib);
                    isChanged = true;
                }
                ++n2;
            }
            if (!isChanged) continue;
            wc.setAttribute(exporterProp, props);
        }
    }

    public static boolean updateClasspathEntries(IRuntimeClasspathEntry[] entries, List<String> oldMementos, List<String> newMementos, IPath oldPath, IPath newPath) throws CoreException {
        Assert.isNotNull(newMementos);
        Assert.isNotNull((Object)(entries.length == oldMementos.size() ? 1 : 0));
        boolean isChanged = false;
        int i = 0;
        while (i < entries.length) {
            String memento;
            String projName;
            IRuntimeClasspathEntry entry = entries[i];
            String attrib = entry.getPath() == null ? null : entry.getPath().toString();
            String string = projName = entry.getJavaProject() == null ? null : entry.getJavaProject().getElementName();
            if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath)) {
                isChanged = true;
                memento = HibernateRefactoringUtil.getUpdatedMemento(oldMementos.get(i), (IPath)new Path(HibernateRefactoringUtil.getUpdatedPath(attrib, oldPath, newPath)), oldPath);
                newMementos.add(memento);
            } else if (HibernateRefactoringUtil.isAttributeChanged(projName, oldPath)) {
                isChanged = true;
                memento = HibernateRefactoringUtil.getUpdatedMemento(oldMementos.get(i), newPath, oldPath);
                newMementos.add(memento);
            } else {
                newMementos.add(entries[i].getMemento());
            }
            ++i;
        }
        return isChanged;
    }

    private static String getUpdatedMemento(String memento, IPath newPath, IPath oldPath) throws CoreException {
        String error_mess = HibernateConsoleMessages.HibernateRefactoringUtil_error_occured_while_updating_classpath;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(memento)));
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            NodeList nodeList = doc.getElementsByTagName("runtimeClasspathEntry");
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                NamedNodeMap map = node.getAttributes();
                Node changedNode = null;
                String[] attrNames = new String[]{"projectName", "externalArchive", "internalArchive", "containerPath", "javaProject"};
                int j = 0;
                while (j < attrNames.length) {
                    Path attrPath;
                    changedNode = map.getNamedItem(attrNames[j]);
                    if (changedNode != null && oldPath.isPrefixOf((IPath)(attrPath = new Path(changedNode.getNodeValue())))) {
                        if (attrNames[j].equals("projectName") || attrNames[j].equals("javaProject")) {
                            changedNode.setNodeValue(newPath.lastSegment());
                        } else {
                            changedNode.setNodeValue(newPath.toString());
                        }
                    }
                    ++j;
                }
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    NodeList mementoList = element.getElementsByTagName("memento");
                    int j2 = 0;
                    while (j2 < mementoList.getLength()) {
                        Path attrPath;
                        map = mementoList.item(j2).getAttributes();
                        changedNode = map.getNamedItem("project");
                        if (changedNode != null && oldPath.isPrefixOf((IPath)(attrPath = new Path(changedNode.getNodeValue())))) {
                            changedNode.setNodeValue(newPath.lastSegment());
                        }
                        ++j2;
                    }
                }
                ++i;
            }
            domSource = new DOMSource(doc);
            String newMemento = DebugPlugin.serializeDocument((Document)doc);
            return newMemento;
        }
        catch (ParserConfigurationException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (SAXException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (TransformerException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static void updateAttributes(IPath oldPath, IPath newPath, ILaunchConfigurationWorkingCopy wc, String[] pathKeys) throws CoreException {
        String attrib = null;
        int i = 0;
        while (i < pathKeys.length) {
            attrib = wc.getAttribute(pathKeys[i], null);
            if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath)) {
                attrib = HibernateRefactoringUtil.getUpdatedPath(attrib, oldPath, newPath);
                wc.setAttribute(pathKeys[i], attrib);
            }
            ++i;
        }
    }

    private static void updateListAttributes(IPath oldPath, IPath newPath, ILaunchConfigurationWorkingCopy wc, String[] pathListKeys) throws CoreException {
        String attrib2 = null;
        boolean isChanged = false;
        int i = 0;
        while (i < pathListKeys.length) {
            List list = wc.getAttribute(pathListKeys[i], Collections.EMPTY_LIST);
            isChanged = false;
            ArrayList<String> newMappings = new ArrayList<String>();
            for (String attrib2 : list) {
                if (HibernateRefactoringUtil.isAttributeChanged(attrib2, oldPath)) {
                    attrib2 = HibernateRefactoringUtil.getUpdatedPath(attrib2, oldPath, newPath);
                    isChanged = true;
                }
                newMappings.add(attrib2);
            }
            if (isChanged) {
                wc.setAttribute(pathListKeys[i], newMappings);
            }
            ++i;
        }
    }

    private static String getUpdatedPath(String attrib, IPath oldPath, IPath newPath) {
        Path attribPath = new Path(attrib);
        Path newAttribPath = new Path("/");
        int j = 0;
        while (j < attribPath.segmentCount()) {
            if (oldPath.isPrefixOf(attribPath.removeFirstSegments(j))) {
                newAttribPath = newAttribPath.append(newPath);
                newAttribPath = newAttribPath.append(attribPath.removeFirstSegments(j + oldPath.segmentCount()));
                break;
            }
            newAttribPath = newAttribPath.append(attribPath.segment(j));
            ++j;
        }
        return newAttribPath.toOSString();
    }

    public static ILaunchConfiguration[] getAffectedConsoleConfigs(IPath path) {
        ILaunchConfiguration[] configs = null;
        try {
            configs = LaunchHelper.findHibernateLaunchConfigs();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length && configs[i].exists()) {
                if (HibernateRefactoringUtil.isConsoleConfigAffected(configs[i], path)) {
                    list.add(configs[i]);
                }
                ++i;
            }
            configs = list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            configs = new ILaunchConfiguration[]{};
            HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
        }
        return configs;
    }

    public static ILaunchConfiguration[] getAffectedCodeGenerationConfigs(IPath path) {
        ILaunchConfiguration[] configs = null;
        try {
            configs = LaunchHelper.findCodeGenerationConfigs();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length && configs[i].exists()) {
                if (HibernateRefactoringUtil.isCodeGenerationConfigAffected(configs[i], path)) {
                    list.add(configs[i]);
                }
                ++i;
            }
            configs = list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            configs = new ILaunchConfiguration[]{};
            HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
        }
        return configs;
    }

    public static IProject[] getAffectedProjects(String oldConsoleConfigurationName) {
        ArrayList<IProject> affectedProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (HibernateRefactoringUtil.isProjectAffected(project, oldConsoleConfigurationName)) {
                    affectedProjects.add(project);
                }
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
            }
            ++n2;
        }
        return affectedProjects.toArray(new IProject[affectedProjects.size()]);
    }

    public static ILaunchConfiguration[] getAffectedCodeGenerationConfigs(String oldCCName) {
        ILaunchConfiguration[] configs = null;
        try {
            configs = LaunchHelper.findCodeGenerationConfigs();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length && configs[i].exists()) {
                if (HibernateRefactoringUtil.isCodeGenerationConfigAffected(configs[i], oldCCName)) {
                    list.add(configs[i]);
                }
                ++i;
            }
            configs = list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            configs = new ILaunchConfiguration[]{};
            HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
        }
        return configs;
    }

    public static ILaunchConfiguration[] getAffectedLaunchConfigurations(IProject project) {
        ILaunchConfiguration[] configs = null;
        try {
            configs = LaunchHelper.findHibernateLaunchConfigs();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length && configs[i].exists()) {
                String projectName = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (project.getName().equals(projectName)) {
                    list.add(configs[i]);
                }
                ++i;
            }
            configs = list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            configs = new ILaunchConfiguration[]{};
            HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
        }
        return configs;
    }

    public static ILaunchConfiguration[] getAffectedLaunchConfigurations(IConnectionProfile profile) {
        ILaunchConfiguration[] configs = null;
        try {
            configs = LaunchHelper.findHibernateLaunchConfigs();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length && configs[i].exists()) {
                if (profile.getName().equals(configs[i].getAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", ""))) {
                    list.add(configs[i]);
                }
                ++i;
            }
            configs = list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            configs = new ILaunchConfiguration[]{};
            HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
        }
        return configs;
    }

    public static Change createChangesFromList(List<Change> changes, String name) {
        if (changes.size() == 0) {
            return null;
        }
        if (changes.size() == 1) {
            return changes.get(0);
        }
        return new CompositeChange(name, changes.toArray(new Change[changes.size()]));
    }

    public static Change createChangesForTypeRename(IType type, String newName) {
        IType dtype = type.getDeclaringType();
        String newfqname = newName;
        if (dtype == null) {
            IPackageFragment packageFragment = type.getPackageFragment();
            if (!packageFragment.isDefaultPackage()) {
                newfqname = String.valueOf(packageFragment.getElementName()) + '.' + newName;
            }
        } else {
            newfqname = String.valueOf(dtype.getFullyQualifiedName()) + '$' + newName;
        }
        return HibernateRefactoringUtil.createChangesForTypeChange(type, newfqname);
    }

    public static Change createChangesForTypeMove(IType type, IJavaElement destination) {
        String newfqname = type.getElementName();
        if (destination instanceof IType) {
            newfqname = String.valueOf(((IType)destination).getFullyQualifiedName()) + '$' + type.getElementName();
        } else if (destination instanceof IPackageFragment && !((IPackageFragment)destination).isDefaultPackage()) {
            newfqname = String.valueOf(destination.getElementName()) + '.' + type.getElementName();
        }
        return HibernateRefactoringUtil.createChangesForTypeChange(type, newfqname);
    }

    protected static Change createChangesForTypeChange(IType type, String newfqname) {
        ArrayList<Change> changes = new ArrayList<Change>();
        String pname = type.getJavaProject().getElementName();
        String typename = type.getFullyQualifiedName();
        ILaunchConfiguration[] configs = null;
        try {
            configs = LaunchHelper.findHibernateLaunchConfigs();
            int i = 0;
            while (i < configs.length && configs[i].exists()) {
                String attrib = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (attrib != null && attrib.equals(pname)) {
                    String nsName = configs[i].getAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", null);
                    String ername = configs[i].getAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", null);
                    if (typename.equals(nsName)) {
                        changes.add(new ConsoleConfigurationNamingStrategyChange(configs[i], newfqname));
                    }
                    if (typename.equals(ername)) {
                        changes.add(new ConsoleConfigurationEntityResolverChange(configs[i], newfqname));
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            configs = new ILaunchConfiguration[]{};
            HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
        }
        return HibernateRefactoringUtil.createChangesFromList(changes, HibernateConsoleMessages.ConsoleConfigurationITypeRenameParticipant_update);
    }
}

