/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.EclipseLaunchConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class ConsoleConfigurationJavaClasspathTab
extends JavaClasspathTab {
    protected boolean configurationFileWillBeCreated = false;
    protected ILaunchConfiguration lastValidatedLaunchConfig = null;
    protected String lastErrorMessage = null;
    protected boolean lastRes = false;

    public boolean isShowBootpath() {
        return false;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean res;
        if (!super.isValid(launchConfig)) {
            return false;
        }
        if (this.lastValidatedLaunchConfig != null && this.lastValidatedLaunchConfig.contentsEqual(launchConfig)) {
            this.setErrorMessage(this.lastErrorMessage);
            return this.lastRes;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean resUserClasses = false;
        boolean resExistArchive = true;
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)launchConfig);
            int i = 0;
            while (i < entries.length) {
                IRuntimeClasspathEntry entry = entries[i];
                if (entry.getClasspathProperty() == 3) {
                    resUserClasses = true;
                    if (entry.getType() == 2 && !entry.getPath().toFile().exists()) {
                        resExistArchive = false;
                        String out = NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationTabGroup_archive_classpath_entry_does_not_exist, (Object)entry.getPath().toString());
                        this.setErrorMessage(out);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
        if (!resUserClasses) {
            this.setErrorMessage(HibernateConsoleMessages.ConsoleConfigurationTabGroup_classpath_must_be_set_or_restored_to_default);
        }
        if (resUserClasses && resExistArchive) {
            boolean flagTryToBuild = true;
            ConsoleConfiguration ccTest = new ConsoleConfiguration((ConsoleConfigurationPreferences)new EclipseLaunchConsoleConfigurationPreferences(launchConfig));
            if (this.configurationFileWillBeCreated) {
                try {
                    ccTest.getConfigXMLFile();
                }
                catch (HibernateConsoleRuntimeException hibernateConsoleRuntimeException) {
                    flagTryToBuild = false;
                }
            }
            if (flagTryToBuild) {
                block20: {
                    try {
                        ccTest.buildWith(null, false);
                    }
                    catch (Exception ex) {
                        resUserClasses = false;
                        this.setErrorMessage(ex.getMessage());
                    }
                    try {
                        ccTest.reset();
                    }
                    catch (Exception ex) {
                        if (!resUserClasses) break block20;
                        resUserClasses = false;
                        this.setErrorMessage(ex.getMessage());
                    }
                }
                try {
                    this.lastValidatedLaunchConfig = launchConfig.getWorkingCopy();
                }
                catch (CoreException coreException) {
                    this.lastValidatedLaunchConfig = null;
                }
            }
        }
        boolean bl = res = resUserClasses && resExistArchive;
        if (this.lastValidatedLaunchConfig != null) {
            this.lastErrorMessage = this.getErrorMessage();
            this.lastRes = res;
        }
        return res;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
    }

    public boolean canSave() {
        return super.canSave();
    }

    public void markConfigurationFileWillBeCreated() {
        this.configurationFileWillBeCreated = true;
    }
}

