/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ComboContribution
extends ControlContribution {
    protected Combo comboControl;

    protected ComboContribution(String id) {
        super(id);
    }

    String getText() {
        if (this.comboControl.isDisposed()) {
            return "";
        }
        return this.comboControl.getText();
    }

    protected Control createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        panel.setLayout((Layout)gridLayout);
        if (this.getLabelText() != null) {
            Label label = new Label(panel, 0);
            label.setText(this.getLabelText());
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 3;
        }
        this.comboControl = new Combo(panel, 4 | (this.isReadOnly() ? 8 : 0));
        this.populateComboBox();
        this.comboControl.pack();
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.getComboWidth();
        this.comboControl.setLayoutData((Object)gd);
        if (this.getSelectionAdapter() != null) {
            this.comboControl.addSelectionListener(this.getSelectionAdapter());
        }
        panel.pack();
        return panel;
    }

    protected int getComboWidth() {
        return 100;
    }

    protected int computeWidth(Control control) {
        return super.computeWidth(control);
    }

    protected boolean isReadOnly() {
        return true;
    }

    String getLabelText() {
        return null;
    }

    protected abstract SelectionListener getSelectionAdapter();

    abstract void populateComboBox();

    public void dispose() {
        if (this.getSelectionAdapter() != null && !this.comboControl.isDisposed()) {
            this.comboControl.removeSelectionListener(this.getSelectionAdapter());
        }
    }
}

