/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ViolationOutlineLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String KEY_IMAGE_ERR1 = "error1";
    private static final String KEY_IMAGE_ERR2 = "error2";
    private static final String KEY_IMAGE_ERR3 = "error3";
    private static final String KEY_IMAGE_ERR4 = "error4";
    private static final String KEY_IMAGE_ERR5 = "error5";

    public Image getColumnImage(Object object, int n) {
        IMarker iMarker = null;
        if (!(object instanceof IMarker)) {
            return null;
        }
        iMarker = (IMarker)object;
        if (n == 0) {
            Integer n2 = new Integer(0);
            try {
                n2 = (Integer)iMarker.getAttribute("pmd_priority");
            }
            catch (CoreException coreException) {
                PMDPlugin.getDefault().logError("message.error.core_exception" + ((Object)((Object)this)).toString(), coreException);
            }
            switch (n2) {
                case 1: {
                    return this.getImage(KEY_IMAGE_ERR1, "icons/lab_err1.gif");
                }
                case 2: {
                    return this.getImage(KEY_IMAGE_ERR2, "icons/lab_err2.gif");
                }
                case 3: {
                    return this.getImage(KEY_IMAGE_ERR3, "icons/lab_err3.gif");
                }
                case 4: {
                    return this.getImage(KEY_IMAGE_ERR4, "icons/lab_err4.gif");
                }
                case 5: {
                    return this.getImage(KEY_IMAGE_ERR5, "icons/lab_err5.gif");
                }
            }
        }
        return null;
    }

    public String getColumnText(Object object, int n) {
        IMarker iMarker = null;
        if (!(object instanceof IMarker)) {
            return null;
        }
        iMarker = (IMarker)object;
        switch (n) {
            case 1: {
                return iMarker.getAttribute("message", "rulename");
            }
            case 2: {
                return String.valueOf(iMarker.getAttribute("lineNumber", 0));
            }
        }
        return "";
    }

    private Image getImage(String string, String string2) {
        return PMDPlugin.getDefault().getImage(string, string2);
    }
}

