/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.preferences.PMDPreferencePage;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class RuleCellModifier
implements ICellModifier {
    private TableViewer tableViewer;

    public RuleCellModifier(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public boolean canModify(Object object, String string) {
        return string.equalsIgnoreCase("priority") || string.equalsIgnoreCase("description");
    }

    public Object getValue(Object object, String string) {
        Object object2 = null;
        if (object instanceof Rule) {
            Rule rule = (Rule)object;
            if (string.equalsIgnoreCase("ruleSetname")) {
                object2 = rule.getRuleSetName();
            } else if (string.equalsIgnoreCase("ruleName")) {
                object2 = rule.getName();
            } else if (string.equalsIgnoreCase("priority")) {
                object2 = new Integer(rule.getPriority() - 1);
            } else if (string.equalsIgnoreCase("description")) {
                object2 = rule.getDescription();
            }
        }
        return object2;
    }

    public void modify(Object object, String string, Object object2) {
        TableItem tableItem = (TableItem)object;
        try {
            if (tableItem.getData() instanceof Rule) {
                Rule rule = (Rule)tableItem.getData();
                if (string.equalsIgnoreCase("priority")) {
                    rule.setPriority((Integer)object2 + 1);
                    PMDPreferencePage.getActiveInstance().setModified(true);
                    this.tableViewer.refresh();
                } else if (string.equalsIgnoreCase("description")) {
                    rule.setDescription((String)object2);
                    PMDPreferencePage.getActiveInstance().setModified(true);
                    this.tableViewer.refresh();
                }
            }
        }
        catch (Throwable throwable) {
            PMDPlugin.getDefault().logError("Exception when notifying a modification in a cell of the rule table in the preference page", throwable);
        }
    }
}

