/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;

public abstract class AbstractPMDRecord {
    public static final int TYPE_ROOT = 8;
    public static final int TYPE_PROJECT = 4;
    public static final int TYPE_PACKAGE = 2;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_MARKER = 16;
    public static final AbstractPMDRecord[] EMPTY_RECORDS = new AbstractPMDRecord[0];

    public abstract String getName();

    public abstract AbstractPMDRecord getParent();

    public abstract AbstractPMDRecord[] getChildren();

    public List getChildrenAsList() {
        return new ArrayList<AbstractPMDRecord>(Arrays.asList(this.getChildren()));
    }

    public abstract IResource getResource();

    public abstract int getResourceType();

    public abstract AbstractPMDRecord addResource(IResource var1);

    public abstract AbstractPMDRecord removeResource(IResource var1);

    public abstract int getNumberOfViolationsToPriority(int var1, boolean var2);

    public abstract int getLOC();

    public abstract int getNumberOfMethods();

    protected abstract AbstractPMDRecord[] createChildren();

    public boolean hasMarkers() {
        AbstractPMDRecord[] abstractPMDRecordArray = this.getChildren();
        boolean bl = false;
        int n = 0;
        while (n < abstractPMDRecordArray.length && !bl) {
            if (abstractPMDRecordArray[n].hasMarkers()) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public IMarker[] findMarkers() {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        AbstractPMDRecord[] abstractPMDRecordArray = this.getChildren();
        int n = 0;
        while (n < abstractPMDRecordArray.length) {
            IMarker[] iMarkerArray;
            if (abstractPMDRecordArray[n].hasMarkers() && (iMarkerArray = abstractPMDRecordArray[n].findMarkers()) != null) {
                arrayList.addAll(Arrays.asList(iMarkerArray));
            }
            ++n;
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new IMarker[arrayList.size()]);
    }

    public IMarker[] findMarkersByAttribute(String string, Object object) {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        AbstractPMDRecord[] abstractPMDRecordArray = this.getChildren();
        int n = 0;
        while (n < abstractPMDRecordArray.length) {
            IMarker[] iMarkerArray = abstractPMDRecordArray[n].findMarkersByAttribute(string, object);
            arrayList.addAll(Arrays.asList(iMarkerArray));
            ++n;
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    public AbstractPMDRecord findResource(IResource iResource) {
        AbstractPMDRecord abstractPMDRecord = null;
        List list = this.getChildrenAsList();
        int n = 0;
        while (n < list.size() && abstractPMDRecord == null) {
            AbstractPMDRecord abstractPMDRecord2;
            AbstractPMDRecord abstractPMDRecord3 = (AbstractPMDRecord)list.get(n);
            if (abstractPMDRecord3.getResource().equals((Object)iResource)) {
                abstractPMDRecord = abstractPMDRecord3;
            } else if (abstractPMDRecord3.getResourceType() != iResource.getType() && (abstractPMDRecord2 = abstractPMDRecord3.findResource(iResource)) != null) {
                abstractPMDRecord = abstractPMDRecord2;
            }
            ++n;
        }
        return abstractPMDRecord;
    }

    public AbstractPMDRecord findResourceByName(String string, int n) {
        AbstractPMDRecord abstractPMDRecord = null;
        List list = this.getChildrenAsList();
        int n2 = 0;
        while (n2 < list.size() && abstractPMDRecord == null) {
            AbstractPMDRecord abstractPMDRecord2 = (AbstractPMDRecord)list.get(n2);
            if (abstractPMDRecord2.getResourceType() == n && abstractPMDRecord2.getName().equalsIgnoreCase(string)) {
                abstractPMDRecord = abstractPMDRecord2;
            } else {
                AbstractPMDRecord abstractPMDRecord3 = abstractPMDRecord2.findResourceByName(string, n);
                if (abstractPMDRecord3 != null) {
                    abstractPMDRecord = abstractPMDRecord3;
                }
            }
            ++n2;
        }
        return abstractPMDRecord;
    }

    public List findResourcesByName(String string, int n) {
        ArrayList<AbstractPMDRecord> arrayList = new ArrayList<AbstractPMDRecord>();
        List list = this.getChildrenAsList();
        int n2 = 0;
        while (n2 < list.size()) {
            AbstractPMDRecord abstractPMDRecord = (AbstractPMDRecord)list.get(n2);
            if (abstractPMDRecord.getResourceType() == n && abstractPMDRecord.getName().equalsIgnoreCase(string)) {
                arrayList.add(abstractPMDRecord);
            } else {
                List list2 = abstractPMDRecord.findResourcesByName(string, n);
                arrayList.addAll(list2);
            }
            ++n2;
        }
        return arrayList;
    }
}

