/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.handlers;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class OpenJavaEditorHandler
extends AbstractHandler {
    @Override
    public boolean isEnabled(XModelObject object) {
        return true;
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        IProject project = EclipseResourceUtil.getProject(object);
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            String className = String.valueOf(EclipseResourceUtil.getJavaClassQualifiedName(object).replace('.', '/')) + "." + object.getAttributeValue("extension");
            IJavaElement javaElement = javaProject.findElement((IPath)new Path(className));
            if (javaElement != null) {
                JavaUI.openInEditor((IJavaElement)javaElement);
            } else {
                IFile f = (IFile)EclipseResourceUtil.getResource(object);
                if (f != null) {
                    IDE.openEditor((IWorkbenchPage)this.getWorkbenchPage(), (IFile)f);
                }
            }
        }
        catch (CoreException e) {
            throw new XModelException(e);
        }
    }

    private IWorkbenchPage getWorkbenchPage() {
        ModelPlugin plugin = ModelPlugin.getDefault();
        IWorkbench workbench = plugin == null ? null : plugin.getWorkbench();
        IWorkbenchWindow window = workbench == null ? null : workbench.getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }
}

