/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import java.util.Properties;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionHandler;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.meta.action.impl.XActionListImpl;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;

public class AbstractHandler
implements XActionHandler {
    protected XAction action;
    protected XEntityData[] data;

    public final void setAction(XAction action) {
        this.action = action;
    }

    @Override
    public XEntityData[] getEntityData(XModelObject object) {
        this.setDefaultData(object);
        return this.data;
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
    }

    @Override
    public boolean getSignificantFlag(XModelObject object) {
        return false;
    }

    @Override
    public boolean isEnabled(XModelObject object) {
        return false;
    }

    @Override
    public boolean hide(boolean enabled) {
        return ((XActionImpl)this.action).hide0(enabled);
    }

    @Override
    public void setDefaultData(XModelObject object) {
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        int i = 0;
        while (i < this.data.length) {
            ((XEntityDataImpl)this.data[i]).setDefaultValues();
            ++i;
        }
    }

    public void setData(XEntityData[] data) {
        this.data = data;
    }

    protected void checkEnvironment(Object environment) {
    }

    @Override
    public boolean isEnabled(XModelObject object, XModelObject[] objects) {
        if (object == null || objects == null || objects.length < 2) {
            return this.isEnabled(object);
        }
        if (this.action.getWizardClassName() != null && this.action.getWizardClassName().length() > 0) {
            return false;
        }
        XModelObject p = object.getParent();
        XModelEntity entity = object.getModelEntity();
        int i = 0;
        while (i < objects.length) {
            if (!(p == objects[i].getParent() || object.getFileType() == objects[i].getFileType() && object.getFileType() == 1 || this.ignoreDifferentParents(objects[i].getModelEntity().getName(), entity.getName()))) {
                return false;
            }
            ++i;
        }
        String path = this.action.getPath();
        int i2 = 0;
        while (i2 < objects.length) {
            XModelEntity ent = objects[i2].getModelEntity();
            if (ent == entity && !this.action.isEnabled(objects[i2])) {
                return false;
            }
            XAction a = (XAction)((XActionListImpl)ent.getActionList()).getByPath(path);
            if (a == null || this.action.getWizardClassName() != null && a.getWizardClassName().length() > 0 || !a.isEnabled(objects[i2])) {
                return false;
            }
            ++i2;
        }
        return this.action.isEnabled(object);
    }

    protected boolean ignoreDifferentParents(String entity1, String entity2) {
        return entity1.equals(entity2);
    }

    @Override
    public void executeHandler(XModelObject object, XModelObject[] objects, Properties p) throws XModelException {
        if (!this.isEnabled(object, objects)) {
            return;
        }
        if (object == null || objects == null || objects.length < 2) {
            this.executeHandler(object, p);
            return;
        }
        String path = this.action.getPath();
        XModelEntity entity = object.getModelEntity();
        int i = 0;
        while (i < objects.length) {
            XModelEntity ent = objects[i].getModelEntity();
            if (ent == entity) {
                this.executeHandler(objects[i], p);
            } else {
                XAction a = (XAction)((XActionListImpl)ent.getActionList()).getByPath(path);
                if (a != null && a.isEnabled(objects[i])) {
                    this.mergeEntityData(this.data, a.getEntityData(objects[i]));
                    a.executeHandler(objects[i], p);
                }
            }
            ++i;
        }
    }

    protected void mergeEntityData(XEntityData[] source, XEntityData[] target) {
        int ic = source.length;
        if (target.length < ic) {
            ic = target.length;
        }
        int i = 0;
        while (i < ic) {
            XAttributeData[] ds = source[i].getAttributeData();
            XAttributeData[] dt = target[i].getAttributeData();
            this.mergeAttributeData(ds, dt);
            ++i;
        }
    }

    protected void mergeAttributeData(XAttributeData[] source, XAttributeData[] target) {
        int ic = source.length;
        if (target.length < ic) {
            ic = target.length;
        }
        int i = 0;
        while (i < ic) {
            target[i].setValue(source[i].getValue());
            ++i;
        }
    }

    protected final void setWizardClassName(String wizard) {
        ((XActionImpl)this.action).setWizardClassName(wizard);
    }

    public final void executeInTransaction(XModelObject object, Properties p, String transactionName, int transactionKind) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        XUndoManager undo = object.getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(transactionName, transactionKind);
        undo.addUndoable(u);
        try {
            try {
                this.transaction(object, p);
            }
            catch (XModelException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    protected void transaction(XModelObject object, Properties p) throws XModelException {
    }
}

