/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.command;

import org.eclipse.gef.commands.Command;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramGuide;

public class ChangeGuideCommand
extends Command {
    private OrmShape part;
    private DiagramGuide oldGuide;
    private DiagramGuide newGuide;
    private int oldAlign;
    private int newAlign;
    private boolean horizontal;

    public ChangeGuideCommand(OrmShape part, boolean horizontalGuide) {
        this.part = part;
        this.horizontal = horizontalGuide;
    }

    protected void changeGuide(DiagramGuide oldGuide, DiagramGuide newGuide, int newAlignment) {
        if (oldGuide != null && oldGuide != newGuide) {
            oldGuide.detachPart(this.part);
        }
        if (newGuide != null) {
            newGuide.attachPart(this.part, newAlignment);
        }
    }

    public void execute() {
        DiagramGuide diagramGuide = this.oldGuide = this.horizontal ? this.part.getHorizontalGuide() : this.part.getVerticalGuide();
        if (this.oldGuide != null) {
            this.oldAlign = this.oldGuide.getAlignment(this.part);
        }
        this.redo();
    }

    public void redo() {
        this.changeGuide(this.oldGuide, this.newGuide, this.newAlign);
    }

    public void setNewGuide(DiagramGuide guide, int alignment) {
        this.newGuide = guide;
        this.newAlign = alignment;
    }

    public void undo() {
        this.changeGuide(this.newGuide, this.oldGuide, this.oldAlign);
    }
}

