/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.jst.jsp.editor.ITextFormatter;
import org.jboss.tools.jst.jsp.selection.SourceSelection;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeAnyCreator;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCommentCreator;
import org.jboss.tools.vpe.editor.template.VpeCopyCreator;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDataTableColumnCreator;
import org.jboss.tools.vpe.editor.template.VpeDataTableCreator;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeElementCreator;
import org.jboss.tools.vpe.editor.template.VpeFacetCreator;
import org.jboss.tools.vpe.editor.template.VpeGridCreator;
import org.jboss.tools.vpe.editor.template.VpeHtmlCreator;
import org.jboss.tools.vpe.editor.template.VpeJspRootCreator;
import org.jboss.tools.vpe.editor.template.VpeLabeledFormCreator;
import org.jboss.tools.vpe.editor.template.VpeLinkCreator;
import org.jboss.tools.vpe.editor.template.VpeListCreator;
import org.jboss.tools.vpe.editor.template.VpeLoadBundleCreator;
import org.jboss.tools.vpe.editor.template.VpeOutputAttributes;
import org.jboss.tools.vpe.editor.template.VpePanelGridCreator;
import org.jboss.tools.vpe.editor.template.VpePanelLayoutCreator;
import org.jboss.tools.vpe.editor.template.VpeStyleCreator;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.VpeVisualLinkCreator;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeHtmlTemplate
extends VpeAbstractTemplate {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_HTML = 1;
    public static final int TYPE_COPY = 2;
    public static final int TYPE_GRID = 3;
    public static final int TYPE_ANY = 4;
    public static final int TYPE_TAGLIB = 5;
    public static final int TYPE_LOAD_BUNDLE = 6;
    public static final int TYPE_DATATABLE = 7;
    public static final int TYPE_DATATABLE_COLUMN = 8;
    public static final int TYPE_COMMENT = 9;
    public static final int TYPE_STYLE = 10;
    public static final int TYPE_LINK = 11;
    public static final int TYPE_LIST = 12;
    public static final int TYPE_JSPROOT = 13;
    public static final int TYPE_LABELED_FORM = 13;
    public static final int TYPE_PANELGRID = 14;
    public static final int TYPE_FACET = 15;
    public static final int TYPE_INCLUDE = 16;
    public static final int PANEL_LAYOUT = 17;
    public static final int TYPE_A = 18;
    static final String ATTR_STYLE = "style";
    public static final String ATTR_STYLE_MODIFY_NAME = "-moz-user-modify";
    public static final String ATTR_STYLE_MODIFY_READ_WRITE_VALUE = "read-write";
    public static final String ATTR_STYLE_MODIFY_READ_ONLY_VALUE = "read-only";
    static final String ATTR_CURSOR_POINTER = "cursor:pointer;";
    private int type = 0;
    private VpeCreator creator = null;
    private VpeDependencyMap dependencyMap;
    private boolean dependencyFromBundle;
    private static final String VIEW_TAGNAME = "view";
    private static final String LOCALE_ATTRNAME = "locale";
    private static final String PREFIX_SEPARATOR = ":";

    @Override
    protected void init(Element templateElement) {
        this.dependencyMap = new VpeDependencyMap(this.caseSensitive);
        super.init(templateElement);
        this.dependencyMap.validate();
        this.dependencyFromBundle = this.dependencyMap.contains("jsfvalue()");
    }

    @Override
    protected void initTemplateSection(Element templateSection) {
        if (this.creator == null) {
            String name = templateSection.getNodeName();
            if (name.startsWith("vpe:")) {
                if ("vpe:copy".equals(name)) {
                    this.type = 2;
                    this.creator = new VpeCopyCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:element".equals(name)) {
                    this.type = 1;
                    this.creator = new VpeElementCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:datatable".equals(name)) {
                    this.type = 7;
                    this.creator = new VpeDataTableCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:a".equals(name)) {
                    this.type = 18;
                    this.creator = new VpeVisualLinkCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:column".equals(name)) {
                    this.type = 8;
                    this.creator = new VpeDataTableColumnCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:facet".equals(name)) {
                    this.type = 15;
                    this.creator = new VpeFacetCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:list".equals(name)) {
                    this.type = 12;
                    this.creator = new VpeListCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:labeledForm".equals(name)) {
                    this.type = 13;
                    this.creator = new VpeLabeledFormCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:grid".equals(name)) {
                    this.type = 3;
                    this.creator = new VpeGridCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:panelgrid".equals(name)) {
                    this.type = 14;
                    this.creator = new VpePanelGridCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:any".equals(name)) {
                    this.type = 4;
                    this.creator = new VpeAnyCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:link".equals(name)) {
                    this.type = 11;
                    this.creator = new VpeLinkCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:load-bundle".equals(name)) {
                    this.type = 6;
                    this.creator = new VpeLoadBundleCreator(templateSection, this.dependencyMap);
                } else if ("vpe:comment".equals(name)) {
                    this.type = 9;
                    this.creator = new VpeCommentCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:style".equals(name)) {
                    this.type = 10;
                    this.creator = new VpeStyleCreator(templateSection, this.dependencyMap, this.caseSensitive);
                } else if ("vpe:jsproot".equals(name)) {
                    this.type = 13;
                    this.creator = new VpeJspRootCreator(templateSection, this.dependencyMap);
                } else if ("vpe:panellayout".equals(name)) {
                    this.type = 17;
                    this.creator = new VpePanelLayoutCreator(templateSection, this.dependencyMap, this.caseSensitive);
                }
            } else {
                this.type = 1;
                this.creator = new VpeHtmlCreator(templateSection, this.dependencyMap, this.caseSensitive);
            }
        }
    }

    @Override
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        List<VpeChildrenInfo> childrenInfoList;
        HashMap<VpeTemplate, ModifyInfo> visualNodeMap = new HashMap<VpeTemplate, ModifyInfo>();
        VpeCreatorInfo creatorInfo = null;
        if (sourceNode instanceof Element) {
            creatorInfo = this.createVisualElement(pageContext, (Element)sourceNode, visualDocument, null, visualNodeMap);
        }
        nsIDOMElement newVisualElement = null;
        if (creatorInfo != null) {
            newVisualElement = (nsIDOMElement)creatorInfo.getVisualNode();
        }
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)newVisualElement);
        if (creatorInfo != null && (childrenInfoList = creatorInfo.getChildrenInfoList()) != null) {
            int i = 0;
            while (i < childrenInfoList.size()) {
                creationData.addChildrenInfo(childrenInfoList.get(i));
                ++i;
            }
        }
        creationData.setData(visualNodeMap);
        return creationData;
    }

    @Override
    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData creationdata) {
        if (sourceNode instanceof Element) {
            this.validateVisualElement(pageContext, (Element)sourceNode, visualDocument, null, creationdata.getNode() == null ? null : (nsIDOMElement)XPCOM.queryInterface((nsISupports)creationdata.getNode(), nsIDOMElement.class), (Map)creationdata.getData());
        }
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        this.setAttribute(pageContext, sourceElement, (Map)data, name, value);
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name) {
        this.removeAttribute(pageContext, sourceElement, (Map)data, name);
    }

    @Override
    public void beforeRemove(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        if (sourceNode instanceof Element) {
            this.removeElement(pageContext, (Element)sourceNode, (Map)data);
        }
    }

    @Override
    public boolean hasChildren() {
        return this.children;
    }

    private VpeCreatorInfo createVisualElement(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualParent, Map<VpeTemplate, ModifyInfo> visualNodeMap) {
        nsIDOMElement visualElement;
        if (this.creator == null) {
            return null;
        }
        VpeCreatorInfo elementInfo = null;
        try {
            elementInfo = this.creator.create(pageContext, sourceElement, visualDocument, visualParent, visualNodeMap);
        }
        catch (VpeExpressionException ex) {
            VpeExpressionException exception = new VpeExpressionException("Exception on processing node " + sourceElement.toString(), ex);
            VpePlugin.reportProblem(exception);
        }
        if (elementInfo != null && (visualElement = (nsIDOMElement)elementInfo.getVisualNode()) != null) {
            boolean curModify = this.getCurrentModify(pageContext, sourceElement, visualNodeMap);
            VpeHtmlTemplate.makeModify(visualElement, curModify);
            if (!"input".equalsIgnoreCase(visualElement.getNodeName()) && this.dependencyFromBundle && !curModify) {
                String style = visualElement.getAttribute(ATTR_STYLE);
                visualElement.setAttribute(ATTR_STYLE, String.valueOf(style) + ATTR_CURSOR_POINTER);
            }
            visualNodeMap.put(this, new ModifyInfo(visualElement, curModify));
        }
        return elementInfo;
    }

    private void validateVisualElement(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualParent, nsIDOMElement visualElement, Map<VpeTemplate, ModifyInfo> visualNodeMap) {
        if (this.creator != null) {
            this.creator.validate(pageContext, sourceElement, visualDocument, visualParent, visualElement, visualNodeMap);
        }
    }

    @Override
    public boolean nonctrlKeyPressHandler(VpePageContext pageContext, Document sourceDocument, Node sourceNode, nsIDOMNode visualNode, Object data, long charCode, SourceSelection selection, ITextFormatter formatter) {
        if (this.creator != null) {
            boolean done = this.creator.nonctrlKeyPressHandler(pageContext, sourceDocument, sourceNode, data, charCode, selection, formatter);
            if (done) {
                return true;
            }
            return super.nonctrlKeyPressHandler(pageContext, sourceDocument, sourceNode, visualNode, data, charCode, selection, formatter);
        }
        return true;
    }

    @Override
    public void refreshBundleValues(VpePageContext pageContext, Element sourceElement, Object data) {
        this.refreshBundleValues(pageContext, sourceElement, (Map)data);
    }

    private void refreshBundleValues(VpePageContext pageContext, Element sourceElement, Map<VpeTemplate, ModifyInfo> visualNodeMap) {
        if (this.dependencyFromBundle) {
            VpeCreator[] creators = this.dependencyMap.getCreators("jsfvalue()");
            int i = 0;
            while (i < creators.length) {
                creators[i].refreshElement(pageContext, sourceElement, visualNodeMap);
                ++i;
            }
            this.changeModify(pageContext, sourceElement, visualNodeMap);
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public VpeAnyData getAnyData() {
        VpeAnyData data = null;
        if (this.getType() == 4 && this.creator != null) {
            data = ((VpeAnyCreator)this.creator).getAnyData();
            data.setCaseSensitive(this.caseSensitive);
            data.setChildren(this.children);
            data.setModify(this.modify);
        }
        return data;
    }

    public boolean isDependencyFromBundle() {
        return this.dependencyFromBundle;
    }

    private String getPageLocale(VpePageContext pageContext, IDOMElement sourceElement) {
        List<TaglibData> taglibs = pageContext.getTagLibs((Node)sourceElement);
        TaglibData fTD = null;
        int i = 0;
        while (i < taglibs.size()) {
            TaglibData td = taglibs.get(i);
            if ("http://java.sun.com/jsf/core".equals(td.getUri())) {
                fTD = td;
            }
            ++i;
        }
        if (fTD == null || fTD.getPrefix() == null || fTD.getPrefix().length() == 0) {
            return null;
        }
        String nodeToFind = String.valueOf(fTD.getPrefix()) + PREFIX_SEPARATOR + VIEW_TAGNAME;
        IDOMElement el = sourceElement;
        IDOMElement jsfCoreViewTag = null;
        while (el != null) {
            if (nodeToFind.equals(el.getNodeName())) {
                jsfCoreViewTag = el;
                break;
            }
            Node parent = el.getParentNode();
            if (!(parent instanceof IDOMElement)) break;
            el = (IDOMElement)parent;
        }
        if (jsfCoreViewTag == null || !jsfCoreViewTag.hasAttribute(LOCALE_ATTRNAME)) {
            return null;
        }
        String locale = jsfCoreViewTag.getAttribute(LOCALE_ATTRNAME);
        if (locale == null || locale.length() == 0) {
            return null;
        }
        return locale;
    }

    @Override
    public void setSourceAttributeValue(VpePageContext pageContext, Element sourceElement, Object data) {
        this.setSourceAttributeValue(pageContext, sourceElement, (Map)data);
    }

    private void setSourceAttributeValue(VpePageContext pageContext, Element sourceElement, Map<?, ?> visualNodeMap) {
        VpeCreator[] creators = this.dependencyMap.getCreators(":vpe:value");
        int i = 0;
        while (i < creators.length) {
            if (creators[i] instanceof VpeOutputAttributes) {
                ((VpeOutputAttributes)((Object)creators[i])).setOutputAttributeValue(pageContext, sourceElement, visualNodeMap);
            }
            ++i;
        }
        this.changeModify(pageContext, sourceElement, visualNodeMap);
    }

    @Override
    public String[] getOutputAttributeNames() {
        VpeCreator[] creators = this.dependencyMap.getCreators(":vpe:value");
        int i = 0;
        while (i < creators.length) {
            if (creators[i] instanceof VpeOutputAttributes) {
                return ((VpeOutputAttributes)((Object)creators[i])).getOutputAttributes();
            }
            ++i;
        }
        return EMPTY_ARRAY;
    }

    @Override
    public nsIDOMText getOutputTextNode(VpePageContext pageContext, Element sourceElement, Object data) {
        VpeCreator[] creators = this.dependencyMap.getCreators(":vpe:value");
        int i = 0;
        while (i < creators.length) {
            if (creators[i] instanceof VpeOutputAttributes) {
                return ((VpeOutputAttributes)((Object)creators[i])).getOutputTextNode(pageContext, sourceElement, (Map)data);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setSourceAttributeSelection(VpePageContext pageContext, Element sourceElement, int offset, int length, Object data) {
        this.setSourceAttributeSelection(pageContext, sourceElement, offset, length, (Map)data);
    }

    private void setSourceAttributeSelection(VpePageContext pageContext, Element sourceElement, int offset, int length, Map visualNodeMap) {
        VpeCreator[] creators = this.dependencyMap.getCreators(":vpe:value");
        boolean setFlag = false;
        int i = 0;
        while (i < creators.length) {
            if (creators[i] instanceof VpeOutputAttributes) {
                ((VpeOutputAttributes)((Object)creators[i])).setOutputAttributeSelection(pageContext, sourceElement, offset, length, visualNodeMap);
                setFlag = true;
            }
            ++i;
        }
        if (!setFlag) {
            VpeSourceDomBuilder sourceBuilder = pageContext.getSourceBuilder();
            sourceBuilder.setSelection(sourceElement, 0, 0);
        }
        this.changeModify(pageContext, sourceElement, visualNodeMap);
    }

    static void makeModify(nsIDOMElement visualElement, boolean modify) {
        String s = "-moz-user-modify:" + (modify ? ATTR_STYLE_MODIFY_READ_WRITE_VALUE : ATTR_STYLE_MODIFY_READ_ONLY_VALUE);
        String style = visualElement.getAttribute(ATTR_STYLE);
        if (style != null && style.length() > 0) {
            if (style.indexOf(ATTR_STYLE_MODIFY_NAME) >= 0) {
                String[] items = style.split(";");
                style = "";
                int i = 0;
                while (i < items.length) {
                    String[] item = items[i].split(PREFIX_SEPARATOR);
                    if (ATTR_STYLE_MODIFY_NAME.trim().equalsIgnoreCase(item[0].trim())) {
                        item[1] = modify ? ATTR_STYLE_MODIFY_READ_WRITE_VALUE : ATTR_STYLE_MODIFY_READ_ONLY_VALUE;
                    }
                    style = String.valueOf(style) + item[0] + PREFIX_SEPARATOR + item[1] + ";";
                    ++i;
                }
            } else {
                if (!";".equals(style.substring(style.length() - 1))) {
                    style = String.valueOf(style) + ";";
                }
                style = String.valueOf(style) + s;
            }
        } else {
            style = s;
        }
        visualElement.setAttribute(ATTR_STYLE, style);
    }

    private boolean getCurrentModify(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        if (!this.modify || !this.dependencyFromBundle) {
            return this.modify;
        }
        VpeCreator[] creators = this.dependencyMap.getCreators(":vpe:value");
        int i = 0;
        while (i < creators.length) {
            boolean currModify;
            if (creators[i] instanceof VpeOutputAttributes && !(currModify = ((VpeOutputAttributes)((Object)creators[i])).isEditabledAtribute(pageContext, sourceElement, visualNodeMap))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void changeModify(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        boolean curModify;
        ModifyInfo info;
        if (this.modify && this.dependencyFromBundle && (info = (ModifyInfo)visualNodeMap.get(this)) != null && (curModify = this.getCurrentModify(pageContext, sourceElement, visualNodeMap)) != info.modify) {
            info.modify = curModify;
            VpeHtmlTemplate.makeModify(info.visualElement, curModify);
        }
    }

    @Override
    public boolean isOutputAttributes() {
        VpeCreator[] creators = this.dependencyMap.getCreators(":vpe:value");
        int i = 0;
        while (i < creators.length) {
            if (creators[i] instanceof VpeOutputAttributes) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeElement(VpePageContext pageContext, Element sourceElement, Map<VpeTemplate, ?> visualNodeMap) {
        if (this.creator != null) {
            this.creator.removeElement(pageContext, sourceElement, visualNodeMap);
        }
    }

    private void setAttribute(VpePageContext pageContext, Element sourceElement, Map<VpeTemplate, ?> visualNodeMap, String name, String value) {
        if (this.creator != null) {
            this.setAttribute(this.dependencyMap.getCreators("@*"), pageContext, sourceElement, visualNodeMap, name, value);
            this.setAttribute(this.dependencyMap.getCreators(VpeExpressionBuilder.attrSignature(name, this.caseSensitive)), pageContext, sourceElement, visualNodeMap, name, value);
            this.changeModify(pageContext, sourceElement, visualNodeMap);
        }
    }

    private void removeAttribute(VpePageContext pageContext, Element sourceElement, Map<VpeTemplate, ?> visualNodeMap, String name) {
        if (this.creator != null) {
            this.removeAttribute(this.dependencyMap.getCreators("@*"), pageContext, sourceElement, visualNodeMap, name);
            this.removeAttribute(this.dependencyMap.getCreators(VpeExpressionBuilder.attrSignature(name, this.caseSensitive)), pageContext, sourceElement, visualNodeMap, name);
            this.changeModify(pageContext, sourceElement, visualNodeMap);
        }
    }

    private void setAttribute(VpeCreator[] creators, VpePageContext pageContext, Element sourceElement, Map<VpeTemplate, ?> visualNodeMap, String name, String value) {
        int i = 0;
        while (i < creators.length) {
            creators[i].setAttribute(pageContext, sourceElement, visualNodeMap, name, value);
            ++i;
        }
    }

    private void removeAttribute(VpeCreator[] creators, VpePageContext pageContext, Element sourceElement, Map<VpeTemplate, ?> visualNodeMap, String name) {
        int i = 0;
        while (i < creators.length) {
            creators[i].removeAttribute(pageContext, sourceElement, visualNodeMap, name);
            ++i;
        }
    }

    @Override
    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        if (this.creator != null) {
            return this.creator.isRecreateAtAttrChange(pageContext, sourceElement, visualDocument, (nsIDOMNode)visualNode, data, name, value);
        }
        return false;
    }

    @Override
    public Node getNodeForUpdate(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        Node nodeForUpdate = null;
        String templateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, sourceNode);
        if (sourceNode.getNodeName().endsWith(":facet")) {
            nodeForUpdate = sourceNode.getParentNode();
        } else if ("td".equalsIgnoreCase(templateName) || "tr".equalsIgnoreCase(templateName)) {
            Node parentNode = sourceNode.getParentNode();
            int i = 0;
            while (parentNode != null && i < 2) {
                if ("table".equalsIgnoreCase(parentNode.getNodeName())) {
                    nodeForUpdate = parentNode;
                    break;
                }
                parentNode = parentNode.getParentNode();
                ++i;
            }
        } else if ("option".equalsIgnoreCase(templateName)) {
            Node parentNode = sourceNode.getParentNode();
            if ("select".equalsIgnoreCase(parentNode.getNodeName())) {
                nodeForUpdate = parentNode;
            }
        } else if (this.creator != null) {
            nodeForUpdate = this.creator.getNodeForUpdate(pageContext, sourceNode, visualNode, (Map)data);
        }
        return nodeForUpdate;
    }

    @Override
    public IRegion getSourceRegionForOpenOn(VpePageContext pageContext, Node sourceNode, nsIDOMNode domNode) {
        if (sourceNode != null && sourceNode instanceof Element) {
            Element sourceElement = (Element)sourceNode;
            String templateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, sourceElement);
            Attr file = null;
            if ("jsp:directive.include".equals(templateName)) {
                file = sourceElement.getAttributeNode("file");
            } else if ("jsp:include".equals(templateName)) {
                file = sourceElement.getAttributeNode("page");
            } else if ("a".equalsIgnoreCase(templateName)) {
                file = sourceElement.getAttributeNode("href");
            } else if ("h:outputStylesheet".equals(templateName) || "h:graphicImage".equals(templateName)) {
                file = sourceElement.getAttributeNode("name");
            }
            if (file != null) {
                return new Region(NodesManagingUtil.getStartOffsetNode((Node)file), 0);
            }
        }
        return null;
    }

    private static class ModifyInfo {
        private nsIDOMElement visualElement;
        private boolean modify;

        private ModifyInfo(nsIDOMElement visualElement, boolean modify) {
            this.visualElement = visualElement;
            this.modify = modify;
        }
    }
}

