/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.texteditors.ITextProvider;
import org.jboss.tools.common.model.ui.texteditors.RevertToSavedAction3;
import org.jboss.tools.common.model.ui.texteditors.SaveAction3;
import org.jboss.tools.common.model.ui.texteditors.TextEditorSupport;
import org.jboss.tools.common.model.ui.texteditors.TextMerge;
import org.jboss.tools.common.model.ui.texteditors.propertyeditor.PropertiesTextEditorStub;
import org.jboss.tools.common.propertieseditor.text.PropertyTextEditorSupport;

public class PropertiesTextEditorComponent
extends PropertiesTextEditorStub
implements ITextListener,
ITextProvider,
ObjectTextEditor {
    protected TextEditorSupport support = this.createSupport();
    protected boolean isObjectNull = false;
    private boolean textChangedLock = false;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.dnd.enable();
        this.setModified(false);
        this.getSourceViewer().getDocument().addDocumentListener((IDocumentListener)this);
    }

    public PropertiesTextEditorComponent() {
        this.support.setProvider(this);
    }

    protected TextEditorSupport createSupport() {
        return new PropertyTextEditorSupport();
    }

    public TextEditorSupport getSupport() {
        return this.support;
    }

    public void setObject(XModelObject object) {
        boolean bl = this.isObjectNull = object == null;
        if (this.isObjectNull) {
            return;
        }
        this.getSourceViewer().getDocument().removeDocumentListener((IDocumentListener)this);
        this.support.setObject(object);
        this.getSourceViewer().getDocument().addDocumentListener((IDocumentListener)this);
    }

    public void updateDocument() {
        this.support.update();
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isDirty() {
        return this.isObjectNull ? super.isDirty() : false;
    }

    public String getText() {
        String text = null;
        if (this.getSourceViewer() == null) {
            return null;
        }
        if (this.getSourceViewer().getDocument() == null) {
            return null;
        }
        text = this.getSourceViewer().getDocument().get();
        return text == null ? "" : text;
    }

    public boolean isEditable() {
        return !this.isEditorInputReadOnly();
    }

    public boolean isEditorInputReadOnly() {
        if (!(this.getEditorInput() instanceof IModelObjectEditorInput)) {
            return super.isEditorInputReadOnly();
        }
        IModelObjectEditorInput input = (IModelObjectEditorInput)this.getEditorInput();
        return input != null && input.getXModelObject() != null && !input.getXModelObject().isObjectEditable();
    }

    public void setModified(boolean set) {
        if (set == this.support.isModified()) {
            return;
        }
        this.support.setModified(set);
        this.firePropertyChange(257);
    }

    public boolean isModified() {
        return this.support.isModified();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.getSourceViewer() != null && this.getSourceViewer().getDocument() != null) {
            this.getSourceViewer().getDocument().removeDocumentListener((IDocumentListener)this);
            this.getSourceViewer().getDocument().addDocumentListener((IDocumentListener)this);
        }
    }

    public void save() {
        if (!this.isObjectNull && !this.support.canSave(false)) {
            return;
        }
        if (this.isObjectNull) {
            super.doSave(null);
        } else {
            this.support.save();
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.getSourceViewer().getTextWidget().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getSourceViewer().getTextWidget().removeFocusListener(listener);
    }

    public void setCursor(int line, int position) {
        ISourceViewer sv = this.getSourceViewer();
        if (sv == null) {
            return;
        }
        IDocument d = sv.getDocument();
        if (d == null) {
            return;
        }
        try {
            int i = d.getLineOffset(line - 1) + position - 1;
            sv.setSelectedRange(i, 0);
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void doSaveAs() {
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isObjectNull) {
            super.doSave(monitor);
        }
    }

    public void textChanged(TextEvent event) {
        if (this.textChangedLock) {
            this.firePropertyChange(257);
        } else {
            this.setModified(true);
        }
    }

    public void setText(String text) {
        this.textChangedLock = true;
        try {
            if (this.getSourceViewer() == null || this.getSourceViewer().getDocument() == null) {
                return;
            }
            String txt = this.getSourceViewer().getDocument().get();
            if (txt != null && txt.length() > 0) {
                if (!TextMerge.replace(this.getSourceViewer().getDocument(), text)) {
                    this.getSourceViewer().getDocument().set(text);
                }
            } else {
                this.getSourceViewer().getDocument().set(text);
            }
        }
        finally {
            this.textChangedLock = false;
        }
    }

    public boolean isEqualText(String text) {
        return this.getSourceViewer().getDocument() != null && text.equals(this.getText());
    }

    public void doSanityCheckState(IEditorInput input) {
        super.safelySanityCheckState(input);
        if (this.isObjectNull) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                PropertiesTextEditorComponent.this.support.save();
            }
        });
    }

    public void doRevertToSaved() {
        this.support.save();
        this.support.revertToSaved();
    }

    protected void createActions() {
        super.createActions();
        Object action = new RevertToSavedAction3(this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.REVERT_TO_SAVED_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.revertToSaved");
        this.setAction(ITextEditorActionConstants.REVERT_TO_SAVED, (IAction)action);
        action = new SaveAction3(this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.SAVE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.file.save");
        this.setAction(ITextEditorActionConstants.SAVE, (IAction)action);
        this.markAsPropertyDependentAction(ITextEditorActionConstants.SAVE, true);
    }

    public void selectModelObject(XModelObject object) {
        String text = this.getText();
        String name = object.getAttributeValue("name");
        String dname = object.getAttributeValue("dirtyname");
        String nvs = object.getAttributeValue("name-value-separator");
        int i = text.indexOf(String.valueOf(dname) + nvs);
        if (i < 0) {
            return;
        }
        int j = text.indexOf(10, i = text.indexOf(name, i));
        if (j < 0) {
            j = text.length();
        }
        this.selectAndReveal(i, j - i);
    }

    public void selectModelObject(XModelObject object, String attribute) {
        this.selectModelObject(object);
    }

    protected void handleEditorInputChanged() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            this.close(false);
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (provider.isDeleted((Object)input)) {
            if (this.isSaveAsAllowed()) {
                IProgressMonitor pm = this.getProgressMonitor();
                this.performSaveAs(pm);
                if (pm.isCanceled()) {
                    this.handleEditorInputChanged();
                }
            } else {
                this.close(false);
            }
        } else {
            try {
                if (provider instanceof IDocumentProviderExtension) {
                    IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
                    extension.synchronize((Object)input);
                } else {
                    this.doSetInput(input);
                }
            }
            catch (CoreException x) {
                ModelUIPlugin.getPluginLog().logError((Throwable)x);
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.textChanged(null);
    }

    public void updateModification() {
        XModelObject object = this.support.getModelObject();
        if (object != null && !object.isModified() && this.support.isModified()) {
            this.setModified(false);
        } else {
            this.firePropertyChange(257);
        }
    }

    public XModelObject findModelObjectAtCursor() {
        XModelObject o = this.getModelObject();
        if (o == null) {
            return null;
        }
        ISelection selection = this.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        int offset = ((ITextSelection)selection).getOffset();
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        try {
            int line = doc.getLineOfOffset(offset);
            int lineStart = doc.getLineOffset(line);
            int length = doc.getLineLength(line);
            String txt = doc.get(lineStart, length);
            XModelObject[] cs = o.getChildren();
            String trimmed = txt.trim();
            int i = 0;
            while (i < cs.length) {
                String n = cs[i].getAttributeValue("name");
                if (trimmed.startsWith(n)) {
                    String s;
                    int q;
                    String sep = cs[i].getAttributeValue("name-value-separator");
                    if (sep == null || sep.length() == 0) {
                        sep = "=";
                    }
                    if ((q = trimmed.indexOf(61)) >= 0 && (s = trimmed.substring(n.length(), q).trim()).length() <= 0) {
                        return cs[i];
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }
}

