/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.editor.ErrorSelectionListener;
import org.jboss.tools.common.editor.L;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

class Lbl {
    private L label = null;
    private String error = "";
    private String[] messages = new String[]{"", "", ""};
    private int line = 1;
    private int position = 1;
    ErrorSelectionListener listener;

    Lbl() {
    }

    public void update(String s, Composite parent) {
        if (this.label == null || this.label.isDisposed()) {
            Composite c = new Composite(parent, 0);
            c.setLayoutData((Object)new GridData(768));
            GridLayout l = new GridLayout();
            l.marginWidth = 0;
            c.setLayout((Layout)l);
            c.setBackground(Display.getDefault().getSystemColor(1));
            this.label = new L(c, 0);
            this.label.setBackground(Display.getDefault().getSystemColor(1));
            this.label.setLayoutData(new GridData(768));
            this.label.addMouseListener((MouseListener)new SL());
            this.label.setData(this.messages);
        }
        if (s == null) {
            s = "";
        }
        if (!this.error.equals(s)) {
            this.parse(s);
        }
    }

    private void parse(String s) {
        this.error = s;
        this.line = 1;
        this.position = 1;
        int i = s.indexOf(64);
        int j = s.indexOf(64, i + 1);
        int k = s.indexOf(64, j + 1);
        if (k > j) {
            String q = s.substring(j + 1, k);
            this.messages[0] = s.substring(0, i);
            this.messages[1] = q;
            this.messages[2] = s.substring(k + 1);
            int qi = q.indexOf(58);
            if (qi > 0) {
                this.line = this.getInt(q.substring(0, qi), this.line);
                this.position = this.getInt(q.substring(qi + 1), this.position);
            }
        } else {
            this.messages[0] = "ERROR";
            this.messages[1] = "0:0";
            this.messages[2] = s;
        }
        if (this.messages[1] == null || "0:0".equals(this.messages[1])) {
            this.messages[1] = "";
        }
    }

    int getInt(String s, int def) {
        if (s == null || s.length() == 0) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return def;
        }
    }

    public void go() {
        if (this.listener != null) {
            this.listener.errorSelected(this.line, this.position);
        }
    }

    public void dispose() {
        if (this.label != null && !this.label.isDisposed()) {
            this.label.dispose();
        }
    }

    class SL
    extends MouseAdapter {
        SL() {
        }

        public void mouseUp(MouseEvent e) {
            if (Lbl.this.label.isLink(e.x, e.y)) {
                Lbl.this.go();
            }
        }
    }
}

