/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.node.BaseNode;
import org.hibernate.eclipse.console.workbench.BaseNodeWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ColumnWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ConfigurationWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ConsoleConfigurationWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.KnownConfigurationsWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchemaWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.LazySessionFactory;
import org.hibernate.eclipse.console.workbench.LazySessionFactoryAdapter;
import org.hibernate.eclipse.console.workbench.PersistentClassWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.PrimaryKeyWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.PropertyWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.TableContainer;
import org.hibernate.eclipse.console.workbench.TableContainerWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.TableWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ValueWorkbenchAdapter;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public class ConfigurationAdapterFactory
implements IAdapterFactory {
    private Class<?>[] classes;
    private IWorkbenchAdapter[] adapters;
    private Class<?>[] deferredClasses;
    private IDeferredWorkbenchAdapter[] deferredAdapters;

    public ConfigurationAdapterFactory() {
        HashMap<Class<LazySessionFactory>, Object> deferredMap = new HashMap<Class<LazySessionFactory>, Object>();
        deferredMap.put(ConsoleConfiguration.class, new ConsoleConfigurationWorkbenchAdapter());
        deferredMap.put(Configuration.class, new ConfigurationWorkbenchAdapter());
        deferredMap.put(KnownConfigurations.class, new KnownConfigurationsWorkbenchAdapter());
        deferredMap.put(LazyDatabaseSchema.class, new LazyDatabaseSchemaWorkbenchAdapter());
        deferredMap.put(LazySessionFactory.class, new LazySessionFactoryAdapter());
        this.deferredClasses = new Class[deferredMap.size()];
        this.deferredAdapters = new IDeferredWorkbenchAdapter[deferredMap.size()];
        int cnt = 0;
        for (Map.Entry entry : deferredMap.entrySet()) {
            this.deferredClasses[cnt] = (Class)entry.getKey();
            this.deferredAdapters[cnt] = (IDeferredWorkbenchAdapter)entry.getValue();
            ++cnt;
        }
        HashMap<Class, Object> map = new HashMap<Class, Object>();
        map.put(TableContainer.class, new TableContainerWorkbenchAdapter());
        map.put(PersistentClass.class, new PersistentClassWorkbenchAdapter());
        map.put(Property.class, new PropertyWorkbenchAdapter());
        map.put(Value.class, new ValueWorkbenchAdapter());
        map.put(Table.class, new TableWorkbenchAdapter());
        map.put(PrimaryKey.class, new PrimaryKeyWorkbenchAdapter());
        map.put(Column.class, new ColumnWorkbenchAdapter());
        map.put(BaseNode.class, new BaseNodeWorkbenchAdapter());
        this.classes = new Class[map.size()];
        this.adapters = new IWorkbenchAdapter[map.size()];
        cnt = 0;
        for (Map.Entry entry : map.entrySet()) {
            this.classes[cnt] = (Class)entry.getKey();
            this.adapters[cnt] = (IWorkbenchAdapter)entry.getValue();
            ++cnt;
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IDeferredWorkbenchAdapter.class) {
            return this.getDeferredAdapter(adaptableObject);
        }
        if (adapterType == IWorkbenchAdapter.class) {
            Object adapter = this.getAdapter(adaptableObject);
            return adapter != null ? adapter : this.getDeferredAdapter(adaptableObject);
        }
        if (adapterType == IPropertySource2.class || adapterType == IPropertySource.class) {
            return this.getPropertySource(adaptableObject);
        }
        return null;
    }

    private Object getPropertySource(Object adaptableObject) {
        return null;
    }

    private Object getDeferredAdapter(Object adaptableObject) {
        int i = 0;
        while (i < this.deferredClasses.length) {
            Class<?> clazz = this.deferredClasses[i];
            if (clazz.isInstance(adaptableObject)) {
                return this.deferredAdapters[i];
            }
            ++i;
        }
        return null;
    }

    private Object getAdapter(Object adaptableObject) {
        int i = 0;
        while (i < this.classes.length) {
            Class<?> clazz = this.classes[i];
            if (clazz.isInstance(adaptableObject)) {
                return this.adapters[i];
            }
            ++i;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IDeferredWorkbenchAdapter.class, IWorkbenchAdapter.class, IPropertySource.class, IPropertySource2.class};
    }

    public void registerAdapters(IAdapterManager adapterManager) {
        Class<?> clazz;
        int i = 0;
        while (i < this.classes.length) {
            clazz = this.classes[i];
            adapterManager.registerAdapters((IAdapterFactory)this, clazz);
            ++i;
        }
        i = 0;
        while (i < this.deferredClasses.length) {
            clazz = this.deferredClasses[i];
            adapterManager.registerAdapters((IAdapterFactory)this, clazz);
            ++i;
        }
    }
}

