/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.LaunchHelper;

public class ConsoleConfigurationPropertySource
implements IPropertySource {
    private ConsoleConfiguration cfg;
    static List<IPropertyDescriptor> pd;

    static {
        ComboBoxPropertyDescriptor modeDescriptor = new ComboBoxPropertyDescriptor((Object)"mode", HibernateConsoleMessages.ConsoleConfigurationPropertySource_mode, ConsoleConfigurationPreferences.ConfigurationMode.labels());
        ArrayList<IPropertyDescriptor> l = new ArrayList<IPropertyDescriptor>();
        l.add((IPropertyDescriptor)new TextPropertyDescriptor((Object)"name", HibernateConsoleMessages.ConsoleConfigurationPropertySource_name));
        l.add((IPropertyDescriptor)modeDescriptor);
        l.add((IPropertyDescriptor)new PropertyDescriptor((Object)"hibernate.cfg.xml", HibernateConsoleMessages.ConsoleConfigurationPropertySource_config_file));
        l.add((IPropertyDescriptor)new PropertyDescriptor((Object)"hibernate.properties", HibernateConsoleMessages.ConsoleConfigurationPropertySource_properties_file));
        l.add((IPropertyDescriptor)new PropertyDescriptor((Object)"mapping.files", HibernateConsoleMessages.ConsoleConfigurationPropertySource_additional_mapping_files));
        pd = l;
    }

    public ConsoleConfigurationPropertySource(ConsoleConfiguration cfg) {
        this.cfg = cfg;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[pd.size() + 2];
        pd.toArray(propertyDescriptors);
        propertyDescriptors[propertyDescriptors.length - 2] = this.createProjectDescriptor();
        propertyDescriptors[propertyDescriptors.length - 1] = this.createConnectionDescriptor();
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        try {
            ILaunchConfiguration lc;
            if ("name".equals(id)) {
                return this.cfg.getName();
            }
            ConsoleConfigurationPreferences preferences = this.cfg.getPreferences();
            if ("project".equals(id)) {
                try {
                    lc = HibernateConsolePlugin.getDefault().findLaunchConfig(this.cfg.getName());
                    if (lc != null) {
                        String projectName = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                        return Arrays.binarySearch(this.getSortedProjectNames(), projectName);
                    }
                    HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().log(e);
                }
            }
            if ("mode".equals(id)) {
                String[] values = ConsoleConfigurationPreferences.ConfigurationMode.values();
                String value = preferences.getConfigurationMode().toString();
                int i = 0;
                while (i < values.length) {
                    if (value.equals(values[i])) {
                        return i;
                    }
                    ++i;
                }
                return new RuntimeException("Unknown ConsoleConfiguration mode: " + value);
            }
            if ("connection".equals(id)) {
                try {
                    lc = HibernateConsolePlugin.getDefault().findLaunchConfig(this.cfg.getName());
                    if (lc != null) {
                        String connectionName = lc.getAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", null);
                        if (connectionName == null) {
                            connectionName = lc.getAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE", Boolean.FALSE.toString());
                            connectionName = Boolean.TRUE.toString().equalsIgnoreCase(connectionName) ? HibernateConsoleMessages.ConnectionProfileCtrl_JPAConfiguredConnection : HibernateConsoleMessages.ConnectionProfileCtrl_HibernateConfiguredConnection;
                        }
                        String[] values = this.getConnectionNames();
                        int i = 0;
                        while (i < values.length) {
                            if (values[i].equals(connectionName)) {
                                return i;
                            }
                            ++i;
                        }
                    } else {
                        HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                    }
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().log(e);
                }
            }
            if ("hibernate.cfg.xml".equals(id)) {
                return preferences.getConfigXMLFile();
            }
            if ("hibernate.properties".equals(id)) {
                return preferences.getPropertyFile();
            }
            if ("mapping.files".equals(id)) {
                return preferences.getMappingFiles().length;
            }
            return null;
        }
        catch (RuntimeException e) {
            return String.valueOf(HibernateConsoleMessages.ConsoleConfigurationPropertySource_error) + e.getMessage();
        }
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        block27: {
            if ("name".equals(id) && value instanceof String) {
                String newName = (String)value;
                if (LaunchHelper.verifyConfigurationName(newName) != null) {
                    return;
                }
                String oldName = this.cfg.getName();
                try {
                    ILaunchConfiguration lc = HibernateConsolePlugin.getDefault().findLaunchConfig(oldName);
                    if (lc != null) {
                        ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
                        wc.rename(newName);
                        wc.doSave();
                        this.cfg = KnownConfigurations.getInstance().find(newName);
                        break block27;
                    }
                    HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + oldName + "\"");
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().log(e);
                }
            } else if ("mode".equals(id) && value instanceof Integer) {
                int index = (Integer)value;
                try {
                    ILaunchConfiguration lc = HibernateConsolePlugin.getDefault().findLaunchConfig(this.cfg.getName());
                    if (lc != null) {
                        ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
                        wc.setAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ConsoleConfigurationPreferences.ConfigurationMode.values()[index]);
                        wc.doSave();
                        break block27;
                    }
                    HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                }
                catch (CoreException coreException) {
                    HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                }
            } else if ("project".equals(id) && value instanceof Integer) {
                int index = (Integer)value;
                try {
                    ILaunchConfiguration lc = HibernateConsolePlugin.getDefault().findLaunchConfig(this.cfg.getName());
                    if (lc != null) {
                        ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
                        String projectName = this.getSortedProjectNames()[index];
                        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
                        if (projectName != null) {
                            wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS, Collections.singletonList(projectName));
                            wc.setAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES, Collections.singletonList(Integer.toString(4)));
                        } else {
                            wc.removeAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS);
                            wc.removeAttribute(LaunchConfiguration.ATTR_MAPPED_RESOURCE_TYPES);
                        }
                        wc.doSave();
                        break block27;
                    }
                    HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                }
                catch (CoreException coreException) {
                    HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                }
            } else if ("connection".equals(id) && value instanceof Integer) {
                int index = (Integer)value;
                try {
                    ILaunchConfiguration lc = HibernateConsolePlugin.getDefault().findLaunchConfig(this.cfg.getName());
                    if (lc != null) {
                        ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
                        if (index == 0) {
                            wc.setAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE", Boolean.TRUE.toString());
                            wc.removeAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME");
                        } else if (index == 1) {
                            wc.removeAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE");
                            wc.removeAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME");
                        } else {
                            String[] values = this.getConnectionNames();
                            wc.setAttribute("org.hibernate.eclipse.launch.CONNECTION_PROFILE_NAME", values[index]);
                            wc.removeAttribute("org.hibernate.eclipse.launch.USE_JPA_PROJECT_PROFILE");
                        }
                        wc.doSave();
                    } else {
                        HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                    }
                }
                catch (CoreException coreException) {
                    HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + this.cfg.getName() + "\"");
                }
            }
        }
    }

    private IPropertyDescriptor createProjectDescriptor() {
        ComboBoxPropertyDescriptor projectDescriptor = new ComboBoxPropertyDescriptor((Object)"project", HibernateConsoleMessages.ConsoleConfigurationPropertySource_project, this.getSortedProjectNames());
        projectDescriptor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                if (value instanceof Integer && (Integer)value < 0) {
                    try {
                        ILaunchConfiguration lc = HibernateConsolePlugin.getDefault().findLaunchConfig(ConsoleConfigurationPropertySource.this.cfg.getName());
                        if (lc != null) {
                            String projectName = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                            if (projectName != null) {
                                return NLS.bind((String)HibernateConsoleMessages.ConsoleConfigurationMainTab_the_java_project_does_not_exist, (Object)projectName);
                            }
                        } else {
                            HibernateConsolePlugin.getDefault().log("Can't find Console Configuration \"" + ConsoleConfigurationPropertySource.this.cfg.getName() + "\"");
                        }
                    }
                    catch (CoreException e) {
                        HibernateConsolePlugin.getDefault().log(e);
                    }
                }
                return null;
            }
        });
        return projectDescriptor;
    }

    private IPropertyDescriptor createConnectionDescriptor() {
        ComboBoxPropertyDescriptor connectionDescriptor = new ComboBoxPropertyDescriptor((Object)"connection", HibernateConsoleMessages.ConsoleConfigurationPropertySource_connection, this.getConnectionNames());
        return connectionDescriptor;
    }

    private String[] getSortedProjectNames() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Object[] projectNames = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            projectNames[i] = projects[i].getName();
            ++i;
        }
        Arrays.sort(projectNames);
        return projectNames;
    }

    private String[] getConnectionNames() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
        Object[] names = new String[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            names[i] = profiles[i].getName();
            ++i;
        }
        Arrays.sort(names);
        String[] resNames = new String[names.length + 2];
        resNames[0] = HibernateConsoleMessages.ConnectionProfileCtrl_JPAConfiguredConnection;
        resNames[1] = HibernateConsoleMessages.ConnectionProfileCtrl_HibernateConfiguredConnection;
        System.arraycopy(names, 0, resNames, 2, names.length);
        return resNames;
    }
}

