/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.CPDView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class CPDViewDoubleClickEventListener
implements IDoubleClickListener {
    private final CPDView view;

    public CPDViewDoubleClickEventListener(CPDView cPDView) {
        this.view = cPDView;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        TreeNode treeNode = (TreeNode)object;
        Object object2 = treeNode.getValue();
        TreeViewer treeViewer = this.view.getTreeViewer();
        if (object2 instanceof Match) {
            if (treeViewer.getExpandedState((Object)treeNode)) {
                treeViewer.collapseToLevel((Object)treeNode, -1);
            } else {
                treeViewer.expandToLevel((Object)treeNode, 1);
            }
        } else if (object2 instanceof TokenEntry) {
            TokenEntry tokenEntry = (TokenEntry)object2;
            Match match = (Match)treeNode.getParent().getValue();
            IPath iPath = Path.fromOSString((String)tokenEntry.getTokenSrcID());
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
            if (iFile != null) {
                try {
                    IWorkbenchPage iWorkbenchPage = this.view.getSite().getPage();
                    IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile);
                    if (iEditorPart instanceof ITextEditor) {
                        ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                        IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                        int n = iDocument.getLineOffset(tokenEntry.getBeginLine() - 1);
                        int n2 = iDocument.getLineOffset(tokenEntry.getBeginLine() - 1 + match.getLineCount()) - n - 1;
                        iTextEditor.selectAndReveal(n, n2);
                    }
                }
                catch (PartInitException partInitException) {
                    PMDPlugin.getDefault().logError(this.getString("message.error.view_exception"), partInitException);
                }
                catch (BadLocationException badLocationException) {
                    PMDPlugin.getDefault().logError(this.getString("message.error.view_exception"), badLocationException);
                }
            }
        }
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

