/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.properties;

import java.util.Collection;
import java.util.Comparator;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleTableViewerSorter;
import net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPageBean;
import net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPageController;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.PropertyPage;

public class PMDPropertyPage
extends PropertyPage {
    private static final Logger log;
    private PMDPropertyPageController controller;
    private PMDPropertyPageBean model;
    private Button enablePMDButton;
    protected TableViewer availableRulesTableViewer;
    private IWorkingSet selectedWorkingSet;
    private Label selectedWorkingSetLabel;
    private Button deselectWorkingSetButton;
    private Button includeDerivedFilesButton;
    private Button violationsAsErrorsButton;
    protected Button ruleSetStoredInProjectButton;
    protected Text ruleSetFileText;
    protected Button ruleSetBrowseButton;
    private final RuleTableViewerSorter availableRuleTableViewerSorter = new RuleTableViewerSorter(RuleTableViewerSorter.RULE_DEFAULT_COMPARATOR);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    protected Control createContents(Composite composite) {
        log.info((Object)"PMD properties editing requested");
        this.controller = new PMDPropertyPageController(this.getShell());
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject iProject = (IProject)iAdaptable.getAdapter((Class)clazz);
        this.controller.setProject(iProject);
        this.model = this.controller.getPropertyPageBean();
        Composite composite2 = null;
        this.noDefaultAndApplyButton();
        if (iProject.isAccessible() && this.model != null) {
            composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            composite2.setLayout((Layout)gridLayout);
            this.enablePMDButton = this.buildEnablePMDButton(composite2);
            Label label = new Label(composite2, 262);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.includeDerivedFilesButton = this.buildIncludeDerivedFilesButton(composite2);
            label = new Label(composite2, 262);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.violationsAsErrorsButton = this.buildViolationsAsErrorsButton(composite2);
            label = new Label(composite2, 262);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.selectedWorkingSetLabel = this.buildSelectedWorkingSetLabel(composite2);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.selectedWorkingSetLabel.setLayoutData((Object)gridData);
            Composite composite3 = new Composite(composite2, 0);
            RowLayout rowLayout = new RowLayout();
            rowLayout.type = 256;
            rowLayout.justify = true;
            rowLayout.pack = false;
            rowLayout.wrap = false;
            composite3.setLayout((Layout)rowLayout);
            this.buildSelectWorkingSetButton(composite3);
            this.deselectWorkingSetButton = this.buildDeselectWorkingSetButton(composite3);
            label = new Label(composite2, 262);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            this.buildLabel(composite2, "property.label.select_rule");
            Table table = this.buildAvailableRulesTableViewer(composite2);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            gridData.heightHint = 50;
            table.setLayoutData((Object)gridData);
            Composite composite4 = new Composite(composite2, 0);
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.numColumns = 3;
            composite4.setLayout((Layout)gridLayout2);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            composite4.setLayoutData((Object)gridData);
            this.ruleSetStoredInProjectButton = this.buildStoreRuleSetInProjectButton(composite4);
            this.ruleSetFileText = this.buildRuleSetFileText(composite4);
            this.ruleSetBrowseButton = this.buildRuleSetBrowseButton(composite4);
            gridData = new GridData(4, 0, true, false);
            this.ruleSetFileText.setLayoutData((Object)gridData);
            this.refreshRuleSetInProject();
        } else {
            this.setValid(false);
        }
        log.debug((Object)"Property page created");
        return composite2;
    }

    private Button buildEnablePMDButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("property.button.enable"));
        button.setSelection(this.model.isPmdEnabled());
        return button;
    }

    private Button buildIncludeDerivedFilesButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("property.button.include_derived_files"));
        button.setSelection(this.model.isIncludeDerivedFiles());
        return button;
    }

    private Button buildViolationsAsErrorsButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("property.button.violations_as_errors"));
        button.setSelection(this.model.violationsAsErrors());
        return button;
    }

    private Button buildStoreRuleSetInProjectButton(Composite composite) {
        Button button = new Button(composite, 32);
        button.setText(this.getMessage("property.button.store_ruleset_project"));
        button.setSelection(this.model.isRuleSetStoredInProject());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PMDPropertyPage.this.refreshRuleSetInProject();
            }
        });
        return button;
    }

    private Text buildRuleSetFileText(Composite composite) {
        Text text = new Text(composite, 2052);
        String string = this.model.getRuleSetFile();
        if (string != null) {
            text.setText(string);
        }
        return text;
    }

    private Button buildRuleSetBrowseButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(this.getMessage("property.button.ruleset_browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(PMDPropertyPage.this.getShell(), 4096);
                String string = fileDialog.open();
                if (string != null) {
                    PMDPropertyPage.this.ruleSetFileText.setText(string);
                }
            }
        });
        return button;
    }

    private Label buildLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string == null ? "" : this.getMessage(string));
        return label;
    }

    private Label buildSelectedWorkingSetLabel(Composite composite) {
        this.selectedWorkingSet = this.model.getProjectWorkingSet();
        Label label = new Label(composite, 0);
        label.setText(this.selectedWorkingSet == null ? this.getMessage("property.label.no_workingset") : String.valueOf(this.getMessage("property.label.selected_workingset")) + this.selectedWorkingSet.getName());
        return label;
    }

    private Table buildAvailableRulesTableViewer(Composite composite) {
        this.availableRulesTableViewer = new TableViewer(composite, 68388);
        Table table = this.availableRulesTableViewer.getTable();
        this.addColumnTo(table, 16384, true, this.getMessage("preference.ruleset.column.ruleset_name"), 110, RuleTableViewerSorter.RULE_RULESET_NAME_COMPARATOR);
        this.addColumnTo(table, 16384, true, this.getMessage("preference.ruleset.column.rule_name"), 170, RuleTableViewerSorter.RULE_NAME_COMPARATOR);
        this.addColumnTo(table, 16384, false, this.getMessage("preference.ruleset.column.since"), 40, RuleTableViewerSorter.RULE_SINCE_COMPARATOR);
        this.addColumnTo(table, 16384, false, this.getMessage("preference.ruleset.column.priority"), 80, RuleTableViewerSorter.RULE_PRIORITY_COMPARATOR);
        this.addColumnTo(table, 16384, true, this.getMessage("preference.ruleset.column.description"), 300, RuleTableViewerSorter.RULE_DESCRIPTION_COMPARATOR);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.availableRulesTableViewer.setContentProvider((IContentProvider)new RuleSetContentProvider());
        this.availableRulesTableViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.availableRulesTableViewer.setSorter((ViewerSorter)this.availableRuleTableViewerSorter);
        this.availableRulesTableViewer.setColumnProperties(new String[]{"ruleSetname", "ruleName", "since", "priority", "description"});
        this.populateAvailableRulesTable();
        return table;
    }

    private void addColumnTo(Table table, int n, boolean bl, String string, int n2, final Comparator comparator) {
        TableColumn tableColumn = new TableColumn(table, n);
        tableColumn.setResizable(bl);
        tableColumn.setText(string);
        tableColumn.setWidth(n2);
        if (comparator != null) {
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PMDPropertyPage.this.availableRuleTableViewerSorter.setComparator(comparator);
                    PMDPropertyPage.this.refresh();
                }
            });
        }
    }

    private void buildSelectWorkingSetButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(this.getMessage("property.button.select_workingset"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PMDPropertyPage.this.selectWorkingSet();
            }
        });
    }

    private Button buildDeselectWorkingSetButton(Composite composite) {
        Button button = new Button(composite, 8);
        button.setText(this.getMessage("property.button.deselect_workingset"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PMDPropertyPage.this.deselectWorkingSet();
            }
        });
        button.setEnabled(this.selectedWorkingSet != null);
        return button;
    }

    private void populateAvailableRulesTable() {
        this.availableRulesTableViewer.setInput((Object)this.controller.getAvailableRules());
        RuleSet ruleSet = this.model.getProjectRuleSet();
        if (ruleSet != null) {
            Collection collection = ruleSet.getRules();
            TableItem[] tableItemArray = this.availableRulesTableViewer.getTable().getItems();
            int n = 0;
            while (n < tableItemArray.length) {
                Object object = tableItemArray[n].getData();
                if (collection.contains(object)) {
                    tableItemArray[n].setChecked(true);
                }
                ++n;
            }
        }
    }

    public boolean performOk() {
        log.info((Object)"Properties editing accepted");
        this.model.setPmdEnabled(this.enablePMDButton.getSelection());
        this.model.setProjectWorkingSet(this.selectedWorkingSet);
        this.model.setProjectRuleSet(this.getProjectRuleSet());
        this.model.setRuleSetStoredInProject(this.ruleSetStoredInProjectButton.getSelection());
        this.model.setRuleSetFile(this.ruleSetFileText.getText());
        this.model.setIncludeDerivedFiles(this.includeDerivedFilesButton.getSelection());
        this.model.setViolationsAsErrors(this.violationsAsErrorsButton.getSelection());
        return this.controller.performOk();
    }

    public boolean performCancel() {
        log.info((Object)"Properties editing canceled");
        return super.performCancel();
    }

    private RuleSet getProjectRuleSet() {
        RuleSet ruleSet = new RuleSet();
        TableItem[] tableItemArray = this.availableRulesTableViewer.getTable().getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            if (tableItemArray[n].getChecked()) {
                Rule rule = (Rule)tableItemArray[n].getData();
                ruleSet.addRule(rule);
            }
            ++n;
        }
        RuleSet ruleSet2 = this.model.getProjectRuleSet();
        ruleSet.addExcludePatterns(ruleSet2.getExcludePatterns());
        ruleSet.addIncludePatterns(ruleSet2.getIncludePatterns());
        return ruleSet;
    }

    protected void selectWorkingSet() {
        log.info((Object)"Select working set");
        this.setSelectedWorkingSet(this.controller.selectWorkingSet(this.selectedWorkingSet));
    }

    protected void deselectWorkingSet() {
        log.info((Object)"Deselect working set");
        this.setSelectedWorkingSet(null);
    }

    private void setSelectedWorkingSet(IWorkingSet iWorkingSet) {
        this.selectedWorkingSet = iWorkingSet;
        this.selectedWorkingSetLabel.setText(this.selectedWorkingSet == null ? this.getMessage("property.label.no_workingset") : String.valueOf(this.getMessage("property.label.selected_workingset")) + this.selectedWorkingSet.getName());
        this.deselectWorkingSetButton.setEnabled(this.selectedWorkingSet != null);
    }

    private String getMessage(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void refresh() {
        try {
            try {
                this.availableRulesTableViewer.getControl().setRedraw(false);
                Collection collection = this.getProjectRuleSet().getRules();
                this.availableRulesTableViewer.refresh();
                TableItem[] tableItemArray = this.availableRulesTableViewer.getTable().getItems();
                int n = 0;
                while (n < tableItemArray.length) {
                    if (collection.contains(tableItemArray[n].getData())) {
                        tableItemArray[n].setChecked(true);
                    }
                    ++n;
                }
            }
            catch (ClassCastException classCastException) {
                PMDPlugin.getDefault().logError("Ignoring exception while refreshing table", classCastException);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.availableRulesTableViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.availableRulesTableViewer.getControl().setRedraw(true);
    }

    protected void refreshRuleSetInProject() {
        Table table = this.availableRulesTableViewer.getTable();
        if (this.ruleSetStoredInProjectButton.getSelection()) {
            table.setEnabled(false);
            this.ruleSetBrowseButton.setEnabled(true);
            this.ruleSetFileText.setEnabled(true);
        } else {
            table.setEnabled(true);
            this.ruleSetBrowseButton.setEnabled(false);
            this.ruleSetFileText.setEnabled(false);
        }
    }
}

