/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CPDPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text minTileText;
    private Label minTileLabel;
    private IPreferences preferences;

    public void init(IWorkbench iWorkbench) {
        this.setDescription(this.getMessage("preference.cpd.title"));
        this.preferences = PMDPlugin.getDefault().loadPreferences();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Group group = this.buildGeneralGroup(composite2);
        group.setLayoutData((Object)new GridData(768));
        return composite2;
    }

    private Group buildGeneralGroup(Composite composite) {
        Group group = new Group(composite, 4);
        group.setText(this.getMessage("preference.cpd.group.general"));
        group.setLayout((Layout)new GridLayout(2, false));
        this.minTileLabel = new Label((Composite)group, 0);
        this.minTileLabel.setText(this.getMessage("preference.cpd.tilesize"));
        this.minTileText = new Text((Composite)group, 2048);
        this.minTileText.setText(String.valueOf(this.preferences.getMinTileSize()));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.minTileText.setLayoutData((Object)gridData);
        return group;
    }

    protected void performDefaults() {
        this.minTileText.setText(String.valueOf(25));
    }

    public boolean performOk() {
        this.preferences.setMinTileSize(new Integer(this.minTileText.getText()));
        this.preferences.sync();
        return super.performOk();
    }

    private String getMessage(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

