/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;

public class EntityComparator
implements Comparator<XModelObject> {
    private static HashMap<String, EntityComparator> comparators = new HashMap();
    private Hashtable<String, Integer> entities = null;
    boolean ignoreCase = false;

    public static synchronized EntityComparator getComparator(XModelEntity entity) {
        EntityComparator c = comparators.get(entity.getName());
        if (c == null) {
            c = new EntityComparator(entity.getChildren());
            comparators.put(entity.getName(), c);
        }
        return c;
    }

    public EntityComparator(XChild[] c) {
        this.entities = new Hashtable(c.length);
        int i = 0;
        while (i < c.length) {
            this.entities.put(c[i].getName(), i * 100);
            ++i;
        }
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    @Override
    public int compare(XModelObject s1, XModelObject s2) {
        int i2;
        int i1 = this.getEntityRange(s1);
        if (i1 != (i2 = this.getEntityRange(s2))) {
            return i1 - i2;
        }
        if (this.ignoreCase) {
            String p1 = s1.getPathPart();
            String p2 = s2.getPathPart();
            p1 = p1 == null ? "" : p1.toLowerCase();
            p2 = p2 == null ? "" : p2.toLowerCase();
            return p1.compareTo(p2);
        }
        return s1.getPathPart().compareTo(s2.getPathPart());
    }

    private int getEntityRange(XModelObject s) {
        Integer i = this.entities.get(s.getModelEntity().getName());
        return i == null ? 1000 : i;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }
}

