/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.Iterator;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public class CreateMutableCloneResolution
extends BugResolution {
    public boolean resolveBindings() {
        return true;
    }

    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        assert (rewrite != null);
        assert (workingUnit != null);
        assert (bug != null);
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        String fieldName = bug.getPrimaryField().getFieldName();
        Expression retEx = null;
        CastExpression castRet = null;
        Expression original = null;
        Iterator itr = method.getBody().statements().iterator();
        while (itr.hasNext() && original == null) {
            Statement stmt = (Statement)itr.next();
            if (!(stmt instanceof ReturnStatement)) continue;
            retEx = ((ReturnStatement)stmt).getExpression();
            if (retEx instanceof SimpleName && ((SimpleName)retEx).getIdentifier().equals(fieldName)) {
                original = retEx;
                continue;
            }
            if (!(retEx instanceof FieldAccess) || !this.isThisFieldAccess((FieldAccess)retEx, fieldName)) continue;
            original = ((FieldAccess)retEx).getName();
        }
        if (original == null) {
            throw new BugResolutionException("No original field found.");
        }
        MethodInvocation cloneInvoke = workingUnit.getAST().newMethodInvocation();
        SimpleName cloneField = (SimpleName)ASTNode.copySubtree((AST)cloneInvoke.getAST(), original);
        SimpleName cloneName = workingUnit.getAST().newSimpleName("clone");
        cloneInvoke.setExpression((Expression)cloneField);
        cloneInvoke.setName(cloneName);
        castRet = workingUnit.getAST().newCastExpression();
        Type retType = (Type)ASTNode.copySubtree((AST)castRet.getAST(), (ASTNode)method.getReturnType2());
        castRet.setExpression((Expression)cloneInvoke);
        castRet.setType(retType);
        rewrite.replace((ASTNode)original, (ASTNode)castRet, null);
    }

    private boolean isThisFieldAccess(FieldAccess access, String fieldName) {
        return access.getExpression() instanceof ThisExpression && access.getName().getIdentifier().equals(fieldName);
    }
}

