/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DetectorConfigurationTab
extends Composite {
    private Map<DetectorFactory, String> factoriesToBugAbbrev;
    private final FindbugsPropertyPage propertyPage;
    protected CheckboxTableViewer availableFactoriesTableViewer;
    private final Map<Integer, COLUMN> columnsMap = new HashMap<Integer, COLUMN>();
    private final Button hiddenVisible;

    public DetectorConfigurationTab(TabFolder tabFolder, FindbugsPropertyPage page, int style) {
        super((Composite)tabFolder, style);
        this.propertyPage = page;
        this.setLayout((Layout)new GridLayout());
        TabItem tabDetector = new TabItem(tabFolder, 0);
        tabDetector.setText(this.getMessage("property.detectorsTab"));
        tabDetector.setControl((Control)this);
        tabDetector.setToolTipText("Enable / disable available detectors");
        Label info = new Label((Composite)this, 64);
        info.setText("Disabled detectors will not participate in FindBugs analysis. \n'Grayed out' detectors will run, however they will not report any results to the UI.");
        this.hiddenVisible = new Button((Composite)this, 32);
        this.hiddenVisible.setText("Show hidden detectors");
        this.hiddenVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetectorConfigurationTab.this.populateAvailableRulesTable(DetectorConfigurationTab.this.propertyPage.getProject());
            }
        });
        SashForm sash = new SashForm((Composite)this, 512);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 400;
        layoutData.widthHint = 550;
        sash.setLayoutData((Object)layoutData);
        Table availableRulesTable = this.createDetectorsTableViewer((Composite)sash, page.getProject());
        GridData tableLayoutData = new GridData(1808);
        tableLayoutData.heightHint = 300;
        tableLayoutData.widthHint = 550;
        availableRulesTable.setLayoutData((Object)tableLayoutData);
        Group group = new Group((Composite)sash, 0);
        group.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText("Detector details");
        final Text text = new Text((Composite)group, 840);
        GridData layoutData2 = new GridData(1808);
        text.setLayoutData((Object)layoutData2);
        text.setBackground(this.getShell().getDisplay().getSystemColor(25));
        sash.setWeights(new int[]{3, 1});
        availableRulesTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                DetectorFactory factory = (DetectorFactory)item.getData();
                String description = DetectorConfigurationTab.getDetailedText(factory);
                text.setText(description);
            }
        });
    }

    private static String getDetailedText(DetectorFactory factory) {
        if (factory == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(factory.getFullName());
        sb.append("\n");
        sb.append(DetectorConfigurationTab.getDescriptionWithoutHtml(factory));
        sb.append("\n\nReported patterns:\n");
        Set<BugPattern> patterns = factory.getReportedBugPatterns();
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            BugPattern pattern = (BugPattern)iter.next();
            sb.append(pattern.getType()).append(" ").append(" (").append(pattern.getAbbrev()).append(", ").append(pattern.getCategory()).append("):").append("  ");
            sb.append(pattern.getShortDescription());
            if (!iter.hasNext()) continue;
            sb.append("\n");
        }
        if (patterns.isEmpty()) {
            sb.append("none");
        }
        return sb.toString();
    }

    private static String getDescriptionWithoutHtml(DetectorFactory factory) {
        String detailHTML = factory.getDetailHTML();
        detailHTML = DetectorConfigurationTab.trimHtml(detailHTML, "<BODY>", "</BODY>");
        detailHTML = detailHTML.replaceAll("\\s*[\\n]+\\s*", " ");
        detailHTML = detailHTML.replaceAll("<[a-zA-Z]+>", "");
        detailHTML = detailHTML.replaceAll("</[a-zA-Z]+>", "");
        detailHTML = detailHTML.replaceAll("&nbsp;", "");
        detailHTML = detailHTML.replaceAll("&lt;", "<");
        detailHTML = detailHTML.replaceAll("&gt;", ">");
        detailHTML = detailHTML.replaceAll("&amp;", "&");
        return detailHTML.trim();
    }

    private static String trimHtml(String detailHTML, String startTag, String endTag) {
        if (detailHTML.indexOf(startTag) > 0) {
            detailHTML = detailHTML.substring(detailHTML.indexOf(startTag) + startTag.length());
        }
        if (detailHTML.indexOf(endTag) > 0) {
            detailHTML = detailHTML.substring(0, detailHTML.lastIndexOf(endTag));
        }
        return detailHTML;
    }

    private String getBugsCategories(DetectorFactory factory) {
        Set<BugPattern> patterns = factory.getReportedBugPatterns();
        String category = null;
        TreeSet<String> categories = new TreeSet<String>();
        for (BugPattern bugPattern : patterns) {
            String category2 = bugPattern.getCategory();
            if (category == null) {
                category = category2;
                continue;
            }
            if (category.equals(category2)) continue;
            categories.add(category);
            categories.add(category2);
        }
        if (!categories.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String string : categories) {
                sb.append(I18N.instance().getBugCategoryDescription(string)).append("|");
            }
            category = sb.toString();
        } else {
            category = I18N.instance().getBugCategoryDescription(category);
        }
        return category;
    }

    void refreshUI(UserPreferences preferences) {
        TableItem[] itemList = this.availableFactoriesTableViewer.getTable().getItems();
        for (int i = 0; i < itemList.length; ++i) {
            TableItem item = itemList[i];
            DetectorFactory factory = (DetectorFactory)item.getData();
            item.setChecked(preferences.isDetectorEnabled(factory));
        }
        this.refreshTable();
        this.syncUserPreferencesWithTable();
    }

    void refreshTable() {
        this.availableFactoriesTableViewer.refresh(true);
    }

    protected void syncUserPreferencesWithTable() {
        TableItem[] itemList = this.availableFactoriesTableViewer.getTable().getItems();
        UserPreferences currentProps = this.getCurrentProps();
        for (int i = 0; i < itemList.length; ++i) {
            DetectorFactory factory = (DetectorFactory)itemList[i].getData();
            currentProps.enableDetector(factory, itemList[i].getChecked());
        }
    }

    private UserPreferences getCurrentProps() {
        return this.propertyPage.getCurrentUserPreferences();
    }

    private void addColumnSelectionListener(final BugPatternTableSorter sorter, final TableColumn column, final COLUMN columnId) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sorter.setSortColumnIndex(columnId);
                Table factoriesTable = DetectorConfigurationTab.this.availableFactoriesTableViewer.getTable();
                factoriesTable.setSortDirection(sorter.revertOrder ? 128 : 1024);
                factoriesTable.setSortColumn(column);
                DetectorConfigurationTab.this.availableFactoriesTableViewer.refresh();
            }
        });
    }

    private Table createDetectorsTableViewer(Composite parent, IProject project) {
        BugPatternTableSorter sorter = new BugPatternTableSorter(this);
        int tableStyle = 68388;
        this.availableFactoriesTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)tableStyle);
        this.availableFactoriesTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DetectorConfigurationTab.this.syncUserPreferencesWithTable();
            }
        });
        int currentColumnIdx = 0;
        Table factoriesTable = this.availableFactoriesTableViewer.getTable();
        TableColumn factoryNameColumn = this.createColumn(currentColumnIdx, factoriesTable, this.getMessage("property.detectorName"), 250, COLUMN.DETECTOR_NAME);
        this.addColumnSelectionListener(sorter, factoryNameColumn, COLUMN.DETECTOR_NAME);
        TableColumn bugsAbbrevColumn = this.createColumn(++currentColumnIdx, factoriesTable, this.getMessage("property.bugCodes"), 100, COLUMN.BUG_CODES);
        this.addColumnSelectionListener(sorter, bugsAbbrevColumn, COLUMN.BUG_CODES);
        TableColumn speedColumn = this.createColumn(++currentColumnIdx, factoriesTable, this.getMessage("property.speed"), 75, COLUMN.DETECTOR_SPEED);
        this.addColumnSelectionListener(sorter, speedColumn, COLUMN.DETECTOR_SPEED);
        TableColumn categoryColumn = this.createColumn(++currentColumnIdx, factoriesTable, this.getMessage("property.category"), 75, COLUMN.BUG_CATEGORIES);
        this.addColumnSelectionListener(sorter, categoryColumn, COLUMN.BUG_CATEGORIES);
        factoriesTable.setLinesVisible(true);
        factoriesTable.setHeaderVisible(true);
        factoriesTable.setSortDirection(sorter.revertOrder ? 128 : 1024);
        factoriesTable.setSortColumn(factoryNameColumn);
        sorter.setSortColumnIndex(COLUMN.DETECTOR_NAME);
        this.availableFactoriesTableViewer.setContentProvider((IContentProvider)new DetectorFactoriesContentProvider());
        this.availableFactoriesTableViewer.setLabelProvider((IBaseLabelProvider)new DetectorFactoryLabelProvider(this));
        this.availableFactoriesTableViewer.setSorter((ViewerSorter)sorter);
        this.populateAvailableRulesTable(project);
        factoriesTable.setEnabled(true);
        return factoriesTable;
    }

    private COLUMN getColumn(int index) {
        COLUMN column = this.columnsMap.get(index);
        if (column == null) {
            return COLUMN.UNKNOWN;
        }
        return column;
    }

    private TableColumn createColumn(int currentColumnIdx, Table factoriesTable, String text, int width, COLUMN col) {
        TableColumn column = new TableColumn(factoriesTable, 4);
        column.setResizable(true);
        column.setText(text);
        column.setWidth(width);
        this.columnsMap.put(currentColumnIdx, col);
        return column;
    }

    protected String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    private void populateAvailableRulesTable(IProject project) {
        ArrayList<DetectorFactory> allAvailableList = new ArrayList<DetectorFactory>();
        this.factoriesToBugAbbrev = new HashMap<DetectorFactory, String>();
        Iterator<DetectorFactory> iterator = DetectorFactoryCollection.instance().factoryIterator();
        while (iterator.hasNext()) {
            DetectorFactory factory = iterator.next();
            if (factory.isHidden() && !this.isHiddenVisible()) continue;
            allAvailableList.add(factory);
            this.addBugsAbbreviation(factory);
        }
        this.availableFactoriesTableViewer.setInput(allAvailableList);
        TableItem[] itemList = this.availableFactoriesTableViewer.getTable().getItems();
        UserPreferences userPreferences = this.getCurrentProps();
        for (int i = 0; i < itemList.length; ++i) {
            DetectorFactory rule = (DetectorFactory)itemList[i].getData();
            if (!userPreferences.isDetectorEnabled(rule)) continue;
            itemList[i].setChecked(true);
        }
    }

    boolean isHiddenVisible() {
        return this.hiddenVisible.getSelection();
    }

    protected void addBugsAbbreviation(DetectorFactory factory) {
        this.factoriesToBugAbbrev.put(factory, this.createBugsAbbreviation(factory));
    }

    protected String getBugsAbbreviation(DetectorFactory factory) {
        String abbr = this.factoriesToBugAbbrev.get(factory);
        if (abbr == null) {
            abbr = this.createBugsAbbreviation(factory);
        }
        if (abbr == null) {
            abbr = "";
        }
        return abbr;
    }

    protected String createBugsAbbreviation(DetectorFactory factory) {
        StringBuffer sb = new StringBuffer();
        Set<BugPattern> patterns = factory.getReportedBugPatterns();
        LinkedHashSet<String> abbrs = new LinkedHashSet<String>();
        for (BugPattern pattern : patterns) {
            String abbr = pattern.getAbbrev();
            abbrs.add(abbr);
        }
        Iterator iter = abbrs.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            sb.append(element);
            if (!iter.hasNext()) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    public void setEnabled(boolean enabled) {
        this.availableFactoriesTableViewer.getTable().setEnabled(enabled);
        this.hiddenVisible.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private static final class DetectorFactoryLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private final DetectorConfigurationTab tab;

        DetectorFactoryLabelProvider(DetectorConfigurationTab tab) {
            this.tab = tab;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof DetectorFactory)) {
                return null;
            }
            DetectorFactory factory = (DetectorFactory)element;
            COLUMN col = this.tab.getColumn(columnIndex);
            switch (col) {
                case BUG_CODES: {
                    return this.tab.getBugsAbbreviation(factory);
                }
                case DETECTOR_SPEED: {
                    return factory.getSpeed();
                }
                case BUG_CATEGORIES: {
                    return this.tab.getBugsCategories(factory);
                }
                case DETECTOR_NAME: {
                    return factory.getShortName();
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            if (!(element instanceof DetectorFactory)) {
                return null;
            }
            if (!this.isFactoryVisible((DetectorFactory)element)) {
                return Display.getDefault().getSystemColor(19);
            }
            return null;
        }

        private boolean isFactoryVisible(DetectorFactory factory) {
            Map<DetectorFactory, Boolean> enabledDetectors = this.tab.propertyPage.getVisibleDetectors();
            Boolean enabled = enabledDetectors.get(factory);
            if (enabled != null) {
                return enabled;
            }
            ProjectFilterSettings filterSettings = this.tab.getCurrentProps().getFilterSettings();
            for (BugPattern pattern : factory.getReportedBugPatterns()) {
                if (!filterSettings.containsCategory(pattern.getCategory())) continue;
                enabledDetectors.put(factory, Boolean.TRUE);
                return true;
            }
            enabledDetectors.put(factory, Boolean.FALSE);
            return false;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }

    private static final class DetectorFactoriesContentProvider
    implements IStructuredContentProvider {
        private DetectorFactoriesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BugPatternTableSorter
    extends ViewerSorter
    implements Comparator<DetectorFactory> {
        private COLUMN sortColumnId;
        private COLUMN lastSortColumnId;
        boolean revertOrder;
        private final DetectorConfigurationTab tab;

        BugPatternTableSorter(DetectorConfigurationTab tab) {
            this.tab = tab;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare((DetectorFactory)e1, (DetectorFactory)e2);
        }

        @Override
        public int compare(DetectorFactory factory1, DetectorFactory factory2) {
            String s2;
            String s1;
            int result = 0;
            switch (this.getSortColumnId()) {
                case BUG_CODES: {
                    s1 = this.tab.getBugsAbbreviation(factory1);
                    s2 = this.tab.getBugsAbbreviation(factory2);
                    break;
                }
                case DETECTOR_SPEED: {
                    s1 = factory1.getSpeed();
                    s2 = factory2.getSpeed();
                    break;
                }
                case BUG_CATEGORIES: {
                    s1 = this.tab.getBugsCategories(factory1);
                    s2 = this.tab.getBugsCategories(factory2);
                    break;
                }
                default: {
                    s1 = "" + factory1.getShortName();
                    s2 = factory2.getShortName();
                }
            }
            result = s1.compareTo(s2);
            if (result == 0) {
                switch (this.getSortColumnId()) {
                    case DETECTOR_NAME: {
                        s1 = this.tab.getBugsAbbreviation(factory1);
                        s2 = this.tab.getBugsAbbreviation(factory2);
                        break;
                    }
                    default: {
                        s1 = "" + factory1.getShortName();
                        s2 = factory2.getShortName();
                    }
                }
                result = s1.compareTo(s2);
            } else if (this.revertOrder) {
                result = -result;
            }
            return result;
        }

        public boolean isSorterProperty(Object element, String property) {
            return property.equals(COLUMN.DETECTOR_NAME.name()) || property.equals(COLUMN.BUG_CODES.name());
        }

        public void setSortColumnIndex(COLUMN columnId) {
            this.lastSortColumnId = this.sortColumnId;
            this.sortColumnId = columnId;
            this.revertOrder = !this.revertOrder && this.lastSortColumnId == columnId;
        }

        public COLUMN getSortColumnId() {
            return this.sortColumnId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum COLUMN {
        BUG_CODES,
        BUG_CATEGORIES,
        DETECTOR_NAME,
        DETECTOR_SPEED,
        UNKNOWN;

    }
}

