/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.expression;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.TLDVersionHelper;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeFunction;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.w3c.dom.Node;

public class VpeFunctionTldVersionCheck
extends VpeFunction {
    public static final String FUNCTION_NAME = "tld_version";
    private static final String MIN_VERSION_KEYWORD = "min";
    private static final String MAX_VERSION_KEYWORD = "max";

    @Override
    public VpeValue exec(VpePageContext pageContext, Node sourceNode) throws VpeExpressionException {
        double tldVersionNumber;
        String tagValue = this.getParameter(0).exec(pageContext, sourceNode).stringValue();
        double startValue = this.getStartVersion(tagValue);
        double endValue = this.getEndVersion(tagValue);
        if (sourceNode == null || sourceNode.getPrefix() == null) {
            return new VpeValue(false);
        }
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, pageContext);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourceNode.getPrefix(), taglibs);
        String tldVersion = TLDVersionHelper.getTldVersion((String)sourceNodeTaglib.getUri(), (String)sourceNodeTaglib.getPrefix(), (IDocument)pageContext.getSourceBuilder().getStructuredTextViewer().getDocument());
        if (tldVersion != null) {
            tldVersionNumber = this.stringVersionToDouble(tldVersion);
        } else {
            XModel xm = null;
            IEditorInput editorInput = pageContext.getEditPart().getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return new VpeValue(false);
            }
            IProject project = ((IFileEditorInput)editorInput).getFile().getProject();
            IModelNature mn = EclipseResourceUtil.getModelNature((IProject)project);
            if (mn != null) {
                xm = mn.getModel();
            }
            tldVersionNumber = (tldVersion = WebProject.getTldVersion((String)sourceNodeTaglib.getUri(), (String)sourceNodeTaglib.getPrefix(), (IDocument)pageContext.getSourceBuilder().getStructuredTextViewer().getDocument(), (XModel)xm)) != null ? this.stringVersionToDouble(tldVersion) : Double.MAX_VALUE;
        }
        if (startValue <= tldVersionNumber && endValue >= tldVersionNumber) {
            return new VpeValue(true);
        }
        return new VpeValue(false);
    }

    private double getStartVersion(String tagValue) {
        try {
            if (tagValue.indexOf(MIN_VERSION_KEYWORD) != -1) {
                return this.stringVersionToDouble(tagValue.substring(tagValue.indexOf(MIN_VERSION_KEYWORD) + 4));
            }
            return -1.7976931348623157E308;
        }
        catch (NumberFormatException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
            return -1.7976931348623157E308;
        }
    }

    private double getEndVersion(String tagValue) {
        try {
            if (tagValue.indexOf(MAX_VERSION_KEYWORD) != -1) {
                return this.stringVersionToDouble(tagValue.substring(tagValue.indexOf(MAX_VERSION_KEYWORD) + 4));
            }
            return Double.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
            return Double.MAX_VALUE;
        }
    }

    private double stringVersionToDouble(String sVersion) {
        double dVersion;
        String parseableVersion;
        String[] tokens = sVersion.split("\\.");
        switch (tokens.length) {
            case 0: {
                parseableVersion = "0";
                break;
            }
            case 1: {
                parseableVersion = tokens[0];
                break;
            }
            default: {
                parseableVersion = String.valueOf(tokens[0]) + '.' + tokens[1];
            }
        }
        try {
            dVersion = Double.parseDouble(parseableVersion);
        }
        catch (NumberFormatException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
            dVersion = 0.0;
        }
        return dVersion;
    }
}

