/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.preferences;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.w3c.dom.Element;

public interface ConsoleConfigurationPreferences {
    public static final String HIBERNATE_VERSION = "hibernate-version";
    public static final String PATH_TAG = "path";
    public static final String CLASSPATH_TAG = "classpath";
    public static final String MAPPING_TAG = "mapping";
    public static final String MAPPINGS_TAG = "mappings";
    public static final String HIBERNATE_PROPERTIES_TAG = "hibernate-properties";
    public static final String LOCATION_ATTRIB = "location";
    public static final String HIBERNATE_CONFIG_XML_TAG = "hibernate-config-xml";
    public static final String NAME_ATTRIB = "name";
    public static final String CONFIGURATION_TAG = "configuration";
    public static final String ANNOTATIONS_ATTRIB = "annotations";
    public static final String ENTITYRESOLVER_ATTRIB = "entityresolver";
    public static final String CONFIGURATION_MODE_ATTRIB = "configuration-factory";

    public String getHibernateVersion();

    public ConfigurationMode getConfigurationMode();

    public String getName();

    public URL[] getCustomClassPathURLS();

    public File[] getMappingFiles();

    public Properties getProperties();

    public File getConfigXMLFile();

    public File getPropertyFile();

    public void writeStateTo(Element var1);

    public void readStateFrom(Element var1);

    public void setName(String var1);

    public String getEntityResolverName();

    public String getPersistenceUnitName();

    public String getNamingStrategy();

    public String getConnectionProfileName();

    public String getDialectName();

    public static class ConfigurationMode
    implements Serializable {
        private static final ArrayList<ConfigurationMode> INSTANCES = new ArrayList();
        private static final ArrayList<String> LABELS = new ArrayList();
        public static final ConfigurationMode CORE = new ConfigurationMode("CORE");
        public static final ConfigurationMode ANNOTATIONS = new ConfigurationMode("ANNOTATIONS");
        public static final ConfigurationMode JPA = new ConfigurationMode("JPA");
        private final String name;

        static {
            INSTANCES.add(CORE);
            INSTANCES.add(ANNOTATIONS);
            INSTANCES.add(JPA);
            LABELS.add("Core");
            LABELS.add("Annotations");
            LABELS.add("JPA");
        }

        public ConfigurationMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            ConfigurationMode res = null;
            int i = 0;
            while (i < INSTANCES.size() && res == null) {
                if (ConfigurationMode.INSTANCES.get((int)i).name.equals(this.name)) {
                    res = INSTANCES.get(i);
                }
                ++i;
            }
            return res;
        }

        public static ConfigurationMode parse(String name) {
            ConfigurationMode rtn = null;
            int i = 0;
            while (i < INSTANCES.size() && rtn == null) {
                if (ConfigurationMode.INSTANCES.get((int)i).name.equals(name)) {
                    rtn = INSTANCES.get(i);
                }
                ++i;
            }
            if (rtn == null) {
                rtn = CORE;
            }
            return rtn;
        }

        public static String[] values() {
            String[] res = new String[INSTANCES.size()];
            int i = 0;
            while (i < INSTANCES.size()) {
                res[i] = ConfigurationMode.INSTANCES.get((int)i).name;
                ++i;
            }
            return res;
        }

        public static String[] labels() {
            return LABELS.toArray(new String[LABELS.size()]);
        }
    }
}

