(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "react", "../../EditColumn", "@patternfly/react-styles/css/components/Table/table"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("react"), require("../../EditColumn"), require("@patternfly/react-styles/css/components/Table/table"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.react, global.EditColumn, global.table);
    global.undefined = mod.exports;
  }
})(this, function (exports, _react, _EditColumn, _table) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.editable = undefined;

  var React = _interopRequireWildcard(_react);

  var _table2 = _interopRequireDefault(_table);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  const editable = exports.editable = (label, {
    rowIndex,
    rowData,
    column
  }) => {
    const {
      extraParams: {
        onRowEdit
      }
    } = column;

    const toggleEditMode = (event, type) => {
      let validationErrors = {};

      if (type === 'save') {
        validationErrors = rowData.rowEditValidationRules && rowData.rowEditValidationRules.reduce((acc, rule) => {
          const invalidCells = rowData.cells.filter(cellData => {
            const testValue = cellData.props.editableValue === '' ? '' : cellData.props.editableValue || cellData.props.value;
            const failedValidation = !rule.validator(testValue);

            if (failedValidation) {
              cellData.props.isValid = false;
            }

            return failedValidation;
          });

          if (invalidCells.length) {
            acc[rule.name] = invalidCells.map(cell => cell.props.name);
          }

          return acc;
        }, {});
      } // tslint:disable-next-line:no-unused-expression


      onRowEdit(event, type, rowData && rowData.isEditable, rowIndex, validationErrors);
    };
    /**
     * @param {number} identifier identifier used for the row
     * @param {RowEditType} actionType the type of row edit action
     */


    function getAriaLabelTxt(identifier, actionType) {
      let result;

      switch (actionType) {
        case 'cancel':
          result = `Cancel row edits for row ${identifier}`;
          break;

        case 'save':
          result = `Save row edits for row ${identifier}`;
          break;

        default:
          result = `Place row ${identifier} in edit mode`;
      }

      return result;
    }

    return {
      className: _table2.default.tableInlineEditAction,
      component: 'td',
      isVisible: true,
      children: React.createElement(_EditColumn.EditColumn, {
        saveAriaLabel: rowData && rowData.rowSaveBtnAriaLabel && rowData.rowSaveBtnAriaLabel(rowIndex) || getAriaLabelTxt(rowIndex, 'save'),
        cancelAriaLabel: rowData && rowData.rowCancelBtnAriaLabel && rowData.rowCancelBtnAriaLabel(rowIndex) || getAriaLabelTxt(rowIndex, 'cancel'),
        editAriaLabel: rowData && rowData.rowEditBtnAriaLabel && rowData.rowEditBtnAriaLabel(rowIndex) || getAriaLabelTxt(rowIndex, 'edit'),
        valid: rowData && rowData.isValid,
        editing: rowData && rowData.isEditable,
        onClick: toggleEditMode
      })
    };
  };
});
//# sourceMappingURL=editable.js.map