(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('prop-types'), require('react'), require('react-dom')) :
  typeof define === 'function' && define.amd ? define(['exports', 'prop-types', 'react', 'react-dom'], factory) :
  (global = global || self, factory(global.PatternFlyReact = {}, global.PropTypes, global.React, global.ReactDOM));
}(this, (function (exports, _pt, React, ReactDOM) { 'use strict';

  _pt = _pt && Object.prototype.hasOwnProperty.call(_pt, 'default') ? _pt['default'] : _pt;
  var React__default = 'default' in React ? React['default'] : React;

  function memoize(fn) {
    var cache = {};
    return function (arg) {
      if (cache[arg] === undefined) cache[arg] = fn(arg);
      return cache[arg];
    };
  }

  var unitlessKeys = {
    animationIterationCount: 1,
    borderImageOutset: 1,
    borderImageSlice: 1,
    borderImageWidth: 1,
    boxFlex: 1,
    boxFlexGroup: 1,
    boxOrdinalGroup: 1,
    columnCount: 1,
    columns: 1,
    flex: 1,
    flexGrow: 1,
    flexPositive: 1,
    flexShrink: 1,
    flexNegative: 1,
    flexOrder: 1,
    gridRow: 1,
    gridRowEnd: 1,
    gridRowSpan: 1,
    gridRowStart: 1,
    gridColumn: 1,
    gridColumnEnd: 1,
    gridColumnSpan: 1,
    gridColumnStart: 1,
    fontWeight: 1,
    lineHeight: 1,
    opacity: 1,
    order: 1,
    orphans: 1,
    tabSize: 1,
    widows: 1,
    zIndex: 1,
    zoom: 1,
    WebkitLineClamp: 1,
    // SVG-related properties
    fillOpacity: 1,
    floodOpacity: 1,
    stopOpacity: 1,
    strokeDasharray: 1,
    strokeDashoffset: 1,
    strokeMiterlimit: 1,
    strokeOpacity: 1,
    strokeWidth: 1
  };

  /* eslint-disable */
  // murmurhash2 via https://github.com/garycourt/murmurhash-js/blob/master/murmurhash2_gc.js
  function murmurhash2_32_gc(str) {
    var l = str.length,
        h = l ^ l,
        i = 0,
        k;

    while (l >= 4) {
      k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
      k = (k & 0xffff) * 0x5bd1e995 + (((k >>> 16) * 0x5bd1e995 & 0xffff) << 16);
      k ^= k >>> 24;
      k = (k & 0xffff) * 0x5bd1e995 + (((k >>> 16) * 0x5bd1e995 & 0xffff) << 16);
      h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16) ^ k;
      l -= 4;
      ++i;
    }

    switch (l) {
      case 3:
        h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

      case 2:
        h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

      case 1:
        h ^= str.charCodeAt(i) & 0xff;
        h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16);
    }

    h ^= h >>> 13;
    h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16);
    h ^= h >>> 15;
    return (h >>> 0).toString(36);
  }

  function stylis_min (W) {
    function M(d, c, e, h, a) {
      for (var m = 0, b = 0, v = 0, n = 0, q, g, x = 0, K = 0, k, u = k = q = 0, l = 0, r = 0, I = 0, t = 0, B = e.length, J = B - 1, y, f = '', p = '', F = '', G = '', C; l < B;) {
        g = e.charCodeAt(l);
        l === J && 0 !== b + n + v + m && (0 !== b && (g = 47 === b ? 10 : 47), n = v = m = 0, B++, J++);

        if (0 === b + n + v + m) {
          if (l === J && (0 < r && (f = f.replace(N, '')), 0 < f.trim().length)) {
            switch (g) {
              case 32:
              case 9:
              case 59:
              case 13:
              case 10:
                break;

              default:
                f += e.charAt(l);
            }

            g = 59;
          }

          switch (g) {
            case 123:
              f = f.trim();
              q = f.charCodeAt(0);
              k = 1;

              for (t = ++l; l < B;) {
                switch (g = e.charCodeAt(l)) {
                  case 123:
                    k++;
                    break;

                  case 125:
                    k--;
                    break;

                  case 47:
                    switch (g = e.charCodeAt(l + 1)) {
                      case 42:
                      case 47:
                        a: {
                          for (u = l + 1; u < J; ++u) {
                            switch (e.charCodeAt(u)) {
                              case 47:
                                if (42 === g && 42 === e.charCodeAt(u - 1) && l + 2 !== u) {
                                  l = u + 1;
                                  break a;
                                }

                                break;

                              case 10:
                                if (47 === g) {
                                  l = u + 1;
                                  break a;
                                }

                            }
                          }

                          l = u;
                        }

                    }

                    break;

                  case 91:
                    g++;

                  case 40:
                    g++;

                  case 34:
                  case 39:
                    for (; l++ < J && e.charCodeAt(l) !== g;) {
                    }

                }

                if (0 === k) break;
                l++;
              }

              k = e.substring(t, l);
              0 === q && (q = (f = f.replace(ca, '').trim()).charCodeAt(0));

              switch (q) {
                case 64:
                  0 < r && (f = f.replace(N, ''));
                  g = f.charCodeAt(1);

                  switch (g) {
                    case 100:
                    case 109:
                    case 115:
                    case 45:
                      r = c;
                      break;

                    default:
                      r = O;
                  }

                  k = M(c, r, k, g, a + 1);
                  t = k.length;
                  0 < A && (r = X(O, f, I), C = H(3, k, r, c, D, z, t, g, a, h), f = r.join(''), void 0 !== C && 0 === (t = (k = C.trim()).length) && (g = 0, k = ''));
                  if (0 < t) switch (g) {
                    case 115:
                      f = f.replace(da, ea);

                    case 100:
                    case 109:
                    case 45:
                      k = f + '{' + k + '}';
                      break;

                    case 107:
                      f = f.replace(fa, '$1 $2');
                      k = f + '{' + k + '}';
                      k = 1 === w || 2 === w && L('@' + k, 3) ? '@-webkit-' + k + '@' + k : '@' + k;
                      break;

                    default:
                      k = f + k, 112 === h && (k = (p += k, ''));
                  } else k = '';
                  break;

                default:
                  k = M(c, X(c, f, I), k, h, a + 1);
              }

              F += k;
              k = I = r = u = q = 0;
              f = '';
              g = e.charCodeAt(++l);
              break;

            case 125:
            case 59:
              f = (0 < r ? f.replace(N, '') : f).trim();
              if (1 < (t = f.length)) switch (0 === u && (q = f.charCodeAt(0), 45 === q || 96 < q && 123 > q) && (t = (f = f.replace(' ', ':')).length), 0 < A && void 0 !== (C = H(1, f, c, d, D, z, p.length, h, a, h)) && 0 === (t = (f = C.trim()).length) && (f = '\x00\x00'), q = f.charCodeAt(0), g = f.charCodeAt(1), q) {
                case 0:
                  break;

                case 64:
                  if (105 === g || 99 === g) {
                    G += f + e.charAt(l);
                    break;
                  }

                default:
                  58 !== f.charCodeAt(t - 1) && (p += P(f, q, g, f.charCodeAt(2)));
              }
              I = r = u = q = 0;
              f = '';
              g = e.charCodeAt(++l);
          }
        }

        switch (g) {
          case 13:
          case 10:
            47 === b ? b = 0 : 0 === 1 + q && 107 !== h && 0 < f.length && (r = 1, f += '\x00');
            0 < A * Y && H(0, f, c, d, D, z, p.length, h, a, h);
            z = 1;
            D++;
            break;

          case 59:
          case 125:
            if (0 === b + n + v + m) {
              z++;
              break;
            }

          default:
            z++;
            y = e.charAt(l);

            switch (g) {
              case 9:
              case 32:
                if (0 === n + m + b) switch (x) {
                  case 44:
                  case 58:
                  case 9:
                  case 32:
                    y = '';
                    break;

                  default:
                    32 !== g && (y = ' ');
                }
                break;

              case 0:
                y = '\\0';
                break;

              case 12:
                y = '\\f';
                break;

              case 11:
                y = '\\v';
                break;

              case 38:
                0 === n + b + m && (r = I = 1, y = '\f' + y);
                break;

              case 108:
                if (0 === n + b + m + E && 0 < u) switch (l - u) {
                  case 2:
                    112 === x && 58 === e.charCodeAt(l - 3) && (E = x);

                  case 8:
                    111 === K && (E = K);
                }
                break;

              case 58:
                0 === n + b + m && (u = l);
                break;

              case 44:
                0 === b + v + n + m && (r = 1, y += '\r');
                break;

              case 34:
              case 39:
                0 === b && (n = n === g ? 0 : 0 === n ? g : n);
                break;

              case 91:
                0 === n + b + v && m++;
                break;

              case 93:
                0 === n + b + v && m--;
                break;

              case 41:
                0 === n + b + m && v--;
                break;

              case 40:
                if (0 === n + b + m) {
                  if (0 === q) switch (2 * x + 3 * K) {
                    case 533:
                      break;

                    default:
                      q = 1;
                  }
                  v++;
                }

                break;

              case 64:
                0 === b + v + n + m + u + k && (k = 1);
                break;

              case 42:
              case 47:
                if (!(0 < n + m + v)) switch (b) {
                  case 0:
                    switch (2 * g + 3 * e.charCodeAt(l + 1)) {
                      case 235:
                        b = 47;
                        break;

                      case 220:
                        t = l, b = 42;
                    }

                    break;

                  case 42:
                    47 === g && 42 === x && t + 2 !== l && (33 === e.charCodeAt(t + 2) && (p += e.substring(t, l + 1)), y = '', b = 0);
                }
            }

            0 === b && (f += y);
        }

        K = x;
        x = g;
        l++;
      }

      t = p.length;

      if (0 < t) {
        r = c;
        if (0 < A && (C = H(2, p, r, d, D, z, t, h, a, h), void 0 !== C && 0 === (p = C).length)) return G + p + F;
        p = r.join(',') + '{' + p + '}';

        if (0 !== w * E) {
          2 !== w || L(p, 2) || (E = 0);

          switch (E) {
            case 111:
              p = p.replace(ha, ':-moz-$1') + p;
              break;

            case 112:
              p = p.replace(Q, '::-webkit-input-$1') + p.replace(Q, '::-moz-$1') + p.replace(Q, ':-ms-input-$1') + p;
          }

          E = 0;
        }
      }

      return G + p + F;
    }

    function X(d, c, e) {
      var h = c.trim().split(ia);
      c = h;
      var a = h.length,
          m = d.length;

      switch (m) {
        case 0:
        case 1:
          var b = 0;

          for (d = 0 === m ? '' : d[0] + ' '; b < a; ++b) {
            c[b] = Z(d, c[b], e).trim();
          }

          break;

        default:
          var v = b = 0;

          for (c = []; b < a; ++b) {
            for (var n = 0; n < m; ++n) {
              c[v++] = Z(d[n] + ' ', h[b], e).trim();
            }
          }

      }

      return c;
    }

    function Z(d, c, e) {
      var h = c.charCodeAt(0);
      33 > h && (h = (c = c.trim()).charCodeAt(0));

      switch (h) {
        case 38:
          return c.replace(F, '$1' + d.trim());

        case 58:
          return d.trim() + c.replace(F, '$1' + d.trim());

        default:
          if (0 < 1 * e && 0 < c.indexOf('\f')) return c.replace(F, (58 === d.charCodeAt(0) ? '' : '$1') + d.trim());
      }

      return d + c;
    }

    function P(d, c, e, h) {
      var a = d + ';',
          m = 2 * c + 3 * e + 4 * h;

      if (944 === m) {
        d = a.indexOf(':', 9) + 1;
        var b = a.substring(d, a.length - 1).trim();
        b = a.substring(0, d).trim() + b + ';';
        return 1 === w || 2 === w && L(b, 1) ? '-webkit-' + b + b : b;
      }

      if (0 === w || 2 === w && !L(a, 1)) return a;

      switch (m) {
        case 1015:
          return 97 === a.charCodeAt(10) ? '-webkit-' + a + a : a;

        case 951:
          return 116 === a.charCodeAt(3) ? '-webkit-' + a + a : a;

        case 963:
          return 110 === a.charCodeAt(5) ? '-webkit-' + a + a : a;

        case 1009:
          if (100 !== a.charCodeAt(4)) break;

        case 969:
        case 942:
          return '-webkit-' + a + a;

        case 978:
          return '-webkit-' + a + '-moz-' + a + a;

        case 1019:
        case 983:
          return '-webkit-' + a + '-moz-' + a + '-ms-' + a + a;

        case 883:
          if (45 === a.charCodeAt(8)) return '-webkit-' + a + a;
          if (0 < a.indexOf('image-set(', 11)) return a.replace(ja, '$1-webkit-$2') + a;
          break;

        case 932:
          if (45 === a.charCodeAt(4)) switch (a.charCodeAt(5)) {
            case 103:
              return '-webkit-box-' + a.replace('-grow', '') + '-webkit-' + a + '-ms-' + a.replace('grow', 'positive') + a;

            case 115:
              return '-webkit-' + a + '-ms-' + a.replace('shrink', 'negative') + a;

            case 98:
              return '-webkit-' + a + '-ms-' + a.replace('basis', 'preferred-size') + a;
          }
          return '-webkit-' + a + '-ms-' + a + a;

        case 964:
          return '-webkit-' + a + '-ms-flex-' + a + a;

        case 1023:
          if (99 !== a.charCodeAt(8)) break;
          b = a.substring(a.indexOf(':', 15)).replace('flex-', '').replace('space-between', 'justify');
          return '-webkit-box-pack' + b + '-webkit-' + a + '-ms-flex-pack' + b + a;

        case 1005:
          return ka.test(a) ? a.replace(aa, ':-webkit-') + a.replace(aa, ':-moz-') + a : a;

        case 1e3:
          b = a.substring(13).trim();
          c = b.indexOf('-') + 1;

          switch (b.charCodeAt(0) + b.charCodeAt(c)) {
            case 226:
              b = a.replace(G, 'tb');
              break;

            case 232:
              b = a.replace(G, 'tb-rl');
              break;

            case 220:
              b = a.replace(G, 'lr');
              break;

            default:
              return a;
          }

          return '-webkit-' + a + '-ms-' + b + a;

        case 1017:
          if (-1 === a.indexOf('sticky', 9)) break;

        case 975:
          c = (a = d).length - 10;
          b = (33 === a.charCodeAt(c) ? a.substring(0, c) : a).substring(d.indexOf(':', 7) + 1).trim();

          switch (m = b.charCodeAt(0) + (b.charCodeAt(7) | 0)) {
            case 203:
              if (111 > b.charCodeAt(8)) break;

            case 115:
              a = a.replace(b, '-webkit-' + b) + ';' + a;
              break;

            case 207:
            case 102:
              a = a.replace(b, '-webkit-' + (102 < m ? 'inline-' : '') + 'box') + ';' + a.replace(b, '-webkit-' + b) + ';' + a.replace(b, '-ms-' + b + 'box') + ';' + a;
          }

          return a + ';';

        case 938:
          if (45 === a.charCodeAt(5)) switch (a.charCodeAt(6)) {
            case 105:
              return b = a.replace('-items', ''), '-webkit-' + a + '-webkit-box-' + b + '-ms-flex-' + b + a;

            case 115:
              return '-webkit-' + a + '-ms-flex-item-' + a.replace(ba, '') + a;

            default:
              return '-webkit-' + a + '-ms-flex-line-pack' + a.replace('align-content', '').replace(ba, '') + a;
          }
          break;

        case 973:
        case 989:
          if (45 !== a.charCodeAt(3) || 122 === a.charCodeAt(4)) break;

        case 931:
        case 953:
          if (!0 === la.test(d)) return 115 === (b = d.substring(d.indexOf(':') + 1)).charCodeAt(0) ? P(d.replace('stretch', 'fill-available'), c, e, h).replace(':fill-available', ':stretch') : a.replace(b, '-webkit-' + b) + a.replace(b, '-moz-' + b.replace('fill-', '')) + a;
          break;

        case 962:
          if (a = '-webkit-' + a + (102 === a.charCodeAt(5) ? '-ms-' + a : '') + a, 211 === e + h && 105 === a.charCodeAt(13) && 0 < a.indexOf('transform', 10)) return a.substring(0, a.indexOf(';', 27) + 1).replace(ma, '$1-webkit-$2') + a;
      }

      return a;
    }

    function L(d, c) {
      var e = d.indexOf(1 === c ? ':' : '{'),
          h = d.substring(0, 3 !== c ? e : 10);
      e = d.substring(e + 1, d.length - 1);
      return R(2 !== c ? h : h.replace(na, '$1'), e, c);
    }

    function ea(d, c) {
      var e = P(c, c.charCodeAt(0), c.charCodeAt(1), c.charCodeAt(2));
      return e !== c + ';' ? e.replace(oa, ' or ($1)').substring(4) : '(' + c + ')';
    }

    function H(d, c, e, h, a, m, b, v, n, q) {
      for (var g = 0, x = c, w; g < A; ++g) {
        switch (w = S[g].call(B, d, x, e, h, a, m, b, v, n, q)) {
          case void 0:
          case !1:
          case !0:
          case null:
            break;

          default:
            x = w;
        }
      }

      if (x !== c) return x;
    }

    function T(d) {
      switch (d) {
        case void 0:
        case null:
          A = S.length = 0;
          break;

        default:
          switch (d.constructor) {
            case Array:
              for (var c = 0, e = d.length; c < e; ++c) {
                T(d[c]);
              }

              break;

            case Function:
              S[A++] = d;
              break;

            case Boolean:
              Y = !!d | 0;
          }

      }

      return T;
    }

    function U(d) {
      d = d.prefix;
      void 0 !== d && (R = null, d ? 'function' !== typeof d ? w = 1 : (w = 2, R = d) : w = 0);
      return U;
    }

    function B(d, c) {
      var e = d;
      33 > e.charCodeAt(0) && (e = e.trim());
      V = e;
      e = [V];

      if (0 < A) {
        var h = H(-1, c, e, e, D, z, 0, 0, 0, 0);
        void 0 !== h && 'string' === typeof h && (c = h);
      }

      var a = M(O, e, c, 0, 0);
      0 < A && (h = H(-2, a, e, e, D, z, a.length, 0, 0, 0), void 0 !== h && (a = h));
      V = '';
      E = 0;
      z = D = 1;
      return a;
    }

    var ca = /^\0+/g,
        N = /[\0\r\f]/g,
        aa = /: */g,
        ka = /zoo|gra/,
        ma = /([,: ])(transform)/g,
        ia = /,\r+?/g,
        F = /([\t\r\n ])*\f?&/g,
        fa = /@(k\w+)\s*(\S*)\s*/,
        Q = /::(place)/g,
        ha = /:(read-only)/g,
        G = /[svh]\w+-[tblr]{2}/,
        da = /\(\s*(.*)\s*\)/g,
        oa = /([\s\S]*?);/g,
        ba = /-self|flex-/g,
        na = /[^]*?(:[rp][el]a[\w-]+)[^]*/,
        la = /stretch|:\s*\w+\-(?:conte|avail)/,
        ja = /([^-])(image-set\()/,
        z = 1,
        D = 1,
        E = 0,
        w = 1,
        O = [],
        S = [],
        A = 0,
        R = null,
        Y = 0,
        V = '';
    B.use = T;
    B.set = U;
    void 0 !== W && U(W);
    return B;
  }

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var stylisRuleSheet = createCommonjsModule(function (module, exports) {
  (function (factory) {
  	 (module['exports'] = factory()) ;
  }(function () {

  	return function (insertRule) {
  		var delimiter = '/*|*/';
  		var needle = delimiter+'}';

  		function toSheet (block) {
  			if (block)
  				try {
  					insertRule(block + '}');
  				} catch (e) {}
  		}

  		return function ruleSheet (context, content, selectors, parents, line, column, length, ns, depth, at) {
  			switch (context) {
  				// property
  				case 1:
  					// @import
  					if (depth === 0 && content.charCodeAt(0) === 64)
  						return insertRule(content+';'), ''
  					break
  				// selector
  				case 2:
  					if (ns === 0)
  						return content + delimiter
  					break
  				// at-rule
  				case 3:
  					switch (ns) {
  						// @font-face, @page
  						case 102:
  						case 112:
  							return insertRule(selectors[0]+content), ''
  						default:
  							return content + (at === 0 ? delimiter : '')
  					}
  				case -2:
  					content.split(needle).forEach(toSheet);
  			}
  		}
  	}
  }));
  });

  var hyphenateRegex = /[A-Z]|^ms/g;
  var processStyleName = memoize(function (styleName) {
    return styleName.replace(hyphenateRegex, '-$&').toLowerCase();
  });
  var processStyleValue = function processStyleValue(key, value) {
    if (value == null || typeof value === 'boolean') {
      return '';
    }

    if (unitlessKeys[key] !== 1 && key.charCodeAt(1) !== 45 && // custom properties
    !isNaN(value) && value !== 0) {
      return value + 'px';
    }

    return value;
  };

  {
    var contentValuePattern = /(attr|calc|counters?|url)\(/;
    var contentValues = ['normal', 'none', 'counter', 'open-quote', 'close-quote', 'no-open-quote', 'no-close-quote', 'initial', 'inherit', 'unset'];
    var oldProcessStyleValue = processStyleValue;

    processStyleValue = function processStyleValue(key, value) {
      if (key === 'content') {
        if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
          console.error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
        }
      }

      return oldProcessStyleValue(key, value);
    };
  }

  var classnames = function classnames(args) {
    var len = args.length;
    var i = 0;
    var cls = '';

    for (; i < len; i++) {
      var arg = args[i];
      if (arg == null) continue;
      var toAdd = void 0;

      switch (typeof arg) {
        case 'boolean':
          break;

        case 'function':
          {
            console.error('Passing functions to cx is deprecated and will be removed in the next major version of Emotion.\n' + 'Please call the function before passing it to cx.');
          }

          toAdd = classnames([arg()]);
          break;

        case 'object':
          {
            if (Array.isArray(arg)) {
              toAdd = classnames(arg);
            } else {
              toAdd = '';

              for (var k in arg) {
                if (arg[k] && k) {
                  toAdd && (toAdd += ' ');
                  toAdd += k;
                }
              }
            }

            break;
          }

        default:
          {
            toAdd = arg;
          }
      }

      if (toAdd) {
        cls && (cls += ' ');
        cls += toAdd;
      }
    }

    return cls;
  };
  var isBrowser = typeof document !== 'undefined';

  /*

  high performance StyleSheet for css-in-js systems

  - uses multiple style tags behind the scenes for millions of rules
  - uses `insertRule` for appending in production for *much* faster performance
  - 'polyfills' on server side

  // usage

  import StyleSheet from 'glamor/lib/sheet'
  let styleSheet = new StyleSheet()

  styleSheet.inject()
  - 'injects' the stylesheet into the page (or into memory if on server)

  styleSheet.insert('#box { border: 1px solid red; }')
  - appends a css rule into the stylesheet

  styleSheet.flush()
  - empties the stylesheet of all its contents

  */
  // $FlowFixMe
  function sheetForTag(tag) {
    if (tag.sheet) {
      // $FlowFixMe
      return tag.sheet;
    } // this weirdness brought to you by firefox


    for (var i = 0; i < document.styleSheets.length; i++) {
      if (document.styleSheets[i].ownerNode === tag) {
        // $FlowFixMe
        return document.styleSheets[i];
      }
    }
  }

  function makeStyleTag(opts) {
    var tag = document.createElement('style');
    tag.setAttribute('data-emotion', opts.key || '');

    if (opts.nonce !== undefined) {
      tag.setAttribute('nonce', opts.nonce);
    }

    tag.appendChild(document.createTextNode('')) // $FlowFixMe
    ;
    (opts.container !== undefined ? opts.container : document.head).appendChild(tag);
    return tag;
  }

  var StyleSheet =
  /*#__PURE__*/
  function () {
    function StyleSheet(options) {
      this.isSpeedy = 'development' === 'production'; // the big drawback here is that the css won't be editable in devtools

      this.tags = [];
      this.ctr = 0;
      this.opts = options;
    }

    var _proto = StyleSheet.prototype;

    _proto.inject = function inject() {
      if (this.injected) {
        throw new Error('already injected!');
      }

      this.tags[0] = makeStyleTag(this.opts);
      this.injected = true;
    };

    _proto.speedy = function speedy(bool) {
      if (this.ctr !== 0) {
        // cannot change speedy mode after inserting any rule to sheet. Either call speedy(${bool}) earlier in your app, or call flush() before speedy(${bool})
        throw new Error("cannot change speedy now");
      }

      this.isSpeedy = !!bool;
    };

    _proto.insert = function insert(rule, sourceMap) {
      // this is the ultrafast version, works across browsers
      if (this.isSpeedy) {
        var tag = this.tags[this.tags.length - 1];
        var sheet = sheetForTag(tag);

        try {
          sheet.insertRule(rule, sheet.cssRules.length);
        } catch (e) {
          {
            console.warn('illegal rule', rule); // eslint-disable-line no-console
          }
        }
      } else {
        var _tag = makeStyleTag(this.opts);

        this.tags.push(_tag);

        _tag.appendChild(document.createTextNode(rule + (sourceMap || '')));
      }

      this.ctr++;

      if (this.ctr % 65000 === 0) {
        this.tags.push(makeStyleTag(this.opts));
      }
    };

    _proto.flush = function flush() {
      // $FlowFixMe
      this.tags.forEach(function (tag) {
        return tag.parentNode.removeChild(tag);
      });
      this.tags = [];
      this.ctr = 0; // todo - look for remnants in document.styleSheets

      this.injected = false;
    };

    return StyleSheet;
  }();

  function createEmotion(context, options) {
    if (context.__SECRET_EMOTION__ !== undefined) {
      return context.__SECRET_EMOTION__;
    }

    if (options === undefined) options = {};
    var key = options.key || 'css';

    {
      if (/[^a-z-]/.test(key)) {
        throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
      }
    }

    var current;

    function insertRule(rule) {
      current += rule;

      if (isBrowser) {
        sheet.insert(rule, currentSourceMap);
      }
    }

    var insertionPlugin = stylisRuleSheet(insertRule);
    var stylisOptions;

    if (options.prefix !== undefined) {
      stylisOptions = {
        prefix: options.prefix
      };
    }

    var caches = {
      registered: {},
      inserted: {},
      nonce: options.nonce,
      key: key
    };
    var sheet = new StyleSheet(options);

    if (isBrowser) {
      // 🚀
      sheet.inject();
    }

    var stylis = new stylis_min(stylisOptions);
    stylis.use(options.stylisPlugins)(insertionPlugin);
    var currentSourceMap = '';

    function handleInterpolation(interpolation, couldBeSelectorInterpolation) {
      if (interpolation == null) {
        return '';
      }

      switch (typeof interpolation) {
        case 'boolean':
          return '';

        case 'function':
          if (interpolation.__emotion_styles !== undefined) {
            var selector = interpolation.toString();

            if (selector === 'NO_COMPONENT_SELECTOR' && 'development' !== 'production') {
              throw new Error('Component selectors can only be used in conjunction with babel-plugin-emotion.');
            }

            return selector;
          }

          if (this === undefined && 'development' !== 'production') {
            console.error('Interpolating functions in css calls is deprecated and will be removed in the next major version of Emotion.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
          }

          return handleInterpolation.call(this, this === undefined ? interpolation() : // $FlowFixMe
          interpolation(this.mergedProps, this.context), couldBeSelectorInterpolation);

        case 'object':
          return createStringFromObject.call(this, interpolation);

        default:
          var cached = caches.registered[interpolation];
          return couldBeSelectorInterpolation === false && cached !== undefined ? cached : interpolation;
      }
    }

    var objectToStringCache = new WeakMap();

    function createStringFromObject(obj) {
      if (objectToStringCache.has(obj)) {
        // $FlowFixMe
        return objectToStringCache.get(obj);
      }

      var string = '';

      if (Array.isArray(obj)) {
        obj.forEach(function (interpolation) {
          string += handleInterpolation.call(this, interpolation, false);
        }, this);
      } else {
        Object.keys(obj).forEach(function (key) {
          if (typeof obj[key] !== 'object') {
            if (caches.registered[obj[key]] !== undefined) {
              string += key + "{" + caches.registered[obj[key]] + "}";
            } else {
              string += processStyleName(key) + ":" + processStyleValue(key, obj[key]) + ";";
            }
          } else {
            if (key === 'NO_COMPONENT_SELECTOR' && 'development' !== 'production') {
              throw new Error('Component selectors can only be used in conjunction with babel-plugin-emotion.');
            }

            if (Array.isArray(obj[key]) && typeof obj[key][0] === 'string' && caches.registered[obj[key][0]] === undefined) {
              obj[key].forEach(function (value) {
                string += processStyleName(key) + ":" + processStyleValue(key, value) + ";";
              });
            } else {
              string += key + "{" + handleInterpolation.call(this, obj[key], false) + "}";
            }
          }
        }, this);
      }

      objectToStringCache.set(obj, string);
      return string;
    }

    var name;
    var stylesWithLabel;
    var labelPattern = /label:\s*([^\s;\n{]+)\s*;/g;

    var createClassName = function createClassName(styles, identifierName) {
      return murmurhash2_32_gc(styles + identifierName) + identifierName;
    };

    {
      var oldCreateClassName = createClassName;
      var sourceMappingUrlPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g;

      createClassName = function createClassName(styles, identifierName) {
        return oldCreateClassName(styles.replace(sourceMappingUrlPattern, function (sourceMap) {
          currentSourceMap = sourceMap;
          return '';
        }), identifierName);
      };
    }

    var createStyles = function createStyles(strings) {
      var stringMode = true;
      var styles = '';
      var identifierName = '';

      if (strings == null || strings.raw === undefined) {
        stringMode = false;
        styles += handleInterpolation.call(this, strings, false);
      } else {
        styles += strings[0];
      }

      for (var _len = arguments.length, interpolations = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        interpolations[_key - 1] = arguments[_key];
      }

      interpolations.forEach(function (interpolation, i) {
        styles += handleInterpolation.call(this, interpolation, styles.charCodeAt(styles.length - 1) === 46 // .
        );

        if (stringMode === true && strings[i + 1] !== undefined) {
          styles += strings[i + 1];
        }
      }, this);
      stylesWithLabel = styles;
      styles = styles.replace(labelPattern, function (match, p1) {
        identifierName += "-" + p1;
        return '';
      });
      name = createClassName(styles, identifierName);
      return styles;
    };

    {
      var oldStylis = stylis;

      stylis = function stylis(selector, styles) {
        oldStylis(selector, styles);
        currentSourceMap = '';
      };
    }

    function insert(scope, styles) {
      if (caches.inserted[name] === undefined) {
        current = '';
        stylis(scope, styles);
        caches.inserted[name] = current;
      }
    }

    var css = function css() {
      var styles = createStyles.apply(this, arguments);
      var selector = key + "-" + name;

      if (caches.registered[selector] === undefined) {
        caches.registered[selector] = stylesWithLabel;
      }

      insert("." + selector, styles);
      return selector;
    };

    var keyframes = function keyframes() {
      var styles = createStyles.apply(this, arguments);
      var animation = "animation-" + name;
      insert('', "@keyframes " + animation + "{" + styles + "}");
      return animation;
    };

    var injectGlobal = function injectGlobal() {
      var styles = createStyles.apply(this, arguments);
      insert('', styles);
    };

    function getRegisteredStyles(registeredStyles, classNames) {
      var rawClassName = '';
      classNames.split(' ').forEach(function (className) {
        if (caches.registered[className] !== undefined) {
          registeredStyles.push(className);
        } else {
          rawClassName += className + " ";
        }
      });
      return rawClassName;
    }

    function merge(className, sourceMap) {
      var registeredStyles = [];
      var rawClassName = getRegisteredStyles(registeredStyles, className);

      if (registeredStyles.length < 2) {
        return className;
      }

      return rawClassName + css(registeredStyles, sourceMap);
    }

    function cx() {
      for (var _len2 = arguments.length, classNames = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        classNames[_key2] = arguments[_key2];
      }

      return merge(classnames(classNames));
    }

    function hydrateSingleId(id) {
      caches.inserted[id] = true;
    }

    function hydrate(ids) {
      ids.forEach(hydrateSingleId);
    }

    function flush() {
      if (isBrowser) {
        sheet.flush();
        sheet.inject();
      }

      caches.inserted = {};
      caches.registered = {};
    }

    if (isBrowser) {
      var chunks = document.querySelectorAll("[data-emotion-" + key + "]");
      Array.prototype.forEach.call(chunks, function (node) {
        // $FlowFixMe
        sheet.tags[0].parentNode.insertBefore(node, sheet.tags[0]); // $FlowFixMe

        node.getAttribute("data-emotion-" + key).split(' ').forEach(hydrateSingleId);
      });
    }

    var emotion = {
      flush: flush,
      hydrate: hydrate,
      cx: cx,
      merge: merge,
      getRegisteredStyles: getRegisteredStyles,
      injectGlobal: injectGlobal,
      keyframes: keyframes,
      css: css,
      sheet: sheet,
      caches: caches
    };
    context.__SECRET_EMOTION__ = emotion;
    return emotion;
  }

  var context = typeof global !== 'undefined' ? global : {};

  var _createEmotion = createEmotion(context),
      flush = _createEmotion.flush,
      hydrate = _createEmotion.hydrate,
      cx = _createEmotion.cx,
      merge = _createEmotion.merge,
      getRegisteredStyles = _createEmotion.getRegisteredStyles,
      injectGlobal = _createEmotion.injectGlobal,
      keyframes = _createEmotion.keyframes,
      css = _createEmotion.css,
      sheet = _createEmotion.sheet,
      caches = _createEmotion.caches;

  /**
   * Special language-specific overrides.
   *
   * Source: ftp://ftp.unicode.org/Public/UCD/latest/ucd/SpecialCasing.txt
   *
   * @type {Object}
   */
  var LANGUAGES = {
    tr: {
      regexp: /[\u0069]/g,
      map: {
        '\u0069': '\u0130'
      }
    },
    az: {
      regexp: /[\u0069]/g,
      map: {
        '\u0069': '\u0130'
      }
    },
    lt: {
      regexp: /[\u0069\u006A\u012F]\u0307|\u0069\u0307[\u0300\u0301\u0303]/g,
      map: {
        '\u0069\u0307': '\u0049',
        '\u006A\u0307': '\u004A',
        '\u012F\u0307': '\u012E',
        '\u0069\u0307\u0300': '\u00CC',
        '\u0069\u0307\u0301': '\u00CD',
        '\u0069\u0307\u0303': '\u0128'
      }
    }
  };

  /**
   * Upper case a string.
   *
   * @param  {String} str
   * @return {String}
   */
  var upperCase = function (str, locale) {
    var lang = LANGUAGES[locale];

    str = str == null ? '' : String(str);

    if (lang) {
      str = str.replace(lang.regexp, function (m) { return lang.map[m] });
    }

    return str.toUpperCase()
  };

  /**
   * Special language-specific overrides.
   *
   * Source: ftp://ftp.unicode.org/Public/UCD/latest/ucd/SpecialCasing.txt
   *
   * @type {Object}
   */
  var LANGUAGES$1 = {
    tr: {
      regexp: /\u0130|\u0049|\u0049\u0307/g,
      map: {
        '\u0130': '\u0069',
        '\u0049': '\u0131',
        '\u0049\u0307': '\u0069'
      }
    },
    az: {
      regexp: /[\u0130]/g,
      map: {
        '\u0130': '\u0069',
        '\u0049': '\u0131',
        '\u0049\u0307': '\u0069'
      }
    },
    lt: {
      regexp: /[\u0049\u004A\u012E\u00CC\u00CD\u0128]/g,
      map: {
        '\u0049': '\u0069\u0307',
        '\u004A': '\u006A\u0307',
        '\u012E': '\u012F\u0307',
        '\u00CC': '\u0069\u0307\u0300',
        '\u00CD': '\u0069\u0307\u0301',
        '\u0128': '\u0069\u0307\u0303'
      }
    }
  };

  /**
   * Lowercase a string.
   *
   * @param  {String} str
   * @return {String}
   */
  var lowerCase = function (str, locale) {
    var lang = LANGUAGES$1[locale];

    str = str == null ? '' : String(str);

    if (lang) {
      str = str.replace(lang.regexp, function (m) { return lang.map[m] });
    }

    return str.toLowerCase()
  };

  var nonWordRegexp = /[^A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AD\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC0-9\xB2\xB3\xB9\xBC-\xBE\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u09F4-\u09F9\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0B72-\u0B77\u0BE6-\u0BF2\u0C66-\u0C6F\u0C78-\u0C7E\u0CE6-\u0CEF\u0D66-\u0D75\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F33\u1040-\u1049\u1090-\u1099\u1369-\u137C\u16EE-\u16F0\u17E0-\u17E9\u17F0-\u17F9\u1810-\u1819\u1946-\u194F\u19D0-\u19DA\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\u2070\u2074-\u2079\u2080-\u2089\u2150-\u2182\u2185-\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2CFD\u3007\u3021-\u3029\u3038-\u303A\u3192-\u3195\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\uA620-\uA629\uA6E6-\uA6EF\uA830-\uA835\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19]+/g;

  var camelCaseRegexp = /([a-z\xB5\xDF-\xF6\xF8-\xFF\u0101\u0103\u0105\u0107\u0109\u010B\u010D\u010F\u0111\u0113\u0115\u0117\u0119\u011B\u011D\u011F\u0121\u0123\u0125\u0127\u0129\u012B\u012D\u012F\u0131\u0133\u0135\u0137\u0138\u013A\u013C\u013E\u0140\u0142\u0144\u0146\u0148\u0149\u014B\u014D\u014F\u0151\u0153\u0155\u0157\u0159\u015B\u015D\u015F\u0161\u0163\u0165\u0167\u0169\u016B\u016D\u016F\u0171\u0173\u0175\u0177\u017A\u017C\u017E-\u0180\u0183\u0185\u0188\u018C\u018D\u0192\u0195\u0199-\u019B\u019E\u01A1\u01A3\u01A5\u01A8\u01AA\u01AB\u01AD\u01B0\u01B4\u01B6\u01B9\u01BA\u01BD-\u01BF\u01C6\u01C9\u01CC\u01CE\u01D0\u01D2\u01D4\u01D6\u01D8\u01DA\u01DC\u01DD\u01DF\u01E1\u01E3\u01E5\u01E7\u01E9\u01EB\u01ED\u01EF\u01F0\u01F3\u01F5\u01F9\u01FB\u01FD\u01FF\u0201\u0203\u0205\u0207\u0209\u020B\u020D\u020F\u0211\u0213\u0215\u0217\u0219\u021B\u021D\u021F\u0221\u0223\u0225\u0227\u0229\u022B\u022D\u022F\u0231\u0233-\u0239\u023C\u023F\u0240\u0242\u0247\u0249\u024B\u024D\u024F-\u0293\u0295-\u02AF\u0371\u0373\u0377\u037B-\u037D\u0390\u03AC-\u03CE\u03D0\u03D1\u03D5-\u03D7\u03D9\u03DB\u03DD\u03DF\u03E1\u03E3\u03E5\u03E7\u03E9\u03EB\u03ED\u03EF-\u03F3\u03F5\u03F8\u03FB\u03FC\u0430-\u045F\u0461\u0463\u0465\u0467\u0469\u046B\u046D\u046F\u0471\u0473\u0475\u0477\u0479\u047B\u047D\u047F\u0481\u048B\u048D\u048F\u0491\u0493\u0495\u0497\u0499\u049B\u049D\u049F\u04A1\u04A3\u04A5\u04A7\u04A9\u04AB\u04AD\u04AF\u04B1\u04B3\u04B5\u04B7\u04B9\u04BB\u04BD\u04BF\u04C2\u04C4\u04C6\u04C8\u04CA\u04CC\u04CE\u04CF\u04D1\u04D3\u04D5\u04D7\u04D9\u04DB\u04DD\u04DF\u04E1\u04E3\u04E5\u04E7\u04E9\u04EB\u04ED\u04EF\u04F1\u04F3\u04F5\u04F7\u04F9\u04FB\u04FD\u04FF\u0501\u0503\u0505\u0507\u0509\u050B\u050D\u050F\u0511\u0513\u0515\u0517\u0519\u051B\u051D\u051F\u0521\u0523\u0525\u0527\u0529\u052B\u052D\u052F\u0561-\u0587\u13F8-\u13FD\u1D00-\u1D2B\u1D6B-\u1D77\u1D79-\u1D9A\u1E01\u1E03\u1E05\u1E07\u1E09\u1E0B\u1E0D\u1E0F\u1E11\u1E13\u1E15\u1E17\u1E19\u1E1B\u1E1D\u1E1F\u1E21\u1E23\u1E25\u1E27\u1E29\u1E2B\u1E2D\u1E2F\u1E31\u1E33\u1E35\u1E37\u1E39\u1E3B\u1E3D\u1E3F\u1E41\u1E43\u1E45\u1E47\u1E49\u1E4B\u1E4D\u1E4F\u1E51\u1E53\u1E55\u1E57\u1E59\u1E5B\u1E5D\u1E5F\u1E61\u1E63\u1E65\u1E67\u1E69\u1E6B\u1E6D\u1E6F\u1E71\u1E73\u1E75\u1E77\u1E79\u1E7B\u1E7D\u1E7F\u1E81\u1E83\u1E85\u1E87\u1E89\u1E8B\u1E8D\u1E8F\u1E91\u1E93\u1E95-\u1E9D\u1E9F\u1EA1\u1EA3\u1EA5\u1EA7\u1EA9\u1EAB\u1EAD\u1EAF\u1EB1\u1EB3\u1EB5\u1EB7\u1EB9\u1EBB\u1EBD\u1EBF\u1EC1\u1EC3\u1EC5\u1EC7\u1EC9\u1ECB\u1ECD\u1ECF\u1ED1\u1ED3\u1ED5\u1ED7\u1ED9\u1EDB\u1EDD\u1EDF\u1EE1\u1EE3\u1EE5\u1EE7\u1EE9\u1EEB\u1EED\u1EEF\u1EF1\u1EF3\u1EF5\u1EF7\u1EF9\u1EFB\u1EFD\u1EFF-\u1F07\u1F10-\u1F15\u1F20-\u1F27\u1F30-\u1F37\u1F40-\u1F45\u1F50-\u1F57\u1F60-\u1F67\u1F70-\u1F7D\u1F80-\u1F87\u1F90-\u1F97\u1FA0-\u1FA7\u1FB0-\u1FB4\u1FB6\u1FB7\u1FBE\u1FC2-\u1FC4\u1FC6\u1FC7\u1FD0-\u1FD3\u1FD6\u1FD7\u1FE0-\u1FE7\u1FF2-\u1FF4\u1FF6\u1FF7\u210A\u210E\u210F\u2113\u212F\u2134\u2139\u213C\u213D\u2146-\u2149\u214E\u2184\u2C30-\u2C5E\u2C61\u2C65\u2C66\u2C68\u2C6A\u2C6C\u2C71\u2C73\u2C74\u2C76-\u2C7B\u2C81\u2C83\u2C85\u2C87\u2C89\u2C8B\u2C8D\u2C8F\u2C91\u2C93\u2C95\u2C97\u2C99\u2C9B\u2C9D\u2C9F\u2CA1\u2CA3\u2CA5\u2CA7\u2CA9\u2CAB\u2CAD\u2CAF\u2CB1\u2CB3\u2CB5\u2CB7\u2CB9\u2CBB\u2CBD\u2CBF\u2CC1\u2CC3\u2CC5\u2CC7\u2CC9\u2CCB\u2CCD\u2CCF\u2CD1\u2CD3\u2CD5\u2CD7\u2CD9\u2CDB\u2CDD\u2CDF\u2CE1\u2CE3\u2CE4\u2CEC\u2CEE\u2CF3\u2D00-\u2D25\u2D27\u2D2D\uA641\uA643\uA645\uA647\uA649\uA64B\uA64D\uA64F\uA651\uA653\uA655\uA657\uA659\uA65B\uA65D\uA65F\uA661\uA663\uA665\uA667\uA669\uA66B\uA66D\uA681\uA683\uA685\uA687\uA689\uA68B\uA68D\uA68F\uA691\uA693\uA695\uA697\uA699\uA69B\uA723\uA725\uA727\uA729\uA72B\uA72D\uA72F-\uA731\uA733\uA735\uA737\uA739\uA73B\uA73D\uA73F\uA741\uA743\uA745\uA747\uA749\uA74B\uA74D\uA74F\uA751\uA753\uA755\uA757\uA759\uA75B\uA75D\uA75F\uA761\uA763\uA765\uA767\uA769\uA76B\uA76D\uA76F\uA771-\uA778\uA77A\uA77C\uA77F\uA781\uA783\uA785\uA787\uA78C\uA78E\uA791\uA793-\uA795\uA797\uA799\uA79B\uA79D\uA79F\uA7A1\uA7A3\uA7A5\uA7A7\uA7A9\uA7B5\uA7B7\uA7FA\uAB30-\uAB5A\uAB60-\uAB65\uAB70-\uABBF\uFB00-\uFB06\uFB13-\uFB17\uFF41-\uFF5A0-9\xB2\xB3\xB9\xBC-\xBE\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u09F4-\u09F9\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0B72-\u0B77\u0BE6-\u0BF2\u0C66-\u0C6F\u0C78-\u0C7E\u0CE6-\u0CEF\u0D66-\u0D75\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F33\u1040-\u1049\u1090-\u1099\u1369-\u137C\u16EE-\u16F0\u17E0-\u17E9\u17F0-\u17F9\u1810-\u1819\u1946-\u194F\u19D0-\u19DA\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\u2070\u2074-\u2079\u2080-\u2089\u2150-\u2182\u2185-\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2CFD\u3007\u3021-\u3029\u3038-\u303A\u3192-\u3195\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\uA620-\uA629\uA6E6-\uA6EF\uA830-\uA835\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19])([A-Z\xC0-\xD6\xD8-\xDE\u0100\u0102\u0104\u0106\u0108\u010A\u010C\u010E\u0110\u0112\u0114\u0116\u0118\u011A\u011C\u011E\u0120\u0122\u0124\u0126\u0128\u012A\u012C\u012E\u0130\u0132\u0134\u0136\u0139\u013B\u013D\u013F\u0141\u0143\u0145\u0147\u014A\u014C\u014E\u0150\u0152\u0154\u0156\u0158\u015A\u015C\u015E\u0160\u0162\u0164\u0166\u0168\u016A\u016C\u016E\u0170\u0172\u0174\u0176\u0178\u0179\u017B\u017D\u0181\u0182\u0184\u0186\u0187\u0189-\u018B\u018E-\u0191\u0193\u0194\u0196-\u0198\u019C\u019D\u019F\u01A0\u01A2\u01A4\u01A6\u01A7\u01A9\u01AC\u01AE\u01AF\u01B1-\u01B3\u01B5\u01B7\u01B8\u01BC\u01C4\u01C7\u01CA\u01CD\u01CF\u01D1\u01D3\u01D5\u01D7\u01D9\u01DB\u01DE\u01E0\u01E2\u01E4\u01E6\u01E8\u01EA\u01EC\u01EE\u01F1\u01F4\u01F6-\u01F8\u01FA\u01FC\u01FE\u0200\u0202\u0204\u0206\u0208\u020A\u020C\u020E\u0210\u0212\u0214\u0216\u0218\u021A\u021C\u021E\u0220\u0222\u0224\u0226\u0228\u022A\u022C\u022E\u0230\u0232\u023A\u023B\u023D\u023E\u0241\u0243-\u0246\u0248\u024A\u024C\u024E\u0370\u0372\u0376\u037F\u0386\u0388-\u038A\u038C\u038E\u038F\u0391-\u03A1\u03A3-\u03AB\u03CF\u03D2-\u03D4\u03D8\u03DA\u03DC\u03DE\u03E0\u03E2\u03E4\u03E6\u03E8\u03EA\u03EC\u03EE\u03F4\u03F7\u03F9\u03FA\u03FD-\u042F\u0460\u0462\u0464\u0466\u0468\u046A\u046C\u046E\u0470\u0472\u0474\u0476\u0478\u047A\u047C\u047E\u0480\u048A\u048C\u048E\u0490\u0492\u0494\u0496\u0498\u049A\u049C\u049E\u04A0\u04A2\u04A4\u04A6\u04A8\u04AA\u04AC\u04AE\u04B0\u04B2\u04B4\u04B6\u04B8\u04BA\u04BC\u04BE\u04C0\u04C1\u04C3\u04C5\u04C7\u04C9\u04CB\u04CD\u04D0\u04D2\u04D4\u04D6\u04D8\u04DA\u04DC\u04DE\u04E0\u04E2\u04E4\u04E6\u04E8\u04EA\u04EC\u04EE\u04F0\u04F2\u04F4\u04F6\u04F8\u04FA\u04FC\u04FE\u0500\u0502\u0504\u0506\u0508\u050A\u050C\u050E\u0510\u0512\u0514\u0516\u0518\u051A\u051C\u051E\u0520\u0522\u0524\u0526\u0528\u052A\u052C\u052E\u0531-\u0556\u10A0-\u10C5\u10C7\u10CD\u13A0-\u13F5\u1E00\u1E02\u1E04\u1E06\u1E08\u1E0A\u1E0C\u1E0E\u1E10\u1E12\u1E14\u1E16\u1E18\u1E1A\u1E1C\u1E1E\u1E20\u1E22\u1E24\u1E26\u1E28\u1E2A\u1E2C\u1E2E\u1E30\u1E32\u1E34\u1E36\u1E38\u1E3A\u1E3C\u1E3E\u1E40\u1E42\u1E44\u1E46\u1E48\u1E4A\u1E4C\u1E4E\u1E50\u1E52\u1E54\u1E56\u1E58\u1E5A\u1E5C\u1E5E\u1E60\u1E62\u1E64\u1E66\u1E68\u1E6A\u1E6C\u1E6E\u1E70\u1E72\u1E74\u1E76\u1E78\u1E7A\u1E7C\u1E7E\u1E80\u1E82\u1E84\u1E86\u1E88\u1E8A\u1E8C\u1E8E\u1E90\u1E92\u1E94\u1E9E\u1EA0\u1EA2\u1EA4\u1EA6\u1EA8\u1EAA\u1EAC\u1EAE\u1EB0\u1EB2\u1EB4\u1EB6\u1EB8\u1EBA\u1EBC\u1EBE\u1EC0\u1EC2\u1EC4\u1EC6\u1EC8\u1ECA\u1ECC\u1ECE\u1ED0\u1ED2\u1ED4\u1ED6\u1ED8\u1EDA\u1EDC\u1EDE\u1EE0\u1EE2\u1EE4\u1EE6\u1EE8\u1EEA\u1EEC\u1EEE\u1EF0\u1EF2\u1EF4\u1EF6\u1EF8\u1EFA\u1EFC\u1EFE\u1F08-\u1F0F\u1F18-\u1F1D\u1F28-\u1F2F\u1F38-\u1F3F\u1F48-\u1F4D\u1F59\u1F5B\u1F5D\u1F5F\u1F68-\u1F6F\u1FB8-\u1FBB\u1FC8-\u1FCB\u1FD8-\u1FDB\u1FE8-\u1FEC\u1FF8-\u1FFB\u2102\u2107\u210B-\u210D\u2110-\u2112\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u2130-\u2133\u213E\u213F\u2145\u2183\u2C00-\u2C2E\u2C60\u2C62-\u2C64\u2C67\u2C69\u2C6B\u2C6D-\u2C70\u2C72\u2C75\u2C7E-\u2C80\u2C82\u2C84\u2C86\u2C88\u2C8A\u2C8C\u2C8E\u2C90\u2C92\u2C94\u2C96\u2C98\u2C9A\u2C9C\u2C9E\u2CA0\u2CA2\u2CA4\u2CA6\u2CA8\u2CAA\u2CAC\u2CAE\u2CB0\u2CB2\u2CB4\u2CB6\u2CB8\u2CBA\u2CBC\u2CBE\u2CC0\u2CC2\u2CC4\u2CC6\u2CC8\u2CCA\u2CCC\u2CCE\u2CD0\u2CD2\u2CD4\u2CD6\u2CD8\u2CDA\u2CDC\u2CDE\u2CE0\u2CE2\u2CEB\u2CED\u2CF2\uA640\uA642\uA644\uA646\uA648\uA64A\uA64C\uA64E\uA650\uA652\uA654\uA656\uA658\uA65A\uA65C\uA65E\uA660\uA662\uA664\uA666\uA668\uA66A\uA66C\uA680\uA682\uA684\uA686\uA688\uA68A\uA68C\uA68E\uA690\uA692\uA694\uA696\uA698\uA69A\uA722\uA724\uA726\uA728\uA72A\uA72C\uA72E\uA732\uA734\uA736\uA738\uA73A\uA73C\uA73E\uA740\uA742\uA744\uA746\uA748\uA74A\uA74C\uA74E\uA750\uA752\uA754\uA756\uA758\uA75A\uA75C\uA75E\uA760\uA762\uA764\uA766\uA768\uA76A\uA76C\uA76E\uA779\uA77B\uA77D\uA77E\uA780\uA782\uA784\uA786\uA78B\uA78D\uA790\uA792\uA796\uA798\uA79A\uA79C\uA79E\uA7A0\uA7A2\uA7A4\uA7A6\uA7A8\uA7AA-\uA7AD\uA7B0-\uA7B4\uA7B6\uFF21-\uFF3A])/g;

  var camelCaseUpperRegexp = /([A-Z\xC0-\xD6\xD8-\xDE\u0100\u0102\u0104\u0106\u0108\u010A\u010C\u010E\u0110\u0112\u0114\u0116\u0118\u011A\u011C\u011E\u0120\u0122\u0124\u0126\u0128\u012A\u012C\u012E\u0130\u0132\u0134\u0136\u0139\u013B\u013D\u013F\u0141\u0143\u0145\u0147\u014A\u014C\u014E\u0150\u0152\u0154\u0156\u0158\u015A\u015C\u015E\u0160\u0162\u0164\u0166\u0168\u016A\u016C\u016E\u0170\u0172\u0174\u0176\u0178\u0179\u017B\u017D\u0181\u0182\u0184\u0186\u0187\u0189-\u018B\u018E-\u0191\u0193\u0194\u0196-\u0198\u019C\u019D\u019F\u01A0\u01A2\u01A4\u01A6\u01A7\u01A9\u01AC\u01AE\u01AF\u01B1-\u01B3\u01B5\u01B7\u01B8\u01BC\u01C4\u01C7\u01CA\u01CD\u01CF\u01D1\u01D3\u01D5\u01D7\u01D9\u01DB\u01DE\u01E0\u01E2\u01E4\u01E6\u01E8\u01EA\u01EC\u01EE\u01F1\u01F4\u01F6-\u01F8\u01FA\u01FC\u01FE\u0200\u0202\u0204\u0206\u0208\u020A\u020C\u020E\u0210\u0212\u0214\u0216\u0218\u021A\u021C\u021E\u0220\u0222\u0224\u0226\u0228\u022A\u022C\u022E\u0230\u0232\u023A\u023B\u023D\u023E\u0241\u0243-\u0246\u0248\u024A\u024C\u024E\u0370\u0372\u0376\u037F\u0386\u0388-\u038A\u038C\u038E\u038F\u0391-\u03A1\u03A3-\u03AB\u03CF\u03D2-\u03D4\u03D8\u03DA\u03DC\u03DE\u03E0\u03E2\u03E4\u03E6\u03E8\u03EA\u03EC\u03EE\u03F4\u03F7\u03F9\u03FA\u03FD-\u042F\u0460\u0462\u0464\u0466\u0468\u046A\u046C\u046E\u0470\u0472\u0474\u0476\u0478\u047A\u047C\u047E\u0480\u048A\u048C\u048E\u0490\u0492\u0494\u0496\u0498\u049A\u049C\u049E\u04A0\u04A2\u04A4\u04A6\u04A8\u04AA\u04AC\u04AE\u04B0\u04B2\u04B4\u04B6\u04B8\u04BA\u04BC\u04BE\u04C0\u04C1\u04C3\u04C5\u04C7\u04C9\u04CB\u04CD\u04D0\u04D2\u04D4\u04D6\u04D8\u04DA\u04DC\u04DE\u04E0\u04E2\u04E4\u04E6\u04E8\u04EA\u04EC\u04EE\u04F0\u04F2\u04F4\u04F6\u04F8\u04FA\u04FC\u04FE\u0500\u0502\u0504\u0506\u0508\u050A\u050C\u050E\u0510\u0512\u0514\u0516\u0518\u051A\u051C\u051E\u0520\u0522\u0524\u0526\u0528\u052A\u052C\u052E\u0531-\u0556\u10A0-\u10C5\u10C7\u10CD\u13A0-\u13F5\u1E00\u1E02\u1E04\u1E06\u1E08\u1E0A\u1E0C\u1E0E\u1E10\u1E12\u1E14\u1E16\u1E18\u1E1A\u1E1C\u1E1E\u1E20\u1E22\u1E24\u1E26\u1E28\u1E2A\u1E2C\u1E2E\u1E30\u1E32\u1E34\u1E36\u1E38\u1E3A\u1E3C\u1E3E\u1E40\u1E42\u1E44\u1E46\u1E48\u1E4A\u1E4C\u1E4E\u1E50\u1E52\u1E54\u1E56\u1E58\u1E5A\u1E5C\u1E5E\u1E60\u1E62\u1E64\u1E66\u1E68\u1E6A\u1E6C\u1E6E\u1E70\u1E72\u1E74\u1E76\u1E78\u1E7A\u1E7C\u1E7E\u1E80\u1E82\u1E84\u1E86\u1E88\u1E8A\u1E8C\u1E8E\u1E90\u1E92\u1E94\u1E9E\u1EA0\u1EA2\u1EA4\u1EA6\u1EA8\u1EAA\u1EAC\u1EAE\u1EB0\u1EB2\u1EB4\u1EB6\u1EB8\u1EBA\u1EBC\u1EBE\u1EC0\u1EC2\u1EC4\u1EC6\u1EC8\u1ECA\u1ECC\u1ECE\u1ED0\u1ED2\u1ED4\u1ED6\u1ED8\u1EDA\u1EDC\u1EDE\u1EE0\u1EE2\u1EE4\u1EE6\u1EE8\u1EEA\u1EEC\u1EEE\u1EF0\u1EF2\u1EF4\u1EF6\u1EF8\u1EFA\u1EFC\u1EFE\u1F08-\u1F0F\u1F18-\u1F1D\u1F28-\u1F2F\u1F38-\u1F3F\u1F48-\u1F4D\u1F59\u1F5B\u1F5D\u1F5F\u1F68-\u1F6F\u1FB8-\u1FBB\u1FC8-\u1FCB\u1FD8-\u1FDB\u1FE8-\u1FEC\u1FF8-\u1FFB\u2102\u2107\u210B-\u210D\u2110-\u2112\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u2130-\u2133\u213E\u213F\u2145\u2183\u2C00-\u2C2E\u2C60\u2C62-\u2C64\u2C67\u2C69\u2C6B\u2C6D-\u2C70\u2C72\u2C75\u2C7E-\u2C80\u2C82\u2C84\u2C86\u2C88\u2C8A\u2C8C\u2C8E\u2C90\u2C92\u2C94\u2C96\u2C98\u2C9A\u2C9C\u2C9E\u2CA0\u2CA2\u2CA4\u2CA6\u2CA8\u2CAA\u2CAC\u2CAE\u2CB0\u2CB2\u2CB4\u2CB6\u2CB8\u2CBA\u2CBC\u2CBE\u2CC0\u2CC2\u2CC4\u2CC6\u2CC8\u2CCA\u2CCC\u2CCE\u2CD0\u2CD2\u2CD4\u2CD6\u2CD8\u2CDA\u2CDC\u2CDE\u2CE0\u2CE2\u2CEB\u2CED\u2CF2\uA640\uA642\uA644\uA646\uA648\uA64A\uA64C\uA64E\uA650\uA652\uA654\uA656\uA658\uA65A\uA65C\uA65E\uA660\uA662\uA664\uA666\uA668\uA66A\uA66C\uA680\uA682\uA684\uA686\uA688\uA68A\uA68C\uA68E\uA690\uA692\uA694\uA696\uA698\uA69A\uA722\uA724\uA726\uA728\uA72A\uA72C\uA72E\uA732\uA734\uA736\uA738\uA73A\uA73C\uA73E\uA740\uA742\uA744\uA746\uA748\uA74A\uA74C\uA74E\uA750\uA752\uA754\uA756\uA758\uA75A\uA75C\uA75E\uA760\uA762\uA764\uA766\uA768\uA76A\uA76C\uA76E\uA779\uA77B\uA77D\uA77E\uA780\uA782\uA784\uA786\uA78B\uA78D\uA790\uA792\uA796\uA798\uA79A\uA79C\uA79E\uA7A0\uA7A2\uA7A4\uA7A6\uA7A8\uA7AA-\uA7AD\uA7B0-\uA7B4\uA7B6\uFF21-\uFF3A])([A-Z\xC0-\xD6\xD8-\xDE\u0100\u0102\u0104\u0106\u0108\u010A\u010C\u010E\u0110\u0112\u0114\u0116\u0118\u011A\u011C\u011E\u0120\u0122\u0124\u0126\u0128\u012A\u012C\u012E\u0130\u0132\u0134\u0136\u0139\u013B\u013D\u013F\u0141\u0143\u0145\u0147\u014A\u014C\u014E\u0150\u0152\u0154\u0156\u0158\u015A\u015C\u015E\u0160\u0162\u0164\u0166\u0168\u016A\u016C\u016E\u0170\u0172\u0174\u0176\u0178\u0179\u017B\u017D\u0181\u0182\u0184\u0186\u0187\u0189-\u018B\u018E-\u0191\u0193\u0194\u0196-\u0198\u019C\u019D\u019F\u01A0\u01A2\u01A4\u01A6\u01A7\u01A9\u01AC\u01AE\u01AF\u01B1-\u01B3\u01B5\u01B7\u01B8\u01BC\u01C4\u01C7\u01CA\u01CD\u01CF\u01D1\u01D3\u01D5\u01D7\u01D9\u01DB\u01DE\u01E0\u01E2\u01E4\u01E6\u01E8\u01EA\u01EC\u01EE\u01F1\u01F4\u01F6-\u01F8\u01FA\u01FC\u01FE\u0200\u0202\u0204\u0206\u0208\u020A\u020C\u020E\u0210\u0212\u0214\u0216\u0218\u021A\u021C\u021E\u0220\u0222\u0224\u0226\u0228\u022A\u022C\u022E\u0230\u0232\u023A\u023B\u023D\u023E\u0241\u0243-\u0246\u0248\u024A\u024C\u024E\u0370\u0372\u0376\u037F\u0386\u0388-\u038A\u038C\u038E\u038F\u0391-\u03A1\u03A3-\u03AB\u03CF\u03D2-\u03D4\u03D8\u03DA\u03DC\u03DE\u03E0\u03E2\u03E4\u03E6\u03E8\u03EA\u03EC\u03EE\u03F4\u03F7\u03F9\u03FA\u03FD-\u042F\u0460\u0462\u0464\u0466\u0468\u046A\u046C\u046E\u0470\u0472\u0474\u0476\u0478\u047A\u047C\u047E\u0480\u048A\u048C\u048E\u0490\u0492\u0494\u0496\u0498\u049A\u049C\u049E\u04A0\u04A2\u04A4\u04A6\u04A8\u04AA\u04AC\u04AE\u04B0\u04B2\u04B4\u04B6\u04B8\u04BA\u04BC\u04BE\u04C0\u04C1\u04C3\u04C5\u04C7\u04C9\u04CB\u04CD\u04D0\u04D2\u04D4\u04D6\u04D8\u04DA\u04DC\u04DE\u04E0\u04E2\u04E4\u04E6\u04E8\u04EA\u04EC\u04EE\u04F0\u04F2\u04F4\u04F6\u04F8\u04FA\u04FC\u04FE\u0500\u0502\u0504\u0506\u0508\u050A\u050C\u050E\u0510\u0512\u0514\u0516\u0518\u051A\u051C\u051E\u0520\u0522\u0524\u0526\u0528\u052A\u052C\u052E\u0531-\u0556\u10A0-\u10C5\u10C7\u10CD\u13A0-\u13F5\u1E00\u1E02\u1E04\u1E06\u1E08\u1E0A\u1E0C\u1E0E\u1E10\u1E12\u1E14\u1E16\u1E18\u1E1A\u1E1C\u1E1E\u1E20\u1E22\u1E24\u1E26\u1E28\u1E2A\u1E2C\u1E2E\u1E30\u1E32\u1E34\u1E36\u1E38\u1E3A\u1E3C\u1E3E\u1E40\u1E42\u1E44\u1E46\u1E48\u1E4A\u1E4C\u1E4E\u1E50\u1E52\u1E54\u1E56\u1E58\u1E5A\u1E5C\u1E5E\u1E60\u1E62\u1E64\u1E66\u1E68\u1E6A\u1E6C\u1E6E\u1E70\u1E72\u1E74\u1E76\u1E78\u1E7A\u1E7C\u1E7E\u1E80\u1E82\u1E84\u1E86\u1E88\u1E8A\u1E8C\u1E8E\u1E90\u1E92\u1E94\u1E9E\u1EA0\u1EA2\u1EA4\u1EA6\u1EA8\u1EAA\u1EAC\u1EAE\u1EB0\u1EB2\u1EB4\u1EB6\u1EB8\u1EBA\u1EBC\u1EBE\u1EC0\u1EC2\u1EC4\u1EC6\u1EC8\u1ECA\u1ECC\u1ECE\u1ED0\u1ED2\u1ED4\u1ED6\u1ED8\u1EDA\u1EDC\u1EDE\u1EE0\u1EE2\u1EE4\u1EE6\u1EE8\u1EEA\u1EEC\u1EEE\u1EF0\u1EF2\u1EF4\u1EF6\u1EF8\u1EFA\u1EFC\u1EFE\u1F08-\u1F0F\u1F18-\u1F1D\u1F28-\u1F2F\u1F38-\u1F3F\u1F48-\u1F4D\u1F59\u1F5B\u1F5D\u1F5F\u1F68-\u1F6F\u1FB8-\u1FBB\u1FC8-\u1FCB\u1FD8-\u1FDB\u1FE8-\u1FEC\u1FF8-\u1FFB\u2102\u2107\u210B-\u210D\u2110-\u2112\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u2130-\u2133\u213E\u213F\u2145\u2183\u2C00-\u2C2E\u2C60\u2C62-\u2C64\u2C67\u2C69\u2C6B\u2C6D-\u2C70\u2C72\u2C75\u2C7E-\u2C80\u2C82\u2C84\u2C86\u2C88\u2C8A\u2C8C\u2C8E\u2C90\u2C92\u2C94\u2C96\u2C98\u2C9A\u2C9C\u2C9E\u2CA0\u2CA2\u2CA4\u2CA6\u2CA8\u2CAA\u2CAC\u2CAE\u2CB0\u2CB2\u2CB4\u2CB6\u2CB8\u2CBA\u2CBC\u2CBE\u2CC0\u2CC2\u2CC4\u2CC6\u2CC8\u2CCA\u2CCC\u2CCE\u2CD0\u2CD2\u2CD4\u2CD6\u2CD8\u2CDA\u2CDC\u2CDE\u2CE0\u2CE2\u2CEB\u2CED\u2CF2\uA640\uA642\uA644\uA646\uA648\uA64A\uA64C\uA64E\uA650\uA652\uA654\uA656\uA658\uA65A\uA65C\uA65E\uA660\uA662\uA664\uA666\uA668\uA66A\uA66C\uA680\uA682\uA684\uA686\uA688\uA68A\uA68C\uA68E\uA690\uA692\uA694\uA696\uA698\uA69A\uA722\uA724\uA726\uA728\uA72A\uA72C\uA72E\uA732\uA734\uA736\uA738\uA73A\uA73C\uA73E\uA740\uA742\uA744\uA746\uA748\uA74A\uA74C\uA74E\uA750\uA752\uA754\uA756\uA758\uA75A\uA75C\uA75E\uA760\uA762\uA764\uA766\uA768\uA76A\uA76C\uA76E\uA779\uA77B\uA77D\uA77E\uA780\uA782\uA784\uA786\uA78B\uA78D\uA790\uA792\uA796\uA798\uA79A\uA79C\uA79E\uA7A0\uA7A2\uA7A4\uA7A6\uA7A8\uA7AA-\uA7AD\uA7B0-\uA7B4\uA7B6\uFF21-\uFF3A][a-z\xB5\xDF-\xF6\xF8-\xFF\u0101\u0103\u0105\u0107\u0109\u010B\u010D\u010F\u0111\u0113\u0115\u0117\u0119\u011B\u011D\u011F\u0121\u0123\u0125\u0127\u0129\u012B\u012D\u012F\u0131\u0133\u0135\u0137\u0138\u013A\u013C\u013E\u0140\u0142\u0144\u0146\u0148\u0149\u014B\u014D\u014F\u0151\u0153\u0155\u0157\u0159\u015B\u015D\u015F\u0161\u0163\u0165\u0167\u0169\u016B\u016D\u016F\u0171\u0173\u0175\u0177\u017A\u017C\u017E-\u0180\u0183\u0185\u0188\u018C\u018D\u0192\u0195\u0199-\u019B\u019E\u01A1\u01A3\u01A5\u01A8\u01AA\u01AB\u01AD\u01B0\u01B4\u01B6\u01B9\u01BA\u01BD-\u01BF\u01C6\u01C9\u01CC\u01CE\u01D0\u01D2\u01D4\u01D6\u01D8\u01DA\u01DC\u01DD\u01DF\u01E1\u01E3\u01E5\u01E7\u01E9\u01EB\u01ED\u01EF\u01F0\u01F3\u01F5\u01F9\u01FB\u01FD\u01FF\u0201\u0203\u0205\u0207\u0209\u020B\u020D\u020F\u0211\u0213\u0215\u0217\u0219\u021B\u021D\u021F\u0221\u0223\u0225\u0227\u0229\u022B\u022D\u022F\u0231\u0233-\u0239\u023C\u023F\u0240\u0242\u0247\u0249\u024B\u024D\u024F-\u0293\u0295-\u02AF\u0371\u0373\u0377\u037B-\u037D\u0390\u03AC-\u03CE\u03D0\u03D1\u03D5-\u03D7\u03D9\u03DB\u03DD\u03DF\u03E1\u03E3\u03E5\u03E7\u03E9\u03EB\u03ED\u03EF-\u03F3\u03F5\u03F8\u03FB\u03FC\u0430-\u045F\u0461\u0463\u0465\u0467\u0469\u046B\u046D\u046F\u0471\u0473\u0475\u0477\u0479\u047B\u047D\u047F\u0481\u048B\u048D\u048F\u0491\u0493\u0495\u0497\u0499\u049B\u049D\u049F\u04A1\u04A3\u04A5\u04A7\u04A9\u04AB\u04AD\u04AF\u04B1\u04B3\u04B5\u04B7\u04B9\u04BB\u04BD\u04BF\u04C2\u04C4\u04C6\u04C8\u04CA\u04CC\u04CE\u04CF\u04D1\u04D3\u04D5\u04D7\u04D9\u04DB\u04DD\u04DF\u04E1\u04E3\u04E5\u04E7\u04E9\u04EB\u04ED\u04EF\u04F1\u04F3\u04F5\u04F7\u04F9\u04FB\u04FD\u04FF\u0501\u0503\u0505\u0507\u0509\u050B\u050D\u050F\u0511\u0513\u0515\u0517\u0519\u051B\u051D\u051F\u0521\u0523\u0525\u0527\u0529\u052B\u052D\u052F\u0561-\u0587\u13F8-\u13FD\u1D00-\u1D2B\u1D6B-\u1D77\u1D79-\u1D9A\u1E01\u1E03\u1E05\u1E07\u1E09\u1E0B\u1E0D\u1E0F\u1E11\u1E13\u1E15\u1E17\u1E19\u1E1B\u1E1D\u1E1F\u1E21\u1E23\u1E25\u1E27\u1E29\u1E2B\u1E2D\u1E2F\u1E31\u1E33\u1E35\u1E37\u1E39\u1E3B\u1E3D\u1E3F\u1E41\u1E43\u1E45\u1E47\u1E49\u1E4B\u1E4D\u1E4F\u1E51\u1E53\u1E55\u1E57\u1E59\u1E5B\u1E5D\u1E5F\u1E61\u1E63\u1E65\u1E67\u1E69\u1E6B\u1E6D\u1E6F\u1E71\u1E73\u1E75\u1E77\u1E79\u1E7B\u1E7D\u1E7F\u1E81\u1E83\u1E85\u1E87\u1E89\u1E8B\u1E8D\u1E8F\u1E91\u1E93\u1E95-\u1E9D\u1E9F\u1EA1\u1EA3\u1EA5\u1EA7\u1EA9\u1EAB\u1EAD\u1EAF\u1EB1\u1EB3\u1EB5\u1EB7\u1EB9\u1EBB\u1EBD\u1EBF\u1EC1\u1EC3\u1EC5\u1EC7\u1EC9\u1ECB\u1ECD\u1ECF\u1ED1\u1ED3\u1ED5\u1ED7\u1ED9\u1EDB\u1EDD\u1EDF\u1EE1\u1EE3\u1EE5\u1EE7\u1EE9\u1EEB\u1EED\u1EEF\u1EF1\u1EF3\u1EF5\u1EF7\u1EF9\u1EFB\u1EFD\u1EFF-\u1F07\u1F10-\u1F15\u1F20-\u1F27\u1F30-\u1F37\u1F40-\u1F45\u1F50-\u1F57\u1F60-\u1F67\u1F70-\u1F7D\u1F80-\u1F87\u1F90-\u1F97\u1FA0-\u1FA7\u1FB0-\u1FB4\u1FB6\u1FB7\u1FBE\u1FC2-\u1FC4\u1FC6\u1FC7\u1FD0-\u1FD3\u1FD6\u1FD7\u1FE0-\u1FE7\u1FF2-\u1FF4\u1FF6\u1FF7\u210A\u210E\u210F\u2113\u212F\u2134\u2139\u213C\u213D\u2146-\u2149\u214E\u2184\u2C30-\u2C5E\u2C61\u2C65\u2C66\u2C68\u2C6A\u2C6C\u2C71\u2C73\u2C74\u2C76-\u2C7B\u2C81\u2C83\u2C85\u2C87\u2C89\u2C8B\u2C8D\u2C8F\u2C91\u2C93\u2C95\u2C97\u2C99\u2C9B\u2C9D\u2C9F\u2CA1\u2CA3\u2CA5\u2CA7\u2CA9\u2CAB\u2CAD\u2CAF\u2CB1\u2CB3\u2CB5\u2CB7\u2CB9\u2CBB\u2CBD\u2CBF\u2CC1\u2CC3\u2CC5\u2CC7\u2CC9\u2CCB\u2CCD\u2CCF\u2CD1\u2CD3\u2CD5\u2CD7\u2CD9\u2CDB\u2CDD\u2CDF\u2CE1\u2CE3\u2CE4\u2CEC\u2CEE\u2CF3\u2D00-\u2D25\u2D27\u2D2D\uA641\uA643\uA645\uA647\uA649\uA64B\uA64D\uA64F\uA651\uA653\uA655\uA657\uA659\uA65B\uA65D\uA65F\uA661\uA663\uA665\uA667\uA669\uA66B\uA66D\uA681\uA683\uA685\uA687\uA689\uA68B\uA68D\uA68F\uA691\uA693\uA695\uA697\uA699\uA69B\uA723\uA725\uA727\uA729\uA72B\uA72D\uA72F-\uA731\uA733\uA735\uA737\uA739\uA73B\uA73D\uA73F\uA741\uA743\uA745\uA747\uA749\uA74B\uA74D\uA74F\uA751\uA753\uA755\uA757\uA759\uA75B\uA75D\uA75F\uA761\uA763\uA765\uA767\uA769\uA76B\uA76D\uA76F\uA771-\uA778\uA77A\uA77C\uA77F\uA781\uA783\uA785\uA787\uA78C\uA78E\uA791\uA793-\uA795\uA797\uA799\uA79B\uA79D\uA79F\uA7A1\uA7A3\uA7A5\uA7A7\uA7A9\uA7B5\uA7B7\uA7FA\uAB30-\uAB5A\uAB60-\uAB65\uAB70-\uABBF\uFB00-\uFB06\uFB13-\uFB17\uFF41-\uFF5A])/g;

  /**
   * Sentence case a string.
   *
   * @param  {string} str
   * @param  {string} locale
   * @param  {string} replacement
   * @return {string}
   */
  var noCase = function (str, locale, replacement) {
    if (str == null) {
      return ''
    }

    replacement = typeof replacement !== 'string' ? ' ' : replacement;

    function replace (match, index, value) {
      if (index === 0 || index === (value.length - match.length)) {
        return ''
      }

      return replacement
    }

    str = String(str)
      // Support camel case ("camelCase" -> "camel Case").
      .replace(camelCaseRegexp, '$1 $2')
      // Support odd camel case ("CAMELCase" -> "CAMEL Case").
      .replace(camelCaseUpperRegexp, '$1 $2')
      // Remove all non-word characters and replace with a single space.
      .replace(nonWordRegexp, replace);

    // Lower case the entire string.
    return lowerCase(str, locale)
  };

  /**
   * Camel case a string.
   *
   * @param  {string} value
   * @param  {string} [locale]
   * @return {string}
   */
  var camelCase = function (value, locale, mergeNumbers) {
    var result = noCase(value, locale);

    // Replace periods between numeric entities with an underscore.
    if (!mergeNumbers) {
      result = result.replace(/ (?=\d)/g, '_');
    }

    // Replace spaces between words with an upper cased character.
    return result.replace(/ (.)/g, function (m, $1) {
      return upperCase($1, locale)
    })
  };

  function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  /**
   * @param {object} styleObj - Style object
   */
  function isValidStyleDeclaration(styleObj) {
    return Boolean(styleObj) && typeof styleObj.__className === 'string' && typeof styleObj.__inject === 'function';
  }
  /**
   * @param {string} className - Class name
   * @param {Array<Interpolation>} rawCss - raw css
   */

  function createStyleDeclaration(className, rawCss) {
    return {
      __className: className.replace('.', '').trim(),

      __inject() {
        injectGlobal(rawCss);
      }

    };
  }
  /**
   * @param {string} className - class name
   */

  function isModifier(className) {
    return Boolean(className && className.startsWith) && className.startsWith('.pf-m-');
  }
  /**
   * @param {object} styleObj - Style object
   * @param {string} modifier - Modifier string
   * @param {string} defaultModifier - Default modifier string
   */

  function getModifier(styleObj, modifier, defaultModifier) {
    if (!styleObj) {
      return null;
    }

    const modifiers = styleObj.modifiers || styleObj;
    return modifiers[modifier] || modifiers[camelCase(modifier)] || defaultModifier;
  }
  /**
   * @param {string} className - Class name
   */

  function formatClassName(className) {
    return camelCase(className.replace(/pf-((c|l|m|u|is|has)-)?/g, ''));
  }
  /**
   * @param {string} cssString - Css string
   */

  function getCSSClasses(cssString) {
    return cssString.match(/(\.)(?!\d)([^\s\.,{\[>+~#:)]*)(?![^{]*})/g); //eslint-disable-line
  }
  /**
   * @param {object} styleObj - Style object
   */

  function getClassName(styleObj = {}) {
    if (typeof styleObj === 'string') {
      return styleObj;
    }

    return isValidStyleDeclaration(styleObj) ? styleObj.__className : '';
  }
  /**
   * @param {object} object - Object
   * @param {Array} properties - Array of properties
   */

  function pickProperties(object, properties) {
    return properties.reduce((picked, property) => _objectSpread({}, picked, {
      [property]: object[property]
    }), {});
  }

  function ownKeys$1(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$1(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$1(source, true).forEach(function (key) { _defineProperty$1(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$1(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty$1(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  const StyleSheet$1 = {
    create(styleObj) {
      const keys = Object.keys(styleObj);

      if (keys.length > 0) {
        return keys.reduce((prev, key) => _objectSpread$1({}, prev, {
          [key]: css(styleObj[key])
        }), {});
      }

      return css(styleObj);
    },

    parse(input) {
      const classes = getCSSClasses(input);

      if (!classes) {
        return {};
      }

      return classes.reduce((map, className) => {
        const key = formatClassName(className);

        if (map[key]) {
          return map;
        }

        const value = createStyleDeclaration(className, input);

        if (isModifier(className)) {
          map.modifiers[key] = value;
        } else {
          map[key] = value;
        }

        return map;
      }, {
        modifiers: {},
        inject: () => injectGlobal(input),
        raw: input
      });
    }

  };
  /**
   * @param {Array} styles - Array of styles
   */

  function css$1(...styles) {
    const filteredStyles = [];
    styles.forEach(style => {
      if (isValidStyleDeclaration(style)) {
        // remove global injection of styles in favor of require(css) in the component
        // style.__inject();
        filteredStyles.push(getClassName(style));
        return;
      }

      filteredStyles.push(style);
    });
    return cx(...filteredStyles);
  }

  var backdrop = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      backdrop: 'pf-c-backdrop',
      backdropOpen: 'pf-c-backdrop__open',
      modifiers: {}
  };
  });

  var styles = unwrapExports(backdrop);

  const KEY_CODES = {
    ARROW_UP: 38,
    ARROW_DOWN: 40,
    ESCAPE_KEY: 27,
    TAB: 9,
    ENTER: 13,
    SPACE: 32
  };
  const SIDE = {
    RIGHT: 'right',
    LEFT: 'left',
    BOTH: 'both',
    NONE: 'none'
  };
  const KEYHANDLER_DIRECTION = {
    UP: 'up',
    DOWN: 'down',
    RIGHT: 'right',
    LEFT: 'left'
  };

  (function (ValidatedOptions) {
    ValidatedOptions["success"] = "success";
    ValidatedOptions["error"] = "error";
    ValidatedOptions["default"] = "default";
  })(exports.ValidatedOptions || (exports.ValidatedOptions = {}));

  var candidateSelectors = [
    'input',
    'select',
    'textarea',
    'a[href]',
    'button',
    '[tabindex]',
    'audio[controls]',
    'video[controls]',
    '[contenteditable]:not([contenteditable="false"])',
  ];
  var candidateSelector = candidateSelectors.join(',');

  var matches = typeof Element === 'undefined'
    ? function () {}
    : Element.prototype.matches || Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;

  function tabbable(el, options) {
    options = options || {};

    var elementDocument = el.ownerDocument || el;
    var regularTabbables = [];
    var orderedTabbables = [];

    var untouchabilityChecker = new UntouchabilityChecker(elementDocument);
    var candidates = el.querySelectorAll(candidateSelector);

    if (options.includeContainer) {
      if (matches.call(el, candidateSelector)) {
        candidates = Array.prototype.slice.apply(candidates);
        candidates.unshift(el);
      }
    }

    var i, candidate, candidateTabindex;
    for (i = 0; i < candidates.length; i++) {
      candidate = candidates[i];

      if (!isNodeMatchingSelectorTabbable(candidate, untouchabilityChecker)) continue;

      candidateTabindex = getTabindex(candidate);
      if (candidateTabindex === 0) {
        regularTabbables.push(candidate);
      } else {
        orderedTabbables.push({
          documentOrder: i,
          tabIndex: candidateTabindex,
          node: candidate,
        });
      }
    }

    var tabbableNodes = orderedTabbables
      .sort(sortOrderedTabbables)
      .map(function(a) { return a.node })
      .concat(regularTabbables);

    return tabbableNodes;
  }

  tabbable.isTabbable = isTabbable;
  tabbable.isFocusable = isFocusable;

  function isNodeMatchingSelectorTabbable(node, untouchabilityChecker) {
    if (
      !isNodeMatchingSelectorFocusable(node, untouchabilityChecker)
      || isNonTabbableRadio(node)
      || getTabindex(node) < 0
    ) {
      return false;
    }
    return true;
  }

  function isTabbable(node, untouchabilityChecker) {
    if (!node) throw new Error('No node provided');
    if (matches.call(node, candidateSelector) === false) return false;
    return isNodeMatchingSelectorTabbable(node, untouchabilityChecker);
  }

  function isNodeMatchingSelectorFocusable(node, untouchabilityChecker) {
    untouchabilityChecker = untouchabilityChecker || new UntouchabilityChecker(node.ownerDocument || node);
    if (
      node.disabled
      || isHiddenInput(node)
      || untouchabilityChecker.isUntouchable(node)
    ) {
      return false;
    }
    return true;
  }

  var focusableCandidateSelector = candidateSelectors.concat('iframe').join(',');
  function isFocusable(node, untouchabilityChecker) {
    if (!node) throw new Error('No node provided');
    if (matches.call(node, focusableCandidateSelector) === false) return false;
    return isNodeMatchingSelectorFocusable(node, untouchabilityChecker);
  }

  function getTabindex(node) {
    var tabindexAttr = parseInt(node.getAttribute('tabindex'), 10);
    if (!isNaN(tabindexAttr)) return tabindexAttr;
    // Browsers do not return `tabIndex` correctly for contentEditable nodes;
    // so if they don't have a tabindex attribute specifically set, assume it's 0.
    if (isContentEditable(node)) return 0;
    return node.tabIndex;
  }

  function sortOrderedTabbables(a, b) {
    return a.tabIndex === b.tabIndex ? a.documentOrder - b.documentOrder : a.tabIndex - b.tabIndex;
  }

  // Array.prototype.find not available in IE.
  function find(list, predicate) {
    for (var i = 0, length = list.length; i < length; i++) {
      if (predicate(list[i])) return list[i];
    }
  }

  function isContentEditable(node) {
    return node.contentEditable === 'true';
  }

  function isInput(node) {
    return node.tagName === 'INPUT';
  }

  function isHiddenInput(node) {
    return isInput(node) && node.type === 'hidden';
  }

  function isRadio(node) {
    return isInput(node) && node.type === 'radio';
  }

  function isNonTabbableRadio(node) {
    return isRadio(node) && !isTabbableRadio(node);
  }

  function getCheckedRadio(nodes) {
    for (var i = 0; i < nodes.length; i++) {
      if (nodes[i].checked) {
        return nodes[i];
      }
    }
  }

  function isTabbableRadio(node) {
    if (!node.name) return true;
    // This won't account for the edge case where you have radio groups with the same
    // in separate forms on the same page.
    var radioSet = node.ownerDocument.querySelectorAll('input[type="radio"][name="' + node.name + '"]');
    var checked = getCheckedRadio(radioSet);
    return !checked || checked === node;
  }

  // An element is "untouchable" if *it or one of its ancestors* has
  // `visibility: hidden` or `display: none`.
  function UntouchabilityChecker(elementDocument) {
    this.doc = elementDocument;
    // Node cache must be refreshed on every check, in case
    // the content of the element has changed. The cache contains tuples
    // mapping nodes to their boolean result.
    this.cache = [];
  }

  // getComputedStyle accurately reflects `visibility: hidden` of ancestors
  // but not `display: none`, so we need to recursively check parents.
  UntouchabilityChecker.prototype.hasDisplayNone = function hasDisplayNone(node, nodeComputedStyle) {
    if (node.nodeType !== Node.ELEMENT_NODE) return false;

      // Search for a cached result.
      var cached = find(this.cache, function(item) {
        return item === node;
      });
      if (cached) return cached[1];

      nodeComputedStyle = nodeComputedStyle || this.doc.defaultView.getComputedStyle(node);

      var result = false;

      if (nodeComputedStyle.display === 'none') {
        result = true;
      } else if (node.parentNode) {
        result = this.hasDisplayNone(node.parentNode);
      }

      this.cache.push([node, result]);

      return result;
  };

  UntouchabilityChecker.prototype.isUntouchable = function isUntouchable(node) {
    if (node === this.doc.documentElement) return false;
    var computedStyle = this.doc.defaultView.getComputedStyle(node);
    if (this.hasDisplayNone(node, computedStyle)) return true;
    return computedStyle.visibility === 'hidden';
  };

  var tabbable_1 = tabbable;

  var immutable = extend;

  var hasOwnProperty = Object.prototype.hasOwnProperty;

  function extend() {
      var target = {};

      for (var i = 0; i < arguments.length; i++) {
          var source = arguments[i];

          for (var key in source) {
              if (hasOwnProperty.call(source, key)) {
                  target[key] = source[key];
              }
          }
      }

      return target
  }

  var activeFocusTraps = (function() {
    var trapQueue = [];
    return {
      activateTrap: function(trap) {
        if (trapQueue.length > 0) {
          var activeTrap = trapQueue[trapQueue.length - 1];
          if (activeTrap !== trap) {
            activeTrap.pause();
          }
        }

        var trapIndex = trapQueue.indexOf(trap);
        if (trapIndex === -1) {
          trapQueue.push(trap);
        } else {
          // move this existing trap to the front of the queue
          trapQueue.splice(trapIndex, 1);
          trapQueue.push(trap);
        }
      },

      deactivateTrap: function(trap) {
        var trapIndex = trapQueue.indexOf(trap);
        if (trapIndex !== -1) {
          trapQueue.splice(trapIndex, 1);
        }

        if (trapQueue.length > 0) {
          trapQueue[trapQueue.length - 1].unpause();
        }
      }
    };
  })();

  function focusTrap(element, userOptions) {
    var doc = document;
    var container =
      typeof element === 'string' ? doc.querySelector(element) : element;

    var config = immutable(
      {
        returnFocusOnDeactivate: true,
        escapeDeactivates: true
      },
      userOptions
    );

    var state = {
      firstTabbableNode: null,
      lastTabbableNode: null,
      nodeFocusedBeforeActivation: null,
      mostRecentlyFocusedNode: null,
      active: false,
      paused: false
    };

    var trap = {
      activate: activate,
      deactivate: deactivate,
      pause: pause,
      unpause: unpause
    };

    return trap;

    function activate(activateOptions) {
      if (state.active) return;

      updateTabbableNodes();

      state.active = true;
      state.paused = false;
      state.nodeFocusedBeforeActivation = doc.activeElement;

      var onActivate =
        activateOptions && activateOptions.onActivate
          ? activateOptions.onActivate
          : config.onActivate;
      if (onActivate) {
        onActivate();
      }

      addListeners();
      return trap;
    }

    function deactivate(deactivateOptions) {
      if (!state.active) return;

      removeListeners();
      state.active = false;
      state.paused = false;

      activeFocusTraps.deactivateTrap(trap);

      var onDeactivate =
        deactivateOptions && deactivateOptions.onDeactivate !== undefined
          ? deactivateOptions.onDeactivate
          : config.onDeactivate;
      if (onDeactivate) {
        onDeactivate();
      }

      var returnFocus =
        deactivateOptions && deactivateOptions.returnFocus !== undefined
          ? deactivateOptions.returnFocus
          : config.returnFocusOnDeactivate;
      if (returnFocus) {
        delay(function() {
          tryFocus(state.nodeFocusedBeforeActivation);
        });
      }

      return trap;
    }

    function pause() {
      if (state.paused || !state.active) return;
      state.paused = true;
      removeListeners();
    }

    function unpause() {
      if (!state.paused || !state.active) return;
      state.paused = false;
      addListeners();
    }

    function addListeners() {
      if (!state.active) return;

      // There can be only one listening focus trap at a time
      activeFocusTraps.activateTrap(trap);

      updateTabbableNodes();

      // Delay ensures that the focused element doesn't capture the event
      // that caused the focus trap activation.
      delay(function() {
        tryFocus(getInitialFocusNode());
      });
      doc.addEventListener('focusin', checkFocusIn, true);
      doc.addEventListener('mousedown', checkPointerDown, true);
      doc.addEventListener('touchstart', checkPointerDown, true);
      doc.addEventListener('click', checkClick, true);
      doc.addEventListener('keydown', checkKey, true);

      return trap;
    }

    function removeListeners() {
      if (!state.active) return;

      doc.removeEventListener('focusin', checkFocusIn, true);
      doc.removeEventListener('mousedown', checkPointerDown, true);
      doc.removeEventListener('touchstart', checkPointerDown, true);
      doc.removeEventListener('click', checkClick, true);
      doc.removeEventListener('keydown', checkKey, true);

      return trap;
    }

    function getNodeForOption(optionName) {
      var optionValue = config[optionName];
      var node = optionValue;
      if (!optionValue) {
        return null;
      }
      if (typeof optionValue === 'string') {
        node = doc.querySelector(optionValue);
        if (!node) {
          throw new Error('`' + optionName + '` refers to no known node');
        }
      }
      if (typeof optionValue === 'function') {
        node = optionValue();
        if (!node) {
          throw new Error('`' + optionName + '` did not return a node');
        }
      }
      return node;
    }

    function getInitialFocusNode() {
      var node;
      if (getNodeForOption('initialFocus') !== null) {
        node = getNodeForOption('initialFocus');
      } else if (container.contains(doc.activeElement)) {
        node = doc.activeElement;
      } else {
        node = state.firstTabbableNode || getNodeForOption('fallbackFocus');
      }

      if (!node) {
        throw new Error(
          "You can't have a focus-trap without at least one focusable element"
        );
      }

      return node;
    }

    // This needs to be done on mousedown and touchstart instead of click
    // so that it precedes the focus event.
    function checkPointerDown(e) {
      if (container.contains(e.target)) return;
      if (config.clickOutsideDeactivates) {
        deactivate({
          returnFocus: !tabbable_1.isFocusable(e.target)
        });
      } else {
        e.preventDefault();
      }
    }

    // In case focus escapes the trap for some strange reason, pull it back in.
    function checkFocusIn(e) {
      // In Firefox when you Tab out of an iframe the Document is briefly focused.
      if (container.contains(e.target) || e.target instanceof Document) {
        return;
      }
      e.stopImmediatePropagation();
      tryFocus(state.mostRecentlyFocusedNode || getInitialFocusNode());
    }

    function checkKey(e) {
      if (config.escapeDeactivates !== false && isEscapeEvent(e)) {
        e.preventDefault();
        deactivate();
        return;
      }
      if (isTabEvent(e)) {
        checkTab(e);
        return;
      }
    }

    // Hijack Tab events on the first and last focusable nodes of the trap,
    // in order to prevent focus from escaping. If it escapes for even a
    // moment it can end up scrolling the page and causing confusion so we
    // kind of need to capture the action at the keydown phase.
    function checkTab(e) {
      updateTabbableNodes();
      if (e.shiftKey && e.target === state.firstTabbableNode) {
        e.preventDefault();
        tryFocus(state.lastTabbableNode);
        return;
      }
      if (!e.shiftKey && e.target === state.lastTabbableNode) {
        e.preventDefault();
        tryFocus(state.firstTabbableNode);
        return;
      }
    }

    function checkClick(e) {
      if (config.clickOutsideDeactivates) return;
      if (container.contains(e.target)) return;
      e.preventDefault();
      e.stopImmediatePropagation();
    }

    function updateTabbableNodes() {
      var tabbableNodes = tabbable_1(container);
      state.firstTabbableNode = tabbableNodes[0] || getInitialFocusNode();
      state.lastTabbableNode =
        tabbableNodes[tabbableNodes.length - 1] || getInitialFocusNode();
    }

    function tryFocus(node) {
      if (node === doc.activeElement) return;
      if (!node || !node.focus) {
        tryFocus(getInitialFocusNode());
        return;
      }

      node.focus();
      state.mostRecentlyFocusedNode = node;
      if (isSelectableInput(node)) {
        node.select();
      }
    }
  }

  function isSelectableInput(node) {
    return (
      node.tagName &&
      node.tagName.toLowerCase() === 'input' &&
      typeof node.select === 'function'
    );
  }

  function isEscapeEvent(e) {
    return e.key === 'Escape' || e.key === 'Esc' || e.keyCode === 27;
  }

  function isTabEvent(e) {
    return e.key === 'Tab' || e.keyCode === 9;
  }

  function delay(fn) {
    return setTimeout(fn, 0);
  }

  var focusTrap_1 = focusTrap;

  function ownKeys$2(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$2(source, true).forEach(function (key) { _defineProperty$2(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$2(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty$2(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class FocusTrap extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$2(this, "divRef", React.createRef());

      if (typeof document !== 'undefined') {
        this.previouslyFocusedElement = document.activeElement;
      }
    }

    componentDidMount() {
      // We need to hijack the returnFocusOnDeactivate option,
      // because React can move focus into the element before we arrived at
      // this lifecycle hook (e.g. with autoFocus inputs). So the component
      // captures the previouslyFocusedElement in componentWillMount,
      // then (optionally) returns focus to it in componentWillUnmount.
      this.focusTrap = focusTrap_1(this.divRef.current, _objectSpread$2({}, this.props.focusTrapOptions, {
        returnFocusOnDeactivate: false
      }));

      if (this.props.active) {
        this.focusTrap.activate();
      }

      if (this.props.paused) {
        this.focusTrap.pause();
      }
    }

    componentDidUpdate(prevProps) {
      if (prevProps.active && !this.props.active) {
        const {
          returnFocusOnDeactivate
        } = this.props.focusTrapOptions;
        const returnFocus = returnFocusOnDeactivate || false;
        const config = {
          returnFocus
        };
        this.focusTrap.deactivate(config);
      } else if (!prevProps.active && this.props.active) {
        this.focusTrap.activate();
      }

      if (prevProps.paused && !this.props.paused) {
        this.focusTrap.unpause();
      } else if (!prevProps.paused && this.props.paused) {
        this.focusTrap.pause();
      }
    }

    componentWillUnmount() {
      this.focusTrap.deactivate();

      if (this.props.focusTrapOptions.returnFocusOnDeactivate !== false && this.previouslyFocusedElement && this.previouslyFocusedElement.focus) {
        this.previouslyFocusedElement.focus();
      }
    }

    render() {
      return React.createElement("div", {
        ref: this.divRef,
        className: this.props.className
      }, this.props.children);
    }

  }

  _defineProperty$2(FocusTrap, "propTypes", {
    children: _pt.node.isRequired,
    className: _pt.string,
    active: _pt.bool,
    paused: _pt.bool,
    focusTrapOptions: _pt.any
  });

  _defineProperty$2(FocusTrap, "defaultProps", {
    active: true,
    paused: false,
    focusTrapOptions: {}
  });

  function _defineProperty$3(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  let currentId = 0;

  class GenerateId extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$3(this, "id", `${this.props.prefix}${currentId++}`);
    }

    render() {
      return this.props.children(this.id);
    }

  }

  _defineProperty$3(GenerateId, "propTypes", {
    prefix: _pt.string
  });

  _defineProperty$3(GenerateId, "defaultProps", {
    prefix: 'pf-random-id-'
  });

  const ASTERISK = '*';

  /**
   * @param {string} input - String to capitalize
   */
  function capitalize(input) {
    return input[0].toUpperCase() + input.substring(1);
  }
  /**
   * @param {string} prefix - String to prefix ID with
   */

  function getUniqueId(prefix = 'pf') {
    const uid = new Date().getTime() + Math.random().toString(36).slice(2);
    return `${prefix}-${uid}`;
  }
  /**
   * @param { any } this - "This" reference
   * @param { Function } func - Function to debounce
   * @param { number } wait - Debounce amount
   */

  function debounce(func, wait) {
    let timeout;
    return (...args) => {
      clearTimeout(timeout);
      timeout = setTimeout(() => func.apply(this, args), wait);
    };
  }
  /** This function returns whether or not an element is within the viewable area of a container. If partial is true,
   * then this function will return true even if only part of the element is in view.
   *
   * @param {HTMLElement} container  The container to check if the element is in view of.
   * @param {HTMLElement} element    The element to check if it is view
   * @param {boolean} partial   true if partial view is allowed
   *
   * @returns { boolean } True if the component is in View.
   */

  function isElementInView(container, element, partial) {
    const containerBounds = container.getBoundingClientRect();
    const elementBounds = element.getBoundingClientRect();
    const containerBoundsLeft = Math.floor(containerBounds.left);
    const containerBoundsRight = Math.floor(containerBounds.right);
    const elementBoundsLeft = Math.floor(elementBounds.left);
    const elementBoundsRight = Math.floor(elementBounds.right); // Check if in view

    const isTotallyInView = elementBoundsLeft >= containerBoundsLeft && elementBoundsRight <= containerBoundsRight;
    const isPartiallyInView = partial && (elementBoundsLeft < containerBoundsLeft && elementBoundsRight > containerBoundsLeft || elementBoundsRight > containerBoundsRight && elementBoundsLeft < containerBoundsRight); // Return outcome

    return isTotallyInView || isPartiallyInView;
  }
  /** This function returns the side the element is out of view on (right, left or both)
   *
   * @param {HTMLElement} container    The container to check if the element is in view of.
   * @param {HTMLElement} element      The element to check if it is view
   *
   * @returns {string} right if the element is of the right, left if element is off the left or both if it is off on both sides.
   */

  function sideElementIsOutOfView(container, element) {
    const containerBounds = container.getBoundingClientRect();
    const elementBounds = element.getBoundingClientRect();
    const containerBoundsLeft = Math.floor(containerBounds.left);
    const containerBoundsRight = Math.floor(containerBounds.right);
    const elementBoundsLeft = Math.floor(elementBounds.left);
    const elementBoundsRight = Math.floor(elementBounds.right); // Check if in view

    const isOffLeft = elementBoundsLeft < containerBoundsLeft;
    const isOffRight = elementBoundsRight > containerBoundsRight;
    let side = SIDE.NONE;

    if (isOffRight && isOffLeft) {
      side = SIDE.BOTH;
    } else if (isOffRight) {
      side = SIDE.RIGHT;
    } else if (isOffLeft) {
      side = SIDE.LEFT;
    } // Return outcome


    return side;
  }
  /** Interpolates a parameterized templateString using values from a templateVars object.
   * The templateVars object should have keys and values which match the templateString's parameters.
   * Example:
   *    const templateString: 'My name is ${firstName} ${lastName}';
   *    const templateVars: {
   *      firstName: 'Jon'
   *      lastName: 'Dough'
   *    };
   *    const result = fillTemplate(templateString, templateVars);
   *    // "My name is Jon Dough"
   *
   * @param {object} templateString  The string passed by the consumer
   * @param {object} templateVars The variables passed to the string
   *
   * @returns {string} The template string literal result
   */

  function fillTemplate(templateString, templateVars) {
    const func = new Function(...Object.keys(templateVars), `return \`${templateString}\`;`);
    return func(...Object.values(templateVars));
  }
  /**
   * This function allows for keyboard navigation through dropdowns. The custom argument is optional.
   *
   * @param {number} index The index of the element you're on
   * @param {number} innerIndex Inner index number
   * @param {string} position The orientation of the dropdown
   * @param {string[]} refsCollection Array of refs to the items in the dropdown
   * @param {object[]} kids Array of items in the dropdown
   * @param {boolean} [custom] Allows for handling of flexible content
   */

  function keyHandler(index, innerIndex, position, refsCollection, kids, custom = false) {
    if (!Array.isArray(kids)) {
      return;
    }

    const isMultiDimensional = refsCollection.filter(ref => ref)[0].constructor === Array;
    let nextIndex = index;
    let nextInnerIndex = innerIndex;

    if (position === 'up') {
      if (index === 0) {
        // loop back to end
        nextIndex = kids.length - 1;
      } else {
        nextIndex = index - 1;
      }
    } else if (position === 'down') {
      if (index === kids.length - 1) {
        // loop back to beginning
        nextIndex = 0;
      } else {
        nextIndex = index + 1;
      }
    } else if (position === 'left') {
      if (innerIndex === 0) {
        nextInnerIndex = refsCollection[index].length - 1;
      } else {
        nextInnerIndex = innerIndex - 1;
      }
    } else if (position === 'right') {
      if (innerIndex === refsCollection[index].length - 1) {
        nextInnerIndex = 0;
      } else {
        nextInnerIndex = innerIndex + 1;
      }
    }

    if (refsCollection[nextIndex] === null || refsCollection[nextIndex] === undefined || isMultiDimensional && (refsCollection[nextIndex][nextInnerIndex] === null || refsCollection[nextIndex][nextInnerIndex] === undefined)) {
      keyHandler(nextIndex, nextInnerIndex, position, refsCollection, kids, custom);
    } else if (custom) {
      if (refsCollection[nextIndex].focus) {
        refsCollection[nextIndex].focus();
      } // eslint-disable-next-line react/no-find-dom-node


      const element = ReactDOM.findDOMNode(refsCollection[nextIndex]);
      element.focus();
    } else {
      if (isMultiDimensional) {
        refsCollection[nextIndex][nextInnerIndex].focus();
      } else {
        refsCollection[nextIndex].focus();
      }
    }
  }
  /** This function is a helper for keyboard navigation through dropdowns.
   *
   * @param {number} index The index of the element you're on
   * @param {string} position The orientation of the dropdown
   * @param {string[]} collection Array of refs to the items in the dropdown
   */

  function getNextIndex(index, position, collection) {
    let nextIndex;

    if (position === 'up') {
      if (index === 0) {
        // loop back to end
        nextIndex = collection.length - 1;
      } else {
        nextIndex = index - 1;
      }
    } else if (index === collection.length - 1) {
      // loop back to beginning
      nextIndex = 0;
    } else {
      nextIndex = index + 1;
    }

    if (collection[nextIndex] === null) {
      getNextIndex(nextIndex, position, collection);
    } else {
      return nextIndex;
    }
  }
  /** This function is a helper for pluralizing strings.
   *
   * @param {number} i The quantity of the string you want to pluralize
   * @param {string} singular The singular version of the string
   * @param {string} plural The change to the string that should occur if the quantity is not equal to 1.
   *                 Defaults to adding an 's'.
   */

  function pluralize(i, singular, plural) {
    if (!plural) {
      plural = `${singular}s`;
    }

    return `${i || 0} ${i === 1 ? singular : plural}`;
  }
  /** This function is a helper for turning arrays of breakpointMod objects for data toolbar and flex into classes
   *
   * @param {(DataToolbarBreakpointMod | FlexBreakpointMod | FlexItemBreakpointMod)[]} breakpointMods The modifiers object
   * @param {any} styles The appropriate styles object for the component
   */

  const formatBreakpointMods = (breakpointMods, styles) => breakpointMods.reduce((acc, curr) => `${acc}${acc && ' '}${getModifier(styles, `${curr.modifier}${curr.breakpoint ? `-on-${curr.breakpoint}` : ''}`)}`, '');
  const canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);

  var bullseye = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      bullseye: 'pf-l-bullseye',
      modifiers: {}
  };
  });

  var styles$1 = unwrapExports(bullseye);

  var aboutModalBox = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      aboutModalBox: 'pf-c-about-modal-box',
      card: 'pf-c-card',
      button: 'pf-c-button',
      aboutModalBoxBrand: 'pf-c-about-modal-box__brand',
      aboutModalBoxBrandImage: 'pf-c-about-modal-box__brand-image',
      aboutModalBoxHeader: 'pf-c-about-modal-box__header',
      aboutModalBoxStrapline: 'pf-c-about-modal-box__strapline',
      aboutModalBoxContent: 'pf-c-about-modal-box__content',
      aboutModalBoxClose: 'pf-c-about-modal-box__close',
      aboutModalBoxHero: 'pf-c-about-modal-box__hero',
      modifiers: {
          'hover': 'pf-m-hover'
      }
  };
  });

  var styles$2 = unwrapExports(aboutModalBox);

  var content = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      content: 'pf-c-content',
      modifiers: {
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var styles$3 = unwrapExports(content);

  function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

  function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AboutModalBoxContent = (_ref) => {
    let {
      children,
      className = '',
      trademark,
      id,
      noAboutModalBoxContentContainer = false
    } = _ref,
        props = _objectWithoutProperties(_ref, ["children", "className", "trademark", "id", "noAboutModalBoxContentContainer"]);

    return React.createElement("div", _extends({
      className: css$1(styles$2.aboutModalBoxContent, className),
      id: id
    }, props), React.createElement("div", {
      className: css$1('pf-c-about-modal-box__body')
    }, noAboutModalBoxContentContainer ? children : React.createElement("div", {
      className: css$1(styles$3.content)
    }, children)), React.createElement("p", {
      className: css$1(styles$2.aboutModalBoxStrapline)
    }, trademark));
  };
  AboutModalBoxContent.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string,
    id: _pt.string.isRequired,
    trademark: _pt.string.isRequired,
    noAboutModalBoxContentContainer: _pt.bool
  };

  var title = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      title: 'pf-c-title',
      modifiers: {
          '4xl': 'pf-m-4xl',
          '3xl': 'pf-m-3xl',
          '2xl': 'pf-m-2xl',
          'xl': 'pf-m-xl',
          'lg': 'pf-m-lg',
          'md': 'pf-m-md',
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var titleStyles = unwrapExports(title);

  function _extends$1() { _extends$1 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1.apply(this, arguments); }

  function _objectWithoutProperties$1(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (TitleLevel) {
    TitleLevel["h1"] = "h1";
    TitleLevel["h2"] = "h2";
    TitleLevel["h3"] = "h3";
    TitleLevel["h4"] = "h4";
    TitleLevel["h5"] = "h5";
    TitleLevel["h6"] = "h6";
  })(exports.TitleLevel || (exports.TitleLevel = {}));

  const Title = (_ref) => {
    let {
      size,
      className = '',
      children = '',
      headingLevel: HeadingLevel = 'h1'
    } = _ref,
        props = _objectWithoutProperties$1(_ref, ["size", "className", "children", "headingLevel"]);

    return React.createElement(HeadingLevel, _extends$1({}, props, {
      className: css$1(titleStyles.title, getModifier(titleStyles, size), className)
    }), children);
  };
  Title.propTypes = {
    size: _pt.oneOfType([_pt.any, _pt.oneOf(['xs']), _pt.oneOf(['sm']), _pt.oneOf(['md']), _pt.oneOf(['lg']), _pt.oneOf(['xl']), _pt.oneOf(['2xl']), _pt.oneOf(['3xl']), _pt.oneOf(['4xl'])]).isRequired,
    children: _pt.node,
    className: _pt.string,
    headingLevel: _pt.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6'])
  };

  (function (BaseSizes) {
    BaseSizes["xs"] = "xs";
    BaseSizes["sm"] = "sm";
    BaseSizes["md"] = "md";
    BaseSizes["lg"] = "lg";
    BaseSizes["xl"] = "xl";
    BaseSizes["2xl"] = "2xl";
    BaseSizes["3xl"] = "3xl";
    BaseSizes["4xl"] = "4xl";
  })(exports.TitleSize || (exports.TitleSize = {}));

  (function (DeviceSizes) {
    DeviceSizes["sm"] = "Sm";
    DeviceSizes["md"] = "Md";
    DeviceSizes["lg"] = "Lg";
    DeviceSizes["xl"] = "Xl";
    DeviceSizes["xl2"] = "_2xl";
  })(exports.DeviceSizes || (exports.DeviceSizes = {}));

  function _extends$2() { _extends$2 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2.apply(this, arguments); }

  function _objectWithoutProperties$2(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AboutModalBoxHeader = (_ref) => {
    let {
      className = '',
      productName = '',
      id
    } = _ref,
        props = _objectWithoutProperties$2(_ref, ["className", "productName", "id"]);

    return React.createElement("div", _extends$2({
      className: css$1(styles$2.aboutModalBoxHeader, className)
    }, props), React.createElement(Title, {
      headingLevel: "h1",
      size: "4xl",
      id: id
    }, productName));
  };
  AboutModalBoxHeader.propTypes = {
    className: _pt.string,
    productName: _pt.string,
    id: _pt.string.isRequired
  };

  var c_about_modal_box__hero_sm_BackgroundImage = {"name":"--pf-c-about-modal-box__hero--sm--BackgroundImage","value":"url(assets/images/pfbg_992@2x.jpg)","var":"var(--pf-c-about-modal-box__hero--sm--BackgroundImage)"};

  function _extends$3() { _extends$3 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$3.apply(this, arguments); }

  function _objectWithoutProperties$3(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$3(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$3(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AboutModalBoxHero = (_ref) => {
    let {
      className,
      backgroundImageSrc
    } = _ref,
        props = _objectWithoutProperties$3(_ref, ["className", "backgroundImageSrc"]);

    return React.createElement("div", _extends$3({
      style:
      /* eslint-disable camelcase */
      backgroundImageSrc !== '' ? {
        [c_about_modal_box__hero_sm_BackgroundImage.name]: `url(${backgroundImageSrc})`
      } : {}
      /* eslint-enable camelcase */
      ,
      className: css$1(styles$2.aboutModalBoxHero, className)
    }, props));
  };
  AboutModalBoxHero.propTypes = {
    className: _pt.string,
    backgroundImageSrc: _pt.string
  };

  function _extends$4() { _extends$4 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$4.apply(this, arguments); }

  function _objectWithoutProperties$4(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$4(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$4(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AboutModalBoxBrand = (_ref) => {
    let {
      className = '',
      src = '',
      alt
    } = _ref,
        props = _objectWithoutProperties$4(_ref, ["className", "src", "alt"]);

    return React.createElement("div", _extends$4({
      className: css$1(styles$2.aboutModalBoxBrand, className)
    }, props), React.createElement("img", {
      className: css$1(styles$2.aboutModalBoxBrandImage),
      src: src,
      alt: alt
    }));
  };
  AboutModalBoxBrand.propTypes = {
    className: _pt.string,
    src: _pt.string,
    alt: _pt.string.isRequired
  };

  var button = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      button: 'pf-c-button',
      buttonIcon: 'pf-c-button__icon',
      buttonText: 'pf-c-button__text',
      modifiers: {
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus',
          'block': 'pf-m-block',
          'primary': 'pf-m-primary',
          'secondary': 'pf-m-secondary',
          'tertiary': 'pf-m-tertiary',
          'danger': 'pf-m-danger',
          'link': 'pf-m-link',
          'inline': 'pf-m-inline',
          'disabled': 'pf-m-disabled',
          'control': 'pf-m-control',
          'expanded': 'pf-m-expanded',
          'plain': 'pf-m-plain',
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var buttonStyles = unwrapExports(button);

  const isOUIAEnvironment = () => {
    try {
      return typeof window !== 'undefined' && window.localStorage && window.localStorage.getItem('ouia:enabled') && window.localStorage['ouia:enabled'].toLowerCase() === 'true' || false;
    } catch (exception) {
      return false;
    }
  };
  const generateOUIAId = () => typeof window !== 'undefined' && window.localStorage['ouia-generate-id'] && window.localStorage['ouia-generate-id'].toLowerCase() === 'true' || false;
  let id = 0;
  const getUniqueId$1 = () => id++;

  function _extends$5() { _extends$5 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$5.apply(this, arguments); }

  function _defineProperty$4(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  const OuiaContext = React.createContext(null);

  /**
   * @param { React.ComponentClass | React.FunctionComponent } WrappedComponent - React component
   */
  function withOuiaContext(WrappedComponent) {
    /* eslint-disable react/display-name */
    return props => React.createElement(OuiaContext.Consumer, null, value => React.createElement(ComponentWithOuia, {
      consumerContext: value,
      component: WrappedComponent,
      componentProps: props
    }));
    /* eslint-enable react/display-name */
  }

  class ComponentWithOuia extends React.Component {
    constructor(props) {
      super(props);
      this.state = {
        isOuia: false,
        ouiaId: null
      };
    }
    /**
     * if either consumer set isOuia through context or local storage
     * then force a re-render
     */


    componentDidMount() {
      const {
        isOuia,
        ouiaId
      } = this.state;
      const {
        consumerContext
      } = this.props;
      const isOuiaEnv = isOUIAEnvironment();

      if (consumerContext && consumerContext.isOuia !== undefined && consumerContext.isOuia !== isOuia || isOuiaEnv !== isOuia) {
        this.setState({
          isOuia: consumerContext && consumerContext.isOuia !== undefined ? consumerContext.isOuia : isOuiaEnv,
          ouiaId: consumerContext && consumerContext.ouiaId !== undefined ? consumerContext.ouiaId : generateOUIAId() ? getUniqueId$1() : ouiaId
        });
      }
    }

    render() {
      const {
        isOuia,
        ouiaId
      } = this.state;
      const {
        component: WrappedComponent,
        componentProps,
        consumerContext
      } = this.props;
      return React.createElement(OuiaContext.Provider, {
        value: {
          isOuia: consumerContext && consumerContext.isOuia || isOuia,
          ouiaId: consumerContext && consumerContext.ouiaId || ouiaId
        }
      }, React.createElement(OuiaContext.Consumer, null, value => React.createElement(WrappedComponent, _extends$5({}, componentProps, {
        ouiaContext: value
      }))));
    }

  }

  _defineProperty$4(ComponentWithOuia, "propTypes", {
    component: _pt.any.isRequired,
    componentProps: _pt.any.isRequired,
    consumerContext: _pt.shape({
      isOuia: _pt.bool,
      ouiaId: _pt.oneOfType([_pt.number, _pt.string])
    })
  });

  function _extends$6() { _extends$6 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$6.apply(this, arguments); }

  function _objectWithoutProperties$5(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$5(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$5(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (ButtonVariant) {
    ButtonVariant["primary"] = "primary";
    ButtonVariant["secondary"] = "secondary";
    ButtonVariant["tertiary"] = "tertiary";
    ButtonVariant["danger"] = "danger";
    ButtonVariant["link"] = "link";
    ButtonVariant["plain"] = "plain";
    ButtonVariant["control"] = "control";
  })(exports.ButtonVariant || (exports.ButtonVariant = {}));

  (function (ButtonType) {
    ButtonType["button"] = "button";
    ButtonType["submit"] = "submit";
    ButtonType["reset"] = "reset";
  })(exports.ButtonType || (exports.ButtonType = {}));

  const Button = (_ref) => {
    let {
      children = null,
      className = '',
      component = 'button',
      isActive = false,
      isBlock = false,
      isDisabled = false,
      isFocus = false,
      isHover = false,
      isInline = false,
      type = exports.ButtonType.button,
      variant = exports.ButtonVariant.primary,
      iconPosition = 'left',
      'aria-label': ariaLabel = null,
      icon = null,
      ouiaContext = null,
      ouiaId = null,
      tabIndex = null
    } = _ref,
        props = _objectWithoutProperties$5(_ref, ["children", "className", "component", "isActive", "isBlock", "isDisabled", "isFocus", "isHover", "isInline", "type", "variant", "iconPosition", "aria-label", "icon", "ouiaContext", "ouiaId", "tabIndex"]);

    const Component = component;
    const isButtonElement = Component === 'button';
    return React.createElement(Component, _extends$6({}, props, {
      "aria-disabled": isButtonElement ? null : isDisabled,
      "aria-label": ariaLabel,
      className: css$1(buttonStyles.button, getModifier(buttonStyles.modifiers, variant), isBlock && buttonStyles.modifiers.block, isDisabled && !isButtonElement && buttonStyles.modifiers.disabled, isActive && buttonStyles.modifiers.active, isFocus && buttonStyles.modifiers.focus, isHover && buttonStyles.modifiers.hover, isInline && variant === exports.ButtonVariant.link && buttonStyles.modifiers.inline, className),
      disabled: isButtonElement ? isDisabled : null,
      tabIndex: isDisabled && !isButtonElement ? -1 : tabIndex,
      type: isButtonElement ? type : null
    }, ouiaContext.isOuia && {
      'data-ouia-component-type': 'Button',
      'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
    }), icon && variant === exports.ButtonVariant.link && iconPosition === 'left' && React.createElement("span", {
      className: "pf-c-button__icon"
    }, icon), variant === exports.ButtonVariant.link && React.createElement("span", {
      className: css$1(buttonStyles.buttonText)
    }, children), variant !== exports.ButtonVariant.link && children, icon && variant === exports.ButtonVariant.link && iconPosition === 'right' && React.createElement("span", {
      className: "pf-c-button__icon"
    }, icon));
  };

  Button.propTypes = {
    children: _pt.node,
    className: _pt.string,
    component: _pt.any,
    isActive: _pt.bool,
    isBlock: _pt.bool,
    isDisabled: _pt.bool,
    isFocus: _pt.bool,
    isHover: _pt.bool,
    isInline: _pt.bool,
    type: _pt.oneOf(['button', 'submit', 'reset']),
    variant: _pt.oneOf(['primary', 'secondary', 'tertiary', 'danger', 'link', 'plain', 'control']),
    iconPosition: _pt.oneOf(['left', 'right']),
    'aria-label': _pt.string,
    icon: _pt.oneOfType([_pt.node, _pt.oneOf([null])]),
    tabIndex: _pt.number
  };
  const ButtonWithOuiaContext = withOuiaContext(Button);

  var common = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getSize = exports.defaultProps = exports.propTypes = exports.IconSize = void 0;

  var _propTypes = _interopRequireDefault(_pt);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  var IconSize = {
    sm: 'sm',
    md: 'md',
    lg: 'lg',
    xl: 'xl'
  };
  exports.IconSize = IconSize;
  var propTypes = {
    color: _propTypes["default"].string,
    size: _propTypes["default"].oneOf(Object.keys(IconSize)),
    title: _propTypes["default"].string,
    noVerticalAlign: _propTypes["default"].bool
  };
  exports.propTypes = propTypes;
  var defaultProps = {
    color: 'currentColor',
    size: IconSize.sm,
    title: null,
    noVerticalAlign: false
  };
  exports.defaultProps = defaultProps;

  var getSize = function getSize(size) {
    switch (size) {
      case IconSize.sm:
        return '1em';

      case IconSize.md:
        return '1.5em';

      case IconSize.lg:
        return '2em';

      case IconSize.xl:
        return '3em';

      default:
        return '1em';
    }
  };

  exports.getSize = getSize;

  });

  unwrapExports(common);
  var common_1 = common.getSize;
  var common_2 = common.defaultProps;
  var common_3 = common.propTypes;
  var common_4 = common.IconSize;

  var createIcon_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireDefault(React__default);



  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

  function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

  function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

  function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

  function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

  function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

  function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

  function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

  function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  var currentId = 0;

  var createIcon = function createIcon(iconDefinition) {
    var viewBox = [iconDefinition.xOffset || 0, iconDefinition.yOffset || 0, iconDefinition.width, iconDefinition.height].join(' ');
    var transform = iconDefinition.transform;

    var Icon =
    /*#__PURE__*/
    function (_React$Component) {
      _inherits(Icon, _React$Component);

      function Icon() {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, Icon);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(Icon)).call.apply(_getPrototypeOf2, [this].concat(args)));

        _defineProperty(_assertThisInitialized(_this), "id", "icon-title-".concat(currentId++));

        return _this;
      }

      _createClass(Icon, [{
        key: "render",
        value: function render() {
          // eslint-disable-next-line @typescript-eslint/no-unused-vars
          var _this$props = this.props,
              size = _this$props.size,
              color = _this$props.color,
              title = _this$props.title,
              noStyle = _this$props.noStyle,
              noVerticalAlign = _this$props.noVerticalAlign,
              props = _objectWithoutProperties(_this$props, ["size", "color", "title", "noStyle", "noVerticalAlign"]);

          var hasTitle = Boolean(title);
          var heightWidth = (0, common.getSize)(size);
          var baseAlign = -0.125 * Number.parseFloat(heightWidth);
          var style = noVerticalAlign ? null : {
            verticalAlign: "".concat(baseAlign, "em")
          };
          return _react["default"].createElement("svg", _extends({
            style: style,
            fill: color,
            height: heightWidth,
            width: heightWidth,
            viewBox: viewBox,
            "aria-labelledby": hasTitle ? this.id : null,
            "aria-hidden": hasTitle ? null : true,
            role: "img"
          }, props), hasTitle && _react["default"].createElement("title", {
            id: this.id
          }, title), _react["default"].createElement("path", {
            d: iconDefinition.svgPath,
            transform: transform
          }));
        }
      }]);

      return Icon;
    }(_react["default"].Component);

    _defineProperty(Icon, "displayName", iconDefinition.name);

    _defineProperty(Icon, "propTypes", common.propTypes);

    _defineProperty(Icon, "defaultProps", common.defaultProps);

    return Icon;
  };

  var _default = createIcon;
  exports["default"] = _default;

  });

  unwrapExports(createIcon_1);

  var timesIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.TimesIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var TimesIconConfig = {
    name: 'TimesIcon',
    height: 512,
    width: 352,
    svgPath: 'M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.TimesIconConfig = TimesIconConfig;

  var _default = (0, _createIcon["default"])(TimesIconConfig);

  exports["default"] = _default;

  });

  var TimesIcon = unwrapExports(timesIcon);
  var timesIcon_1 = timesIcon.TimesIconConfig;

  function _extends$7() { _extends$7 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$7.apply(this, arguments); }

  function _objectWithoutProperties$6(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$6(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$6(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AboutModalBoxCloseButton = (_ref) => {
    let {
      className = '',
      onClose = () => undefined,
      'aria-label': ariaLabel = 'Close Dialog'
    } = _ref,
        props = _objectWithoutProperties$6(_ref, ["className", "onClose", "aria-label"]);

    return React.createElement("div", _extends$7({
      className: css$1(styles$2.aboutModalBoxClose, className)
    }, props), React.createElement(ButtonWithOuiaContext, {
      variant: "plain",
      onClick: onClose,
      "aria-label": ariaLabel
    }, React.createElement(TimesIcon, null)));
  };
  AboutModalBoxCloseButton.propTypes = {
    className: _pt.string,
    onClose: _pt.func,
    'aria-label': _pt.string
  };

  function _extends$8() { _extends$8 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$8.apply(this, arguments); }

  function _objectWithoutProperties$7(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$7(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$7(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AboutModalBox = (_ref) => {
    let {
      children,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$7(_ref, ["children", "className"]);

    return React.createElement("div", _extends$8({
      role: "dialog",
      "aria-modal": "true",
      className: css$1(styles$2.aboutModalBox, className)
    }, props), children);
  };
  AboutModalBox.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string
  };

  function _extends$9() { _extends$9 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$9.apply(this, arguments); }

  function _objectWithoutProperties$8(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$8(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$8(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Backdrop = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$8(_ref, ["children", "className"]);

    return React.createElement("div", _extends$9({}, props, {
      className: css$1(styles.backdrop, className)
    }), children);
  };
  Backdrop.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$a() { _extends$a = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$a.apply(this, arguments); }

  function _objectWithoutProperties$9(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$9(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$9(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AboutModalContainer = (_ref) => {
    let {
      children,
      className = '',
      isOpen = false,
      onClose = () => undefined,
      productName = '',
      trademark,
      brandImageSrc,
      brandImageAlt,
      backgroundImageSrc,
      ariaLabelledbyId,
      ariaDescribedById,
      closeButtonAriaLabel
    } = _ref,
        props = _objectWithoutProperties$9(_ref, ["children", "className", "isOpen", "onClose", "productName", "trademark", "brandImageSrc", "brandImageAlt", "backgroundImageSrc", "ariaLabelledbyId", "ariaDescribedById", "closeButtonAriaLabel"]);

    if (!isOpen) {
      return null;
    }

    return React.createElement(Backdrop, null, React.createElement(FocusTrap, {
      focusTrapOptions: {
        clickOutsideDeactivates: true
      },
      className: css$1(styles$1.bullseye)
    }, React.createElement(AboutModalBox, {
      className: className,
      "aria-labelledby": ariaLabelledbyId,
      "aria-describedby": ariaDescribedById
    }, React.createElement(AboutModalBoxBrand, {
      src: brandImageSrc,
      alt: brandImageAlt
    }), React.createElement(AboutModalBoxCloseButton, {
      "aria-label": closeButtonAriaLabel,
      onClose: onClose
    }), productName && React.createElement(AboutModalBoxHeader, {
      id: ariaLabelledbyId,
      productName: productName
    }), React.createElement(AboutModalBoxContent, _extends$a({
      trademark: trademark,
      id: ariaDescribedById,
      noAboutModalBoxContentContainer: false
    }, props), children), React.createElement(AboutModalBoxHero, {
      backgroundImageSrc: backgroundImageSrc
    }))));
  };
  AboutModalContainer.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string,
    isOpen: _pt.bool,
    onClose: _pt.func,
    productName: _pt.string,
    trademark: _pt.string,
    brandImageSrc: _pt.string.isRequired,
    brandImageAlt: _pt.string.isRequired,
    backgroundImageSrc: _pt.string,
    ariaLabelledbyId: _pt.string.isRequired,
    ariaDescribedById: _pt.string.isRequired,
    closeButtonAriaLabel: _pt.string
  };

  function _extends$b() { _extends$b = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$b.apply(this, arguments); }

  function _objectWithoutProperties$a(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$a(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$a(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$5(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class AboutModal extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$5(this, "id", AboutModal.currentId++);

      _defineProperty$5(this, "ariaLabelledBy", `pf-about-modal-title-${this.id}`);

      _defineProperty$5(this, "ariaDescribedBy", `pf-about-modal-content-${this.id}`);

      _defineProperty$5(this, "handleEscKeyClick", event => {
        if (event.keyCode === KEY_CODES.ESCAPE_KEY && this.props.isOpen) {
          this.props.onClose();
        }
      });

      _defineProperty$5(this, "toggleSiblingsFromScreenReaders", hide => {
        const {
          appendTo
        } = this.props;
        const target = this.getElement(appendTo);
        const bodyChildren = target.children;

        for (const child of Array.from(bodyChildren)) {
          if (child !== this.state.container) {
            hide ? child.setAttribute('aria-hidden', '' + hide) : child.removeAttribute('aria-hidden');
          }
        }
      });

      _defineProperty$5(this, "getElement", appendTo => {
        if (typeof appendTo === 'function') {
          return appendTo();
        }

        return appendTo || document.body;
      });

      this.state = {
        container: undefined
      };

      if (props.brandImageSrc && !props.brandImageAlt) {
        // eslint-disable-next-line no-console
        console.error('AboutModal:', 'brandImageAlt is required when a brandImageSrc is specified');
      }
    }

    componentDidMount() {
      const container = document.createElement('div');
      const target = this.getElement(this.props.appendTo);
      this.setState({
        container
      });
      target.appendChild(container);
      target.addEventListener('keydown', this.handleEscKeyClick, false);

      if (this.props.isOpen) {
        target.classList.add(css$1(styles.backdropOpen));
      } else {
        target.classList.remove(css$1(styles.backdropOpen));
      }
    }

    componentDidUpdate() {
      const target = this.getElement(this.props.appendTo);

      if (this.props.isOpen) {
        target.classList.add(css$1(styles.backdropOpen));
        this.toggleSiblingsFromScreenReaders(true);
      } else {
        target.classList.remove(css$1(styles.backdropOpen));
        this.toggleSiblingsFromScreenReaders(false);
      }
    }

    componentWillUnmount() {
      const target = this.getElement(this.props.appendTo);

      if (this.state.container) {
        target.removeChild(this.state.container);
      }

      target.removeEventListener('keydown', this.handleEscKeyClick, false);
      target.classList.remove(css$1(styles.backdropOpen));
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            props = _objectWithoutProperties$a(_this$props, ["appendTo"]);

      const {
        container
      } = this.state;

      if (!canUseDOM || !container) {
        return null;
      }

      return ReactDOM.createPortal(React.createElement(AboutModalContainer, _extends$b({
        ariaLabelledbyId: this.ariaLabelledBy,
        ariaDescribedById: this.ariaDescribedBy
      }, props)), container);
    }

  }

  _defineProperty$5(AboutModal, "propTypes", {
    children: _pt.node.isRequired,
    className: _pt.string,
    isOpen: _pt.bool,
    onClose: _pt.func,
    productName: _pt.string,
    trademark: _pt.string,
    brandImageSrc: _pt.string.isRequired,
    brandImageAlt: _pt.string.isRequired,
    backgroundImageSrc: _pt.string,
    noAboutModalBoxContentContainer: _pt.bool,
    appendTo: _pt.oneOfType([_pt.any, _pt.func]),
    closeButtonAriaLabel: _pt.string
  });

  _defineProperty$5(AboutModal, "currentId", 0);

  _defineProperty$5(AboutModal, "defaultProps", {
    className: '',
    isOpen: false,
    onClose: () => undefined,
    productName: '',
    trademark: '',
    backgroundImageSrc: '',
    noAboutModalBoxContentContainer: false,
    appendTo: null
  });

  var accordion = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      accordion: 'pf-c-accordion',
      accordionToggle: 'pf-c-accordion__toggle',
      accordionToggleText: 'pf-c-accordion__toggle-text',
      accordionToggleIcon: 'pf-c-accordion__toggle-icon',
      accordionExpandedContent: 'pf-c-accordion__expanded-content',
      accordionExpandedContentBody: 'pf-c-accordion__expanded-content-body',
      modifiers: {
          'noBoxShadow': 'pf-m-no-box-shadow',
          'expanded': 'pf-m-expanded',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus',
          'fixed': 'pf-m-fixed'
      }
  };
  });

  var styles$4 = unwrapExports(accordion);

  const AccordionContext = React.createContext({});

  function _extends$c() { _extends$c = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$c.apply(this, arguments); }

  function _objectWithoutProperties$b(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$b(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$b(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Accordion = (_ref) => {
    let {
      children = null,
      className = '',
      'aria-label': ariaLabel = '',
      headingLevel = 'h3',
      asDefinitionList = true,
      noBoxShadow = false
    } = _ref,
        props = _objectWithoutProperties$b(_ref, ["children", "className", "aria-label", "headingLevel", "asDefinitionList", "noBoxShadow"]);

    const AccordionList = asDefinitionList ? 'dl' : 'div';
    return React.createElement(AccordionList, _extends$c({
      className: css$1(styles$4.accordion, noBoxShadow && styles$4.modifiers.noBoxShadow, className),
      "aria-label": ariaLabel
    }, props), React.createElement(AccordionContext.Provider, {
      value: {
        ContentContainer: asDefinitionList ? 'dd' : 'div',
        ToggleContainer: asDefinitionList ? 'dt' : headingLevel
      }
    }, children));
  };
  Accordion.propTypes = {
    children: _pt.node,
    className: _pt.string,
    'aria-label': _pt.string,
    headingLevel: _pt.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6']),
    asDefinitionList: _pt.bool,
    noBoxShadow: _pt.bool
  };

  const AccordionItem = ({
    children = null
  }) => React.createElement(React.Fragment, null, children);
  AccordionItem.propTypes = {
    children: _pt.node
  };

  function _extends$d() { _extends$d = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$d.apply(this, arguments); }

  function _objectWithoutProperties$c(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$c(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$c(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AccordionContent = (_ref) => {
    let {
      className = '',
      children = null,
      id = '',
      isHidden = false,
      isFixed = false,
      'aria-label': ariaLabel = '',
      component
    } = _ref,
        props = _objectWithoutProperties$c(_ref, ["className", "children", "id", "isHidden", "isFixed", "aria-label", "component"]);

    return React.createElement(AccordionContext.Consumer, null, ({
      ContentContainer
    }) => {
      const Container = component || ContentContainer;
      return React.createElement(Container, _extends$d({
        id: id,
        className: css$1(styles$4.accordionExpandedContent, isFixed && styles$4.modifiers.fixed, !isHidden && styles$4.modifiers.expanded, className),
        hidden: isHidden,
        "aria-label": ariaLabel
      }, props), React.createElement("div", {
        className: css$1(styles$4.accordionExpandedContentBody)
      }, children));
    });
  };
  AccordionContent.propTypes = {
    children: _pt.node,
    className: _pt.string,
    id: _pt.string,
    isHidden: _pt.bool,
    isFixed: _pt.bool,
    'aria-label': _pt.string,
    component: _pt.any
  };

  var angleRightIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.AngleRightIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var AngleRightIconConfig = {
    name: 'AngleRightIcon',
    height: 512,
    width: 256,
    svgPath: 'M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.AngleRightIconConfig = AngleRightIconConfig;

  var _default = (0, _createIcon["default"])(AngleRightIconConfig);

  exports["default"] = _default;

  });

  var AngleRightIcon = unwrapExports(angleRightIcon);
  var angleRightIcon_1 = angleRightIcon.AngleRightIconConfig;

  function _extends$e() { _extends$e = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$e.apply(this, arguments); }

  function _objectWithoutProperties$d(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$d(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$d(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AccordionToggle = (_ref) => {
    let {
      className = '',
      id,
      isExpanded = false,
      children = null,
      component
    } = _ref,
        props = _objectWithoutProperties$d(_ref, ["className", "id", "isExpanded", "children", "component"]);

    return React.createElement(AccordionContext.Consumer, null, ({
      ToggleContainer
    }) => {
      const Container = component || ToggleContainer;
      return React.createElement(Container, null, React.createElement("button", _extends$e({
        id: id,
        className: css$1(styles$4.accordionToggle, isExpanded && styles$4.modifiers.expanded, className)
      }, props, {
        "aria-expanded": isExpanded
      }), React.createElement("span", {
        className: css$1(styles$4.accordionToggleText)
      }, children), React.createElement(AngleRightIcon, {
        className: css$1(styles$4.accordionToggleIcon)
      })));
    });
  };
  AccordionToggle.propTypes = {
    children: _pt.node,
    className: _pt.string,
    isExpanded: _pt.bool,
    id: _pt.string.isRequired,
    component: _pt.any
  };

  var alert = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      alert: 'pf-c-alert',
      alertIcon: 'pf-c-alert__icon',
      alertTitle: 'pf-c-alert__title',
      alertDescription: 'pf-c-alert__description',
      alertAction: 'pf-c-alert__action',
      modifiers: {
          'success': 'pf-m-success',
          'inline': 'pf-m-inline',
          'danger': 'pf-m-danger',
          'warning': 'pf-m-warning',
          'info': 'pf-m-info',
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var styles$5 = unwrapExports(alert);

  var accessibility = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      screenReader: 'pf-u-screen-reader',
      visible: 'pf-u-visible',
      hidden: 'pf-u-hidden',
      screenReaderOnSm: 'pf-u-screen-reader-on-sm',
      visibleOnSm: 'pf-u-visible-on-sm',
      hiddenOnSm: 'pf-u-hidden-on-sm',
      screenReaderOnMd: 'pf-u-screen-reader-on-md',
      visibleOnMd: 'pf-u-visible-on-md',
      hiddenOnMd: 'pf-u-hidden-on-md',
      screenReaderOnLg: 'pf-u-screen-reader-on-lg',
      visibleOnLg: 'pf-u-visible-on-lg',
      hiddenOnLg: 'pf-u-hidden-on-lg',
      screenReaderOnXl: 'pf-u-screen-reader-on-xl',
      visibleOnXl: 'pf-u-visible-on-xl',
      hiddenOnXl: 'pf-u-hidden-on-xl',
      screenReaderOn_2xl: 'pf-u-screen-reader-on-2xl',
      visibleOn_2xl: 'pf-u-visible-on-2xl',
      hiddenOn_2xl: 'pf-u-hidden-on-2xl',
      modifiers: {}
  };
  });

  var a11yStyles = unwrapExports(accessibility);

  var checkCircleIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.CheckCircleIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var CheckCircleIconConfig = {
    name: 'CheckCircleIcon',
    height: 512,
    width: 512,
    svgPath: 'M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.CheckCircleIconConfig = CheckCircleIconConfig;

  var _default = (0, _createIcon["default"])(CheckCircleIconConfig);

  exports["default"] = _default;

  });

  var CheckCircleIcon = unwrapExports(checkCircleIcon);
  var checkCircleIcon_1 = checkCircleIcon.CheckCircleIconConfig;

  var exclamationCircleIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ExclamationCircleIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var ExclamationCircleIconConfig = {
    name: 'ExclamationCircleIcon',
    height: 512,
    width: 512,
    svgPath: 'M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.ExclamationCircleIconConfig = ExclamationCircleIconConfig;

  var _default = (0, _createIcon["default"])(ExclamationCircleIconConfig);

  exports["default"] = _default;

  });

  var ExclamationCircleIcon = unwrapExports(exclamationCircleIcon);
  var exclamationCircleIcon_1 = exclamationCircleIcon.ExclamationCircleIconConfig;

  var exclamationTriangleIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ExclamationTriangleIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var ExclamationTriangleIconConfig = {
    name: 'ExclamationTriangleIcon',
    height: 512,
    width: 576,
    svgPath: 'M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.ExclamationTriangleIconConfig = ExclamationTriangleIconConfig;

  var _default = (0, _createIcon["default"])(ExclamationTriangleIconConfig);

  exports["default"] = _default;

  });

  var ExclamationTriangleIcon = unwrapExports(exclamationTriangleIcon);
  var exclamationTriangleIcon_1 = exclamationTriangleIcon.ExclamationTriangleIconConfig;

  var infoCircleIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.InfoCircleIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var InfoCircleIconConfig = {
    name: 'InfoCircleIcon',
    height: 512,
    width: 512,
    svgPath: 'M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.InfoCircleIconConfig = InfoCircleIconConfig;

  var _default = (0, _createIcon["default"])(InfoCircleIconConfig);

  exports["default"] = _default;

  });

  var InfoCircleIcon = unwrapExports(infoCircleIcon);
  var infoCircleIcon_1 = infoCircleIcon.InfoCircleIconConfig;

  var bellIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.BellIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var BellIconConfig = {
    name: 'BellIcon',
    height: 512,
    width: 448,
    svgPath: 'M224 512c35.32 0 63.97-28.65 63.97-64H160.03c0 35.35 28.65 64 63.97 64zm215.39-149.71c-19.32-20.76-55.47-51.99-55.47-154.29 0-77.7-54.48-139.9-127.94-155.16V32c0-17.67-14.32-32-31.98-32s-31.98 14.33-31.98 32v20.84C118.56 68.1 64.08 130.3 64.08 208c0 102.3-36.15 133.53-55.47 154.29-6 6.45-8.66 14.16-8.61 21.71.11 16.4 12.98 32 32.1 32h383.8c19.12 0 32-15.6 32.1-32 .05-7.55-2.61-15.27-8.61-21.71z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.BellIconConfig = BellIconConfig;

  var _default = (0, _createIcon["default"])(BellIconConfig);

  exports["default"] = _default;

  });

  var BellIcon = unwrapExports(bellIcon);
  var bellIcon_1 = bellIcon.BellIconConfig;

  function _extends$f() { _extends$f = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$f.apply(this, arguments); }

  function _objectWithoutProperties$e(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$e(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$e(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const variantIcons = {
    success: CheckCircleIcon,
    danger: ExclamationCircleIcon,
    warning: ExclamationTriangleIcon,
    info: InfoCircleIcon,
    default: BellIcon
  };
  const AlertIcon = (_ref) => {
    let {
      variant,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$e(_ref, ["variant", "className"]);

    const Icon = variantIcons[variant];
    return React.createElement("div", _extends$f({}, props, {
      className: css$1(styles$5.alertIcon, className)
    }), React.createElement(Icon, null));
  };
  AlertIcon.propTypes = {
    variant: _pt.oneOf(['success', 'danger', 'warning', 'info', 'default']).isRequired,
    className: _pt.string
  };

  const AlertContext = React.createContext(null);

  function _extends$g() { _extends$g = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$g.apply(this, arguments); }

  function _objectWithoutProperties$f(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$f(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$f(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (AlertVariant) {
    AlertVariant["success"] = "success";
    AlertVariant["danger"] = "danger";
    AlertVariant["warning"] = "warning";
    AlertVariant["info"] = "info";
    AlertVariant["default"] = "default";
  })(exports.AlertVariant || (exports.AlertVariant = {}));

  const Alert = (_ref) => {
    let {
      variant = exports.AlertVariant.info,
      isInline = false,
      isLiveRegion = false,
      variantLabel = `${capitalize(variant)} alert:`,
      'aria-label': ariaLabel = `${capitalize(variant)} Alert`,
      action = null,
      title,
      children = '',
      className = '',
      ouiaContext = null,
      ouiaId = null
    } = _ref,
        props = _objectWithoutProperties$f(_ref, ["variant", "isInline", "isLiveRegion", "variantLabel", "aria-label", "action", "title", "children", "className", "ouiaContext", "ouiaId"]);

    const getHeadingContent = React.createElement(React.Fragment, null, React.createElement("span", {
      className: css$1(a11yStyles.screenReader)
    }, variantLabel), title);
    const customClassName = css$1(styles$5.alert, isInline && styles$5.modifiers.inline, variant !== exports.AlertVariant.default && getModifier(styles$5, variant, styles$5.modifiers.info), className);
    return React.createElement("div", _extends$g({}, props, {
      className: customClassName,
      "aria-label": ariaLabel
    }, ouiaContext.isOuia && {
      'data-ouia-component-type': 'Alert',
      'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
    }, isLiveRegion && {
      'aria-live': 'polite',
      'aria-atomic': 'false'
    }), React.createElement(AlertIcon, {
      variant: variant
    }), React.createElement("h4", {
      className: css$1(styles$5.alertTitle)
    }, getHeadingContent), children && React.createElement("div", {
      className: css$1(styles$5.alertDescription)
    }, children), React.createElement(AlertContext.Provider, {
      value: {
        title,
        variantLabel
      }
    }, action && (typeof action === 'object' || typeof action === 'string') && React.createElement("div", {
      className: css$1(styles$5.alertAction)
    }, action)));
  };

  Alert.propTypes = {
    variant: _pt.oneOf(['success', 'danger', 'warning', 'info', 'default']),
    isInline: _pt.bool,
    title: _pt.node.isRequired,
    action: _pt.node,
    children: _pt.node,
    className: _pt.string,
    'aria-label': _pt.string,
    variantLabel: _pt.string,
    isLiveRegion: _pt.bool
  };
  const AlertWithOuiaContext = withOuiaContext(Alert);

  function _extends$h() { _extends$h = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$h.apply(this, arguments); }

  function _objectWithoutProperties$g(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$g(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$g(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AlertActionCloseButton = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      onClose = () => undefined,
      'aria-label': ariaLabel = '',
      variantLabel
    } = _ref,
        props = _objectWithoutProperties$g(_ref, ["className", "onClose", "aria-label", "variantLabel"]);

    return React.createElement(AlertContext.Consumer, null, ({
      title,
      variantLabel: alertVariantLabel
    }) => React.createElement(ButtonWithOuiaContext, _extends$h({
      variant: exports.ButtonVariant.plain,
      onClick: onClose,
      "aria-label": ariaLabel === '' ? `Close ${variantLabel || alertVariantLabel} alert: ${title}` : ariaLabel
    }, props), React.createElement(TimesIcon, null)));
  };
  AlertActionCloseButton.propTypes = {
    className: _pt.string,
    onClose: _pt.func,
    'aria-label': _pt.string,
    variantLabel: _pt.string
  };

  function _extends$i() { _extends$i = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$i.apply(this, arguments); }

  function _objectWithoutProperties$h(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$h(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$h(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AlertActionLink = (_ref) => {
    let {
      className = '',
      children
    } = _ref,
        props = _objectWithoutProperties$h(_ref, ["className", "children"]);

    return React.createElement(ButtonWithOuiaContext, _extends$i({
      variant: exports.ButtonVariant.link,
      className: className
    }, props), children);
  };
  AlertActionLink.propTypes = {
    children: _pt.string,
    className: _pt.string
  };

  var alertGroup = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      alertGroup: 'pf-c-alert-group',
      modifiers: {
          'toast': 'pf-m-toast'
      }
  };
  });

  var styles$6 = unwrapExports(alertGroup);

  function _extends$j() { _extends$j = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$j.apply(this, arguments); }

  function _objectWithoutProperties$i(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$i(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$i(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const AlertGroupInline = (_ref) => {
    let {
      className,
      children,
      isToast
    } = _ref,
        rest = _objectWithoutProperties$i(_ref, ["className", "children", "isToast"]);

    return React.createElement("ul", _extends$j({
      className: css$1(styles$6.alertGroup, className, isToast ? styles$6.modifiers.toast : '')
    }, rest), React.Children.toArray(children).map((Alert, index) => React.createElement("li", {
      key: index
    }, Alert)));
  };

  function _defineProperty$6(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class AlertGroup extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$6(this, "state", {
        container: undefined
      });
    }

    componentDidMount() {
      const container = document.createElement('div');
      const target = this.getTargetElement();
      this.setState({
        container
      });
      target.appendChild(container);
    }

    componentWillUnmount() {
      const target = this.getTargetElement();

      if (this.state.container) {
        target.removeChild(this.state.container);
      }
    }

    getTargetElement() {
      const appendTo = this.props.appendTo;

      if (typeof appendTo === 'function') {
        return appendTo();
      }

      return appendTo || document.body;
    }

    render() {
      const {
        className,
        children,
        isToast
      } = this.props;
      const alertGroup = React.createElement(AlertGroupInline, {
        className: className,
        isToast: isToast
      }, children);

      if (!this.props.isToast) {
        return alertGroup;
      }

      const container = this.state.container;

      if (!canUseDOM || !container) {
        return null;
      }

      return ReactDOM.createPortal(alertGroup, container);
    }

  }

  _defineProperty$6(AlertGroup, "propTypes", {
    className: _pt.string,
    children: _pt.node,
    isToast: _pt.bool,
    appendTo: _pt.oneOfType([_pt.any, _pt.func])
  });

  var appLauncher = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      appLauncher: 'pf-c-app-launcher',
      appLauncherToggle: 'pf-c-app-launcher__toggle',
      divider: 'pf-c-divider',
      appLauncherMenu: 'pf-c-app-launcher__menu',
      appLauncherMenuSearch: 'pf-c-app-launcher__menu-search',
      appLauncherMenuWrapper: 'pf-c-app-launcher__menu-wrapper',
      appLauncherMenuItem: 'pf-c-app-launcher__menu-item',
      appLauncherMenuItemExternalIcon: 'pf-c-app-launcher__menu-item-external-icon',
      appLauncherMenuItemIcon: 'pf-c-app-launcher__menu-item-icon',
      appLauncherSeparator: 'pf-c-app-launcher__separator',
      appLauncherGroup: 'pf-c-app-launcher__group',
      appLauncherGroupTitle: 'pf-c-app-launcher__group-title',
      modifiers: {
          'expanded': 'pf-m-expanded',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus',
          'disabled': 'pf-m-disabled',
          'alignRight': 'pf-m-align-right',
          'top': 'pf-m-top',
          'favorite': 'pf-m-favorite',
          'external': 'pf-m-external',
          'link': 'pf-m-link',
          'action': 'pf-m-action'
      }
  };
  });

  var styles$7 = unwrapExports(appLauncher);

  var formControl = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      formControl: 'pf-c-form-control',
      modifiers: {
          'hover': 'pf-m-hover',
          'focus': 'pf-m-focus',
          'success': 'pf-m-success',
          'search': 'pf-m-search',
          'resizeVertical': 'pf-m-resize-vertical',
          'resizeHorizontal': 'pf-m-resize-horizontal'
      }
  };
  });

  var formStyles = unwrapExports(formControl);

  var thIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ThIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var ThIconConfig = {
    name: 'ThIcon',
    height: 512,
    width: 512,
    svgPath: 'M149.333 56v80c0 13.255-10.745 24-24 24H24c-13.255 0-24-10.745-24-24V56c0-13.255 10.745-24 24-24h101.333c13.255 0 24 10.745 24 24zm181.334 240v-80c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.256 0 24.001-10.745 24.001-24zm32-240v80c0 13.255 10.745 24 24 24H488c13.255 0 24-10.745 24-24V56c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24zm-32 80V56c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.256 0 24.001-10.745 24.001-24zm-205.334 56H24c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24zM0 376v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H24c-13.255 0-24 10.745-24 24zm386.667-56H488c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24zm0 160H488c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24zM181.333 376v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.ThIconConfig = ThIconConfig;

  var _default = (0, _createIcon["default"])(ThIconConfig);

  exports["default"] = _default;

  });

  var ThIcon = unwrapExports(thIcon);
  var thIcon_1 = thIcon.ThIconConfig;

  var dropdown = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      dropdown: 'pf-c-dropdown',
      divider: 'pf-c-divider',
      dropdownToggle: 'pf-c-dropdown__toggle',
      dropdownToggleButton: 'pf-c-dropdown__toggle-button',
      dropdownToggleCheck: 'pf-c-dropdown__toggle-check',
      dropdownToggleText: 'pf-c-dropdown__toggle-text',
      dropdownToggleIcon: 'pf-c-dropdown__toggle-icon',
      dropdownMenu: 'pf-c-dropdown__menu',
      dropdownMenuItem: 'pf-c-dropdown__menu-item',
      dropdownMenuItemIcon: 'pf-c-dropdown__menu-item-icon',
      dropdownSeparator: 'pf-c-dropdown__separator',
      dropdownGroup: 'pf-c-dropdown__group',
      dropdownGroupTitle: 'pf-c-dropdown__group-title',
      modifiers: {
          'disabled': 'pf-m-disabled',
          'plain': 'pf-m-plain',
          'splitButton': 'pf-m-split-button',
          'action': 'pf-m-action',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus',
          'expanded': 'pf-m-expanded',
          'primary': 'pf-m-primary',
          'top': 'pf-m-top',
          'alignRight': 'pf-m-align-right',
          'icon': 'pf-m-icon'
      }
  };
  });

  var styles$8 = unwrapExports(dropdown);

  (function (DropdownPosition) {
    DropdownPosition["right"] = "right";
    DropdownPosition["left"] = "left";
  })(exports.DropdownPosition || (exports.DropdownPosition = {}));

  (function (DropdownDirection) {
    DropdownDirection["up"] = "up";
    DropdownDirection["down"] = "down";
  })(exports.DropdownDirection || (exports.DropdownDirection = {}));

  const DropdownContext = React.createContext({
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onSelect: event => undefined,
    id: '',
    toggleIconClass: '',
    toggleTextClass: '',
    menuClass: '',
    itemClass: '',
    toggleClass: '',
    baseClass: '',
    baseComponent: 'div',
    sectionClass: '',
    sectionTitleClass: '',
    sectionComponent: 'section',
    disabledClass: '',
    hoverClass: '',
    separatorClass: '',
    menuComponent: 'ul'
  });
  const DropdownArrowContext = React.createContext({
    keyHandler: null,
    sendRef: null
  });

  function _extends$k() { _extends$k = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$k.apply(this, arguments); }

  function _objectWithoutProperties$j(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$j(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$j(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function ownKeys$3(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$3(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$3(source, true).forEach(function (key) { _defineProperty$7(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$3(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty$7(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DropdownMenu extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$7(this, "refsCollection", []);

      _defineProperty$7(this, "childKeyHandler", (index, innerIndex, position, custom = false) => {
        keyHandler(index, innerIndex, position, this.refsCollection, this.props.isGrouped ? this.refsCollection : React.Children.toArray(this.props.children), custom);
      });

      _defineProperty$7(this, "sendRef", (index, nodes, isDisabled, isSeparator) => {
        this.refsCollection[index] = [];
        nodes.map((node, innerIndex) => {
          if (!node) {
            this.refsCollection[index][innerIndex] = null;
          } else if (!node.getAttribute) {
            // eslint-disable-next-line react/no-find-dom-node
            this.refsCollection[index][innerIndex] = ReactDOM.findDOMNode(node);
          } else if (isDisabled || isSeparator) {
            this.refsCollection[index][innerIndex] = null;
          } else {
            this.refsCollection[index][innerIndex] = node;
          }
        });
      });
    }

    componentDidMount() {
      const {
        autoFocus
      } = this.props;

      if (autoFocus) {
        // Focus first non-disabled element
        const focusTargetCollection = this.refsCollection.find(ref => ref && ref[0] && !ref[0].hasAttribute('disabled'));
        const focusTarget = focusTargetCollection && focusTargetCollection[0];

        if (focusTarget && focusTarget.focus) {
          focusTarget.focus();
        }
      }
    }

    shouldComponentUpdate() {
      // reset refsCollection before updating to account for child removal between mounts
      this.refsCollection = [];
      return true;
    }

    extendChildren() {
      const {
        children,
        isGrouped
      } = this.props;

      if (isGrouped) {
        let index = 0;
        return React.Children.map(children, groupedChildren => {
          const group = groupedChildren;
          return React.cloneElement(group, _objectSpread$3({}, group.props && group.props.children && {
            children: group.props.children.constructor === Array && React.Children.map(group.props.children, option => React.cloneElement(option, {
              index: index++
            })) || React.cloneElement(group.props.children, {
              index: index++
            })
          }));
        });
      }

      return React.Children.map(children, (child, index) => React.cloneElement(child, {
        index
      }));
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            {
        className,
        isOpen,
        position,
        children,
        component,
        isGrouped,
        openedOnEnter
      } = _this$props,
            props = _objectWithoutProperties$j(_this$props, ["className", "isOpen", "position", "children", "component", "isGrouped", "openedOnEnter"]);

      return React.createElement(DropdownArrowContext.Provider, {
        value: {
          keyHandler: this.childKeyHandler,
          sendRef: this.sendRef
        }
      }, component === 'div' ? React.createElement(DropdownContext.Consumer, null, ({
        onSelect,
        menuClass
      }) => React.createElement("div", {
        className: css$1(menuClass, position === exports.DropdownPosition.right && styles$8.modifiers.alignRight, className),
        hidden: !isOpen,
        onClick: event => onSelect && onSelect(event)
      }, children)) : isGrouped && React.createElement(DropdownContext.Consumer, null, ({
        menuClass,
        menuComponent
      }) => {
        const MenuComponent = menuComponent || 'div';
        return React.createElement(MenuComponent, _extends$k({}, props, {
          className: css$1(menuClass, position === exports.DropdownPosition.right && styles$8.modifiers.alignRight, className),
          hidden: !isOpen,
          role: "menu"
        }), this.extendChildren());
      }) || React.createElement(DropdownContext.Consumer, null, ({
        menuClass,
        menuComponent
      }) => {
        const MenuComponent = menuComponent || component;
        return React.createElement(MenuComponent, _extends$k({}, props, {
          className: css$1(menuClass, position === exports.DropdownPosition.right && styles$8.modifiers.alignRight, className),
          hidden: !isOpen,
          role: "menu"
        }), this.extendChildren());
      }));
    }

  }

  _defineProperty$7(DropdownMenu, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    isOpen: _pt.bool,
    openedOnEnter: _pt.bool,
    autoFocus: _pt.bool,
    component: _pt.node,
    position: _pt.oneOfType([_pt.any, _pt.oneOf(['right']), _pt.oneOf(['left'])]),
    isGrouped: _pt.bool
  });

  _defineProperty$7(DropdownMenu, "defaultProps", {
    className: '',
    isOpen: true,
    openedOnEnter: false,
    autoFocus: true,
    position: exports.DropdownPosition.left,
    component: 'ul',
    isGrouped: false
  });

  function _extends$l() { _extends$l = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$l.apply(this, arguments); }

  function _objectWithoutProperties$k(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$k(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$k(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$8(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  class DropdownWithContext extends React.Component {
    // seed for the aria-labelledby ID
    constructor(props) {
      super(props);

      _defineProperty$8(this, "openedOnEnter", false);

      _defineProperty$8(this, "baseComponentRef", React.createRef());

      _defineProperty$8(this, "onEnter", () => {
        this.openedOnEnter = true;
      });

      if (props.dropdownItems && props.dropdownItems.length > 0 && props.children) {
        // eslint-disable-next-line no-console
        console.error('Children and dropdownItems props have been provided. Only the dropdownItems prop items will be rendered');
      }
    }

    componentDidUpdate() {
      if (!this.props.isOpen) {
        this.openedOnEnter = false;
      }
    }

    render() {
      const _this$props = this.props,
            {
        children,
        className,
        direction,
        dropdownItems,
        isOpen,
        isPlain,
        isGrouped,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onSelect,
        position,
        toggle,
        autoFocus,
        ouiaContext,
        ouiaId,
        ouiaComponentType
      } = _this$props,
            props = _objectWithoutProperties$k(_this$props, ["children", "className", "direction", "dropdownItems", "isOpen", "isPlain", "isGrouped", "onSelect", "position", "toggle", "autoFocus", "ouiaContext", "ouiaId", "ouiaComponentType"]);

      const id = toggle.props.id || `pf-toggle-id-${DropdownWithContext.currentId++}`;
      let component;
      let renderedContent;
      let ariaHasPopup = false;

      if (dropdownItems && dropdownItems.length > 0) {
        component = 'ul';
        renderedContent = dropdownItems;
        ariaHasPopup = true;
      } else {
        component = 'div';
        renderedContent = React.Children.toArray(children);
      }

      const openedOnEnter = this.openedOnEnter;
      return React.createElement(DropdownContext.Consumer, null, ({
        baseClass,
        baseComponent,
        id: contextId
      }) => {
        const BaseComponent = baseComponent;
        return React.createElement(BaseComponent, _extends$l({}, props, {
          className: css$1(baseClass, direction === exports.DropdownDirection.up && styles$8.modifiers.top, position === exports.DropdownPosition.right && styles$8.modifiers.alignRight, isOpen && styles$8.modifiers.expanded, className),
          ref: this.baseComponentRef
        }, ouiaContext.isOuia && {
          'data-ouia-component-type': ouiaComponentType,
          'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
        }), React.Children.map(toggle, oneToggle => React.cloneElement(oneToggle, {
          parentRef: this.baseComponentRef,
          isOpen,
          id,
          isPlain,
          ariaHasPopup,
          onEnter: () => this.onEnter()
        })), isOpen && React.createElement(DropdownMenu, {
          component: component,
          isOpen: isOpen,
          position: position,
          "aria-labelledby": contextId ? `${contextId}-toggle` : id,
          openedOnEnter: openedOnEnter,
          isGrouped: isGrouped,
          autoFocus: openedOnEnter && autoFocus
        }, renderedContent));
      });
    }

  }

  _defineProperty$8(DropdownWithContext, "currentId", 0);

  _defineProperty$8(DropdownWithContext, "defaultProps", {
    className: '',
    dropdownItems: [],
    isOpen: false,
    isPlain: false,
    isGrouped: false,
    position: exports.DropdownPosition.left,
    direction: exports.DropdownDirection.down,
    onSelect: () => undefined,
    autoFocus: true,
    ouiaComponentType: 'Dropdown'
  });

  const DropdownWithOuiaContext = withOuiaContext(DropdownWithContext);

  function _objectWithoutProperties$l(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$l(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$l(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Dropdown = (_ref) => {
    let {
      onSelect,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      ref
    } = _ref,
        props = _objectWithoutProperties$l(_ref, ["onSelect", "ref"]);

    return React.createElement(DropdownContext.Provider, {
      value: {
        onSelect: event => onSelect && onSelect(event),
        toggleTextClass: styles$8.dropdownToggleText,
        toggleIconClass: styles$8.dropdownToggleIcon,
        menuClass: styles$8.dropdownMenu,
        itemClass: styles$8.dropdownMenuItem,
        toggleClass: styles$8.dropdownToggle,
        baseClass: styles$8.dropdown,
        baseComponent: 'div',
        sectionClass: styles$8.dropdownGroup,
        sectionTitleClass: styles$8.dropdownGroupTitle,
        sectionComponent: 'section',
        disabledClass: styles$8.modifiers.disabled,
        hoverClass: styles$8.modifiers.hover,
        separatorClass: styles$8.dropdownSeparator
      }
    }, React.createElement(DropdownWithOuiaContext, props));
  };
  Dropdown.propTypes = {
    children: _pt.node,
    className: _pt.string,
    dropdownItems: _pt.arrayOf(_pt.any),
    isOpen: _pt.bool,
    isPlain: _pt.bool,
    position: _pt.oneOfType([_pt.any, _pt.oneOf(['right']), _pt.oneOf(['left'])]),
    direction: _pt.oneOfType([_pt.any, _pt.oneOf(['up']), _pt.oneOf(['down'])]),
    isGrouped: _pt.bool,
    toggle: _pt.element.isRequired,
    onSelect: _pt.func,
    autoFocus: _pt.bool,
    ouiaComponentType: _pt.string
  };

  const DropdownGroup = ({
    children = null,
    className = '',
    label = ''
  }) => React.createElement(DropdownContext.Consumer, null, ({
    sectionClass,
    sectionTitleClass,
    sectionComponent
  }) => {
    const SectionComponent = sectionComponent;
    return React.createElement(SectionComponent, {
      className: css$1(sectionClass, className)
    }, label && React.createElement("h1", {
      className: css$1(sectionTitleClass),
      "aria-hidden": true
    }, label), React.createElement("ul", {
      role: "none"
    }, children));
  });
  DropdownGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    label: _pt.node
  };

  /**!
   * @fileOverview Kickass library to create and place poppers near their reference elements.
   * @version 1.16.0
   * @license
   * Copyright (c) 2016 Federico Zivolo and contributors
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to deal
   * in the Software without restriction, including without limitation the rights
   * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   * copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in all
   * copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   * SOFTWARE.
   */
  var isBrowser$1 = typeof window !== 'undefined' && typeof document !== 'undefined' && typeof navigator !== 'undefined';

  var timeoutDuration = function () {
    var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];
    for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
      if (isBrowser$1 && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
        return 1;
      }
    }
    return 0;
  }();

  function microtaskDebounce(fn) {
    var called = false;
    return function () {
      if (called) {
        return;
      }
      called = true;
      window.Promise.resolve().then(function () {
        called = false;
        fn();
      });
    };
  }

  function taskDebounce(fn) {
    var scheduled = false;
    return function () {
      if (!scheduled) {
        scheduled = true;
        setTimeout(function () {
          scheduled = false;
          fn();
        }, timeoutDuration);
      }
    };
  }

  var supportsMicroTasks = isBrowser$1 && window.Promise;

  /**
  * Create a debounced version of a method, that's asynchronously deferred
  * but called in the minimum time possible.
  *
  * @method
  * @memberof Popper.Utils
  * @argument {Function} fn
  * @returns {Function}
  */
  var debounce$1 = supportsMicroTasks ? microtaskDebounce : taskDebounce;

  /**
   * Check if the given variable is a function
   * @method
   * @memberof Popper.Utils
   * @argument {Any} functionToCheck - variable to check
   * @returns {Boolean} answer to: is a function?
   */
  function isFunction(functionToCheck) {
    var getType = {};
    return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
  }

  /**
   * Get CSS computed property of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Eement} element
   * @argument {String} property
   */
  function getStyleComputedProperty(element, property) {
    if (element.nodeType !== 1) {
      return [];
    }
    // NOTE: 1 DOM access here
    var window = element.ownerDocument.defaultView;
    var css = window.getComputedStyle(element, null);
    return property ? css[property] : css;
  }

  /**
   * Returns the parentNode or the host of the element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} parent
   */
  function getParentNode(element) {
    if (element.nodeName === 'HTML') {
      return element;
    }
    return element.parentNode || element.host;
  }

  /**
   * Returns the scrolling parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} scroll parent
   */
  function getScrollParent(element) {
    // Return body, `getScroll` will take care to get the correct `scrollTop` from it
    if (!element) {
      return document.body;
    }

    switch (element.nodeName) {
      case 'HTML':
      case 'BODY':
        return element.ownerDocument.body;
      case '#document':
        return element.body;
    }

    // Firefox want us to check `-x` and `-y` variations as well

    var _getStyleComputedProp = getStyleComputedProperty(element),
        overflow = _getStyleComputedProp.overflow,
        overflowX = _getStyleComputedProp.overflowX,
        overflowY = _getStyleComputedProp.overflowY;

    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
      return element;
    }

    return getScrollParent(getParentNode(element));
  }

  /**
   * Returns the reference node of the reference object, or the reference object itself.
   * @method
   * @memberof Popper.Utils
   * @param {Element|Object} reference - the reference element (the popper will be relative to this)
   * @returns {Element} parent
   */
  function getReferenceNode(reference) {
    return reference && reference.referenceNode ? reference.referenceNode : reference;
  }

  var isIE11 = isBrowser$1 && !!(window.MSInputMethodContext && document.documentMode);
  var isIE10 = isBrowser$1 && /MSIE 10/.test(navigator.userAgent);

  /**
   * Determines if the browser is Internet Explorer
   * @method
   * @memberof Popper.Utils
   * @param {Number} version to check
   * @returns {Boolean} isIE
   */
  function isIE(version) {
    if (version === 11) {
      return isIE11;
    }
    if (version === 10) {
      return isIE10;
    }
    return isIE11 || isIE10;
  }

  /**
   * Returns the offset parent of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} offset parent
   */
  function getOffsetParent(element) {
    if (!element) {
      return document.documentElement;
    }

    var noOffsetParent = isIE(10) ? document.body : null;

    // NOTE: 1 DOM access here
    var offsetParent = element.offsetParent || null;
    // Skip hidden elements which don't have an offsetParent
    while (offsetParent === noOffsetParent && element.nextElementSibling) {
      offsetParent = (element = element.nextElementSibling).offsetParent;
    }

    var nodeName = offsetParent && offsetParent.nodeName;

    if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
      return element ? element.ownerDocument.documentElement : document.documentElement;
    }

    // .offsetParent will return the closest TH, TD or TABLE in case
    // no offsetParent is present, I hate this job...
    if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
      return getOffsetParent(offsetParent);
    }

    return offsetParent;
  }

  function isOffsetContainer(element) {
    var nodeName = element.nodeName;

    if (nodeName === 'BODY') {
      return false;
    }
    return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
  }

  /**
   * Finds the root node (document, shadowDOM root) of the given element
   * @method
   * @memberof Popper.Utils
   * @argument {Element} node
   * @returns {Element} root node
   */
  function getRoot(node) {
    if (node.parentNode !== null) {
      return getRoot(node.parentNode);
    }

    return node;
  }

  /**
   * Finds the offset parent common to the two provided nodes
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element1
   * @argument {Element} element2
   * @returns {Element} common offset parent
   */
  function findCommonOffsetParent(element1, element2) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
      return document.documentElement;
    }

    // Here we make sure to give as "start" the element that comes first in the DOM
    var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
    var start = order ? element1 : element2;
    var end = order ? element2 : element1;

    // Get common ancestor container
    var range = document.createRange();
    range.setStart(start, 0);
    range.setEnd(end, 0);
    var commonAncestorContainer = range.commonAncestorContainer;

    // Both nodes are inside #document

    if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
      if (isOffsetContainer(commonAncestorContainer)) {
        return commonAncestorContainer;
      }

      return getOffsetParent(commonAncestorContainer);
    }

    // one of the nodes is inside shadowDOM, find which one
    var element1root = getRoot(element1);
    if (element1root.host) {
      return findCommonOffsetParent(element1root.host, element2);
    } else {
      return findCommonOffsetParent(element1, getRoot(element2).host);
    }
  }

  /**
   * Gets the scroll value of the given element in the given side (top and left)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {String} side `top` or `left`
   * @returns {number} amount of scrolled pixels
   */
  function getScroll(element) {
    var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';

    var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
    var nodeName = element.nodeName;

    if (nodeName === 'BODY' || nodeName === 'HTML') {
      var html = element.ownerDocument.documentElement;
      var scrollingElement = element.ownerDocument.scrollingElement || html;
      return scrollingElement[upperSide];
    }

    return element[upperSide];
  }

  /*
   * Sum or subtract the element scroll values (left and top) from a given rect object
   * @method
   * @memberof Popper.Utils
   * @param {Object} rect - Rect object you want to change
   * @param {HTMLElement} element - The element from the function reads the scroll values
   * @param {Boolean} subtract - set to true if you want to subtract the scroll values
   * @return {Object} rect - The modifier rect object
   */
  function includeScroll(rect, element) {
    var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var scrollTop = getScroll(element, 'top');
    var scrollLeft = getScroll(element, 'left');
    var modifier = subtract ? -1 : 1;
    rect.top += scrollTop * modifier;
    rect.bottom += scrollTop * modifier;
    rect.left += scrollLeft * modifier;
    rect.right += scrollLeft * modifier;
    return rect;
  }

  /*
   * Helper to detect borders of a given element
   * @method
   * @memberof Popper.Utils
   * @param {CSSStyleDeclaration} styles
   * Result of `getStyleComputedProperty` on the given element
   * @param {String} axis - `x` or `y`
   * @return {number} borders - The borders size of the given axis
   */

  function getBordersSize(styles, axis) {
    var sideA = axis === 'x' ? 'Left' : 'Top';
    var sideB = sideA === 'Left' ? 'Right' : 'Bottom';

    return parseFloat(styles['border' + sideA + 'Width'], 10) + parseFloat(styles['border' + sideB + 'Width'], 10);
  }

  function getSize(axis, body, html, computedStyle) {
    return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
  }

  function getWindowSizes(document) {
    var body = document.body;
    var html = document.documentElement;
    var computedStyle = isIE(10) && getComputedStyle(html);

    return {
      height: getSize('Height', body, html, computedStyle),
      width: getSize('Width', body, html, computedStyle)
    };
  }

  var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();





  var defineProperty = function (obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  };

  var _extends$m = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  /**
   * Given element offsets, generate an output similar to getBoundingClientRect
   * @method
   * @memberof Popper.Utils
   * @argument {Object} offsets
   * @returns {Object} ClientRect like output
   */
  function getClientRect(offsets) {
    return _extends$m({}, offsets, {
      right: offsets.left + offsets.width,
      bottom: offsets.top + offsets.height
    });
  }

  /**
   * Get bounding client rect of given element
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} element
   * @return {Object} client rect
   */
  function getBoundingClientRect(element) {
    var rect = {};

    // IE10 10 FIX: Please, don't ask, the element isn't
    // considered in DOM in some circumstances...
    // This isn't reproducible in IE10 compatibility mode of IE11
    try {
      if (isIE(10)) {
        rect = element.getBoundingClientRect();
        var scrollTop = getScroll(element, 'top');
        var scrollLeft = getScroll(element, 'left');
        rect.top += scrollTop;
        rect.left += scrollLeft;
        rect.bottom += scrollTop;
        rect.right += scrollLeft;
      } else {
        rect = element.getBoundingClientRect();
      }
    } catch (e) {}

    var result = {
      left: rect.left,
      top: rect.top,
      width: rect.right - rect.left,
      height: rect.bottom - rect.top
    };

    // subtract scrollbar size from sizes
    var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
    var width = sizes.width || element.clientWidth || result.width;
    var height = sizes.height || element.clientHeight || result.height;

    var horizScrollbar = element.offsetWidth - width;
    var vertScrollbar = element.offsetHeight - height;

    // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
    // we make this check conditional for performance reasons
    if (horizScrollbar || vertScrollbar) {
      var styles = getStyleComputedProperty(element);
      horizScrollbar -= getBordersSize(styles, 'x');
      vertScrollbar -= getBordersSize(styles, 'y');

      result.width -= horizScrollbar;
      result.height -= vertScrollbar;
    }

    return getClientRect(result);
  }

  function getOffsetRectRelativeToArbitraryNode(children, parent) {
    var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var isIE10 = isIE(10);
    var isHTML = parent.nodeName === 'HTML';
    var childrenRect = getBoundingClientRect(children);
    var parentRect = getBoundingClientRect(parent);
    var scrollParent = getScrollParent(children);

    var styles = getStyleComputedProperty(parent);
    var borderTopWidth = parseFloat(styles.borderTopWidth, 10);
    var borderLeftWidth = parseFloat(styles.borderLeftWidth, 10);

    // In cases where the parent is fixed, we must ignore negative scroll in offset calc
    if (fixedPosition && isHTML) {
      parentRect.top = Math.max(parentRect.top, 0);
      parentRect.left = Math.max(parentRect.left, 0);
    }
    var offsets = getClientRect({
      top: childrenRect.top - parentRect.top - borderTopWidth,
      left: childrenRect.left - parentRect.left - borderLeftWidth,
      width: childrenRect.width,
      height: childrenRect.height
    });
    offsets.marginTop = 0;
    offsets.marginLeft = 0;

    // Subtract margins of documentElement in case it's being used as parent
    // we do this only on HTML because it's the only element that behaves
    // differently when margins are applied to it. The margins are included in
    // the box of the documentElement, in the other cases not.
    if (!isIE10 && isHTML) {
      var marginTop = parseFloat(styles.marginTop, 10);
      var marginLeft = parseFloat(styles.marginLeft, 10);

      offsets.top -= borderTopWidth - marginTop;
      offsets.bottom -= borderTopWidth - marginTop;
      offsets.left -= borderLeftWidth - marginLeft;
      offsets.right -= borderLeftWidth - marginLeft;

      // Attach marginTop and marginLeft because in some circumstances we may need them
      offsets.marginTop = marginTop;
      offsets.marginLeft = marginLeft;
    }

    if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
      offsets = includeScroll(offsets, parent);
    }

    return offsets;
  }

  function getViewportOffsetRectRelativeToArtbitraryNode(element) {
    var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var html = element.ownerDocument.documentElement;
    var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
    var width = Math.max(html.clientWidth, window.innerWidth || 0);
    var height = Math.max(html.clientHeight, window.innerHeight || 0);

    var scrollTop = !excludeScroll ? getScroll(html) : 0;
    var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;

    var offset = {
      top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
      left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
      width: width,
      height: height
    };

    return getClientRect(offset);
  }

  /**
   * Check if the given element is fixed or is inside a fixed parent
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @argument {Element} customContainer
   * @returns {Boolean} answer to "isFixed?"
   */
  function isFixed(element) {
    var nodeName = element.nodeName;
    if (nodeName === 'BODY' || nodeName === 'HTML') {
      return false;
    }
    if (getStyleComputedProperty(element, 'position') === 'fixed') {
      return true;
    }
    var parentNode = getParentNode(element);
    if (!parentNode) {
      return false;
    }
    return isFixed(parentNode);
  }

  /**
   * Finds the first parent of an element that has a transformed property defined
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Element} first transformed parent or documentElement
   */

  function getFixedPositionOffsetParent(element) {
    // This check is needed to avoid errors in case one of the elements isn't defined for any reason
    if (!element || !element.parentElement || isIE()) {
      return document.documentElement;
    }
    var el = element.parentElement;
    while (el && getStyleComputedProperty(el, 'transform') === 'none') {
      el = el.parentElement;
    }
    return el || document.documentElement;
  }

  /**
   * Computed the boundaries limits and return them
   * @method
   * @memberof Popper.Utils
   * @param {HTMLElement} popper
   * @param {HTMLElement} reference
   * @param {number} padding
   * @param {HTMLElement} boundariesElement - Element used to define the boundaries
   * @param {Boolean} fixedPosition - Is in fixed position mode
   * @returns {Object} Coordinates of the boundaries
   */
  function getBoundaries(popper, reference, padding, boundariesElement) {
    var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;

    // NOTE: 1 DOM access here

    var boundaries = { top: 0, left: 0 };
    var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));

    // Handle viewport case
    if (boundariesElement === 'viewport') {
      boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
    } else {
      // Handle other cases based on DOM element used as boundaries
      var boundariesNode = void 0;
      if (boundariesElement === 'scrollParent') {
        boundariesNode = getScrollParent(getParentNode(reference));
        if (boundariesNode.nodeName === 'BODY') {
          boundariesNode = popper.ownerDocument.documentElement;
        }
      } else if (boundariesElement === 'window') {
        boundariesNode = popper.ownerDocument.documentElement;
      } else {
        boundariesNode = boundariesElement;
      }

      var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition);

      // In case of HTML, we need a different computation
      if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
        var _getWindowSizes = getWindowSizes(popper.ownerDocument),
            height = _getWindowSizes.height,
            width = _getWindowSizes.width;

        boundaries.top += offsets.top - offsets.marginTop;
        boundaries.bottom = height + offsets.top;
        boundaries.left += offsets.left - offsets.marginLeft;
        boundaries.right = width + offsets.left;
      } else {
        // for all the other DOM elements, this one is good
        boundaries = offsets;
      }
    }

    // Add paddings
    padding = padding || 0;
    var isPaddingNumber = typeof padding === 'number';
    boundaries.left += isPaddingNumber ? padding : padding.left || 0;
    boundaries.top += isPaddingNumber ? padding : padding.top || 0;
    boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
    boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;

    return boundaries;
  }

  function getArea(_ref) {
    var width = _ref.width,
        height = _ref.height;

    return width * height;
  }

  /**
   * Utility used to transform the `auto` placement to the placement with more
   * available space.
   * @method
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
    var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

    if (placement.indexOf('auto') === -1) {
      return placement;
    }

    var boundaries = getBoundaries(popper, reference, padding, boundariesElement);

    var rects = {
      top: {
        width: boundaries.width,
        height: refRect.top - boundaries.top
      },
      right: {
        width: boundaries.right - refRect.right,
        height: boundaries.height
      },
      bottom: {
        width: boundaries.width,
        height: boundaries.bottom - refRect.bottom
      },
      left: {
        width: refRect.left - boundaries.left,
        height: boundaries.height
      }
    };

    var sortedAreas = Object.keys(rects).map(function (key) {
      return _extends$m({
        key: key
      }, rects[key], {
        area: getArea(rects[key])
      });
    }).sort(function (a, b) {
      return b.area - a.area;
    });

    var filteredAreas = sortedAreas.filter(function (_ref2) {
      var width = _ref2.width,
          height = _ref2.height;
      return width >= popper.clientWidth && height >= popper.clientHeight;
    });

    var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;

    var variation = placement.split('-')[1];

    return computedPlacement + (variation ? '-' + variation : '');
  }

  /**
   * Get offsets to the reference element
   * @method
   * @memberof Popper.Utils
   * @param {Object} state
   * @param {Element} popper - the popper element
   * @param {Element} reference - the reference element (the popper will be relative to this)
   * @param {Element} fixedPosition - is in fixed position mode
   * @returns {Object} An object containing the offsets which will be applied to the popper
   */
  function getReferenceOffsets(state, popper, reference) {
    var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, getReferenceNode(reference));
    return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
  }

  /**
   * Get the outer sizes of the given element (offset size + margins)
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element
   * @returns {Object} object containing width and height properties
   */
  function getOuterSizes(element) {
    var window = element.ownerDocument.defaultView;
    var styles = window.getComputedStyle(element);
    var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
    var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
    var result = {
      width: element.offsetWidth + y,
      height: element.offsetHeight + x
    };
    return result;
  }

  /**
   * Get the opposite placement of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement
   * @returns {String} flipped placement
   */
  function getOppositePlacement(placement) {
    var hash = { left: 'right', right: 'left', bottom: 'top', top: 'bottom' };
    return placement.replace(/left|right|bottom|top/g, function (matched) {
      return hash[matched];
    });
  }

  /**
   * Get offsets to the popper
   * @method
   * @memberof Popper.Utils
   * @param {Object} position - CSS position the Popper will get applied
   * @param {HTMLElement} popper - the popper element
   * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
   * @param {String} placement - one of the valid placement options
   * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
   */
  function getPopperOffsets(popper, referenceOffsets, placement) {
    placement = placement.split('-')[0];

    // Get popper node sizes
    var popperRect = getOuterSizes(popper);

    // Add position, width and height to our offsets object
    var popperOffsets = {
      width: popperRect.width,
      height: popperRect.height
    };

    // depending by the popper placement we have to compute its offsets slightly differently
    var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
    var mainSide = isHoriz ? 'top' : 'left';
    var secondarySide = isHoriz ? 'left' : 'top';
    var measurement = isHoriz ? 'height' : 'width';
    var secondaryMeasurement = !isHoriz ? 'height' : 'width';

    popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;
    if (placement === secondarySide) {
      popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
    } else {
      popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
    }

    return popperOffsets;
  }

  /**
   * Mimics the `find` method of Array
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function find$1(arr, check) {
    // use native find if supported
    if (Array.prototype.find) {
      return arr.find(check);
    }

    // use `filter` to obtain the same behavior of `find`
    return arr.filter(check)[0];
  }

  /**
   * Return the index of the matching object
   * @method
   * @memberof Popper.Utils
   * @argument {Array} arr
   * @argument prop
   * @argument value
   * @returns index or -1
   */
  function findIndex(arr, prop, value) {
    // use native findIndex if supported
    if (Array.prototype.findIndex) {
      return arr.findIndex(function (cur) {
        return cur[prop] === value;
      });
    }

    // use `find` + `indexOf` if `findIndex` isn't supported
    var match = find$1(arr, function (obj) {
      return obj[prop] === value;
    });
    return arr.indexOf(match);
  }

  /**
   * Loop trough the list of modifiers and run them in order,
   * each of them will then edit the data object.
   * @method
   * @memberof Popper.Utils
   * @param {dataObject} data
   * @param {Array} modifiers
   * @param {String} ends - Optional modifier name used as stopper
   * @returns {dataObject}
   */
  function runModifiers(modifiers, data, ends) {
    var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex(modifiers, 'name', ends));

    modifiersToRun.forEach(function (modifier) {
      if (modifier['function']) {
        // eslint-disable-line dot-notation
        console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
      }
      var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation
      if (modifier.enabled && isFunction(fn)) {
        // Add properties to offsets to make them a complete clientRect object
        // we do this before each modifier to make sure the previous one doesn't
        // mess with these values
        data.offsets.popper = getClientRect(data.offsets.popper);
        data.offsets.reference = getClientRect(data.offsets.reference);

        data = fn(data, modifier);
      }
    });

    return data;
  }

  /**
   * Updates the position of the popper, computing the new offsets and applying
   * the new style.<br />
   * Prefer `scheduleUpdate` over `update` because of performance reasons.
   * @method
   * @memberof Popper
   */
  function update() {
    // if popper is destroyed, don't perform any further update
    if (this.state.isDestroyed) {
      return;
    }

    var data = {
      instance: this,
      styles: {},
      arrowStyles: {},
      attributes: {},
      flipped: false,
      offsets: {}
    };

    // compute reference element offsets
    data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding);

    // store the computed placement inside `originalPlacement`
    data.originalPlacement = data.placement;

    data.positionFixed = this.options.positionFixed;

    // compute the popper offsets
    data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);

    data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute';

    // run the modifiers
    data = runModifiers(this.modifiers, data);

    // the first `update` will call `onCreate` callback
    // the other ones will call `onUpdate` callback
    if (!this.state.isCreated) {
      this.state.isCreated = true;
      this.options.onCreate(data);
    } else {
      this.options.onUpdate(data);
    }
  }

  /**
   * Helper used to know if the given modifier is enabled.
   * @method
   * @memberof Popper.Utils
   * @returns {Boolean}
   */
  function isModifierEnabled(modifiers, modifierName) {
    return modifiers.some(function (_ref) {
      var name = _ref.name,
          enabled = _ref.enabled;
      return enabled && name === modifierName;
    });
  }

  /**
   * Get the prefixed supported property name
   * @method
   * @memberof Popper.Utils
   * @argument {String} property (camelCase)
   * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
   */
  function getSupportedPropertyName(property) {
    var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
    var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

    for (var i = 0; i < prefixes.length; i++) {
      var prefix = prefixes[i];
      var toCheck = prefix ? '' + prefix + upperProp : property;
      if (typeof document.body.style[toCheck] !== 'undefined') {
        return toCheck;
      }
    }
    return null;
  }

  /**
   * Destroys the popper.
   * @method
   * @memberof Popper
   */
  function destroy() {
    this.state.isDestroyed = true;

    // touch DOM only if `applyStyle` modifier is enabled
    if (isModifierEnabled(this.modifiers, 'applyStyle')) {
      this.popper.removeAttribute('x-placement');
      this.popper.style.position = '';
      this.popper.style.top = '';
      this.popper.style.left = '';
      this.popper.style.right = '';
      this.popper.style.bottom = '';
      this.popper.style.willChange = '';
      this.popper.style[getSupportedPropertyName('transform')] = '';
    }

    this.disableEventListeners();

    // remove the popper if user explicitly asked for the deletion on destroy
    // do not use `remove` because IE11 doesn't support it
    if (this.options.removeOnDestroy) {
      this.popper.parentNode.removeChild(this.popper);
    }
    return this;
  }

  /**
   * Get the window associated with the element
   * @argument {Element} element
   * @returns {Window}
   */
  function getWindow(element) {
    var ownerDocument = element.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView : window;
  }

  function attachToScrollParents(scrollParent, event, callback, scrollParents) {
    var isBody = scrollParent.nodeName === 'BODY';
    var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
    target.addEventListener(event, callback, { passive: true });

    if (!isBody) {
      attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
    }
    scrollParents.push(target);
  }

  /**
   * Setup needed event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function setupEventListeners(reference, options, state, updateBound) {
    // Resize event listener on window
    state.updateBound = updateBound;
    getWindow(reference).addEventListener('resize', state.updateBound, { passive: true });

    // Scroll event listener on scroll parents
    var scrollElement = getScrollParent(reference);
    attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
    state.scrollElement = scrollElement;
    state.eventsEnabled = true;

    return state;
  }

  /**
   * It will add resize/scroll events and start recalculating
   * position of the popper element when they are triggered.
   * @method
   * @memberof Popper
   */
  function enableEventListeners() {
    if (!this.state.eventsEnabled) {
      this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
    }
  }

  /**
   * Remove event listeners used to update the popper position
   * @method
   * @memberof Popper.Utils
   * @private
   */
  function removeEventListeners(reference, state) {
    // Remove resize event listener on window
    getWindow(reference).removeEventListener('resize', state.updateBound);

    // Remove scroll event listener on scroll parents
    state.scrollParents.forEach(function (target) {
      target.removeEventListener('scroll', state.updateBound);
    });

    // Reset state
    state.updateBound = null;
    state.scrollParents = [];
    state.scrollElement = null;
    state.eventsEnabled = false;
    return state;
  }

  /**
   * It will remove resize/scroll events and won't recalculate popper position
   * when they are triggered. It also won't trigger `onUpdate` callback anymore,
   * unless you call `update` method manually.
   * @method
   * @memberof Popper
   */
  function disableEventListeners() {
    if (this.state.eventsEnabled) {
      cancelAnimationFrame(this.scheduleUpdate);
      this.state = removeEventListeners(this.reference, this.state);
    }
  }

  /**
   * Tells if a given input is a number
   * @method
   * @memberof Popper.Utils
   * @param {*} input to check
   * @return {Boolean}
   */
  function isNumeric(n) {
    return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
  }

  /**
   * Set the style to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the style to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setStyles(element, styles) {
    Object.keys(styles).forEach(function (prop) {
      var unit = '';
      // add unit if the value is numeric and is one of the following
      if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
        unit = 'px';
      }
      element.style[prop] = styles[prop] + unit;
    });
  }

  /**
   * Set the attributes to the given popper
   * @method
   * @memberof Popper.Utils
   * @argument {Element} element - Element to apply the attributes to
   * @argument {Object} styles
   * Object with a list of properties and values which will be applied to the element
   */
  function setAttributes(element, attributes) {
    Object.keys(attributes).forEach(function (prop) {
      var value = attributes[prop];
      if (value !== false) {
        element.setAttribute(prop, attributes[prop]);
      } else {
        element.removeAttribute(prop);
      }
    });
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} data.styles - List of style properties - values to apply to popper element
   * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The same data object
   */
  function applyStyle(data) {
    // any property present in `data.styles` will be applied to the popper,
    // in this way we can make the 3rd party modifiers add custom styles to it
    // Be aware, modifiers could override the properties defined in the previous
    // lines of this modifier!
    setStyles(data.instance.popper, data.styles);

    // any property present in `data.attributes` will be applied to the popper,
    // they will be set as HTML attributes of the element
    setAttributes(data.instance.popper, data.attributes);

    // if arrowElement is defined and arrowStyles has some properties
    if (data.arrowElement && Object.keys(data.arrowStyles).length) {
      setStyles(data.arrowElement, data.arrowStyles);
    }

    return data;
  }

  /**
   * Set the x-placement attribute before everything else because it could be used
   * to add margins to the popper margins needs to be calculated to get the
   * correct popper offsets.
   * @method
   * @memberof Popper.modifiers
   * @param {HTMLElement} reference - The reference element used to position the popper
   * @param {HTMLElement} popper - The HTML element used as popper
   * @param {Object} options - Popper.js options
   */
  function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
    // compute reference element offsets
    var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed);

    // compute auto placement, store placement inside the data object,
    // modifiers will be able to edit `placement` if needed
    // and refer to originalPlacement to know the original value
    var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);

    popper.setAttribute('x-placement', placement);

    // Apply `position` to popper before anything else because
    // without the position applied we can't guarantee correct computations
    setStyles(popper, { position: options.positionFixed ? 'fixed' : 'absolute' });

    return options;
  }

  /**
   * @function
   * @memberof Popper.Utils
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Boolean} shouldRound - If the offsets should be rounded at all
   * @returns {Object} The popper's position offsets rounded
   *
   * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
   * good as it can be within reason.
   * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
   *
   * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
   * as well on High DPI screens).
   *
   * Firefox prefers no rounding for positioning and does not have blurriness on
   * high DPI screens.
   *
   * Only horizontal placement and left/right values need to be considered.
   */
  function getRoundedOffsets(data, shouldRound) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var round = Math.round,
        floor = Math.floor;

    var noRound = function noRound(v) {
      return v;
    };

    var referenceWidth = round(reference.width);
    var popperWidth = round(popper.width);

    var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
    var isVariation = data.placement.indexOf('-') !== -1;
    var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
    var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;

    var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
    var verticalToInteger = !shouldRound ? noRound : round;

    return {
      left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
      top: verticalToInteger(popper.top),
      bottom: verticalToInteger(popper.bottom),
      right: horizontalToInteger(popper.right)
    };
  }

  var isFirefox = isBrowser$1 && /Firefox/i.test(navigator.userAgent);

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function computeStyle(data, options) {
    var x = options.x,
        y = options.y;
    var popper = data.offsets.popper;

    // Remove this legacy support in Popper.js v2

    var legacyGpuAccelerationOption = find$1(data.instance.modifiers, function (modifier) {
      return modifier.name === 'applyStyle';
    }).gpuAcceleration;
    if (legacyGpuAccelerationOption !== undefined) {
      console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
    }
    var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;

    var offsetParent = getOffsetParent(data.instance.popper);
    var offsetParentRect = getBoundingClientRect(offsetParent);

    // Styles
    var styles = {
      position: popper.position
    };

    var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);

    var sideA = x === 'bottom' ? 'top' : 'bottom';
    var sideB = y === 'right' ? 'left' : 'right';

    // if gpuAcceleration is set to `true` and transform is supported,
    //  we use `translate3d` to apply the position to the popper we
    // automatically use the supported prefixed version if needed
    var prefixedProperty = getSupportedPropertyName('transform');

    // now, let's make a step back and look at this code closely (wtf?)
    // If the content of the popper grows once it's been positioned, it
    // may happen that the popper gets misplaced because of the new content
    // overflowing its reference element
    // To avoid this problem, we provide two options (x and y), which allow
    // the consumer to define the offset origin.
    // If we position a popper on top of a reference element, we can set
    // `x` to `top` to make the popper grow towards its top instead of
    // its bottom.
    var left = void 0,
        top = void 0;
    if (sideA === 'bottom') {
      // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
      // and not the bottom of the html element
      if (offsetParent.nodeName === 'HTML') {
        top = -offsetParent.clientHeight + offsets.bottom;
      } else {
        top = -offsetParentRect.height + offsets.bottom;
      }
    } else {
      top = offsets.top;
    }
    if (sideB === 'right') {
      if (offsetParent.nodeName === 'HTML') {
        left = -offsetParent.clientWidth + offsets.right;
      } else {
        left = -offsetParentRect.width + offsets.right;
      }
    } else {
      left = offsets.left;
    }
    if (gpuAcceleration && prefixedProperty) {
      styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
      styles[sideA] = 0;
      styles[sideB] = 0;
      styles.willChange = 'transform';
    } else {
      // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
      var invertTop = sideA === 'bottom' ? -1 : 1;
      var invertLeft = sideB === 'right' ? -1 : 1;
      styles[sideA] = top * invertTop;
      styles[sideB] = left * invertLeft;
      styles.willChange = sideA + ', ' + sideB;
    }

    // Attributes
    var attributes = {
      'x-placement': data.placement
    };

    // Update `data` attributes, styles and arrowStyles
    data.attributes = _extends$m({}, attributes, data.attributes);
    data.styles = _extends$m({}, styles, data.styles);
    data.arrowStyles = _extends$m({}, data.offsets.arrow, data.arrowStyles);

    return data;
  }

  /**
   * Helper used to know if the given modifier depends from another one.<br />
   * It checks if the needed modifier is listed and enabled.
   * @method
   * @memberof Popper.Utils
   * @param {Array} modifiers - list of modifiers
   * @param {String} requestingName - name of requesting modifier
   * @param {String} requestedName - name of requested modifier
   * @returns {Boolean}
   */
  function isModifierRequired(modifiers, requestingName, requestedName) {
    var requesting = find$1(modifiers, function (_ref) {
      var name = _ref.name;
      return name === requestingName;
    });

    var isRequired = !!requesting && modifiers.some(function (modifier) {
      return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
    });

    if (!isRequired) {
      var _requesting = '`' + requestingName + '`';
      var requested = '`' + requestedName + '`';
      console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
    }
    return isRequired;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function arrow(data, options) {
    var _data$offsets$arrow;

    // arrow depends on keepTogether in order to work
    if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
      return data;
    }

    var arrowElement = options.element;

    // if arrowElement is a string, suppose it's a CSS selector
    if (typeof arrowElement === 'string') {
      arrowElement = data.instance.popper.querySelector(arrowElement);

      // if arrowElement is not found, don't run the modifier
      if (!arrowElement) {
        return data;
      }
    } else {
      // if the arrowElement isn't a query selector we must check that the
      // provided DOM node is child of its popper node
      if (!data.instance.popper.contains(arrowElement)) {
        console.warn('WARNING: `arrow.element` must be child of its popper element!');
        return data;
      }
    }

    var placement = data.placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var isVertical = ['left', 'right'].indexOf(placement) !== -1;

    var len = isVertical ? 'height' : 'width';
    var sideCapitalized = isVertical ? 'Top' : 'Left';
    var side = sideCapitalized.toLowerCase();
    var altSide = isVertical ? 'left' : 'top';
    var opSide = isVertical ? 'bottom' : 'right';
    var arrowElementSize = getOuterSizes(arrowElement)[len];

    //
    // extends keepTogether behavior making sure the popper and its
    // reference have enough pixels in conjunction
    //

    // top/left side
    if (reference[opSide] - arrowElementSize < popper[side]) {
      data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
    }
    // bottom/right side
    if (reference[side] + arrowElementSize > popper[opSide]) {
      data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
    }
    data.offsets.popper = getClientRect(data.offsets.popper);

    // compute center of the popper
    var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;

    // Compute the sideValue using the updated popper offsets
    // take popper margin in account because we don't have this info available
    var css = getStyleComputedProperty(data.instance.popper);
    var popperMarginSide = parseFloat(css['margin' + sideCapitalized], 10);
    var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width'], 10);
    var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide;

    // prevent arrowElement from being placed not contiguously to its popper
    sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);

    data.arrowElement = arrowElement;
    data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);

    return data;
  }

  /**
   * Get the opposite placement variation of the given one
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement variation
   * @returns {String} flipped placement variation
   */
  function getOppositeVariation(variation) {
    if (variation === 'end') {
      return 'start';
    } else if (variation === 'start') {
      return 'end';
    }
    return variation;
  }

  /**
   * List of accepted placements to use as values of the `placement` option.<br />
   * Valid placements are:
   * - `auto`
   * - `top`
   * - `right`
   * - `bottom`
   * - `left`
   *
   * Each placement can have a variation from this list:
   * - `-start`
   * - `-end`
   *
   * Variations are interpreted easily if you think of them as the left to right
   * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
   * is right.<br />
   * Vertically (`left` and `right`), `start` is top and `end` is bottom.
   *
   * Some valid examples are:
   * - `top-end` (on top of reference, right aligned)
   * - `right-start` (on right of reference, top aligned)
   * - `bottom` (on bottom, centered)
   * - `auto-end` (on the side with more space available, alignment depends by placement)
   *
   * @static
   * @type {Array}
   * @enum {String}
   * @readonly
   * @method placements
   * @memberof Popper
   */
  var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start'];

  // Get rid of `auto` `auto-start` and `auto-end`
  var validPlacements = placements.slice(3);

  /**
   * Given an initial placement, returns all the subsequent placements
   * clockwise (or counter-clockwise).
   *
   * @method
   * @memberof Popper.Utils
   * @argument {String} placement - A valid placement (it accepts variations)
   * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
   * @returns {Array} placements including their variations
   */
  function clockwise(placement) {
    var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    var index = validPlacements.indexOf(placement);
    var arr = validPlacements.slice(index + 1).concat(validPlacements.slice(0, index));
    return counter ? arr.reverse() : arr;
  }

  var BEHAVIORS = {
    FLIP: 'flip',
    CLOCKWISE: 'clockwise',
    COUNTERCLOCKWISE: 'counterclockwise'
  };

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function flip(data, options) {
    // if `inner` modifier is enabled, we can't use the `flip` modifier
    if (isModifierEnabled(data.instance.modifiers, 'inner')) {
      return data;
    }

    if (data.flipped && data.placement === data.originalPlacement) {
      // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
      return data;
    }

    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);

    var placement = data.placement.split('-')[0];
    var placementOpposite = getOppositePlacement(placement);
    var variation = data.placement.split('-')[1] || '';

    var flipOrder = [];

    switch (options.behavior) {
      case BEHAVIORS.FLIP:
        flipOrder = [placement, placementOpposite];
        break;
      case BEHAVIORS.CLOCKWISE:
        flipOrder = clockwise(placement);
        break;
      case BEHAVIORS.COUNTERCLOCKWISE:
        flipOrder = clockwise(placement, true);
        break;
      default:
        flipOrder = options.behavior;
    }

    flipOrder.forEach(function (step, index) {
      if (placement !== step || flipOrder.length === index + 1) {
        return data;
      }

      placement = data.placement.split('-')[0];
      placementOpposite = getOppositePlacement(placement);

      var popperOffsets = data.offsets.popper;
      var refOffsets = data.offsets.reference;

      // using floor because the reference offsets may contain decimals we are not going to consider here
      var floor = Math.floor;
      var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);

      var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
      var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
      var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
      var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);

      var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom;

      // flip the variation if required
      var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;

      // flips variation if reference element overflows boundaries
      var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom);

      // flips variation if popper content overflows boundaries
      var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === 'start' && overflowsRight || isVertical && variation === 'end' && overflowsLeft || !isVertical && variation === 'start' && overflowsBottom || !isVertical && variation === 'end' && overflowsTop);

      var flippedVariation = flippedVariationByRef || flippedVariationByContent;

      if (overlapsRef || overflowsBoundaries || flippedVariation) {
        // this boolean to detect any flip loop
        data.flipped = true;

        if (overlapsRef || overflowsBoundaries) {
          placement = flipOrder[index + 1];
        }

        if (flippedVariation) {
          variation = getOppositeVariation(variation);
        }

        data.placement = placement + (variation ? '-' + variation : '');

        // this object contains `position`, we want to preserve it along with
        // any additional property we may add in the future
        data.offsets.popper = _extends$m({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));

        data = runModifiers(data.instance.modifiers, data, 'flip');
      }
    });
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function keepTogether(data) {
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var placement = data.placement.split('-')[0];
    var floor = Math.floor;
    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
    var side = isVertical ? 'right' : 'bottom';
    var opSide = isVertical ? 'left' : 'top';
    var measurement = isVertical ? 'width' : 'height';

    if (popper[side] < floor(reference[opSide])) {
      data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
    }
    if (popper[opSide] > floor(reference[side])) {
      data.offsets.popper[opSide] = floor(reference[side]);
    }

    return data;
  }

  /**
   * Converts a string containing value + unit into a px value number
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} str - Value + unit string
   * @argument {String} measurement - `height` or `width`
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @returns {Number|String}
   * Value in pixels, or original string if no values were extracted
   */
  function toValue(str, measurement, popperOffsets, referenceOffsets) {
    // separate value from unit
    var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
    var value = +split[1];
    var unit = split[2];

    // If it's not a number it's an operator, I guess
    if (!value) {
      return str;
    }

    if (unit.indexOf('%') === 0) {
      var element = void 0;
      switch (unit) {
        case '%p':
          element = popperOffsets;
          break;
        case '%':
        case '%r':
        default:
          element = referenceOffsets;
      }

      var rect = getClientRect(element);
      return rect[measurement] / 100 * value;
    } else if (unit === 'vh' || unit === 'vw') {
      // if is a vh or vw, we calculate the size based on the viewport
      var size = void 0;
      if (unit === 'vh') {
        size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
      } else {
        size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
      }
      return size / 100 * value;
    } else {
      // if is an explicit pixel unit, we get rid of the unit and keep the value
      // if is an implicit unit, it's px, and we return just the value
      return value;
    }
  }

  /**
   * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
   * @function
   * @memberof {modifiers~offset}
   * @private
   * @argument {String} offset
   * @argument {Object} popperOffsets
   * @argument {Object} referenceOffsets
   * @argument {String} basePlacement
   * @returns {Array} a two cells array with x and y offsets in numbers
   */
  function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
    var offsets = [0, 0];

    // Use height if placement is left or right and index is 0 otherwise use width
    // in this way the first offset will use an axis and the second one
    // will use the other one
    var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1;

    // Split the offset string to obtain a list of values and operands
    // The regex addresses values with the plus or minus sign in front (+10, -20, etc)
    var fragments = offset.split(/(\+|\-)/).map(function (frag) {
      return frag.trim();
    });

    // Detect if the offset string contains a pair of values or a single one
    // they could be separated by comma or space
    var divider = fragments.indexOf(find$1(fragments, function (frag) {
      return frag.search(/,|\s/) !== -1;
    }));

    if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
      console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
    }

    // If divider is found, we divide the list of values and operands to divide
    // them by ofset X and Y.
    var splitRegex = /\s*,\s*|\s+/;
    var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments];

    // Convert the values with units to absolute pixels to allow our computations
    ops = ops.map(function (op, index) {
      // Most of the units rely on the orientation of the popper
      var measurement = (index === 1 ? !useHeight : useHeight) ? 'height' : 'width';
      var mergeWithPrevious = false;
      return op
      // This aggregates any `+` or `-` sign that aren't considered operators
      // e.g.: 10 + +5 => [10, +, +5]
      .reduce(function (a, b) {
        if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
          a[a.length - 1] = b;
          mergeWithPrevious = true;
          return a;
        } else if (mergeWithPrevious) {
          a[a.length - 1] += b;
          mergeWithPrevious = false;
          return a;
        } else {
          return a.concat(b);
        }
      }, [])
      // Here we convert the string values into number values (in px)
      .map(function (str) {
        return toValue(str, measurement, popperOffsets, referenceOffsets);
      });
    });

    // Loop trough the offsets arrays and execute the operations
    ops.forEach(function (op, index) {
      op.forEach(function (frag, index2) {
        if (isNumeric(frag)) {
          offsets[index] += frag * (op[index2 - 1] === '-' ? -1 : 1);
        }
      });
    });
    return offsets;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @argument {Number|String} options.offset=0
   * The offset value as described in the modifier description
   * @returns {Object} The data object, properly modified
   */
  function offset(data, _ref) {
    var offset = _ref.offset;
    var placement = data.placement,
        _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var basePlacement = placement.split('-')[0];

    var offsets = void 0;
    if (isNumeric(+offset)) {
      offsets = [+offset, 0];
    } else {
      offsets = parseOffset(offset, popper, reference, basePlacement);
    }

    if (basePlacement === 'left') {
      popper.top += offsets[0];
      popper.left -= offsets[1];
    } else if (basePlacement === 'right') {
      popper.top += offsets[0];
      popper.left += offsets[1];
    } else if (basePlacement === 'top') {
      popper.left += offsets[0];
      popper.top -= offsets[1];
    } else if (basePlacement === 'bottom') {
      popper.left += offsets[0];
      popper.top += offsets[1];
    }

    data.popper = popper;
    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function preventOverflow(data, options) {
    var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper);

    // If offsetParent is the reference element, we really want to
    // go one step up and use the next offsetParent as reference to
    // avoid to make this modifier completely useless and look like broken
    if (data.instance.reference === boundariesElement) {
      boundariesElement = getOffsetParent(boundariesElement);
    }

    // NOTE: DOM access here
    // resets the popper's position so that the document size can be calculated excluding
    // the size of the popper element itself
    var transformProp = getSupportedPropertyName('transform');
    var popperStyles = data.instance.popper.style; // assignment to help minification
    var top = popperStyles.top,
        left = popperStyles.left,
        transform = popperStyles[transformProp];

    popperStyles.top = '';
    popperStyles.left = '';
    popperStyles[transformProp] = '';

    var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed);

    // NOTE: DOM access here
    // restores the original style properties after the offsets have been computed
    popperStyles.top = top;
    popperStyles.left = left;
    popperStyles[transformProp] = transform;

    options.boundaries = boundaries;

    var order = options.priority;
    var popper = data.offsets.popper;

    var check = {
      primary: function primary(placement) {
        var value = popper[placement];
        if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
          value = Math.max(popper[placement], boundaries[placement]);
        }
        return defineProperty({}, placement, value);
      },
      secondary: function secondary(placement) {
        var mainSide = placement === 'right' ? 'left' : 'top';
        var value = popper[mainSide];
        if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
          value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
        }
        return defineProperty({}, mainSide, value);
      }
    };

    order.forEach(function (placement) {
      var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
      popper = _extends$m({}, popper, check[side](placement));
    });

    data.offsets.popper = popper;

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function shift(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var shiftvariation = placement.split('-')[1];

    // if shift shiftvariation is specified, run the modifier
    if (shiftvariation) {
      var _data$offsets = data.offsets,
          reference = _data$offsets.reference,
          popper = _data$offsets.popper;

      var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
      var side = isVertical ? 'left' : 'top';
      var measurement = isVertical ? 'width' : 'height';

      var shiftOffsets = {
        start: defineProperty({}, side, reference[side]),
        end: defineProperty({}, side, reference[side] + reference[measurement] - popper[measurement])
      };

      data.offsets.popper = _extends$m({}, popper, shiftOffsets[shiftvariation]);
    }

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by update method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function hide(data) {
    if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
      return data;
    }

    var refRect = data.offsets.reference;
    var bound = find$1(data.instance.modifiers, function (modifier) {
      return modifier.name === 'preventOverflow';
    }).boundaries;

    if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === true) {
        return data;
      }

      data.hide = true;
      data.attributes['x-out-of-boundaries'] = '';
    } else {
      // Avoid unnecessary DOM access if visibility hasn't changed
      if (data.hide === false) {
        return data;
      }

      data.hide = false;
      data.attributes['x-out-of-boundaries'] = false;
    }

    return data;
  }

  /**
   * @function
   * @memberof Modifiers
   * @argument {Object} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {Object} The data object, properly modified
   */
  function inner(data) {
    var placement = data.placement;
    var basePlacement = placement.split('-')[0];
    var _data$offsets = data.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;

    var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;

    var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;

    popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);

    data.placement = getOppositePlacement(placement);
    data.offsets.popper = getClientRect(popper);

    return data;
  }

  /**
   * Modifier function, each modifier can have a function of this type assigned
   * to its `fn` property.<br />
   * These functions will be called on each update, this means that you must
   * make sure they are performant enough to avoid performance bottlenecks.
   *
   * @function ModifierFn
   * @argument {dataObject} data - The data object generated by `update` method
   * @argument {Object} options - Modifiers configuration and options
   * @returns {dataObject} The data object, properly modified
   */

  /**
   * Modifiers are plugins used to alter the behavior of your poppers.<br />
   * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
   * needed by the library.
   *
   * Usually you don't want to override the `order`, `fn` and `onLoad` props.
   * All the other properties are configurations that could be tweaked.
   * @namespace modifiers
   */
  var modifiers = {
    /**
     * Modifier used to shift the popper on the start or end of its reference
     * element.<br />
     * It will read the variation of the `placement` property.<br />
     * It can be one either `-end` or `-start`.
     * @memberof modifiers
     * @inner
     */
    shift: {
      /** @prop {number} order=100 - Index used to define the order of execution */
      order: 100,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: shift
    },

    /**
     * The `offset` modifier can shift your popper on both its axis.
     *
     * It accepts the following units:
     * - `px` or unit-less, interpreted as pixels
     * - `%` or `%r`, percentage relative to the length of the reference element
     * - `%p`, percentage relative to the length of the popper element
     * - `vw`, CSS viewport width unit
     * - `vh`, CSS viewport height unit
     *
     * For length is intended the main axis relative to the placement of the popper.<br />
     * This means that if the placement is `top` or `bottom`, the length will be the
     * `width`. In case of `left` or `right`, it will be the `height`.
     *
     * You can provide a single value (as `Number` or `String`), or a pair of values
     * as `String` divided by a comma or one (or more) white spaces.<br />
     * The latter is a deprecated method because it leads to confusion and will be
     * removed in v2.<br />
     * Additionally, it accepts additions and subtractions between different units.
     * Note that multiplications and divisions aren't supported.
     *
     * Valid examples are:
     * ```
     * 10
     * '10%'
     * '10, 10'
     * '10%, 10'
     * '10 + 10%'
     * '10 - 5vh + 3%'
     * '-10px + 5vh, 5px - 6%'
     * ```
     * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
     * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
     * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
     *
     * @memberof modifiers
     * @inner
     */
    offset: {
      /** @prop {number} order=200 - Index used to define the order of execution */
      order: 200,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: offset,
      /** @prop {Number|String} offset=0
       * The offset value as described in the modifier description
       */
      offset: 0
    },

    /**
     * Modifier used to prevent the popper from being positioned outside the boundary.
     *
     * A scenario exists where the reference itself is not within the boundaries.<br />
     * We can say it has "escaped the boundaries" — or just "escaped".<br />
     * In this case we need to decide whether the popper should either:
     *
     * - detach from the reference and remain "trapped" in the boundaries, or
     * - if it should ignore the boundary and "escape with its reference"
     *
     * When `escapeWithReference` is set to`true` and reference is completely
     * outside its boundaries, the popper will overflow (or completely leave)
     * the boundaries in order to remain attached to the edge of the reference.
     *
     * @memberof modifiers
     * @inner
     */
    preventOverflow: {
      /** @prop {number} order=300 - Index used to define the order of execution */
      order: 300,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: preventOverflow,
      /**
       * @prop {Array} [priority=['left','right','top','bottom']]
       * Popper will try to prevent overflow following these priorities by default,
       * then, it could overflow on the left and on top of the `boundariesElement`
       */
      priority: ['left', 'right', 'top', 'bottom'],
      /**
       * @prop {number} padding=5
       * Amount of pixel used to define a minimum distance between the boundaries
       * and the popper. This makes sure the popper always has a little padding
       * between the edges of its container
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='scrollParent'
       * Boundaries used by the modifier. Can be `scrollParent`, `window`,
       * `viewport` or any DOM element.
       */
      boundariesElement: 'scrollParent'
    },

    /**
     * Modifier used to make sure the reference and its popper stay near each other
     * without leaving any gap between the two. Especially useful when the arrow is
     * enabled and you want to ensure that it points to its reference element.
     * It cares only about the first axis. You can still have poppers with margin
     * between the popper and its reference element.
     * @memberof modifiers
     * @inner
     */
    keepTogether: {
      /** @prop {number} order=400 - Index used to define the order of execution */
      order: 400,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: keepTogether
    },

    /**
     * This modifier is used to move the `arrowElement` of the popper to make
     * sure it is positioned between the reference element and its popper element.
     * It will read the outer size of the `arrowElement` node to detect how many
     * pixels of conjunction are needed.
     *
     * It has no effect if no `arrowElement` is provided.
     * @memberof modifiers
     * @inner
     */
    arrow: {
      /** @prop {number} order=500 - Index used to define the order of execution */
      order: 500,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: arrow,
      /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
      element: '[x-arrow]'
    },

    /**
     * Modifier used to flip the popper's placement when it starts to overlap its
     * reference element.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     *
     * **NOTE:** this modifier will interrupt the current update cycle and will
     * restart it if it detects the need to flip the placement.
     * @memberof modifiers
     * @inner
     */
    flip: {
      /** @prop {number} order=600 - Index used to define the order of execution */
      order: 600,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: flip,
      /**
       * @prop {String|Array} behavior='flip'
       * The behavior used to change the popper's placement. It can be one of
       * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
       * placements (with optional variations)
       */
      behavior: 'flip',
      /**
       * @prop {number} padding=5
       * The popper will flip if it hits the edges of the `boundariesElement`
       */
      padding: 5,
      /**
       * @prop {String|HTMLElement} boundariesElement='viewport'
       * The element which will define the boundaries of the popper position.
       * The popper will never be placed outside of the defined boundaries
       * (except if `keepTogether` is enabled)
       */
      boundariesElement: 'viewport',
      /**
       * @prop {Boolean} flipVariations=false
       * The popper will switch placement variation between `-start` and `-end` when
       * the reference element overlaps its boundaries.
       *
       * The original placement should have a set variation.
       */
      flipVariations: false,
      /**
       * @prop {Boolean} flipVariationsByContent=false
       * The popper will switch placement variation between `-start` and `-end` when
       * the popper element overlaps its reference boundaries.
       *
       * The original placement should have a set variation.
       */
      flipVariationsByContent: false
    },

    /**
     * Modifier used to make the popper flow toward the inner of the reference element.
     * By default, when this modifier is disabled, the popper will be placed outside
     * the reference element.
     * @memberof modifiers
     * @inner
     */
    inner: {
      /** @prop {number} order=700 - Index used to define the order of execution */
      order: 700,
      /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
      enabled: false,
      /** @prop {ModifierFn} */
      fn: inner
    },

    /**
     * Modifier used to hide the popper when its reference element is outside of the
     * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
     * be used to hide with a CSS selector the popper when its reference is
     * out of boundaries.
     *
     * Requires the `preventOverflow` modifier before it in order to work.
     * @memberof modifiers
     * @inner
     */
    hide: {
      /** @prop {number} order=800 - Index used to define the order of execution */
      order: 800,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: hide
    },

    /**
     * Computes the style that will be applied to the popper element to gets
     * properly positioned.
     *
     * Note that this modifier will not touch the DOM, it just prepares the styles
     * so that `applyStyle` modifier can apply it. This separation is useful
     * in case you need to replace `applyStyle` with a custom implementation.
     *
     * This modifier has `850` as `order` value to maintain backward compatibility
     * with previous versions of Popper.js. Expect the modifiers ordering method
     * to change in future major versions of the library.
     *
     * @memberof modifiers
     * @inner
     */
    computeStyle: {
      /** @prop {number} order=850 - Index used to define the order of execution */
      order: 850,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: computeStyle,
      /**
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: true,
      /**
       * @prop {string} [x='bottom']
       * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
       * Change this if your popper should grow in a direction different from `bottom`
       */
      x: 'bottom',
      /**
       * @prop {string} [x='left']
       * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
       * Change this if your popper should grow in a direction different from `right`
       */
      y: 'right'
    },

    /**
     * Applies the computed styles to the popper element.
     *
     * All the DOM manipulations are limited to this modifier. This is useful in case
     * you want to integrate Popper.js inside a framework or view library and you
     * want to delegate all the DOM manipulations to it.
     *
     * Note that if you disable this modifier, you must make sure the popper element
     * has its position set to `absolute` before Popper.js can do its work!
     *
     * Just disable this modifier and define your own to achieve the desired effect.
     *
     * @memberof modifiers
     * @inner
     */
    applyStyle: {
      /** @prop {number} order=900 - Index used to define the order of execution */
      order: 900,
      /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
      enabled: true,
      /** @prop {ModifierFn} */
      fn: applyStyle,
      /** @prop {Function} */
      onLoad: applyStyleOnLoad,
      /**
       * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
       * @prop {Boolean} gpuAcceleration=true
       * If true, it uses the CSS 3D transformation to position the popper.
       * Otherwise, it will use the `top` and `left` properties
       */
      gpuAcceleration: undefined
    }
  };

  /**
   * The `dataObject` is an object containing all the information used by Popper.js.
   * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
   * @name dataObject
   * @property {Object} data.instance The Popper.js instance
   * @property {String} data.placement Placement applied to popper
   * @property {String} data.originalPlacement Placement originally defined on init
   * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
   * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
   * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
   * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
   * @property {Object} data.boundaries Offsets of the popper boundaries
   * @property {Object} data.offsets The measurements of popper, reference and arrow elements
   * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
   * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
   */

  /**
   * Default options provided to Popper.js constructor.<br />
   * These can be overridden using the `options` argument of Popper.js.<br />
   * To override an option, simply pass an object with the same
   * structure of the `options` object, as the 3rd argument. For example:
   * ```
   * new Popper(ref, pop, {
   *   modifiers: {
   *     preventOverflow: { enabled: false }
   *   }
   * })
   * ```
   * @type {Object}
   * @static
   * @memberof Popper
   */
  var Defaults = {
    /**
     * Popper's placement.
     * @prop {Popper.placements} placement='bottom'
     */
    placement: 'bottom',

    /**
     * Set this to true if you want popper to position it self in 'fixed' mode
     * @prop {Boolean} positionFixed=false
     */
    positionFixed: false,

    /**
     * Whether events (resize, scroll) are initially enabled.
     * @prop {Boolean} eventsEnabled=true
     */
    eventsEnabled: true,

    /**
     * Set to true if you want to automatically remove the popper when
     * you call the `destroy` method.
     * @prop {Boolean} removeOnDestroy=false
     */
    removeOnDestroy: false,

    /**
     * Callback called when the popper is created.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onCreate}
     */
    onCreate: function onCreate() {},

    /**
     * Callback called when the popper is updated. This callback is not called
     * on the initialization/creation of the popper, but only on subsequent
     * updates.<br />
     * By default, it is set to no-op.<br />
     * Access Popper.js instance with `data.instance`.
     * @prop {onUpdate}
     */
    onUpdate: function onUpdate() {},

    /**
     * List of modifiers used to modify the offsets before they are applied to the popper.
     * They provide most of the functionalities of Popper.js.
     * @prop {modifiers}
     */
    modifiers: modifiers
  };

  /**
   * @callback onCreate
   * @param {dataObject} data
   */

  /**
   * @callback onUpdate
   * @param {dataObject} data
   */

  // Utils
  // Methods
  var Popper = function () {
    /**
     * Creates a new Popper.js instance.
     * @class Popper
     * @param {Element|referenceObject} reference - The reference element used to position the popper
     * @param {Element} popper - The HTML / XML element used as the popper
     * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
     * @return {Object} instance - The generated Popper.js instance
     */
    function Popper(reference, popper) {
      var _this = this;

      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      classCallCheck(this, Popper);

      this.scheduleUpdate = function () {
        return requestAnimationFrame(_this.update);
      };

      // make update() debounced, so that it only runs at most once-per-tick
      this.update = debounce$1(this.update.bind(this));

      // with {} we create a new object with the options inside it
      this.options = _extends$m({}, Popper.Defaults, options);

      // init state
      this.state = {
        isDestroyed: false,
        isCreated: false,
        scrollParents: []
      };

      // get reference and popper elements (allow jQuery wrappers)
      this.reference = reference && reference.jquery ? reference[0] : reference;
      this.popper = popper && popper.jquery ? popper[0] : popper;

      // Deep merge modifiers options
      this.options.modifiers = {};
      Object.keys(_extends$m({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
        _this.options.modifiers[name] = _extends$m({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
      });

      // Refactoring modifiers' list (Object => Array)
      this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
        return _extends$m({
          name: name
        }, _this.options.modifiers[name]);
      })
      // sort the modifiers by order
      .sort(function (a, b) {
        return a.order - b.order;
      });

      // modifiers have the ability to execute arbitrary code when Popper.js get inited
      // such code is executed in the same order of its modifier
      // they could add new properties to their options configuration
      // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!
      this.modifiers.forEach(function (modifierOptions) {
        if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
          modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
        }
      });

      // fire the first update to position the popper in the right place
      this.update();

      var eventsEnabled = this.options.eventsEnabled;
      if (eventsEnabled) {
        // setup event listeners, they will take care of update the position in specific situations
        this.enableEventListeners();
      }

      this.state.eventsEnabled = eventsEnabled;
    }

    // We can't use class properties because they don't get listed in the
    // class prototype and break stuff like Sinon stubs


    createClass(Popper, [{
      key: 'update',
      value: function update$$1() {
        return update.call(this);
      }
    }, {
      key: 'destroy',
      value: function destroy$$1() {
        return destroy.call(this);
      }
    }, {
      key: 'enableEventListeners',
      value: function enableEventListeners$$1() {
        return enableEventListeners.call(this);
      }
    }, {
      key: 'disableEventListeners',
      value: function disableEventListeners$$1() {
        return disableEventListeners.call(this);
      }

      /**
       * Schedules an update. It will run on the next UI update available.
       * @method scheduleUpdate
       * @memberof Popper
       */


      /**
       * Collection of utilities useful when writing custom modifiers.
       * Starting from version 1.7, this method is available only if you
       * include `popper-utils.js` before `popper.js`.
       *
       * **DEPRECATION**: This way to access PopperUtils is deprecated
       * and will be removed in v2! Use the PopperUtils module directly instead.
       * Due to the high instability of the methods contained in Utils, we can't
       * guarantee them to follow semver. Use them at your own risk!
       * @static
       * @private
       * @type {Object}
       * @deprecated since version 1.8
       * @member Utils
       * @memberof Popper
       */

    }]);
    return Popper;
  }();

  /**
   * The `referenceObject` is an object that provides an interface compatible with Popper.js
   * and lets you use it as replacement of a real DOM node.<br />
   * You can use this method to position a popper relatively to a set of coordinates
   * in case you don't have a DOM node to use as reference.
   *
   * ```
   * new Popper(referenceObject, popperNode);
   * ```
   *
   * NB: This feature isn't supported in Internet Explorer 10.
   * @name referenceObject
   * @property {Function} data.getBoundingClientRect
   * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
   * @property {number} data.clientWidth
   * An ES6 getter that will return the width of the virtual reference element.
   * @property {number} data.clientHeight
   * An ES6 getter that will return the height of the virtual reference element.
   */


  Popper.Utils = (typeof window !== 'undefined' ? window : global).PopperUtils;
  Popper.placements = placements;
  Popper.Defaults = Defaults;

  /**!
  * tippy.js v5.1.2
  * (c) 2017-2019 atomiks
  * MIT License
  */

  function _extends$n() {
    _extends$n = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends$n.apply(this, arguments);
  }

  var version = "5.1.2";

  /**
   * Triggers reflow
   */
  function reflow(element) {
    void element.offsetHeight;
  }
  /**
   * Sets the innerHTML of an element
   */

  function setInnerHTML(element, html) {
    element[innerHTML()] = html;
  }
  /**
   * Determines if the value is a reference element
   */

  function isReferenceElement(value) {
    return !!(value && value._tippy && value._tippy.reference === value);
  }
  /**
   * Safe .hasOwnProperty check, for prototype-less objects
   */

  function hasOwnProperty$1(obj, key) {
    return {}.hasOwnProperty.call(obj, key);
  }
  /**
   * Returns an array of elements based on the value
   */

  function getArrayOfElements(value) {
    if (isElement(value)) {
      return [value];
    }

    if (isNodeList(value)) {
      return arrayFrom(value);
    }

    if (Array.isArray(value)) {
      return value;
    }

    return arrayFrom(document.querySelectorAll(value));
  }
  /**
   * Returns a value at a given index depending on if it's an array or number
   */

  function getValueAtIndexOrReturn(value, index, defaultValue) {
    if (Array.isArray(value)) {
      var v = value[index];
      return v == null ? Array.isArray(defaultValue) ? defaultValue[index] : defaultValue : v;
    }

    return value;
  }
  /**
   * Prevents errors from being thrown while accessing nested modifier objects
   * in `popperOptions`
   */

  function getModifier$1(obj, key) {
    return obj && obj.modifiers && obj.modifiers[key];
  }
  /**
   * Determines if the value is of type
   */

  function isType(value, type) {
    var str = {}.toString.call(value);
    return str.indexOf('[object') === 0 && str.indexOf(type + "]") > -1;
  }
  /**
   * Determines if the value is of type Element
   */

  function isElement(value) {
    return isType(value, 'Element');
  }
  /**
   * Determines if the value is of type NodeList
   */

  function isNodeList(value) {
    return isType(value, 'NodeList');
  }
  /**
   * Determines if the value is of type MouseEvent
   */

  function isMouseEvent(value) {
    return isType(value, 'MouseEvent');
  }
  /**
   * Firefox extensions don't allow setting .innerHTML directly, this will trick
   * it
   */

  function innerHTML() {
    return 'innerHTML';
  }
  /**
   * Evaluates a function if one, or returns the value
   */

  function invokeWithArgsOrReturn(value, args) {
    return typeof value === 'function' ? value.apply(void 0, args) : value;
  }
  /**
   * Sets a popperInstance modifier's property to a value
   */

  function setModifierValue(modifiers, name, property, value) {
    modifiers.filter(function (m) {
      return m.name === name;
    })[0][property] = value;
  }
  /**
   * Returns a new `div` element
   */

  function div() {
    return document.createElement('div');
  }
  /**
   * Applies a transition duration to a list of elements
   */

  function setTransitionDuration(els, value) {
    els.forEach(function (el) {
      if (el) {
        el.style.transitionDuration = value + "ms";
      }
    });
  }
  /**
   * Sets the visibility state to elements so they can begin to transition
   */

  function setVisibilityState(els, state) {
    els.forEach(function (el) {
      if (el) {
        el.setAttribute('data-state', state);
      }
    });
  }
  /**
   * Debounce utility. To avoid bloating bundle size, we're only passing 1
   * argument here, a more generic function would pass all arguments. Only
   * `onMouseMove` uses this which takes the event object for now.
   */

  function debounce$2(fn, ms) {
    // Avoid wrapping in `setTimeout` if ms is 0 anyway
    if (ms === 0) {
      return fn;
    }

    var timeout;
    return function (arg) {
      clearTimeout(timeout);
      timeout = setTimeout(function () {
        fn(arg);
      }, ms);
    };
  }
  /**
   * Preserves the original function invocation when another function replaces it
   */

  function preserveInvocation(originalFn, currentFn, args) {
    if (originalFn && originalFn !== currentFn) {
      originalFn.apply(void 0, args);
    }
  }
  /**
   * Deletes properties from an object (pure)
   */

  function removeProperties(obj, keys) {
    var clone = _extends$n({}, obj);

    keys.forEach(function (key) {
      delete clone[key];
    });
    return clone;
  }
  /**
   * Ponyfill for Array.from - converts iterable values to an array
   */

  function arrayFrom(value) {
    return [].slice.call(value);
  }
  /**
   * Works like Element.prototype.closest, but uses a callback instead
   */

  function closestCallback(element, callback) {
    while (element) {
      if (callback(element)) {
        return element;
      }

      element = element.parentElement;
    }

    return null;
  }
  /**
   * Determines if an array or string includes a string
   */

  function includes(a, b) {
    return a.indexOf(b) > -1;
  }
  /**
   * Creates an array from string of values separated by whitespace
   */

  function splitBySpaces(value) {
    return value.split(/\s+/).filter(Boolean);
  }
  /**
   * Returns the `nextValue` if `nextValue` is not `undefined`, otherwise returns
   * `currentValue`
   */

  function useIfDefined(nextValue, currentValue) {
    return nextValue !== undefined ? nextValue : currentValue;
  }
  /**
   * Converts a value that's an array or single value to an array
   */

  function normalizeToArray(value) {
    return [].concat(value);
  }
  /**
   * Returns the ownerDocument of the first available element, otherwise global
   * document
   */

  function getOwnerDocument(elementOrElements) {
    var _normalizeToArray = normalizeToArray(elementOrElements),
        element = _normalizeToArray[0];

    return element ? element.ownerDocument || document : document;
  }
  /**
   * Adds item to array if array does not contain it
   */

  function pushIfUnique(arr, value) {
    if (arr.indexOf(value) === -1) {
      arr.push(value);
    }
  }
  /**
   * Adds `px` if value is a number, or returns it directly
   */

  function appendPxIfNumber(value) {
    return typeof value === 'number' ? value + "px" : value;
  }
  /**
   * Filters out duplicate elements in an array
   */

  function unique(arr) {
    return arr.filter(function (item, index) {
      return arr.indexOf(item) === index;
    });
  }
  /**
   * Returns number from number or CSS units string
   */

  function getNumber(value) {
    return typeof value === 'number' ? value : parseFloat(value);
  }
  /**
   * Gets number or CSS string units in pixels (e.g. `1rem` -> 16)
   */

  function getUnitsInPx(doc, value) {
    var isRem = typeof value === 'string' && includes(value, 'rem');
    var html = doc.documentElement;
    var rootFontSize = 16;

    if (html && isRem) {
      return parseFloat(getComputedStyle(html).fontSize || String(rootFontSize)) * getNumber(value);
    }

    return getNumber(value);
  }
  /**
   * Adds the `distancePx` value to the placement of a Popper.Padding object
   */

  function getComputedPadding(basePlacement, padding, distancePx) {
    if (padding === void 0) {
      padding = 5;
    }

    var freshPaddingObject = {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    };
    var keys = Object.keys(freshPaddingObject);
    return keys.reduce(function (obj, key) {
      obj[key] = typeof padding === 'number' ? padding : padding[key];

      if (basePlacement === key) {
        obj[key] = typeof padding === 'number' ? padding + distancePx : padding[basePlacement] + distancePx;
      }

      return obj;
    }, freshPaddingObject);
  }

  function createMemoryLeakWarning(method) {
    var txt = method === 'destroy' ? 'n already-' : ' ';
    return "\n    " + method + "() was called on a" + txt + "destroyed instance. This is a no-op but\n    indicates a potential memory leak.\n  ";
  }
  function clean(value) {
    var spacesAndTabs = /[ \t]{2,}/g;
    var lineStartWithSpaces = /^[ \t]*/gm;
    return value.replace(spacesAndTabs, ' ').replace(lineStartWithSpaces, '').trim();
  }

  function getDevMessage(message) {
    return clean("\n  %ctippy.js\n\n  %c" + clean(message) + "\n\n  %c\uD83D\uDC77\u200D This is a development-only message. It will be removed in production.\n  ");
  }

  function getFormattedMessage(message) {
    return [getDevMessage(message), // title
    'color: #00C584; font-size: 1.3em; font-weight: bold;', // message
    'line-height: 1.5', // footer
    'color: #a6a095;'];
  }
  /**
   * Helpful wrapper around `console.warn()`.
   * TODO: Should we use a cache so it only warns a single time and not spam the
   * console? (Need to consider hot reloading and invalidation though). Chrome
   * already batches warnings as well.
   */

  function warnWhen(condition, message) {
    if (condition) {
      var _console;

      (_console = console).warn.apply(_console, getFormattedMessage(message));
    }
  }
  /**
   * Helpful wrapper around thrown errors
   */

  function throwErrorWhen(condition, message) {
    if (condition) {
      throw new Error(clean(message));
    }
  }
  /**
   * Validates the `targets` value passed to `tippy()`
   */

  function validateTargets(targets) {
    var didPassFalsyValue = !targets;
    var didPassPlainObject = Object.prototype.toString.call(targets) === '[object Object]' && !targets.addEventListener;
    throwErrorWhen(didPassFalsyValue, "tippy() was passed `" + targets + "` as its targets (first) argument.\n\n    Valid types are: String, Element, Element[], or NodeList.");
    throwErrorWhen(didPassPlainObject, "tippy() was passed a plain object which is no longer supported as an\n    argument.\n    \n    See https://atomiks.github.io/tippyjs/misc/#custom-position");
  }

  var defaultProps = {
    allowHTML: true,
    animateFill: false,
    animation: 'fade',
    appendTo: function appendTo() {
      return document.body;
    },
    aria: 'describedby',
    arrow: true,
    boundary: 'scrollParent',
    content: '',
    delay: 0,
    distance: 10,
    duration: [300, 250],
    flip: true,
    flipBehavior: 'flip',
    flipOnUpdate: false,
    followCursor: false,
    hideOnClick: true,
    ignoreAttributes: false,
    inlinePositioning: false,
    inertia: false,
    interactive: false,
    interactiveBorder: 2,
    interactiveDebounce: 0,
    lazy: true,
    maxWidth: 350,
    multiple: false,
    offset: 0,
    onAfterUpdate: function onAfterUpdate() {},
    onBeforeUpdate: function onBeforeUpdate() {},
    onCreate: function onCreate() {},
    onDestroy: function onDestroy() {},
    onHidden: function onHidden() {},
    onHide: function onHide() {},
    onMount: function onMount() {},
    onShow: function onShow() {},
    onShown: function onShown() {},
    onTrigger: function onTrigger() {},
    onUntrigger: function onUntrigger() {},
    placement: 'top',
    plugins: [],
    popperOptions: {},
    role: 'tooltip',
    showOnCreate: false,
    sticky: false,
    theme: '',
    touch: true,
    trigger: 'mouseenter focus',
    triggerTarget: null,
    updateDuration: 0,
    zIndex: 9999
  };
  var defaultKeys = Object.keys(defaultProps);
  /**
   * If the setProps() method encounters one of these, the popperInstance must be
   * recreated
   */

  var POPPER_INSTANCE_DEPENDENCIES = ['arrow', 'boundary', 'distance', 'flip', 'flipBehavior', 'flipOnUpdate', 'offset', 'placement', 'popperOptions'];
  /**
   * Mutates the defaultProps object by setting the props specified
   */

  var setDefaultProps = function setDefaultProps(partialProps) {
    {
      validateProps(partialProps, []);
    }

    var keys = Object.keys(partialProps);
    keys.forEach(function (key) {
      defaultProps[key] = partialProps[key];
    });
  };
  /**
   * Returns an extended props object including plugin props
   */

  function getExtendedProps(props) {
    return _extends$n({}, props, {}, props.plugins.reduce(function (acc, plugin) {
      var name = plugin.name,
          defaultValue = plugin.defaultValue;

      if (name) {
        acc[name] = props[name] !== undefined ? props[name] : defaultValue;
      }

      return acc;
    }, {}));
  }
  /**
   * Returns an object of optional props from data-tippy-* attributes
   */

  function getDataAttributeProps(reference, plugins) {
    var propKeys = plugins ? Object.keys(getExtendedProps(_extends$n({}, defaultProps, {
      plugins: plugins
    }))) : defaultKeys;
    var props = propKeys.reduce(function (acc, key) {
      var valueAsString = (reference.getAttribute("data-tippy-" + key) || '').trim();

      if (!valueAsString) {
        return acc;
      }

      if (key === 'content') {
        acc[key] = valueAsString;
      } else {
        try {
          acc[key] = JSON.parse(valueAsString);
        } catch (e) {
          acc[key] = valueAsString;
        }
      }

      return acc;
    }, {});
    return props;
  }
  /**
   * Evaluates the props object by merging data attributes and disabling
   * conflicting props where necessary
   */

  function evaluateProps(reference, props) {
    var out = _extends$n({}, props, {
      content: invokeWithArgsOrReturn(props.content, [reference])
    }, props.ignoreAttributes ? {} : getDataAttributeProps(reference, props.plugins));

    if (out.interactive) {
      out.aria = null;
    }

    return out;
  }
  /**
   * Validates props with the valid `defaultProps` object
   */

  function validateProps(partialProps, plugins) {
    if (partialProps === void 0) {
      partialProps = {};
    }

    if (plugins === void 0) {
      plugins = [];
    }

    var keys = Object.keys(partialProps);
    keys.forEach(function (prop) {
      var value = partialProps[prop];
      var didSpecifyPlacementInPopperOptions = prop === 'popperOptions' && value !== null && typeof value === 'object' && hasOwnProperty$1(value, 'placement');
      var nonPluginProps = removeProperties(defaultProps, ['animateFill', 'followCursor', 'inlinePositioning', 'sticky']); // These props have custom warnings

      var customWarningProps = ['a11y', 'arrowType', 'showOnInit', 'size', 'target', 'touchHold'];
      var didPassUnknownProp = !hasOwnProperty$1(nonPluginProps, prop) && !includes(customWarningProps, prop); // Check if the prop exists in `plugins`

      if (didPassUnknownProp) {
        didPassUnknownProp = plugins.filter(function (plugin) {
          return plugin.name === prop;
        }).length === 0;
      }

      warnWhen(prop === 'target', "The `target` prop was removed in v5 and replaced with the delegate()\n      addon in order to conserve bundle size.\n      \n      See: https://atomiks.github.io/tippyjs/addons/#event-delegation");
      warnWhen(prop === 'a11y', "The `a11y` prop was removed in v5. Make sure the element you are giving\n      a tippy to is natively focusable, such as <button> or <input>, not <div>\n      or <span>.");
      warnWhen(prop === 'showOnInit', "The `showOnInit` prop was renamed to `showOnCreate` in v5.");
      warnWhen(prop === 'arrowType', "The `arrowType` prop was removed in v5 in favor of overloading the\n      `arrow` prop.\n\n      \"round\" string was replaced with importing the string from the package.\n\n      * import {roundArrow} from 'tippy.js'; (ESM version)\n      * const {roundArrow} = tippy; (IIFE CDN version)\n\n      Before: {arrow: true, arrowType: \"round\"}\n      After: {arrow: roundArrow}");
      warnWhen(prop === 'touchHold', "The `touchHold` prop was removed in v5 in favor of overloading the\n      `touch` prop.\n      \n      Before: {touchHold: true}\n      After: {touch: \"hold\"}");
      warnWhen(prop === 'size', "The `size` prop was removed in v5. Instead, use a theme that specifies\n      CSS padding and font-size properties.");
      warnWhen(prop === 'theme' && value === 'google', "The included theme \"google\" was renamed to \"material\" in v5.");
      warnWhen(didSpecifyPlacementInPopperOptions, "Specifying placement in `popperOptions` is not supported. Use the\n      base-level `placement` prop instead.\n      \n      Before: {popperOptions: {placement: \"bottom\"}}\n      After: {placement: \"bottom\"}");
      warnWhen(didPassUnknownProp, "`" + prop + "` is not a valid prop. You may have spelled it incorrectly,\n      or if it's a plugin, forgot to pass it in an array as props.plugins.\n\n      In v5, the following props were turned into plugins:\n\n      * animateFill\n      * followCursor\n      * sticky\n\n      All props: https://atomiks.github.io/tippyjs/all-props/\n      Plugins: https://atomiks.github.io/tippyjs/plugins/");
    });
  }

  var PASSIVE = {
    passive: true
  };
  var IOS_CLASS = "tippy-iOS";
  var POPPER_CLASS = "tippy-popper";
  var TOOLTIP_CLASS = "tippy-tooltip";
  var CONTENT_CLASS = "tippy-content";
  var ARROW_CLASS = "tippy-arrow";
  var SVG_ARROW_CLASS = "tippy-svg-arrow";
  var POPPER_SELECTOR = "." + POPPER_CLASS;
  var TOOLTIP_SELECTOR = "." + TOOLTIP_CLASS;
  var CONTENT_SELECTOR = "." + CONTENT_CLASS;
  var ARROW_SELECTOR = "." + ARROW_CLASS;
  var SVG_ARROW_SELECTOR = "." + SVG_ARROW_CLASS;

  var currentInput = {
    isTouch: false
  };
  var lastMouseMoveTime = 0;
  /**
   * When a `touchstart` event is fired, it's assumed the user is using touch
   * input. We'll bind a `mousemove` event listener to listen for mouse input in
   * the future. This way, the `isTouch` property is fully dynamic and will handle
   * hybrid devices that use a mix of touch + mouse input.
   */

  function onDocumentTouchStart() {
    if (currentInput.isTouch) {
      return;
    }

    currentInput.isTouch = true;

    if (window.performance) {
      document.addEventListener('mousemove', onDocumentMouseMove);
    }
  }
  /**
   * When two `mousemove` event are fired consecutively within 20ms, it's assumed
   * the user is using mouse input again. `mousemove` can fire on touch devices as
   * well, but very rarely that quickly.
   */

  function onDocumentMouseMove() {
    var now = performance.now();

    if (now - lastMouseMoveTime < 20) {
      currentInput.isTouch = false;
      document.removeEventListener('mousemove', onDocumentMouseMove);
    }

    lastMouseMoveTime = now;
  }
  /**
   * When an element is in focus and has a tippy, leaving the tab/window and
   * returning causes it to show again. For mouse users this is unexpected, but
   * for keyboard use it makes sense.
   * TODO: find a better technique to solve this problem
   */

  function onWindowBlur() {
    var activeElement = document.activeElement;

    if (isReferenceElement(activeElement)) {
      var instance = activeElement._tippy;

      if (activeElement.blur && !instance.state.isVisible) {
        activeElement.blur();
      }
    }
  }
  /**
   * Adds the needed global event listeners
   */

  function bindGlobalEventListeners() {
    document.addEventListener('touchstart', onDocumentTouchStart, _extends$n({}, PASSIVE, {
      capture: true
    }));
    window.addEventListener('blur', onWindowBlur);
  }

  var isBrowser$2 = typeof window !== 'undefined' && typeof document !== 'undefined';
  var ua = isBrowser$2 ? navigator.userAgent : '';
  var isIE$1 = /MSIE |Trident\//.test(ua);
  var isUCBrowser = /UCBrowser\//.test(ua);
  var isIOS = isBrowser$2 && /iPhone|iPad|iPod/.test(navigator.platform);
  function updateIOSClass(isAdd) {
    var shouldAdd = isAdd && isIOS && currentInput.isTouch;
    document.body.classList[shouldAdd ? 'add' : 'remove'](IOS_CLASS);
  }

  /**
   * Returns the popper's placement, ignoring shifting (top-start, etc)
   */

  function getBasePlacement(placement) {
    return placement.split('-')[0];
  }
  /**
   * Adds `data-inertia` attribute
   */

  function addInertia(tooltip) {
    tooltip.setAttribute('data-inertia', '');
  }
  /**
   * Removes `data-inertia` attribute
   */

  function removeInertia(tooltip) {
    tooltip.removeAttribute('data-inertia');
  }
  /**
   * Adds interactive-related attributes
   */

  function addInteractive(tooltip) {
    tooltip.setAttribute('data-interactive', '');
  }
  /**
   * Removes interactive-related attributes
   */

  function removeInteractive(tooltip) {
    tooltip.removeAttribute('data-interactive');
  }
  /**
   * Sets the content of a tooltip
   */

  function setContent(contentEl, props) {
    if (isElement(props.content)) {
      setInnerHTML(contentEl, '');
      contentEl.appendChild(props.content);
    } else if (typeof props.content !== 'function') {
      var key = props.allowHTML ? 'innerHTML' : 'textContent';
      contentEl[key] = props.content;
    }
  }
  /**
   * Returns the child elements of a popper element
   */

  function getChildren(popper) {
    return {
      tooltip: popper.querySelector(TOOLTIP_SELECTOR),
      content: popper.querySelector(CONTENT_SELECTOR),
      arrow: popper.querySelector(ARROW_SELECTOR) || popper.querySelector(SVG_ARROW_SELECTOR)
    };
  }
  /**
   * Creates an arrow element and returns it
   */

  function createArrowElement(arrow) {
    var arrowElement = div();

    if (arrow === true) {
      arrowElement.className = ARROW_CLASS;
    } else {
      arrowElement.className = SVG_ARROW_CLASS;

      if (isElement(arrow)) {
        arrowElement.appendChild(arrow);
      } else {
        setInnerHTML(arrowElement, arrow);
      }
    }

    return arrowElement;
  }
  /**
   * Constructs the popper element and returns it
   */

  function createPopperElement(id, props) {
    var popper = div();
    popper.className = POPPER_CLASS;
    popper.style.position = 'absolute';
    popper.style.top = '0';
    popper.style.left = '0';
    var tooltip = div();
    tooltip.className = TOOLTIP_CLASS;
    tooltip.id = "tippy-" + id;
    tooltip.setAttribute('data-state', 'hidden');
    tooltip.setAttribute('tabindex', '-1');
    updateTheme(tooltip, 'add', props.theme);
    var content = div();
    content.className = CONTENT_CLASS;
    content.setAttribute('data-state', 'hidden');

    if (props.interactive) {
      addInteractive(tooltip);
    }

    if (props.arrow) {
      tooltip.setAttribute('data-arrow', '');
      tooltip.appendChild(createArrowElement(props.arrow));
    }

    if (props.inertia) {
      addInertia(tooltip);
    }

    setContent(content, props);
    tooltip.appendChild(content);
    popper.appendChild(tooltip);
    updatePopperElement(popper, props, props);
    return popper;
  }
  /**
   * Updates the popper element based on the new props
   */

  function updatePopperElement(popper, prevProps, nextProps) {
    var _getChildren = getChildren(popper),
        tooltip = _getChildren.tooltip,
        content = _getChildren.content,
        arrow = _getChildren.arrow;

    popper.style.zIndex = '' + nextProps.zIndex;
    tooltip.setAttribute('data-animation', nextProps.animation);
    tooltip.style.maxWidth = appendPxIfNumber(nextProps.maxWidth);

    if (nextProps.role) {
      tooltip.setAttribute('role', nextProps.role);
    } else {
      tooltip.removeAttribute('role');
    }

    if (prevProps.content !== nextProps.content) {
      setContent(content, nextProps);
    } // arrow


    if (!prevProps.arrow && nextProps.arrow) {
      // false to true
      tooltip.appendChild(createArrowElement(nextProps.arrow));
      tooltip.setAttribute('data-arrow', '');
    } else if (prevProps.arrow && !nextProps.arrow) {
      // true to false
      tooltip.removeChild(arrow);
      tooltip.removeAttribute('data-arrow');
    } else if (prevProps.arrow !== nextProps.arrow) {
      // true to 'round' or vice-versa
      tooltip.removeChild(arrow);
      tooltip.appendChild(createArrowElement(nextProps.arrow));
    } // interactive


    if (!prevProps.interactive && nextProps.interactive) {
      addInteractive(tooltip);
    } else if (prevProps.interactive && !nextProps.interactive) {
      removeInteractive(tooltip);
    } // inertia


    if (!prevProps.inertia && nextProps.inertia) {
      addInertia(tooltip);
    } else if (prevProps.inertia && !nextProps.inertia) {
      removeInertia(tooltip);
    } // theme


    if (prevProps.theme !== nextProps.theme) {
      updateTheme(tooltip, 'remove', prevProps.theme);
      updateTheme(tooltip, 'add', nextProps.theme);
    }
  }
  /**
   * Add/remove transitionend listener from tooltip
   */

  function updateTransitionEndListener(tooltip, action, listener) {
    var eventName = isUCBrowser && document.body.style.webkitTransition !== undefined ? 'webkitTransitionEnd' : 'transitionend';
    tooltip[action + 'EventListener'](eventName, listener);
  }
  /**
   * Adds/removes theme from tooltip's classList
   */

  function updateTheme(tooltip, action, theme) {
    splitBySpaces(theme).forEach(function (name) {
      tooltip.classList[action](name + "-theme");
    });
  }
  /**
   * Determines if the mouse cursor is outside of the popper's interactive border
   * region
   */

  function isCursorOutsideInteractiveBorder(popperTreeData, event) {
    var clientX = event.clientX,
        clientY = event.clientY;
    return popperTreeData.every(function (_ref) {
      var popperRect = _ref.popperRect,
          tooltipRect = _ref.tooltipRect,
          interactiveBorder = _ref.interactiveBorder;
      // Get min/max bounds of both the popper and tooltip rects due to
      // `distance` offset
      var mergedRect = {
        top: Math.min(popperRect.top, tooltipRect.top),
        right: Math.max(popperRect.right, tooltipRect.right),
        bottom: Math.max(popperRect.bottom, tooltipRect.bottom),
        left: Math.min(popperRect.left, tooltipRect.left)
      };
      var exceedsTop = mergedRect.top - clientY > interactiveBorder;
      var exceedsBottom = clientY - mergedRect.bottom > interactiveBorder;
      var exceedsLeft = mergedRect.left - clientX > interactiveBorder;
      var exceedsRight = clientX - mergedRect.right > interactiveBorder;
      return exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;
    });
  }

  var idCounter = 1;
  var mouseMoveListeners = [];
  /**
   * Used by `hideAll()`
   */

  var mountedInstances = [];
  /**
   * Creates and returns a Tippy object. We're using a closure pattern instead of
   * a class so that the exposed object API is clean without private members
   * prefixed with `_`.
   */

  function createTippy(reference, collectionProps) {
    var props = getExtendedProps(evaluateProps(reference, collectionProps)); // If the reference shouldn't have multiple tippys, return null early

    if (!props.multiple && reference._tippy) {
      return null;
    }
    /* ======================= 🔒 Private members 🔒 ======================= */


    var showTimeout;
    var hideTimeout;
    var scheduleHideAnimationFrame;
    var isBeingDestroyed = false;
    var didHideDueToDocumentMouseDown = false;
    var popperUpdates = 0;
    var lastTriggerEvent;
    var currentMountCallback;
    var currentTransitionEndListener;
    var listeners = [];
    var debouncedOnMouseMove = debounce$2(onMouseMove, props.interactiveDebounce);
    var currentTarget; // Support iframe contexts
    // Static check that assumes any of the `triggerTarget` or `reference`
    // nodes will never change documents, even when they are updated

    var doc = getOwnerDocument(props.triggerTarget || reference);
    /* ======================= 🔑 Public members 🔑 ======================= */

    var id = idCounter++;
    var popper = createPopperElement(id, props);
    var popperChildren = getChildren(popper);
    var popperInstance = null;
    var plugins = unique(props.plugins); // These two elements are static

    var tooltip = popperChildren.tooltip,
        content = popperChildren.content;
    var transitionableElements = [tooltip, content];
    var state = {
      // The current real placement (`data-placement` attribute)
      currentPlacement: null,
      // Is the instance currently enabled?
      isEnabled: true,
      // Is the tippy currently showing and not transitioning out?
      isVisible: false,
      // Has the instance been destroyed?
      isDestroyed: false,
      // Is the tippy currently mounted to the DOM?
      isMounted: false,
      // Has the tippy finished transitioning in?
      isShown: false
    };
    var instance = {
      // properties
      id: id,
      reference: reference,
      popper: popper,
      popperChildren: popperChildren,
      popperInstance: popperInstance,
      props: props,
      state: state,
      plugins: plugins,
      // methods
      clearDelayTimeouts: clearDelayTimeouts,
      setProps: setProps,
      setContent: setContent,
      show: show,
      hide: hide,
      enable: enable,
      disable: disable,
      destroy: destroy
    };
    /* ==================== Initial instance mutations =================== */

    reference._tippy = instance;
    popper._tippy = instance;
    var pluginsHooks = plugins.map(function (plugin) {
      return plugin.fn(instance);
    });
    addListenersToTriggerTarget();
    handleAriaExpandedAttribute();

    if (!props.lazy) {
      createPopperInstance();
    }

    invokeHook('onCreate', [instance]);

    if (props.showOnCreate) {
      scheduleShow();
    } // Prevent a tippy with a delay from hiding if the cursor left then returned
    // before it started hiding


    popper.addEventListener('mouseenter', function () {
      if (instance.props.interactive && instance.state.isVisible) {
        instance.clearDelayTimeouts();
      }
    });
    popper.addEventListener('mouseleave', function () {
      if (instance.props.interactive && includes(instance.props.trigger, 'mouseenter')) {
        doc.addEventListener('mousemove', debouncedOnMouseMove);
      }
    });
    return instance;
    /* ======================= 🔒 Private methods 🔒 ======================= */

    function getNormalizedTouchSettings() {
      var touch = instance.props.touch;
      return Array.isArray(touch) ? touch : [touch, 0];
    }

    function getIsCustomTouchBehavior() {
      return getNormalizedTouchSettings()[0] === 'hold';
    }

    function getCurrentTarget() {
      return currentTarget || reference;
    }

    function getDelay(isShow) {
      // For touch or keyboard input, force `0` delay for UX reasons
      // Also if the instance is mounted but not visible (transitioning out),
      // ignore delay
      if (instance.state.isMounted && !instance.state.isVisible || currentInput.isTouch || lastTriggerEvent && lastTriggerEvent.type === 'focus') {
        return 0;
      }

      return getValueAtIndexOrReturn(instance.props.delay, isShow ? 0 : 1, defaultProps.delay);
    }

    function invokeHook(hook, args, shouldInvokePropsHook) {
      if (shouldInvokePropsHook === void 0) {
        shouldInvokePropsHook = true;
      }

      pluginsHooks.forEach(function (pluginHooks) {
        if (hasOwnProperty$1(pluginHooks, hook)) {
          // @ts-ignore
          pluginHooks[hook].apply(pluginHooks, args);
        }
      });

      if (shouldInvokePropsHook) {
        var _instance$props;

        // @ts-ignore
        (_instance$props = instance.props)[hook].apply(_instance$props, args);
      }
    }

    function handleAriaDescribedByAttribute() {
      var aria = instance.props.aria;

      if (!aria) {
        return;
      }

      var attr = "aria-" + aria;
      var id = tooltip.id;
      var nodes = normalizeToArray(instance.props.triggerTarget || reference);
      nodes.forEach(function (node) {
        var currentValue = node.getAttribute(attr);

        if (instance.state.isVisible) {
          node.setAttribute(attr, currentValue ? currentValue + " " + id : id);
        } else {
          var nextValue = currentValue && currentValue.replace(id, '').trim();

          if (nextValue) {
            node.setAttribute(attr, nextValue);
          } else {
            node.removeAttribute(attr);
          }
        }
      });
    }

    function handleAriaExpandedAttribute() {
      var nodes = normalizeToArray(instance.props.triggerTarget || reference);
      nodes.forEach(function (node) {
        if (instance.props.interactive) {
          node.setAttribute('aria-expanded', instance.state.isVisible && node === getCurrentTarget() ? 'true' : 'false');
        } else {
          node.removeAttribute('aria-expanded');
        }
      });
    }

    function cleanupInteractiveMouseListeners() {
      doc.body.removeEventListener('mouseleave', scheduleHide);
      doc.removeEventListener('mousemove', debouncedOnMouseMove);
      mouseMoveListeners = mouseMoveListeners.filter(function (listener) {
        return listener !== debouncedOnMouseMove;
      });
    }

    function onDocumentMouseDown(event) {
      // Clicked on interactive popper
      if (instance.props.interactive && popper.contains(event.target)) {
        return;
      } // Clicked on the event listeners target


      if (getCurrentTarget().contains(event.target)) {
        if (currentInput.isTouch) {
          return;
        }

        if (instance.state.isVisible && includes(instance.props.trigger, 'click')) {
          return;
        }
      }

      if (instance.props.hideOnClick === true) {
        instance.clearDelayTimeouts();
        instance.hide(); // `mousedown` event is fired right before `focus` if pressing the
        // currentTarget. This lets a tippy with `focus` trigger know that it
        // should not show

        didHideDueToDocumentMouseDown = true;
        setTimeout(function () {
          didHideDueToDocumentMouseDown = false;
        }); // The listener gets added in `scheduleShow()`, but this may be hiding it
        // before it shows, and hide()'s early bail-out behavior can prevent it
        // from being cleaned up

        if (!instance.state.isMounted) {
          removeDocumentMouseDownListener();
        }
      }
    }

    function addDocumentMouseDownListener() {
      doc.addEventListener('mousedown', onDocumentMouseDown, true);
    }

    function removeDocumentMouseDownListener() {
      doc.removeEventListener('mousedown', onDocumentMouseDown, true);
    }

    function onTransitionedOut(duration, callback) {
      onTransitionEnd(duration, function () {
        if (!instance.state.isVisible && popper.parentNode && popper.parentNode.contains(popper)) {
          callback();
        }
      });
    }

    function onTransitionedIn(duration, callback) {
      onTransitionEnd(duration, callback);
    }

    function onTransitionEnd(duration, callback) {
      function listener(event) {
        if (event.target === tooltip) {
          updateTransitionEndListener(tooltip, 'remove', listener);
          callback();
        }
      } // Make callback synchronous if duration is 0
      // `transitionend` won't fire otherwise


      if (duration === 0) {
        return callback();
      }

      updateTransitionEndListener(tooltip, 'remove', currentTransitionEndListener);
      updateTransitionEndListener(tooltip, 'add', listener);
      currentTransitionEndListener = listener;
    }

    function on(eventType, handler, options) {
      if (options === void 0) {
        options = false;
      }

      var nodes = normalizeToArray(instance.props.triggerTarget || reference);
      nodes.forEach(function (node) {
        node.addEventListener(eventType, handler, options);
        listeners.push({
          node: node,
          eventType: eventType,
          handler: handler,
          options: options
        });
      });
    }

    function addListenersToTriggerTarget() {
      if (getIsCustomTouchBehavior()) {
        on('touchstart', onTrigger, PASSIVE);
        on('touchend', onMouseLeave, PASSIVE);
      }

      splitBySpaces(instance.props.trigger).forEach(function (eventType) {
        if (eventType === 'manual') {
          return;
        }

        on(eventType, onTrigger);

        switch (eventType) {
          case 'mouseenter':
            on('mouseleave', onMouseLeave);
            break;

          case 'focus':
            on(isIE$1 ? 'focusout' : 'blur', onBlur);
            break;
        }
      });
    }

    function removeListenersFromTriggerTarget() {
      listeners.forEach(function (_ref) {
        var node = _ref.node,
            eventType = _ref.eventType,
            handler = _ref.handler,
            options = _ref.options;
        node.removeEventListener(eventType, handler, options);
      });
      listeners = [];
    }

    function onTrigger(event) {
      if (!instance.state.isEnabled || isEventListenerStopped(event) || didHideDueToDocumentMouseDown) {
        return;
      }

      lastTriggerEvent = event;
      currentTarget = event.currentTarget;
      handleAriaExpandedAttribute();

      if (!instance.state.isVisible && isMouseEvent(event)) {
        // If scrolling, `mouseenter` events can be fired if the cursor lands
        // over a new target, but `mousemove` events don't get fired. This
        // causes interactive tooltips to get stuck open until the cursor is
        // moved
        mouseMoveListeners.forEach(function (listener) {
          return listener(event);
        });
      } // Toggle show/hide when clicking click-triggered tooltips


      if (event.type === 'click' && instance.props.hideOnClick !== false && instance.state.isVisible) {
        scheduleHide(event);
      } else {
        var _getNormalizedTouchSe = getNormalizedTouchSettings(),
            value = _getNormalizedTouchSe[0],
            duration = _getNormalizedTouchSe[1];

        if (currentInput.isTouch && value === 'hold' && duration) {
          // We can hijack the show timeout here, it will be cleared by
          // `scheduleHide()` when necessary
          showTimeout = setTimeout(function () {
            scheduleShow(event);
          }, duration);
        } else {
          scheduleShow(event);
        }
      }
    }

    function onMouseMove(event) {
      var isCursorOverReferenceOrPopper = closestCallback(event.target, function (el) {
        return el === reference || el === popper;
      });

      if (isCursorOverReferenceOrPopper) {
        return;
      }

      var popperTreeData = arrayFrom(popper.querySelectorAll(POPPER_SELECTOR)).concat(popper).map(function (popper) {
        var instance = popper._tippy;
        var tooltip = instance.popperChildren.tooltip;
        var interactiveBorder = instance.props.interactiveBorder;
        return {
          popperRect: popper.getBoundingClientRect(),
          tooltipRect: tooltip.getBoundingClientRect(),
          interactiveBorder: interactiveBorder
        };
      });

      if (isCursorOutsideInteractiveBorder(popperTreeData, event)) {
        cleanupInteractiveMouseListeners();
        scheduleHide(event);
      }
    }

    function onMouseLeave(event) {
      if (isEventListenerStopped(event)) {
        return;
      }

      if (instance.props.interactive) {
        doc.body.addEventListener('mouseleave', scheduleHide);
        doc.addEventListener('mousemove', debouncedOnMouseMove);
        pushIfUnique(mouseMoveListeners, debouncedOnMouseMove);
        return;
      }

      scheduleHide(event);
    }

    function onBlur(event) {
      if (event.target !== getCurrentTarget()) {
        return;
      } // If focus was moved to within the popper


      if (instance.props.interactive && event.relatedTarget && popper.contains(event.relatedTarget)) {
        return;
      }

      scheduleHide(event);
    }

    function isEventListenerStopped(event) {
      var supportsTouch = 'ontouchstart' in window;
      var isTouchEvent = includes(event.type, 'touch');
      var isCustomTouch = getIsCustomTouchBehavior();
      return supportsTouch && currentInput.isTouch && isCustomTouch && !isTouchEvent || currentInput.isTouch && !isCustomTouch && isTouchEvent;
    }

    function createPopperInstance() {
      var popperOptions = instance.props.popperOptions;
      var arrow = instance.popperChildren.arrow;
      var flipModifier = getModifier$1(popperOptions, 'flip');
      var preventOverflowModifier = getModifier$1(popperOptions, 'preventOverflow');
      var distancePx;

      function applyMutations(data) {
        var prevPlacement = instance.state.currentPlacement;
        instance.state.currentPlacement = data.placement;

        if (instance.props.flip && !instance.props.flipOnUpdate) {
          if (data.flipped) {
            instance.popperInstance.options.placement = data.placement;
          }

          setModifierValue(instance.popperInstance.modifiers, 'flip', 'enabled', false);
        }

        tooltip.setAttribute('data-placement', data.placement);

        if (data.attributes['x-out-of-boundaries'] !== false) {
          tooltip.setAttribute('data-out-of-boundaries', '');
        } else {
          tooltip.removeAttribute('data-out-of-boundaries');
        }

        var basePlacement = getBasePlacement(data.placement);
        var isVerticalPlacement = includes(['top', 'bottom'], basePlacement);
        var isSecondaryPlacement = includes(['bottom', 'right'], basePlacement); // Apply `distance` prop

        tooltip.style.top = '0';
        tooltip.style.left = '0';
        tooltip.style[isVerticalPlacement ? 'top' : 'left'] = (isSecondaryPlacement ? 1 : -1) * distancePx + 'px'; // Careful not to cause an infinite loop here
        // Fixes https://github.com/FezVrasta/popper.js/issues/784

        if (prevPlacement && prevPlacement !== data.placement) {
          instance.popperInstance.update();
        }
      }

      var config = _extends$n({
        eventsEnabled: false,
        placement: instance.props.placement
      }, popperOptions, {
        modifiers: _extends$n({}, popperOptions && popperOptions.modifiers, {
          // We can't use `padding` on the popper el because of these bugs when
          // flipping from a vertical to horizontal placement or vice-versa,
          // there is severe flickering.
          // https://github.com/FezVrasta/popper.js/issues/720
          // This workaround increases bundle size by 250B minzip unfortunately,
          // due to need to custom compute the distance (since Popper rect does
          // not get affected by the inner tooltip's distance offset)
          tippyDistance: {
            enabled: true,
            order: 0,
            fn: function fn(data) {
              // `html` fontSize may change while `popperInstance` is alive
              // e.g. on resize in media queries
              distancePx = getUnitsInPx(doc, instance.props.distance);
              var basePlacement = getBasePlacement(data.placement);
              var computedPreventOverflowPadding = getComputedPadding(basePlacement, preventOverflowModifier && preventOverflowModifier.padding, distancePx);
              var computedFlipPadding = getComputedPadding(basePlacement, flipModifier && flipModifier.padding, distancePx);
              var instanceModifiers = instance.popperInstance.modifiers;
              setModifierValue(instanceModifiers, 'preventOverflow', 'padding', computedPreventOverflowPadding);
              setModifierValue(instanceModifiers, 'flip', 'padding', computedFlipPadding);
              return data;
            }
          },
          preventOverflow: _extends$n({
            boundariesElement: instance.props.boundary
          }, preventOverflowModifier),
          flip: _extends$n({
            enabled: instance.props.flip,
            behavior: instance.props.flipBehavior
          }, flipModifier),
          arrow: _extends$n({
            element: arrow,
            enabled: !!arrow
          }, getModifier$1(popperOptions, 'arrow')),
          offset: _extends$n({
            offset: instance.props.offset
          }, getModifier$1(popperOptions, 'offset'))
        }),
        onCreate: function onCreate(data) {
          applyMutations(data);
          preserveInvocation(popperOptions && popperOptions.onCreate, config.onCreate, [data]);
          runMountCallback();
        },
        onUpdate: function onUpdate(data) {
          applyMutations(data);
          preserveInvocation(popperOptions && popperOptions.onUpdate, config.onUpdate, [data]);
          runMountCallback();
        }
      });

      instance.popperInstance = new Popper(reference, popper, config);
    }

    function runMountCallback() {
      // Only invoke currentMountCallback after 2 updates
      // This fixes some bugs in Popper.js (TODO: aim for only 1 update)
      if (popperUpdates === 0) {
        popperUpdates++; // 1

        instance.popperInstance.update();
      } else if (currentMountCallback && popperUpdates === 1) {
        popperUpdates++; // 2

        reflow(popper);
        currentMountCallback();
      }
    }

    function mount() {
      // The mounting callback (`currentMountCallback`) is only run due to a
      // popperInstance update/create
      popperUpdates = 0;
      var appendTo = instance.props.appendTo;
      var parentNode; // By default, we'll append the popper to the triggerTargets's parentNode so
      // it's directly after the reference element so the elements inside the
      // tippy can be tabbed to
      // If there are clipping issues, the user can specify a different appendTo
      // and ensure focus management is handled correctly manually

      var node = getCurrentTarget();

      if (instance.props.interactive && appendTo === defaultProps.appendTo || appendTo === 'parent') {
        parentNode = node.parentNode;
      } else {
        parentNode = invokeWithArgsOrReturn(appendTo, [node]);
      } // The popper element needs to exist on the DOM before its position can be
      // updated as Popper.js needs to read its dimensions


      if (!parentNode.contains(popper)) {
        parentNode.appendChild(popper);
      }

      {
        // Accessibility check
        warnWhen(instance.props.interactive && appendTo === defaultProps.appendTo && node.nextElementSibling !== popper, "Interactive tippy element may not be accessible via keyboard\n        navigation because it is not directly after the reference element in\n        the DOM source order.\n\n        Using a wrapper <div> or <span> tag around the reference element solves\n        this by creating a new parentNode context.\n        \n        Specifying `appendTo: document.body` silences this warning, but it\n        assumes you are using a focus management solution to handle keyboard\n        navigation.\n        \n        See: https://atomiks.github.io/tippyjs/accessibility/#interactivity");
      }

      setModifierValue(instance.popperInstance.modifiers, 'flip', 'enabled', instance.props.flip);
      instance.popperInstance.enableEventListeners(); // Mounting callback invoked in `onUpdate`

      instance.popperInstance.update();
    }

    function scheduleShow(event) {
      instance.clearDelayTimeouts();

      if (!instance.popperInstance) {
        createPopperInstance();
      }

      if (event) {
        invokeHook('onTrigger', [instance, event]);
      }

      addDocumentMouseDownListener();
      var delay = getDelay(true);

      if (delay) {
        showTimeout = setTimeout(function () {
          instance.show();
        }, delay);
      } else {
        instance.show();
      }
    }

    function scheduleHide(event) {
      instance.clearDelayTimeouts();
      invokeHook('onUntrigger', [instance, event]);

      if (!instance.state.isVisible) {
        removeDocumentMouseDownListener();
        return;
      }

      var delay = getDelay(false);

      if (delay) {
        hideTimeout = setTimeout(function () {
          if (instance.state.isVisible) {
            instance.hide();
          }
        }, delay);
      } else {
        // Fixes a `transitionend` problem when it fires 1 frame too
        // late sometimes, we don't want hide() to be called.
        scheduleHideAnimationFrame = requestAnimationFrame(function () {
          instance.hide();
        });
      }
    }
    /* ======================= 🔑 Public methods 🔑 ======================= */


    function enable() {
      instance.state.isEnabled = true;
    }

    function disable() {
      // Disabling the instance should also hide it
      // https://github.com/atomiks/tippy.js-react/issues/106
      instance.hide();
      instance.state.isEnabled = false;
    }

    function clearDelayTimeouts() {
      clearTimeout(showTimeout);
      clearTimeout(hideTimeout);
      cancelAnimationFrame(scheduleHideAnimationFrame);
    }

    function setProps(partialProps) {
      {
        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning('setProps'));
      }

      if (instance.state.isDestroyed) {
        return;
      }

      {
        validateProps(partialProps, plugins);
        warnWhen(partialProps.plugins ? partialProps.plugins.length !== plugins.length || plugins.some(function (p, i) {
          if (partialProps.plugins && partialProps.plugins[i]) {
            return p !== partialProps.plugins[i];
          } else {
            return true;
          }
        }) : false, "Cannot update plugins");
      }

      invokeHook('onBeforeUpdate', [instance, partialProps]);
      removeListenersFromTriggerTarget();
      var prevProps = instance.props;
      var nextProps = evaluateProps(reference, _extends$n({}, instance.props, {}, partialProps, {
        ignoreAttributes: true
      }));
      nextProps.ignoreAttributes = useIfDefined(partialProps.ignoreAttributes, prevProps.ignoreAttributes);
      instance.props = nextProps;
      addListenersToTriggerTarget();

      if (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {
        cleanupInteractiveMouseListeners();
        debouncedOnMouseMove = debounce$2(onMouseMove, nextProps.interactiveDebounce);
      }

      updatePopperElement(popper, prevProps, nextProps);
      instance.popperChildren = getChildren(popper); // Ensure stale aria-expanded attributes are removed

      if (prevProps.triggerTarget && !nextProps.triggerTarget) {
        normalizeToArray(prevProps.triggerTarget).forEach(function (node) {
          node.removeAttribute('aria-expanded');
        });
      } else if (nextProps.triggerTarget) {
        reference.removeAttribute('aria-expanded');
      }

      handleAriaExpandedAttribute();

      if (instance.popperInstance) {
        if (POPPER_INSTANCE_DEPENDENCIES.some(function (prop) {
          return hasOwnProperty$1(partialProps, prop) && partialProps[prop] !== prevProps[prop];
        })) {
          var currentReference = instance.popperInstance.reference;
          instance.popperInstance.destroy();
          createPopperInstance();
          instance.popperInstance.reference = currentReference;

          if (instance.state.isVisible) {
            instance.popperInstance.enableEventListeners();
          }
        } else {
          instance.popperInstance.update();
        }
      }

      invokeHook('onAfterUpdate', [instance, partialProps]);
    }

    function setContent(content) {
      instance.setProps({
        content: content
      });
    }

    function show(duration) {
      if (duration === void 0) {
        duration = getValueAtIndexOrReturn(instance.props.duration, 0, defaultProps.duration);
      }

      {
        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning('show'));
      } // Early bail-out


      var isAlreadyVisible = instance.state.isVisible;
      var isDestroyed = instance.state.isDestroyed;
      var isDisabled = !instance.state.isEnabled;
      var isTouchAndTouchDisabled = currentInput.isTouch && !instance.props.touch;

      if (isAlreadyVisible || isDestroyed || isDisabled || isTouchAndTouchDisabled) {
        return;
      } // Normalize `disabled` behavior across browsers.
      // Firefox allows events on disabled elements, but Chrome doesn't.
      // Using a wrapper element (i.e. <span>) is recommended.


      if (getCurrentTarget().hasAttribute('disabled')) {
        return;
      }

      if (!instance.popperInstance) {
        createPopperInstance();
      }

      invokeHook('onShow', [instance], false);

      if (instance.props.onShow(instance) === false) {
        return;
      }

      addDocumentMouseDownListener();
      popper.style.visibility = 'visible';
      instance.state.isVisible = true; // Prevent a transition of the popper from its previous position and of the
      // elements at a different placement
      // Check if the tippy was fully unmounted before `show()` was called, to
      // allow for smooth transition for `createSingleton()`

      if (!instance.state.isMounted) {
        setTransitionDuration(transitionableElements.concat(popper), 0);
      }

      currentMountCallback = function currentMountCallback() {
        if (!instance.state.isVisible) {
          return;
        }

        setTransitionDuration([popper], instance.props.updateDuration);
        setTransitionDuration(transitionableElements, duration);
        setVisibilityState(transitionableElements, 'visible');
        handleAriaDescribedByAttribute();
        handleAriaExpandedAttribute();
        pushIfUnique(mountedInstances, instance);
        updateIOSClass(true);
        instance.state.isMounted = true;
        invokeHook('onMount', [instance]);
        onTransitionedIn(duration, function () {
          instance.state.isShown = true;
          invokeHook('onShown', [instance]);
        });
      };

      mount();
    }

    function hide(duration) {
      if (duration === void 0) {
        duration = getValueAtIndexOrReturn(instance.props.duration, 1, defaultProps.duration);
      }

      {
        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning('hide'));
      } // Early bail-out


      var isAlreadyHidden = !instance.state.isVisible && !isBeingDestroyed;
      var isDestroyed = instance.state.isDestroyed;
      var isDisabled = !instance.state.isEnabled && !isBeingDestroyed;

      if (isAlreadyHidden || isDestroyed || isDisabled) {
        return;
      }

      invokeHook('onHide', [instance], false);

      if (instance.props.onHide(instance) === false && !isBeingDestroyed) {
        return;
      }

      removeDocumentMouseDownListener();
      popper.style.visibility = 'hidden';
      instance.state.isVisible = false;
      instance.state.isShown = false;
      setTransitionDuration(transitionableElements, duration);
      setVisibilityState(transitionableElements, 'hidden');
      handleAriaDescribedByAttribute();
      handleAriaExpandedAttribute();
      onTransitionedOut(duration, function () {
        instance.popperInstance.disableEventListeners();
        instance.popperInstance.options.placement = instance.props.placement;
        popper.parentNode.removeChild(popper);
        mountedInstances = mountedInstances.filter(function (i) {
          return i !== instance;
        });

        if (mountedInstances.length === 0) {
          updateIOSClass(false);
        }

        instance.state.isMounted = false;
        invokeHook('onHidden', [instance]);
      });
    }

    function destroy() {
      {
        warnWhen(instance.state.isDestroyed, createMemoryLeakWarning('destroy'));
      }

      if (instance.state.isDestroyed) {
        return;
      }

      isBeingDestroyed = true;
      instance.clearDelayTimeouts();
      instance.hide(0);
      removeListenersFromTriggerTarget();
      delete reference._tippy;

      if (instance.popperInstance) {
        instance.popperInstance.destroy();
      }

      isBeingDestroyed = false;
      instance.state.isDestroyed = true;
      invokeHook('onDestroy', [instance]);
    }
  }

  function tippy(targets, optionalProps,
  /** @deprecated use Props.plugins */
  plugins) {
    if (optionalProps === void 0) {
      optionalProps = {};
    }

    if (plugins === void 0) {
      plugins = [];
    }

    plugins = defaultProps.plugins.concat(optionalProps.plugins || plugins);

    {
      validateTargets(targets);
      validateProps(optionalProps, plugins);
    }

    bindGlobalEventListeners();

    var props = _extends$n({}, defaultProps, {}, optionalProps, {
      plugins: plugins
    });

    var elements = getArrayOfElements(targets);

    {
      var isSingleContentElement = isElement(props.content);
      var isMoreThanOneReferenceElement = elements.length > 1;
      warnWhen(isSingleContentElement && isMoreThanOneReferenceElement, "tippy() was passed an Element as the `content` prop, but more than one\n      tippy instance was created by this invocation. This means the content\n      element will only be appended to the last tippy instance.\n      \n      Instead, pass the .innerHTML of the element, or use a function that\n      returns a cloned version of the element instead.\n      \n      1) content: () => element.cloneNode(true)\n      2) content: element.innerHTML");
    }

    var instances = elements.reduce(function (acc, reference) {
      var instance = reference && createTippy(reference, props);

      if (instance) {
        acc.push(instance);
      }

      return acc;
    }, []);
    return isElement(targets) ? instances[0] : instances;
  }

  tippy.version = version;
  tippy.defaultProps = defaultProps;
  tippy.setDefaultProps = setDefaultProps;
  tippy.currentInput = currentInput;

  function ownKeys$4(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$4(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$4(source, true).forEach(function (key) { _defineProperty$9(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$4(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty$9(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  // These props are not native to `tippy.js` and are specific to React only.
  const REACT_ONLY_PROPS = ['children', 'onCreate', 'isVisible', 'isEnabled'];
  /** Avoid Babel's large '_objectWithoutProperties' helper function.
   *
   * @param {object} props - Props object
   */

  function getNativeTippyProps(props) {
    return Object.keys(props).filter(prop => !REACT_ONLY_PROPS.includes(prop)).reduce((acc, key) => {
      acc[key] = props[key];
      return acc;
    }, {});
  }

  class PopoverBase extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$9(this, "state", {
        isMounted: false
      });

      _defineProperty$9(this, "container", typeof document !== 'undefined' && document.createElement('div'));
    }

    get isReactElementContent() {
      return React.isValidElement(this.props.content);
    }

    get options() {
      return _objectSpread$4({}, getNativeTippyProps(this.props), {
        content: this.isReactElementContent ? this.container : this.props.content
      });
    }

    get isManualTrigger() {
      return this.props.trigger === 'manual';
    }

    componentDidMount() {
      this.setState({
        isMounted: true
      });
      /* eslint-disable-next-line */

      this.tip = tippy(ReactDOM.findDOMNode(this), this.options);
      const {
        onCreate,
        isEnabled,
        isVisible
      } = this.props;

      if (onCreate) {
        onCreate(this.tip);
      }

      if (isEnabled === false) {
        this.tip.disable();
      }

      if (this.isManualTrigger && isVisible === true) {
        this.tip.show();
      }
    }

    componentDidUpdate() {
      this.tip.setProps(this.options);
      const {
        isEnabled,
        isVisible
      } = this.props;

      if (isEnabled === true) {
        this.tip.enable();
      }

      if (isEnabled === false) {
        this.tip.disable();
      }

      if (this.isManualTrigger) {
        if (isVisible === true) {
          this.tip.show();
        }

        if (isVisible === false) {
          this.tip.hide();
        }
      }
    }

    componentWillUnmount() {
      this.tip.destroy();
      this.tip = null;
    }

    render() {
      return React.createElement(React.Fragment, null, this.props.children, this.isReactElementContent && this.state.isMounted && ReactDOM.createPortal(this.props.content, this.container));
    }

  }

  _defineProperty$9(PopoverBase, "propTypes", {
    children: _pt.node.isRequired,
    content: _pt.node.isRequired,
    isEnabled: _pt.bool,
    isVisible: _pt.bool,
    onCreate: _pt.func,
    trigger: _pt.string
  });

  _defineProperty$9(PopoverBase, "defaultProps", {
    trigger: 'mouseenter focus'
  });

  var tooltip = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      tooltip: 'pf-c-tooltip',
      tooltipArrow: 'pf-c-tooltip__arrow',
      tooltipContent: 'pf-c-tooltip__content',
      modifiers: {
          'top': 'pf-m-top',
          'bottom': 'pf-m-bottom',
          'left': 'pf-m-left',
          'right': 'pf-m-right',
          'textAlignLeft': 'pf-m-text-align-left'
      }
  };
  });

  var styles$9 = unwrapExports(tooltip);

  function _extends$o() { _extends$o = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$o.apply(this, arguments); }

  function _objectWithoutProperties$m(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$m(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$m(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const TooltipContent = (_ref) => {
    let {
      className,
      children,
      isLeftAligned
    } = _ref,
        props = _objectWithoutProperties$m(_ref, ["className", "children", "isLeftAligned"]);

    return React.createElement("div", _extends$o({
      className: css$1(styles$9.tooltipContent, isLeftAligned && styles$9.modifiers.textAlignLeft, className)
    }, props), children);
  };
  TooltipContent.propTypes = {
    className: _pt.string,
    children: _pt.node.isRequired,
    isLeftAligned: _pt.bool
  };

  var c_tooltip_MaxWidth = {"name":"--pf-c-tooltip--MaxWidth","value":"18.75rem","var":"var(--pf-c-tooltip--MaxWidth)"};

  function _extends$p() { _extends$p = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$p.apply(this, arguments); }

  function _objectWithoutProperties$n(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$n(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$n(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$a(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (TooltipPosition) {
    TooltipPosition["auto"] = "auto";
    TooltipPosition["top"] = "top";
    TooltipPosition["bottom"] = "bottom";
    TooltipPosition["left"] = "left";
    TooltipPosition["right"] = "right";
  })(exports.TooltipPosition || (exports.TooltipPosition = {}));

  class Tooltip extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$a(this, "storeTippyInstance", tip => {
        tip.popperChildren.tooltip.classList.add(styles$9.tooltip);
        this.tip = tip;
      });

      _defineProperty$a(this, "handleEscKeyClick", event => {
        if (event.keyCode === KEY_CODES.ESCAPE_KEY && this.tip.state.isVisible) {
          this.tip.hide();
        }
      });
    }

    componentDidMount() {
      document.addEventListener('keydown', this.handleEscKeyClick, false);
    }

    componentWillUnmount() {
      document.removeEventListener('keydown', this.handleEscKeyClick, false);
    }

    extendChildren() {
      return React.cloneElement(this.props.children, {
        isAppLauncher: this.props.isAppLauncher
      });
    }

    render() {
      const _this$props = this.props,
            {
        position,
        trigger,
        isContentLeftAligned,
        isVisible,
        enableFlip,
        children,
        className,
        content: bodyContent,
        entryDelay,
        exitDelay,
        appendTo,
        zIndex,
        maxWidth,
        isAppLauncher,
        distance,
        aria,
        boundary,
        flipBehavior,
        tippyProps,
        id
      } = _this$props,
            rest = _objectWithoutProperties$n(_this$props, ["position", "trigger", "isContentLeftAligned", "isVisible", "enableFlip", "children", "className", "content", "entryDelay", "exitDelay", "appendTo", "zIndex", "maxWidth", "isAppLauncher", "distance", "aria", "boundary", "flipBehavior", "tippyProps", "id"]);

      const content = React.createElement("div", _extends$p({
        className: css$1(!enableFlip && getModifier(styles$9, position, styles$9.modifiers.top), className),
        role: "tooltip",
        id: id
      }, rest), React.createElement(TooltipContent, {
        isLeftAligned: isContentLeftAligned
      }, bodyContent));
      return React.createElement(PopoverBase, _extends$p({}, tippyProps, {
        arrow: true,
        aria: aria,
        onCreate: this.storeTippyInstance,
        maxWidth: maxWidth,
        zIndex: zIndex,
        appendTo: appendTo,
        content: content,
        lazy: true,
        theme: "pf-tooltip",
        placement: position,
        trigger: trigger,
        delay: [entryDelay, exitDelay],
        distance: distance,
        flip: enableFlip,
        flipBehavior: flipBehavior,
        boundary: boundary,
        isVisible: isVisible,
        popperOptions: {
          modifiers: {
            preventOverflow: {
              enabled: enableFlip
            },
            hide: {
              enabled: enableFlip
            }
          }
        }
      }), isAppLauncher ? this.extendChildren() : children);
    }

  }

  _defineProperty$a(Tooltip, "propTypes", {
    appendTo: _pt.oneOfType([_pt.element, _pt.func]),
    aria: _pt.oneOf(['describedby', 'labelledby']),
    boundary: _pt.oneOfType([_pt.oneOf(['scrollParent']), _pt.oneOf(['window']), _pt.oneOf(['viewport']), _pt.any]),
    children: _pt.element.isRequired,
    className: _pt.string,
    content: _pt.node.isRequired,
    distance: _pt.number,
    enableFlip: _pt.bool,
    entryDelay: _pt.number,
    exitDelay: _pt.number,
    flipBehavior: _pt.oneOfType([_pt.oneOf(['flip']), _pt.arrayOf(_pt.oneOf(['top', 'bottom', 'left', 'right']))]),
    isAppLauncher: _pt.bool,
    maxWidth: _pt.string,
    position: _pt.oneOf(['auto', 'top', 'bottom', 'left', 'right']),
    trigger: _pt.string,
    isContentLeftAligned: _pt.bool,
    isVisible: _pt.bool,
    zIndex: _pt.number,
    tippyProps: _pt.any,
    id: _pt.string
  });

  _defineProperty$a(Tooltip, "defaultProps", {
    position: 'top',
    trigger: 'mouseenter focus',
    isVisible: false,
    isContentLeftAligned: false,
    enableFlip: true,
    className: '',
    entryDelay: 500,
    exitDelay: 500,
    appendTo: () => document.body,
    zIndex: 9999,
    maxWidth: c_tooltip_MaxWidth && c_tooltip_MaxWidth.value,
    isAppLauncher: false,
    distance: 15,
    aria: 'describedby',
    boundary: 'window',
    // For every initial starting position, there are 3 escape positions
    flipBehavior: ['top', 'right', 'bottom', 'left', 'top', 'right', 'bottom'],
    tippyProps: {},
    id: ''
  });

  function ownKeys$5(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$5(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$5(source, true).forEach(function (key) { _defineProperty$b(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$5(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _extends$q() { _extends$q = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$q.apply(this, arguments); }

  function _objectWithoutProperties$o(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$o(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$o(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$b(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class InternalDropdownItem extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$b(this, "ref", React.createRef());

      _defineProperty$b(this, "additionalRef", React.createRef());

      _defineProperty$b(this, "getInnerNode", node => node && node.childNodes && node.childNodes.length ? node.childNodes[0] : node);

      _defineProperty$b(this, "onKeyDown", event => {
        // Detected key press on this item, notify the menu parent so that the appropriate item can be focused
        const innerIndex = event.target === this.ref.current ? 0 : 1;

        if (!this.props.customChild) {
          event.preventDefault();
        }

        if (event.key === 'ArrowUp') {
          this.props.context.keyHandler(this.props.index, innerIndex, KEYHANDLER_DIRECTION.UP);
        } else if (event.key === 'ArrowDown') {
          this.props.context.keyHandler(this.props.index, innerIndex, KEYHANDLER_DIRECTION.DOWN);
        } else if (event.key === 'ArrowRight') {
          this.props.context.keyHandler(this.props.index, innerIndex, KEYHANDLER_DIRECTION.RIGHT);
        } else if (event.key === 'ArrowLeft') {
          this.props.context.keyHandler(this.props.index, innerIndex, KEYHANDLER_DIRECTION.LEFT);
        } else if (event.key === 'Enter' || event.key === ' ') {
          event.target.click();
          this.props.enterTriggersArrowDown && this.props.context.keyHandler(this.props.index, innerIndex, KEYHANDLER_DIRECTION.DOWN);
        }
      });
    }

    componentDidMount() {
      const {
        context,
        index,
        isDisabled,
        role,
        customChild
      } = this.props;
      const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
      context.sendRef(index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
    }

    componentDidUpdate() {
      const {
        context,
        index,
        isDisabled,
        role,
        customChild
      } = this.props;
      const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
      context.sendRef(index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
    }

    extendAdditionalChildRef() {
      const {
        additionalChild
      } = this.props;
      return React.cloneElement(additionalChild, {
        ref: this.additionalRef
      });
    }

    render() {
      /* eslint-disable @typescript-eslint/no-unused-vars */
      const _this$props = this.props,
            {
        className,
        children,
        isHovered,
        context,
        onClick,
        component,
        variant,
        role,
        isDisabled,
        index,
        href,
        tooltip,
        tooltipProps,
        id,
        componentID,
        listItemClassName,
        additionalChild,
        customChild,
        enterTriggersArrowDown
      } = _this$props,
            additionalProps = _objectWithoutProperties$o(_this$props, ["className", "children", "isHovered", "context", "onClick", "component", "variant", "role", "isDisabled", "index", "href", "tooltip", "tooltipProps", "id", "componentID", "listItemClassName", "additionalChild", "customChild", "enterTriggersArrowDown"]);
      /* eslint-enable @typescript-eslint/no-unused-vars */


      const Component = component;
      let classes;

      if (Component === 'a') {
        additionalProps['aria-disabled'] = isDisabled;
        additionalProps.tabIndex = isDisabled ? -1 : additionalProps.tabIndex;
      } else if (Component === 'button') {
        additionalProps.disabled = isDisabled;
        additionalProps.type = additionalProps.type || 'button';
      }

      const renderWithTooltip = childNode => tooltip ? React.createElement(Tooltip, _extends$q({
        content: tooltip
      }, tooltipProps), childNode) : childNode;

      return React.createElement(DropdownContext.Consumer, null, ({
        onSelect,
        itemClass,
        disabledClass,
        hoverClass
      }) => {
        if (this.props.role === 'separator') {
          classes = css$1(variant === 'icon' && styles$8.modifiers.icon, className);
        } else {
          classes = css$1(variant === 'icon' && styles$8.modifiers.icon, className, isDisabled && disabledClass, isHovered && hoverClass, itemClass);
        }

        if (customChild) {
          return React.cloneElement(customChild, {
            ref: this.ref,
            onKeyDown: this.onKeyDown
          });
        }

        return React.createElement("li", {
          className: listItemClassName || null,
          role: role,
          onKeyDown: this.onKeyDown,
          onClick: event => {
            if (!isDisabled) {
              onClick(event);
              onSelect(event);
            }
          },
          id: id
        }, renderWithTooltip(React.isValidElement(component) ? React.cloneElement(component, _objectSpread$5({
          id: componentID
        }, component.props, {
          className: css$1(component.props.className, classes)
        })) : React.createElement(Component, _extends$q({}, additionalProps, {
          href: href,
          ref: this.ref,
          className: classes,
          id: componentID
        }), children)), additionalChild && this.extendAdditionalChildRef());
      });
    }

  }

  _defineProperty$b(InternalDropdownItem, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    listItemClassName: _pt.string,
    component: _pt.node,
    variant: _pt.oneOf(['item', 'icon']),
    role: _pt.string,
    isDisabled: _pt.bool,
    isHovered: _pt.bool,
    href: _pt.string,
    tooltip: _pt.node,
    tooltipProps: _pt.any,
    index: _pt.number,
    context: _pt.shape({
      keyHandler: _pt.func,
      sendRef: _pt.func
    }),
    onClick: _pt.func,
    id: _pt.string,
    componentID: _pt.string,
    additionalChild: _pt.node,
    customChild: _pt.node,
    enterTriggersArrowDown: _pt.bool
  });

  _defineProperty$b(InternalDropdownItem, "defaultProps", {
    className: '',
    isHovered: false,
    component: 'a',
    variant: 'item',
    role: 'none',
    isDisabled: false,
    tooltipProps: {},
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: event => undefined,
    index: -1,
    context: {
      keyHandler: () => {},
      sendRef: () => {}
    },
    enterTriggersArrowDown: false
  });

  function _extends$r() { _extends$r = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$r.apply(this, arguments); }

  function _objectWithoutProperties$p(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$p(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$p(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DropdownItem = (_ref) => {
    let {
      children = null,
      className = '',
      component = 'a',
      variant = 'item',
      isDisabled = false,
      isHovered = false,
      href,
      tooltip = null,
      tooltipProps = {},
      listItemClassName,
      onClick,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      ref,
      // Types of Ref are different for React.FC vs React.Component
      additionalChild,
      customChild
    } = _ref,
        props = _objectWithoutProperties$p(_ref, ["children", "className", "component", "variant", "isDisabled", "isHovered", "href", "tooltip", "tooltipProps", "listItemClassName", "onClick", "ref", "additionalChild", "customChild"]);

    return React.createElement(DropdownArrowContext.Consumer, null, context => React.createElement(InternalDropdownItem, _extends$r({
      context: context,
      role: "menuitem",
      tabIndex: -1,
      className: className,
      component: component,
      variant: variant,
      isDisabled: isDisabled,
      isHovered: isHovered,
      href: href,
      tooltip: tooltip,
      tooltipProps: tooltipProps,
      listItemClassName: listItemClassName,
      onClick: onClick,
      additionalChild: additionalChild,
      customChild: customChild
    }, props), children));
  };
  DropdownItem.propTypes = {
    children: _pt.node,
    className: _pt.string,
    listItemClassName: _pt.string,
    component: _pt.node,
    variant: _pt.oneOf(['item', 'icon']),
    isDisabled: _pt.bool,
    isHovered: _pt.bool,
    href: _pt.string,
    tooltip: _pt.node,
    tooltipProps: _pt.any,
    additionalChild: _pt.node,
    customChild: _pt.node
  };

  function _extends$s() { _extends$s = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$s.apply(this, arguments); }

  function _objectWithoutProperties$q(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$q(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$q(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DropdownItemIcon = (_ref) => {
    let {
      children,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$q(_ref, ["children", "className"]);

    return React.createElement("span", _extends$s({
      className: css$1(styles$8.dropdownMenuItemIcon, className)
    }, props), children);
  };
  DropdownItemIcon.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$t() { _extends$t = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$t.apply(this, arguments); }

  function _objectWithoutProperties$r(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$r(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$r(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DropdownSeparator = (_ref) => {
    let {
      className = '',
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      ref
    } = _ref,
        props = _objectWithoutProperties$r(_ref, ["className", "ref"]);

    return React.createElement(DropdownContext.Consumer, null, ({
      separatorClass
    }) => React.createElement(DropdownArrowContext.Consumer, null, context => React.createElement(InternalDropdownItem, _extends$t({}, props, {
      context: context,
      className: css$1(separatorClass, className),
      component: "div",
      role: "separator"
    }))));
  };
  DropdownSeparator.propTypes = {
    className: _pt.string,
    onClick: _pt.func
  };

  var ellipsisVIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.EllipsisVIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var EllipsisVIconConfig = {
    name: 'EllipsisVIcon',
    height: 512,
    width: 192,
    svgPath: 'M96 184c39.8 0 72 32.2 72 72s-32.2 72-72 72-72-32.2-72-72 32.2-72 72-72zM24 80c0 39.8 32.2 72 72 72s72-32.2 72-72S135.8 8 96 8 24 40.2 24 80zm0 352c0 39.8 32.2 72 72 72s72-32.2 72-72-32.2-72-72-72-72 32.2-72 72z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.EllipsisVIconConfig = EllipsisVIconConfig;

  var _default = (0, _createIcon["default"])(EllipsisVIconConfig);

  exports["default"] = _default;

  });

  var EllipsisVIcon = unwrapExports(ellipsisVIcon);
  var ellipsisVIcon_1 = ellipsisVIcon.EllipsisVIconConfig;

  function _extends$u() { _extends$u = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$u.apply(this, arguments); }

  function _objectWithoutProperties$s(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$s(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$s(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$c(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class Toggle extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$c(this, "buttonRef", React.createRef());

      _defineProperty$c(this, "componentDidMount", () => {
        document.addEventListener('mousedown', event => this.onDocClick(event));
        document.addEventListener('touchstart', event => this.onDocClick(event));
        document.addEventListener('keydown', event => this.onEscPress(event));
      });

      _defineProperty$c(this, "componentWillUnmount", () => {
        document.removeEventListener('mousedown', event => this.onDocClick(event));
        document.removeEventListener('touchstart', event => this.onDocClick(event));
        document.removeEventListener('keydown', event => this.onEscPress(event));
      });

      _defineProperty$c(this, "onDocClick", event => {
        if (this.props.isOpen && this.props.parentRef && this.props.parentRef.current && !this.props.parentRef.current.contains(event.target)) {
          this.props.onToggle(false, event);
          this.buttonRef.current.focus();
        }
      });

      _defineProperty$c(this, "onEscPress", event => {
        const {
          parentRef
        } = this.props;
        const keyCode = event.keyCode || event.which;

        if (this.props.isOpen && (keyCode === KEY_CODES.ESCAPE_KEY || event.key === 'Tab') && parentRef && parentRef.current && parentRef.current.contains(event.target)) {
          this.props.onToggle(false, event);
          this.buttonRef.current.focus();
        }
      });

      _defineProperty$c(this, "onKeyDown", event => {
        if (event.key === 'Tab' && !this.props.isOpen) {
          return;
        }

        if (!this.props.bubbleEvent) {
          event.stopPropagation();
        }

        event.preventDefault();

        if ((event.key === 'Tab' || event.key === 'Enter' || event.key === ' ') && this.props.isOpen) {
          this.props.onToggle(!this.props.isOpen, event);
        } else if ((event.key === 'Enter' || event.key === ' ') && !this.props.isOpen) {
          this.props.onToggle(!this.props.isOpen, event);
          this.props.onEnter();
        }
      });
    }

    render() {
      const _this$props = this.props,
            {
        className,
        children,
        isOpen,
        isFocused,
        isActive,
        isHovered,
        isDisabled,
        isPlain,
        isPrimary,
        isSplitButton,
        ariaHasPopup,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        bubbleEvent,
        onToggle,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onEnter,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        parentRef,
        id,
        type
      } = _this$props,
            props = _objectWithoutProperties$s(_this$props, ["className", "children", "isOpen", "isFocused", "isActive", "isHovered", "isDisabled", "isPlain", "isPrimary", "isSplitButton", "ariaHasPopup", "bubbleEvent", "onToggle", "onEnter", "parentRef", "id", "type"]);

      return React.createElement(DropdownContext.Consumer, null, ({
        toggleClass
      }) => React.createElement("button", _extends$u({}, props, {
        id: id,
        ref: this.buttonRef,
        className: css$1(isSplitButton ? styles$8.dropdownToggleButton : toggleClass || styles$8.dropdownToggle, isFocused && styles$8.modifiers.focus, isHovered && styles$8.modifiers.hover, isActive && styles$8.modifiers.active, isPlain && styles$8.modifiers.plain, isPrimary && styles$8.modifiers.primary, className),
        type: type || 'button',
        onClick: event => onToggle(!isOpen, event),
        "aria-expanded": isOpen,
        "aria-haspopup": ariaHasPopup,
        onKeyDown: event => this.onKeyDown(event),
        disabled: isDisabled
      }), children));
    }

  }

  _defineProperty$c(Toggle, "propTypes", {
    id: _pt.string.isRequired,
    type: _pt.oneOf(['button', 'submit', 'reset']),
    children: _pt.node,
    className: _pt.string,
    isOpen: _pt.bool,
    onToggle: _pt.func,
    onEnter: _pt.func,
    parentRef: _pt.any,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isActive: _pt.bool,
    isDisabled: _pt.bool,
    isPlain: _pt.bool,
    isPrimary: _pt.bool,
    isSplitButton: _pt.bool,
    ariaHasPopup: _pt.oneOfType([_pt.bool, _pt.oneOf(['listbox']), _pt.oneOf(['menu']), _pt.oneOf(['dialog']), _pt.oneOf(['grid']), _pt.oneOf(['listbox']), _pt.oneOf(['tree'])]),
    bubbleEvent: _pt.bool
  });

  _defineProperty$c(Toggle, "defaultProps", {
    className: '',
    isOpen: false,
    isFocused: false,
    isHovered: false,
    isActive: false,
    isDisabled: false,
    isPlain: false,
    isPrimary: false,
    isSplitButton: false,
    onToggle: () => {},
    onEnter: () => {},
    bubbleEvent: false
  });

  function _extends$v() { _extends$v = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$v.apply(this, arguments); }

  function _objectWithoutProperties$t(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$t(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$t(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const KebabToggle = (_ref) => {
    let {
      id = '',
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      children = null,
      className = '',
      isOpen = false,
      'aria-label': ariaLabel = 'Actions',
      parentRef = null,
      isFocused = false,
      isHovered = false,
      isActive = false,
      isPlain = false,
      isDisabled = false,
      bubbleEvent = false,
      onToggle = () => undefined,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      ref
    } = _ref,
        props = _objectWithoutProperties$t(_ref, ["id", "children", "className", "isOpen", "aria-label", "parentRef", "isFocused", "isHovered", "isActive", "isPlain", "isDisabled", "bubbleEvent", "onToggle", "ref"]);

    return React.createElement(Toggle, _extends$v({
      id: id,
      className: className,
      isOpen: isOpen,
      "aria-label": ariaLabel,
      parentRef: parentRef,
      isFocused: isFocused,
      isHovered: isHovered,
      isActive: isActive,
      isPlain: isPlain,
      isDisabled: isDisabled,
      onToggle: onToggle,
      bubbleEvent: bubbleEvent
    }, props), React.createElement(EllipsisVIcon, null));
  };
  KebabToggle.propTypes = {
    id: _pt.string,
    children: _pt.node,
    className: _pt.string,
    isOpen: _pt.bool,
    'aria-label': _pt.string,
    onToggle: _pt.func,
    parentRef: _pt.any,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isActive: _pt.bool,
    isDisabled: _pt.bool,
    isPlain: _pt.bool,
    type: _pt.oneOf(['button', 'submit', 'reset']),
    bubbleEvent: _pt.bool
  };

  var caretDownIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.CaretDownIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var CaretDownIconConfig = {
    name: 'CaretDownIcon',
    height: 512,
    width: 320,
    svgPath: 'M31.3 192h257.3c17.8 0 26.7 21.5 14.1 34.1L174.1 354.8c-7.8 7.8-20.5 7.8-28.3 0L17.2 226.1C4.6 213.5 13.5 192 31.3 192z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.CaretDownIconConfig = CaretDownIconConfig;

  var _default = (0, _createIcon["default"])(CaretDownIconConfig);

  exports["default"] = _default;

  });

  var CaretDownIcon = unwrapExports(caretDownIcon);
  var caretDownIcon_1 = caretDownIcon.CaretDownIconConfig;

  function _extends$w() { _extends$w = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$w.apply(this, arguments); }

  function _objectWithoutProperties$u(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$u(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$u(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DropdownToggle = (_ref) => {
    let {
      id = '',
      children = null,
      className = '',
      isOpen = false,
      parentRef = null,
      isFocused = false,
      isHovered = false,
      isActive = false,
      isDisabled = false,
      isPlain = false,
      isPrimary = false,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      onToggle = _isOpen => undefined,
      iconComponent: IconComponent = CaretDownIcon,
      splitButtonItems,
      splitButtonVariant = 'checkbox',
      ariaHasPopup,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      ref
    } = _ref,
        props = _objectWithoutProperties$u(_ref, ["id", "children", "className", "isOpen", "parentRef", "isFocused", "isHovered", "isActive", "isDisabled", "isPlain", "isPrimary", "onToggle", "iconComponent", "splitButtonItems", "splitButtonVariant", "ariaHasPopup", "ref"]);

    const toggle = React.createElement(DropdownContext.Consumer, null, ({
      toggleTextClass,
      toggleIconClass
    }) => React.createElement(Toggle, _extends$w({}, props, {
      id: id,
      className: className,
      isOpen: isOpen,
      parentRef: parentRef,
      isFocused: isFocused,
      isHovered: isHovered,
      isActive: isActive,
      isDisabled: isDisabled,
      isPlain: isPlain,
      isPrimary: isPrimary,
      onToggle: onToggle,
      ariaHasPopup: ariaHasPopup
    }, splitButtonItems && {
      isSplitButton: true,
      'aria-label': props['aria-label'] || 'Select'
    }), children && React.createElement("span", {
      className: IconComponent && css$1(toggleTextClass)
    }, children), IconComponent && React.createElement(IconComponent, {
      className: css$1(children && toggleIconClass)
    })));

    if (splitButtonItems) {
      return React.createElement("div", {
        className: css$1(styles$8.dropdownToggle, styles$8.modifiers.splitButton, splitButtonVariant === 'action' && styles$8.modifiers.action, isDisabled && styles$8.modifiers.disabled)
      }, splitButtonItems, toggle);
    }

    return toggle;
  };
  DropdownToggle.propTypes = {
    id: _pt.string,
    children: _pt.node,
    className: _pt.string,
    isOpen: _pt.bool,
    onToggle: _pt.func,
    parentRef: _pt.any,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isActive: _pt.bool,
    isPlain: _pt.bool,
    isDisabled: _pt.bool,
    isPrimary: _pt.bool,
    iconComponent: _pt.oneOfType([_pt.any, _pt.oneOf([null])]),
    splitButtonItems: _pt.arrayOf(_pt.node),
    splitButtonVariant: _pt.oneOf(['action', 'checkbox']),
    'aria-label': _pt.string,
    ariaHasPopup: _pt.oneOfType([_pt.bool, _pt.oneOf(['listbox']), _pt.oneOf(['menu']), _pt.oneOf(['dialog']), _pt.oneOf(['grid']), _pt.oneOf(['listbox']), _pt.oneOf(['tree'])]),
    type: _pt.oneOf(['button', 'submit', 'reset']),
    onEnter: _pt.func
  };

  function _extends$x() { _extends$x = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$x.apply(this, arguments); }

  function _objectWithoutProperties$v(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$v(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$v(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$d(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DropdownToggleCheckbox extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$d(this, "handleChange", event => {
        this.props.onChange(event.target.checked, event);
      });

      _defineProperty$d(this, "calculateChecked", () => {
        const {
          isChecked,
          checked
        } = this.props;
        return isChecked !== undefined ? isChecked : checked;
      });
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            {
        className,
        onChange,
        isValid,
        isDisabled,
        isChecked,
        checked,
        children
      } = _this$props,
            props = _objectWithoutProperties$v(_this$props, ["className", "onChange", "isValid", "isDisabled", "isChecked", "checked", "children"]);

      const text = children && React.createElement("span", {
        className: css$1(styles$8.dropdownToggleText, className),
        "aria-hidden": "true",
        id: `${props.id}-text`
      }, children);
      return React.createElement("label", {
        className: css$1(styles$8.dropdownToggleCheck, className),
        htmlFor: props.id
      }, React.createElement("input", _extends$x({}, props, this.calculateChecked() !== undefined && {
        onChange: this.handleChange
      }, {
        type: "checkbox",
        ref: elem => elem && (elem.indeterminate = isChecked === null),
        "aria-invalid": !isValid,
        disabled: isDisabled,
        checked: this.calculateChecked()
      })), text);
    }

  }

  _defineProperty$d(DropdownToggleCheckbox, "propTypes", {
    className: _pt.string,
    isValid: _pt.bool,
    isDisabled: _pt.bool,
    isChecked: _pt.oneOfType([_pt.bool, _pt.oneOf([null])]),
    checked: _pt.oneOfType([_pt.bool, _pt.oneOf([null])]),
    onChange: _pt.func,
    children: _pt.node,
    id: _pt.string.isRequired,
    'aria-label': _pt.string.isRequired
  });

  _defineProperty$d(DropdownToggleCheckbox, "defaultProps", {
    className: '',
    isValid: true,
    isDisabled: false,
    onChange: () => undefined
  });

  function _extends$y() { _extends$y = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$y.apply(this, arguments); }

  function _objectWithoutProperties$w(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$w(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$w(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$e(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DropdownToggleAction extends React.Component {
    render() {
      const _this$props = this.props,
            {
        id,
        className,
        onClick,
        isDisabled,
        children
      } = _this$props,
            props = _objectWithoutProperties$w(_this$props, ["id", "className", "onClick", "isDisabled", "children"]);

      return React.createElement("button", _extends$y({
        id: id,
        className: css$1(styles$8.dropdownToggleButton, className),
        onClick: onClick
      }, isDisabled && {
        disabled: true,
        'aria-disabled': true
      }, props), children);
    }

  }

  _defineProperty$e(DropdownToggleAction, "propTypes", {
    className: _pt.string,
    isDisabled: _pt.bool,
    onClick: _pt.func,
    children: _pt.node,
    id: _pt.string,
    'aria-label': _pt.string
  });

  _defineProperty$e(DropdownToggleAction, "defaultProps", {
    className: '',
    isDisabled: false,
    onClick: () => {}
  });

  function _objectWithoutProperties$x(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$x(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$x(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ApplicationLauncherGroup = (_ref) => {
    let {
      children
    } = _ref,
        props = _objectWithoutProperties$x(_ref, ["children"]);

    return React.createElement(DropdownGroup, props, children);
  };

  function _objectWithoutProperties$y(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$y(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$y(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ApplicationLauncherSeparator = (_ref) => {
    let props = _objectWithoutProperties$y(_ref, ["children"]);

    return React.createElement(DropdownSeparator, props);
  };

  function _extends$z() { _extends$z = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$z.apply(this, arguments); }

  function _objectWithoutProperties$z(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$z(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$z(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ApplicationLauncherIcon = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children
    } = _ref,
        props = _objectWithoutProperties$z(_ref, ["className", "children"]);

    return React.createElement("span", _extends$z({
      className: css$1(styles$7.appLauncherMenuItemIcon)
    }, props), children);
  };
  ApplicationLauncherIcon.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string
  };

  function _extends$A() { _extends$A = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$A.apply(this, arguments); }

  function _objectWithoutProperties$A(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$A(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$A(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ApplicationLauncherText = (_ref) => {
    let {
      className = '',
      children
    } = _ref,
        props = _objectWithoutProperties$A(_ref, ["className", "children"]);

    return React.createElement("span", _extends$A({
      className: css$1('pf-c-app-launcher__menu-item-text', className)
    }, props), children);
  };
  ApplicationLauncherText.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string
  };

  var externalLinkAltIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ExternalLinkAltIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var ExternalLinkAltIconConfig = {
    name: 'ExternalLinkAltIcon',
    height: 512,
    width: 512,
    svgPath: 'M432,320H400a16,16,0,0,0-16,16V448H64V128H208a16,16,0,0,0,16-16V80a16,16,0,0,0-16-16H48A48,48,0,0,0,0,112V464a48,48,0,0,0,48,48H400a48,48,0,0,0,48-48V336A16,16,0,0,0,432,320ZM488,0h-128c-21.37,0-32.05,25.91-17,41l35.73,35.73L135,320.37a24,24,0,0,0,0,34L157.67,377a24,24,0,0,0,34,0L435.28,133.32,471,169c15,15,41,4.5,41-17V24A24,24,0,0,0,488,0Z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.ExternalLinkAltIconConfig = ExternalLinkAltIconConfig;

  var _default = (0, _createIcon["default"])(ExternalLinkAltIconConfig);

  exports["default"] = _default;

  });

  var ExternalLinkAltIcon = unwrapExports(externalLinkAltIcon);
  var externalLinkAltIcon_1 = externalLinkAltIcon.ExternalLinkAltIconConfig;

  const ApplicationLauncherItemContext = React.createContext({
    isExternal: false,
    icon: null
  });

  const ApplicationLauncherContent = ({
    children
  }) => React.createElement(ApplicationLauncherItemContext.Consumer, null, ({
    isExternal,
    icon
  }) => React.createElement(React.Fragment, null, icon && React.createElement(ApplicationLauncherIcon, null, icon), icon ? React.createElement(ApplicationLauncherText, null, children) : children, isExternal && React.createElement(React.Fragment, null, React.createElement("span", {
    className: css$1(styles$7.appLauncherMenuItemExternalIcon)
  }, React.createElement(ExternalLinkAltIcon, null)), React.createElement("span", {
    className: css$1(a11yStyles.screenReader)
  }, "(opens new window)"))));
  ApplicationLauncherContent.propTypes = {
    children: _pt.node.isRequired
  };

  const ApplicationLauncherContext = React.createContext({
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onFavorite: (itemId, isFavorite) => {}
  });

  var starIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.StarIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var StarIconConfig = {
    name: 'StarIcon',
    height: 512,
    width: 576,
    svgPath: 'M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.StarIconConfig = StarIconConfig;

  var _default = (0, _createIcon["default"])(StarIconConfig);

  exports["default"] = _default;

  });

  var StarIcon = unwrapExports(starIcon);
  var starIcon_1 = starIcon.StarIconConfig;

  function _extends$B() { _extends$B = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$B.apply(this, arguments); }

  function _objectWithoutProperties$B(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$B(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$B(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ApplicationLauncherItem = (_ref) => {
    let {
      className = '',
      id,
      children,
      icon = null,
      isExternal = false,
      href,
      tooltip = null,
      tooltipProps = null,
      component = 'a',
      isFavorite = null,
      ariaIsFavoriteLabel = 'starred',
      ariaIsNotFavoriteLabel = 'not starred',
      customChild,
      enterTriggersArrowDown = false
    } = _ref,
        props = _objectWithoutProperties$B(_ref, ["className", "id", "children", "icon", "isExternal", "href", "tooltip", "tooltipProps", "component", "isFavorite", "ariaIsFavoriteLabel", "ariaIsNotFavoriteLabel", "customChild", "enterTriggersArrowDown"]);

    return React.createElement(ApplicationLauncherItemContext.Provider, {
      value: {
        isExternal,
        icon
      }
    }, React.createElement(ApplicationLauncherContext.Consumer, null, ({
      onFavorite
    }) => React.createElement(DropdownItem, _extends$B({
      id: id,
      component: component,
      href: href || null,
      className: css$1(isExternal && styles$7.modifiers.external, isFavorite !== null && styles$7.modifiers.link, className),
      listItemClassName: css$1(onFavorite && styles$7.appLauncherMenuWrapper, isFavorite && styles$7.modifiers.favorite),
      tooltip: tooltip,
      tooltipProps: tooltipProps
    }, enterTriggersArrowDown === true && {
      enterTriggersArrowDown
    }, customChild && {
      customChild
    }, isFavorite !== null && {
      additionalChild: React.createElement("button", {
        className: css$1(styles$7.appLauncherMenuItem, styles$7.modifiers.action),
        "aria-label": isFavorite ? ariaIsFavoriteLabel : ariaIsNotFavoriteLabel,
        onClick: () => {
          onFavorite(id, isFavorite);
        }
      }, React.createElement(StarIcon, null))
    }, props), children && React.createElement(ApplicationLauncherContent, null, children))));
  };
  ApplicationLauncherItem.propTypes = {
    icon: _pt.node,
    isExternal: _pt.bool,
    tooltip: _pt.node,
    tooltipProps: _pt.any,
    component: _pt.node,
    isFavorite: _pt.bool,
    ariaIsFavoriteLabel: _pt.string,
    ariaIsNotFavoriteLabel: _pt.string,
    id: _pt.string,
    customChild: _pt.node,
    enterTriggersArrowDown: _pt.bool
  };

  function _objectWithoutProperties$C(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$C(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$C(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _extends$C() { _extends$C = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$C.apply(this, arguments); }

  function _defineProperty$f(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class ApplicationLauncher extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$f(this, "createSearchBox", () => {
        const {
          onSearch,
          searchPlaceholderText,
          searchProps
        } = this.props;
        return React.createElement("div", {
          key: "search",
          className: css$1(styles$7.appLauncherMenuSearch)
        }, React.createElement(ApplicationLauncherItem, {
          customChild: React.createElement("input", _extends$C({
            type: "search",
            className: css$1(formStyles.formControl),
            placeholder: searchPlaceholderText,
            onChange: e => onSearch(e.target.value)
          }, searchProps))
        }));
      });

      _defineProperty$f(this, "createRenderableFavorites", () => {
        const {
          items,
          isGrouped,
          favorites
        } = this.props;

        if (isGrouped) {
          const favoriteItems = [];
          items.forEach(group => group.props.children.filter(item => favorites.includes(item.props.id)).map(item => favoriteItems.push(React.cloneElement(item, {
            isFavorite: true,
            enterTriggersArrowDown: true
          }))));
          return favoriteItems;
        }

        return items.filter(item => favorites.includes(item.props.id)).map(item => React.cloneElement(item, {
          isFavorite: true,
          enterTriggersArrowDown: true
        }));
      });

      _defineProperty$f(this, "extendItemsWithFavorite", () => {
        const {
          items,
          isGrouped,
          favorites
        } = this.props;

        if (isGrouped) {
          return items.map(group => React.cloneElement(group, {
            children: React.Children.map(group.props.children, item => {
              if (item.type === ApplicationLauncherSeparator) {
                return item;
              }

              return React.cloneElement(item, {
                isFavorite: favorites.some(favoriteId => favoriteId === item.props.id)
              });
            })
          }));
        }

        return items.map(item => React.cloneElement(item, {
          isFavorite: favorites.some(favoriteId => favoriteId === item.props.id)
        }));
      });
    }

    render() {
      const _this$props = this.props,
            {
        'aria-label': ariaLabel,
        isOpen,
        onToggle,
        toggleIcon,
        toggleId,
        onSelect,
        isDisabled,
        className,
        isGrouped,
        dropdownItems,
        favorites,
        onFavorite,
        onSearch,
        items,

        /* eslint-disable @typescript-eslint/no-unused-vars */
        searchPlaceholderText,
        searchProps,
        ref,

        /* eslint-enable @typescript-eslint/no-unused-vars */
        favoritesLabel,
        searchNoResultsText
      } = _this$props,
            props = _objectWithoutProperties$C(_this$props, ["aria-label", "isOpen", "onToggle", "toggleIcon", "toggleId", "onSelect", "isDisabled", "className", "isGrouped", "dropdownItems", "favorites", "onFavorite", "onSearch", "items", "searchPlaceholderText", "searchProps", "ref", "favoritesLabel", "searchNoResultsText"]);

      let renderableItems = [];

      if (onFavorite) {
        let favoritesGroup = [];
        let renderableFavorites = [];

        if (favorites.length > 0) {
          renderableFavorites = this.createRenderableFavorites();
          favoritesGroup = [React.createElement(ApplicationLauncherGroup, {
            key: "favorites",
            label: favoritesLabel
          }, renderableFavorites, React.createElement(ApplicationLauncherSeparator, {
            key: "separator"
          }))];
        }

        if (renderableFavorites.length > 0) {
          renderableItems = favoritesGroup.concat(this.extendItemsWithFavorite());
        } else {
          renderableItems = this.extendItemsWithFavorite();
        }
      } else {
        renderableItems = items;
      }

      if (items.length === 0 && dropdownItems.length === 0) {
        renderableItems = [React.createElement(ApplicationLauncherGroup, {
          key: "no-results-group"
        }, React.createElement(ApplicationLauncherItem, {
          key: "no-results"
        }, searchNoResultsText))];
      }

      if (onSearch) {
        renderableItems = [this.createSearchBox(), ...renderableItems];
      }

      return React.createElement(ApplicationLauncherContext.Provider, {
        value: {
          onFavorite
        }
      }, React.createElement(DropdownContext.Provider, {
        value: {
          onSelect,
          menuClass: styles$7.appLauncherMenu,
          itemClass: styles$7.appLauncherMenuItem,
          toggleClass: styles$7.appLauncherToggle,
          baseClass: styles$7.appLauncher,
          baseComponent: 'nav',
          sectionClass: styles$7.appLauncherGroup,
          sectionTitleClass: styles$7.appLauncherGroupTitle,
          sectionComponent: 'section',
          disabledClass: styles$7.modifiers.disabled,
          hoverClass: styles$7.modifiers.hover,
          separatorClass: styles$7.appLauncherSeparator
        }
      }, React.createElement(DropdownWithOuiaContext, _extends$C({}, props, {
        dropdownItems: renderableItems.length ? renderableItems : dropdownItems,
        isOpen: isOpen,
        className: className,
        "aria-label": ariaLabel,
        toggle: React.createElement(DropdownToggle, {
          id: toggleId,
          iconComponent: null,
          isOpen: isOpen,
          onToggle: onToggle,
          isDisabled: isDisabled,
          "aria-label": ariaLabel
        }, toggleIcon),
        isGrouped: isGrouped
      }))));
    }

  }

  _defineProperty$f(ApplicationLauncher, "propTypes", {
    className: _pt.string,
    direction: _pt.oneOfType([_pt.any, _pt.oneOf(['up']), _pt.oneOf(['down'])]),
    dropdownItems: _pt.arrayOf(_pt.node),
    items: _pt.arrayOf(_pt.node),
    isDisabled: _pt.bool,
    isOpen: _pt.bool,
    position: _pt.oneOfType([_pt.any, _pt.oneOf(['right']), _pt.oneOf(['left'])]),
    onSelect: _pt.func,
    onToggle: _pt.func,
    'aria-label': _pt.string,
    isGrouped: _pt.bool,
    toggleIcon: _pt.node,
    favorites: _pt.arrayOf(_pt.string),
    onFavorite: _pt.func,
    onSearch: _pt.func,
    searchPlaceholderText: _pt.string,
    searchNoResultsText: _pt.string,
    searchProps: _pt.any,
    favoritesLabel: _pt.string,
    toggleId: _pt.string
  });

  _defineProperty$f(ApplicationLauncher, "defaultProps", {
    className: '',
    isDisabled: false,
    direction: exports.DropdownDirection.down,
    dropdownItems: [],
    favorites: [],
    items: [],
    isOpen: false,
    position: exports.DropdownPosition.left,

    /* eslint-disable @typescript-eslint/no-unused-vars */
    onSelect: _event => undefined,
    onToggle: _value => undefined,

    /* eslint-enable @typescript-eslint/no-unused-vars */
    'aria-label': 'Application launcher',
    isGrouped: false,
    toggleIcon: React.createElement(ThIcon, null),
    searchPlaceholderText: 'Filter by name...',
    searchNoResultsText: 'No results found',
    favoritesLabel: 'Favorites'
  });

  var avatar = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      avatar: 'pf-c-avatar',
      modifiers: {}
  };
  });

  var styles$a = unwrapExports(avatar);

  function _extends$D() { _extends$D = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$D.apply(this, arguments); }

  function _objectWithoutProperties$D(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$D(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$D(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Avatar = (_ref) => {
    let {
      className = '',
      src = '',
      alt
    } = _ref,
        props = _objectWithoutProperties$D(_ref, ["className", "src", "alt"]);

    return React.createElement("img", _extends$D({}, props, {
      src: src,
      alt: alt,
      className: css$1(styles$a.avatar, className)
    }));
  };
  Avatar.propTypes = {
    className: _pt.string,
    src: _pt.string,
    alt: _pt.string.isRequired
  };

  var backgroundImage = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      backgroundImage: 'pf-c-background-image',
      backgroundImageFilter: 'pf-c-background-image__filter',
      modifiers: {}
  };
  });

  var styles$b = unwrapExports(backgroundImage);

  var c_background_image_BackgroundImage = {"name":"--pf-c-background-image--BackgroundImage","value":"url(assets/images/pfbg_576.jpg)","var":"var(--pf-c-background-image--BackgroundImage)"};

  var c_background_image_BackgroundImage_2x = {"name":"--pf-c-background-image--BackgroundImage-2x","value":"url(assets/images/pfbg_576@2x.jpg)","var":"var(--pf-c-background-image--BackgroundImage-2x)"};

  var c_background_image_BackgroundImage_sm = {"name":"--pf-c-background-image--BackgroundImage--sm","value":"url(assets/images/pfbg_768.jpg)","var":"var(--pf-c-background-image--BackgroundImage--sm)"};

  var c_background_image_BackgroundImage_sm_2x = {"name":"--pf-c-background-image--BackgroundImage--sm-2x","value":"url(assets/images/pfbg_768@2x.jpg)","var":"var(--pf-c-background-image--BackgroundImage--sm-2x)"};

  var c_background_image_BackgroundImage_lg = {"name":"--pf-c-background-image--BackgroundImage--lg","value":"url(assets/images/pfbg_2000.jpg)","var":"var(--pf-c-background-image--BackgroundImage--lg)"};

  function _extends$E() { _extends$E = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$E.apply(this, arguments); }

  function _objectWithoutProperties$E(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$E(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$E(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (BackgroundImageSrc) {
    BackgroundImageSrc["xs"] = "xs";
    BackgroundImageSrc["xs2x"] = "xs2x";
    BackgroundImageSrc["sm"] = "sm";
    BackgroundImageSrc["sm2x"] = "sm2x";
    BackgroundImageSrc["lg"] = "lg";
    BackgroundImageSrc["filter"] = "filter";
  })(exports.BackgroundImageSrc || (exports.BackgroundImageSrc = {}));

  const cssVariables = {
    [exports.BackgroundImageSrc.xs]: c_background_image_BackgroundImage && c_background_image_BackgroundImage.name,
    [exports.BackgroundImageSrc.xs2x]: c_background_image_BackgroundImage_2x && c_background_image_BackgroundImage_2x.name,
    [exports.BackgroundImageSrc.sm]: c_background_image_BackgroundImage_sm && c_background_image_BackgroundImage_sm.name,
    [exports.BackgroundImageSrc.sm2x]: c_background_image_BackgroundImage_sm_2x && c_background_image_BackgroundImage_sm_2x.name,
    [exports.BackgroundImageSrc.lg]: c_background_image_BackgroundImage_lg && c_background_image_BackgroundImage_lg.name
  };
  const BackgroundImage = (_ref) => {
    let {
      className = '',
      src
    } = _ref,
        props = _objectWithoutProperties$E(_ref, ["className", "src"]);

    let srcMap = src; // Default string value to handle all sizes

    if (typeof src === 'string') {
      srcMap = {
        [exports.BackgroundImageSrc.xs]: src,
        [exports.BackgroundImageSrc.xs2x]: src,
        [exports.BackgroundImageSrc.sm]: src,
        [exports.BackgroundImageSrc.sm2x]: src,
        [exports.BackgroundImageSrc.lg]: src,
        [exports.BackgroundImageSrc.filter]: '' // unused

      };
    } // Build stylesheet string based on cssVariables


    let cssSheet = '';
    Object.keys(cssVariables).forEach(size => {
      cssSheet += `${cssVariables[size]}: url('${srcMap[size]}');`;
    }); // Create emotion stylesheet to inject new css

    const bgStyles = StyleSheet$1.create({
      bgOverrides: `&.pf-c-background-image {
      ${cssSheet}
    }`
    });
    return React.createElement("div", _extends$E({
      className: css$1(styles$b.backgroundImage, bgStyles.bgOverrides, className)
    }, props), React.createElement("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      className: "pf-c-background-image__filter",
      width: "0",
      height: "0"
    }, React.createElement("filter", {
      id: "image_overlay"
    }, React.createElement("feColorMatrix", {
      type: "matrix",
      values: "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0"
    }), React.createElement("feComponentTransfer", {
      colorInterpolationFilters: "sRGB",
      result: "duotone"
    }, React.createElement("feFuncR", {
      type: "table",
      tableValues: "0.086274509803922 0.43921568627451"
    }), React.createElement("feFuncG", {
      type: "table",
      tableValues: "0.086274509803922 0.43921568627451"
    }), React.createElement("feFuncB", {
      type: "table",
      tableValues: "0.086274509803922 0.43921568627451"
    }), React.createElement("feFuncA", {
      type: "table",
      tableValues: "0 1"
    })))));
  };
  BackgroundImage.propTypes = {
    className: _pt.string,
    src: _pt.oneOfType([_pt.string, _pt.shape({
      xs: _pt.string.isRequired,
      xs2x: _pt.string.isRequired,
      sm: _pt.string.isRequired,
      sm2x: _pt.string.isRequired,
      lg: _pt.string.isRequired,
      filter: _pt.string
    })]).isRequired
  };

  var badge = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      badge: 'pf-c-badge',
      modifiers: {
          'read': 'pf-m-read',
          'unread': 'pf-m-unread'
      }
  };
  });

  var badgeStyles = unwrapExports(badge);

  function _extends$F() { _extends$F = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$F.apply(this, arguments); }

  function _objectWithoutProperties$F(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$F(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$F(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Badge = (_ref) => {
    let {
      isRead = false,
      className = '',
      children = ''
    } = _ref,
        props = _objectWithoutProperties$F(_ref, ["isRead", "className", "children"]);

    return React.createElement("span", _extends$F({}, props, {
      className: css$1(badgeStyles.badge, isRead ? badgeStyles.modifiers.read : badgeStyles.modifiers.unread, className)
    }), children);
  };
  Badge.propTypes = {
    isRead: _pt.bool,
    children: _pt.node,
    className: _pt.string
  };

  function _extends$G() { _extends$G = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$G.apply(this, arguments); }

  function _objectWithoutProperties$G(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$G(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$G(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Brand = (_ref) => {
    let {
      className = '',
      src = '',
      alt
    } = _ref,
        props = _objectWithoutProperties$G(_ref, ["className", "src", "alt"]);

    return (
      /** the brand component currently contains no styling the 'pf-c-brand' string will be used for the className */
      React.createElement("img", _extends$G({}, props, {
        className: css$1('pf-c-brand', className),
        src: src,
        alt: alt
      }))
    );
  };
  Brand.propTypes = {
    className: _pt.string,
    src: _pt.string,
    alt: _pt.string.isRequired
  };

  var breadcrumb = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      breadcrumb: 'pf-c-breadcrumb',
      breadcrumbList: 'pf-c-breadcrumb__list',
      breadcrumbItem: 'pf-c-breadcrumb__item',
      breadcrumbItemDivider: 'pf-c-breadcrumb__item-divider',
      breadcrumbLink: 'pf-c-breadcrumb__link',
      breadcrumbHeading: 'pf-c-breadcrumb__heading',
      modifiers: {
          'current': 'pf-m-current',
          'hover': 'pf-m-hover',
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var styles$c = unwrapExports(breadcrumb);

  function _extends$H() { _extends$H = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$H.apply(this, arguments); }

  function _objectWithoutProperties$H(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$H(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$H(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  const Breadcrumb = (_ref) => {
    let {
      children = null,
      className = '',
      'aria-label': ariaLabel = 'Breadcrumb',
      ouiaContext = null,
      ouiaId = null
    } = _ref,
        props = _objectWithoutProperties$H(_ref, ["children", "className", "aria-label", "ouiaContext", "ouiaId"]);

    return React.createElement("nav", _extends$H({}, props, {
      "aria-label": ariaLabel,
      className: css$1(styles$c.breadcrumb, className)
    }, ouiaContext.isOuia && {
      'data-ouia-component-type': 'Breadcrumb',
      'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
    }), React.createElement("ol", {
      className: css$1(styles$c.breadcrumbList)
    }, children));
  };

  Breadcrumb.propTypes = {
    children: _pt.node,
    className: _pt.string,
    'aria-label': _pt.string
  };
  const BreadcrumbWithOuiaContext = withOuiaContext(Breadcrumb);

  function _extends$I() { _extends$I = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$I.apply(this, arguments); }

  function _objectWithoutProperties$I(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$I(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$I(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const BreadcrumbItem = (_ref) => {
    let {
      children = null,
      className = '',
      to = null,
      isActive = false,
      target = null,
      component = 'a'
    } = _ref,
        props = _objectWithoutProperties$I(_ref, ["children", "className", "to", "isActive", "target", "component"]);

    const Component = component;
    return React.createElement("li", _extends$I({}, props, {
      className: css$1(styles$c.breadcrumbItem, className)
    }), to && React.createElement(Component, {
      href: to,
      target: target,
      className: css$1(styles$c.breadcrumbLink, isActive ? getModifier(styles$c, 'current') : ''),
      "aria-current": isActive ? 'page' : undefined
    }, children), !to && React.createElement(React.Fragment, null, children), !isActive && React.createElement("span", {
      className: css$1(styles$c.breadcrumbItemDivider)
    }, React.createElement(AngleRightIcon, null)));
  };
  BreadcrumbItem.propTypes = {
    children: _pt.node,
    className: _pt.string,
    to: _pt.string,
    isActive: _pt.bool,
    target: _pt.string,
    component: _pt.node
  };

  function _extends$J() { _extends$J = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$J.apply(this, arguments); }

  function _objectWithoutProperties$J(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$J(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$J(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const BreadcrumbHeading = (_ref) => {
    let {
      children = null,
      className = '',
      to = null,
      target = null,
      component = 'a'
    } = _ref,
        props = _objectWithoutProperties$J(_ref, ["children", "className", "to", "target", "component"]);

    const Component = component;
    return React.createElement("li", _extends$J({}, props, {
      className: css$1(styles$c.breadcrumbItem, className)
    }), React.createElement("h1", {
      className: css$1(styles$c.breadcrumbHeading)
    }, to && React.createElement(Component, {
      href: to,
      target: target,
      className: css$1(styles$c.breadcrumbLink, styles$c.modifiers.current),
      "aria-current": "page"
    }, children), !to && React.createElement(React.Fragment, null, children)));
  };
  BreadcrumbHeading.propTypes = {
    children: _pt.node,
    className: _pt.string,
    to: _pt.string,
    target: _pt.string,
    component: _pt.node
  };

  var card = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      card: 'pf-c-card',
      cardHead: 'pf-c-card__head',
      cardActions: 'pf-c-card__actions',
      cardHeader: 'pf-c-card__header',
      cardBody: 'pf-c-card__body',
      cardFooter: 'pf-c-card__footer',
      modifiers: {
          'hoverable': 'pf-m-hoverable',
          'selectable': 'pf-m-selectable',
          'selected': 'pf-m-selected',
          'compact': 'pf-m-compact',
          'noFill': 'pf-m-no-fill',
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var styles$d = unwrapExports(card);

  function _extends$K() { _extends$K = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$K.apply(this, arguments); }

  function _objectWithoutProperties$K(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$K(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$K(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Card = (_ref) => {
    let {
      children = null,
      className = '',
      component = 'article',
      isHoverable = false,
      isCompact = false,
      isSelectable = false,
      isSelected = false
    } = _ref,
        props = _objectWithoutProperties$K(_ref, ["children", "className", "component", "isHoverable", "isCompact", "isSelectable", "isSelected"]);

    const Component = component;
    return React.createElement(Component, _extends$K({
      className: css$1(styles$d.card, isHoverable && styles$d.modifiers.hoverable, isCompact && styles$d.modifiers.compact, isSelectable && styles$d.modifiers.selectable, isSelected && isSelectable && styles$d.modifiers.selected, className),
      tabIndex: isSelectable ? '0' : undefined
    }, props), children);
  };
  Card.propTypes = {
    children: _pt.node,
    className: _pt.string,
    component: _pt.any,
    isHoverable: _pt.bool,
    isCompact: _pt.bool,
    isSelectable: _pt.bool,
    isSelected: _pt.bool
  };

  function _extends$L() { _extends$L = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$L.apply(this, arguments); }

  function _objectWithoutProperties$L(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$L(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$L(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const CardActions = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$L(_ref, ["children", "className"]);

    return React.createElement("div", _extends$L({
      className: css$1(styles$d.cardActions, className)
    }, props), children);
  };
  CardActions.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$M() { _extends$M = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$M.apply(this, arguments); }

  function _objectWithoutProperties$M(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$M(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$M(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const CardBody = (_ref) => {
    let {
      children = null,
      className = '',
      component = 'div',
      isFilled = true
    } = _ref,
        props = _objectWithoutProperties$M(_ref, ["children", "className", "component", "isFilled"]);

    const Component = component;
    return React.createElement(Component, _extends$M({
      className: css$1(styles$d.cardBody, !isFilled && styles$d.modifiers.noFill, className)
    }, props), children);
  };
  CardBody.propTypes = {
    children: _pt.node,
    className: _pt.string,
    component: _pt.any,
    isFilled: _pt.bool
  };

  function _extends$N() { _extends$N = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$N.apply(this, arguments); }

  function _objectWithoutProperties$N(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$N(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$N(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const CardFooter = (_ref) => {
    let {
      children = null,
      className = '',
      component = 'div'
    } = _ref,
        props = _objectWithoutProperties$N(_ref, ["children", "className", "component"]);

    const Component = component;
    return React.createElement(Component, _extends$N({
      className: css$1(styles$d.cardFooter, className)
    }, props), children);
  };
  CardFooter.propTypes = {
    children: _pt.node,
    className: _pt.string,
    component: _pt.any
  };

  function _extends$O() { _extends$O = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$O.apply(this, arguments); }

  function _objectWithoutProperties$O(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$O(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$O(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const CardHeader = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$O(_ref, ["children", "className"]);

    return React.createElement("div", _extends$O({
      className: css$1(styles$d.cardHeader, titleStyles.title, titleStyles.modifiers.md, className)
    }, props), children);
  };
  CardHeader.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$P() { _extends$P = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$P.apply(this, arguments); }

  function _objectWithoutProperties$P(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$P(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$P(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const CardHead = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$P(_ref, ["children", "className"]);

    return React.createElement("div", _extends$P({
      className: css$1(styles$d.cardHead, className)
    }, props), children);
  };
  CardHead.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$Q() { _extends$Q = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$Q.apply(this, arguments); }

  function _objectWithoutProperties$Q(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$Q(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$Q(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const CardHeadMain = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$Q(_ref, ["children", "className"]);

    return React.createElement("div", _extends$Q({
      className: css$1('pf-c-card__head-main', className)
    }, props), children);
  };
  CardHeadMain.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  var check = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      check: 'pf-c-check',
      checkLabel: 'pf-c-check__label',
      checkInput: 'pf-c-check__input',
      checkDescription: 'pf-c-check__description',
      modifiers: {
          'disabled': 'pf-m-disabled'
      }
  };
  });

  var checkStyles = unwrapExports(check);

  function _extends$R() { _extends$R = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$R.apply(this, arguments); }

  function _objectWithoutProperties$R(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$R(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$R(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$g(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  // tslint:disable-next-line:no-empty
  const defaultOnChange = () => {};

  class Checkbox extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$g(this, "handleChange", event => {
        this.props.onChange(event.currentTarget.checked, event);
      });
    }

    render() {
      const _this$props = this.props,
            {
        'aria-label': ariaLabel,
        className,
        onChange,
        isValid,
        isDisabled,
        isChecked,
        label,
        checked,
        defaultChecked,
        description
      } = _this$props,
            props = _objectWithoutProperties$R(_this$props, ["aria-label", "className", "onChange", "isValid", "isDisabled", "isChecked", "label", "checked", "defaultChecked", "description"]);

      const checkedProps = {};

      if ([true, false].includes(checked) || isChecked === true) {
        checkedProps.checked = checked || isChecked;
      }

      if (onChange !== defaultOnChange) {
        checkedProps.checked = isChecked;
      }

      if ([false, true].includes(defaultChecked)) {
        checkedProps.defaultChecked = defaultChecked;
      }

      checkedProps.checked = checkedProps.checked === null ? false : checkedProps.checked;
      return React.createElement("div", {
        className: css$1(checkStyles.check, className)
      }, React.createElement("input", _extends$R({}, props, {
        className: css$1(checkStyles.checkInput),
        type: "checkbox",
        onChange: this.handleChange,
        "aria-invalid": !isValid,
        "aria-label": ariaLabel,
        disabled: isDisabled,
        ref: elem => elem && (elem.indeterminate = isChecked === null)
      }, checkedProps)), label && React.createElement("label", {
        className: css$1(checkStyles.checkLabel, isDisabled ? getModifier(checkStyles, 'disabled') : ''),
        htmlFor: props.id
      }, label), description && React.createElement("div", {
        className: css$1(checkStyles.checkDescription)
      }, description));
    }

  }

  _defineProperty$g(Checkbox, "propTypes", {
    className: _pt.string,
    isValid: _pt.bool,
    isDisabled: _pt.bool,
    isChecked: _pt.bool,
    checked: _pt.bool,
    onChange: _pt.func,
    label: _pt.node,
    id: _pt.string.isRequired,
    'aria-label': _pt.string,
    description: _pt.node
  });

  _defineProperty$g(Checkbox, "defaultProps", {
    className: '',
    isValid: true,
    isDisabled: false,
    isChecked: false,
    onChange: defaultOnChange
  });

  var chipGroup = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      chipGroup: 'pf-c-chip-group',
      chip: 'pf-c-chip',
      chipGroupLabel: 'pf-c-chip-group__label',
      modifiers: {
          'toolbar': 'pf-m-toolbar',
          'overflow': 'pf-m-overflow'
      }
  };
  });

  var styles$e = unwrapExports(chipGroup);

  function _extends$S() { _extends$S = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$S.apply(this, arguments); }

  function _objectWithoutProperties$S(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$S(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$S(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ChipButton = (_ref) => {
    let {
      ariaLabel = 'close',
      children = null,
      className = '',
      onClick = () => undefined
    } = _ref,
        props = _objectWithoutProperties$S(_ref, ["ariaLabel", "children", "className", "onClick"]);

    return React.createElement(ButtonWithOuiaContext, _extends$S({
      variant: "plain",
      "aria-label": ariaLabel,
      onClick: onClick,
      className: className
    }, props), children);
  };
  ChipButton.propTypes = {
    ariaLabel: _pt.string,
    children: _pt.node,
    className: _pt.string,
    onClick: _pt.func
  };

  var timesCircleIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.TimesCircleIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var TimesCircleIconConfig = {
    name: 'TimesCircleIcon',
    height: 512,
    width: 512,
    svgPath: 'M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.TimesCircleIconConfig = TimesCircleIconConfig;

  var _default = (0, _createIcon["default"])(TimesCircleIconConfig);

  exports["default"] = _default;

  });

  var TimesCircleIcon = unwrapExports(timesCircleIcon);
  var timesCircleIcon_1 = timesCircleIcon.TimesCircleIconConfig;

  var chip = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      chip: 'pf-c-chip',
      button: 'pf-c-button',
      badge: 'pf-c-badge',
      chipText: 'pf-c-chip__text',
      modifiers: {
          'overflow': 'pf-m-overflow',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus',
          'readOnly': 'pf-m-read-only'
      }
  };
  });

  var styles$f = unwrapExports(chip);

  function _extends$T() { _extends$T = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$T.apply(this, arguments); }

  function _defineProperty$h(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  class Chip extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$h(this, "span", React.createRef());

      _defineProperty$h(this, "renderOverflowChip", () => {
        const {
          children,
          className,
          onClick,
          ouiaContext,
          ouiaId
        } = this.props;
        const Component = this.props.component;
        return React.createElement(Component, _extends$T({
          className: css$1(styles$f.chip, styles$f.modifiers.overflow, className)
        }, ouiaContext.isOuia && {
          'data-ouia-component-type': 'OverflowChip',
          'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
        }), React.createElement(ChipButton, {
          onClick: onClick
        }, React.createElement("span", {
          className: css$1(styles$f.chipText)
        }, children)));
      });

      _defineProperty$h(this, "renderChip", randomId => {
        const {
          children,
          closeBtnAriaLabel,
          tooltipPosition,
          className,
          onClick,
          isReadOnly,
          ouiaContext,
          ouiaId
        } = this.props;
        const Component = this.props.component;

        if (this.state.isTooltipVisible) {
          return React.createElement(Tooltip, {
            position: tooltipPosition,
            content: children
          }, React.createElement(Component, _extends$T({
            className: css$1(styles$f.chip, isReadOnly && styles$f.modifiers.readOnly, className),
            tabIndex: "0"
          }, ouiaContext.isOuia && {
            'data-ouia-component-type': 'Chip',
            'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
          }), React.createElement("span", {
            ref: this.span,
            className: css$1(styles$f.chipText),
            id: randomId
          }, children), !isReadOnly && React.createElement(ChipButton, {
            onClick: onClick,
            ariaLabel: closeBtnAriaLabel,
            id: `remove_${randomId}`,
            "aria-labelledby": `remove_${randomId} ${randomId}`
          }, React.createElement(TimesCircleIcon, {
            "aria-hidden": "true"
          }))));
        }

        return React.createElement(Component, _extends$T({
          className: css$1(styles$f.chip, isReadOnly && styles$f.modifiers.readOnly, className)
        }, ouiaContext.isOuia && {
          'data-ouia-component-type': 'Chip',
          'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
        }), React.createElement("span", {
          ref: this.span,
          className: css$1(styles$f.chipText),
          id: randomId
        }, children), !isReadOnly && React.createElement(ChipButton, {
          onClick: onClick,
          ariaLabel: closeBtnAriaLabel,
          id: `remove_${randomId}`,
          "aria-labelledby": `remove_${randomId} ${randomId}`
        }, React.createElement(TimesCircleIcon, {
          "aria-hidden": "true"
        })));
      });

      this.state = {
        isTooltipVisible: false
      };
    }

    componentDidMount() {
      this.setState({
        isTooltipVisible: Boolean(this.span.current && this.span.current.offsetWidth < this.span.current.scrollWidth)
      });
    }

    render() {
      const {
        isOverflowChip
      } = this.props;
      return React.createElement(GenerateId, null, randomId => isOverflowChip ? this.renderOverflowChip() : this.renderChip(randomId));
    }

  }

  _defineProperty$h(Chip, "propTypes", {
    children: _pt.node,
    closeBtnAriaLabel: _pt.string,
    className: _pt.string,
    isOverflowChip: _pt.bool,
    isReadOnly: _pt.bool,
    onClick: _pt.func,
    component: _pt.node,
    tooltipPosition: _pt.oneOf(['auto', 'top', 'bottom', 'left', 'right'])
  });

  _defineProperty$h(Chip, "defaultProps", {
    closeBtnAriaLabel: 'close',
    className: '',
    isOverflowChip: false,
    isReadOnly: false,
    tooltipPosition: 'top',
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: _e => undefined,
    component: 'div'
  });

  const ChipWithOuiaContext = withOuiaContext(Chip);

  function _extends$U() { _extends$U = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$U.apply(this, arguments); }

  function _defineProperty$i(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  const ChipGroupContext = React.createContext('');
  class ChipGroup extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$i(this, "toggleCollapse", () => {
        this.setState(prevState => ({
          isOpen: !prevState.isOpen
        }));
      });

      this.state = {
        isOpen: this.props.defaultIsOpen
      };
    }

    renderToolbarGroup() {
      const {
        isOpen
      } = this.state;
      const {
        headingLevel = 'h4'
      } = this.props;
      return React.createElement(ChipGroupContext.Provider, {
        value: headingLevel
      }, React.createElement(InnerChipGroup, _extends$U({}, this.props, {
        isOpen: isOpen,
        onToggleCollapse: this.toggleCollapse
      })));
    }

    renderChipGroup() {
      const {
        className
      } = this.props;
      const {
        isOpen
      } = this.state;
      return React.createElement("ul", {
        className: css$1(styles$e.chipGroup, className)
      }, React.createElement(InnerChipGroup, _extends$U({}, this.props, {
        isOpen: isOpen,
        onToggleCollapse: this.toggleCollapse
      })));
    }

    render() {
      const {
        withToolbar,
        children
      } = this.props;

      if (React.Children.count(children)) {
        return withToolbar ? this.renderToolbarGroup() : this.renderChipGroup();
      }

      return null;
    }

  }

  _defineProperty$i(ChipGroup, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    defaultIsOpen: _pt.bool,
    expandedText: _pt.string,
    collapsedText: _pt.string,
    withToolbar: _pt.bool,
    headingLevel: _pt.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6']),
    numChips: _pt.number
  });

  _defineProperty$i(ChipGroup, "defaultProps", {
    className: '',
    expandedText: 'Show Less',
    collapsedText: '${remaining} more',
    withToolbar: false,
    defaultIsOpen: false,
    numChips: 3
  });

  const InnerChipGroup = props => {
    const {
      children,
      expandedText,
      isOpen,
      onToggleCollapse,
      collapsedText,
      withToolbar,
      numChips
    } = props;
    const collapsedTextResult = fillTemplate(collapsedText, {
      remaining: React.Children.count(children) - numChips
    });
    const mappedChildren = React.Children.map(children, c => {
      const child = c;

      if (withToolbar) {
        return React.cloneElement(child, {
          children: React.Children.toArray(child.props.children).map(chip => React.cloneElement(chip, {
            component: 'li'
          }))
        });
      }

      return React.cloneElement(child, {
        component: 'li'
      });
    });
    return React.createElement(React.Fragment, null, isOpen ? React.createElement(React.Fragment, null, mappedChildren) : React.createElement(React.Fragment, null, mappedChildren.map((child, i) => {
      if (i < numChips) {
        return child;
      }
    })), React.Children.count(children) > numChips && React.createElement(ChipWithOuiaContext, {
      isOverflowChip: true,
      onClick: onToggleCollapse,
      component: withToolbar ? 'div' : 'li'
    }, isOpen ? expandedText : collapsedTextResult));
  };

  InnerChipGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    defaultIsOpen: _pt.bool,
    expandedText: _pt.string,
    collapsedText: _pt.string,
    withToolbar: _pt.bool,
    headingLevel: _pt.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6']),
    numChips: _pt.number,
    isOpen: _pt.bool.isRequired,
    onToggleCollapse: _pt.func.isRequired
  };

  function _extends$V() { _extends$V = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$V.apply(this, arguments); }

  function _objectWithoutProperties$T(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$T(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$T(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$j(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class ChipGroupToolbarItem extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$j(this, "heading", React.createRef());

      this.state = {
        isTooltipVisible: false
      };
    }

    componentDidMount() {
      this.setState({
        isTooltipVisible: Boolean(this.heading.current && this.heading.current.offsetWidth < this.heading.current.scrollWidth)
      });
    }

    render() {
      const _this$props = this.props,
            {
        categoryName,
        children,
        className,
        isClosable,
        closeBtnAriaLabel,
        onClick,
        tooltipPosition
      } = _this$props,
            rest = _objectWithoutProperties$T(_this$props, ["categoryName", "children", "className", "isClosable", "closeBtnAriaLabel", "onClick", "tooltipPosition"]);

      if (React.Children.count(children)) {
        const renderChipGroup = (id, HeadingLevel) => React.createElement("ul", _extends$V({
          className: css$1(styles$e.chipGroup, styles$e.modifiers.toolbar, className)
        }, rest), React.createElement("li", null, this.state.isTooltipVisible ? React.createElement(Tooltip, {
          position: tooltipPosition,
          content: categoryName
        }, React.createElement(HeadingLevel, {
          tabIndex: "0",
          ref: this.heading,
          className: css$1(styles$e.chipGroupLabel),
          id: id
        }, categoryName)) : React.createElement(HeadingLevel, {
          ref: this.heading,
          className: css$1(styles$e.chipGroupLabel),
          id: id
        }, categoryName), React.createElement("ul", {
          className: css$1(styles$e.chipGroup)
        }, children), isClosable && React.createElement("div", {
          className: "pf-c-chip-group__close"
        }, React.createElement(ChipButton, {
          "aria-label": closeBtnAriaLabel,
          onClick: onClick,
          id: `remove_group_${id}`,
          "aria-labelledby": `remove_group_${id} ${id}`
        }, React.createElement(TimesIcon, {
          "aria-hidden": "true"
        })))));

        return React.createElement(ChipGroupContext.Consumer, null, HeadingLevel => React.createElement(GenerateId, null, randomId => renderChipGroup(randomId, HeadingLevel)));
      }

      return null;
    }

  }

  _defineProperty$j(ChipGroupToolbarItem, "propTypes", {
    categoryName: _pt.string,
    children: _pt.node,
    className: _pt.string,
    isClosable: _pt.bool,
    onClick: _pt.func,
    closeBtnAriaLabel: _pt.string,
    tooltipPosition: _pt.oneOf(['auto', 'top', 'bottom', 'left', 'right'])
  });

  _defineProperty$j(ChipGroupToolbarItem, "defaultProps", {
    categoryName: '',
    children: null,
    className: '',
    isClosable: false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: _e => undefined,
    closeBtnAriaLabel: 'Close chip group',
    tooltipPosition: 'top'
  });

  var clipboardCopy = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      clipboardCopy: 'pf-c-clipboard-copy',
      clipboardCopyGroupToggle: 'pf-c-clipboard-copy__group-toggle',
      clipboardCopyGroupToggleIcon: 'pf-c-clipboard-copy__group-toggle-icon',
      clipboardCopyGroup: 'pf-c-clipboard-copy__group',
      clipboardCopyGroupCopy: 'pf-c-clipboard-copy__group-copy',
      clipboardCopyExpandableContent: 'pf-c-clipboard-copy__expandable-content',
      modifiers: {
          'expanded': 'pf-m-expanded',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus'
      }
  };
  });

  var styles$g = unwrapExports(clipboardCopy);

  function _extends$W() { _extends$W = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$W.apply(this, arguments); }

  function _objectWithoutProperties$U(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$U(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$U(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$k(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (TextInputTypes) {
    TextInputTypes["text"] = "text";
    TextInputTypes["date"] = "date";
    TextInputTypes["datetimeLocal"] = "datetime-local";
    TextInputTypes["email"] = "email";
    TextInputTypes["month"] = "month";
    TextInputTypes["number"] = "number";
    TextInputTypes["password"] = "password";
    TextInputTypes["search"] = "search";
    TextInputTypes["tel"] = "tel";
    TextInputTypes["time"] = "time";
    TextInputTypes["url"] = "url";
  })(exports.TextInputTypes || (exports.TextInputTypes = {}));

  class TextInputBase extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$k(this, "handleChange", event => {
        if (this.props.onChange) {
          this.props.onChange(event.currentTarget.value, event);
        }
      });

      if (!props.id && !props['aria-label'] && !props['aria-labelledby']) {
        // eslint-disable-next-line no-console
        console.error('Text input:', 'Text input requires either an id or aria-label to be specified');
      }
    }

    render() {
      const _this$props = this.props,
            {
        innerRef,
        className,
        type,
        value,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onChange,
        isValid,
        validated,
        isReadOnly,
        isRequired,
        isDisabled
      } = _this$props,
            props = _objectWithoutProperties$U(_this$props, ["innerRef", "className", "type", "value", "onChange", "isValid", "validated", "isReadOnly", "isRequired", "isDisabled"]);

      return React.createElement("input", _extends$W({}, props, {
        className: css$1(formStyles.formControl, validated === exports.ValidatedOptions.success && formStyles.modifiers.success, className),
        onChange: this.handleChange,
        type: type,
        value: value,
        "aria-invalid": !isValid || validated === exports.ValidatedOptions.error,
        required: isRequired,
        disabled: isDisabled,
        readOnly: isReadOnly,
        ref: innerRef
      }));
    }

  }

  _defineProperty$k(TextInputBase, "propTypes", {
    className: _pt.string,
    isDisabled: _pt.bool,
    isReadOnly: _pt.bool,
    isRequired: _pt.bool,
    isValid: _pt.bool,
    validated: _pt.oneOf(['success', 'error', 'default']),
    onChange: _pt.func,
    type: _pt.oneOf(['text', 'date', 'datetime-local', 'email', 'month', 'number', 'password', 'search', 'tel', 'time', 'url']),
    value: _pt.oneOfType([_pt.string, _pt.number]),
    'aria-label': _pt.string,
    innerRef: _pt.oneOfType([_pt.string, _pt.func, _pt.object])
  });

  _defineProperty$k(TextInputBase, "defaultProps", {
    'aria-label': null,
    className: '',
    isRequired: false,
    isValid: true,
    validated: 'default',
    isDisabled: false,
    isReadOnly: false,
    type: exports.TextInputTypes.text,
    onChange: () => undefined
  });

  const TextInput = React.forwardRef((props, ref) => React.createElement(TextInputBase, _extends$W({}, props, {
    innerRef: ref
  })));

  var copyIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.CopyIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var CopyIconConfig = {
    name: 'CopyIcon',
    height: 512,
    width: 448,
    svgPath: 'M320 448v40c0 13.255-10.745 24-24 24H24c-13.255 0-24-10.745-24-24V120c0-13.255 10.745-24 24-24h72v296c0 30.879 25.121 56 56 56h168zm0-344V0H152c-13.255 0-24 10.745-24 24v368c0 13.255 10.745 24 24 24h272c13.255 0 24-10.745 24-24V128H344c-13.2 0-24-10.8-24-24zm120.971-31.029L375.029 7.029A24 24 0 0 0 358.059 0H352v96h96v-6.059a24 24 0 0 0-7.029-16.97z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.CopyIconConfig = CopyIconConfig;

  var _default = (0, _createIcon["default"])(CopyIconConfig);

  exports["default"] = _default;

  });

  var CopyIcon = unwrapExports(copyIcon);
  var copyIcon_1 = copyIcon.CopyIconConfig;

  function _extends$X() { _extends$X = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$X.apply(this, arguments); }

  function _objectWithoutProperties$V(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$V(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$V(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ClipboardCopyButton = (_ref) => {
    let {
      onClick,
      className = '',
      exitDelay = 100,
      entryDelay = 100,
      maxWidth = '100px',
      position = 'top',
      'aria-label': ariaLabel = 'Copyable input',
      id,
      textId,
      children
    } = _ref,
        props = _objectWithoutProperties$V(_ref, ["onClick", "className", "exitDelay", "entryDelay", "maxWidth", "position", "aria-label", "id", "textId", "children"]);

    return React.createElement(Tooltip, {
      trigger: "mouseenter focus click",
      exitDelay: exitDelay,
      entryDelay: entryDelay,
      maxWidth: maxWidth,
      position: position,
      content: React.createElement("div", null, children)
    }, React.createElement("button", _extends$X({
      type: "button",
      onClick: onClick,
      className: css$1(styles$g.clipboardCopyGroupCopy, className),
      "aria-label": ariaLabel,
      id: id,
      "aria-labelledby": `${id} ${textId}`
    }, props), React.createElement(CopyIcon, null)));
  };
  ClipboardCopyButton.propTypes = {
    onClick: _pt.func.isRequired,
    children: _pt.node.isRequired,
    id: _pt.string.isRequired,
    textId: _pt.string.isRequired,
    className: _pt.string,
    exitDelay: _pt.number,
    entryDelay: _pt.number,
    maxWidth: _pt.string,
    position: _pt.oneOf(['auto', 'top', 'bottom', 'left', 'right']),
    'aria-label': _pt.string
  };

  function _extends$Y() { _extends$Y = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$Y.apply(this, arguments); }

  function _objectWithoutProperties$W(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$W(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$W(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ClipboardCopyToggle = (_ref) => {
    let {
      onClick,
      className = '',
      id,
      textId,
      contentId,
      isExpanded = false
    } = _ref,
        props = _objectWithoutProperties$W(_ref, ["onClick", "className", "id", "textId", "contentId", "isExpanded"]);

    return React.createElement("button", _extends$Y({
      type: "button",
      onClick: onClick,
      className: css$1(styles$g.clipboardCopyGroupToggle, className),
      id: id,
      "aria-labelledby": `${id} ${textId}`,
      "aria-controls": `${id} ${contentId}`,
      "aria-expanded": isExpanded
    }, props), React.createElement(AngleRightIcon, {
      "aria-hidden": "true",
      className: css$1(styles$g.clipboardCopyGroupToggleIcon)
    }));
  };
  ClipboardCopyToggle.propTypes = {
    onClick: _pt.func.isRequired,
    id: _pt.string.isRequired,
    textId: _pt.string.isRequired,
    contentId: _pt.string.isRequired,
    isExpanded: _pt.bool,
    className: _pt.string
  };

  function _extends$Z() { _extends$Z = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$Z.apply(this, arguments); }

  function _objectWithoutProperties$X(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$X(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$X(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$l(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class ClipboardCopyExpanded extends React.Component {
    constructor(props) {
      super(props);
    }

    render() {
      const _this$props = this.props,
            {
        className,
        children,
        onChange,
        isReadOnly,
        isCode
      } = _this$props,
            props = _objectWithoutProperties$X(_this$props, ["className", "children", "onChange", "isReadOnly", "isCode"]);

      return React.createElement("div", _extends$Z({
        suppressContentEditableWarning: true,
        className: css$1(styles$g.clipboardCopyExpandableContent, className),
        onInput: e => onChange(e.target.innerText, e),
        contentEditable: !isReadOnly
      }, props), isCode ? React.createElement("pre", null, children) : children);
    }

  }

  _defineProperty$l(ClipboardCopyExpanded, "propTypes", {
    className: _pt.string,
    children: _pt.node.isRequired,
    onChange: _pt.func,
    isReadOnly: _pt.bool,
    isCode: _pt.bool
  });

  _defineProperty$l(ClipboardCopyExpanded, "defaultProps", {
    onChange: () => undefined,
    className: '',
    isReadOnly: false,
    isCode: false
  });

  function _extends$_() { _extends$_ = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$_.apply(this, arguments); }

  function _objectWithoutProperties$Y(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$Y(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$Y(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$m(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  const clipboardCopyFunc = (event, text) => {
    const clipboard = event.currentTarget.parentElement;
    const el = document.createElement('input');
    el.value = text.toString();
    clipboard.appendChild(el);
    el.select();
    document.execCommand('copy');
    clipboard.removeChild(el);
  };

  (function (ClipboardCopyVariant) {
    ClipboardCopyVariant["inline"] = "inline";
    ClipboardCopyVariant["expansion"] = "expansion";
  })(exports.ClipboardCopyVariant || (exports.ClipboardCopyVariant = {}));

  class ClipboardCopy extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$m(this, "timer", null);

      _defineProperty$m(this, "componentDidUpdate", (prevProps, prevState) => {
        if (prevProps.children !== this.props.children) {
          this.updateText(this.props.children);
        }
      });

      _defineProperty$m(this, "expandContent", _event => {
        this.setState(prevState => ({
          expanded: !prevState.expanded
        }));
      });

      _defineProperty$m(this, "updateText", text => {
        this.setState({
          text
        });
        this.props.onChange(text);
      });

      _defineProperty$m(this, "render", () => {
        const _this$props = this.props,
              {
          /* eslint-disable @typescript-eslint/no-unused-vars */
          isExpanded,
          onChange,
          // Don't pass to <div>

          /* eslint-enable @typescript-eslint/no-unused-vars */
          isReadOnly,
          isCode,
          exitDelay,
          maxWidth,
          entryDelay,
          switchDelay,
          onCopy,
          hoverTip,
          clickTip,
          textAriaLabel,
          toggleAriaLabel,
          variant,
          position,
          className
        } = _this$props,
              divProps = _objectWithoutProperties$Y(_this$props, ["isExpanded", "onChange", "isReadOnly", "isCode", "exitDelay", "maxWidth", "entryDelay", "switchDelay", "onCopy", "hoverTip", "clickTip", "textAriaLabel", "toggleAriaLabel", "variant", "position", "className"]);

        const textIdPrefix = 'text-input-';
        const toggleIdPrefix = 'toggle-';
        const contentIdPrefix = 'content-';
        return React.createElement("div", _extends$_({
          className: css$1(styles$g.clipboardCopy, this.state.expanded && styles$g.modifiers.expanded, className)
        }, divProps), React.createElement(GenerateId, {
          prefix: ""
        }, id => React.createElement(React.Fragment, null, React.createElement("div", {
          className: css$1(styles$g.clipboardCopyGroup)
        }, variant === 'expansion' && React.createElement(ClipboardCopyToggle, {
          isExpanded: this.state.expanded,
          onClick: this.expandContent,
          id: `${toggleIdPrefix}-${id}`,
          textId: `${textIdPrefix}-${id}`,
          contentId: `${contentIdPrefix}-${id}`,
          "aria-label": toggleAriaLabel
        }), React.createElement(TextInput, {
          isReadOnly: isReadOnly || this.state.expanded,
          onChange: this.updateText,
          value: this.state.text,
          id: `text-input-${id}`,
          "aria-label": textAriaLabel
        }), React.createElement(ClipboardCopyButton, {
          exitDelay: exitDelay,
          entryDelay: entryDelay,
          maxWidth: maxWidth,
          position: position,
          id: `copy-button-${id}`,
          textId: `text-input-${id}`,
          "aria-label": hoverTip,
          onClick: event => {
            if (this.timer) {
              window.clearTimeout(this.timer);
              this.setState({
                copied: false
              });
            }

            onCopy(event, this.state.text);
            this.setState({
              copied: true
            }, () => {
              this.timer = window.setTimeout(() => {
                this.setState({
                  copied: false
                });
                this.timer = null;
              }, switchDelay);
            });
          }
        }, this.state.copied ? clickTip : hoverTip)), this.state.expanded && React.createElement(ClipboardCopyExpanded, {
          isReadOnly: isReadOnly,
          isCode: isCode,
          id: `content-${id}`,
          onChange: this.updateText
        }, this.state.text))));
      });

      this.state = {
        text: this.props.children,
        expanded: this.props.isExpanded,
        copied: false
      };
    }

  }

  _defineProperty$m(ClipboardCopy, "propTypes", {
    className: _pt.string,
    hoverTip: _pt.string,
    clickTip: _pt.string,
    textAriaLabel: _pt.string,
    toggleAriaLabel: _pt.string,
    isReadOnly: _pt.bool,
    isExpanded: _pt.bool,
    isCode: _pt.bool,
    variant: _pt.oneOfType([_pt.any, _pt.oneOf(['inline']), _pt.oneOf(['expansion'])]),
    position: _pt.oneOfType([_pt.any, _pt.oneOf(['auto']), _pt.oneOf(['top']), _pt.oneOf(['bottom']), _pt.oneOf(['left']), _pt.oneOf(['right'])]),
    maxWidth: _pt.string,
    exitDelay: _pt.number,
    entryDelay: _pt.number,
    switchDelay: _pt.number,
    onCopy: _pt.func,
    onChange: _pt.func,
    children: _pt.node.isRequired
  });

  _defineProperty$m(ClipboardCopy, "defaultProps", {
    hoverTip: 'Copy to clipboard',
    clickTip: 'Successfully copied to clipboard!',
    isReadOnly: false,
    isExpanded: false,
    isCode: false,
    variant: 'inline',
    position: exports.TooltipPosition.top,
    maxWidth: '150px',
    exitDelay: 1600,
    entryDelay: 100,
    switchDelay: 2000,
    onCopy: clipboardCopyFunc,
    onChange: () => undefined,
    textAriaLabel: 'Copyable input',
    toggleAriaLabel: 'Show content'
  });

  var contextSelector = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      contextSelectorMenu: 'pf-c-context-selector__menu',
      contextSelector: 'pf-c-context-selector',
      contextSelectorToggle: 'pf-c-context-selector__toggle',
      contextSelectorToggleIcon: 'pf-c-context-selector__toggle-icon',
      contextSelectorToggleText: 'pf-c-context-selector__toggle-text',
      contextSelectorMenuInput: 'pf-c-context-selector__menu-input',
      contextSelectorMenuList: 'pf-c-context-selector__menu-list',
      contextSelectorMenuListItem: 'pf-c-context-selector__menu-list-item',
      modifiers: {
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'expanded': 'pf-m-expanded',
          'focus': 'pf-m-focus',
          'disabled': 'pf-m-disabled'
      }
  };
  });

  var styles$h = unwrapExports(contextSelector);

  var searchIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SearchIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var SearchIconConfig = {
    name: 'SearchIcon',
    height: 512,
    width: 512,
    svgPath: 'M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.SearchIconConfig = SearchIconConfig;

  var _default = (0, _createIcon["default"])(SearchIconConfig);

  exports["default"] = _default;

  });

  var SearchIcon = unwrapExports(searchIcon);
  var searchIcon_1 = searchIcon.SearchIconConfig;

  function _extends$$() { _extends$$ = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$$.apply(this, arguments); }

  function _objectWithoutProperties$Z(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$Z(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$Z(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$n(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class ContextSelectorToggle extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$n(this, "toggle", React.createRef());

      _defineProperty$n(this, "componentDidMount", () => {
        document.addEventListener('mousedown', this.onDocClick);
        document.addEventListener('touchstart', this.onDocClick);
        document.addEventListener('keydown', this.onEscPress);
      });

      _defineProperty$n(this, "componentWillUnmount", () => {
        document.removeEventListener('mousedown', this.onDocClick);
        document.removeEventListener('touchstart', this.onDocClick);
        document.removeEventListener('keydown', this.onEscPress);
      });

      _defineProperty$n(this, "onDocClick", event => {
        const {
          isOpen,
          parentRef,
          onToggle
        } = this.props;

        if (isOpen && parentRef && !parentRef.contains(event.target)) {
          onToggle(null, false);
          this.toggle.current.focus();
        }
      });

      _defineProperty$n(this, "onEscPress", event => {
        const {
          isOpen,
          parentRef,
          onToggle
        } = this.props;
        const keyCode = event.keyCode || event.which;

        if (isOpen && keyCode === KEY_CODES.ESCAPE_KEY && parentRef && parentRef.contains(event.target)) {
          onToggle(null, false);
          this.toggle.current.focus();
        }
      });

      _defineProperty$n(this, "onKeyDown", event => {
        const {
          isOpen,
          onToggle,
          onEnter
        } = this.props;

        if (event.keyCode === KEY_CODES.TAB && !isOpen || event.key !== KEY_CODES.ENTER) {
          return;
        }

        event.preventDefault();

        if ((event.keyCode === KEY_CODES.TAB || event.keyCode === KEY_CODES.ENTER || event.key !== KEY_CODES.SPACE) && isOpen) {
          onToggle(null, !isOpen);
        } else if ((event.keyCode === KEY_CODES.ENTER || event.key === ' ') && !isOpen) {
          onToggle(null, !isOpen);
          onEnter();
        }
      });
    }

    render() {
      const _this$props = this.props,
            {
        className,
        toggleText,
        isOpen,
        isFocused,
        isActive,
        isHovered,
        onToggle,
        id,

        /* eslint-disable @typescript-eslint/no-unused-vars */
        onEnter,
        parentRef
      } = _this$props,
            props = _objectWithoutProperties$Z(_this$props, ["className", "toggleText", "isOpen", "isFocused", "isActive", "isHovered", "onToggle", "id", "onEnter", "parentRef"]);

      return React.createElement("button", _extends$$({}, props, {
        id: id,
        ref: this.toggle,
        className: css$1(styles$h.contextSelectorToggle, isFocused && styles$h.modifiers.focus, isHovered && styles$h.modifiers.hover, isActive && styles$h.modifiers.active, className),
        type: "button",
        onClick: event => onToggle(event, !isOpen),
        "aria-expanded": isOpen,
        onKeyDown: this.onKeyDown
      }), React.createElement("span", {
        className: css$1(styles$h.contextSelectorToggleText)
      }, toggleText), React.createElement(CaretDownIcon, {
        className: css$1(styles$h.contextSelectorToggleIcon),
        "aria-hidden": true
      }));
    }

  }

  _defineProperty$n(ContextSelectorToggle, "propTypes", {
    id: _pt.string.isRequired,
    className: _pt.string,
    toggleText: _pt.string,
    isOpen: _pt.bool,
    onToggle: _pt.func,
    onEnter: _pt.func,
    parentRef: _pt.any,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isActive: _pt.bool
  });

  _defineProperty$n(ContextSelectorToggle, "defaultProps", {
    className: '',
    toggleText: '',
    isOpen: false,
    onEnter: () => undefined,
    parentRef: null,
    isFocused: false,
    isHovered: false,
    isActive: false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToggle: (event, value) => undefined
  });

  function _extends$10() { _extends$10 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$10.apply(this, arguments); }

  function _objectWithoutProperties$_(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$_(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$_(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$o(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class ContextSelectorMenuList extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$o(this, "refsCollection", []);

      _defineProperty$o(this, "sendRef", (index, ref) => {
        this.refsCollection[index] = ref;
      });

      _defineProperty$o(this, "render", () => {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _this$props = this.props,
              {
          className,
          isOpen,
          children
        } = _this$props,
              props = _objectWithoutProperties$_(_this$props, ["className", "isOpen", "children"]);

        return React.createElement("ul", _extends$10({
          className: css$1(styles$h.contextSelectorMenuList, className),
          hidden: !isOpen,
          role: "menu"
        }, props), this.extendChildren());
      });
    }

    extendChildren() {
      return React.Children.map(this.props.children, (child, index) => React.cloneElement(child, {
        sendRef: this.sendRef,
        index
      }));
    }

  }

  _defineProperty$o(ContextSelectorMenuList, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    isOpen: _pt.bool
  });

  _defineProperty$o(ContextSelectorMenuList, "defaultProps", {
    children: null,
    className: '',
    isOpen: true
  });

  const ContextSelectorContext = React.createContext({
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onSelect: (event, value) => undefined
  });

  var inputGroup = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      inputGroup: 'pf-c-input-group',
      formControl: 'pf-c-form-control',
      button: 'pf-c-button',
      dropdownToggle: 'pf-c-dropdown__toggle',
      inputGroupText: 'pf-c-input-group__text',
      modifiers: {
          'control': 'pf-m-control'
      }
  };
  });

  var styles$i = unwrapExports(inputGroup);

  function _extends$11() { _extends$11 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$11.apply(this, arguments); }

  function _objectWithoutProperties$$(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$$(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$$(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$p(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class FormSelect extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$p(this, "handleChange", event => {
        this.props.onChange(event.currentTarget.value, event);
      });

      if (!props.id && !props['aria-label']) {
        // eslint-disable-next-line no-console
        console.error('FormSelect requires either an id or aria-label to be specified');
      }
    }

    render() {
      const _this$props = this.props,
            {
        children,
        className,
        value,
        isValid,
        validated,
        isDisabled,
        isRequired
      } = _this$props,
            props = _objectWithoutProperties$$(_this$props, ["children", "className", "value", "isValid", "validated", "isDisabled", "isRequired"]);

      return React.createElement("select", _extends$11({}, props, {
        className: css$1(formStyles.formControl, className, validated === exports.ValidatedOptions.success && formStyles.modifiers.success),
        "aria-invalid": !isValid || validated === exports.ValidatedOptions.error,
        onChange: this.handleChange,
        disabled: isDisabled,
        required: isRequired,
        value: value
      }), children);
    }

  }

  _defineProperty$p(FormSelect, "propTypes", {
    children: _pt.node.isRequired,
    className: _pt.string,
    value: _pt.any,
    isValid: _pt.bool,
    validated: _pt.oneOf(['success', 'error', 'default']),
    isDisabled: _pt.bool,
    isRequired: _pt.bool,
    onBlur: _pt.func,
    onFocus: _pt.func,
    onChange: _pt.func,
    'aria-label': _pt.string
  });

  _defineProperty$p(FormSelect, "defaultProps", {
    className: '',
    value: '',
    isValid: true,
    validated: 'default',
    isDisabled: false,
    isRequired: false,
    onBlur: () => undefined,
    onFocus: () => undefined,
    onChange: () => undefined
  });

  function _extends$12() { _extends$12 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$12.apply(this, arguments); }

  function _objectWithoutProperties$10(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$10(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$10(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const FormSelectOption = (_ref) => {
    let {
      className = '',
      value = '',
      isDisabled = false,
      label
    } = _ref,
        props = _objectWithoutProperties$10(_ref, ["className", "value", "isDisabled", "label"]);

    return React.createElement("option", _extends$12({}, props, {
      className: className,
      value: value,
      disabled: isDisabled
    }), label);
  };
  FormSelectOption.propTypes = {
    className: _pt.string,
    value: _pt.any,
    label: _pt.string.isRequired,
    isDisabled: _pt.bool
  };

  function _extends$13() { _extends$13 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$13.apply(this, arguments); }

  function _objectWithoutProperties$11(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$11(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$11(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const FormSelectOptionGroup = (_ref) => {
    let {
      children = null,
      className = '',
      isDisabled = false,
      label
    } = _ref,
        props = _objectWithoutProperties$11(_ref, ["children", "className", "isDisabled", "label"]);

    return React.createElement("optgroup", _extends$13({}, props, {
      disabled: !!isDisabled,
      className: className,
      label: label
    }), children);
  };
  FormSelectOptionGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    label: _pt.string.isRequired,
    isDisabled: _pt.bool
  };

  function _extends$14() { _extends$14 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$14.apply(this, arguments); }

  function _objectWithoutProperties$12(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$12(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$12(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$q(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (TextAreResizeOrientation) {
    TextAreResizeOrientation["horizontal"] = "horizontal";
    TextAreResizeOrientation["vertical"] = "vertical";
    TextAreResizeOrientation["both"] = "both";
  })(exports.TextAreResizeOrientation || (exports.TextAreResizeOrientation = {}));

  class TextArea extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$q(this, "handleChange", event => {
        if (this.props.onChange) {
          this.props.onChange(event.currentTarget.value, event);
        }
      });

      if (!props.id && !props['aria-label']) {
        // eslint-disable-next-line no-console
        console.error('TextArea: TextArea requires either an id or aria-label to be specified');
      }
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            {
        className,
        value,
        onChange,
        isValid,
        validated,
        isRequired,
        resizeOrientation
      } = _this$props,
            props = _objectWithoutProperties$12(_this$props, ["className", "value", "onChange", "isValid", "validated", "isRequired", "resizeOrientation"]);

      const orientation = 'resize' + resizeOrientation.charAt(0).toUpperCase() + resizeOrientation.slice(1);
      return React.createElement("textarea", _extends$14({
        className: css$1(formStyles.formControl, className, resizeOrientation !== exports.TextAreResizeOrientation.both && getModifier(formStyles, orientation), validated === exports.ValidatedOptions.success && formStyles.modifiers.success),
        onChange: this.handleChange
      }, typeof this.props.defaultValue !== 'string' && {
        value
      }, {
        "aria-invalid": !isValid || validated === exports.ValidatedOptions.error,
        required: isRequired
      }, props));
    }

  }

  _defineProperty$q(TextArea, "propTypes", {
    className: _pt.string,
    isRequired: _pt.bool,
    isValid: _pt.bool,
    validated: _pt.oneOf(['success', 'error', 'default']),
    value: _pt.oneOfType([_pt.string, _pt.number]),
    onChange: _pt.func,
    resizeOrientation: _pt.oneOf(['horizontal', 'vertical', 'both']),
    'aria-label': _pt.string
  });

  _defineProperty$q(TextArea, "defaultProps", {
    className: '',
    isRequired: false,
    isValid: true,
    validated: 'default',
    resizeOrientation: 'both',
    'aria-label': null
  });

  function _extends$15() { _extends$15 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$15.apply(this, arguments); }

  function _objectWithoutProperties$13(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$13(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$13(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const InputGroup = (_ref) => {
    let {
      className = '',
      children
    } = _ref,
        props = _objectWithoutProperties$13(_ref, ["className", "children"]);

    const formCtrls = [FormSelect, TextArea, TextInput].map(comp => comp.toString());
    const idItem = React.Children.toArray(children).find(child => !formCtrls.includes(child.type.toString()) && child.props.id);
    return React.createElement("div", _extends$15({
      className: css$1(styles$i.inputGroup, className)
    }, props), idItem ? React.Children.map(children, child => formCtrls.includes(child.type.toString()) ? React.cloneElement(child, {
      'aria-describedby': idItem.props.id
    }) : child) : children);
  };
  InputGroup.propTypes = {
    className: _pt.string,
    children: _pt.node.isRequired
  };

  function _extends$16() { _extends$16 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$16.apply(this, arguments); }

  function _objectWithoutProperties$14(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$14(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$14(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const InputGroupText = (_ref) => {
    let {
      className = '',
      component = 'span',
      children
    } = _ref,
        props = _objectWithoutProperties$14(_ref, ["className", "component", "children"]);

    const Component = component;
    return React.createElement(Component, _extends$16({
      className: css$1(styles$i.inputGroupText, className)
    }, props), children);
  };
  InputGroupText.propTypes = {
    className: _pt.string,
    children: _pt.node.isRequired,
    component: _pt.node
  };

  function _extends$17() { _extends$17 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$17.apply(this, arguments); }

  function _objectWithoutProperties$15(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$15(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$15(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$r(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  let currentId$1 = 0;
  const newId = currentId$1++;
  class ContextSelector extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$r(this, "parentRef", React.createRef());

      _defineProperty$r(this, "onEnterPressed", event => {
        if (event.charCode === KEY_CODES.ENTER) {
          this.props.onSearchButtonClick();
        }
      });
    }

    render() {
      const toggleId = `pf-context-selector-toggle-id-${newId}`;
      const screenReaderLabelId = `pf-context-selector-label-id-${newId}`;
      const searchButtonId = `pf-context-selector-search-button-id-${newId}`;

      const _this$props = this.props,
            {
        children,
        className,
        isOpen,
        onToggle,
        onSelect,
        screenReaderLabel,
        toggleText,
        searchButtonAriaLabel,
        searchInputValue,
        onSearchInputChange,
        searchInputPlaceholder,
        onSearchButtonClick
      } = _this$props,
            props = _objectWithoutProperties$15(_this$props, ["children", "className", "isOpen", "onToggle", "onSelect", "screenReaderLabel", "toggleText", "searchButtonAriaLabel", "searchInputValue", "onSearchInputChange", "searchInputPlaceholder", "onSearchButtonClick"]);

      return React.createElement("div", _extends$17({
        className: css$1(styles$h.contextSelector, isOpen && styles$h.modifiers.expanded, className),
        ref: this.parentRef
      }, props), screenReaderLabel && React.createElement("span", {
        id: screenReaderLabelId,
        hidden: true
      }, screenReaderLabel), React.createElement(ContextSelectorToggle, {
        onToggle: onToggle,
        isOpen: isOpen,
        toggleText: toggleText,
        id: toggleId,
        parentRef: this.parentRef.current,
        "aria-labelledby": `${screenReaderLabelId} ${toggleId}`
      }), isOpen && React.createElement("div", {
        className: css$1(styles$h.contextSelectorMenu)
      }, isOpen && React.createElement(FocusTrap, {
        focusTrapOptions: {
          clickOutsideDeactivates: true
        }
      }, React.createElement("div", {
        className: css$1(styles$h.contextSelectorMenuInput)
      }, React.createElement(InputGroup, null, React.createElement(TextInput, {
        value: searchInputValue,
        type: "search",
        placeholder: searchInputPlaceholder,
        onChange: onSearchInputChange,
        onKeyPress: this.onEnterPressed,
        "aria-labelledby": searchButtonId
      }), React.createElement(ButtonWithOuiaContext, {
        variant: exports.ButtonVariant.control,
        "aria-label": searchButtonAriaLabel,
        id: searchButtonId,
        onClick: onSearchButtonClick
      }, React.createElement(SearchIcon, {
        "aria-hidden": "true"
      })))), React.createElement(ContextSelectorContext.Provider, {
        value: {
          onSelect
        }
      }, React.createElement(ContextSelectorMenuList, {
        isOpen: isOpen
      }, children)))));
    }

  }

  _defineProperty$r(ContextSelector, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    isOpen: _pt.bool,
    onToggle: _pt.func,
    onSelect: _pt.func,
    screenReaderLabel: _pt.string,
    toggleText: _pt.string,
    searchButtonAriaLabel: _pt.string,
    searchInputValue: _pt.string,
    onSearchInputChange: _pt.func,
    searchInputPlaceholder: _pt.string,
    onSearchButtonClick: _pt.func
  });

  _defineProperty$r(ContextSelector, "defaultProps", {
    children: null,
    className: '',
    isOpen: false,
    onToggle: () => undefined,
    onSelect: () => undefined,
    screenReaderLabel: '',
    toggleText: '',
    searchButtonAriaLabel: 'Search menu items',
    searchInputValue: '',
    onSearchInputChange: () => undefined,
    searchInputPlaceholder: 'Search',
    onSearchButtonClick: () => undefined
  });

  function _extends$18() { _extends$18 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$18.apply(this, arguments); }

  function _objectWithoutProperties$16(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$16(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$16(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$s(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class ContextSelectorItem extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$s(this, "ref", React.createRef());
    }

    componentDidMount() {
      /* eslint-disable-next-line */
      this.props.sendRef(this.props.index, this.ref.current);
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            {
        className,
        children,
        isHovered,
        onClick,
        isDisabled,
        index,
        sendRef
      } = _this$props,
            props = _objectWithoutProperties$16(_this$props, ["className", "children", "isHovered", "onClick", "isDisabled", "index", "sendRef"]);

      return React.createElement(ContextSelectorContext.Consumer, null, ({
        onSelect
      }) => React.createElement("li", {
        role: "none"
      }, React.createElement("button", _extends$18({
        className: css$1(styles$h.contextSelectorMenuListItem, isDisabled && styles$h.modifiers.disabled, isHovered && styles$h.modifiers.hover, className),
        ref: this.ref,
        onClick: event => {
          if (!isDisabled) {
            onClick(event);
            onSelect(event, children);
          }
        }
      }, props), children)));
    }

  }

  _defineProperty$s(ContextSelectorItem, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    isDisabled: _pt.bool,
    isHovered: _pt.bool,
    onClick: _pt.func,
    index: _pt.number,
    sendRef: _pt.func
  });

  _defineProperty$s(ContextSelectorItem, "defaultProps", {
    children: null,
    className: '',
    isHovered: false,
    isDisabled: false,
    onClick: () => undefined,
    index: undefined,
    sendRef: () => {}
  });

  var dataList = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      dataList: 'pf-c-data-list',
      dataListItemAction: 'pf-c-data-list__item-action',
      dataListItem: 'pf-c-data-list__item',
      dataListItemRow: 'pf-c-data-list__item-row',
      dataListItemControl: 'pf-c-data-list__item-control',
      dataListAction: 'pf-c-data-list__action',
      dataListToggle: 'pf-c-data-list__toggle',
      button: 'pf-c-button',
      dataListExpandableContent: 'pf-c-data-list__expandable-content',
      dataListItemContent: 'pf-c-data-list__item-content',
      dataListCell: 'pf-c-data-list__cell',
      dataListExpandableContentBody: 'pf-c-data-list__expandable-content-body',
      modifiers: {
          'hidden': 'pf-m-hidden',
          'hiddenOnSm': 'pf-m-hidden-on-sm',
          'visibleOnSm': 'pf-m-visible-on-sm',
          'hiddenOnMd': 'pf-m-hidden-on-md',
          'visibleOnMd': 'pf-m-visible-on-md',
          'hiddenOnLg': 'pf-m-hidden-on-lg',
          'visibleOnLg': 'pf-m-visible-on-lg',
          'hiddenOnXl': 'pf-m-hidden-on-xl',
          'visibleOnXl': 'pf-m-visible-on-xl',
          'hiddenOn_2xl': 'pf-m-hidden-on-2xl',
          'visibleOn_2xl': 'pf-m-visible-on-2xl',
          'compact': 'pf-m-compact',
          'expanded': 'pf-m-expanded',
          'selected': 'pf-m-selected',
          'selectable': 'pf-m-selectable',
          'icon': 'pf-m-icon',
          'noFill': 'pf-m-no-fill',
          'alignRight': 'pf-m-align-right',
          'flex_2': 'pf-m-flex-2',
          'flex_3': 'pf-m-flex-3',
          'flex_4': 'pf-m-flex-4',
          'flex_5': 'pf-m-flex-5',
          'noPadding': 'pf-m-no-padding'
      }
  };
  });

  var styles$j = unwrapExports(dataList);

  function _extends$19() { _extends$19 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$19.apply(this, arguments); }

  function _objectWithoutProperties$17(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$17(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$17(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListContext = React.createContext({
    isSelectable: false
  });
  const DataList = (_ref) => {
    let {
      children = null,
      className = '',
      'aria-label': ariaLabel,
      selectedDataListItemId = '',
      onSelectDataListItem,
      isCompact = false
    } = _ref,
        props = _objectWithoutProperties$17(_ref, ["children", "className", "aria-label", "selectedDataListItemId", "onSelectDataListItem", "isCompact"]);

    const isSelectable = onSelectDataListItem !== undefined;

    const updateSelectedDataListItem = id => {
      onSelectDataListItem(id);
    };

    return React.createElement(DataListContext.Provider, {
      value: {
        isSelectable,
        selectedDataListItemId,
        updateSelectedDataListItem
      }
    }, React.createElement("ul", _extends$19({
      className: css$1(styles$j.dataList, isCompact && styles$j.modifiers.compact, className),
      "aria-label": ariaLabel
    }, props), children));
  };
  DataList.propTypes = {
    children: _pt.node,
    className: _pt.string,
    'aria-label': _pt.string.isRequired,
    onSelectDataListItem: _pt.func,
    selectedDataListItemId: _pt.string,
    isCompact: _pt.bool
  };

  function _extends$1a() { _extends$1a = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1a.apply(this, arguments); }

  function _objectWithoutProperties$18(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$18(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$18(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function ownKeys$6(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$6(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$6(source, true).forEach(function (key) { _defineProperty$t(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$6(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty$t(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  const visibilityModifiers = pickProperties(styles$j.modifiers, ['hidden', 'hiddenOnSm', 'hiddenOnMd', 'hiddenOnLg', 'hiddenOnXl', 'hiddenOn_2xl', 'visibleOnSm', 'visibleOnMd', 'visibleOnLg', 'visibleOnXl', 'visibleOn_2xl']); // eslint-disable-next-line @typescript-eslint/interface-name-prefix

  const DataListActionVisibility = Object.keys(visibilityModifiers).map(key => [key.replace('_2xl', '2Xl'), visibilityModifiers[key]]).reduce((acc, curr) => _objectSpread$6({}, acc, {
    [curr[0]]: curr[1]
  }), {});
  class DataListAction extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$t(this, "onToggle", isOpen => {
        this.setState({
          isOpen
        });
      });

      _defineProperty$t(this, "onSelect", event => {
        this.setState(prevState => ({
          isOpen: !prevState.isOpen
        }));
      });

      this.state = {
        isOpen: false
      };
    }

    render() {
      const _this$props = this.props,
            {
        children,
        className,

        /* eslint-disable @typescript-eslint/no-unused-vars */
        id,
        'aria-label': ariaLabel,
        'aria-labelledby': ariaLabelledBy
      } = _this$props,
            props = _objectWithoutProperties$18(_this$props, ["children", "className", "id", "aria-label", "aria-labelledby"]);

      return React.createElement("div", _extends$1a({
        className: css$1(styles$j.dataListItemAction, className)
      }, props), children);
    }

  }

  _defineProperty$t(DataListAction, "propTypes", {
    children: _pt.node.isRequired,
    className: _pt.string,
    id: _pt.string.isRequired,
    'aria-labelledby': _pt.string.isRequired,
    'aria-label': _pt.string.isRequired
  });

  _defineProperty$t(DataListAction, "defaultProps", {
    className: ''
  });

  function _extends$1b() { _extends$1b = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1b.apply(this, arguments); }

  function _objectWithoutProperties$19(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$19(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$19(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListCell = (_ref) => {
    let {
      children = null,
      className = '',
      width = 1,
      isFilled = true,
      alignRight = false,
      isIcon = false
    } = _ref,
        props = _objectWithoutProperties$19(_ref, ["children", "className", "width", "isFilled", "alignRight", "isIcon"]);

    return React.createElement("div", _extends$1b({
      className: css$1(styles$j.dataListCell, width > 1 && getModifier(styles$j, `flex_${width}`, ''), !isFilled && styles$j.modifiers.noFill, alignRight && styles$j.modifiers.alignRight, isIcon && styles$j.modifiers.icon, className)
    }, props), children);
  };
  DataListCell.propTypes = {
    children: _pt.node,
    className: _pt.string,
    width: _pt.oneOf([1, 2, 3, 4, 5]),
    isFilled: _pt.bool,
    alignRight: _pt.bool,
    isIcon: _pt.bool
  };

  function _extends$1c() { _extends$1c = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1c.apply(this, arguments); }

  function _objectWithoutProperties$1a(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1a(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1a(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListCheck = (_ref) => {
    let {
      className = '',
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      onChange = (checked, event) => {},
      isValid = true,
      isDisabled = false,
      isChecked = null,
      checked = null
    } = _ref,
        props = _objectWithoutProperties$1a(_ref, ["className", "onChange", "isValid", "isDisabled", "isChecked", "checked"]);

    return React.createElement("div", {
      className: css$1(styles$j.dataListItemControl, className)
    }, React.createElement("div", {
      className: css$1('pf-c-data-list__check')
    }, React.createElement("input", _extends$1c({}, props, {
      type: "checkbox",
      onChange: event => onChange(event.currentTarget.checked, event),
      "aria-invalid": !isValid,
      disabled: isDisabled,
      checked: isChecked || checked
    }))));
  };
  DataListCheck.propTypes = {
    className: _pt.string,
    isValid: _pt.bool,
    isDisabled: _pt.bool,
    isChecked: _pt.bool,
    checked: _pt.bool,
    onChange: _pt.func,
    'aria-labelledby': _pt.string.isRequired
  };

  var select = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      select: 'pf-c-select',
      selectToggle: 'pf-c-select__toggle',
      formControl: 'pf-c-form-control',
      selectToggleClear: 'pf-c-select__toggle-clear',
      selectToggleButton: 'pf-c-select__toggle-button',
      selectToggleArrow: 'pf-c-select__toggle-arrow',
      selectToggleText: 'pf-c-select__toggle-text',
      selectToggleWrapper: 'pf-c-select__toggle-wrapper',
      chip: 'pf-c-chip',
      button: 'pf-c-button',
      chipGroup: 'pf-c-chip-group',
      selectToggleTypeaheadForm: 'pf-c-select__toggle-typeahead-form',
      selectToggleTypeahead: 'pf-c-select__toggle-typeahead',
      selectToggleIcon: 'pf-c-select__toggle-icon',
      selectToggleBadge: 'pf-c-select__toggle-badge',
      selectMenu: 'pf-c-select__menu',
      selectMenuFieldset: 'pf-c-select__menu-fieldset',
      selectMenuItem: 'pf-c-select__menu-item',
      selectMenuItemIcon: 'pf-c-select__menu-item-icon',
      selectMenuItemMatch: 'pf-c-select__menu-item--match',
      selectSeparator: 'pf-c-select__separator',
      selectMenuGroup: 'pf-c-select__menu-group',
      selectMenuInput: 'pf-c-select__menu-input',
      selectMenuGroupTitle: 'pf-c-select__menu-group-title',
      modifiers: {
          'disabled': 'pf-m-disabled',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'expanded': 'pf-m-expanded',
          'plain': 'pf-m-plain',
          'typeahead': 'pf-m-typeahead',
          'top': 'pf-m-top',
          'focus': 'pf-m-focus',
          'alignRight': 'pf-m-align-right',
          'selected': 'pf-m-selected'
      }
  };
  });

  var styles$k = unwrapExports(select);

  var form = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      form: 'pf-c-form',
      formLabel: 'pf-c-form__label',
      formGroup: 'pf-c-form__group',
      formControl: 'pf-c-form-control',
      formHorizontalGroup: 'pf-c-form__horizontal-group',
      formHelperText: 'pf-c-form__helper-text',
      check: 'pf-c-check',
      formLabelText: 'pf-c-form__label-text',
      formLabelRequired: 'pf-c-form__label-required',
      formFieldset: 'pf-c-form__fieldset',
      formActions: 'pf-c-form__actions',
      modifiers: {
          'horizontal': 'pf-m-horizontal',
          'alignRight': 'pf-m-align-right',
          'noPaddingTop': 'pf-m-no-padding-top',
          'action': 'pf-m-action',
          'inline': 'pf-m-inline',
          'disabled': 'pf-m-disabled',
          'error': 'pf-m-error',
          'success': 'pf-m-success',
          'inactive': 'pf-m-inactive',
          'hidden': 'pf-m-hidden'
      }
  };
  });

  var styles$l = unwrapExports(form);

  var checkIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.CheckIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var CheckIconConfig = {
    name: 'CheckIcon',
    height: 512,
    width: 512,
    svgPath: 'M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.CheckIconConfig = CheckIconConfig;

  var _default = (0, _createIcon["default"])(CheckIconConfig);

  exports["default"] = _default;

  });

  var CheckIcon = unwrapExports(checkIcon);
  var checkIcon_1 = checkIcon.CheckIconConfig;

  const SelectContext = React.createContext(null);
  const SelectProvider = SelectContext.Provider;
  const SelectConsumer = SelectContext.Consumer;

  (function (SelectVariant) {
    SelectVariant["single"] = "single";
    SelectVariant["checkbox"] = "checkbox";
    SelectVariant["typeahead"] = "typeahead";
    SelectVariant["typeaheadMulti"] = "typeaheadmulti";
  })(exports.SelectVariant || (exports.SelectVariant = {}));

  (function (SelectDirection) {
    SelectDirection["up"] = "up";
    SelectDirection["down"] = "down";
  })(exports.SelectDirection || (exports.SelectDirection = {}));

  const KeyTypes = {
    Tab: 'Tab',
    Space: ' ',
    Escape: 'Escape',
    Enter: 'Enter',
    ArrowUp: 'ArrowUp',
    ArrowDown: 'ArrowDown'
  };

  function _extends$1d() { _extends$1d = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1d.apply(this, arguments); }

  function _objectWithoutProperties$1b(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1b(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1b(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$u(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class SelectOption extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$u(this, "ref", React.createRef());

      _defineProperty$u(this, "onKeyDown", event => {
        if (event.key === KeyTypes.Tab) {
          return;
        }

        event.preventDefault();

        if (event.key === KeyTypes.ArrowUp) {
          this.props.keyHandler(this.props.index, 'up');
        } else if (event.key === KeyTypes.ArrowDown) {
          this.props.keyHandler(this.props.index, 'down');
        } else if (event.key === KeyTypes.Enter) {
          this.ref.current.click();

          if (this.context.variant === exports.SelectVariant.checkbox) {
            this.ref.current.focus();
          }
        }
      });
    }

    componentDidMount() {
      this.props.sendRef(this.props.isDisabled ? null : this.ref.current, this.props.index);
    }

    componentDidUpdate() {
      this.props.sendRef(this.props.isDisabled ? null : this.ref.current, this.props.index);
    }

    render() {
      /* eslint-disable @typescript-eslint/no-unused-vars */
      const _this$props = this.props,
            {
        children,
        className,
        value,
        onClick,
        isDisabled,
        isPlaceholder,
        isNoResultsOption,
        isSelected,
        isChecked,
        isFocused,
        sendRef,
        keyHandler,
        index,
        component
      } = _this$props,
            props = _objectWithoutProperties$1b(_this$props, ["children", "className", "value", "onClick", "isDisabled", "isPlaceholder", "isNoResultsOption", "isSelected", "isChecked", "isFocused", "sendRef", "keyHandler", "index", "component"]);
      /* eslint-enable @typescript-eslint/no-unused-vars */


      const Component = component;
      return React.createElement(SelectConsumer, null, ({
        onSelect,
        onClose,
        variant
      }) => React.createElement(React.Fragment, null, variant !== exports.SelectVariant.checkbox && React.createElement("li", {
        role: "presentation"
      }, React.createElement(Component, _extends$1d({}, props, {
        className: css$1(styles$k.selectMenuItem, isSelected && styles$k.modifiers.selected, isDisabled && styles$k.modifiers.disabled, isFocused && styles$k.modifiers.focus, className),
        onClick: event => {
          if (!isDisabled) {
            onClick(event);
            onSelect(event, value, isPlaceholder);
            onClose();
          }
        },
        role: "option",
        "aria-selected": isSelected || null,
        ref: this.ref,
        onKeyDown: this.onKeyDown,
        type: "button"
      }), children || value.toString(), isSelected && React.createElement(CheckIcon, {
        className: css$1(styles$k.selectMenuItemIcon),
        "aria-hidden": true
      }))), variant === exports.SelectVariant.checkbox && !isNoResultsOption && React.createElement("label", _extends$1d({}, props, {
        className: css$1(checkStyles.check, styles$k.selectMenuItem, isDisabled && styles$k.modifiers.disabled, className),
        onKeyDown: this.onKeyDown
      }), React.createElement("input", {
        id: value.toString(),
        className: css$1(checkStyles.checkInput),
        type: "checkbox",
        onChange: event => {
          if (!isDisabled) {
            onClick(event);
            onSelect(event, value);
          }
        },
        ref: this.ref,
        checked: isChecked || false,
        disabled: isDisabled
      }), React.createElement("span", {
        className: css$1(checkStyles.checkLabel, isDisabled && styles$k.modifiers.disabled)
      }, children || value.toString())), variant === exports.SelectVariant.checkbox && isNoResultsOption && React.createElement("div", null, React.createElement(Component, _extends$1d({}, props, {
        className: css$1(styles$k.selectMenuItem, isSelected && styles$k.modifiers.selected, isDisabled && styles$k.modifiers.disabled, isFocused && styles$k.modifiers.focus, className),
        role: "option",
        "aria-selected": isSelected || null,
        ref: this.ref,
        onKeyDown: this.onKeyDown,
        type: "button"
      }), children || value.toString()))));
    }

  }

  _defineProperty$u(SelectOption, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    index: _pt.number,
    component: _pt.node,
    value: _pt.oneOfType([_pt.string, _pt.shape({})]),
    isDisabled: _pt.bool,
    isPlaceholder: _pt.bool,
    isNoResultsOption: _pt.bool,
    isSelected: _pt.bool,
    isChecked: _pt.bool,
    isFocused: _pt.bool,
    sendRef: _pt.func,
    keyHandler: _pt.func,
    onClick: _pt.func
  });

  _defineProperty$u(SelectOption, "defaultProps", {
    className: '',
    value: '',
    index: 0,
    isDisabled: false,
    isPlaceholder: false,
    isSelected: false,
    isChecked: false,
    isFocused: false,
    isNoResultsOption: false,
    component: 'button',
    onClick: () => {},
    sendRef: () => {},
    keyHandler: () => {}
  });

  function _extends$1e() { _extends$1e = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1e.apply(this, arguments); }

  function _objectWithoutProperties$1c(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1c(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1c(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$v(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class SelectMenu extends React.Component {
    extendChildren() {
      const {
        children,
        isGrouped
      } = this.props;
      const childrenArray = children;

      if (isGrouped) {
        let index = 0;
        return React.Children.map(childrenArray, group => React.cloneElement(group, {
          titleId: group.props.label.replace(/\W/g, '-'),
          children: group.props.children.map(option => this.cloneOption(option, index++))
        }));
      }

      return React.Children.map(childrenArray, (child, index) => this.cloneOption(child, index));
    }

    cloneOption(child, index) {
      const {
        selected,
        sendRef,
        keyHandler
      } = this.props;
      const isSelected = selected && selected.constructor === Array ? selected && Array.isArray(selected) && selected.includes(child.props.value) : selected === child.props.value;
      return React.cloneElement(child, {
        id: `${child.props.value ? child.props.value.toString() : ''}-${index}`,
        isSelected,
        sendRef,
        keyHandler,
        index
      });
    }

    extendCheckboxChildren(children) {
      const {
        isGrouped,
        checked,
        sendRef,
        keyHandler,
        hasInlineFilter
      } = this.props;
      let index = hasInlineFilter ? 1 : 0;

      if (isGrouped) {
        return React.Children.map(children, group => {
          if (group.type === SelectOption) {
            return group;
          }

          return React.cloneElement(group, {
            titleId: group.props.label.replace(/\W/g, '-'),
            children: React.createElement("fieldset", {
              "aria-labelledby": group.props.label.replace(/\W/g, '-'),
              className: css$1(styles$k.selectMenuFieldset)
            }, group.props.children.map(option => React.cloneElement(option, {
              isChecked: checked && checked.includes(option.props.value),
              sendRef,
              keyHandler,
              index: index++
            })))
          });
        });
      }

      return React.Children.map(children, child => React.cloneElement(child, {
        isChecked: checked && checked.includes(child.props.value),
        sendRef,
        keyHandler,
        index: index++
      }));
    }

    render() {
      /* eslint-disable @typescript-eslint/no-unused-vars */
      const _this$props = this.props,
            {
        children,
        isCustomContent,
        className,
        isExpanded,
        openedOnEnter,
        selected,
        checked,
        isGrouped,
        sendRef,
        keyHandler,
        maxHeight,
        noResultsFoundText,
        createText,
        'aria-label': ariaLabel,
        'aria-labelledby': ariaLabelledBy,
        hasInlineFilter
      } = _this$props,
            props = _objectWithoutProperties$1c(_this$props, ["children", "isCustomContent", "className", "isExpanded", "openedOnEnter", "selected", "checked", "isGrouped", "sendRef", "keyHandler", "maxHeight", "noResultsFoundText", "createText", "aria-label", "aria-labelledby", "hasInlineFilter"]);
      /* eslint-enable @typescript-eslint/no-unused-vars */


      return React.createElement(SelectConsumer, null, ({
        variant
      }) => React.createElement(React.Fragment, null, isCustomContent && React.createElement("div", _extends$1e({
        className: css$1(styles$k.selectMenu, className)
      }, maxHeight && {
        style: {
          maxHeight,
          overflow: 'auto'
        }
      }, props), children), variant !== exports.SelectVariant.checkbox && !isCustomContent && React.createElement("ul", _extends$1e({
        className: css$1(styles$k.selectMenu, className),
        role: "listbox"
      }, maxHeight && {
        style: {
          maxHeight,
          overflow: 'auto'
        }
      }, props), this.extendChildren()), variant === exports.SelectVariant.checkbox && !isCustomContent && React.Children.count(children) > 0 && React.createElement(FocusTrap, {
        focusTrapOptions: {
          clickOutsideDeactivates: true
        }
      }, React.createElement("div", _extends$1e({
        className: css$1(styles$k.selectMenu, className)
      }, maxHeight && {
        style: {
          maxHeight,
          overflow: 'auto'
        }
      }), React.createElement("fieldset", _extends$1e({}, props, {
        "aria-label": ariaLabel,
        "aria-labelledby": !ariaLabel && ariaLabelledBy || null,
        className: css$1(styles$l.formFieldset)
      }), hasInlineFilter && [children.shift(), ...this.extendCheckboxChildren(children)], !hasInlineFilter && this.extendCheckboxChildren(children)))), variant === exports.SelectVariant.checkbox && !isCustomContent && React.Children.count(children) === 0 && React.createElement("div", _extends$1e({
        className: css$1(styles$k.selectMenu, className)
      }, maxHeight && {
        style: {
          maxHeight,
          overflow: 'auto'
        }
      }), React.createElement("fieldset", {
        className: css$1(styles$k.selectMenuFieldset)
      }))));
    }

  }

  _defineProperty$v(SelectMenu, "propTypes", {
    children: _pt.oneOfType([_pt.arrayOf(_pt.element), _pt.node]).isRequired,
    isCustomContent: _pt.bool,
    className: _pt.string,
    isExpanded: _pt.bool,
    isGrouped: _pt.bool,
    selected: _pt.oneOfType([_pt.string, _pt.any, _pt.arrayOf(_pt.oneOfType([_pt.string, _pt.any]))]),
    checked: _pt.arrayOf(_pt.oneOfType([_pt.string, _pt.any])),
    openedOnEnter: _pt.bool,
    maxHeight: _pt.oneOfType([_pt.string, _pt.number]),
    noResultsFoundText: _pt.string,
    createText: _pt.string,
    sendRef: _pt.func,
    keyHandler: _pt.func,
    hasInlineFilter: _pt.bool
  });

  _defineProperty$v(SelectMenu, "defaultProps", {
    className: '',
    isExpanded: false,
    isGrouped: false,
    openedOnEnter: false,
    selected: '',
    maxHeight: '',
    sendRef: () => {},
    keyHandler: () => {},
    isCustomContent: false,
    hasInlineFilter: false
  });

  function _extends$1f() { _extends$1f = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1f.apply(this, arguments); }

  function _objectWithoutProperties$1d(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1d(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1d(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$w(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class SelectToggle extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$w(this, "onDocClick", event => {
        const {
          parentRef,
          isExpanded,
          onToggle,
          onClose
        } = this.props;

        if (isExpanded && parentRef && !parentRef.current.contains(event.target)) {
          onToggle(false);
          onClose();
          this.toggle.current.focus();
        }
      });

      _defineProperty$w(this, "onEscPress", event => {
        const {
          parentRef,
          isExpanded,
          variant,
          onToggle,
          onClose
        } = this.props;

        if (event.key === KeyTypes.Tab && variant === exports.SelectVariant.checkbox) {
          return;
        }

        if (isExpanded && (event.key === KeyTypes.Escape || event.key === KeyTypes.Tab) && parentRef && parentRef.current.contains(event.target)) {
          onToggle(false);
          onClose();
          this.toggle.current.focus();
        }
      });

      _defineProperty$w(this, "onKeyDown", event => {
        const {
          isExpanded,
          onToggle,
          variant,
          onClose,
          onEnter,
          handleTypeaheadKeys
        } = this.props;

        if ((event.key === KeyTypes.ArrowDown || event.key === KeyTypes.ArrowUp) && (variant === exports.SelectVariant.typeahead || variant === exports.SelectVariant.typeaheadMulti)) {
          handleTypeaheadKeys(event.key === KeyTypes.ArrowDown && 'down' || event.key === KeyTypes.ArrowUp && 'up');
        }

        if (event.key === KeyTypes.Enter && (variant === exports.SelectVariant.typeahead || variant === exports.SelectVariant.typeaheadMulti)) {
          if (isExpanded) {
            handleTypeaheadKeys('enter');
          } else {
            onToggle(!isExpanded);
          }
        }

        if (event.key === KeyTypes.Tab && variant === exports.SelectVariant.checkbox || event.key === KeyTypes.Tab && !isExpanded || event.key !== KeyTypes.Enter && event.key !== KeyTypes.Space || (event.key === KeyTypes.Space || event.key === KeyTypes.Enter) && (variant === exports.SelectVariant.typeahead || variant === exports.SelectVariant.typeaheadMulti)) {
          return;
        }

        event.preventDefault();

        if ((event.key === KeyTypes.Tab || event.key === KeyTypes.Enter || event.key === KeyTypes.Space) && isExpanded) {
          onToggle(!isExpanded);
          onClose();
          this.toggle.current.focus();
        } else if ((event.key === KeyTypes.Enter || event.key === KeyTypes.Space) && !isExpanded) {
          onToggle(!isExpanded);
          onEnter();
        }
      });

      const {
        variant: _variant
      } = props;
      const isTypeahead = _variant === exports.SelectVariant.typeahead || _variant === exports.SelectVariant.typeaheadMulti;
      this.toggle = isTypeahead ? React.createRef() : React.createRef();
    }

    componentDidMount() {
      document.addEventListener('mousedown', this.onDocClick);
      document.addEventListener('touchstart', this.onDocClick);
      document.addEventListener('keydown', this.onEscPress);
    }

    componentWillUnmount() {
      document.removeEventListener('mousedown', this.onDocClick);
      document.removeEventListener('touchstart', this.onDocClick);
      document.removeEventListener('keydown', this.onEscPress);
    }

    render() {
      /* eslint-disable @typescript-eslint/no-unused-vars */
      const _this$props = this.props,
            {
        className,
        children,
        isExpanded,
        isFocused,
        isActive,
        isHovered,
        isPlain,
        isDisabled,
        variant,
        onToggle,
        onEnter,
        onClose,
        handleTypeaheadKeys,
        parentRef,
        id,
        type,
        hasClearButton,
        ariaLabelledBy,
        ariaLabelToggle
      } = _this$props,
            props = _objectWithoutProperties$1d(_this$props, ["className", "children", "isExpanded", "isFocused", "isActive", "isHovered", "isPlain", "isDisabled", "variant", "onToggle", "onEnter", "onClose", "handleTypeaheadKeys", "parentRef", "id", "type", "hasClearButton", "ariaLabelledBy", "ariaLabelToggle"]);
      /* eslint-enable @typescript-eslint/no-unused-vars */


      const isTypeahead = variant === exports.SelectVariant.typeahead || variant === exports.SelectVariant.typeaheadMulti || hasClearButton;
      const toggleProps = {
        id,
        'aria-labelledby': ariaLabelledBy,
        'aria-expanded': isExpanded,
        'aria-haspopup': variant !== exports.SelectVariant.checkbox && 'listbox' || null
      };
      return React.createElement(React.Fragment, null, !isTypeahead && React.createElement("button", _extends$1f({}, props, toggleProps, {
        ref: this.toggle,
        type: type,
        className: css$1(styles$k.selectToggle, isFocused && styles$k.modifiers.focus, isHovered && styles$k.modifiers.hover, isDisabled && styles$k.modifiers.disabled, isActive && styles$k.modifiers.active, isPlain && styles$k.modifiers.plain, className) // eslint-disable-next-line @typescript-eslint/no-unused-vars
        ,
        onClick: _event => {
          onToggle(!isExpanded);

          if (isExpanded) {
            onClose();
          }
        },
        onKeyDown: this.onKeyDown,
        disabled: isDisabled
      }), children, React.createElement(CaretDownIcon, {
        className: css$1(styles$k.selectToggleArrow)
      })), isTypeahead && React.createElement("div", _extends$1f({}, props, {
        ref: this.toggle,
        className: css$1(styles$k.selectToggle, isFocused && styles$k.modifiers.focus, isHovered && styles$k.modifiers.hover, isActive && styles$k.modifiers.active, isDisabled && styles$k.modifiers.disabled, isPlain && styles$k.modifiers.plain, isTypeahead && styles$k.modifiers.typeahead, className) // eslint-disable-next-line @typescript-eslint/no-unused-vars
        ,
        onClick: _event => {
          if (!isDisabled) {
            onToggle(true);
          }
        },
        onKeyDown: this.onKeyDown
      }), children, React.createElement("button", _extends$1f({}, toggleProps, {
        type: type,
        className: css$1(buttonStyles.button, styles$k.selectToggleButton, styles$k.modifiers.plain),
        "aria-label": ariaLabelToggle,
        onClick: _event => {
          _event.stopPropagation();

          onToggle(!isExpanded);

          if (isExpanded) {
            onClose();
          }
        },
        disabled: isDisabled
      }), React.createElement(CaretDownIcon, {
        className: css$1(styles$k.selectToggleArrow)
      }))));
    }

  }

  _defineProperty$w(SelectToggle, "propTypes", {
    id: _pt.string.isRequired,
    children: _pt.node.isRequired,
    className: _pt.string,
    isExpanded: _pt.bool,
    onToggle: _pt.func,
    onEnter: _pt.func,
    onClose: _pt.func,
    handleTypeaheadKeys: _pt.func,
    parentRef: _pt.any.isRequired,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isActive: _pt.bool,
    isPlain: _pt.bool,
    isDisabled: _pt.bool,
    type: _pt.oneOfType([_pt.oneOf(['reset']), _pt.oneOf(['button']), _pt.oneOf(['submit'])]),
    ariaLabelledBy: _pt.string,
    ariaLabelToggle: _pt.string,
    variant: _pt.oneOf(['single', 'checkbox', 'typeahead', 'typeaheadmulti']),
    hasClearButton: _pt.bool
  });

  _defineProperty$w(SelectToggle, "defaultProps", {
    className: '',
    isExpanded: false,
    isFocused: false,
    isHovered: false,
    isActive: false,
    isPlain: false,
    isDisabled: false,
    hasClearButton: false,
    variant: 'single',
    ariaLabelledBy: '',
    ariaLabelToggle: '',
    type: 'button',
    onToggle: () => {},
    onEnter: () => {},
    onClose: () => {}
  });

  var divider = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      divider: 'pf-c-divider',
      modifiers: {
          'vertical': 'pf-m-vertical',
          'insetNone': 'pf-m-inset-none',
          'insetSm': 'pf-m-inset-sm',
          'insetMd': 'pf-m-inset-md',
          'insetLg': 'pf-m-inset-lg',
          'insetXl': 'pf-m-inset-xl',
          'inset_2xl': 'pf-m-inset-2xl',
          'inset_3xl': 'pf-m-inset-3xl',
          'insetNoneOnSm': 'pf-m-inset-none-on-sm',
          'insetSmOnSm': 'pf-m-inset-sm-on-sm',
          'insetMdOnSm': 'pf-m-inset-md-on-sm',
          'insetLgOnSm': 'pf-m-inset-lg-on-sm',
          'insetXlOnSm': 'pf-m-inset-xl-on-sm',
          'inset_2xlOnSm': 'pf-m-inset-2xl-on-sm',
          'inset_3xlOnSm': 'pf-m-inset-3xl-on-sm',
          'insetNoneOnMd': 'pf-m-inset-none-on-md',
          'insetSmOnMd': 'pf-m-inset-sm-on-md',
          'insetMdOnMd': 'pf-m-inset-md-on-md',
          'insetLgOnMd': 'pf-m-inset-lg-on-md',
          'insetXlOnMd': 'pf-m-inset-xl-on-md',
          'inset_2xlOnMd': 'pf-m-inset-2xl-on-md',
          'inset_3xlOnMd': 'pf-m-inset-3xl-on-md',
          'insetNoneOnLg': 'pf-m-inset-none-on-lg',
          'insetSmOnLg': 'pf-m-inset-sm-on-lg',
          'insetMdOnLg': 'pf-m-inset-md-on-lg',
          'insetLgOnLg': 'pf-m-inset-lg-on-lg',
          'insetXlOnLg': 'pf-m-inset-xl-on-lg',
          'inset_2xlOnLg': 'pf-m-inset-2xl-on-lg',
          'inset_3xlOnLg': 'pf-m-inset-3xl-on-lg',
          'insetNoneOnXl': 'pf-m-inset-none-on-xl',
          'insetSmOnXl': 'pf-m-inset-sm-on-xl',
          'insetMdOnXl': 'pf-m-inset-md-on-xl',
          'insetLgOnXl': 'pf-m-inset-lg-on-xl',
          'insetXlOnXl': 'pf-m-inset-xl-on-xl',
          'inset_2xlOnXl': 'pf-m-inset-2xl-on-xl',
          'inset_3xlOnXl': 'pf-m-inset-3xl-on-xl',
          'insetNoneOn_2xl': 'pf-m-inset-none-on-2xl',
          'insetSmOn_2xl': 'pf-m-inset-sm-on-2xl',
          'insetMdOn_2xl': 'pf-m-inset-md-on-2xl',
          'insetLgOn_2xl': 'pf-m-inset-lg-on-2xl',
          'insetXlOn_2xl': 'pf-m-inset-xl-on-2xl',
          'inset_2xlOn_2xl': 'pf-m-inset-2xl-on-2xl',
          'inset_3xlOn_2xl': 'pf-m-inset-3xl-on-2xl'
      }
  };
  });

  var styles$m = unwrapExports(divider);

  function _extends$1g() { _extends$1g = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1g.apply(this, arguments); }

  function _objectWithoutProperties$1e(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1e(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1e(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (DividerVariant) {
    DividerVariant["hr"] = "hr";
    DividerVariant["li"] = "li";
    DividerVariant["div"] = "div";
  })(exports.DividerVariant || (exports.DividerVariant = {}));

  const Divider = (_ref) => {
    let {
      className = '',
      component = exports.DividerVariant.hr
    } = _ref,
        props = _objectWithoutProperties$1e(_ref, ["className", "component"]);

    const Component = component;
    return React.createElement(Component, _extends$1g({
      className: css$1(styles$m.divider, className)
    }, component !== 'hr' && {
      role: 'separator'
    }, props));
  };
  Divider.propTypes = {
    className: _pt.string,
    component: _pt.oneOf(['hr', 'li', 'div'])
  };

  function _extends$1h() { _extends$1h = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1h.apply(this, arguments); }

  function _objectWithoutProperties$1f(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1f(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1f(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$x(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  let currentId$2 = 0;

  class Select extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$x(this, "parentRef", React.createRef());

      _defineProperty$x(this, "filterRef", React.createRef());

      _defineProperty$x(this, "refCollection", []);

      _defineProperty$x(this, "state", {
        openedOnEnter: false,
        typeaheadInputValue: null,
        typeaheadActiveChild: null,
        typeaheadFilteredChildren: React.Children.toArray(this.props.children),
        typeaheadCurrIndex: -1,
        creatableValue: ''
      });

      _defineProperty$x(this, "componentDidUpdate", (prevProps, prevState) => {
        if (this.props.hasInlineFilter) {
          this.refCollection[0] = this.filterRef.current;
        }

        if (!prevState.openedOnEnter && this.state.openedOnEnter) {
          this.refCollection[0].focus();
        }

        if (prevProps.children !== this.props.children) {
          this.setState({
            typeaheadFilteredChildren: React.Children.toArray(this.props.children)
          });
        }

        if (prevProps.selections !== this.props.selections && this.props.variant === exports.SelectVariant.typeahead) {
          this.setState({
            typeaheadInputValue: this.props.selections
          });
        }
      });

      _defineProperty$x(this, "onEnter", () => {
        this.setState({
          openedOnEnter: true
        });
      });

      _defineProperty$x(this, "onClose", () => {
        this.setState({
          openedOnEnter: false,
          typeaheadInputValue: null,
          typeaheadActiveChild: null,
          typeaheadFilteredChildren: React.Children.toArray(this.props.children),
          typeaheadCurrIndex: -1
        });
      });

      _defineProperty$x(this, "onChange", e => {
        const {
          onFilter,
          isCreatable,
          onCreateOption,
          createText,
          noResultsFoundText,
          children
        } = this.props;
        let typeaheadFilteredChildren;

        if (onFilter) {
          typeaheadFilteredChildren = onFilter(e) || children;
        } else {
          let input;

          try {
            input = new RegExp(e.target.value.toString(), 'i');
          } catch (err) {
            input = new RegExp(e.target.value.toString().replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'i');
          }

          typeaheadFilteredChildren = e.target.value.toString() !== '' ? React.Children.toArray(this.props.children).filter(child => this.getDisplay(child.props.value.toString(), 'text').search(input) === 0) : React.Children.toArray(this.props.children);
        }

        if (!typeaheadFilteredChildren) {
          typeaheadFilteredChildren = [];
        }

        if (typeaheadFilteredChildren.length === 0) {
          !isCreatable && typeaheadFilteredChildren.push(React.createElement(SelectOption, {
            isDisabled: true,
            key: 0,
            value: noResultsFoundText,
            isNoResultsOption: true
          }));
        }

        if (isCreatable && e.target.value !== '') {
          const newValue = e.target.value;
          typeaheadFilteredChildren.push(React.createElement(SelectOption, {
            key: 0,
            value: newValue,
            onClick: () => onCreateOption && onCreateOption(newValue)
          }, createText, " \"", newValue, "\""));
        }

        this.setState({
          typeaheadInputValue: e.target.value,
          typeaheadCurrIndex: -1,
          typeaheadFilteredChildren,
          typeaheadActiveChild: null,
          creatableValue: e.target.value
        });
        this.refCollection = [];
      });

      _defineProperty$x(this, "onClick", e => {
        e.stopPropagation();
      });

      _defineProperty$x(this, "clearSelection", e => {
        e.stopPropagation();
        this.setState({
          typeaheadInputValue: null,
          typeaheadActiveChild: null,
          typeaheadFilteredChildren: React.Children.toArray(this.props.children),
          typeaheadCurrIndex: -1
        });
      });

      _defineProperty$x(this, "sendRef", (ref, index) => {
        this.refCollection[index] = ref;
      });

      _defineProperty$x(this, "handleArrowKeys", (index, position) => {
        keyHandler(index, 0, position, this.refCollection, this.refCollection);
      });

      _defineProperty$x(this, "handleFocus", () => {
        if (!this.props.isExpanded) {
          this.props.onToggle(true);
        }
      });

      _defineProperty$x(this, "handleTypeaheadKeys", position => {
        const {
          isExpanded,
          isCreatable,
          createText
        } = this.props;
        const {
          typeaheadActiveChild,
          typeaheadCurrIndex
        } = this.state;

        if (isExpanded) {
          if (position === 'enter' && (typeaheadActiveChild || this.refCollection[0])) {
            this.setState({
              typeaheadInputValue: typeaheadActiveChild && typeaheadActiveChild.innerText || this.refCollection[0].innerText
            });

            if (typeaheadActiveChild) {
              typeaheadActiveChild.click();
            } else {
              this.refCollection[0].click();
            }
          } else {
            let nextIndex;

            if (typeaheadCurrIndex === -1 && position === 'down') {
              nextIndex = 0;
            } else if (typeaheadCurrIndex === -1 && position === 'up') {
              nextIndex = this.refCollection.length - 1;
            } else {
              nextIndex = getNextIndex(typeaheadCurrIndex, position, this.refCollection);
            }

            this.setState({
              typeaheadCurrIndex: nextIndex,
              typeaheadActiveChild: this.refCollection[nextIndex],
              typeaheadInputValue: isCreatable && this.refCollection[nextIndex].innerText.includes(createText) ? this.state.creatableValue : this.refCollection[nextIndex].innerText
            });
          }
        }
      });

      _defineProperty$x(this, "getDisplay", (value, type = 'node') => {
        if (!value) {
          return;
        }

        const {
          children,
          isGrouped
        } = this.props;
        let item = children.filter(child => child.props.value !== undefined && child.props.value.toString() === value.toString())[0];

        if (isGrouped) {
          item = children.reduce((acc, curr) => [...acc, ...React.Children.toArray(curr.props.children)], []).filter(child => child.props.value.toString() === value.toString())[0];
        }

        if (item) {
          if (item && item.props.children) {
            if (type === 'node') {
              return item.props.children;
            }

            return this.findText(item);
          }

          return item.props.value.toString();
        }

        return value;
      });

      _defineProperty$x(this, "findText", item => {
        if (!item.props || !item.props.children) {
          if (typeof item !== 'string') {
            return '';
          }

          return item;
        }

        if (typeof item.props.children === 'string') {
          return item.props.children;
        }

        const multi = [];
        React.Children.toArray(item.props.children).forEach(child => multi.push(this.findText(child)));
        return multi.join('');
      });
    }

    extendTypeaheadChildren(typeaheadActiveChild) {
      return this.state.typeaheadFilteredChildren.map(child => React.cloneElement(child, {
        isFocused: typeaheadActiveChild && (typeaheadActiveChild.innerText === this.getDisplay(child.props.value.toString(), 'text') || this.props.isCreatable && typeaheadActiveChild.innerText === `{createText} "${child.props.value}"`)
      }));
    }

    render() {
      /* eslint-disable @typescript-eslint/no-unused-vars */
      const _this$props = this.props,
            {
        children,
        className,
        customContent,
        variant,
        direction,
        onToggle,
        onSelect,
        onClear,
        onFilter,
        onCreateOption,
        toggleId,
        isExpanded,
        isGrouped,
        isPlain,
        isDisabled,
        isCreatable,
        selections,
        isCheckboxSelectionBadgeHidden,
        ariaLabelledBy,
        ariaLabelTypeAhead,
        ariaLabelClear,
        ariaLabelToggle,
        ariaLabelRemove,
        'aria-label': ariaLabel,
        placeholderText,
        width,
        maxHeight,
        toggleIcon,
        ouiaContext,
        ouiaId,
        createText,
        noResultsFoundText,
        hasInlineFilter
      } = _this$props,
            props = _objectWithoutProperties$1f(_this$props, ["children", "className", "customContent", "variant", "direction", "onToggle", "onSelect", "onClear", "onFilter", "onCreateOption", "toggleId", "isExpanded", "isGrouped", "isPlain", "isDisabled", "isCreatable", "selections", "isCheckboxSelectionBadgeHidden", "ariaLabelledBy", "ariaLabelTypeAhead", "ariaLabelClear", "ariaLabelToggle", "ariaLabelRemove", "aria-label", "placeholderText", "width", "maxHeight", "toggleIcon", "ouiaContext", "ouiaId", "createText", "noResultsFoundText", "hasInlineFilter"]);
      /* eslint-enable @typescript-eslint/no-unused-vars */


      const {
        openedOnEnter,
        typeaheadInputValue,
        typeaheadActiveChild,
        typeaheadFilteredChildren
      } = this.state;
      const selectToggleId = toggleId || `pf-toggle-id-${currentId$2++}`;
      let childPlaceholderText = null;

      if (!customContent) {
        if (!selections && !placeholderText) {
          const childPlaceholder = React.Children.toArray(children.filter(child => child.props.isPlaceholder === true));
          childPlaceholderText = childPlaceholder[0] && this.getDisplay(childPlaceholder[0].props.value, 'node') || children[0] && this.getDisplay(children[0].props.value, 'node');
        }
      }

      const hasOnClear = onClear !== Select.defaultProps.onClear;
      const hasAnySelections = selections && (Array.isArray(selections) ? selections.length > 0 ? true : false : selections !== '');
      const clearBtn = React.createElement("button", {
        className: css$1(buttonStyles.button, buttonStyles.modifiers.plain, styles$k.selectToggleClear),
        onClick: e => {
          this.clearSelection(e);
          onClear(e);
        },
        "aria-label": ariaLabelClear,
        type: "button",
        disabled: isDisabled
      }, React.createElement(TimesCircleIcon, {
        "aria-hidden": true
      }));
      let selectedChips = null;

      if (variant === exports.SelectVariant.typeaheadMulti) {
        selectedChips = React.createElement(ChipGroup, null, selections && selections.map(item => {
          const isItemDisabled = React.Children.toArray(children.filter(child => child.props.value === item))[0].props.isDisabled;
          return React.createElement(ChipWithOuiaContext, _extends$1h({
            key: item,
            onClick: e => onSelect(e, item),
            closeBtnAriaLabel: ariaLabelRemove
          }, isItemDisabled && {
            isReadOnly: true
          }), this.getDisplay(item, 'node'));
        }));
      }

      let filterWithChildren = children;

      if (hasInlineFilter) {
        const filterBox = React.createElement(React.Fragment, null, React.createElement("div", {
          key: "inline-filter",
          className: css$1(styles$k.selectMenuInput)
        }, React.createElement("input", {
          key: "inline-filter-input",
          type: "search",
          className: css$1(formStyles.formControl, formStyles.modifiers.search),
          onChange: this.onChange,
          onKeyDown: event => {
            if (event.key === KeyTypes.ArrowUp) {
              this.handleArrowKeys(0, 'up');
            } else if (event.key === KeyTypes.ArrowDown) {
              this.handleArrowKeys(0, 'down');
            }
          },
          ref: this.filterRef,
          autoComplete: "off"
        })), React.createElement(Divider, {
          key: "inline-filter-divider"
        }));
        this.refCollection[0] = this.filterRef.current;
        filterWithChildren = [filterBox, ...typeaheadFilteredChildren].map((option, index) => React.cloneElement(option, {
          key: index
        }));
      }

      return React.createElement("div", _extends$1h({
        className: css$1(styles$k.select, isExpanded && styles$k.modifiers.expanded, direction === exports.SelectDirection.up && styles$k.modifiers.top, className),
        ref: this.parentRef,
        style: {
          width
        }
      }, ouiaContext.isOuia && {
        'data-ouia-component-type': 'Select',
        'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
      }), React.createElement(SelectContext.Provider, {
        value: {
          onSelect,
          onClose: this.onClose,
          variant
        }
      }, React.createElement(SelectToggle, {
        id: selectToggleId,
        parentRef: this.parentRef,
        isExpanded: isExpanded,
        isPlain: isPlain,
        onToggle: onToggle,
        onEnter: this.onEnter,
        onClose: this.onClose,
        ariaLabelledBy: `${ariaLabelledBy || ''} ${selectToggleId}`,
        variant: variant,
        ariaLabelToggle: ariaLabelToggle,
        handleTypeaheadKeys: this.handleTypeaheadKeys,
        isDisabled: isDisabled,
        hasClearButton: hasOnClear
      }, customContent && React.createElement("div", {
        className: css$1(styles$k.selectToggleWrapper)
      }, toggleIcon && React.createElement("span", {
        className: css$1(styles$k.selectToggleIcon)
      }, toggleIcon), React.createElement("span", {
        className: css$1(styles$k.selectToggleText)
      }, placeholderText)), variant === exports.SelectVariant.single && !customContent && React.createElement("div", {
        className: css$1(styles$k.selectToggleWrapper)
      }, toggleIcon && React.createElement("span", {
        className: css$1(styles$k.selectToggleIcon)
      }, toggleIcon), React.createElement("span", {
        className: css$1(styles$k.selectToggleText)
      }, this.getDisplay(selections, 'node') || placeholderText || childPlaceholderText), hasOnClear && hasAnySelections && clearBtn), variant === exports.SelectVariant.checkbox && !customContent && React.createElement(React.Fragment, null, React.createElement("div", {
        className: css$1(styles$k.selectToggleWrapper)
      }, toggleIcon && React.createElement("span", {
        className: css$1(styles$k.selectToggleIcon)
      }, toggleIcon), React.createElement("span", {
        className: css$1(styles$k.selectToggleText)
      }, placeholderText), !isCheckboxSelectionBadgeHidden && selections && Array.isArray(selections) && selections.length > 0 && React.createElement("div", {
        className: css$1(styles$k.selectToggleBadge)
      }, React.createElement("span", {
        className: css$1(badgeStyles.badge, badgeStyles.modifiers.read)
      }, selections.length))), hasOnClear && hasAnySelections && clearBtn), variant === exports.SelectVariant.typeahead && !customContent && React.createElement(React.Fragment, null, React.createElement("div", {
        className: css$1(styles$k.selectToggleWrapper)
      }, toggleIcon && React.createElement("span", {
        className: css$1(styles$k.selectToggleIcon)
      }, toggleIcon), React.createElement("input", {
        className: css$1(formStyles.formControl, styles$k.selectToggleTypeahead),
        "aria-activedescendant": typeaheadActiveChild && typeaheadActiveChild.id,
        id: `${selectToggleId}-select-typeahead`,
        "aria-label": ariaLabelTypeAhead,
        placeholder: placeholderText,
        value: typeaheadInputValue !== null ? typeaheadInputValue : this.getDisplay(selections, 'text') || '',
        type: "text",
        onClick: this.onClick,
        onChange: this.onChange,
        onFocus: this.handleFocus,
        autoComplete: "off",
        disabled: isDisabled
      })), (selections || typeaheadInputValue) && clearBtn), variant === exports.SelectVariant.typeaheadMulti && !customContent && React.createElement(React.Fragment, null, React.createElement("div", {
        className: css$1(styles$k.selectToggleWrapper)
      }, toggleIcon && React.createElement("span", {
        className: css$1(styles$k.selectToggleIcon)
      }, toggleIcon), selections && Array.isArray(selections) && selections.length > 0 && selectedChips, React.createElement("input", {
        className: css$1(formStyles.formControl, styles$k.selectToggleTypeahead),
        "aria-activedescendant": typeaheadActiveChild && typeaheadActiveChild.id,
        id: `${selectToggleId}-select-multi-typeahead-typeahead`,
        "aria-label": ariaLabelTypeAhead,
        placeholder: placeholderText,
        value: typeaheadInputValue !== null ? typeaheadInputValue : '',
        type: "text",
        onChange: this.onChange,
        onClick: this.onClick,
        onFocus: this.handleFocus,
        autoComplete: "off",
        disabled: isDisabled
      })), (selections && Array.isArray(selections) && selections.length > 0 || typeaheadInputValue) && clearBtn)), customContent && isExpanded && React.createElement(SelectMenu, _extends$1h({}, props, {
        selected: selections,
        openedOnEnter: openedOnEnter,
        "aria-label": ariaLabel,
        "aria-labelledby": ariaLabelledBy,
        sendRef: this.sendRef,
        keyHandler: this.handleArrowKeys,
        maxHeight: maxHeight,
        isCustomContent: true
      }), customContent), variant === exports.SelectVariant.single && isExpanded && !customContent && React.createElement(SelectMenu, _extends$1h({}, props, {
        isGrouped: isGrouped,
        selected: selections,
        openedOnEnter: openedOnEnter,
        "aria-label": ariaLabel,
        "aria-labelledby": ariaLabelledBy,
        sendRef: this.sendRef,
        keyHandler: this.handleArrowKeys,
        maxHeight: maxHeight
      }), children), variant === exports.SelectVariant.checkbox && isExpanded && !customContent && React.createElement(SelectMenu, _extends$1h({}, props, {
        checked: selections ? selections : [],
        "aria-label": ariaLabel,
        "aria-labelledby": ariaLabelledBy,
        isGrouped: isGrouped,
        sendRef: this.sendRef,
        keyHandler: this.handleArrowKeys,
        maxHeight: maxHeight,
        hasInlineFilter: hasInlineFilter
      }), filterWithChildren), (variant === exports.SelectVariant.typeahead || variant === exports.SelectVariant.typeaheadMulti) && isExpanded && !customContent && React.createElement(SelectMenu, _extends$1h({}, props, {
        selected: selections,
        openedOnEnter: openedOnEnter,
        "aria-label": ariaLabel,
        "aria-labelledby": ariaLabelledBy,
        sendRef: this.sendRef,
        keyHandler: this.handleArrowKeys,
        maxHeight: maxHeight
      }), this.extendTypeaheadChildren(typeaheadActiveChild))));
    }

  }

  _defineProperty$x(Select, "propTypes", {
    children: _pt.arrayOf(_pt.element),
    className: _pt.string,
    direction: _pt.oneOf(['up', 'down']),
    isExpanded: _pt.bool,
    isGrouped: _pt.bool,
    isPlain: _pt.bool,
    isDisabled: _pt.bool,
    isCreatable: _pt.bool,
    createText: _pt.string,
    placeholderText: _pt.oneOfType([_pt.string, _pt.node]),
    noResultsFoundText: _pt.string,
    selections: _pt.oneOfType([_pt.string, _pt.any, _pt.arrayOf(_pt.oneOfType([_pt.string, _pt.any]))]),
    isCheckboxSelectionBadgeHidden: _pt.bool,
    toggleId: _pt.string,
    'aria-label': _pt.string,
    ariaLabelledBy: _pt.string,
    ariaLabelTypeAhead: _pt.string,
    ariaLabelClear: _pt.string,
    ariaLabelToggle: _pt.string,
    ariaLabelRemove: _pt.string,
    onSelect: _pt.func,
    onToggle: _pt.func.isRequired,
    onClear: _pt.func,
    onFilter: _pt.func,
    onCreateOption: _pt.func
  });

  _defineProperty$x(Select, "defaultProps", {
    children: [],
    className: '',
    direction: exports.SelectDirection.down,
    toggleId: null,
    isExpanded: false,
    isGrouped: false,
    isPlain: false,
    isDisabled: false,
    isCreatable: false,
    'aria-label': '',
    ariaLabelledBy: '',
    ariaLabelTypeAhead: '',
    ariaLabelClear: 'Clear all',
    ariaLabelToggle: 'Options menu',
    ariaLabelRemove: 'Remove',
    selections: '',
    createText: 'Create',
    placeholderText: '',
    noResultsFoundText: 'No results found',
    variant: exports.SelectVariant.single,
    width: '',
    onClear: () => undefined,
    onCreateOption: () => undefined,
    toggleIcon: null,
    onFilter: null,
    customContent: null,
    hasInlineFilter: false
  });

  const SelectWithOuiaContext = withOuiaContext(Select);

  function _extends$1i() { _extends$1i = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1i.apply(this, arguments); }

  function _objectWithoutProperties$1g(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1g(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1g(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const SelectGroup = (_ref) => {
    let {
      children = [],
      className = '',
      label = '',
      titleId = ''
    } = _ref,
        props = _objectWithoutProperties$1g(_ref, ["children", "className", "label", "titleId"]);

    return React.createElement("div", _extends$1i({}, props, {
      className: css$1(styles$k.selectMenuGroup, className)
    }), React.createElement("div", {
      className: css$1(styles$k.selectMenuGroupTitle),
      id: titleId,
      "aria-hidden": true
    }, label), children);
  };
  SelectGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    label: _pt.string,
    titleId: _pt.string
  };

  function _extends$1j() { _extends$1j = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1j.apply(this, arguments); }

  function _objectWithoutProperties$1h(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1h(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1h(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const CheckboxSelectGroup = (_ref) => {
    let {
      children = [],
      className = '',
      label = '',
      titleId = ''
    } = _ref,
        props = _objectWithoutProperties$1h(_ref, ["children", "className", "label", "titleId"]);

    return React.createElement("div", _extends$1j({}, props, {
      className: css$1(styles$k.selectMenuGroup, className)
    }), React.createElement("div", {
      className: css$1(styles$k.selectMenuGroupTitle),
      id: titleId,
      "aria-hidden": true
    }, label), children);
  };
  CheckboxSelectGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    label: _pt.string,
    titleId: _pt.string
  };

  function _extends$1k() { _extends$1k = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1k.apply(this, arguments); }

  function _objectWithoutProperties$1i(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1i(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1i(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$y(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class CheckboxSelectOption extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$y(this, "ref", React.createRef());

      _defineProperty$y(this, "onKeyDown", event => {
        if (event.key === KeyTypes.Tab) {
          return;
        }

        event.preventDefault();

        if (event.key === KeyTypes.ArrowUp) {
          this.props.keyHandler(this.props.index, 'up');
        } else if (event.key === KeyTypes.ArrowDown) {
          this.props.keyHandler(this.props.index, 'down');
        } else if (event.key === KeyTypes.Enter) {
          this.ref.current.click();
          this.ref.current.focus();
        }
      });
    }

    componentDidMount() {
      this.props.sendRef(this.ref.current, this.props.index);
    }

    componentDidUpdate() {
      this.props.sendRef(this.ref.current, this.props.index);
    }

    render() {
      /* eslint-disable @typescript-eslint/no-unused-vars */
      const _this$props = this.props,
            {
        children,
        className,
        value,
        onClick,
        isDisabled,
        isChecked,
        sendRef,
        keyHandler,
        index
      } = _this$props,
            props = _objectWithoutProperties$1i(_this$props, ["children", "className", "value", "onClick", "isDisabled", "isChecked", "sendRef", "keyHandler", "index"]);
      /* eslint-enable @typescript-eslint/no-unused-vars */


      return React.createElement(SelectConsumer, null, ({
        onSelect
      }) => React.createElement("label", _extends$1k({}, props, {
        className: css$1(checkStyles.check, styles$k.selectMenuItem, isDisabled && styles$k.modifiers.disabled, className),
        onKeyDown: this.onKeyDown
      }), React.createElement("input", {
        id: value,
        className: css$1(checkStyles.checkInput),
        type: "checkbox",
        onChange: event => {
          if (!isDisabled) {
            onClick(event);
            onSelect && onSelect(event, value);
          }
        },
        ref: this.ref,
        checked: isChecked || false,
        disabled: isDisabled
      }), React.createElement("span", {
        className: css$1(checkStyles.checkLabel, isDisabled && styles$k.modifiers.disabled)
      }, children || value)));
    }

  }

  _defineProperty$y(CheckboxSelectOption, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    index: _pt.number,
    value: _pt.string,
    isDisabled: _pt.bool,
    isChecked: _pt.bool,
    sendRef: _pt.func,
    keyHandler: _pt.func,
    onClick: _pt.func
  });

  _defineProperty$y(CheckboxSelectOption, "defaultProps", {
    className: '',
    value: '',
    index: 0,
    isDisabled: false,
    isChecked: false,
    onClick: () => {},
    sendRef: () => {},
    keyHandler: () => {}
  });

  function _extends$1l() { _extends$1l = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1l.apply(this, arguments); }

  function _objectWithoutProperties$1j(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1j(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1j(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListItem = (_ref) => {
    let {
      isExpanded = false,
      className = '',
      id = '',
      'aria-labelledby': ariaLabelledBy,
      children
    } = _ref,
        props = _objectWithoutProperties$1j(_ref, ["isExpanded", "className", "id", "aria-labelledby", "children"]);

    return React.createElement(DataListContext.Consumer, null, ({
      isSelectable,
      selectedDataListItemId,
      updateSelectedDataListItem
    }) => {
      const selectDataListItem = event => {
        let target = event.target;

        while (event.currentTarget !== target) {
          if ('onclick' in target && target.onclick || target.parentNode.classList.contains(styles$j.dataListItemAction) || target.parentNode.classList.contains(styles$j.dataListItemControl)) {
            // check other event handlers are not present.
            return;
          } else {
            target = target.parentNode;
          }
        }

        updateSelectedDataListItem(id);
      };

      const onKeyDown = event => {
        if (event.key === KeyTypes.Enter) {
          updateSelectedDataListItem(id);
        }
      };

      return React.createElement("li", _extends$1l({
        id: id,
        className: css$1(styles$j.dataListItem, isExpanded && styles$j.modifiers.expanded, isSelectable && styles$j.modifiers.selectable, selectedDataListItemId && selectedDataListItemId === id && styles$j.modifiers.selected, className),
        "aria-labelledby": ariaLabelledBy
      }, isSelectable && {
        tabIndex: 0,
        onClick: selectDataListItem,
        onKeyDown
      }, isSelectable && selectedDataListItemId === id && {
        'aria-selected': true
      }, props), React.Children.map(children, child => React.isValidElement(child) && React.cloneElement(child, {
        rowid: ariaLabelledBy
      })));
    });
  };
  DataListItem.propTypes = {
    isExpanded: _pt.bool,
    children: _pt.node.isRequired,
    className: _pt.string,
    'aria-labelledby': _pt.string.isRequired,
    id: _pt.string
  };

  function _extends$1m() { _extends$1m = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1m.apply(this, arguments); }

  function _objectWithoutProperties$1k(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1k(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1k(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListItemCells = (_ref) => {
    let {
      className = '',
      dataListCells,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      rowid = ''
    } = _ref,
        props = _objectWithoutProperties$1k(_ref, ["className", "dataListCells", "rowid"]);

    return React.createElement("div", _extends$1m({
      className: css$1(styles$j.dataListItemContent, className)
    }, props), dataListCells);
  };
  DataListItemCells.propTypes = {
    className: _pt.string,
    dataListCells: _pt.node,
    rowid: _pt.string
  };

  function _extends$1n() { _extends$1n = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1n.apply(this, arguments); }

  function _objectWithoutProperties$1l(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1l(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1l(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListItemRow = (_ref) => {
    let {
      children,
      className = '',
      rowid = ''
    } = _ref,
        props = _objectWithoutProperties$1l(_ref, ["children", "className", "rowid"]);

    return React.createElement("div", _extends$1n({
      className: css$1(styles$j.dataListItemRow, className)
    }, props), React.Children.map(children, child => React.isValidElement(child) && React.cloneElement(child, {
      rowid
    })));
  };
  DataListItemRow.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string,
    rowid: _pt.string
  };

  function _extends$1o() { _extends$1o = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1o.apply(this, arguments); }

  function _objectWithoutProperties$1m(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1m(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1m(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListToggle = (_ref) => {
    let {
      className = '',
      isExpanded = false,
      'aria-controls': ariaControls = '',
      'aria-label': ariaLabel = 'Details',
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      'aria-labelledby': ariaLabelledBy = '',
      rowid = '',
      id
    } = _ref,
        props = _objectWithoutProperties$1m(_ref, ["className", "isExpanded", "aria-controls", "aria-label", "aria-labelledby", "rowid", "id"]);

    return React.createElement("div", _extends$1o({
      className: css$1(styles$j.dataListItemControl, className)
    }, props), React.createElement("div", {
      className: css$1(styles$j.dataListToggle)
    }, React.createElement(ButtonWithOuiaContext, {
      id: id,
      variant: exports.ButtonVariant.plain,
      "aria-controls": ariaControls !== '' && ariaControls,
      "aria-label": ariaLabel,
      "aria-labelledby": ariaLabel !== 'Details' ? null : `${rowid} ${id}`,
      "aria-expanded": isExpanded
    }, React.createElement(AngleRightIcon, null))));
  };
  DataListToggle.propTypes = {
    className: _pt.string,
    isExpanded: _pt.bool,
    id: _pt.string.isRequired,
    rowid: _pt.string,
    'aria-labelledby': _pt.string,
    'aria-label': _pt.string,
    'aria-controls': _pt.string
  };

  function _extends$1p() { _extends$1p = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1p.apply(this, arguments); }

  function _objectWithoutProperties$1n(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1n(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1n(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DataListContent = (_ref) => {
    let {
      className = '',
      children = null,
      id = '',
      isHidden = false,
      'aria-label': ariaLabel,
      noPadding = false,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      rowid = ''
    } = _ref,
        props = _objectWithoutProperties$1n(_ref, ["className", "children", "id", "isHidden", "aria-label", "noPadding", "rowid"]);

    return React.createElement("section", _extends$1p({
      id: id,
      className: css$1(styles$j.dataListExpandableContent, className),
      hidden: isHidden,
      "aria-label": ariaLabel
    }, props), React.createElement("div", {
      className: css$1(styles$j.dataListExpandableContentBody, noPadding && styles$j.modifiers.noPadding)
    }, children));
  };
  DataListContent.propTypes = {
    children: _pt.node,
    className: _pt.string,
    id: _pt.string,
    rowid: _pt.string,
    isHidden: _pt.bool,
    noPadding: _pt.bool,
    'aria-label': _pt.string.isRequired
  };

  var emptyState = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      emptyState: 'pf-c-empty-state',
      button: 'pf-c-button',
      emptyStatePrimary: 'pf-c-empty-state__primary',
      emptyStateSecondary: 'pf-c-empty-state__secondary',
      emptyStateBody: 'pf-c-empty-state__body',
      emptyStateIcon: 'pf-c-empty-state__icon',
      title: 'pf-c-title',
      modifiers: {
          'primary': 'pf-m-primary',
          'sm': 'pf-m-sm',
          'lg': 'pf-m-lg',
          'xl': 'pf-m-xl',
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var styles$n = unwrapExports(emptyState);

  function _extends$1q() { _extends$1q = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1q.apply(this, arguments); }

  function _objectWithoutProperties$1o(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1o(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1o(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (EmptyStateVariant) {
    EmptyStateVariant["xl"] = "xl";
    EmptyStateVariant["large"] = "large";
    EmptyStateVariant["small"] = "small";
    EmptyStateVariant["full"] = "full";
  })(exports.EmptyStateVariant || (exports.EmptyStateVariant = {}));

  const maxWidthModifiers = {
    xl: 'xl',
    large: 'lg',
    small: 'sm',
    full: ''
  };
  const EmptyState = (_ref) => {
    let {
      children,
      className = '',
      variant = exports.EmptyStateVariant.large
    } = _ref,
        props = _objectWithoutProperties$1o(_ref, ["children", "className", "variant"]);

    const maxWidthModifier = maxWidthModifiers[variant];
    return React.createElement("div", _extends$1q({
      className: css$1(styles$n.emptyState, getModifier(styles$n, maxWidthModifier, null), className)
    }, props), children);
  };
  EmptyState.propTypes = {
    className: _pt.string,
    children: _pt.node.isRequired,
    variant: _pt.oneOf(['small', 'large', 'full', 'xl'])
  };

  function _extends$1r() { _extends$1r = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1r.apply(this, arguments); }

  function _objectWithoutProperties$1p(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1p(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1p(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const EmptyStateBody = (_ref) => {
    let {
      children,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1p(_ref, ["children", "className"]);

    return React.createElement("div", _extends$1r({
      className: css$1(styles$n.emptyStateBody, className)
    }, props), children);
  };
  EmptyStateBody.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$1s() { _extends$1s = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1s.apply(this, arguments); }

  function _objectWithoutProperties$1q(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1q(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1q(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (IconSize) {
    IconSize["sm"] = "sm";
    IconSize["md"] = "md";
    IconSize["lg"] = "lg";
    IconSize["xl"] = "xl";
  })(exports.IconSize || (exports.IconSize = {}));

  const EmptyStateIcon = (_ref) => {
    let {
      className = '',
      icon: IconComponent = null,
      component: AnyComponent = null,
      variant = 'icon'
    } = _ref,
        props = _objectWithoutProperties$1q(_ref, ["className", "icon", "component", "variant"]);

    const classNames = css$1(styles$n.emptyStateIcon, className);
    return variant === 'icon' ? React.createElement(IconComponent, _extends$1s({
      className: classNames
    }, props, {
      "aria-hidden": "true"
    })) : React.createElement("div", {
      className: classNames
    }, React.createElement(AnyComponent, null));
  };
  EmptyStateIcon.propTypes = {
    color: _pt.string,
    size: _pt.oneOf(['sm', 'md', 'lg', 'xl']),
    title: _pt.string,
    className: _pt.string,
    icon: _pt.oneOfType([_pt.string, _pt.any]),
    component: _pt.any,
    variant: _pt.oneOf(['icon', 'container'])
  };

  function _extends$1t() { _extends$1t = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1t.apply(this, arguments); }

  function _objectWithoutProperties$1r(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1r(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1r(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const EmptyStateSecondaryActions = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1r(_ref, ["children", "className"]);

    return React.createElement("div", _extends$1t({
      className: css$1(styles$n.emptyStateSecondary, className)
    }, props), children);
  };
  EmptyStateSecondaryActions.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$1u() { _extends$1u = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1u.apply(this, arguments); }

  function _objectWithoutProperties$1s(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1s(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1s(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const EmptyStatePrimary = (_ref) => {
    let {
      children,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1s(_ref, ["children", "className"]);

    return React.createElement("div", _extends$1u({
      className: css$1(styles$n.emptyStatePrimary, className)
    }, props), children);
  };
  EmptyStatePrimary.propTypes = {
    className: _pt.string,
    children: _pt.node.isRequired
  };

  var expandable = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      expandable: 'pf-c-expandable',
      expandableToggleIcon: 'pf-c-expandable__toggle-icon',
      expandableToggle: 'pf-c-expandable__toggle',
      expandableContent: 'pf-c-expandable__content',
      modifiers: {
          'expanded': 'pf-m-expanded',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus',
          'redhatFont': 'pf-m-redhat-font'
      }
  };
  });

  var styles$o = unwrapExports(expandable);

  function _extends$1v() { _extends$1v = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1v.apply(this, arguments); }

  function _objectWithoutProperties$1t(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1t(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1t(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$z(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class Expandable extends React.Component {
    constructor(props) {
      super(props);
      this.state = {
        isExpanded: props.isExpanded
      };
    }

    calculateToggleText(toggleText, toggleTextExpanded, toggleTextCollapsed, propOrStateIsExpanded) {
      if (propOrStateIsExpanded && toggleTextExpanded !== '') {
        return toggleTextExpanded;
      }

      if (!propOrStateIsExpanded && toggleTextCollapsed !== '') {
        return toggleTextCollapsed;
      }

      return toggleText;
    }

    render() {
      const _this$props = this.props,
            {
        onToggle: onToggleProp,
        isFocused,
        isHovered,
        isActive,
        className,
        toggleText,
        toggleTextExpanded,
        toggleTextCollapsed,
        children,
        isExpanded
      } = _this$props,
            props = _objectWithoutProperties$1t(_this$props, ["onToggle", "isFocused", "isHovered", "isActive", "className", "toggleText", "toggleTextExpanded", "toggleTextCollapsed", "children", "isExpanded"]);

      let onToggle = onToggleProp;
      let propOrStateIsExpanded = isExpanded; // uncontrolled

      if (isExpanded === undefined) {
        propOrStateIsExpanded = this.state.isExpanded;

        onToggle = () => {
          onToggleProp();
          this.setState(prevState => ({
            isExpanded: !prevState.isExpanded
          }));
        };
      }

      const computedToggleText = this.calculateToggleText(toggleText, toggleTextExpanded, toggleTextCollapsed, propOrStateIsExpanded);
      return React.createElement("div", _extends$1v({}, props, {
        className: css$1(styles$o.expandable, propOrStateIsExpanded && styles$o.modifiers.expanded, className)
      }), React.createElement("button", {
        className: css$1(styles$o.expandableToggle, isFocused && styles$o.modifiers.focus, isHovered && styles$o.modifiers.hover, isActive && styles$o.modifiers.active),
        type: "button",
        "aria-expanded": propOrStateIsExpanded,
        onClick: onToggle
      }, React.createElement(AngleRightIcon, {
        className: css$1(styles$o.expandableToggleIcon),
        "aria-hidden": true
      }), React.createElement("span", null, computedToggleText)), React.createElement("div", {
        className: css$1(styles$o.expandableContent),
        hidden: !propOrStateIsExpanded
      }, children));
    }

  }

  _defineProperty$z(Expandable, "propTypes", {
    children: _pt.node.isRequired,
    className: _pt.string,
    isExpanded: _pt.bool,
    toggleText: _pt.string,
    toggleTextExpanded: _pt.string,
    toggleTextCollapsed: _pt.string,
    onToggle: _pt.func,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isActive: _pt.bool
  });

  _defineProperty$z(Expandable, "defaultProps", {
    className: '',
    toggleText: '',
    toggleTextExpanded: '',
    toggleTextCollapsed: '',
    onToggle: () => undefined,
    isFocused: false,
    isActive: false,
    isHovered: false
  });

  var fileUpload = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      fileUpload: 'pf-c-file-upload',
      fileUploadFileDetails: 'pf-c-file-upload__file-details',
      fileUploadFileSelect: 'pf-c-file-upload__file-select',
      button: 'pf-c-button',
      formControl: 'pf-c-form-control',
      fileUploadFileDetailsSpinner: 'pf-c-file-upload__file-details-spinner',
      modifiers: {
          'dragHover': 'pf-m-drag-hover',
          'loading': 'pf-m-loading',
          'control': 'pf-m-control',
          'disabled': 'pf-m-disabled'
      }
  };
  });

  var styles$p = unwrapExports(fileUpload);

  var spinner = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      spinner: 'pf-c-spinner',
      spinnerClipper: 'pf-c-spinner__clipper',
      spinnerLeadBall: 'pf-c-spinner__lead-ball',
      spinnerTailBall: 'pf-c-spinner__tail-ball',
      modifiers: {
          'sm': 'pf-m-sm',
          'md': 'pf-m-md',
          'lg': 'pf-m-lg',
          'xl': 'pf-m-xl'
      }
  };
  });

  var styles$q = unwrapExports(spinner);

  function _extends$1w() { _extends$1w = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1w.apply(this, arguments); }

  function _objectWithoutProperties$1u(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1u(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1u(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (spinnerSize) {
    spinnerSize["sm"] = "sm";
    spinnerSize["md"] = "md";
    spinnerSize["lg"] = "lg";
    spinnerSize["xl"] = "xl";
  })(exports.spinnerSize || (exports.spinnerSize = {}));

  const Spinner = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      size = 'xl',
      'aria-valuetext': ariaValueText = 'Loading...'
    } = _ref,
        props = _objectWithoutProperties$1u(_ref, ["className", "size", "aria-valuetext"]);

    return React.createElement("span", _extends$1w({
      className: css$1(styles$q.spinner, getModifier(styles$q, size)),
      role: "progressbar",
      "aria-valuetext": ariaValueText
    }, props), React.createElement("span", {
      className: css$1(styles$q.spinnerClipper)
    }), React.createElement("span", {
      className: css$1(styles$q.spinnerLeadBall)
    }), React.createElement("span", {
      className: css$1(styles$q.spinnerTailBall)
    }));
  };
  Spinner.propTypes = {
    className: _pt.string,
    size: _pt.oneOf(['sm', 'md', 'lg', 'xl']),
    'aria-valuetext': _pt.string
  };

  let fileReaderType;
  /**
   * Read a file using the FileReader API, either as a plain text string or as a DataURL string.
   * Returns a promise which will resolve with the file contents as a string or reject with a DOMException.
   *
   * @param {File} fileHandle - File object to read
   * @param {fileReaderType} type - How to read it
   */

  (function (fileReaderType) {
    fileReaderType["text"] = "text";
    fileReaderType["dataURL"] = "dataURL";
  })(fileReaderType || (fileReaderType = {}));

  function readFile(fileHandle, type) {
    return new Promise((resolve, reject) => {
      const reader = new FileReader();

      reader.onload = () => resolve(reader.result);

      reader.onerror = () => reject(reader.error);

      if (type === fileReaderType.text) {
        reader.readAsText(fileHandle);
      } else if (type === fileReaderType.dataURL) {
        reader.readAsDataURL(fileHandle);
      } else {
        reject('unknown type');
      }
    });
  }

  function _extends$1x() { _extends$1x = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1x.apply(this, arguments); }

  function _objectWithoutProperties$1v(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1v(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1v(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const FileUploadField = (_ref) => {
    let {
      id,
      type,
      value = '',
      filename = '',
      onChange = () => {},
      onBrowseButtonClick = () => {},
      onClearButtonClick = () => {},
      className = '',
      isDisabled = false,
      isReadOnly = false,
      isLoading = false,
      spinnerAriaValueText,
      isRequired = false,
      isDragActive = false,
      validated = 'default',
      'aria-label': ariaLabel = 'File upload',
      filenamePlaceholder = 'Drag a file here or browse to upload',
      filenameAriaLabel = filename ? 'Read only filename' : filenamePlaceholder,
      browseButtonText = 'Browse...',
      clearButtonText = 'Clear',
      isClearButtonDisabled = !filename && !value,
      containerRef = null,
      allowEditingUploadedText = false,
      hideDefaultPreview = false,
      children = null
    } = _ref,
        props = _objectWithoutProperties$1v(_ref, ["id", "type", "value", "filename", "onChange", "onBrowseButtonClick", "onClearButtonClick", "className", "isDisabled", "isReadOnly", "isLoading", "spinnerAriaValueText", "isRequired", "isDragActive", "validated", "aria-label", "filenamePlaceholder", "filenameAriaLabel", "browseButtonText", "clearButtonText", "isClearButtonDisabled", "containerRef", "allowEditingUploadedText", "hideDefaultPreview", "children"]);

    const onTextAreaChange = (newValue, event) => {
      onChange(newValue, filename, event);
    };

    return React.createElement("div", _extends$1x({
      className: css$1(styles$p.fileUpload, isDragActive && styles$p.modifiers.dragHover, isLoading && styles$p.modifiers.loading, className),
      ref: containerRef
    }, props), React.createElement("div", {
      className: styles$p.fileUploadFileSelect
    }, React.createElement(InputGroup, null, React.createElement(TextInput, {
      isReadOnly: true // Always read-only regardless of isReadOnly prop (which is just for the TextArea)
      ,
      isDisabled: isDisabled,
      id: `${id}-filename`,
      name: `${id}-filename`,
      "aria-label": filenameAriaLabel,
      placeholder: filenamePlaceholder,
      "aria-describedby": `${id}-browse-button`,
      value: filename
    }), React.createElement(ButtonWithOuiaContext, {
      id: `${id}-browse-button`,
      variant: exports.ButtonVariant.control,
      onClick: onBrowseButtonClick,
      isDisabled: isDisabled
    }, browseButtonText), React.createElement(ButtonWithOuiaContext, {
      variant: exports.ButtonVariant.control,
      isDisabled: isDisabled || isClearButtonDisabled,
      onClick: onClearButtonClick
    }, clearButtonText))), React.createElement("div", {
      className: styles$p.fileUploadFileDetails
    }, !hideDefaultPreview && type === fileReaderType.text && React.createElement(TextArea, {
      readOnly: isReadOnly || !!filename && !allowEditingUploadedText,
      disabled: isDisabled,
      isRequired: isRequired,
      resizeOrientation: exports.TextAreResizeOrientation.vertical,
      validated: validated,
      id: id,
      name: id,
      "aria-label": ariaLabel,
      value: value,
      onChange: onTextAreaChange
    }), isLoading && React.createElement("div", {
      className: styles$p.fileUploadFileDetailsSpinner
    }, React.createElement(Spinner, {
      size: exports.spinnerSize.lg,
      "aria-valuetext": spinnerAriaValueText
    }))), children);
  };
  FileUploadField.propTypes = {
    id: _pt.string.isRequired,
    type: _pt.oneOf(['text', 'dataURL']),
    value: _pt.oneOfType([_pt.string, _pt.any]),
    filename: _pt.string,
    onChange: _pt.func,
    className: _pt.string,
    isDisabled: _pt.bool,
    isReadOnly: _pt.bool,
    isLoading: _pt.bool,
    spinnerAriaValueText: _pt.string,
    isRequired: _pt.bool,
    validated: _pt.oneOf(['success', 'error', 'default']),
    'aria-label': _pt.string,
    filenamePlaceholder: _pt.string,
    filenameAriaLabel: _pt.string,
    browseButtonText: _pt.string,
    clearButtonText: _pt.string,
    isClearButtonDisabled: _pt.bool,
    hideDefaultPreview: _pt.bool,
    allowEditingUploadedText: _pt.bool,
    children: _pt.node,
    onBrowseButtonClick: _pt.func,
    onClearButtonClick: _pt.func,
    isDragActive: _pt.bool,
    containerRef: _pt.oneOfType([_pt.string, _pt.func, _pt.object])
  };

  /*! *****************************************************************************
  Copyright (c) Microsoft Corporation. All rights reserved.
  Licensed under the Apache License, Version 2.0 (the "License"); you may not use
  this file except in compliance with the License. You may obtain a copy of the
  License at http://www.apache.org/licenses/LICENSE-2.0

  THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
  WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
  MERCHANTABLITY OR NON-INFRINGEMENT.

  See the Apache Version 2.0 License for specific language governing permissions
  and limitations under the License.
  ***************************************************************************** */

  function __awaiter(thisArg, _arguments, P, generator) {
      return new (P || (P = Promise))(function (resolve, reject) {
          function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
          function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
          function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
          step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
  }

  function __generator(thisArg, body) {
      var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
      function verb(n) { return function (v) { return step([n, v]); }; }
      function step(op) {
          if (f) throw new TypeError("Generator is already executing.");
          while (_) try {
              if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
              if (y = 0, t) op = [op[0] & 2, t.value];
              switch (op[0]) {
                  case 0: case 1: t = op; break;
                  case 4: _.label++; return { value: op[1], done: false };
                  case 5: _.label++; y = op[1]; op = [0]; continue;
                  case 7: op = _.ops.pop(); _.trys.pop(); continue;
                  default:
                      if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                      if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                      if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                      if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                      if (t[2]) _.ops.pop();
                      _.trys.pop(); continue;
              }
              op = body.call(thisArg, _);
          } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
          if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
      }
  }

  function __read(o, n) {
      var m = typeof Symbol === "function" && o[Symbol.iterator];
      if (!m) return o;
      var i = m.call(o), r, ar = [], e;
      try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
      }
      catch (error) { e = { error: error }; }
      finally {
          try {
              if (r && !r.done && (m = i["return"])) m.call(i);
          }
          finally { if (e) throw e.error; }
      }
      return ar;
  }

  function __spread() {
      for (var ar = [], i = 0; i < arguments.length; i++)
          ar = ar.concat(__read(arguments[i]));
      return ar;
  }

  var COMMON_MIME_TYPES = new Map([
      ['avi', 'video/avi'],
      ['gif', 'image/gif'],
      ['ico', 'image/x-icon'],
      ['jpeg', 'image/jpeg'],
      ['jpg', 'image/jpeg'],
      ['mkv', 'video/x-matroska'],
      ['mov', 'video/quicktime'],
      ['mp4', 'video/mp4'],
      ['pdf', 'application/pdf'],
      ['png', 'image/png'],
      ['zip', 'application/zip'],
      ['doc', 'application/msword'],
      ['docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document']
  ]);
  function toFileWithPath(file, path) {
      var f = withMimeType(file);
      if (typeof f.path !== 'string') { // on electron, path is already set to the absolute path
          var webkitRelativePath = file.webkitRelativePath;
          Object.defineProperty(f, 'path', {
              value: typeof path === 'string'
                  ? path
                  // If <input webkitdirectory> is set,
                  // the File will have a {webkitRelativePath} property
                  // https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/webkitdirectory
                  : typeof webkitRelativePath === 'string' && webkitRelativePath.length > 0
                      ? webkitRelativePath
                      : file.name,
              writable: false,
              configurable: false,
              enumerable: true
          });
      }
      return f;
  }
  function withMimeType(file) {
      var name = file.name;
      var hasExtension = name && name.lastIndexOf('.') !== -1;
      if (hasExtension && !file.type) {
          var ext = name.split('.')
              .pop().toLowerCase();
          var type = COMMON_MIME_TYPES.get(ext);
          if (type) {
              Object.defineProperty(file, 'type', {
                  value: type,
                  writable: false,
                  configurable: false,
                  enumerable: true
              });
          }
      }
      return file;
  }

  var FILES_TO_IGNORE = [
      // Thumbnail cache files for macOS and Windows
      '.DS_Store',
      'Thumbs.db' // Windows
  ];
  /**
   * Convert a DragEvent's DataTrasfer object to a list of File objects
   * NOTE: If some of the items are folders,
   * everything will be flattened and placed in the same list but the paths will be kept as a {path} property.
   * @param evt
   */
  function fromEvent(evt) {
      return __awaiter(this, void 0, void 0, function () {
          return __generator(this, function (_a) {
              return [2 /*return*/, isDragEvt(evt) && evt.dataTransfer
                      ? getDataTransferFiles(evt.dataTransfer, evt.type)
                      : getInputFiles(evt)];
          });
      });
  }
  function isDragEvt(value) {
      return !!value.dataTransfer;
  }
  function getInputFiles(evt) {
      var files = isInput$1(evt.target)
          ? evt.target.files
              ? fromList(evt.target.files)
              : []
          : [];
      return files.map(function (file) { return toFileWithPath(file); });
  }
  function isInput$1(value) {
      return value !== null;
  }
  function getDataTransferFiles(dt, type) {
      return __awaiter(this, void 0, void 0, function () {
          var items, files;
          return __generator(this, function (_a) {
              switch (_a.label) {
                  case 0:
                      if (!dt.items) return [3 /*break*/, 2];
                      items = fromList(dt.items)
                          .filter(function (item) { return item.kind === 'file'; });
                      // According to https://html.spec.whatwg.org/multipage/dnd.html#dndevents,
                      // only 'dragstart' and 'drop' has access to the data (source node)
                      if (type !== 'drop') {
                          return [2 /*return*/, items];
                      }
                      return [4 /*yield*/, Promise.all(items.map(toFilePromises))];
                  case 1:
                      files = _a.sent();
                      return [2 /*return*/, noIgnoredFiles(flatten(files))];
                  case 2: return [2 /*return*/, noIgnoredFiles(fromList(dt.files)
                          .map(function (file) { return toFileWithPath(file); }))];
              }
          });
      });
  }
  function noIgnoredFiles(files) {
      return files.filter(function (file) { return FILES_TO_IGNORE.indexOf(file.name) === -1; });
  }
  // IE11 does not support Array.from()
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from#Browser_compatibility
  // https://developer.mozilla.org/en-US/docs/Web/API/FileList
  // https://developer.mozilla.org/en-US/docs/Web/API/DataTransferItemList
  function fromList(items) {
      var files = [];
      // tslint:disable: prefer-for-of
      for (var i = 0; i < items.length; i++) {
          var file = items[i];
          files.push(file);
      }
      return files;
  }
  // https://developer.mozilla.org/en-US/docs/Web/API/DataTransferItem
  function toFilePromises(item) {
      if (typeof item.webkitGetAsEntry !== 'function') {
          return fromDataTransferItem(item);
      }
      var entry = item.webkitGetAsEntry();
      // Safari supports dropping an image node from a different window and can be retrieved using
      // the DataTransferItem.getAsFile() API
      // NOTE: FileSystemEntry.file() throws if trying to get the file
      if (entry && entry.isDirectory) {
          return fromDirEntry(entry);
      }
      return fromDataTransferItem(item);
  }
  function flatten(items) {
      return items.reduce(function (acc, files) { return __spread(acc, (Array.isArray(files) ? flatten(files) : [files])); }, []);
  }
  function fromDataTransferItem(item) {
      var file = item.getAsFile();
      if (!file) {
          return Promise.reject(item + " is not a File");
      }
      var fwp = toFileWithPath(file);
      return Promise.resolve(fwp);
  }
  // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemEntry
  function fromEntry(entry) {
      return __awaiter(this, void 0, void 0, function () {
          return __generator(this, function (_a) {
              return [2 /*return*/, entry.isDirectory ? fromDirEntry(entry) : fromFileEntry(entry)];
          });
      });
  }
  // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemDirectoryEntry
  function fromDirEntry(entry) {
      var reader = entry.createReader();
      return new Promise(function (resolve, reject) {
          var entries = [];
          function readEntries() {
              var _this = this;
              // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemDirectoryEntry/createReader
              // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemDirectoryReader/readEntries
              reader.readEntries(function (batch) { return __awaiter(_this, void 0, void 0, function () {
                  var files, err_1, items;
                  return __generator(this, function (_a) {
                      switch (_a.label) {
                          case 0:
                              if (!!batch.length) return [3 /*break*/, 5];
                              _a.label = 1;
                          case 1:
                              _a.trys.push([1, 3, , 4]);
                              return [4 /*yield*/, Promise.all(entries)];
                          case 2:
                              files = _a.sent();
                              resolve(files);
                              return [3 /*break*/, 4];
                          case 3:
                              err_1 = _a.sent();
                              reject(err_1);
                              return [3 /*break*/, 4];
                          case 4: return [3 /*break*/, 6];
                          case 5:
                              items = Promise.all(batch.map(fromEntry));
                              entries.push(items);
                              // Continue reading
                              readEntries();
                              _a.label = 6;
                          case 6: return [2 /*return*/];
                      }
                  });
              }); }, function (err) {
                  reject(err);
              });
          }
          readEntries();
      });
  }
  // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemFileEntry
  function fromFileEntry(entry) {
      return __awaiter(this, void 0, void 0, function () {
          return __generator(this, function (_a) {
              return [2 /*return*/, new Promise(function (resolve, reject) {
                      entry.file(function (file) {
                          var fwp = toFileWithPath(file, entry.fullPath);
                          resolve(fwp);
                      }, function (err) {
                          reject(err);
                      });
                  })];
          });
      });
  }

  var dist = createCommonjsModule(function (module) {
  module.exports=function(t){function n(e){if(r[e])return r[e].exports;var o=r[e]={i:e,l:!1,exports:{}};return t[e].call(o.exports,o,o.exports,n),o.l=!0,o.exports}var r={};return n.m=t,n.c=r,n.d=function(t,r,e){n.o(t,r)||Object.defineProperty(t,r,{configurable:!1,enumerable:!0,get:e});},n.n=function(t){var r=t&&t.__esModule?function(){return t.default}:function(){return t};return n.d(r,"a",r),r},n.o=function(t,n){return Object.prototype.hasOwnProperty.call(t,n)},n.p="",n(n.s=13)}([function(t,n){var r=t.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=r);},function(t,n){t.exports=function(t){return "object"==typeof t?null!==t:"function"==typeof t};},function(t,n){var r=t.exports={version:"2.5.0"};"number"==typeof __e&&(__e=r);},function(t,n,r){t.exports=!r(4)(function(){return 7!=Object.defineProperty({},"a",{get:function(){return 7}}).a});},function(t,n){t.exports=function(t){try{return !!t()}catch(t){return !0}};},function(t,n){var r={}.toString;t.exports=function(t){return r.call(t).slice(8,-1)};},function(t,n,r){var e=r(32)("wks"),o=r(9),i=r(0).Symbol,u="function"==typeof i;(t.exports=function(t){return e[t]||(e[t]=u&&i[t]||(u?i:o)("Symbol."+t))}).store=e;},function(t,n,r){var e=r(0),o=r(2),i=r(8),u=r(22),c=r(10),f=function(t,n,r){var a,s,p,l,v=t&f.F,y=t&f.G,h=t&f.S,d=t&f.P,x=t&f.B,g=y?e:h?e[n]||(e[n]={}):(e[n]||{}).prototype,m=y?o:o[n]||(o[n]={}),b=m.prototype||(m.prototype={});y&&(r=n);for(a in r)s=!v&&g&&void 0!==g[a],p=(s?g:r)[a],l=x&&s?c(p,e):d&&"function"==typeof p?c(Function.call,p):p,g&&u(g,a,p,t&f.U),m[a]!=p&&i(m,a,l),d&&b[a]!=p&&(b[a]=p);};e.core=o,f.F=1,f.G=2,f.S=4,f.P=8,f.B=16,f.W=32,f.U=64,f.R=128,t.exports=f;},function(t,n,r){var e=r(16),o=r(21);t.exports=r(3)?function(t,n,r){return e.f(t,n,o(1,r))}:function(t,n,r){return t[n]=r,t};},function(t,n){var r=0,e=Math.random();t.exports=function(t){return "Symbol(".concat(void 0===t?"":t,")_",(++r+e).toString(36))};},function(t,n,r){var e=r(24);t.exports=function(t,n,r){if(e(t),void 0===n)return t;switch(r){case 1:return function(r){return t.call(n,r)};case 2:return function(r,e){return t.call(n,r,e)};case 3:return function(r,e,o){return t.call(n,r,e,o)}}return function(){return t.apply(n,arguments)}};},function(t,n){t.exports=function(t){if(void 0==t)throw TypeError("Can't call method on  "+t);return t};},function(t,n,r){var e=r(28),o=Math.min;t.exports=function(t){return t>0?o(e(t),9007199254740991):0};},function(t,n,r){n.__esModule=!0,n.default=function(t,n){if(t&&n){var r=Array.isArray(n)?n:n.split(","),e=t.name||"",o=t.type||"",i=o.replace(/\/.*$/,"");return r.some(function(t){var n=t.trim();return "."===n.charAt(0)?e.toLowerCase().endsWith(n.toLowerCase()):n.endsWith("/*")?i===n.replace(/\/.*$/,""):o===n})}return !0},r(14),r(34);},function(t,n,r){r(15),t.exports=r(2).Array.some;},function(t,n,r){var e=r(7),o=r(25)(3);e(e.P+e.F*!r(33)([].some,!0),"Array",{some:function(t){return o(this,t,arguments[1])}});},function(t,n,r){var e=r(17),o=r(18),i=r(20),u=Object.defineProperty;n.f=r(3)?Object.defineProperty:function(t,n,r){if(e(t),n=i(n,!0),e(r),o)try{return u(t,n,r)}catch(t){}if("get"in r||"set"in r)throw TypeError("Accessors not supported!");return "value"in r&&(t[n]=r.value),t};},function(t,n,r){var e=r(1);t.exports=function(t){if(!e(t))throw TypeError(t+" is not an object!");return t};},function(t,n,r){t.exports=!r(3)&&!r(4)(function(){return 7!=Object.defineProperty(r(19)("div"),"a",{get:function(){return 7}}).a});},function(t,n,r){var e=r(1),o=r(0).document,i=e(o)&&e(o.createElement);t.exports=function(t){return i?o.createElement(t):{}};},function(t,n,r){var e=r(1);t.exports=function(t,n){if(!e(t))return t;var r,o;if(n&&"function"==typeof(r=t.toString)&&!e(o=r.call(t)))return o;if("function"==typeof(r=t.valueOf)&&!e(o=r.call(t)))return o;if(!n&&"function"==typeof(r=t.toString)&&!e(o=r.call(t)))return o;throw TypeError("Can't convert object to primitive value")};},function(t,n){t.exports=function(t,n){return {enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:n}};},function(t,n,r){var e=r(0),o=r(8),i=r(23),u=r(9)("src"),c=Function.toString,f=(""+c).split("toString");r(2).inspectSource=function(t){return c.call(t)},(t.exports=function(t,n,r,c){var a="function"==typeof r;a&&(i(r,"name")||o(r,"name",n)),t[n]!==r&&(a&&(i(r,u)||o(r,u,t[n]?""+t[n]:f.join(String(n)))),t===e?t[n]=r:c?t[n]?t[n]=r:o(t,n,r):(delete t[n],o(t,n,r)));})(Function.prototype,"toString",function(){return "function"==typeof this&&this[u]||c.call(this)});},function(t,n){var r={}.hasOwnProperty;t.exports=function(t,n){return r.call(t,n)};},function(t,n){t.exports=function(t){if("function"!=typeof t)throw TypeError(t+" is not a function!");return t};},function(t,n,r){var e=r(10),o=r(26),i=r(27),u=r(12),c=r(29);t.exports=function(t,n){var r=1==t,f=2==t,a=3==t,s=4==t,p=6==t,l=5==t||p,v=n||c;return function(n,c,y){for(var h,d,x=i(n),g=o(x),m=e(c,y,3),b=u(g.length),_=0,w=r?v(n,b):f?v(n,0):void 0;b>_;_++)if((l||_ in g)&&(h=g[_],d=m(h,_,x),t))if(r)w[_]=d;else if(d)switch(t){case 3:return !0;case 5:return h;case 6:return _;case 2:w.push(h);}else if(s)return !1;return p?-1:a||s?s:w}};},function(t,n,r){var e=r(5);t.exports=Object("z").propertyIsEnumerable(0)?Object:function(t){return "String"==e(t)?t.split(""):Object(t)};},function(t,n,r){var e=r(11);t.exports=function(t){return Object(e(t))};},function(t,n){var r=Math.ceil,e=Math.floor;t.exports=function(t){return isNaN(t=+t)?0:(t>0?e:r)(t)};},function(t,n,r){var e=r(30);t.exports=function(t,n){return new(e(t))(n)};},function(t,n,r){var e=r(1),o=r(31),i=r(6)("species");t.exports=function(t){var n;return o(t)&&(n=t.constructor,"function"!=typeof n||n!==Array&&!o(n.prototype)||(n=void 0),e(n)&&null===(n=n[i])&&(n=void 0)),void 0===n?Array:n};},function(t,n,r){var e=r(5);t.exports=Array.isArray||function(t){return "Array"==e(t)};},function(t,n,r){var e=r(0),o=e["__core-js_shared__"]||(e["__core-js_shared__"]={});t.exports=function(t){return o[t]||(o[t]={})};},function(t,n,r){var e=r(4);t.exports=function(t,n){return !!t&&e(function(){n?t.call(null,function(){},1):t.call(null);})};},function(t,n,r){r(35),t.exports=r(2).String.endsWith;},function(t,n,r){var e=r(7),o=r(12),i=r(36),u="".endsWith;e(e.P+e.F*r(38)("endsWith"),"String",{endsWith:function(t){var n=i(this,t,"endsWith"),r=arguments.length>1?arguments[1]:void 0,e=o(n.length),c=void 0===r?e:Math.min(o(r),e),f=String(t);return u?u.call(n,f,c):n.slice(c-f.length,c)===f}});},function(t,n,r){var e=r(37),o=r(11);t.exports=function(t,n,r){if(e(n))throw TypeError("String#"+r+" doesn't accept regex!");return String(o(t))};},function(t,n,r){var e=r(1),o=r(5),i=r(6)("match");t.exports=function(t){var n;return e(t)&&(void 0!==(n=t[i])?!!n:"RegExp"==o(t))};},function(t,n,r){var e=r(6)("match");t.exports=function(t){var n=/./;try{"/./"[t](n);}catch(r){try{return n[e]=!1,!"/./"[t](n)}catch(t){}}return !0};}]);
  });

  var accepts = unwrapExports(dist);

  var supportMultiple = typeof document !== 'undefined' && document && document.createElement ? 'multiple' in document.createElement('input') : true;

  // Firefox versions prior to 53 return a bogus MIME type for every file drag, so dragovers with
  // that MIME type will always be accepted
  function fileAccepted(file, accept) {
    return file.type === 'application/x-moz-file' || accepts(file, accept);
  }

  function fileMatchSize(file, maxSize, minSize) {
    return file.size <= maxSize && file.size >= minSize;
  }

  function allFilesAccepted(files, accept) {
    return files.every(function (file) {
      return fileAccepted(file, accept);
    });
  }

  // React's synthetic events has evt.isPropagationStopped,
  // but to remain compatibility with other libs (Preact) fall back
  // to check evt.cancelBubble
  function isPropagationStopped(evt) {
    if (typeof evt.isPropagationStopped === 'function') {
      return evt.isPropagationStopped();
    } else if (typeof evt.cancelBubble !== 'undefined') {
      return evt.cancelBubble;
    }
    return false;
  }

  // React's synthetic events has evt.isDefaultPrevented,
  // but to remain compatibility with other libs (Preact) first
  // check evt.defaultPrevented
  function isDefaultPrevented(evt) {
    if (typeof evt.defaultPrevented !== 'undefined') {
      return evt.defaultPrevented;
    } else if (typeof evt.isDefaultPrevented === 'function') {
      return evt.isDefaultPrevented();
    }
    return false;
  }

  function isDragDataWithFiles(evt) {
    if (!evt.dataTransfer) {
      return true;
    }
    // https://developer.mozilla.org/en-US/docs/Web/API/DataTransfer/types
    // https://developer.mozilla.org/en-US/docs/Web/API/HTML_Drag_and_Drop_API/Recommended_drag_types#file
    return Array.prototype.some.call(evt.dataTransfer.types, function (type) {
      return type === 'Files' || type === 'application/x-moz-file';
    });
  }

  // allow the entire document to be a drag target
  function onDocumentDragOver(evt) {
    evt.preventDefault();
  }

  function isIe(userAgent) {
    return userAgent.indexOf('MSIE') !== -1 || userAgent.indexOf('Trident/') !== -1;
  }

  function isEdge(userAgent) {
    return userAgent.indexOf('Edge/') !== -1;
  }

  function isIeOrEdge() {
    var userAgent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window.navigator.userAgent;

    return isIe(userAgent) || isEdge(userAgent);
  }

  /**
   * This is intended to be used to compose event handlers
   * They are executed in order until one of them calls `event.preventDefault()`.
   * Not sure this is the best way to do this, but it seems legit.
   * @param {Function} fns the event hanlder functions
   * @return {Function} the event handler to add to an element
   */
  function composeEventHandlers() {
    for (var _len = arguments.length, fns = Array(_len), _key = 0; _key < _len; _key++) {
      fns[_key] = arguments[_key];
    }

    return function (event) {
      for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      return fns.some(function (fn) {
        fn && fn.apply(undefined, [event].concat(args));
        return event.defaultPrevented;
      });
    };
  }

  var _extends$1y = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

  function _defineProperty$A(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _objectWithoutProperties$1w(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

  function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

  function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

  function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

  var Dropzone = function (_React$Component) {
    _inherits(Dropzone, _React$Component);

    function Dropzone() {
      var _ref;

      var _temp, _this, _ret;

      _classCallCheck(this, Dropzone);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Dropzone.__proto__ || Object.getPrototypeOf(Dropzone)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
        draggedFiles: [],
        acceptedFiles: [],
        rejectedFiles: []
      }, _this.isFileDialogActive = false, _this.onDocumentDrop = function (evt) {
        if (_this.node && _this.node.contains(evt.target)) {
          // if we intercepted an event for our instance, let it propagate down to the instance's onDrop handler
          return;
        }
        evt.preventDefault();
        _this.dragTargets = [];
      }, _this.onDragStart = function (evt) {
        evt.persist();
        if (_this.props.onDragStart && isDragDataWithFiles(evt)) {
          _this.props.onDragStart.call(_this, evt);
        }
      }, _this.onDragEnter = function (evt) {
        evt.preventDefault();

        // Count the dropzone and any children that are entered.
        if (_this.dragTargets.indexOf(evt.target) === -1) {
          _this.dragTargets.push(evt.target);
        }

        evt.persist();

        if (isDragDataWithFiles(evt)) {
          Promise.resolve(_this.props.getDataTransferItems(evt)).then(function (draggedFiles) {
            if (isPropagationStopped(evt)) {
              return;
            }

            _this.setState({
              draggedFiles: draggedFiles,
              // Do not rely on files for the drag state. It doesn't work in Safari.
              isDragActive: true
            });
          });

          if (_this.props.onDragEnter) {
            _this.props.onDragEnter.call(_this, evt);
          }
        }
      }, _this.onDragOver = function (evt) {
        // eslint-disable-line class-methods-use-this
        evt.preventDefault();
        evt.persist();

        if (evt.dataTransfer) {
          evt.dataTransfer.dropEffect = 'copy';
        }

        if (_this.props.onDragOver && isDragDataWithFiles(evt)) {
          _this.props.onDragOver.call(_this, evt);
        }

        return false;
      }, _this.onDragLeave = function (evt) {
        evt.preventDefault();
        evt.persist();

        // Only deactivate once the dropzone and all children have been left.
        _this.dragTargets = _this.dragTargets.filter(function (el) {
          return el !== evt.target && _this.node.contains(el);
        });
        if (_this.dragTargets.length > 0) {
          return;
        }

        // Clear dragging files state
        _this.setState({
          isDragActive: false,
          draggedFiles: []
        });

        if (_this.props.onDragLeave && isDragDataWithFiles(evt)) {
          _this.props.onDragLeave.call(_this, evt);
        }
      }, _this.onDrop = function (evt) {
        var _this$props = _this.props,
            onDrop = _this$props.onDrop,
            onDropAccepted = _this$props.onDropAccepted,
            onDropRejected = _this$props.onDropRejected,
            multiple = _this$props.multiple,
            accept = _this$props.accept,
            getDataTransferItems = _this$props.getDataTransferItems;

        // Stop default browser behavior

        evt.preventDefault();

        // Persist event for later usage
        evt.persist();

        // Reset the counter along with the drag on a drop.
        _this.dragTargets = [];
        _this.isFileDialogActive = false;

        // Clear files value
        _this.draggedFiles = null;

        // Reset drag state
        _this.setState({
          isDragActive: false,
          draggedFiles: []
        });

        if (isDragDataWithFiles(evt)) {
          Promise.resolve(getDataTransferItems(evt)).then(function (fileList) {
            var acceptedFiles = [];
            var rejectedFiles = [];

            if (isPropagationStopped(evt)) {
              return;
            }

            fileList.forEach(function (file) {
              if (fileAccepted(file, accept) && fileMatchSize(file, _this.props.maxSize, _this.props.minSize)) {
                acceptedFiles.push(file);
              } else {
                rejectedFiles.push(file);
              }
            });

            if (!multiple && acceptedFiles.length > 1) {
              // if not in multi mode add any extra accepted files to rejected.
              // This will allow end users to easily ignore a multi file drop in "single" mode.
              rejectedFiles.push.apply(rejectedFiles, _toConsumableArray(acceptedFiles.splice(0)));
            }

            // Update `acceptedFiles` and `rejectedFiles` state
            // This will make children render functions receive the appropriate
            // values
            _this.setState({ acceptedFiles: acceptedFiles, rejectedFiles: rejectedFiles }, function () {
              if (onDrop) {
                onDrop.call(_this, acceptedFiles, rejectedFiles, evt);
              }

              if (rejectedFiles.length > 0 && onDropRejected) {
                onDropRejected.call(_this, rejectedFiles, evt);
              }

              if (acceptedFiles.length > 0 && onDropAccepted) {
                onDropAccepted.call(_this, acceptedFiles, evt);
              }
            });
          });
        }
      }, _this.onClick = function (evt) {
        var onClick = _this.props.onClick;

        // if onClick prop is given, run it first

        if (onClick) {
          onClick.call(_this, evt);
        }

        // If the event hasn't been default prevented from within
        // the onClick listener, open the file dialog
        if (!isDefaultPrevented(evt)) {
          evt.stopPropagation();

          // in IE11/Edge the file-browser dialog is blocking, ensure this is behind setTimeout
          // this is so react can handle state changes in the onClick prop above above
          // see: https://github.com/react-dropzone/react-dropzone/issues/450
          if (isIeOrEdge()) {
            setTimeout(_this.open, 0);
          } else {
            _this.open();
          }
        }
      }, _this.onInputElementClick = function (evt) {
        evt.stopPropagation();
      }, _this.onFileDialogCancel = function () {
        // timeout will not recognize context of this method
        var onFileDialogCancel = _this.props.onFileDialogCancel;
        // execute the timeout only if the FileDialog is opened in the browser

        if (_this.isFileDialogActive) {
          setTimeout(function () {
            if (_this.input != null) {
              // Returns an object as FileList
              var files = _this.input.files;


              if (!files.length) {
                _this.isFileDialogActive = false;

                if (typeof onFileDialogCancel === 'function') {
                  onFileDialogCancel();
                }
              }
            }
          }, 300);
        }
      }, _this.onFocus = function (evt) {
        var onFocus = _this.props.onFocus;

        if (onFocus) {
          onFocus.call(_this, evt);
        }
        if (!isDefaultPrevented(evt)) {
          _this.setState({ isFocused: true });
        }
      }, _this.onBlur = function (evt) {
        var onBlur = _this.props.onBlur;

        if (onBlur) {
          onBlur.call(_this, evt);
        }
        if (!isDefaultPrevented(evt)) {
          _this.setState({ isFocused: false });
        }
      }, _this.onKeyDown = function (evt) {
        var onKeyDown = _this.props.onKeyDown;

        if (!_this.node.isEqualNode(evt.target)) {
          return;
        }

        if (onKeyDown) {
          onKeyDown.call(_this, evt);
        }

        if (!isDefaultPrevented(evt) && (evt.keyCode === 32 || evt.keyCode === 13)) {
          evt.preventDefault();
          _this.open();
        }
      }, _this.composeHandler = function (handler) {
        if (_this.props.disabled) {
          return null;
        }
        return handler;
      }, _this.getRootProps = function () {
        var _extends2;

        var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        var _ref2$refKey = _ref2.refKey,
            refKey = _ref2$refKey === undefined ? 'ref' : _ref2$refKey,
            onKeyDown = _ref2.onKeyDown,
            onFocus = _ref2.onFocus,
            onBlur = _ref2.onBlur,
            onClick = _ref2.onClick,
            onDragStart = _ref2.onDragStart,
            onDragEnter = _ref2.onDragEnter,
            onDragOver = _ref2.onDragOver,
            onDragLeave = _ref2.onDragLeave,
            onDrop = _ref2.onDrop,
            rest = _objectWithoutProperties$1w(_ref2, ['refKey', 'onKeyDown', 'onFocus', 'onBlur', 'onClick', 'onDragStart', 'onDragEnter', 'onDragOver', 'onDragLeave', 'onDrop']);

        return _extends$1y((_extends2 = {
          onKeyDown: _this.composeHandler(onKeyDown ? composeEventHandlers(onKeyDown, _this.onKeyDown) : _this.onKeyDown),
          onFocus: _this.composeHandler(onFocus ? composeEventHandlers(onFocus, _this.onFocus) : _this.onFocus),
          onBlur: _this.composeHandler(onBlur ? composeEventHandlers(onBlur, _this.onBlur) : _this.onBlur),
          onClick: _this.composeHandler(onClick ? composeEventHandlers(onClick, _this.onClick) : _this.onClick),
          onDragStart: _this.composeHandler(onDragStart ? composeEventHandlers(onDragStart, _this.onDragStart) : _this.onDragStart),
          onDragEnter: _this.composeHandler(onDragEnter ? composeEventHandlers(onDragEnter, _this.onDragEnter) : _this.onDragEnter),
          onDragOver: _this.composeHandler(onDragOver ? composeEventHandlers(onDragOver, _this.onDragOver) : _this.onDragOver),
          onDragLeave: _this.composeHandler(onDragLeave ? composeEventHandlers(onDragLeave, _this.onDragLeave) : _this.onDragLeave),
          onDrop: _this.composeHandler(onDrop ? composeEventHandlers(onDrop, _this.onDrop) : _this.onDrop)
        }, _defineProperty$A(_extends2, refKey, _this.setNodeRef), _defineProperty$A(_extends2, 'tabIndex', _this.props.disabled ? -1 : 0), _extends2), rest);
      }, _this.getInputProps = function () {
        var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        var _ref3$refKey = _ref3.refKey,
            refKey = _ref3$refKey === undefined ? 'ref' : _ref3$refKey,
            onChange = _ref3.onChange,
            onClick = _ref3.onClick,
            rest = _objectWithoutProperties$1w(_ref3, ['refKey', 'onChange', 'onClick']);

        var _this$props2 = _this.props,
            accept = _this$props2.accept,
            multiple = _this$props2.multiple,
            name = _this$props2.name;

        var inputProps = _defineProperty$A({
          accept: accept,
          type: 'file',
          style: { display: 'none' },
          multiple: supportMultiple && multiple,
          onChange: composeEventHandlers(onChange, _this.onDrop),
          onClick: composeEventHandlers(onClick, _this.onInputElementClick),
          autoComplete: 'off',
          tabIndex: -1
        }, refKey, _this.setInputRef);
        if (name && name.length) {
          inputProps.name = name;
        }
        return _extends$1y({}, inputProps, rest);
      }, _this.setNodeRef = function (node) {
        _this.node = node;
      }, _this.setInputRef = function (input) {
        _this.input = input;
      }, _this.open = function () {
        _this.isFileDialogActive = true;
        if (_this.input) {
          _this.input.value = null;
          _this.input.click();
        }
      }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(Dropzone, [{
      key: 'componentDidMount',
      value: function componentDidMount() {
        var preventDropOnDocument = this.props.preventDropOnDocument;

        this.dragTargets = [];

        if (preventDropOnDocument) {
          document.addEventListener('dragover', onDocumentDragOver, false);
          document.addEventListener('drop', this.onDocumentDrop, false);
        }

        window.addEventListener('focus', this.onFileDialogCancel, false);
      }
    }, {
      key: 'componentWillUnmount',
      value: function componentWillUnmount() {
        var preventDropOnDocument = this.props.preventDropOnDocument;

        if (preventDropOnDocument) {
          document.removeEventListener('dragover', onDocumentDragOver);
          document.removeEventListener('drop', this.onDocumentDrop);
        }

        window.removeEventListener('focus', this.onFileDialogCancel, false);
      }

      /**
       * Open system file upload dialog.
       *
       * @public
       */

    }, {
      key: 'render',
      value: function render() {
        var _props = this.props,
            children = _props.children,
            multiple = _props.multiple,
            disabled = _props.disabled;
        var _state = this.state,
            isDragActive = _state.isDragActive,
            isFocused = _state.isFocused,
            draggedFiles = _state.draggedFiles,
            acceptedFiles = _state.acceptedFiles,
            rejectedFiles = _state.rejectedFiles;


        var filesCount = draggedFiles.length;
        var isMultipleAllowed = multiple || filesCount <= 1;
        var isDragAccept = filesCount > 0 && allFilesAccepted(draggedFiles, this.props.accept);
        var isDragReject = filesCount > 0 && (!isDragAccept || !isMultipleAllowed);

        return children({
          isDragActive: isDragActive,
          isDragAccept: isDragAccept,
          isDragReject: isDragReject,
          draggedFiles: draggedFiles,
          acceptedFiles: acceptedFiles,
          rejectedFiles: rejectedFiles,
          isFocused: isFocused && !disabled,
          getRootProps: this.getRootProps,
          getInputProps: this.getInputProps,
          open: this.open
        });
      }
    }]);

    return Dropzone;
  }(React__default.Component);

  Dropzone.propTypes = {
    /**
     * Allow specific types of files. See https://github.com/okonet/attr-accept for more information.
     * Keep in mind that mime type determination is not reliable across platforms. CSV files,
     * for example, are reported as text/plain under macOS but as application/vnd.ms-excel under
     * Windows. In some cases there might not be a mime type set at all.
     * See: https://github.com/react-dropzone/react-dropzone/issues/276
     */
    accept: _pt.oneOfType([_pt.string, _pt.arrayOf(_pt.string)]),

    /**
     * Render function that renders the actual component
     *
     * @param {Object} props
     * @param {Function} props.getRootProps Returns the props you should apply to the root drop container you render
     * @param {Function} props.getInputProps Returns the props you should apply to hidden file input you render
     * @param {Function} props.open Open the native file selection dialog
     * @param {Boolean} props.isFocused Dropzone area is in focus
     * @param {Boolean} props.isDragActive Active drag is in progress
     * @param {Boolean} props.isDragAccept Dragged files are accepted
     * @param {Boolean} props.isDragReject Some dragged files are rejected
     * @param {Array} props.draggedFiles Files in active drag
     * @param {Array} props.acceptedFiles Accepted files
     * @param {Array} props.rejectedFiles Rejected files
     */
    children: _pt.func,

    /**
     * Enable/disable the dropzone entirely
     */
    disabled: _pt.bool,

    /**
     * If false, allow dropped items to take over the current browser window
     */
    preventDropOnDocument: _pt.bool,

    /**
     * Allow dropping multiple files
     */
    multiple: _pt.bool,

    /**
     * `name` attribute for the input tag
     */
    name: _pt.string,

    /**
     * Maximum file size (in bytes)
     */
    maxSize: _pt.number,

    /**
     * Minimum file size (in bytes)
     */
    minSize: _pt.number,

    /**
     * getDataTransferItems handler
     * @param {Event} event
     * @returns {Array} array of File objects
     */
    getDataTransferItems: _pt.func,

    /**
     * onClick callback
     * @param {Event} event
     */
    onClick: _pt.func,

    /**
     * onFocus callback
     */
    onFocus: _pt.func,

    /**
     * onBlur callback
     */
    onBlur: _pt.func,

    /**
     * onKeyDown callback
     */
    onKeyDown: _pt.func,

    /**
     * The `onDrop` method that accepts two arguments.
     * The first argument represents the accepted files and the second argument the rejected files.
     *
     * ```javascript
     * function onDrop(acceptedFiles, rejectedFiles) {
     *   // do stuff with files...
     * }
     * ```
     *
     * Files are accepted or rejected based on the `accept` prop.
     * This must be a valid [MIME type](http://www.iana.org/assignments/media-types/media-types.xhtml) according to [input element specification](https://www.w3.org/wiki/HTML/Elements/input/file) or a valid file extension.
     *
     * Note that the `onDrop` callback will always be called regardless if the dropped files were accepted or rejected.
     * You can use the `onDropAccepted`/`onDropRejected` props if you'd like to react to a specific event instead of the `onDrop` prop.
     *
     * The `onDrop` callback will provide you with an array of [Files](https://developer.mozilla.org/en-US/docs/Web/API/File) which you can then process and send to a server.
     * For example, with [SuperAgent](https://github.com/visionmedia/superagent) as a http/ajax library:
     *
     * ```javascript
     * function onDrop(acceptedFiles) {
     *   const req = request.post('/upload')
     *   acceptedFiles.forEach(file => {
     *     req.attach(file.name, file)
     *   })
     *   req.end(callback)
     * }
     * ```
     */
    onDrop: _pt.func,

    /**
     * onDropAccepted callback
     */
    onDropAccepted: _pt.func,

    /**
     * onDropRejected callback
     */
    onDropRejected: _pt.func,

    /**
     * onDragStart callback
     */
    onDragStart: _pt.func,

    /**
     * onDragEnter callback
     */
    onDragEnter: _pt.func,

    /**
     * onDragOver callback
     */
    onDragOver: _pt.func,

    /**
     * onDragLeave callback
     */
    onDragLeave: _pt.func,

    /**
     * Provide a callback on clicking the cancel button of the file dialog
     */
    onFileDialogCancel: _pt.func
  };

  Dropzone.defaultProps = {
    preventDropOnDocument: true,
    disabled: false,
    multiple: true,
    maxSize: Infinity,
    minSize: 0,
    getDataTransferItems: fromEvent
  };

  function _extends$1z() { _extends$1z = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1z.apply(this, arguments); }

  function ownKeys$7(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$7(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$7(source, true).forEach(function (key) { _defineProperty$B(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$7(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty$B(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _objectWithoutProperties$1x(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1w(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1w(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const FileUpload = (_ref) => {
    let {
      id,
      type,
      value = type === fileReaderType.text || type === fileReaderType.dataURL ? '' : null,
      filename = '',
      children = null,
      onChange = () => {},
      onReadStarted = () => {},
      onReadFinished = () => {},
      onReadFailed = () => {},
      dropzoneProps = {}
    } = _ref,
        props = _objectWithoutProperties$1x(_ref, ["id", "type", "value", "filename", "children", "onChange", "onReadStarted", "onReadFinished", "onReadFailed", "dropzoneProps"]);

    const onDropAccepted = (acceptedFiles, event) => {
      if (acceptedFiles.length > 0) {
        const fileHandle = acceptedFiles[0];

        if (type === fileReaderType.text || type === fileReaderType.dataURL) {
          onChange('', fileHandle.name, event); // Show the filename while reading

          onReadStarted(fileHandle);
          readFile(fileHandle, type).then(data => {
            onReadFinished(fileHandle);
            onChange(data, fileHandle.name, event);
          }).catch(error => {
            onReadFailed(error, fileHandle);
            onReadFinished(fileHandle);
            onChange('', '', event); // Clear the filename field on a failure
          });
        } else {
          onChange(fileHandle, fileHandle.name, event);
        }
      }

      dropzoneProps.onDropAccepted && dropzoneProps.onDropAccepted(acceptedFiles, event);
    };

    const onDropRejected = (rejectedFiles, event) => {
      if (rejectedFiles.length > 0) {
        onChange('', rejectedFiles[0].name, event);
      }

      dropzoneProps.onDropRejected && dropzoneProps.onDropRejected(rejectedFiles, event);
    };

    const onClearButtonClick = event => {
      onChange('', '', event);
    };

    return React.createElement(Dropzone, _extends$1z({
      multiple: false
    }, dropzoneProps, {
      onDropAccepted: onDropAccepted,
      onDropRejected: onDropRejected
    }), ({
      getRootProps,
      getInputProps,
      isDragActive,
      open
    }) => React.createElement(FileUploadField, _extends$1z({}, getRootProps(_objectSpread$7({}, props, {
      refKey: 'containerRef',
      onClick: event => event.preventDefault() // Prevents clicking TextArea from opening file dialog

    })), {
      tabIndex: null // Omit the unwanted tabIndex from react-dropzone's getRootProps
      ,
      id: id,
      type: type,
      filename: filename,
      value: value,
      onChange: onChange,
      isDragActive: isDragActive,
      onBrowseButtonClick: open,
      onClearButtonClick: onClearButtonClick
    }), React.createElement("input", getInputProps()), children));
  };
  FileUpload.propTypes = {
    id: _pt.string.isRequired,
    type: _pt.oneOf(['text', 'dataURL']),
    value: _pt.oneOfType([_pt.string, _pt.any]),
    filename: _pt.string,
    onChange: _pt.func,
    className: _pt.string,
    isDisabled: _pt.bool,
    isReadOnly: _pt.bool,
    isLoading: _pt.bool,
    spinnerAriaValueText: _pt.string,
    isRequired: _pt.bool,
    validated: _pt.oneOf(['success', 'error', 'default']),
    'aria-label': _pt.string,
    filenamePlaceholder: _pt.string,
    filenameAriaLabel: _pt.string,
    browseButtonText: _pt.string,
    clearButtonText: _pt.string,
    hideDefaultPreview: _pt.bool,
    allowEditingUploadedText: _pt.bool,
    children: _pt.node,
    onReadStarted: _pt.func,
    onReadFinished: _pt.func,
    onReadFailed: _pt.func,
    dropzoneProps: _pt.any
  };

  const FormContext = React.createContext({
    isHorizontal: false
  });

  function _extends$1A() { _extends$1A = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1A.apply(this, arguments); }

  function _objectWithoutProperties$1y(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1x(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1x(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ActionGroup = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1y(_ref, ["children", "className"]);

    const customClassName = css$1(styles$l.formGroup, styles$l.modifiers.action, className);
    const classesHorizontal = css$1(styles$l.formHorizontalGroup);
    const formActionsComponent = React.createElement("div", {
      className: css$1(styles$l.formActions)
    }, children);
    return React.createElement(FormContext.Consumer, null, ({
      isHorizontal
    }) => React.createElement("div", _extends$1A({}, props, {
      className: customClassName
    }), isHorizontal ? React.createElement("div", {
      className: classesHorizontal
    }, formActionsComponent) : formActionsComponent));
  };
  ActionGroup.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$1B() { _extends$1B = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1B.apply(this, arguments); }

  function _objectWithoutProperties$1z(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1y(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1y(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Form = (_ref) => {
    let {
      children = null,
      className = '',
      isHorizontal = false
    } = _ref,
        props = _objectWithoutProperties$1z(_ref, ["children", "className", "isHorizontal"]);

    return React.createElement("form", _extends$1B({
      noValidate: true
    }, props, {
      className: css$1(styles$l.form, isHorizontal && styles$l.modifiers.horizontal, className)
    }), React.createElement(FormContext.Provider, {
      value: {
        isHorizontal
      }
    }, children));
  };
  Form.propTypes = {
    children: _pt.node,
    className: _pt.string,
    isHorizontal: _pt.bool
  };

  function _extends$1C() { _extends$1C = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1C.apply(this, arguments); }

  function _objectWithoutProperties$1A(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1z(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1z(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const FormGroup = (_ref) => {
    let {
      children = null,
      className = '',
      label,
      isRequired = false,
      isValid = true,
      validated = 'default',
      isInline = false,
      helperText,
      helperTextInvalid,
      fieldId
    } = _ref,
        props = _objectWithoutProperties$1A(_ref, ["children", "className", "label", "isRequired", "isValid", "validated", "isInline", "helperText", "helperTextInvalid", "fieldId"]);

    const validHelperText = React.createElement("div", {
      className: css$1(styles$l.formHelperText, validated === exports.ValidatedOptions.success && styles$l.modifiers.success),
      id: `${fieldId}-helper`,
      "aria-live": "polite"
    }, helperText);
    const inValidHelperText = React.createElement("div", {
      className: css$1(styles$l.formHelperText, styles$l.modifiers.error),
      id: `${fieldId}-helper`,
      "aria-live": "polite"
    }, helperTextInvalid);
    return React.createElement(FormContext.Consumer, null, ({
      isHorizontal
    }) => React.createElement("div", _extends$1C({}, props, {
      className: css$1(styles$l.formGroup, isInline ? getModifier(styles$l, 'inline', className) : className)
    }), label && React.createElement("label", {
      className: css$1(styles$l.formLabel),
      htmlFor: fieldId
    }, React.createElement("span", {
      className: css$1(styles$l.formLabelText)
    }, label), isRequired && React.createElement("span", {
      className: css$1(styles$l.formLabelRequired),
      "aria-hidden": "true"
    }, ASTERISK)), isHorizontal ? React.createElement("div", {
      className: css$1(styles$l.formHorizontalGroup)
    }, children) : children, (!isValid || validated === exports.ValidatedOptions.error) && helperTextInvalid ? inValidHelperText : validated !== exports.ValidatedOptions.error && helperText ? validHelperText : ''));
  };
  FormGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    label: _pt.node,
    isRequired: _pt.bool,
    isValid: _pt.bool,
    validated: _pt.oneOf(['success', 'error', 'default']),
    isInline: _pt.bool,
    helperText: _pt.node,
    helperTextInvalid: _pt.node,
    fieldId: _pt.string.isRequired
  };

  function _extends$1D() { _extends$1D = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1D.apply(this, arguments); }

  function _objectWithoutProperties$1B(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1A(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1A(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const FormHelperText = (_ref) => {
    let {
      children = null,
      isError = false,
      isHidden = true,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1B(_ref, ["children", "isError", "isHidden", "className"]);

    return React.createElement("p", _extends$1D({
      className: css$1(styles$l.formHelperText, isError ? getModifier(styles$l, 'error') : '', isHidden ? getModifier(styles$l, 'hidden') : '', className)
    }, props), children);
  };
  FormHelperText.propTypes = {
    children: _pt.node,
    isError: _pt.bool,
    isHidden: _pt.bool,
    className: _pt.string
  };

  var label = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      label: 'pf-c-label',
      modifiers: {
          'compact': 'pf-m-compact'
      }
  };
  });

  var styles$r = unwrapExports(label);

  function _extends$1E() { _extends$1E = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1E.apply(this, arguments); }

  function _objectWithoutProperties$1C(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1B(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1B(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Label = (_ref) => {
    let {
      children,
      className = '',
      isCompact = false
    } = _ref,
        props = _objectWithoutProperties$1C(_ref, ["children", "className", "isCompact"]);

    return React.createElement("span", _extends$1E({}, props, {
      className: css$1(styles$r.label, className, isCompact && styles$r.modifiers.compact)
    }), children);
  };
  Label.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string,
    isCompact: _pt.bool
  };

  var list = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      list: 'pf-c-list',
      modifiers: {
          'inline': 'pf-m-inline'
      }
  };
  });

  var styles$s = unwrapExports(list);

  function _extends$1F() { _extends$1F = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1F.apply(this, arguments); }

  function _objectWithoutProperties$1D(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1C(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1C(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (OrderType) {
    OrderType["number"] = "1";
    OrderType["lowercaseLetter"] = "a";
    OrderType["uppercaseLetter"] = "A";
    OrderType["lowercaseRomanNumber"] = "i";
    OrderType["uppercaseRomanNumber"] = "I";
  })(exports.OrderType || (exports.OrderType = {}));

  (function (ListVariant) {
    ListVariant["inline"] = "inline";
  })(exports.ListVariant || (exports.ListVariant = {}));

  (function (ListComponent) {
    ListComponent["ol"] = "ol";
    ListComponent["ul"] = "ul";
  })(exports.ListComponent || (exports.ListComponent = {}));

  const List = (_ref) => {
    let {
      className = '',
      children = null,
      variant = null,
      type = exports.OrderType.number,
      ref = null,
      component = exports.ListComponent.ul
    } = _ref,
        props = _objectWithoutProperties$1D(_ref, ["className", "children", "variant", "type", "ref", "component"]);

    return component === exports.ListComponent.ol ? React.createElement("ol", _extends$1F({
      ref: ref,
      type: type
    }, props, {
      className: css$1(styles$s.list, variant && getModifier(styles$s.modifiers, variant), className)
    }), children) : React.createElement("ul", _extends$1F({
      ref: ref
    }, props, {
      className: css$1(styles$s.list, variant && getModifier(styles$s.modifiers, variant), className)
    }), children);
  };
  List.propTypes = {
    children: _pt.node,
    className: _pt.string,
    variant: _pt.any,
    type: _pt.any,
    component: _pt.oneOf(['ol', 'ul'])
  };

  function _objectWithoutProperties$1E(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1D(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1D(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ListItem = (_ref) => {
    let {
      children = null
    } = _ref,
        props = _objectWithoutProperties$1E(_ref, ["children"]);

    return React.createElement("li", props, children);
  };
  ListItem.propTypes = {
    children: _pt.node.isRequired
  };

  var login = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      loginHeader: 'pf-c-login__header',
      loginFooter: 'pf-c-login__footer',
      card: 'pf-c-card',
      button: 'pf-c-button',
      login: 'pf-c-login',
      loginContainer: 'pf-c-login__container',
      brand: 'pf-c-brand',
      loginMain: 'pf-c-login__main',
      loginMainHeader: 'pf-c-login__main-header',
      loginMainFooter: 'pf-c-login__main-footer',
      dropdown: 'pf-c-dropdown',
      loginMainHeaderDesc: 'pf-c-login__main-header-desc',
      loginMainBody: 'pf-c-login__main-body',
      formHelperText: 'pf-c-form__helper-text',
      formHelperTextIcon: 'pf-c-form__helper-text-icon',
      title: 'pf-c-title',
      loginMainFooterLinks: 'pf-c-login__main-footer-links',
      loginMainFooterLinksItem: 'pf-c-login__main-footer-links-item',
      loginMainFooterLinksItemLink: 'pf-c-login__main-footer-links-item-link',
      loginMainFooterBand: 'pf-c-login__main-footer-band',
      list: 'pf-c-list',
      modifiers: {}
  };
  });

  var styles$t = unwrapExports(login);

  function _extends$1G() { _extends$1G = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1G.apply(this, arguments); }

  function _objectWithoutProperties$1F(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1E(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1E(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Login = (_ref) => {
    let {
      className = '',
      children = null,
      footer = null,
      header = null
    } = _ref,
        props = _objectWithoutProperties$1F(_ref, ["className", "children", "footer", "header"]);

    return React.createElement("div", _extends$1G({}, props, {
      className: css$1(styles$t.login, className)
    }), React.createElement("div", {
      className: css$1(styles$t.loginContainer)
    }, header, React.createElement("main", {
      className: css$1(styles$t.loginMain)
    }, children), footer));
  };
  Login.propTypes = {
    children: _pt.node,
    className: _pt.string,
    footer: _pt.node,
    header: _pt.node
  };

  function _extends$1H() { _extends$1H = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1H.apply(this, arguments); }

  function _objectWithoutProperties$1G(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1F(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1F(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginHeader = (_ref) => {
    let {
      className = '',
      children = null,
      headerBrand = null
    } = _ref,
        props = _objectWithoutProperties$1G(_ref, ["className", "children", "headerBrand"]);

    return React.createElement("header", _extends$1H({
      className: css$1(styles$t.loginHeader, className)
    }, props), headerBrand, children);
  };
  LoginHeader.propTypes = {
    children: _pt.node,
    className: _pt.string,
    headerBrand: _pt.node
  };

  function _extends$1I() { _extends$1I = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1I.apply(this, arguments); }

  function _objectWithoutProperties$1H(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1G(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1G(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginFooter = (_ref) => {
    let {
      className = '',
      children = null
    } = _ref,
        props = _objectWithoutProperties$1H(_ref, ["className", "children"]);

    return React.createElement("footer", _extends$1I({
      className: css$1(styles$t.loginFooter, className)
    }, props), children);
  };
  LoginFooter.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$1J() { _extends$1J = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1J.apply(this, arguments); }

  function _objectWithoutProperties$1I(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1H(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1H(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginMainHeader = (_ref) => {
    let {
      children = null,
      className = '',
      title = '',
      subtitle = ''
    } = _ref,
        props = _objectWithoutProperties$1I(_ref, ["children", "className", "title", "subtitle"]);

    return React.createElement("header", _extends$1J({
      className: css$1(styles$t.loginMainHeader, className)
    }, props), title && React.createElement(Title, {
      headingLevel: exports.TitleLevel.h2,
      size: "3xl"
    }, title), subtitle && React.createElement("p", {
      className: css$1(styles$t.loginMainHeaderDesc)
    }, subtitle), children);
  };
  LoginMainHeader.propTypes = {
    children: _pt.node,
    className: _pt.string,
    title: _pt.string,
    subtitle: _pt.string
  };

  function _extends$1K() { _extends$1K = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1K.apply(this, arguments); }

  function _objectWithoutProperties$1J(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1I(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1I(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginMainBody = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1J(_ref, ["children", "className"]);

    return React.createElement("div", _extends$1K({
      className: css$1(styles$t.loginMainBody, className)
    }, props), children);
  };
  LoginMainBody.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$1L() { _extends$1L = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1L.apply(this, arguments); }

  function _objectWithoutProperties$1K(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1J(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1J(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginMainFooter = (_ref) => {
    let {
      children = null,
      socialMediaLoginContent = null,
      signUpForAccountMessage = null,
      forgotCredentials = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1K(_ref, ["children", "socialMediaLoginContent", "signUpForAccountMessage", "forgotCredentials", "className"]);

    return React.createElement("div", _extends$1L({
      className: css$1(styles$t.loginMainFooter, className)
    }, props), children, socialMediaLoginContent && React.createElement("ul", {
      className: css$1(styles$t.loginMainFooterLinks)
    }, socialMediaLoginContent), (signUpForAccountMessage || forgotCredentials) && React.createElement("div", {
      className: css$1(styles$t.loginMainFooterBand)
    }, signUpForAccountMessage, forgotCredentials));
  };
  LoginMainFooter.propTypes = {
    className: _pt.string,
    children: _pt.node,
    socialMediaLoginContent: _pt.node,
    signUpForAccountMessage: _pt.node,
    forgotCredentials: _pt.node
  };

  function _extends$1M() { _extends$1M = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1M.apply(this, arguments); }

  function _objectWithoutProperties$1L(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1K(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1K(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginPage = (_ref) => {
    let {
      children = null,
      className = '',
      brandImgSrc = '',
      brandImgAlt = '',
      backgroundImgSrc = '',
      backgroundImgAlt = '',
      footerListItems = null,
      textContent = '',
      footerListVariants,
      loginTitle,
      loginSubtitle,
      signUpForAccountMessage = null,
      forgotCredentials = null,
      socialMediaLoginContent = null
    } = _ref,
        props = _objectWithoutProperties$1L(_ref, ["children", "className", "brandImgSrc", "brandImgAlt", "backgroundImgSrc", "backgroundImgAlt", "footerListItems", "textContent", "footerListVariants", "loginTitle", "loginSubtitle", "signUpForAccountMessage", "forgotCredentials", "socialMediaLoginContent"]);

    const HeaderBrand = React.createElement(React.Fragment, null, React.createElement(Brand, {
      src: brandImgSrc,
      alt: brandImgAlt
    }));
    const Header = React.createElement(LoginHeader, {
      headerBrand: HeaderBrand
    });
    const Footer = React.createElement(LoginFooter, null, React.createElement("p", null, textContent), React.createElement(List, {
      variant: footerListVariants
    }, footerListItems));
    return React.createElement(React.Fragment, null, backgroundImgSrc && React.createElement(BackgroundImage, {
      src: backgroundImgSrc,
      alt: backgroundImgAlt
    }), React.createElement(Login, _extends$1M({
      header: Header,
      footer: Footer,
      className: css$1(className)
    }, props), React.createElement(LoginMainHeader, {
      title: loginTitle,
      subtitle: loginSubtitle
    }), React.createElement(LoginMainBody, null, children), (socialMediaLoginContent || forgotCredentials || signUpForAccountMessage) && React.createElement(LoginMainFooter, {
      socialMediaLoginContent: socialMediaLoginContent,
      forgotCredentials: forgotCredentials,
      signUpForAccountMessage: signUpForAccountMessage
    })));
  };
  LoginPage.propTypes = {
    children: _pt.node,
    className: _pt.string,
    brandImgSrc: _pt.string,
    brandImgAlt: _pt.string,
    backgroundImgSrc: _pt.oneOfType([_pt.string, _pt.any]),
    backgroundImgAlt: _pt.string,
    textContent: _pt.string,
    footerListItems: _pt.node,
    footerListVariants: _pt.any,
    loginTitle: _pt.string.isRequired,
    loginSubtitle: _pt.string,
    signUpForAccountMessage: _pt.node,
    forgotCredentials: _pt.node,
    socialMediaLoginContent: _pt.node
  };

  function _extends$1N() { _extends$1N = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1N.apply(this, arguments); }

  function _objectWithoutProperties$1M(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1L(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1L(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginForm = (_ref) => {
    let {
      noAutoFocus = false,
      className = '',
      showHelperText = false,
      helperText = null,
      usernameLabel = 'Username',
      usernameValue = '',
      onChangeUsername = () => undefined,
      isValidUsername = true,
      passwordLabel = 'Password',
      passwordValue = '',
      onChangePassword = () => undefined,
      isValidPassword = true,
      loginButtonLabel = 'Log In',
      isLoginButtonDisabled = false,
      onLoginButtonClick = () => undefined,
      rememberMeLabel = '',
      isRememberMeChecked = false,
      onChangeRememberMe = () => undefined,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      rememberMeAriaLabel = ''
    } = _ref,
        props = _objectWithoutProperties$1M(_ref, ["noAutoFocus", "className", "showHelperText", "helperText", "usernameLabel", "usernameValue", "onChangeUsername", "isValidUsername", "passwordLabel", "passwordValue", "onChangePassword", "isValidPassword", "loginButtonLabel", "isLoginButtonDisabled", "onLoginButtonClick", "rememberMeLabel", "isRememberMeChecked", "onChangeRememberMe", "rememberMeAriaLabel"]);

    return React.createElement(Form, _extends$1N({
      className: className
    }, props), React.createElement(FormHelperText, {
      isError: !isValidUsername || !isValidPassword,
      isHidden: !showHelperText
    }, helperText), React.createElement(FormGroup, {
      label: usernameLabel,
      isRequired: true,
      isValid: isValidUsername,
      fieldId: "pf-login-username-id"
    }, React.createElement(TextInput, {
      autoFocus: !noAutoFocus,
      id: "pf-login-username-id",
      isRequired: true,
      isValid: isValidUsername,
      type: "text",
      name: "pf-login-username-id",
      value: usernameValue,
      onChange: onChangeUsername
    })), React.createElement(FormGroup, {
      label: passwordLabel,
      isRequired: true,
      isValid: isValidPassword,
      fieldId: "pf-login-password-id"
    }, React.createElement(TextInput, {
      isRequired: true,
      type: "password",
      id: "pf-login-password-id",
      name: "pf-login-password-id",
      isValid: isValidPassword,
      value: passwordValue,
      onChange: onChangePassword
    })), rememberMeLabel.length > 0 && React.createElement(FormGroup, {
      fieldId: "pf-login-remember-me-id"
    }, React.createElement(Checkbox, {
      id: "pf-login-remember-me-id",
      label: rememberMeLabel,
      isChecked: isRememberMeChecked,
      onChange: onChangeRememberMe
    })), React.createElement(ActionGroup, null, React.createElement(ButtonWithOuiaContext, {
      variant: "primary",
      type: "submit",
      onClick: onLoginButtonClick,
      isBlock: true,
      isDisabled: isLoginButtonDisabled
    }, loginButtonLabel)));
  };
  LoginForm.propTypes = {
    noAutoFocus: _pt.bool,
    className: _pt.string,
    showHelperText: _pt.bool,
    helperText: _pt.node,
    usernameLabel: _pt.string,
    usernameValue: _pt.string,
    onChangeUsername: _pt.func,
    isValidUsername: _pt.bool,
    passwordLabel: _pt.string,
    passwordValue: _pt.string,
    onChangePassword: _pt.func,
    isValidPassword: _pt.bool,
    loginButtonLabel: _pt.string,
    isLoginButtonDisabled: _pt.bool,
    onLoginButtonClick: _pt.func,
    rememberMeLabel: _pt.string,
    isRememberMeChecked: _pt.bool,
    onChangeRememberMe: _pt.func,
    rememberMeAriaLabel: _pt.string
  };

  function _extends$1O() { _extends$1O = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1O.apply(this, arguments); }

  function _objectWithoutProperties$1N(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1M(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1M(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginFooterItem = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children = null,
      href = '#',
      target = '_blank'
    } = _ref,
        props = _objectWithoutProperties$1N(_ref, ["className", "children", "href", "target"]);

    const reactElement = React.isValidElement(children);
    return reactElement ? React.cloneElement(children) : React.createElement("a", _extends$1O({
      target: target,
      href: href
    }, props), children);
  };
  LoginFooterItem.propTypes = {
    children: _pt.node,
    className: _pt.string,
    href: _pt.string,
    target: _pt.string
  };

  function _extends$1P() { _extends$1P = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1P.apply(this, arguments); }

  function _objectWithoutProperties$1O(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1N(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1N(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginMainFooterBandItem = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1O(_ref, ["children", "className"]);

    return React.createElement("p", _extends$1P({
      className: css$1(`${styles$t.loginMainFooterBand}-item`, className)
    }, props), children);
  };
  LoginMainFooterBandItem.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$1Q() { _extends$1Q = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1Q.apply(this, arguments); }

  function _objectWithoutProperties$1P(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1O(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1O(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const LoginMainFooterLinksItem = (_ref) => {
    let {
      children = null,
      href = '',
      target = '',
      className = '',
      linkComponent = 'a',
      linkComponentProps
    } = _ref,
        props = _objectWithoutProperties$1P(_ref, ["children", "href", "target", "className", "linkComponent", "linkComponentProps"]);

    const LinkComponent = linkComponent;
    return React.createElement("li", _extends$1Q({
      className: css$1(styles$t.loginMainFooterLinksItem, className)
    }, props), React.createElement(LinkComponent, _extends$1Q({
      className: css$1(styles$t.loginMainFooterLinksItemLink),
      href: href,
      target: target
    }, linkComponentProps), children));
  };
  LoginMainFooterLinksItem.propTypes = {
    children: _pt.node,
    href: _pt.string,
    target: _pt.string,
    className: _pt.string,
    linkComponent: _pt.node,
    linkComponentProps: _pt.any
  };

  var modalBox = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      modalBox: 'pf-c-modal-box',
      button: 'pf-c-button',
      title: 'pf-c-title',
      modalBoxDescription: 'pf-c-modal-box__description',
      modalBoxBody: 'pf-c-modal-box__body',
      modalBoxFooter: 'pf-c-modal-box__footer',
      modifiers: {
          'sm': 'pf-m-sm',
          'lg': 'pf-m-lg',
          'alignLeft': 'pf-m-align-left'
      }
  };
  });

  var styles$u = unwrapExports(modalBox);

  function _extends$1R() { _extends$1R = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1R.apply(this, arguments); }

  function _objectWithoutProperties$1Q(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1P(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1P(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ModalBoxBody = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$1Q(_ref, ["children", "className"]);

    return React.createElement("div", _extends$1R({}, props, {
      className: css$1(styles$u.modalBoxBody, className)
    }), children);
  };
  ModalBoxBody.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$1S() { _extends$1S = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1S.apply(this, arguments); }

  function _objectWithoutProperties$1R(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1Q(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1Q(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ModalBoxHeader = (_ref) => {
    let {
      children = null,
      className = '',
      hideTitle = false,
      headingLevel = exports.TitleLevel.h1
    } = _ref,
        props = _objectWithoutProperties$1R(_ref, ["children", "className", "hideTitle", "headingLevel"]);

    return hideTitle ? null : React.createElement(React.Fragment, null, React.createElement(Title, _extends$1S({
      size: "2xl",
      headingLevel: headingLevel,
      className: className
    }, props), children));
  };
  ModalBoxHeader.propTypes = {
    children: _pt.node,
    className: _pt.string,
    hideTitle: _pt.bool,
    headingLevel: _pt.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6'])
  };

  function _extends$1T() { _extends$1T = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1T.apply(this, arguments); }

  function _objectWithoutProperties$1S(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1R(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1R(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ModalBoxCloseButton = (_ref) => {
    let {
      className = '',
      onClose = () => undefined
    } = _ref,
        props = _objectWithoutProperties$1S(_ref, ["className", "onClose"]);

    return React.createElement(ButtonWithOuiaContext, _extends$1T({
      className: className,
      variant: "plain",
      onClick: onClose,
      "aria-label": "Close"
    }, props), React.createElement(TimesIcon, null));
  };
  ModalBoxCloseButton.propTypes = {
    className: _pt.string,
    onClose: _pt.func
  };

  function _extends$1U() { _extends$1U = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1U.apply(this, arguments); }

  function _objectWithoutProperties$1T(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1S(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1S(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ModalBox = (_ref) => {
    let {
      children,
      className = '',
      isLarge = false,
      isSmall = false,
      title,
      id
    } = _ref,
        props = _objectWithoutProperties$1T(_ref, ["children", "className", "isLarge", "isSmall", "title", "id"]);

    return React.createElement("div", _extends$1U({}, props, {
      role: "dialog",
      "aria-label": title,
      "aria-describedby": id,
      "aria-modal": "true",
      className: css$1(styles$u.modalBox, className, isLarge && styles$u.modifiers.lg, isSmall && styles$u.modifiers.sm)
    }), children);
  };
  ModalBox.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string,
    isLarge: _pt.bool,
    isSmall: _pt.bool,
    title: _pt.string.isRequired,
    id: _pt.string.isRequired
  };

  function _extends$1V() { _extends$1V = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1V.apply(this, arguments); }

  function _objectWithoutProperties$1U(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1T(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1T(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ModalBoxFooter = (_ref) => {
    let {
      children = null,
      className = '',
      isLeftAligned = false
    } = _ref,
        props = _objectWithoutProperties$1U(_ref, ["children", "className", "isLeftAligned"]);

    return React.createElement("div", _extends$1V({}, props, {
      className: css$1(styles$u.modalBoxFooter, isLeftAligned && styles$u.modifiers.alignLeft, className)
    }), children);
  };
  ModalBoxFooter.propTypes = {
    children: _pt.node,
    className: _pt.string,
    isLeftAligned: _pt.bool
  };

  function _extends$1W() { _extends$1W = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1W.apply(this, arguments); }

  function _objectWithoutProperties$1V(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1U(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1U(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ModalBoxDescription = (_ref) => {
    let {
      children = null,
      className = '',
      id = ''
    } = _ref,
        props = _objectWithoutProperties$1V(_ref, ["children", "className", "id"]);

    return React.createElement("div", _extends$1W({}, props, {
      id: id,
      className: css$1(styles$u.modalBoxDescription, className)
    }), children);
  };
  ModalBoxDescription.propTypes = {
    children: _pt.node,
    className: _pt.string,
    id: _pt.string
  };

  function _extends$1X() { _extends$1X = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1X.apply(this, arguments); }

  function _objectWithoutProperties$1W(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1V(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1V(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ModalContent = (_ref) => {
    let {
      children,
      className = '',
      isOpen = false,
      header = null,
      description = null,
      title,
      hideTitle = false,
      showClose = true,
      footer = null,
      actions = [],
      isFooterLeftAligned = false,
      onClose = () => undefined,
      isLarge = false,
      isSmall = false,
      width = -1,
      ariaDescribedById = '',
      id = '',
      disableFocusTrap = false
    } = _ref,
        props = _objectWithoutProperties$1W(_ref, ["children", "className", "isOpen", "header", "description", "title", "hideTitle", "showClose", "footer", "actions", "isFooterLeftAligned", "onClose", "isLarge", "isSmall", "width", "ariaDescribedById", "id", "disableFocusTrap"]);

    if (!isOpen) {
      return null;
    }

    const modalBoxHeader = header ? React.createElement("div", {
      className: css$1(titleStyles.title)
    }, header) : React.createElement(ModalBoxHeader, {
      hideTitle: hideTitle
    }, " ", title, " ");
    const modalBoxFooter = footer ? React.createElement(ModalBoxFooter, {
      isLeftAligned: isFooterLeftAligned
    }, footer) : actions.length > 0 && React.createElement(ModalBoxFooter, {
      isLeftAligned: isFooterLeftAligned
    }, actions);
    const boxStyle = width === -1 ? {} : {
      width
    };
    const modalBox = React.createElement(ModalBox, {
      style: boxStyle,
      className: className,
      isLarge: isLarge,
      isSmall: isSmall,
      title: title,
      id: ariaDescribedById || id
    }, showClose && React.createElement(ModalBoxCloseButton, {
      onClose: onClose
    }), modalBoxHeader, description && React.createElement(ModalBoxDescription, {
      id: id
    }, description), React.createElement(ModalBoxBody, _extends$1X({}, props, !description && {
      id
    }), children), modalBoxFooter);
    return React.createElement(Backdrop, null, React.createElement(FocusTrap, {
      active: !disableFocusTrap,
      focusTrapOptions: {
        clickOutsideDeactivates: true
      },
      className: css$1(styles$1.bullseye)
    }, modalBox));
  };
  ModalContent.propTypes = {
    children: _pt.node.isRequired,
    className: _pt.string,
    isLarge: _pt.bool,
    isSmall: _pt.bool,
    isOpen: _pt.bool,
    header: _pt.node,
    description: _pt.node,
    title: _pt.string.isRequired,
    hideTitle: _pt.bool,
    showClose: _pt.bool,
    width: _pt.oneOfType([_pt.number, _pt.string]),
    footer: _pt.node,
    actions: _pt.any,
    isFooterLeftAligned: _pt.bool,
    onClose: _pt.func,
    ariaDescribedById: _pt.string,
    id: _pt.string.isRequired,
    disableFocusTrap: _pt.bool
  };

  function _extends$1Y() { _extends$1Y = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1Y.apply(this, arguments); }

  function _objectWithoutProperties$1X(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1W(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1W(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$C(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class Modal extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$C(this, "id", '');

      _defineProperty$C(this, "handleEscKeyClick", event => {
        if (event.keyCode === KEY_CODES.ESCAPE_KEY && this.props.isOpen) {
          this.props.onClose();
        }
      });

      _defineProperty$C(this, "getElement", appendTo => {
        let target;

        if (typeof appendTo === 'function') {
          target = appendTo();
        } else {
          target = appendTo;
        }

        return target;
      });

      _defineProperty$C(this, "toggleSiblingsFromScreenReaders", hide => {
        const {
          appendTo
        } = this.props;
        const target = this.getElement(appendTo);
        const bodyChildren = target.children;

        for (const child of Array.from(bodyChildren)) {
          if (child !== this.state.container) {
            hide ? child.setAttribute('aria-hidden', '' + hide) : child.removeAttribute('aria-hidden');
          }
        }
      });

      const newId = Modal.currentId++;
      this.id = `pf-modal-${newId}`;
      this.state = {
        container: undefined
      };
    }

    componentDidMount() {
      const {
        appendTo
      } = this.props;
      const target = this.getElement(appendTo);
      const container = document.createElement('div');
      this.setState({
        container
      });
      target.appendChild(container);
      target.addEventListener('keydown', this.handleEscKeyClick, false);

      if (this.props.isOpen) {
        target.classList.add(css$1(styles.backdropOpen));
      } else {
        target.classList.remove(css$1(styles.backdropOpen));
      }
    }

    componentDidUpdate() {
      const {
        appendTo
      } = this.props;
      const target = this.getElement(appendTo);

      if (this.props.isOpen) {
        target.classList.add(css$1(styles.backdropOpen));
        this.toggleSiblingsFromScreenReaders(true);
      } else {
        target.classList.remove(css$1(styles.backdropOpen));
        this.toggleSiblingsFromScreenReaders(false);
      }
    }

    componentWillUnmount() {
      const {
        appendTo
      } = this.props;
      const target = this.getElement(appendTo);

      if (this.state.container) {
        target.removeChild(this.state.container);
      }

      target.removeEventListener('keydown', this.handleEscKeyClick, false);
      target.classList.remove(css$1(styles.backdropOpen));
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            props = _objectWithoutProperties$1X(_this$props, ["appendTo"]);

      const {
        container
      } = this.state;

      if (!canUseDOM || !container) {
        return null;
      }

      return ReactDOM.createPortal(React.createElement(ModalContent, _extends$1Y({}, props, {
        title: this.props.title,
        id: this.id,
        ariaDescribedById: this.props.ariaDescribedById
      })), container);
    }

  }

  _defineProperty$C(Modal, "propTypes", {
    children: _pt.node.isRequired,
    className: _pt.string,
    isOpen: _pt.bool,
    header: _pt.node,
    title: _pt.string.isRequired,
    hideTitle: _pt.bool,
    showClose: _pt.bool,
    ariaDescribedById: _pt.string,
    footer: _pt.node,
    actions: _pt.any,
    isFooterLeftAligned: _pt.bool,
    onClose: _pt.func,
    width: _pt.oneOfType([_pt.number, _pt.string]),
    isLarge: _pt.bool,
    isSmall: _pt.bool,
    appendTo: _pt.oneOfType([_pt.any, _pt.func]),
    disableFocusTrap: _pt.bool,
    description: _pt.node
  });

  _defineProperty$C(Modal, "currentId", 0);

  _defineProperty$C(Modal, "defaultProps", {
    className: '',
    isOpen: false,
    hideTitle: false,
    showClose: true,
    ariaDescribedById: '',
    actions: [],
    isFooterLeftAligned: false,
    onClose: () => undefined,
    isLarge: false,
    isSmall: false,
    appendTo: typeof document !== 'undefined' && document.body || null
  });

  var nav = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      nav: 'pf-c-nav',
      navScrollButton: 'pf-c-nav__scroll-button',
      divider: 'pf-c-divider',
      navItem: 'pf-c-nav__item',
      navLink: 'pf-c-nav__link',
      navList: 'pf-c-nav__list',
      pageSidebar: 'pf-c-page__sidebar',
      pageHeaderNav: 'pf-c-page__header-nav',
      navSeparator: 'pf-c-nav__separator',
      navSimpleList: 'pf-c-nav__simple-list',
      navToggle: 'pf-c-nav__toggle',
      navHorizontalList: 'pf-c-nav__horizontal-list',
      navTertiaryList: 'pf-c-nav__tertiary-list',
      navSubnav: 'pf-c-nav__subnav',
      navSection: 'pf-c-nav__section',
      navSectionTitle: 'pf-c-nav__section-title',
      modifiers: {
          'start': 'pf-m-start',
          'end': 'pf-m-end',
          'dark': 'pf-m-dark',
          'current': 'pf-m-current',
          'expanded': 'pf-m-expanded',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus'
      }
  };
  });

  var styles$v = unwrapExports(nav);

  function _extends$1Z() { _extends$1Z = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1Z.apply(this, arguments); }

  function _objectWithoutProperties$1Y(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1X(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1X(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$D(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  const NavContext = React.createContext({});

  class Nav extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$D(this, "state", {
        showLeftScrollButton: false,
        showRightScrollButton: false
      });

      _defineProperty$D(this, "updateScrollButtonState", state => {
        const {
          showLeftScrollButton,
          showRightScrollButton
        } = state;
        this.setState({
          showLeftScrollButton,
          showRightScrollButton
        });
      });
    }

    // Callback from NavItem
    onSelect(event, groupId, itemId, to, preventDefault, onClick) {
      if (preventDefault) {
        event.preventDefault();
      }

      this.props.onSelect({
        groupId,
        itemId,
        event,
        to
      });

      if (onClick) {
        onClick(event, itemId, groupId, to);
      }
    } // Callback from NavExpandable


    onToggle(event, groupId, toggleValue) {
      this.props.onToggle({
        event,
        groupId,
        isExpanded: toggleValue
      });
    }

    render() {
      const _this$props = this.props,
            {
        'aria-label': ariaLabel,
        children,
        className,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onSelect,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onToggle,
        theme,
        ouiaContext,
        ouiaId
      } = _this$props,
            props = _objectWithoutProperties$1Y(_this$props, ["aria-label", "children", "className", "onSelect", "onToggle", "theme", "ouiaContext", "ouiaId"]);

      const {
        showLeftScrollButton,
        showRightScrollButton
      } = this.state;
      const childrenProps = children.props;
      return React.createElement(NavContext.Provider, {
        value: {
          onSelect: (event, groupId, itemId, to, preventDefault, onClick) => this.onSelect(event, groupId, itemId, to, preventDefault, onClick),
          onToggle: (event, groupId, expanded) => this.onToggle(event, groupId, expanded),
          updateScrollButtonState: this.updateScrollButtonState
        }
      }, React.createElement("nav", _extends$1Z({
        className: css$1(styles$v.nav, theme === 'dark' && styles$v.modifiers.dark, showLeftScrollButton && styles$v.modifiers.start, showRightScrollButton && styles$v.modifiers.end, className),
        "aria-label": ariaLabel === '' ? typeof childrenProps !== 'undefined' && childrenProps.variant === 'tertiary' ? 'Local' : 'Global' : ariaLabel
      }, ouiaContext.isOuia && {
        'data-ouia-component-type': 'Nav',
        'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
      }, props), children));
    }

  }

  _defineProperty$D(Nav, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    onSelect: _pt.func,
    onToggle: _pt.func,
    'aria-label': _pt.string,
    theme: _pt.oneOf(['dark', 'light'])
  });

  _defineProperty$D(Nav, "defaultProps", {
    'aria-label': '',
    children: null,
    className: '',
    onSelect: () => undefined,
    onToggle: () => undefined,
    theme: 'light'
  });

  const NavWithOuiaContext = withOuiaContext(Nav);

  (function (NavVariants) {
    NavVariants["default"] = "default";
    NavVariants["simple"] = "simple";
    NavVariants["horizontal"] = "horizontal";
    NavVariants["tertiary"] = "tertiary";
  })(exports.NavVariants || (exports.NavVariants = {}));

  var angleLeftIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.AngleLeftIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var AngleLeftIconConfig = {
    name: 'AngleLeftIcon',
    height: 512,
    width: 256,
    svgPath: 'M31.7 239l136-136c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9L127.9 256l96.4 96.4c9.4 9.4 9.4 24.6 0 33.9L201.7 409c-9.4 9.4-24.6 9.4-33.9 0l-136-136c-9.5-9.4-9.5-24.6-.1-34z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.AngleLeftIconConfig = AngleLeftIconConfig;

  var _default = (0, _createIcon["default"])(AngleLeftIconConfig);

  exports["default"] = _default;

  });

  var AngleLeftIcon = unwrapExports(angleLeftIcon);
  var angleLeftIcon_1 = angleLeftIcon.AngleLeftIconConfig;

  function _extends$1_() { _extends$1_ = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1_.apply(this, arguments); }

  function _objectWithoutProperties$1Z(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1Y(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1Y(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$E(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class NavList extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$E(this, "navList", React.createRef());

      _defineProperty$E(this, "handleScrollButtons", () => {
        if (this.navList.current) {
          const {
            updateScrollButtonState
          } = this.context;
          const container = this.navList.current; // get first element and check if it is in view

          const showLeftScrollButton = !isElementInView(container, container.firstChild, false); // get last element and check if it is in view

          const showRightScrollButton = !isElementInView(container, container.lastChild, false);
          updateScrollButtonState({
            showLeftScrollButton,
            showRightScrollButton
          });
        }
      });

      _defineProperty$E(this, "scrollLeft", () => {
        // find first Element that is fully in view on the left, then scroll to the element before it
        if (this.navList.current) {
          const container = this.navList.current;
          const childrenArr = Array.from(container.children);
          let firstElementInView;
          let lastElementOutOfView;

          for (let i = 0; i < childrenArr.length && !firstElementInView; i++) {
            if (isElementInView(container, childrenArr[i], false)) {
              firstElementInView = childrenArr[i];
              lastElementOutOfView = childrenArr[i - 1];
            }
          }

          if (lastElementOutOfView) {
            container.scrollLeft -= lastElementOutOfView.scrollWidth;
          }

          this.handleScrollButtons();
        }
      });

      _defineProperty$E(this, "scrollRight", () => {
        // find last Element that is fully in view on the right, then scroll to the element after it
        if (this.navList.current) {
          const container = this.navList.current;
          const childrenArr = Array.from(container.children);
          let lastElementInView;
          let firstElementOutOfView;

          for (let i = childrenArr.length - 1; i >= 0 && !lastElementInView; i--) {
            if (isElementInView(container, childrenArr[i], false)) {
              lastElementInView = childrenArr[i];
              firstElementOutOfView = childrenArr[i + 1];
            }
          }

          if (firstElementOutOfView) {
            container.scrollLeft += firstElementOutOfView.scrollWidth;
          }

          this.handleScrollButtons();
        }
      });
    }

    componentDidMount() {
      const {
        variant
      } = this.props;
      const isHorizontal = variant === exports.NavVariants.horizontal || variant === exports.NavVariants.tertiary;

      if (isHorizontal) {
        window.addEventListener('resize', this.handleScrollButtons, false); // call the handle resize function to check if scroll buttons should be shown

        this.handleScrollButtons();
      }
    }

    componentWillUnmount() {
      const {
        variant
      } = this.props;
      const isHorizontal = variant === exports.NavVariants.horizontal || variant === exports.NavVariants.tertiary;

      if (isHorizontal) {
        document.removeEventListener('resize', this.handleScrollButtons, false);
      }
    }

    render() {
      const _this$props = this.props,
            {
        variant,
        children,
        className,
        ariaLeftScroll,
        ariaRightScroll
      } = _this$props,
            props = _objectWithoutProperties$1Z(_this$props, ["variant", "children", "className", "ariaLeftScroll", "ariaRightScroll"]);

      const variantStyle = {
        [exports.NavVariants.default]: styles$v.navList,
        [exports.NavVariants.simple]: styles$v.navSimpleList,
        [exports.NavVariants.horizontal]: styles$v.navHorizontalList,
        [exports.NavVariants.tertiary]: styles$v.navTertiaryList
      };
      const isHorizontal = variant === exports.NavVariants.horizontal || variant === exports.NavVariants.tertiary;
      return React.createElement(React.Fragment, null, isHorizontal && React.createElement("button", {
        className: css$1(styles$v.navScrollButton),
        "aria-label": ariaLeftScroll,
        onClick: this.scrollLeft
      }, React.createElement(AngleLeftIcon, null)), React.createElement("ul", _extends$1_({
        ref: this.navList,
        className: css$1(variantStyle[variant], className)
      }, props), children), isHorizontal && React.createElement("button", {
        className: css$1(styles$v.navScrollButton),
        "aria-label": ariaRightScroll,
        onClick: this.scrollRight
      }, React.createElement(AngleRightIcon, null)));
    }

  }

  _defineProperty$E(NavList, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    variant: _pt.oneOf(['default', 'simple', 'horizontal', 'tertiary']),
    ariaLeftScroll: _pt.string,
    ariaRightScroll: _pt.string
  });

  _defineProperty$E(NavList, "contextType", NavContext);

  _defineProperty$E(NavList, "defaultProps", {
    variant: 'default',
    children: null,
    className: '',
    ariaLeftScroll: 'Scroll left',
    ariaRightScroll: 'Scroll right'
  });

  function _extends$1$() { _extends$1$ = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1$.apply(this, arguments); }

  function _objectWithoutProperties$1_(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1Z(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1Z(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const NavGroup = (_ref) => {
    let {
      title,
      children = null,
      className = '',
      id = getUniqueId()
    } = _ref,
        props = _objectWithoutProperties$1_(_ref, ["title", "children", "className", "id"]);

    return React.createElement("section", _extends$1$({
      className: css$1(styles$v.navSection, className),
      "aria-labelledby": id
    }, props), React.createElement("h2", {
      className: css$1(styles$v.navSectionTitle),
      id: id
    }, title), React.createElement("ul", {
      className: css$1(styles$v.navList)
    }, children));
  };
  NavGroup.propTypes = {
    title: _pt.string.isRequired,
    children: _pt.node,
    className: _pt.string,
    id: _pt.string
  };

  function _extends$20() { _extends$20 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$20.apply(this, arguments); }

  function _objectWithoutProperties$1$(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1_(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1_(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const NavItem = (_ref) => {
    let {
      children = null,
      className = '',
      to = '',
      isActive = false,
      groupId = null,
      itemId = null,
      preventDefault = false,
      onClick = null,
      component = 'a'
    } = _ref,
        props = _objectWithoutProperties$1$(_ref, ["children", "className", "to", "isActive", "groupId", "itemId", "preventDefault", "onClick", "component"]);

    const Component = component;

    const renderDefaultLink = () => {
      const preventLinkDefault = preventDefault || !to;
      return React.createElement(NavContext.Consumer, null, context => React.createElement(Component, _extends$20({
        href: to,
        onClick: e => context.onSelect(e, groupId, itemId, to, preventLinkDefault, onClick),
        className: css$1(styles$v.navLink, isActive && styles$v.modifiers.current, className),
        "aria-current": isActive ? 'page' : null
      }, props), children));
    };

    const renderClonedChild = child => React.createElement(NavContext.Consumer, null, context => React.cloneElement(child, {
      onClick: e => context.onSelect(e, groupId, itemId, to, preventDefault, onClick),
      className: css$1(styles$v.navLink, isActive && styles$v.modifiers.current, child.props && child.props.className),
      'aria-current': isActive ? 'page' : null
    }));

    return React.createElement("li", {
      className: css$1(styles$v.navItem, className)
    }, React.isValidElement(children) ? renderClonedChild(children) : renderDefaultLink());
  };
  NavItem.propTypes = {
    children: _pt.node,
    className: _pt.string,
    to: _pt.string,
    isActive: _pt.bool,
    groupId: _pt.oneOfType([_pt.string, _pt.number, _pt.oneOf([null])]),
    itemId: _pt.oneOfType([_pt.string, _pt.number, _pt.oneOf([null])]),
    preventDefault: _pt.bool,
    onClick: _pt.func,
    component: _pt.node
  };

  function _extends$21() { _extends$21 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$21.apply(this, arguments); }

  function _objectWithoutProperties$20(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$1$(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$1$(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const NavItemSeparator = (_ref) => {
    let {
      className = ''
    } = _ref,
        props = _objectWithoutProperties$20(_ref, ["className"]);

    return React.createElement("li", _extends$21({
      className: css$1(styles$v.navSeparator, className),
      role: "separator"
    }, props));
  };

  function _extends$22() { _extends$22 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$22.apply(this, arguments); }

  function _objectWithoutProperties$21(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$20(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$20(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$F(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class NavExpandable extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$F(this, "id", this.props.id || getUniqueId());

      _defineProperty$F(this, "state", {
        expandedState: this.props.isExpanded
      });

      _defineProperty$F(this, "onExpand", (e, val) => {
        if (this.props.onExpand) {
          this.props.onExpand(e, val);
        } else {
          this.setState({
            expandedState: val
          });
        }
      });

      _defineProperty$F(this, "handleToggle", (e, onToggle) => {
        // Item events can bubble up, ignore those
        if (e.target.getAttribute('data-component') !== 'pf-nav-expandable') {
          return;
        }

        const {
          groupId
        } = this.props;
        const {
          expandedState
        } = this.state;
        onToggle(e, groupId, !expandedState);
        this.onExpand(e, !expandedState);
      });
    }

    componentDidMount() {
      this.setState({
        expandedState: this.props.isExpanded
      });
    }

    componentDidUpdate(prevProps) {
      if (this.props.isExpanded !== prevProps.isExpanded) {
        this.setState({
          expandedState: this.props.isExpanded
        });
      }
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            {
        id,
        title,
        srText,
        children,
        className,
        isActive,
        groupId,
        isExpanded,
        onExpand
      } = _this$props,
            props = _objectWithoutProperties$21(_this$props, ["id", "title", "srText", "children", "className", "isActive", "groupId", "isExpanded", "onExpand"]);

      const {
        expandedState
      } = this.state;
      return React.createElement(NavContext.Consumer, null, context => React.createElement("li", _extends$22({
        className: css$1(styles$v.navItem, expandedState && styles$v.modifiers.expanded, isActive && styles$v.modifiers.current, className),
        onClick: e => this.handleToggle(e, context.onToggle)
      }, props), React.createElement("a", {
        "data-component": "pf-nav-expandable",
        className: css$1(styles$v.navLink),
        id: srText ? null : this.id,
        href: "#",
        onClick: e => e.preventDefault(),
        onMouseDown: e => e.preventDefault(),
        "aria-expanded": expandedState
      }, title, React.createElement("span", {
        className: css$1(styles$v.navToggle)
      }, React.createElement(AngleRightIcon, {
        "aria-hidden": "true"
      }))), React.createElement("section", {
        className: css$1(styles$v.navSubnav),
        "aria-labelledby": this.id,
        hidden: expandedState ? null : true
      }, srText && React.createElement("h2", {
        className: css$1(a11yStyles.screenReader),
        id: this.id
      }, srText), React.createElement("ul", {
        className: css$1(styles$v.navSimpleList)
      }, children))));
    }

  }

  _defineProperty$F(NavExpandable, "propTypes", {
    title: _pt.string.isRequired,
    srText: _pt.string,
    isExpanded: _pt.bool,
    children: _pt.node,
    className: _pt.string,
    groupId: _pt.oneOfType([_pt.string, _pt.number]),
    isActive: _pt.bool,
    id: _pt.string,
    onExpand: _pt.func
  });

  _defineProperty$F(NavExpandable, "defaultProps", {
    srText: '',
    isExpanded: false,
    children: '',
    className: '',
    groupId: null,
    isActive: false,
    id: ''
  });

  var notificationBadge = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      notificationBadge: 'pf-c-notification-badge',
      modifiers: {
          'unread': 'pf-m-unread',
          'read': 'pf-m-read'
      }
  };
  });

  var styles$w = unwrapExports(notificationBadge);

  function _extends$23() { _extends$23 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$23.apply(this, arguments); }

  function _objectWithoutProperties$22(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$21(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$21(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const NotificationBadge = (_ref) => {
    let {
      isRead = false,
      className,
      children
    } = _ref,
        props = _objectWithoutProperties$22(_ref, ["isRead", "className", "children"]);

    return React.createElement(ButtonWithOuiaContext, _extends$23({
      variant: exports.ButtonVariant.plain,
      className: className
    }, props), React.createElement("span", {
      className: css$1(styles$w.notificationBadge, isRead ? styles$w.modifiers.read : styles$w.modifiers.unread)
    }, children));
  };
  NotificationBadge.propTypes = {
    isRead: _pt.bool,
    children: _pt.node,
    className: _pt.string,
    'aria-label': _pt.string
  };

  var optionsMenu = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      optionsMenu: 'pf-c-options-menu',
      divider: 'pf-c-divider',
      optionsMenuToggle: 'pf-c-options-menu__toggle',
      optionsMenuToggleButton: 'pf-c-options-menu__toggle-button',
      optionsMenuToggleText: 'pf-c-options-menu__toggle-text',
      optionsMenuToggleIcon: 'pf-c-options-menu__toggle-icon',
      optionsMenuMenu: 'pf-c-options-menu__menu',
      optionsMenuMenuItem: 'pf-c-options-menu__menu-item',
      optionsMenuMenuItemIcon: 'pf-c-options-menu__menu-item-icon',
      optionsMenuSeparator: 'pf-c-options-menu__separator',
      optionsMenuGroup: 'pf-c-options-menu__group',
      optionsMenuGroupTitle: 'pf-c-options-menu__group-title',
      modifiers: {
          'plain': 'pf-m-plain',
          'text': 'pf-m-text',
          'hover': 'pf-m-hover',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus',
          'expanded': 'pf-m-expanded',
          'disabled': 'pf-m-disabled',
          'top': 'pf-m-top',
          'alignRight': 'pf-m-align-right'
      }
  };
  });

  var styles$x = unwrapExports(optionsMenu);

  function _extends$24() { _extends$24 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$24.apply(this, arguments); }

  function _objectWithoutProperties$23(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$22(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$22(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (OptionsMenuPosition) {
    OptionsMenuPosition["right"] = "right";
    OptionsMenuPosition["left"] = "left";
  })(exports.OptionsMenuPosition || (exports.OptionsMenuPosition = {}));

  (function (OptionsMenuDirection) {
    OptionsMenuDirection["up"] = "up";
    OptionsMenuDirection["down"] = "down";
  })(exports.OptionsMenuDirection || (exports.OptionsMenuDirection = {}));

  const OptionsMenu = (_ref) => {
    let {
      className = '',
      menuItems,
      toggle,
      isText = false,
      isGrouped = false,
      id,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      ref
    } = _ref,
        props = _objectWithoutProperties$23(_ref, ["className", "menuItems", "toggle", "isText", "isGrouped", "id", "ref"]);

    return React.createElement(DropdownContext.Provider, {
      value: {
        id,
        onSelect: () => undefined,
        toggleIconClass: styles$x.optionsMenuToggleIcon,
        toggleTextClass: styles$x.optionsMenuToggleText,
        menuClass: styles$x.optionsMenuMenu,
        itemClass: styles$x.optionsMenuMenuItem,
        toggleClass: isText ? styles$x.optionsMenuToggleButton : styles$x.optionsMenuToggle,
        baseClass: styles$x.optionsMenu,
        disabledClass: styles$x.modifiers.disabled,
        menuComponent: isGrouped ? 'div' : 'ul',
        baseComponent: 'div'
      }
    }, React.createElement(DropdownWithOuiaContext, _extends$24({}, props, {
      id: id,
      dropdownItems: menuItems,
      className: className,
      isGrouped: isGrouped,
      toggle: toggle
    })));
  };
  OptionsMenu.propTypes = {
    className: _pt.string,
    id: _pt.string.isRequired,
    menuItems: _pt.arrayOf(_pt.node).isRequired,
    toggle: _pt.element.isRequired,
    isPlain: _pt.bool,
    isOpen: _pt.bool,
    isText: _pt.bool,
    isGrouped: _pt.bool,
    ariaLabelMenu: _pt.string,
    position: _pt.oneOf(['right', 'left']),
    direction: _pt.oneOf(['up', 'down'])
  };

  function _extends$25() { _extends$25 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$25.apply(this, arguments); }

  function _objectWithoutProperties$24(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$23(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$23(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const OptionsMenuToggle = (_ref) => {
    let {
      isPlain = false,
      isHovered = false,
      isActive = false,
      isFocused = false,
      isDisabled = false,
      isOpen = false,
      parentId = '',
      toggleTemplate = React.createElement(React.Fragment, null),
      hideCaret = false,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      isSplitButton = false,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      type,
      'aria-label': ariaLabel = 'Options menu'
    } = _ref,
        props = _objectWithoutProperties$24(_ref, ["isPlain", "isHovered", "isActive", "isFocused", "isDisabled", "isOpen", "parentId", "toggleTemplate", "hideCaret", "isSplitButton", "type", "aria-label"]);

    return React.createElement(DropdownContext.Consumer, null, ({
      id: contextId
    }) => React.createElement(DropdownToggle, _extends$25({}, (isPlain || hideCaret) && {
      iconComponent: null
    }, props, {
      isPlain: isPlain,
      isOpen: isOpen,
      isDisabled: isDisabled,
      isHovered: isHovered,
      isActive: isActive,
      isFocused: isFocused,
      id: parentId ? `${parentId}-toggle` : `${contextId}-toggle`,
      ariaHasPopup: "listbox",
      "aria-label": ariaLabel,
      "aria-expanded": isOpen
    }, toggleTemplate ? {
      children: toggleTemplate
    } : {})));
  };
  OptionsMenuToggle.propTypes = {
    parentId: _pt.string,
    onToggle: _pt.func,
    isOpen: _pt.bool,
    isPlain: _pt.bool,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isSplitButton: _pt.bool,
    isActive: _pt.bool,
    isDisabled: _pt.bool,
    hideCaret: _pt.bool,
    'aria-label': _pt.string,
    onEnter: _pt.func,
    parentRef: _pt.any,
    toggleTemplate: _pt.node
  };

  function _extends$26() { _extends$26 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$26.apply(this, arguments); }

  function _objectWithoutProperties$25(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$24(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$24(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const OptionsMenuItemGroup = (_ref) => {
    let {
      className = '',
      ariaLabel = '',
      groupTitle = '',
      children = null,
      hasSeparator = false
    } = _ref,
        props = _objectWithoutProperties$25(_ref, ["className", "ariaLabel", "groupTitle", "children", "hasSeparator"]);

    return React.createElement("section", _extends$26({}, props, {
      className: css$1(styles$x.optionsMenuGroup)
    }), groupTitle && React.createElement("h1", {
      className: css$1(styles$x.optionsMenuGroupTitle)
    }, groupTitle), React.createElement("ul", {
      className: className,
      "aria-label": ariaLabel
    }, children, hasSeparator && React.createElement("li", {
      className: css$1(styles$x.optionsMenuSeparator),
      role: "separator"
    })));
  };
  OptionsMenuItemGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    ariaLabel: _pt.string,
    groupTitle: _pt.oneOfType([_pt.string, _pt.node]),
    hasSeparator: _pt.bool
  };

  function _extends$27() { _extends$27 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$27.apply(this, arguments); }

  function _objectWithoutProperties$26(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$25(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$25(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const OptionsMenuItem = (_ref) => {
    let {
      children = null,
      isSelected = false,
      onSelect = () => null,
      id = '',
      isDisabled
    } = _ref,
        props = _objectWithoutProperties$26(_ref, ["children", "isSelected", "onSelect", "id", "isDisabled"]);

    return React.createElement(DropdownItem, _extends$27({
      id: id,
      component: "button",
      isDisabled: isDisabled,
      onClick: event => onSelect(event)
    }, isDisabled && {
      'aria-disabled': true
    }, props), children, isSelected && React.createElement(CheckIcon, {
      className: css$1(styles$x.optionsMenuMenuItemIcon),
      "aria-hidden": isSelected
    }));
  };
  OptionsMenuItem.propTypes = {
    children: _pt.node,
    className: _pt.string,
    isSelected: _pt.bool,
    isDisabled: _pt.bool,
    onSelect: _pt.func,
    id: _pt.string
  };

  function _extends$28() { _extends$28 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$28.apply(this, arguments); }

  function _objectWithoutProperties$27(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$26(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$26(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const OptionsMenuSeparator = (_ref) => {
    let {
      className = ''
    } = _ref,
        props = _objectWithoutProperties$27(_ref, ["className"]);

    return React.createElement("li", _extends$28({
      className: css$1(styles$x.optionsMenuSeparator, className),
      role: "separator"
    }, props));
  };
  OptionsMenuSeparator.propTypes = {
    className: _pt.string
  };

  function _extends$29() { _extends$29 = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$29.apply(this, arguments); }

  function _objectWithoutProperties$28(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$27(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$27(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const OptionsMenuToggleWithText = (_ref) => {
    let {
      parentId = '',
      toggleText,
      toggleTextClassName = '',
      toggleButtonContents,
      toggleButtonContentsClassName = '',
      onToggle = () => null,
      isOpen = false,
      isPlain = false,
      isHovered = false,
      isActive = false,
      isFocused = false,
      isDisabled = false,

      /* eslint-disable @typescript-eslint/no-unused-vars */
      ariaHasPopup,
      parentRef,
      onEnter,

      /* eslint-enable @typescript-eslint/no-unused-vars */
      'aria-label': ariaLabel = 'Options menu'
    } = _ref,
        props = _objectWithoutProperties$28(_ref, ["parentId", "toggleText", "toggleTextClassName", "toggleButtonContents", "toggleButtonContentsClassName", "onToggle", "isOpen", "isPlain", "isHovered", "isActive", "isFocused", "isDisabled", "ariaHasPopup", "parentRef", "onEnter", "aria-label"]);

    return React.createElement("div", _extends$29({
      className: css$1(styles$x.optionsMenuToggle, getModifier(styles$x, 'text'), isPlain && getModifier(styles$x, 'plain'), isHovered && getModifier(styles$x, 'hover'), isActive && getModifier(styles$x, 'active'), isFocused && getModifier(styles$x, 'focus'), isDisabled && getModifier(styles$x, 'disabled'))
    }, props), React.createElement("span", {
      className: css$1(styles$x.optionsMenuToggleText, toggleTextClassName)
    }, toggleText), React.createElement("button", {
      className: css$1(styles$x.optionsMenuToggleButton, toggleButtonContentsClassName),
      id: `${parentId}-toggle`,
      "aria-haspopup": "listbox",
      "aria-label": ariaLabel,
      "aria-expanded": isOpen,
      onClick: () => onToggle(!isOpen)
    }, toggleButtonContents));
  };
  OptionsMenuToggleWithText.propTypes = {
    parentId: _pt.string,
    toggleText: _pt.node.isRequired,
    toggleTextClassName: _pt.string,
    toggleButtonContents: _pt.node,
    toggleButtonContentsClassName: _pt.string,
    onToggle: _pt.func,
    onEnter: _pt.func,
    isOpen: _pt.bool,
    isPlain: _pt.bool,
    isFocused: _pt.bool,
    isHovered: _pt.bool,
    isActive: _pt.bool,
    isDisabled: _pt.bool,
    parentRef: _pt.any,
    ariaHasPopup: _pt.oneOfType([_pt.bool, _pt.oneOf(['dialog']), _pt.oneOf(['menu']), _pt.oneOf(['false']), _pt.oneOf(['true']), _pt.oneOf(['listbox']), _pt.oneOf(['tree']), _pt.oneOf(['grid'])]),
    'aria-label': _pt.string
  };

  var page = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      pageHeader: 'pf-c-page__header',
      pageSidebar: 'pf-c-page__sidebar',
      pageMainSection: 'pf-c-page__main-section',
      card: 'pf-c-card',
      button: 'pf-c-button',
      page: 'pf-c-page',
      pageHeaderBrand: 'pf-c-page__header-brand',
      pageHeaderBrandLink: 'pf-c-page__header-brand-link',
      brand: 'pf-c-brand',
      pageHeaderBrandToggle: 'pf-c-page__header-brand-toggle',
      pageHeaderNav: 'pf-c-page__header-nav',
      nav: 'pf-c-nav',
      navScrollButton: 'pf-c-nav__scroll-button',
      pageHeaderTools: 'pf-c-page__header-tools',
      notificationBadge: 'pf-c-notification-badge',
      avatar: 'pf-c-avatar',
      pageHeaderToolsGroup: 'pf-c-page__header-tools-group',
      pageSidebarBody: 'pf-c-page__sidebar-body',
      pageMain: 'pf-c-page__main',
      pageDrawer: 'pf-c-page__drawer',
      pageMainNav: 'pf-c-page__main-nav',
      pageMainBreadcrumb: 'pf-c-page__main-breadcrumb',
      pageMainWizard: 'pf-c-page__main-wizard',
      drawer: 'pf-c-drawer',
      modifiers: {
          'dark': 'pf-m-dark',
          'icons': 'pf-m-icons',
          'selected': 'pf-m-selected',
          'unread': 'pf-m-unread',
          'mobile': 'pf-m-mobile',
          'user': 'pf-m-user',
          'expanded': 'pf-m-expanded',
          'collapsed': 'pf-m-collapsed',
          'fill': 'pf-m-fill',
          'noFill': 'pf-m-no-fill',
          'light': 'pf-m-light',
          'dark_100': 'pf-m-dark-100',
          'dark_200': 'pf-m-dark-200',
          'noPadding': 'pf-m-no-padding',
          'noPaddingMobile': 'pf-m-no-padding-mobile'
      }
  };
  });

  var styles$y = unwrapExports(page);

  var global_breakpoint_md = {"name":"--pf-global--breakpoint--md","value":"768px","var":"var(--pf-global--breakpoint--md)"};

  function _extends$2a() { _extends$2a = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2a.apply(this, arguments); }

  function _objectWithoutProperties$29(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$28(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$28(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$G(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (PageLayouts) {
    PageLayouts["vertical"] = "vertical";
    PageLayouts["horizontal"] = "horizontal";
  })(exports.PageLayouts || (exports.PageLayouts = {}));

  const PageContext = React.createContext({});
  const PageContextProvider = PageContext.Provider;
  const PageContextConsumer = PageContext.Consumer;
  class Page extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$G(this, "handleResize", () => {
        const {
          onPageResize
        } = this.props;
        const windowSize = window.innerWidth; // eslint-disable-next-line radix

        const mobileView = windowSize < Number.parseInt(global_breakpoint_md.value, 10);

        if (onPageResize) {
          onPageResize({
            mobileView,
            windowSize
          });
        } // eslint-disable-next-line @typescript-eslint/no-unused-vars


        this.setState(prevState => ({
          mobileView
        }));
      });

      _defineProperty$G(this, "onNavToggleMobile", () => {
        this.setState(prevState => ({
          mobileIsNavOpen: !prevState.mobileIsNavOpen
        }));
      });

      _defineProperty$G(this, "onNavToggleDesktop", () => {
        this.setState(prevState => ({
          desktopIsNavOpen: !prevState.desktopIsNavOpen
        }));
      });

      const {
        isManagedSidebar,
        defaultManagedSidebarIsOpen
      } = props;
      const managedSidebarOpen = !isManagedSidebar ? true : defaultManagedSidebarIsOpen;
      this.state = {
        desktopIsNavOpen: managedSidebarOpen,
        mobileIsNavOpen: false,
        mobileView: false
      };
    }

    componentDidMount() {
      const {
        isManagedSidebar,
        onPageResize
      } = this.props;

      if (isManagedSidebar || onPageResize) {
        window.addEventListener('resize', debounce(this.handleResize, 250)); // Initial check if should be shown

        this.handleResize();
      }
    }

    componentWillUnmount() {
      const {
        isManagedSidebar,
        onPageResize
      } = this.props;

      if (isManagedSidebar || onPageResize) {
        window.removeEventListener('resize', debounce(this.handleResize, 250));
      }
    }

    render() {
      const _this$props = this.props,
            {
        breadcrumb,
        className,
        children,
        header,
        sidebar,
        skipToContent,
        role,
        mainContainerId,
        isManagedSidebar,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        defaultManagedSidebarIsOpen,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onPageResize,
        mainAriaLabel
      } = _this$props,
            rest = _objectWithoutProperties$29(_this$props, ["breadcrumb", "className", "children", "header", "sidebar", "skipToContent", "role", "mainContainerId", "isManagedSidebar", "defaultManagedSidebarIsOpen", "onPageResize", "mainAriaLabel"]);

      const {
        mobileView,
        mobileIsNavOpen,
        desktopIsNavOpen
      } = this.state;
      const context = {
        isManagedSidebar,
        onNavToggle: mobileView ? this.onNavToggleMobile : this.onNavToggleDesktop,
        isNavOpen: mobileView ? mobileIsNavOpen : desktopIsNavOpen
      };
      return React.createElement(PageContextProvider, {
        value: context
      }, React.createElement("div", _extends$2a({}, rest, {
        className: css$1(styles$y.page, className)
      }), skipToContent, header, sidebar, React.createElement("main", {
        role: role,
        id: mainContainerId,
        className: css$1(styles$y.pageMain),
        tabIndex: -1,
        "aria-label": mainAriaLabel
      }, breadcrumb && React.createElement("section", {
        className: css$1(styles$y.pageMainBreadcrumb)
      }, breadcrumb), children)));
    }

  }

  _defineProperty$G(Page, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    header: _pt.node,
    sidebar: _pt.node,
    skipToContent: _pt.element,
    role: _pt.string,
    mainContainerId: _pt.string,
    isManagedSidebar: _pt.bool,
    defaultManagedSidebarIsOpen: _pt.bool,
    onPageResize: _pt.func,
    breadcrumb: _pt.node,
    mainAriaLabel: _pt.string
  });

  _defineProperty$G(Page, "defaultProps", {
    breadcrumb: null,
    children: null,
    className: '',
    header: null,
    sidebar: null,
    skipToContent: null,
    isManagedSidebar: false,
    defaultManagedSidebarIsOpen: true,
    onPageResize: () => null,
    mainContainerId: null,
    role: undefined
  });

  var barsIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.BarsIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var BarsIconConfig = {
    name: 'BarsIcon',
    height: 512,
    width: 448,
    svgPath: 'M16 132h416c8.837 0 16-7.163 16-16V76c0-8.837-7.163-16-16-16H16C7.163 60 0 67.163 0 76v40c0 8.837 7.163 16 16 16zm0 160h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16zm0 160h416c8.837 0 16-7.163 16-16v-40c0-8.837-7.163-16-16-16H16c-8.837 0-16 7.163-16 16v40c0 8.837 7.163 16 16 16z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.BarsIconConfig = BarsIconConfig;

  var _default = (0, _createIcon["default"])(BarsIconConfig);

  exports["default"] = _default;

  });

  var BarsIcon = unwrapExports(barsIcon);
  var barsIcon_1 = barsIcon.BarsIconConfig;

  function _extends$2b() { _extends$2b = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2b.apply(this, arguments); }

  function _objectWithoutProperties$2a(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$29(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$29(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const PageHeader = (_ref) => {
    let {
      className = '',
      logo = null,
      logoProps = null,
      logoComponent = 'a',
      toolbar = null,
      avatar = null,
      topNav = null,
      isNavOpen = true,
      role = undefined,
      showNavToggle = false,
      onNavToggle = () => undefined,
      'aria-label': ariaLabel = 'Global navigation'
    } = _ref,
        props = _objectWithoutProperties$2a(_ref, ["className", "logo", "logoProps", "logoComponent", "toolbar", "avatar", "topNav", "isNavOpen", "role", "showNavToggle", "onNavToggle", "aria-label"]);

    const LogoComponent = logoComponent;
    return React.createElement(PageContextConsumer, null, ({
      isManagedSidebar,
      onNavToggle: managedOnNavToggle,
      isNavOpen: managedIsNavOpen
    }) => {
      const navToggle = isManagedSidebar ? managedOnNavToggle : onNavToggle;
      const navOpen = isManagedSidebar ? managedIsNavOpen : isNavOpen;
      return React.createElement("header", _extends$2b({
        role: role,
        className: css$1(styles$y.pageHeader, className)
      }, props), (showNavToggle || logo) && React.createElement("div", {
        className: css$1(styles$y.pageHeaderBrand)
      }, showNavToggle && React.createElement("div", {
        className: css$1(styles$y.pageHeaderBrandToggle)
      }, React.createElement(ButtonWithOuiaContext, {
        id: "nav-toggle",
        onClick: navToggle,
        "aria-label": ariaLabel,
        "aria-controls": "page-sidebar",
        "aria-expanded": navOpen ? 'true' : 'false',
        variant: exports.ButtonVariant.plain
      }, React.createElement(BarsIcon, null))), logo && React.createElement(LogoComponent, _extends$2b({
        className: css$1(styles$y.pageHeaderBrandLink)
      }, logoProps), logo)), topNav && React.createElement("div", {
        className: css$1(styles$y.pageHeaderNav)
      }, topNav), (toolbar || avatar) && React.createElement("div", {
        className: css$1(styles$y.pageHeaderTools)
      }, toolbar, avatar));
    });
  };
  PageHeader.propTypes = {
    className: _pt.string,
    logo: _pt.node,
    logoProps: _pt.object,
    logoComponent: _pt.node,
    toolbar: _pt.node,
    avatar: _pt.node,
    topNav: _pt.node,
    showNavToggle: _pt.bool,
    isNavOpen: _pt.bool,
    isManagedSidebar: _pt.bool,
    role: _pt.string,
    onNavToggle: _pt.func,
    'aria-label': _pt.string
  };

  function _extends$2c() { _extends$2c = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2c.apply(this, arguments); }

  function _objectWithoutProperties$2b(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2a(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2a(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const PageSidebar = (_ref) => {
    let {
      className = '',
      nav,
      isNavOpen = true,
      theme = 'light'
    } = _ref,
        props = _objectWithoutProperties$2b(_ref, ["className", "nav", "isNavOpen", "theme"]);

    return React.createElement(PageContextConsumer, null, ({
      isManagedSidebar,
      isNavOpen: managedIsNavOpen
    }) => {
      const navOpen = isManagedSidebar ? managedIsNavOpen : isNavOpen;
      return React.createElement("div", _extends$2c({
        id: "page-sidebar",
        className: css$1(styles$y.pageSidebar, theme === 'dark' && styles$y.modifiers.dark, navOpen && styles$y.modifiers.expanded, !navOpen && styles$y.modifiers.collapsed, className)
      }, props), React.createElement("div", {
        className: css$1(styles$y.pageSidebarBody)
      }, nav));
    });
  };
  PageSidebar.propTypes = {
    className: _pt.string,
    nav: _pt.node,
    isManagedSidebar: _pt.bool,
    isNavOpen: _pt.bool,
    theme: _pt.oneOf(['dark', 'light'])
  };

  function _extends$2d() { _extends$2d = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2d.apply(this, arguments); }

  function _objectWithoutProperties$2c(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2b(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2b(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (PageSectionVariants) {
    PageSectionVariants["default"] = "default";
    PageSectionVariants["light"] = "light";
    PageSectionVariants["dark"] = "dark";
    PageSectionVariants["darker"] = "darker";
  })(exports.PageSectionVariants || (exports.PageSectionVariants = {}));

  (function (PageSectionTypes) {
    PageSectionTypes["default"] = "default";
    PageSectionTypes["nav"] = "nav";
  })(exports.PageSectionTypes || (exports.PageSectionTypes = {}));

  const PageSection = (_ref) => {
    let {
      className = '',
      children,
      variant = 'default',
      type = 'default',
      noPadding = false,
      noPaddingMobile = false,
      isFilled
    } = _ref,
        props = _objectWithoutProperties$2c(_ref, ["className", "children", "variant", "type", "noPadding", "noPaddingMobile", "isFilled"]);

    const variantType = {
      [exports.PageSectionTypes.default]: styles$y.pageMainSection,
      [exports.PageSectionTypes.nav]: styles$y.pageMainNav
    };
    const variantStyle = {
      [exports.PageSectionVariants.default]: '',
      [exports.PageSectionVariants.light]: styles$y.modifiers.light,
      [exports.PageSectionVariants.dark]: styles$y.modifiers.dark_200,
      [exports.PageSectionVariants.darker]: styles$y.modifiers.dark_100
    };
    return React.createElement("section", _extends$2d({}, props, {
      className: css$1(variantType[type], noPadding && styles$y.modifiers.noPadding, noPaddingMobile && styles$y.modifiers.noPaddingMobile, variantStyle[variant], isFilled === false && styles$y.modifiers.noFill, isFilled === true && styles$y.modifiers.fill, className)
    }), children);
  };
  PageSection.propTypes = {
    children: _pt.node,
    className: _pt.string,
    variant: _pt.oneOf(['default', 'light', 'dark', 'darker']),
    type: _pt.oneOf(['default', 'nav']),
    isFilled: _pt.bool,
    noPadding: _pt.bool,
    noPaddingMobile: _pt.bool
  };

  const ToggleTemplate = ({
    firstIndex = 0,
    lastIndex = 0,
    itemCount = 0,
    itemsTitle = 'items'
  }) => React.createElement(React.Fragment, null, React.createElement("b", null, firstIndex, " - ", lastIndex), ' ', "of ", React.createElement("b", null, itemCount), " ", itemsTitle);
  ToggleTemplate.propTypes = {
    firstIndex: _pt.number,
    lastIndex: _pt.number,
    itemCount: _pt.number,
    itemsTitle: _pt.string
  };

  var pagination = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      pagination: 'pf-c-pagination',
      paginationTotalItems: 'pf-c-pagination__total-items',
      optionsMenu: 'pf-c-options-menu',
      paginationNav: 'pf-c-pagination__nav',
      optionsMenuToggle: 'pf-c-options-menu__toggle',
      button: 'pf-c-button',
      paginationNavPageSelect: 'pf-c-pagination__nav-page-select',
      formControl: 'pf-c-form-control',
      paginationMenuText: 'pf-c-pagination__menu-text',
      modifiers: {
          'footer': 'pf-m-footer',
          'compact': 'pf-m-compact'
      }
  };
  });

  var styles$z = unwrapExports(pagination);

  var angleDoubleLeftIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.AngleDoubleLeftIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var AngleDoubleLeftIconConfig = {
    name: 'AngleDoubleLeftIcon',
    height: 512,
    width: 448,
    svgPath: 'M223.7 239l136-136c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9L319.9 256l96.4 96.4c9.4 9.4 9.4 24.6 0 33.9L393.7 409c-9.4 9.4-24.6 9.4-33.9 0l-136-136c-9.5-9.4-9.5-24.6-.1-34zm-192 34l136 136c9.4 9.4 24.6 9.4 33.9 0l22.6-22.6c9.4-9.4 9.4-24.6 0-33.9L127.9 256l96.4-96.4c9.4-9.4 9.4-24.6 0-33.9L201.7 103c-9.4-9.4-24.6-9.4-33.9 0l-136 136c-9.5 9.4-9.5 24.6-.1 34z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.AngleDoubleLeftIconConfig = AngleDoubleLeftIconConfig;

  var _default = (0, _createIcon["default"])(AngleDoubleLeftIconConfig);

  exports["default"] = _default;

  });

  var AngleDoubleLeftIcon = unwrapExports(angleDoubleLeftIcon);
  var angleDoubleLeftIcon_1 = angleDoubleLeftIcon.AngleDoubleLeftIconConfig;

  var angleDoubleRightIcon = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.AngleDoubleRightIconConfig = void 0;

  var _createIcon = _interopRequireDefault(createIcon_1);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /* This file is generated by createIcons.js any changes will be lost. */
  var AngleDoubleRightIconConfig = {
    name: 'AngleDoubleRightIcon',
    height: 512,
    width: 448,
    svgPath: 'M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34zm192-34l-136-136c-9.4-9.4-24.6-9.4-33.9 0l-22.6 22.6c-9.4 9.4-9.4 24.6 0 33.9l96.4 96.4-96.4 96.4c-9.4 9.4-9.4 24.6 0 33.9l22.6 22.6c9.4 9.4 24.6 9.4 33.9 0l136-136c9.4-9.2 9.4-24.4 0-33.8z',
    yOffset: '',
    xOffset: '',
    transform: ''
  };
  exports.AngleDoubleRightIconConfig = AngleDoubleRightIconConfig;

  var _default = (0, _createIcon["default"])(AngleDoubleRightIconConfig);

  exports["default"] = _default;

  });

  var AngleDoubleRightIcon = unwrapExports(angleDoubleRightIcon);
  var angleDoubleRightIcon_1 = angleDoubleRightIcon.AngleDoubleRightIconConfig;

  function _extends$2e() { _extends$2e = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2e.apply(this, arguments); }

  function _objectWithoutProperties$2d(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2c(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2c(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$H(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class Navigation extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$H(this, "handleNewPage", (_evt, newPage) => {
        const {
          perPage,
          onSetPage
        } = this.props;
        const startIdx = (newPage - 1) * perPage;
        const endIdx = newPage * perPage;
        return onSetPage(_evt, newPage, perPage, startIdx, endIdx);
      });

      this.state = {
        userInputPage: this.props.page
      };
    }

    static parseInteger(input, lastPage) {
      // eslint-disable-next-line radix
      let inputPage = Number.parseInt(input, 10);

      if (!Number.isNaN(inputPage)) {
        inputPage = inputPage > lastPage ? lastPage : inputPage;
        inputPage = inputPage < 1 ? 1 : inputPage;
      }

      return inputPage;
    }

    onChange(event, lastPage) {
      const inputPage = Navigation.parseInteger(event.target.value, lastPage);
      this.setState({
        userInputPage: Number.isNaN(inputPage) ? event.target.value : inputPage
      });
    }

    onKeyDown(event, page, lastPage, onPageInput) {
      if (event.keyCode === KEY_CODES.ENTER) {
        const inputPage = Navigation.parseInteger(this.state.userInputPage, lastPage);
        onPageInput(event, Number.isNaN(inputPage) ? page : inputPage);
        this.handleNewPage(event, Number.isNaN(inputPage) ? page : inputPage);
      }
    }

    componentDidUpdate(lastState) {
      if (this.props.page !== lastState.page && this.props.page <= this.props.lastPage && this.state.userInputPage !== this.props.page) {
        this.setState({
          userInputPage: this.props.page
        });
      }
    }

    render() {
      const _this$props = this.props,
            {
        page,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        perPage,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onSetPage,
        isDisabled,
        lastPage,
        firstPage,
        pagesTitle,
        toLastPage,
        toNextPage,
        toFirstPage,
        toPreviousPage,
        currPage,
        paginationTitle,
        onNextClick,
        onPreviousClick,
        onFirstClick,
        onLastClick,
        onPageInput,
        className,
        isCompact
      } = _this$props,
            props = _objectWithoutProperties$2d(_this$props, ["page", "perPage", "onSetPage", "isDisabled", "lastPage", "firstPage", "pagesTitle", "toLastPage", "toNextPage", "toFirstPage", "toPreviousPage", "currPage", "paginationTitle", "onNextClick", "onPreviousClick", "onFirstClick", "onLastClick", "onPageInput", "className", "isCompact"]);

      const {
        userInputPage
      } = this.state;
      return React.createElement("nav", _extends$2e({
        className: css$1(styles$z.paginationNav, className),
        "aria-label": paginationTitle
      }, props), !isCompact && React.createElement(ButtonWithOuiaContext, {
        variant: exports.ButtonVariant.plain,
        isDisabled: isDisabled || page === firstPage || page === 0,
        "aria-label": toFirstPage,
        "data-action": "first",
        onClick: event => {
          onFirstClick(event, 1);
          this.handleNewPage(event, 1);
          this.setState({
            userInputPage: 1
          });
        }
      }, React.createElement(AngleDoubleLeftIcon, null)), React.createElement(ButtonWithOuiaContext, {
        variant: exports.ButtonVariant.plain,
        isDisabled: isDisabled || page === firstPage || page === 0,
        "data-action": "previous",
        onClick: event => {
          const newPage = page - 1 >= 1 ? page - 1 : 1;
          onPreviousClick(event, newPage);
          this.handleNewPage(event, newPage);
          this.setState({
            userInputPage: newPage
          });
        },
        "aria-label": toPreviousPage
      }, React.createElement(AngleLeftIcon, null)), !isCompact && React.createElement("div", {
        className: css$1(styles$z.paginationNavPageSelect)
      }, React.createElement("input", {
        className: css$1(styles$z.formControl),
        "aria-label": currPage,
        type: "number",
        disabled: isDisabled || page === firstPage && page === lastPage || page === 0,
        min: lastPage <= 0 && firstPage <= 0 ? 0 : 1,
        max: lastPage,
        value: userInputPage,
        onKeyDown: event => this.onKeyDown(event, page, lastPage, onPageInput),
        onChange: event => this.onChange(event, lastPage)
      }), React.createElement("span", {
        "aria-hidden": "true"
      }, "of ", pagesTitle ? pluralize(lastPage, pagesTitle) : lastPage)), React.createElement(ButtonWithOuiaContext, {
        variant: exports.ButtonVariant.plain,
        isDisabled: isDisabled || page === lastPage,
        "aria-label": toNextPage,
        "data-action": "next",
        onClick: event => {
          const newPage = page + 1 <= lastPage ? page + 1 : lastPage;
          onNextClick(event, newPage);
          this.handleNewPage(event, newPage);
          this.setState({
            userInputPage: newPage
          });
        }
      }, React.createElement(AngleRightIcon, null)), !isCompact && React.createElement(ButtonWithOuiaContext, {
        variant: exports.ButtonVariant.plain,
        isDisabled: isDisabled || page === lastPage,
        "aria-label": toLastPage,
        "data-action": "last",
        onClick: event => {
          onLastClick(event, lastPage);
          this.handleNewPage(event, lastPage);
          this.setState({
            userInputPage: lastPage
          });
        }
      }, React.createElement(AngleDoubleRightIcon, null)));
    }

  }

  _defineProperty$H(Navigation, "propTypes", {
    className: _pt.string,
    isDisabled: _pt.bool,
    isCompact: _pt.bool,
    lastPage: _pt.number,
    firstPage: _pt.number,
    pagesTitle: _pt.string,
    toLastPage: _pt.string,
    toPreviousPage: _pt.string,
    toNextPage: _pt.string,
    toFirstPage: _pt.string,
    currPage: _pt.string,
    paginationTitle: _pt.string,
    page: _pt.node.isRequired,
    perPage: _pt.number,
    onSetPage: _pt.any.isRequired,
    onNextClick: _pt.func,
    onPreviousClick: _pt.func,
    onFirstClick: _pt.func,
    onLastClick: _pt.func,
    onPageInput: _pt.func
  });

  _defineProperty$H(Navigation, "defaultProps", {
    className: '',
    isDisabled: false,
    isCompact: false,
    lastPage: 0,
    firstPage: 0,
    pagesTitle: '',
    toLastPage: 'Go to last page',
    toNextPage: 'Go to next page',
    toFirstPage: 'Go to first page',
    toPreviousPage: 'Go to previous page',
    currPage: 'Current page',
    paginationTitle: 'Pagination',
    onNextClick: () => undefined,
    onPreviousClick: () => undefined,
    onFirstClick: () => undefined,
    onLastClick: () => undefined,
    onPageInput: () => undefined
  });

  let toggleId = 0;
  const OptionsToggle = ({
    itemsTitle = 'items',
    optionsToggle = 'Select',
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    itemsPerPageTitle = 'Items per page',
    firstIndex = 0,
    lastIndex = 0,
    itemCount = 0,
    widgetId = '',
    showToggle = true,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToggle = _isOpen => undefined,
    isOpen = false,
    isDisabled = false,
    parentRef = null,
    toggleTemplate: ToggleTemplate = '',
    onEnter = null
  }) => React.createElement("div", {
    className: css$1(styles$x.optionsMenuToggle, isDisabled && styles$x.modifiers.disabled, styles$x.modifiers.plain, styles$x.modifiers.text)
  }, showToggle && React.createElement(React.Fragment, null, React.createElement("span", {
    className: css$1(styles$x.optionsMenuToggleText)
  }, typeof ToggleTemplate === 'string' ? fillTemplate(ToggleTemplate, {
    firstIndex,
    lastIndex,
    itemCount,
    itemsTitle
  }) : React.createElement(ToggleTemplate, {
    firstIndex: firstIndex,
    lastIndex: lastIndex,
    itemCount: itemCount,
    itemsTitle: itemsTitle
  })), React.createElement(DropdownToggle, {
    onEnter: onEnter,
    "aria-label": optionsToggle,
    onToggle: onToggle,
    isDisabled: isDisabled || itemCount <= 0,
    isOpen: isOpen,
    id: `${widgetId}-toggle-${toggleId++}`,
    className: styles$x.optionsMenuToggleButton,
    parentRef: parentRef
  })));
  OptionsToggle.propTypes = {
    itemsTitle: _pt.string,
    optionsToggle: _pt.string,
    itemsPerPageTitle: _pt.string,
    firstIndex: _pt.number,
    lastIndex: _pt.number,
    itemCount: _pt.number,
    widgetId: _pt.string,
    showToggle: _pt.bool,
    onToggle: _pt.func,
    isOpen: _pt.bool,
    isDisabled: _pt.bool,
    parentRef: _pt.any,
    toggleTemplate: _pt.oneOfType([_pt.func, _pt.string]),
    onEnter: _pt.func
  };

  function _defineProperty$I(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class PaginationOptionsMenu extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$I(this, "parentRef", React.createRef());

      _defineProperty$I(this, "onToggle", isOpen => {
        this.setState({
          isOpen
        });
      });

      _defineProperty$I(this, "onSelect", () => {
        this.setState(prevState => ({
          isOpen: !prevState.isOpen
        }));
      });

      _defineProperty$I(this, "handleNewPerPage", (_evt, newPerPage) => {
        const {
          page,
          onPerPageSelect,
          itemCount,
          defaultToFullPage
        } = this.props;
        let newPage = page;

        while (Math.ceil(itemCount / newPerPage) < newPage) {
          newPage--;
        }

        if (defaultToFullPage) {
          if (itemCount / newPerPage !== newPage) {
            while (newPage > 1 && itemCount - newPerPage * newPage < 0) {
              newPage--;
            }
          }
        }

        const startIdx = (newPage - 1) * newPerPage;
        const endIdx = newPage * newPerPage;
        return onPerPageSelect(_evt, newPerPage, newPage, startIdx, endIdx);
      });

      _defineProperty$I(this, "renderItems", () => {
        const {
          perPageOptions,
          perPage,
          perPageSuffix
        } = this.props;
        return perPageOptions.map(({
          value,
          title
        }) => React.createElement(DropdownItem, {
          key: value,
          component: "button",
          "data-action": `per-page-${value}`,
          className: css$1(perPage === value && 'pf-m-selected'),
          onClick: event => this.handleNewPerPage(event, value)
        }, title, React.createElement("span", {
          className: css$1(styles$z.paginationMenuText)
        }, ` ${perPageSuffix}`), perPage === value && React.createElement("i", {
          className: css$1(styles$x.optionsMenuMenuItemIcon)
        }, React.createElement(CheckIcon, null))));
      });

      this.state = {
        isOpen: false
      };
    }

    render() {
      const {
        widgetId,
        isDisabled,
        itemsPerPageTitle,
        dropDirection,
        optionsToggle,
        perPageOptions,
        toggleTemplate,
        firstIndex,
        lastIndex,
        itemCount,
        itemsTitle
      } = this.props;
      const {
        isOpen
      } = this.state;
      return React.createElement(DropdownContext.Provider, {
        value: {
          id: widgetId,
          onSelect: this.onSelect,
          toggleIconClass: styles$x.optionsMenuToggleIcon,
          toggleTextClass: styles$x.optionsMenuToggleText,
          menuClass: styles$x.optionsMenuMenu,
          itemClass: styles$x.optionsMenuMenuItem,
          toggleClass: ' ',
          baseClass: styles$x.optionsMenu,
          disabledClass: styles$x.modifiers.disabled,
          menuComponent: 'ul',
          baseComponent: 'div'
        }
      }, React.createElement(DropdownWithOuiaContext, {
        direction: dropDirection,
        isOpen: isOpen,
        toggle: React.createElement(OptionsToggle, {
          optionsToggle: optionsToggle,
          itemsPerPageTitle: itemsPerPageTitle,
          showToggle: perPageOptions && perPageOptions.length > 0,
          onToggle: this.onToggle,
          isOpen: isOpen,
          widgetId: widgetId,
          firstIndex: firstIndex,
          lastIndex: lastIndex,
          itemCount: itemCount,
          itemsTitle: itemsTitle,
          toggleTemplate: toggleTemplate,
          parentRef: this.parentRef.current,
          isDisabled: isDisabled
        }),
        dropdownItems: this.renderItems(),
        isPlain: true
      }));
    }

  }

  _defineProperty$I(PaginationOptionsMenu, "propTypes", {
    className: _pt.string,
    widgetId: _pt.string,
    isDisabled: _pt.bool,
    dropDirection: _pt.oneOf(['up', 'down']),
    perPageOptions: _pt.arrayOf(_pt.any),
    itemsPerPageTitle: _pt.string,
    page: _pt.number,
    perPageSuffix: _pt.string,
    itemsTitle: _pt.string,
    optionsToggle: _pt.string,
    itemCount: _pt.number,
    firstIndex: _pt.number,
    lastIndex: _pt.number,
    defaultToFullPage: _pt.bool,
    perPage: _pt.number,
    lastPage: _pt.number,
    toggleTemplate: _pt.oneOfType([_pt.func, _pt.string]),
    onPerPageSelect: _pt.any
  });

  _defineProperty$I(PaginationOptionsMenu, "defaultProps", {
    className: '',
    widgetId: '',
    isDisabled: false,
    dropDirection: exports.DropdownDirection.down,
    perPageOptions: [],
    itemsPerPageTitle: 'Items per page',
    perPageSuffix: 'per page',
    optionsToggle: 'Select',
    perPage: 0,
    firstIndex: 0,
    lastIndex: 0,
    defaultToFullPage: false,
    itemCount: 0,
    itemsTitle: 'items',
    toggleTemplate: ({
      firstIndex,
      lastIndex,
      itemCount,
      itemsTitle
    }) => React.createElement(React.Fragment, null, React.createElement("b", null, firstIndex, " - ", lastIndex), ' ', "of", React.createElement("b", null, itemCount), " ", itemsTitle),
    onPerPageSelect: () => null
  });

  const c_pagination__nav_page_select_c_form_control_width_chars = {"name":"--pf-c-pagination__nav-page-select--c-form-control--width-chars","value":"2","var":"var(--pf-c-pagination__nav-page-select--c-form-control--width-chars)"};

  function _extends$2f() { _extends$2f = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2f.apply(this, arguments); }

  function _objectWithoutProperties$2e(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2d(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2d(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$J(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (PaginationVariant) {
    PaginationVariant["top"] = "top";
    PaginationVariant["bottom"] = "bottom";
    PaginationVariant["left"] = "left";
    PaginationVariant["right"] = "right";
  })(exports.PaginationVariant || (exports.PaginationVariant = {}));

  const defaultPerPageOptions = [{
    title: '10',
    value: 10
  }, {
    title: '20',
    value: 20
  }, {
    title: '50',
    value: 50
  }, {
    title: '100',
    value: 100
  }];

  const handleInputWidth = (lastPage, node) => {
    if (!node) {
      return;
    }

    const len = String(lastPage).length;

    if (len >= 3) {
      node.style.setProperty(c_pagination__nav_page_select_c_form_control_width_chars.name, `${len}`);
    } else {
      node.style.setProperty(c_pagination__nav_page_select_c_form_control_width_chars.name, '2');
    }
  };

  let paginationId = 0;

  class Pagination extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$J(this, "paginationRef", React.createRef());
    }

    getLastPage() {
      const {
        itemCount,
        perPage
      } = this.props;
      return Math.ceil(itemCount / perPage) || 0;
    }

    componentDidMount() {
      const node = this.paginationRef.current;
      handleInputWidth(this.getLastPage(), node);
    }

    componentDidUpdate(prevProps) {
      const node = this.paginationRef.current;

      if (prevProps.perPage !== this.props.perPage || prevProps.itemCount !== this.props.itemCount) {
        handleInputWidth(this.getLastPage(), node);
      }
    }

    render() {
      const _this$props = this.props,
            {
        children,
        className,
        variant,
        isDisabled,
        isCompact,
        perPage,
        titles,
        firstPage,
        page: propPage,
        offset,
        defaultToFullPage,
        itemCount,
        itemsStart,
        itemsEnd,
        perPageOptions,
        dropDirection,
        widgetId,
        toggleTemplate,
        onSetPage,
        onPerPageSelect,
        onFirstClick,
        onPreviousClick,
        onNextClick,
        onPageInput,
        onLastClick,
        ouiaContext,
        ouiaId
      } = _this$props,
            props = _objectWithoutProperties$2e(_this$props, ["children", "className", "variant", "isDisabled", "isCompact", "perPage", "titles", "firstPage", "page", "offset", "defaultToFullPage", "itemCount", "itemsStart", "itemsEnd", "perPageOptions", "dropDirection", "widgetId", "toggleTemplate", "onSetPage", "onPerPageSelect", "onFirstClick", "onPreviousClick", "onNextClick", "onPageInput", "onLastClick", "ouiaContext", "ouiaId"]);

      let page = propPage;

      if (!page && offset) {
        page = Math.ceil(offset / perPage);
      }

      const lastPage = this.getLastPage();

      if (page < firstPage && itemCount > 0) {
        page = firstPage;
      } else if (page > lastPage) {
        page = lastPage;
      }

      const firstIndex = itemCount <= 0 ? 0 : (page - 1) * perPage + 1;
      let lastIndex;

      if (itemCount <= 0) {
        lastIndex = 0;
      } else {
        lastIndex = page === lastPage ? itemCount : page * perPage;
      }

      return React.createElement("div", _extends$2f({
        ref: this.paginationRef,
        className: css$1(styles$z.pagination, variant === exports.PaginationVariant.bottom && styles$z.modifiers.footer, isCompact && styles$z.modifiers.compact, className),
        id: `${widgetId}-${paginationId++}`
      }, ouiaContext.isOuia && {
        'data-ouia-component-type': 'Pagination',
        'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
      }, props), variant === exports.PaginationVariant.top && React.createElement("div", {
        className: css$1(styles$z.paginationTotalItems)
      }, React.createElement(ToggleTemplate, {
        firstIndex: firstIndex,
        lastIndex: lastIndex,
        itemCount: itemCount,
        itemsTitle: titles.items
      })), React.createElement(PaginationOptionsMenu, {
        itemsPerPageTitle: titles.itemsPerPage,
        perPageSuffix: titles.perPageSuffix,
        itemsTitle: isCompact ? '' : titles.items,
        optionsToggle: titles.optionsToggle,
        perPageOptions: perPageOptions,
        firstIndex: itemsStart !== null ? itemsStart : firstIndex,
        lastIndex: itemsEnd !== null ? itemsEnd : lastIndex,
        defaultToFullPage: defaultToFullPage,
        itemCount: itemCount,
        page: page,
        perPage: perPage,
        lastPage: lastPage,
        onPerPageSelect: onPerPageSelect,
        dropDirection: dropDirection,
        widgetId: widgetId,
        toggleTemplate: toggleTemplate,
        isDisabled: isDisabled
      }), React.createElement(Navigation, {
        pagesTitle: titles.page,
        toLastPage: titles.toLastPage,
        toPreviousPage: titles.toPreviousPage,
        toNextPage: titles.toNextPage,
        toFirstPage: titles.toFirstPage,
        currPage: titles.currPage,
        paginationTitle: titles.paginationTitle,
        page: itemCount <= 0 ? 0 : page,
        perPage: perPage,
        firstPage: itemsStart !== null ? itemsStart : 1,
        lastPage: lastPage,
        onSetPage: onSetPage,
        onFirstClick: onFirstClick,
        onPreviousClick: onPreviousClick,
        onNextClick: onNextClick,
        onLastClick: onLastClick,
        onPageInput: onPageInput,
        isDisabled: isDisabled,
        isCompact: isCompact
      }), children);
    }

  }

  _defineProperty$J(Pagination, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    itemCount: _pt.number.isRequired,
    variant: _pt.oneOf(['top', 'bottom', 'left', 'right']),
    isDisabled: _pt.bool,
    isCompact: _pt.bool,
    perPage: _pt.number,
    perPageOptions: _pt.arrayOf(_pt.shape({
      title: _pt.string,
      value: _pt.number
    })),
    defaultToFullPage: _pt.bool,
    firstPage: _pt.number,
    page: _pt.number,
    offset: _pt.number,
    itemsStart: _pt.number,
    itemsEnd: _pt.number,
    widgetId: _pt.string,
    dropDirection: _pt.oneOf(['up', 'down']),
    titles: _pt.shape({
      page: _pt.string,
      items: _pt.string,
      itemsPerPage: _pt.string,
      perPageSuffix: _pt.string,
      toFirstPage: _pt.string,
      toPreviousPage: _pt.string,
      toLastPage: _pt.string,
      toNextPage: _pt.string,
      optionsToggle: _pt.string,
      currPage: _pt.string,
      paginationTitle: _pt.string
    }),
    toggleTemplate: _pt.oneOfType([_pt.func, _pt.string]),
    onSetPage: _pt.func,
    onFirstClick: _pt.func,
    onPreviousClick: _pt.func,
    onNextClick: _pt.func,
    onLastClick: _pt.func,
    onPageInput: _pt.func,
    onPerPageSelect: _pt.func
  });

  _defineProperty$J(Pagination, "defaultProps", {
    children: null,
    className: '',
    variant: exports.PaginationVariant.top,
    isDisabled: false,
    isCompact: false,
    perPage: defaultPerPageOptions[0].value,
    titles: {
      items: '',
      page: '',
      itemsPerPage: 'Items per page',
      perPageSuffix: 'per page',
      toFirstPage: 'Go to first page',
      toPreviousPage: 'Go to previous page',
      toLastPage: 'Go to last page',
      toNextPage: 'Go to next page',
      optionsToggle: 'Items per page',
      currPage: 'Current page',
      paginationTitle: 'Pagination'
    },
    firstPage: 1,
    page: 0,
    offset: 0,
    defaultToFullPage: false,
    itemsStart: null,
    itemsEnd: null,
    perPageOptions: defaultPerPageOptions,
    dropDirection: exports.DropdownDirection.down,
    widgetId: 'pagination-options-menu',
    toggleTemplate: ToggleTemplate,
    onSetPage: () => undefined,
    onPerPageSelect: () => undefined,
    onFirstClick: () => undefined,
    onPreviousClick: () => undefined,
    onNextClick: () => undefined,
    onPageInput: () => undefined,
    onLastClick: () => undefined,
    ouiaContext: null,
    ouiaId: null
  });

  const PaginationWithOuiaContext = withOuiaContext(Pagination);

  var popover = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      popover: 'pf-c-popover',
      popoverArrow: 'pf-c-popover__arrow',
      popoverContent: 'pf-c-popover__content',
      title: 'pf-c-title',
      button: 'pf-c-button',
      popoverBody: 'pf-c-popover__body',
      popoverFooter: 'pf-c-popover__footer',
      modifiers: {
          'top': 'pf-m-top',
          'bottom': 'pf-m-bottom',
          'left': 'pf-m-left',
          'right': 'pf-m-right'
      }
  };
  });

  var styles$A = unwrapExports(popover);

  function _extends$2g() { _extends$2g = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2g.apply(this, arguments); }

  function _objectWithoutProperties$2f(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2e(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2e(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const PopoverContent = (_ref) => {
    let {
      className = null,
      children
    } = _ref,
        props = _objectWithoutProperties$2f(_ref, ["className", "children"]);

    return React.createElement("div", _extends$2g({
      className: css$1(styles$A.popoverContent, className)
    }, props), children);
  };
  PopoverContent.propTypes = {
    className: _pt.string,
    children: _pt.node.isRequired
  };

  function _extends$2h() { _extends$2h = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2h.apply(this, arguments); }

  function _objectWithoutProperties$2g(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2f(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2f(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const PopoverBody = (_ref) => {
    let {
      children,
      id
    } = _ref,
        props = _objectWithoutProperties$2g(_ref, ["children", "id"]);

    return React.createElement("div", _extends$2h({
      className: css$1(styles$A.popoverBody),
      id: id
    }, props), children);
  };
  PopoverBody.propTypes = {
    id: _pt.string.isRequired,
    children: _pt.node.isRequired
  };

  function _extends$2i() { _extends$2i = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2i.apply(this, arguments); }

  function _objectWithoutProperties$2h(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2g(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2g(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const PopoverHeader = (_ref) => {
    let {
      children,
      id
    } = _ref,
        props = _objectWithoutProperties$2h(_ref, ["children", "id"]);

    return React.createElement(Title, _extends$2i({
      headingLevel: "h6",
      size: exports.TitleSize.xl,
      id: id
    }, props), children);
  };
  PopoverHeader.propTypes = {
    id: _pt.string.isRequired,
    children: _pt.node.isRequired
  };

  function _extends$2j() { _extends$2j = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2j.apply(this, arguments); }

  function _objectWithoutProperties$2i(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2h(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2h(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const PopoverFooter = (_ref) => {
    let {
      children,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$2i(_ref, ["children", "className"]);

    return React.createElement("footer", _extends$2j({
      className: css$1(styles$A.popoverFooter, className)
    }, props), children);
  };
  PopoverFooter.propTypes = {
    className: _pt.string,
    children: _pt.node.isRequired
  };

  function _extends$2k() { _extends$2k = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2k.apply(this, arguments); }

  function _objectWithoutProperties$2j(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2i(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2i(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const PopoverCloseButton = (_ref) => {
    let {
      onClose = () => undefined
    } = _ref,
        props = _objectWithoutProperties$2j(_ref, ["onClose"]);

    return React.createElement(ButtonWithOuiaContext, _extends$2k({
      onClick: onClose,
      variant: "plain",
      "aria-label": true
    }, props, {
      style: {
        pointerEvents: 'auto'
      }
    }), React.createElement(TimesIcon, null));
  };
  PopoverCloseButton.propTypes = {
    onClose: _pt.func,
    'aria-label': _pt.string.isRequired
  };

  var c_popover_MaxWidth = {"name":"--pf-c-popover--MaxWidth","value":"calc(2rem + 18.75rem)","var":"var(--pf-c-popover--MaxWidth)"};

  function _extends$2l() { _extends$2l = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2l.apply(this, arguments); }

  function _objectWithoutProperties$2k(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2j(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2j(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$K(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (PopoverPosition) {
    PopoverPosition["auto"] = "auto";
    PopoverPosition["top"] = "top";
    PopoverPosition["bottom"] = "bottom";
    PopoverPosition["left"] = "left";
    PopoverPosition["right"] = "right";
  })(exports.PopoverPosition || (exports.PopoverPosition = {}));

  class Popover extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$K(this, "hideOrNotify", () => {
        if (this.props.isVisible === null) {
          // Handle closing
          this.tip.hide();
        } else {
          // notify consumer
          this.props.shouldClose(this.tip);
        }
      });

      _defineProperty$K(this, "handleEscOrEnterKey", event => {
        if (event.keyCode === KEY_CODES.ESCAPE_KEY && this.tip.state.isVisible) {
          this.hideOrNotify();
        } else if (!this.state.isOpen && event.keyCode === KEY_CODES.ENTER) {
          this.setState({
            focusTrapActive: true
          });
        }
      });

      _defineProperty$K(this, "storeTippyInstance", tip => {
        if (this.props.minWidth) {
          tip.popperChildren.tooltip.style.minWidth = this.props.minWidth;
        }

        tip.popperChildren.tooltip.classList.add(styles$A.popover);
        this.tip = tip;
      });

      _defineProperty$K(this, "closePopover", () => {
        this.hideOrNotify();
        this.setState({
          focusTrapActive: false
        });
      });

      _defineProperty$K(this, "hideAllPopovers", () => {
        document.querySelectorAll('.tippy-popper').forEach(popper => {
          if (popper._tippy) {
            popper._tippy.hide();
          }
        });
      });

      _defineProperty$K(this, "onHide", tip => {
        if (this.state.isOpen) {
          this.setState({
            isOpen: false
          });
        }

        return this.props.onHide(tip);
      });

      _defineProperty$K(this, "onHidden", tip => this.props.onHidden(tip));

      _defineProperty$K(this, "onMount", tip => this.props.onMount(tip));

      _defineProperty$K(this, "onShow", tip => {
        const {
          hideOnOutsideClick,
          isVisible,
          onShow
        } = this.props; // hide all other open popovers first if events are managed by us

        if (!hideOnOutsideClick && isVisible === null) {
          this.hideAllPopovers();
        }

        if (this.state.isOpen === false) {
          this.setState({
            isOpen: true
          });
        }

        return onShow(tip);
      });

      _defineProperty$K(this, "onShown", tip => this.props.onShown(tip));

      _defineProperty$K(this, "onContentMouseDown", () => {
        if (this.state.focusTrapActive) {
          this.setState({
            focusTrapActive: false
          });
        }
      });

      this.state = {
        isOpen: false,
        focusTrapActive: false
      };
    }

    componentDidMount() {
      document.addEventListener('keydown', this.handleEscOrEnterKey, false);
    }

    componentWillUnmount() {
      document.removeEventListener('keydown', this.handleEscOrEnterKey, false);
    }

    render() {
      /* eslint-disable @typescript-eslint/no-unused-vars */
      const _this$props = this.props,
            {
        position,
        enableFlip,
        children,
        className,
        'aria-label': ariaLabel,
        headerContent,
        bodyContent,
        footerContent,
        isVisible,
        shouldClose,
        appendTo,
        hideOnOutsideClick,
        onHide,
        onHidden,
        onShow,
        onShown,
        onMount,
        zIndex,
        minWidth,
        maxWidth,
        closeBtnAriaLabel,
        distance,
        boundary,
        flipBehavior,
        tippyProps
      } = _this$props,
            rest = _objectWithoutProperties$2k(_this$props, ["position", "enableFlip", "children", "className", "aria-label", "headerContent", "bodyContent", "footerContent", "isVisible", "shouldClose", "appendTo", "hideOnOutsideClick", "onHide", "onHidden", "onShow", "onShown", "onMount", "zIndex", "minWidth", "maxWidth", "closeBtnAriaLabel", "distance", "boundary", "flipBehavior", "tippyProps"]);
      /* eslint-enable @typescript-eslint/no-unused-vars */


      if (!headerContent && !ariaLabel) {
        return new Error('aria-label is required when header is not used');
      }

      const content = this.state.isOpen ? React.createElement(GenerateId, null, randomId => React.createElement(FocusTrap, {
        active: this.state.focusTrapActive,
        focusTrapOptions: {
          clickOutsideDeactivates: true
        }
      }, React.createElement("div", _extends$2l({
        className: css$1(!enableFlip && getModifier(styles$A, position, styles$A.modifiers.top), className),
        role: "dialog",
        "aria-modal": "true",
        "aria-label": headerContent ? undefined : ariaLabel,
        "aria-labelledby": headerContent ? `popover-${randomId}-header` : undefined,
        "aria-describedby": `popover-${randomId}-body`,
        onMouseDown: this.onContentMouseDown
      }, rest), React.createElement(PopoverContent, null, React.createElement(PopoverCloseButton, {
        onClose: this.closePopover,
        "aria-label": closeBtnAriaLabel
      }), headerContent && React.createElement(PopoverHeader, {
        id: `popover-${randomId}-header`
      }, headerContent), React.createElement(PopoverBody, {
        id: `popover-${randomId}-body`
      }, bodyContent), footerContent && React.createElement(PopoverFooter, null, footerContent))))) : React.createElement(React.Fragment, null);
      const handleEvents = isVisible === null;

      const shouldHideOnClick = () => {
        if (handleEvents) {
          if (hideOnOutsideClick === true) {
            return true;
          }

          return 'toggle';
        }

        return false;
      };

      return React.createElement(PopoverBase, _extends$2l({}, tippyProps, {
        arrow: true,
        onCreate: this.storeTippyInstance,
        maxWidth: maxWidth,
        zIndex: zIndex,
        appendTo: appendTo,
        content: content,
        lazy: true,
        trigger: handleEvents ? 'click' : 'manual',
        isVisible: isVisible,
        hideOnClick: shouldHideOnClick(),
        theme: "pf-popover",
        interactive: true,
        interactiveBorder: 0,
        placement: position,
        distance: distance,
        flip: enableFlip,
        flipBehavior: flipBehavior,
        boundary: boundary,
        popperOptions: {
          modifiers: {
            preventOverflow: {
              enabled: enableFlip
            },
            hide: {
              enabled: enableFlip
            }
          }
        },
        onHide: tip => this.onHide(tip),
        onHidden: tip => this.onHidden(tip),
        onShow: tip => this.onShow(tip),
        onShown: tip => this.onShown(tip),
        onMount: tip => this.onMount(tip)
      }), children);
    }

  }

  _defineProperty$K(Popover, "propTypes", {
    'aria-label': _pt.string,
    appendTo: _pt.oneOfType([_pt.element, _pt.func]),
    bodyContent: _pt.node.isRequired,
    boundary: _pt.oneOfType([_pt.oneOf(['scrollParent']), _pt.oneOf(['window']), _pt.oneOf(['viewport']), _pt.any]),
    children: _pt.element.isRequired,
    className: _pt.string,
    closeBtnAriaLabel: _pt.string,
    distance: _pt.number,
    enableFlip: _pt.bool,
    flipBehavior: _pt.oneOfType([_pt.oneOf(['flip']), _pt.arrayOf(_pt.oneOf(['top', 'bottom', 'left', 'right']))]),
    footerContent: _pt.node,
    headerContent: _pt.node,
    hideOnOutsideClick: _pt.bool,
    isVisible: _pt.bool,
    minWidth: _pt.string,
    maxWidth: _pt.string,
    onHidden: _pt.func,
    onHide: _pt.func,
    onMount: _pt.func,
    onShow: _pt.func,
    onShown: _pt.func,
    position: _pt.oneOf(['auto', 'top', 'bottom', 'left', 'right']),
    shouldClose: _pt.func,
    zIndex: _pt.number,
    tippyProps: _pt.any
  });

  _defineProperty$K(Popover, "defaultProps", {
    position: 'top',
    enableFlip: true,
    className: '',
    isVisible: null,
    shouldClose: () => null,
    'aria-label': '',
    headerContent: null,
    footerContent: null,
    appendTo: () => document.body,
    hideOnOutsideClick: true,
    onHide: () => null,
    onHidden: () => null,
    onShow: () => null,
    onShown: () => null,
    onMount: () => null,
    zIndex: 9999,
    maxWidth: c_popover_MaxWidth && c_popover_MaxWidth.value,
    closeBtnAriaLabel: 'Close',
    distance: 25,
    boundary: 'window',
    // For every initial starting position, there are 3 escape positions
    flipBehavior: ['top', 'right', 'bottom', 'left', 'top', 'right', 'bottom'],
    tippyProps: {}
  });

  var progress = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      progress: 'pf-c-progress',
      progressDescription: 'pf-c-progress__description',
      progressMeasure: 'pf-c-progress__measure',
      progressIndicator: 'pf-c-progress__indicator',
      progressStatus: 'pf-c-progress__status',
      progressBar: 'pf-c-progress__bar',
      progressStatusIcon: 'pf-c-progress__status-icon',
      modifiers: {
          'sm': 'pf-m-sm',
          'lg': 'pf-m-lg',
          'inside': 'pf-m-inside',
          'outside': 'pf-m-outside',
          'singleline': 'pf-m-singleline',
          'success': 'pf-m-success',
          'danger': 'pf-m-danger'
      }
  };
  });

  var styles$B = unwrapExports(progress);

  function _extends$2m() { _extends$2m = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2m.apply(this, arguments); }

  function _objectWithoutProperties$2l(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2k(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2k(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const ProgressBar = (_ref) => {
    let {
      ariaProps,
      className = '',
      children = null,
      value
    } = _ref,
        props = _objectWithoutProperties$2l(_ref, ["ariaProps", "className", "children", "value"]);

    return React.createElement("div", _extends$2m({}, props, {
      className: css$1(styles$B.progressBar, className)
    }, ariaProps), React.createElement("div", {
      className: css$1(styles$B.progressIndicator),
      style: {
        width: `${value}%`
      }
    }, React.createElement("span", {
      className: css$1(styles$B.progressMeasure)
    }, children)));
  };
  ProgressBar.propTypes = {
    children: _pt.node,
    className: _pt.string,
    value: _pt.number.isRequired,
    ariaProps: _pt.shape({
      'aria-describedby': _pt.string,
      'aria-valuemin': _pt.number,
      'aria-valuenow': _pt.number,
      'aria-valuemax': _pt.number,
      'aria-valuetext': _pt.string
    })
  };

  (function (ProgressMeasureLocation) {
    ProgressMeasureLocation["outside"] = "outside";
    ProgressMeasureLocation["inside"] = "inside";
    ProgressMeasureLocation["top"] = "top";
    ProgressMeasureLocation["none"] = "none";
  })(exports.ProgressMeasureLocation || (exports.ProgressMeasureLocation = {}));

  (function (ProgressVariant) {
    ProgressVariant["danger"] = "danger";
    ProgressVariant["success"] = "success";
    ProgressVariant["info"] = "info";
  })(exports.ProgressVariant || (exports.ProgressVariant = {}));

  const variantToIcon = {
    danger: TimesCircleIcon,
    success: CheckCircleIcon
  };
  const ProgressContainer = ({
    ariaProps,
    value,
    title = '',
    parentId,
    label = null,
    variant = exports.ProgressVariant.info,
    measureLocation = exports.ProgressMeasureLocation.top
  }) => {
    const StatusIcon = variantToIcon.hasOwnProperty(variant) && variantToIcon[variant];
    return React.createElement(React.Fragment, null, React.createElement("div", {
      className: css$1(styles$B.progressDescription),
      id: `${parentId}-description`
    }, title), React.createElement("div", {
      className: css$1(styles$B.progressStatus)
    }, (measureLocation === exports.ProgressMeasureLocation.top || measureLocation === exports.ProgressMeasureLocation.outside) && React.createElement("span", {
      className: css$1(styles$B.progressMeasure)
    }, label || `${value}%`), variantToIcon.hasOwnProperty(variant) && React.createElement("span", {
      className: css$1(styles$B.progressStatusIcon)
    }, React.createElement(StatusIcon, null))), React.createElement(ProgressBar, {
      ariaProps: ariaProps,
      value: value
    }, measureLocation === exports.ProgressMeasureLocation.inside && `${value}%`));
  };
  ProgressContainer.propTypes = {
    ariaProps: _pt.any,
    parentId: _pt.string.isRequired,
    title: _pt.string,
    label: _pt.node,
    variant: _pt.oneOf(['danger', 'success', 'info']),
    measureLocation: _pt.oneOf(['outside', 'inside', 'top', 'none']),
    value: _pt.number.isRequired
  };

  function _extends$2n() { _extends$2n = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2n.apply(this, arguments); }

  function ownKeys$8(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$8(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$8(source, true).forEach(function (key) { _defineProperty$L(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$8(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _objectWithoutProperties$2m(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2l(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2l(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$L(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (ProgressSize) {
    ProgressSize["sm"] = "sm";
    ProgressSize["md"] = "md";
    ProgressSize["lg"] = "lg";
  })(exports.ProgressSize || (exports.ProgressSize = {}));

  class Progress extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$L(this, "id", this.props.id || getUniqueId());
    }

    render() {
      const _this$props = this.props,
            {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        id,
        className,
        size,
        value,
        title,
        label,
        variant,
        measureLocation,
        min,
        max,
        valueText
      } = _this$props,
            props = _objectWithoutProperties$2m(_this$props, ["id", "className", "size", "value", "title", "label", "variant", "measureLocation", "min", "max", "valueText"]);

      const additionalProps = _objectSpread$8({}, props, {}, valueText ? {
        'aria-valuetext': valueText
      } : {
        'aria-describedby': `${this.id}-description`
      });

      const ariaProps = {
        'aria-describedby': `${this.id}-description`,
        'aria-valuemin': min,
        'aria-valuenow': value,
        'aria-valuemax': max
      };

      if (valueText) {
        ariaProps['aria-valuetext'] = valueText;
      }

      const scaledValue = Math.min(100, Math.max(0, Math.floor((value - min) / (max - min) * 100)));
      return React.createElement("div", _extends$2n({}, additionalProps, {
        className: css$1(styles$B.progress, getModifier(styles$B, variant, ''), getModifier(styles$B, measureLocation, ''), getModifier(styles$B, measureLocation === exports.ProgressMeasureLocation.inside ? exports.ProgressSize.lg : size, ''), !title && getModifier(styles$B, 'singleline', ''), className),
        id: this.id,
        role: "progressbar"
      }), React.createElement(ProgressContainer, {
        parentId: this.id,
        value: scaledValue,
        title: title,
        label: label,
        variant: variant,
        measureLocation: measureLocation,
        ariaProps: ariaProps
      }));
    }

  }

  _defineProperty$L(Progress, "propTypes", {
    className: _pt.string,
    size: _pt.oneOf(['sm', 'md', 'lg']),
    measureLocation: _pt.oneOf(['outside', 'inside', 'top', 'none']),
    variant: _pt.oneOf(['danger', 'success', 'info']),
    title: _pt.string,
    label: _pt.node,
    value: _pt.number,
    id: _pt.string,
    min: _pt.number,
    max: _pt.number,
    valueText: _pt.string
  });

  _defineProperty$L(Progress, "defaultProps", {
    className: '',
    measureLocation: exports.ProgressMeasureLocation.top,
    variant: exports.ProgressVariant.info,
    id: '',
    title: '',
    min: 0,
    max: 100,
    size: null,
    label: null,
    value: 0,
    valueText: null
  });

  var radio = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      radio: 'pf-c-radio',
      radioLabel: 'pf-c-radio__label',
      radioInput: 'pf-c-radio__input',
      radioDescription: 'pf-c-radio__description',
      modifiers: {
          'disabled': 'pf-m-disabled'
      }
  };
  });

  var styles$C = unwrapExports(radio);

  function _extends$2o() { _extends$2o = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2o.apply(this, arguments); }

  function _objectWithoutProperties$2n(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2m(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2m(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$M(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class Radio extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$M(this, "handleChange", event => {
        this.props.onChange(event.currentTarget.checked, event);
      });

      if (!props.label && !props['aria-label']) {
        // eslint-disable-next-line no-console
        console.error('Radio:', 'Radio requires an aria-label to be specified');
      }
    }

    render() {
      const _this$props = this.props,
            {
        'aria-label': ariaLabel,
        checked,
        className,
        defaultChecked,
        isLabelWrapped,
        isLabelBeforeButton,
        isChecked,
        isDisabled,
        isValid,
        label,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onChange,
        description
      } = _this$props,
            props = _objectWithoutProperties$2n(_this$props, ["aria-label", "checked", "className", "defaultChecked", "isLabelWrapped", "isLabelBeforeButton", "isChecked", "isDisabled", "isValid", "label", "onChange", "description"]);

      const inputRendered = React.createElement("input", _extends$2o({}, props, {
        className: css$1(styles$C.radioInput),
        type: "radio",
        onChange: this.handleChange,
        "aria-invalid": !isValid,
        disabled: isDisabled,
        checked: checked || isChecked
      }, checked === undefined && {
        defaultChecked
      }, !label && {
        'aria-label': ariaLabel
      }));
      const labelRendered = !label ? null : isLabelWrapped ? React.createElement("span", {
        className: css$1(styles$C.radioLabel, getModifier(styles$C, isDisabled && 'disabled'))
      }, label) : React.createElement("label", {
        className: css$1(styles$C.radioLabel, getModifier(styles$C, isDisabled && 'disabled')),
        htmlFor: props.id
      }, label);
      const descRender = description ? React.createElement("div", {
        className: css$1(styles$C.radioDescription)
      }, description) : null;
      const childrenRendered = isLabelBeforeButton ? React.createElement(React.Fragment, null, labelRendered, inputRendered, descRender) : React.createElement(React.Fragment, null, inputRendered, labelRendered, descRender);
      return isLabelWrapped ? React.createElement("label", {
        className: css$1(styles$C.radio, className),
        htmlFor: props.id
      }, childrenRendered) : React.createElement("div", {
        className: css$1(styles$C.radio, className)
      }, childrenRendered);
    }

  }

  _defineProperty$M(Radio, "propTypes", {
    className: _pt.string,
    id: _pt.string.isRequired,
    isLabelWrapped: _pt.bool,
    isLabelBeforeButton: _pt.bool,
    checked: _pt.bool,
    isChecked: _pt.bool,
    isDisabled: _pt.bool,
    isValid: _pt.bool,
    label: _pt.node,
    name: _pt.string.isRequired,
    onChange: _pt.func,
    'aria-label': _pt.string,
    description: _pt.node
  });

  _defineProperty$M(Radio, "defaultProps", {
    className: '',
    isDisabled: false,
    isValid: true,
    onChange: () => {}
  });

  var simpleList = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      simpleList: 'pf-c-simple-list',
      simpleListItemLink: 'pf-c-simple-list__item-link',
      simpleListTitle: 'pf-c-simple-list__title',
      simpleListSection: 'pf-c-simple-list__section',
      modifiers: {
          'current': 'pf-m-current',
          'hover': 'pf-m-hover',
          'focus': 'pf-m-focus',
          'active': 'pf-m-active'
      }
  };
  });

  var styles$D = unwrapExports(simpleList);

  function _extends$2p() { _extends$2p = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2p.apply(this, arguments); }

  function _objectWithoutProperties$2o(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2n(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2n(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const SimpleListGroup = (_ref) => {
    let {
      children = null,
      className = '',
      title = '',
      titleClassName = '',
      id = ''
    } = _ref,
        props = _objectWithoutProperties$2o(_ref, ["children", "className", "title", "titleClassName", "id"]);

    return React.createElement("section", _extends$2p({
      className: css$1(styles$D.simpleListSection)
    }, props), React.createElement("h2", {
      id: id,
      className: css$1(styles$D.simpleListTitle, titleClassName),
      "aria-hidden": "true"
    }, title), React.createElement("ul", {
      className: css$1(className),
      "aria-labelledby": id
    }, children));
  };
  SimpleListGroup.propTypes = {
    children: _pt.node,
    className: _pt.string,
    titleClassName: _pt.string,
    title: _pt.node,
    id: _pt.string
  };

  function _extends$2q() { _extends$2q = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2q.apply(this, arguments); }

  function _objectWithoutProperties$2p(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2o(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2o(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$N(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  const SimpleListContext = React.createContext({});
  class SimpleList extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$N(this, "state", {
        currentRef: null
      });

      _defineProperty$N(this, "handleCurrentUpdate", (newCurrentRef, itemProps) => {
        this.setState({
          currentRef: newCurrentRef
        });
        const {
          onSelect
        } = this.props;
        onSelect && onSelect(newCurrentRef, itemProps);
      });
    }

    componentDidMount() {
      if (!SimpleList.hasWarnBeta && 'development' !== 'production') {
        // eslint-disable-next-line no-console
        console.warn('This component is in beta and subject to change.');
        SimpleList.hasWarnBeta = true;
      }
    }

    render() {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      const _this$props = this.props,
            {
        children,
        className,
        onSelect
      } = _this$props,
            props = _objectWithoutProperties$2p(_this$props, ["children", "className", "onSelect"]);

      let isGrouped = false;

      if (children) {
        isGrouped = React.Children.toArray(children)[0].type === SimpleListGroup;
      }

      return React.createElement(SimpleListContext.Provider, {
        value: {
          currentRef: this.state.currentRef,
          updateCurrentRef: this.handleCurrentUpdate
        }
      }, React.createElement("div", _extends$2q({
        className: css$1(styles$D.simpleList, className)
      }, props, isGrouped && {
        role: 'list'
      }), isGrouped && children, !isGrouped && React.createElement("ul", null, children)));
    }

  }

  _defineProperty$N(SimpleList, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    onSelect: _pt.func
  });

  _defineProperty$N(SimpleList, "hasWarnBeta", false);

  _defineProperty$N(SimpleList, "defaultProps", {
    children: null,
    className: ''
  });

  function _extends$2r() { _extends$2r = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2r.apply(this, arguments); }

  function _objectWithoutProperties$2q(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2p(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2p(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$O(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class SimpleListItem extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$O(this, "ref", React.createRef());
    }

    render() {
      const _this$props = this.props,
            {
        children,
        isCurrent,
        className,
        component: Component,
        componentClassName,
        componentProps,
        onClick,
        type,
        href
      } = _this$props,
            props = _objectWithoutProperties$2q(_this$props, ["children", "isCurrent", "className", "component", "componentClassName", "componentProps", "onClick", "type", "href"]);

      return React.createElement(SimpleListContext.Consumer, null, ({
        currentRef,
        updateCurrentRef
      }) => {
        const isButton = Component === 'button';
        const isCurrentItem = this.ref && currentRef ? currentRef.current === this.ref.current : isCurrent;
        const additionalComponentProps = isButton ? {
          type
        } : {
          tabIndex: 0,
          href
        };
        return React.createElement("li", _extends$2r({
          className: css$1(className)
        }, props), React.createElement(Component, _extends$2r({
          className: css$1(styles$D.simpleListItemLink, isCurrentItem && styles$D.modifiers.current, componentClassName),
          onClick: evt => {
            onClick(evt);
            updateCurrentRef(this.ref, this.props);
          },
          ref: this.ref
        }, componentProps, additionalComponentProps), children));
      });
    }

  }

  _defineProperty$O(SimpleListItem, "propTypes", {
    children: _pt.node,
    className: _pt.string,
    component: _pt.oneOf(['button', 'a']),
    componentClassName: _pt.string,
    componentProps: _pt.any,
    isCurrent: _pt.bool,
    onClick: _pt.func,
    type: _pt.oneOf(['button', 'submit', 'reset']),
    href: _pt.string
  });

  _defineProperty$O(SimpleListItem, "defaultProps", {
    children: null,
    className: '',
    isCurrent: false,
    component: 'button',
    componentClassName: '',
    type: 'button',
    href: '',
    onClick: () => {}
  });

  var skipToContent = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      skipToContent: 'pf-c-skip-to-content',
      modifiers: {
          'focus': 'pf-m-focus'
      }
  };
  });

  var styles$E = unwrapExports(skipToContent);

  function _extends$2s() { _extends$2s = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2s.apply(this, arguments); }

  function _objectWithoutProperties$2r(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2q(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2q(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$P(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class SkipToContent extends React.Component {
    render() {
      const _this$props = this.props,
            {
        component,
        children,
        className,
        href,
        show
      } = _this$props,
            rest = _objectWithoutProperties$2r(_this$props, ["component", "children", "className", "href", "show"]);

      const Component = component;
      return React.createElement(Component, _extends$2s({}, rest, {
        className: css$1(buttonStyles.button, getModifier(buttonStyles.modifiers, 'primary'), styles$E.skipToContent, show && getModifier(styles$E, 'focus'), className),
        href: href
      }), children);
    }

  }

  _defineProperty$P(SkipToContent, "propTypes", {
    component: _pt.any,
    href: _pt.string.isRequired,
    children: _pt.node,
    className: _pt.string,
    show: _pt.bool
  });

  _defineProperty$P(SkipToContent, "defaultProps", {
    component: 'a',
    className: '',
    show: false
  });

  var _switch = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      switch: 'pf-c-switch',
      switchInput: 'pf-c-switch__input',
      switchToggle: 'pf-c-switch__toggle',
      switchLabel: 'pf-c-switch__label',
      switchToggleIcon: 'pf-c-switch__toggle-icon',
      modifiers: {
          'off': 'pf-m-off',
          'on': 'pf-m-on'
      }
  };
  });

  var styles$F = unwrapExports(_switch);

  function _extends$2t() { _extends$2t = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2t.apply(this, arguments); }

  function _objectWithoutProperties$2s(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2r(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2r(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$Q(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  class Switch extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$Q(this, "id", '');

      if (!props.id && !props['aria-label']) {
        // eslint-disable-next-line no-console
        console.error('Switch: Switch requires either an id or aria-label to be specified');
      }

      this.id = props.id || getUniqueId();
    }

    render() {
      const _this$props = this.props,
            {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        id,
        className,
        label,
        labelOff,
        isChecked,
        isDisabled,
        onChange,
        ouiaContext,
        ouiaId
      } = _this$props,
            props = _objectWithoutProperties$2s(_this$props, ["id", "className", "label", "labelOff", "isChecked", "isDisabled", "onChange", "ouiaContext", "ouiaId"]);

      const isAriaLabelledBy = props['aria-label'] === '';
      return React.createElement("label", _extends$2t({
        className: css$1(styles$F.switch, className),
        htmlFor: this.id
      }, ouiaContext.isOuia && {
        'data-ouia-component-type': 'Switch',
        'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
      }), React.createElement("input", _extends$2t({
        id: this.id,
        className: css$1(styles$F.switchInput),
        type: "checkbox",
        onChange: event => onChange(event.target.checked, event),
        checked: isChecked,
        disabled: isDisabled,
        "aria-labelledby": isAriaLabelledBy ? `${this.id}-on` : null
      }, props)), label !== '' ? React.createElement(React.Fragment, null, React.createElement("span", {
        className: css$1(styles$F.switchToggle)
      }), React.createElement("span", {
        className: css$1(styles$F.switchLabel, styles$F.modifiers.on),
        id: isAriaLabelledBy ? `${this.id}-on` : null,
        "aria-hidden": "true"
      }, label), React.createElement("span", {
        className: css$1(styles$F.switchLabel, styles$F.modifiers.off),
        id: isAriaLabelledBy ? `${this.id}-off` : null,
        "aria-hidden": "true"
      }, labelOff || label)) : label !== '' && labelOff !== '' ? React.createElement(React.Fragment, null, React.createElement("span", {
        className: css$1(styles$F.switchToggle)
      }), React.createElement("span", {
        className: css$1(styles$F.switchLabel, styles$F.modifiers.on),
        id: isAriaLabelledBy ? `${this.id}-on` : null,
        "aria-hidden": "true"
      }, label), React.createElement("span", {
        className: css$1(styles$F.switchLabel, styles$F.modifiers.off),
        id: isAriaLabelledBy ? `${this.id}-off` : null,
        "aria-hidden": "true"
      }, labelOff)) : React.createElement("span", {
        className: css$1(styles$F.switchToggle)
      }, React.createElement("div", {
        className: css$1(styles$F.switchToggleIcon),
        "aria-hidden": "true"
      }, React.createElement(CheckIcon, {
        noVerticalAlign: true
      }))));
    }

  }

  _defineProperty$Q(Switch, "propTypes", {
    id: _pt.string,
    className: _pt.string,
    label: _pt.string,
    labelOff: _pt.string,
    isChecked: _pt.bool,
    isDisabled: _pt.bool,
    onChange: _pt.func,
    'aria-label': _pt.string
  });

  _defineProperty$Q(Switch, "defaultProps", {
    id: '',
    className: '',
    label: '',
    labelOff: '',
    isChecked: true,
    isDisabled: false,
    'aria-label': '',
    onChange: () => undefined
  });

  const SwitchWithOuiaContext = withOuiaContext(Switch);

  const Tab = () => null;

  var tabs = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      tabs: 'pf-c-tabs',
      tabsScrollButton: 'pf-c-tabs__scroll-button',
      tabsList: 'pf-c-tabs__list',
      tabsItem: 'pf-c-tabs__item',
      tabsButton: 'pf-c-tabs__button',
      tabsScrollItem: 'pf-c-tabs__scroll-item',
      modifiers: {
          'start': 'pf-m-start',
          'end': 'pf-m-end',
          'startCurrent': 'pf-m-start-current',
          'tabsSecondary': 'pf-m-tabs-secondary',
          'endCurrent': 'pf-m-end-current',
          'fill': 'pf-m-fill',
          'current': 'pf-m-current',
          'hover': 'pf-m-hover',
          'secondary': 'pf-m-secondary',
          'active': 'pf-m-active',
          'focus': 'pf-m-focus'
      }
  };
  });

  var styles$G = unwrapExports(tabs);

  function _extends$2u() { _extends$2u = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2u.apply(this, arguments); }

  function _objectWithoutProperties$2t(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2s(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2s(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  const TabButtonBase = (_ref) => {
    let {
      children,
      className = '',
      tabContentRef
    } = _ref,
        props = _objectWithoutProperties$2t(_ref, ["children", "className", "tabContentRef"]);

    const Component = props.href ? 'a' : 'button';
    return React.createElement(Component, _extends$2u({}, props, {
      className: className,
      ref: tabContentRef
    }), children);
  };

  TabButtonBase.propTypes = {
    children: _pt.node,
    className: _pt.string,
    href: _pt.string,
    tabContentRef: _pt.oneOfType([_pt.string, _pt.func, _pt.object])
  };
  const TabButton = React.forwardRef((props, ref) => React.createElement(TabButtonBase, _extends$2u({}, props, {
    tabContentRef: ref
  }))); // export const TabButton = withForwardedRef(TabButtonWithRef);

  function _extends$2v() { _extends$2v = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2v.apply(this, arguments); }

  function _objectWithoutProperties$2u(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2t(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2t(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  const TabContentBase = (_ref) => {
    let {
      id,
      activeKey,
      'aria-label': ariaLabel,
      child,
      children,
      className,
      eventKey,
      innerRef
    } = _ref,
        props = _objectWithoutProperties$2u(_ref, ["id", "activeKey", "aria-label", "child", "children", "className", "eventKey", "innerRef"]);

    if (children || child) {
      let labelledBy;

      if (ariaLabel) {
        labelledBy = null;
      } else {
        labelledBy = children ? `pf-tab-${eventKey}-${id}` : `pf-tab-${child.props.eventKey}-${id}`;
      }

      return React.createElement("section", _extends$2v({
        ref: innerRef,
        hidden: children ? null : child.props.eventKey !== activeKey,
        className: children ? css$1('pf-c-tab-content', className) : css$1('pf-c-tab-content', child.props.className),
        id: children ? id : `pf-tab-section-${child.props.eventKey}-${id}`,
        "aria-label": ariaLabel,
        "aria-labelledby": labelledBy,
        role: "tabpanel",
        tabIndex: 0
      }, props), children || child.props.children);
    }

    return null;
  };

  TabContentBase.propTypes = {
    children: _pt.any,
    child: _pt.element,
    className: _pt.string,
    activeKey: _pt.oneOfType([_pt.number, _pt.string]),
    eventKey: _pt.oneOfType([_pt.number, _pt.string]),
    innerRef: _pt.oneOfType([_pt.string, _pt.func, _pt.object]),
    id: _pt.string.isRequired,
    'aria-label': _pt.string
  };
  const TabContent = React.forwardRef((props, ref) => React.createElement(TabContentBase, _extends$2v({}, props, {
    innerRef: ref
  })));

  function _extends$2w() { _extends$2w = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2w.apply(this, arguments); }

  function _objectWithoutProperties$2v(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2u(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2u(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$R(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (TabsVariant) {
    TabsVariant["div"] = "div";
    TabsVariant["nav"] = "nav";
  })(exports.TabsVariant || (exports.TabsVariant = {}));

  class Tabs extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$R(this, "tabList", React.createRef());

      _defineProperty$R(this, "handleScrollButtons", () => {
        if (this.tabList.current) {
          const container = this.tabList.current; // get first element and check if it is in view

          const showLeftScrollButton = !isElementInView(container, container.firstChild, false); // get lase element and check if it is in view

          const showRightScrollButton = !isElementInView(container, container.lastChild, false); // determine if selected tab is out of view and apply styles

          let selectedTab;
          const childrenArr = Array.from(container.children);
          childrenArr.forEach(child => {
            const {
              className
            } = child;

            if (className.search('pf-m-current') > 0) {
              selectedTab = child;
            }
          });
          const sideOutOfView = sideElementIsOutOfView(container, selectedTab);
          this.setState({
            showLeftScrollButton,
            showRightScrollButton,
            highlightLeftScrollButton: (sideOutOfView === SIDE.LEFT || sideOutOfView === SIDE.BOTH) && showLeftScrollButton,
            highlightRightScrollButton: (sideOutOfView === SIDE.RIGHT || sideOutOfView === SIDE.BOTH) && showRightScrollButton
          });
        }
      });

      _defineProperty$R(this, "scrollLeft", () => {
        // find first Element that is fully in view on the left, then scroll to the element before it
        if (this.tabList.current) {
          const container = this.tabList.current;
          const childrenArr = Array.from(container.children);
          let firstElementInView;
          let lastElementOutOfView;
          let i;

          for (i = 0; i < childrenArr.length && !firstElementInView; i++) {
            if (isElementInView(container, childrenArr[i], false)) {
              firstElementInView = childrenArr[i];
              lastElementOutOfView = childrenArr[i - 1];
            }
          }

          if (lastElementOutOfView) {
            container.scrollLeft -= lastElementOutOfView.scrollWidth;
          }
        }
      });

      _defineProperty$R(this, "scrollRight", () => {
        // find last Element that is fully in view on the right, then scroll to the element after it
        if (this.tabList.current) {
          const container = this.tabList.current;
          const childrenArr = Array.from(container.children);
          let lastElementInView;
          let firstElementOutOfView;

          for (let i = childrenArr.length - 1; i >= 0 && !lastElementInView; i--) {
            if (isElementInView(container, childrenArr[i], false)) {
              lastElementInView = childrenArr[i];
              firstElementOutOfView = childrenArr[i + 1];
            }
          }

          if (firstElementOutOfView) {
            container.scrollLeft += firstElementOutOfView.scrollWidth;
          }
        }
      });

      this.state = {
        showLeftScrollButton: false,
        showRightScrollButton: false,
        highlightLeftScrollButton: false,
        highlightRightScrollButton: false,
        shownKeys: [this.props.activeKey] // only for mountOnEnter case

      };
    }

    handleTabClick(event, eventKey, tabContentRef, mountOnEnter) {
      const {
        shownKeys
      } = this.state;
      this.props.onSelect(event, eventKey); // process any tab content sections outside of the component

      if (tabContentRef) {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        React.Children.map(this.props.children, (child, i) => {
          child.props.tabContentRef.current.hidden = true;
        }); // most recently selected tabContent

        tabContentRef.current.hidden = false;
      } // Update scroll button state and which button to highlight


      setTimeout(() => {
        this.handleScrollButtons();
      }, 1);

      if (mountOnEnter) {
        this.setState({
          shownKeys: shownKeys.concat(eventKey)
        });
      }
    }

    componentDidMount() {
      window.addEventListener('resize', this.handleScrollButtons, false); // call the handle resize function to check if scroll buttons should be shown

      this.handleScrollButtons();
    }

    componentWillUnmount() {
      document.removeEventListener('resize', this.handleScrollButtons, false);
    }

    render() {
      const _this$props = this.props,
            {
        className,
        children,
        activeKey,
        id,
        isFilled,
        isSecondary,
        leftScrollAriaLabel,
        rightScrollAriaLabel,
        'aria-label': ariaLabel,
        variant,
        ouiaContext,
        ouiaId,
        mountOnEnter,
        unmountOnExit
      } = _this$props,
            props = _objectWithoutProperties$2v(_this$props, ["className", "children", "activeKey", "id", "isFilled", "isSecondary", "leftScrollAriaLabel", "rightScrollAriaLabel", "aria-label", "variant", "ouiaContext", "ouiaId", "mountOnEnter", "unmountOnExit"]);

      const {
        showLeftScrollButton,
        showRightScrollButton,
        highlightLeftScrollButton,
        highlightRightScrollButton,
        shownKeys
      } = this.state;
      const uniqueId = id || getUniqueId();
      const Component = variant === exports.TabsVariant.nav ? 'nav' : 'div';
      return React.createElement(React.Fragment, null, React.createElement(Component, _extends$2w({
        "aria-label": ariaLabel,
        className: css$1(styles$G.tabs, isFilled && styles$G.modifiers.fill, isSecondary && styles$G.modifiers.tabsSecondary, showLeftScrollButton && styles$G.modifiers.start, showRightScrollButton && styles$G.modifiers.end, highlightLeftScrollButton && styles$G.modifiers.startCurrent, highlightRightScrollButton && styles$G.modifiers.endCurrent, className)
      }, ouiaContext.isOuia && {
        'data-ouia-component-type': 'Tabs',
        'data-ouia-component-id': ouiaId || ouiaContext.ouiaId
      }, {
        id: id && id
      }, props), React.createElement("button", {
        className: css$1(styles$G.tabsScrollButton, isSecondary && buttonStyles.modifiers.secondary),
        "aria-label": leftScrollAriaLabel,
        onClick: this.scrollLeft
      }, React.createElement(AngleLeftIcon, null)), React.createElement("ul", {
        className: css$1(styles$G.tabsList),
        ref: this.tabList,
        onScroll: this.handleScrollButtons
      }, React.Children.map(children, (child, index) => {
        const _child$props = child.props,
              {
          title,
          eventKey,
          tabContentRef,
          id: childId,
          tabContentId
        } = _child$props,
              rest = _objectWithoutProperties$2v(_child$props, ["title", "eventKey", "tabContentRef", "id", "tabContentId"]);

        return React.createElement("li", {
          key: index,
          className: css$1(styles$G.tabsItem, eventKey === activeKey && styles$G.modifiers.current, className)
        }, React.createElement(TabButton, _extends$2w({
          className: css$1(styles$G.tabsButton),
          onClick: event => this.handleTabClick(event, eventKey, tabContentRef, mountOnEnter),
          id: `pf-tab-${eventKey}-${childId || uniqueId}`,
          "aria-controls": tabContentId ? `${tabContentId}` : `pf-tab-section-${eventKey}-${childId || uniqueId}`,
          tabContentRef: tabContentRef
        }, rest), title));
      })), React.createElement("button", {
        className: css$1(styles$G.tabsScrollButton, isSecondary && buttonStyles.modifiers.secondary),
        "aria-label": rightScrollAriaLabel,
        onClick: this.scrollRight
      }, React.createElement(AngleRightIcon, null))), React.Children.map(children, (child, index) => {
        if (!child.props.children || unmountOnExit && child.props.eventKey !== activeKey || mountOnEnter && shownKeys.indexOf(child.props.eventKey) === -1) {
          return null;
        } else {
          return React.createElement(TabContent, {
            key: index,
            activeKey: activeKey,
            child: child,
            id: child.props.id || uniqueId
          });
        }
      }));
    }

  }

  _defineProperty$R(Tabs, "propTypes", {
    children: _pt.node.isRequired,
    className: _pt.string,
    activeKey: _pt.oneOfType([_pt.number, _pt.string]),
    onSelect: _pt.func,
    id: _pt.string,
    isFilled: _pt.bool,
    isSecondary: _pt.bool,
    leftScrollAriaLabel: _pt.string,
    rightScrollAriaLabel: _pt.string,
    variant: _pt.oneOf(['div', 'nav']),
    'aria-label': _pt.string,
    mountOnEnter: _pt.bool,
    unmountOnExit: _pt.bool
  });

  _defineProperty$R(Tabs, "defaultProps", {
    className: '',
    activeKey: 0,
    onSelect: () => undefined,
    isFilled: false,
    isSecondary: false,
    leftScrollAriaLabel: 'Scroll left',
    rightScrollAriaLabel: 'Scroll right',
    variant: exports.TabsVariant.div,
    mountOnEnter: false,
    unmountOnExit: false
  });

  const TabsWithOuiaContext = withOuiaContext(Tabs);

  function _extends$2x() { _extends$2x = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2x.apply(this, arguments); }

  function _objectWithoutProperties$2w(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2v(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2v(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const TextContent = (_ref) => {
    let {
      children = null,
      className = ''
    } = _ref,
        props = _objectWithoutProperties$2w(_ref, ["children", "className"]);

    return React.createElement("div", _extends$2x({}, props, {
      className: css$1(styles$3.content, className)
    }), children);
  };
  TextContent.propTypes = {
    children: _pt.node,
    className: _pt.string
  };

  function _extends$2y() { _extends$2y = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2y.apply(this, arguments); }

  function _objectWithoutProperties$2x(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2w(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2w(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (TextVariants) {
    TextVariants["h1"] = "h1";
    TextVariants["h2"] = "h2";
    TextVariants["h3"] = "h3";
    TextVariants["h4"] = "h4";
    TextVariants["h5"] = "h5";
    TextVariants["h6"] = "h6";
    TextVariants["p"] = "p";
    TextVariants["a"] = "a";
    TextVariants["small"] = "small";
    TextVariants["blockquote"] = "blockquote";
    TextVariants["pre"] = "pre";
  })(exports.TextVariants || (exports.TextVariants = {}));

  const Text = (_ref) => {
    let {
      children = null,
      className = '',
      component = exports.TextVariants.p
    } = _ref,
        props = _objectWithoutProperties$2x(_ref, ["children", "className", "component"]);

    const Component = component;
    return React.createElement(Component, _extends$2y({}, props, {
      "data-pf-content": true,
      className: css$1(className)
    }), children);
  };
  Text.propTypes = {
    component: _pt.oneOf(['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p', 'a', 'small', 'blockquote', 'pre']),
    children: _pt.node,
    className: _pt.string
  };

  function _extends$2z() { _extends$2z = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2z.apply(this, arguments); }

  function _objectWithoutProperties$2y(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2x(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2x(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (TextListVariants) {
    TextListVariants["ul"] = "ul";
    TextListVariants["ol"] = "ol";
    TextListVariants["dl"] = "dl";
  })(exports.TextListVariants || (exports.TextListVariants = {}));

  const TextList = (_ref) => {
    let {
      children = null,
      className = '',
      component = exports.TextListVariants.ul
    } = _ref,
        props = _objectWithoutProperties$2y(_ref, ["children", "className", "component"]);

    const Component = component;
    return React.createElement(Component, _extends$2z({}, props, {
      "data-pf-content": true,
      className: css$1(className)
    }), children);
  };
  TextList.propTypes = {
    children: _pt.node,
    className: _pt.string,
    component: _pt.oneOf(['ul', 'ol', 'dl'])
  };

  function _extends$2A() { _extends$2A = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2A.apply(this, arguments); }

  function _objectWithoutProperties$2z(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2y(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2y(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (TextListItemVariants) {
    TextListItemVariants["li"] = "li";
    TextListItemVariants["dt"] = "dt";
    TextListItemVariants["dd"] = "dd";
  })(exports.TextListItemVariants || (exports.TextListItemVariants = {}));

  const TextListItem = (_ref) => {
    let {
      children = null,
      className = '',
      component = exports.TextListItemVariants.li
    } = _ref,
        props = _objectWithoutProperties$2z(_ref, ["children", "className", "component"]);

    const Component = component;
    return React.createElement(Component, _extends$2A({}, props, {
      "data-pf-content": true,
      className: css$1(className)
    }), children);
  };
  TextListItem.propTypes = {
    children: _pt.node,
    className: _pt.string,
    component: _pt.oneOf(['li', 'dt', 'dd'])
  };

  var wizard = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      wizardHeader: 'pf-c-wizard__header',
      card: 'pf-c-card',
      button: 'pf-c-button',
      wizard: 'pf-c-wizard',
      wizardOuterWrap: 'pf-c-wizard__outer-wrap',
      wizardNav: 'pf-c-wizard__nav',
      wizardFooter: 'pf-c-wizard__footer',
      wizardToggle: 'pf-c-wizard__toggle',
      wizardClose: 'pf-c-wizard__close',
      wizardTitle: 'pf-c-wizard__title',
      wizardDescription: 'pf-c-wizard__description',
      wizardToggleIcon: 'pf-c-wizard__toggle-icon',
      wizardToggleList: 'pf-c-wizard__toggle-list',
      wizardToggleListItem: 'pf-c-wizard__toggle-list-item',
      wizardToggleNum: 'pf-c-wizard__toggle-num',
      wizardToggleSeparator: 'pf-c-wizard__toggle-separator',
      wizardInnerWrap: 'pf-c-wizard__inner-wrap',
      wizardNavList: 'pf-c-wizard__nav-list',
      wizardNavLink: 'pf-c-wizard__nav-link',
      wizardNavItem: 'pf-c-wizard__nav-item',
      wizardMain: 'pf-c-wizard__main',
      wizardMainBody: 'pf-c-wizard__main-body',
      modifiers: {
          'fullWidth': 'pf-m-full-width',
          'fullHeight': 'pf-m-full-height',
          'compactNav': 'pf-m-compact-nav',
          'finished': 'pf-m-finished',
          'inPage': 'pf-m-in-page',
          'expanded': 'pf-m-expanded',
          'current': 'pf-m-current',
          'hover': 'pf-m-hover',
          'focus': 'pf-m-focus',
          'disabled': 'pf-m-disabled',
          'noPadding': 'pf-m-no-padding'
      }
  };
  });

  var styles$H = unwrapExports(wizard);

  function _extends$2B() { _extends$2B = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2B.apply(this, arguments); }

  function _objectWithoutProperties$2A(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2z(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2z(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const Bullseye = (_ref) => {
    let {
      children = null,
      className = '',
      component = 'div'
    } = _ref,
        props = _objectWithoutProperties$2A(_ref, ["children", "className", "component"]);

    const Component = component;
    return React.createElement(Component, _extends$2B({
      className: css$1(styles$1.bullseye, className)
    }, props), children);
  };
  Bullseye.propTypes = {
    children: _pt.node,
    className: _pt.string,
    component: _pt.any
  };

  const WizardHeader = ({
    onClose = () => undefined,
    title,
    description,
    ariaLabelCloseButton,
    titleId,
    descriptionId
  }) => React.createElement("div", {
    className: css$1(styles$H.wizardHeader)
  }, React.createElement(ButtonWithOuiaContext, {
    variant: "plain",
    className: css$1(styles$H.wizardClose),
    "aria-label": ariaLabelCloseButton,
    onClick: onClose
  }, React.createElement(TimesIcon, {
    "aria-hidden": "true"
  })), React.createElement(Title, {
    size: "3xl",
    className: css$1(styles$H.wizardTitle),
    "aria-label": title,
    id: titleId
  }, title || React.createElement(React.Fragment, null, "\xA0")), description && React.createElement("p", {
    className: css$1(styles$H.wizardDescription),
    id: descriptionId
  }, description));
  WizardHeader.propTypes = {
    onClose: _pt.func,
    title: _pt.string.isRequired,
    description: _pt.string,
    ariaLabelCloseButton: _pt.string,
    titleId: _pt.string,
    descriptionId: _pt.string
  };

  const WizardFooterInternal = ({
    onNext,
    onBack,
    onClose,
    isValid,
    firstStep,
    activeStep,
    nextButtonText,
    backButtonText,
    cancelButtonText
  }) => React.createElement("footer", {
    className: css$1(styles$H.wizardFooter)
  }, React.createElement(ButtonWithOuiaContext, {
    variant: exports.ButtonVariant.primary,
    type: "submit",
    onClick: onNext,
    isDisabled: !isValid
  }, nextButtonText), !activeStep.hideBackButton && React.createElement(ButtonWithOuiaContext, {
    variant: exports.ButtonVariant.secondary,
    onClick: onBack,
    className: css$1(firstStep && 'pf-m-disabled')
  }, backButtonText), !activeStep.hideCancelButton && React.createElement(ButtonWithOuiaContext, {
    variant: exports.ButtonVariant.link,
    onClick: onClose
  }, cancelButtonText));
  WizardFooterInternal.propTypes = {
    onNext: _pt.any.isRequired,
    onBack: _pt.any.isRequired,
    onClose: _pt.any.isRequired,
    isValid: _pt.bool.isRequired,
    firstStep: _pt.bool.isRequired,
    activeStep: _pt.any.isRequired,
    nextButtonText: _pt.string.isRequired,
    backButtonText: _pt.string.isRequired,
    cancelButtonText: _pt.string.isRequired
  };

  const WizardBody = ({
    children,
    hasBodyPadding = true
  }) => React.createElement("main", {
    className: css$1(styles$H.wizardMain, !hasBodyPadding && styles$H.modifiers.noPadding)
  }, React.createElement("div", {
    className: css$1(styles$H.wizardMainBody)
  }, children));
  WizardBody.propTypes = {
    children: _pt.any.isRequired,
    hasBodyPadding: _pt.bool.isRequired
  };

  const WizardToggle = ({
    isNavOpen,
    onNavToggle,
    nav,
    steps,
    activeStep,
    children,
    hasBodyPadding = true
  }) => {
    let activeStepIndex;
    let activeStepName;
    let activeStepSubName;

    for (let i = 0; i < steps.length; i++) {
      if (activeStep.id && steps[i].id === activeStep.id || steps[i].name === activeStep.name) {
        activeStepIndex = i + 1;
        activeStepName = steps[i].name;
        break;
      } else if (steps[i].steps) {
        for (const step of steps[i].steps) {
          if (activeStep.id && step.id === activeStep.id || step.name === activeStep.name) {
            activeStepIndex = i + 1;
            activeStepName = steps[i].name;
            activeStepSubName = step.name;
            break;
          }
        }
      }
    }

    return React.createElement(React.Fragment, null, React.createElement("button", {
      onClick: () => onNavToggle(!isNavOpen),
      className: css$1(styles$H.wizardToggle, isNavOpen && 'pf-m-expanded'),
      "aria-expanded": isNavOpen
    }, React.createElement("ol", {
      className: css$1(styles$H.wizardToggleList)
    }, React.createElement("li", {
      className: css$1(styles$H.wizardToggleListItem)
    }, React.createElement("span", {
      className: css$1(styles$H.wizardToggleNum)
    }, activeStepIndex), " ", activeStepName, activeStepSubName && React.createElement(AngleRightIcon, {
      className: css$1(styles$H.wizardToggleSeparator),
      "aria-hidden": "true"
    })), activeStepSubName && React.createElement("li", {
      className: css$1(styles$H.wizardToggleListItem)
    }, activeStepSubName)), React.createElement(CaretDownIcon, {
      className: css$1(styles$H.wizardToggleIcon),
      "aria-hidden": "true"
    })), React.createElement("div", {
      className: css$1(styles$H.wizardOuterWrap)
    }, React.createElement("div", {
      className: css$1(styles$H.wizardInnerWrap)
    }, nav(isNavOpen), React.createElement(WizardBody, {
      hasBodyPadding: hasBodyPadding
    }, activeStep.component)), children));
  };
  WizardToggle.propTypes = {
    nav: _pt.func.isRequired,
    steps: _pt.arrayOf(_pt.any).isRequired,
    activeStep: _pt.any.isRequired,
    children: _pt.node.isRequired,
    hasBodyPadding: _pt.bool.isRequired,
    isNavOpen: _pt.bool.isRequired,
    onNavToggle: _pt.func.isRequired
  };

  const WizardNav = ({
    children,
    ariaLabel,
    isOpen = false,
    returnList = false
  }) => {
    const innerList = React.createElement("ol", {
      className: css$1(styles$H.wizardNavList)
    }, children);

    if (returnList) {
      return innerList;
    }

    return React.createElement("nav", {
      className: css$1(styles$H.wizardNav, isOpen && 'pf-m-expanded'),
      "aria-label": ariaLabel
    }, React.createElement("ol", {
      className: css$1(styles$H.wizardNavList)
    }, children));
  };
  WizardNav.propTypes = {
    children: _pt.any,
    ariaLabel: _pt.string,
    isOpen: _pt.bool,
    returnList: _pt.bool
  };

  const WizardNavItem = ({
    children = null,
    text = '',
    isCurrent = false,
    isDisabled = false,
    step,
    onNavItemClick = () => undefined,
    navItemComponent = 'a'
  }) => {
    const NavItemComponent = navItemComponent;
    return React.createElement("li", {
      className: css$1(styles$H.wizardNavItem)
    }, React.createElement(NavItemComponent, {
      "aria-current": isCurrent && !children ? 'page' : false,
      onClick: () => onNavItemClick(step),
      className: css$1(styles$H.wizardNavLink, isCurrent && 'pf-m-current', isDisabled && 'pf-m-disabled'),
      "aria-disabled": isDisabled ? true : false,
      tabIndex: isDisabled ? -1 : undefined
    }, text), children);
  };
  WizardNavItem.propTypes = {
    children: _pt.node,
    text: _pt.string,
    isCurrent: _pt.bool,
    isDisabled: _pt.bool,
    step: _pt.number.isRequired,
    onNavItemClick: _pt.func,
    navItemComponent: _pt.node
  };

  const WizardContext = React.createContext({
    goToStepById: () => null,
    goToStepByName: () => null,
    onNext: () => null,
    onBack: () => null,
    onClose: () => null,
    activeStep: {
      name: null
    }
  });
  const WizardContextProvider = WizardContext.Provider;
  const WizardContextConsumer = WizardContext.Consumer;

  function _extends$2C() { _extends$2C = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2C.apply(this, arguments); }

  function _objectWithoutProperties$2B(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2A(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2A(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$S(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class Wizard extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$S(this, "handleKeyClicks", event => {
        if (event.keyCode === KEY_CODES.ESCAPE_KEY) {
          if (this.state.isNavOpen) {
            this.setState({
              isNavOpen: !this.state.isNavOpen
            });
          } else if (this.props.isOpen) {
            this.props.onClose();
          }
        }
      });

      _defineProperty$S(this, "toggleSiblingsFromScreenReaders", hide => {
        const {
          appendTo
        } = this.props;
        const target = this.getElement(appendTo);
        const bodyChildren = target.children;

        for (const child of Array.from(bodyChildren)) {
          if (child !== this.container) {
            hide ? child.setAttribute('aria-hidden', '' + hide) : child.removeAttribute('aria-hidden');
          }
        }
      });

      _defineProperty$S(this, "onNext", () => {
        const {
          onNext,
          onClose,
          onSave
        } = this.props;
        const {
          currentStep
        } = this.state;
        const flattenedSteps = this.getFlattenedSteps();
        const maxSteps = flattenedSteps.length;

        if (currentStep >= maxSteps) {
          // Hit the save button at the end of the wizard
          if (onSave) {
            return onSave();
          }

          return onClose();
        } else {
          const newStep = currentStep + 1;
          this.setState({
            currentStep: newStep
          });
          const {
            id: prevId,
            name: prevName
          } = flattenedSteps[currentStep - 1];
          const {
            id,
            name
          } = flattenedSteps[newStep - 1];
          return onNext && onNext({
            id,
            name
          }, {
            prevId,
            prevName
          });
        }
      });

      _defineProperty$S(this, "onBack", () => {
        const {
          onBack
        } = this.props;
        const {
          currentStep
        } = this.state;
        const flattenedSteps = this.getFlattenedSteps();

        if (flattenedSteps.length < currentStep) {
          // Previous step was removed, just update the currentStep state
          const adjustedStep = flattenedSteps.length;
          this.setState({
            currentStep: adjustedStep
          });
        } else {
          const newStep = currentStep - 1 <= 0 ? 0 : currentStep - 1;
          this.setState({
            currentStep: newStep
          });
          const {
            id: prevId,
            name: prevName
          } = flattenedSteps[newStep];
          const {
            id,
            name
          } = flattenedSteps[newStep - 1];
          return onBack && onBack({
            id,
            name
          }, {
            prevId,
            prevName
          });
        }
      });

      _defineProperty$S(this, "goToStep", step => {
        const {
          onGoToStep
        } = this.props;
        const {
          currentStep
        } = this.state;
        const flattenedSteps = this.getFlattenedSteps();
        const maxSteps = flattenedSteps.length;

        if (step < 1) {
          step = 1;
        } else if (step > maxSteps) {
          step = maxSteps;
        }

        this.setState({
          currentStep: step,
          isNavOpen: false
        });
        const {
          id: prevId,
          name: prevName
        } = flattenedSteps[currentStep - 1];
        const {
          id,
          name
        } = flattenedSteps[step - 1];
        return onGoToStep && onGoToStep({
          id,
          name
        }, {
          prevId,
          prevName
        });
      });

      _defineProperty$S(this, "goToStepById", stepId => {
        const flattenedSteps = this.getFlattenedSteps();
        let step;

        for (let i = 0; i < flattenedSteps.length; i++) {
          if (flattenedSteps[i].id === stepId) {
            step = i + 1;
            break;
          }
        }

        if (step) {
          this.setState({
            currentStep: step
          });
        }
      });

      _defineProperty$S(this, "goToStepByName", stepName => {
        const flattenedSteps = this.getFlattenedSteps();
        let step;

        for (let i = 0; i < flattenedSteps.length; i++) {
          if (flattenedSteps[i].name === stepName) {
            step = i + 1;
            break;
          }
        }

        if (step) {
          this.setState({
            currentStep: step
          });
        }
      });

      _defineProperty$S(this, "getFlattenedSteps", () => {
        const {
          steps
        } = this.props;
        const flattenedSteps = [];

        for (const step of steps) {
          if (step.steps) {
            for (const childStep of step.steps) {
              flattenedSteps.push(childStep);
            }
          } else {
            flattenedSteps.push(step);
          }
        }

        return flattenedSteps;
      });

      _defineProperty$S(this, "getFlattenedStepsIndex", (flattenedSteps, stepName) => {
        for (let i = 0; i < flattenedSteps.length; i++) {
          if (flattenedSteps[i].name === stepName) {
            return i + 1;
          }
        }

        return 0;
      });

      _defineProperty$S(this, "initSteps", steps => {
        // Set default Step values
        for (let i = 0; i < steps.length; i++) {
          if (steps[i].steps) {
            for (let j = 0; j < steps[i].steps.length; j++) {
              steps[i].steps[j] = Object.assign({
                canJumpTo: true
              }, steps[i].steps[j]);
            }
          }

          steps[i] = Object.assign({
            canJumpTo: true
          }, steps[i]);
        }

        return steps;
      });

      _defineProperty$S(this, "getElement", appendTo => {
        if (typeof appendTo === 'function') {
          return appendTo();
        }

        return appendTo || document.body;
      });

      const newId = Wizard.currentId++;
      this.isModal = !props.isInPage;

      if (this.isModal) {
        this.titleId = `pf-wizard-title-${newId}`;
        this.descriptionId = `pf-wizard-description-${newId}`;
      }

      this.state = {
        currentStep: this.props.startAtStep && Number.isInteger(this.props.startAtStep) ? this.props.startAtStep : 1,
        isNavOpen: false
      };
    }

    componentDidMount() {
      const {
        appendTo
      } = this.props;
      const target = this.getElement(appendTo);

      if (this.isModal) {
        if (this.container) {
          target.appendChild(this.container);
        }

        this.toggleSiblingsFromScreenReaders(true);
        target.addEventListener('keydown', this.handleKeyClicks, false);
      }
    }

    componentWillUnmount() {
      const {
        appendTo
      } = this.props;
      const target = this.getElement(appendTo);

      if (this.isModal) {
        if (this.container) {
          target.removeChild(this.container);
        }

        this.toggleSiblingsFromScreenReaders(false);
        target.removeEventListener('keydown', this.handleKeyClicks, false);
      }
    }

    render() {
      if (this.isModal) {
        if (!canUseDOM) {
          return null;
        }

        if (!this.container) {
          this.container = document.createElement('div');
        }
      }

      const _this$props = this.props,
            {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        isOpen,
        isInPage,
        isFullHeight,
        isFullWidth,
        width,
        height,
        title,
        description,
        onClose,
        onSave,
        onBack,
        onNext,
        onGoToStep,
        className,
        steps,
        startAtStep,
        nextButtonText = 'Next',
        backButtonText = 'Back',
        cancelButtonText = 'Cancel',
        ariaLabelCloseButton = 'Close',
        ariaLabelNav,
        hasBodyPadding,
        footer,
        isCompactNav,
        appendTo
        /* eslint-enable @typescript-eslint/no-unused-vars */

      } = _this$props,
            rest = _objectWithoutProperties$2B(_this$props, ["isOpen", "isInPage", "isFullHeight", "isFullWidth", "width", "height", "title", "description", "onClose", "onSave", "onBack", "onNext", "onGoToStep", "className", "steps", "startAtStep", "nextButtonText", "backButtonText", "cancelButtonText", "ariaLabelCloseButton", "ariaLabelNav", "hasBodyPadding", "footer", "isCompactNav", "appendTo"]);

      const {
        currentStep
      } = this.state;
      const flattenedSteps = this.getFlattenedSteps();
      const adjustedStep = flattenedSteps.length < currentStep ? flattenedSteps.length : currentStep;
      const activeStep = flattenedSteps[adjustedStep - 1];
      const computedSteps = this.initSteps(steps);
      const firstStep = activeStep === flattenedSteps[0];
      const isValid = activeStep && activeStep.enableNext !== undefined ? activeStep.enableNext : true;
      const setFullWidth = isFullWidth || width;
      const setFullHeight = isFullHeight || height;

      const nav = isWizardNavOpen => React.createElement(WizardNav, {
        isOpen: isWizardNavOpen,
        ariaLabel: ariaLabelNav
      }, computedSteps.map((step, index) => {
        if (step.isFinishedStep) {
          // Don't show finished step in the side nav
          return;
        }

        let enabled;
        let navItemStep;

        if (step.steps) {
          let hasActiveChild = false;
          let canJumpToParent = false;

          for (const subStep of step.steps) {
            if (activeStep.name === subStep.name) {
              // one of the children matches
              hasActiveChild = true;
            }

            if (subStep.canJumpTo) {
              canJumpToParent = true;
            }
          }

          navItemStep = this.getFlattenedStepsIndex(flattenedSteps, step.steps[0].name);
          return React.createElement(WizardNavItem, {
            key: index,
            text: step.name,
            isCurrent: hasActiveChild,
            isDisabled: !canJumpToParent,
            step: navItemStep,
            onNavItemClick: this.goToStep
          }, React.createElement(WizardNav, {
            returnList: true
          }, step.steps.map((childStep, indexChild) => {
            if (childStep.isFinishedStep) {
              // Don't show finished step in the side nav
              return;
            }

            navItemStep = this.getFlattenedStepsIndex(flattenedSteps, childStep.name);
            enabled = childStep.canJumpTo;
            return React.createElement(WizardNavItem, {
              key: `child_${indexChild}`,
              text: childStep.name,
              isCurrent: activeStep.name === childStep.name,
              isDisabled: !enabled,
              step: navItemStep,
              onNavItemClick: this.goToStep
            });
          })));
        }

        navItemStep = this.getFlattenedStepsIndex(flattenedSteps, step.name);
        enabled = step.canJumpTo;
        return React.createElement(WizardNavItem, {
          key: index,
          text: step.name,
          isCurrent: activeStep.name === step.name,
          isDisabled: !enabled,
          step: navItemStep,
          onNavItemClick: this.goToStep
        });
      }));

      const context = {
        goToStepById: this.goToStepById,
        goToStepByName: this.goToStepByName,
        onNext: this.onNext,
        onBack: this.onBack,
        onClose,
        activeStep
      };

      if (this.isModal && !isOpen) {
        return null;
      }

      const wizard = React.createElement(WizardContextProvider, {
        value: context
      }, React.createElement("div", _extends$2C({}, rest, {
        className: css$1(styles$H.wizard, !this.isModal && styles$H.modifiers.inPage, isCompactNav && 'pf-m-compact-nav', activeStep.isFinishedStep && 'pf-m-finished', setFullWidth && styles$H.modifiers.fullWidth, setFullHeight && styles$H.modifiers.fullHeight, className)
      }, this.isModal && {
        role: 'dialog',
        'aria-modal': 'true',
        'aria-labelledby': this.titleId,
        'aria-describedby': description ? this.descriptionId : undefined
      }), this.isModal && React.createElement(WizardHeader, {
        titleId: this.titleId,
        descriptionId: this.descriptionId,
        onClose: onClose,
        title: title,
        description: description,
        ariaLabelCloseButton: ariaLabelCloseButton
      }), React.createElement(WizardToggle, {
        isNavOpen: this.state.isNavOpen,
        onNavToggle: isNavOpen => this.setState({
          isNavOpen
        }),
        nav: nav,
        steps: steps,
        activeStep: activeStep,
        hasBodyPadding: hasBodyPadding
      }, footer || React.createElement(WizardFooterInternal, {
        onNext: this.onNext,
        onBack: this.onBack,
        onClose: onClose,
        isValid: isValid,
        firstStep: firstStep,
        activeStep: activeStep,
        nextButtonText: activeStep.nextButtonText || nextButtonText,
        backButtonText: backButtonText,
        cancelButtonText: cancelButtonText
      }))));
      return this.isModal ? ReactDOM.createPortal(React.createElement(FocusTrap, {
        focusTrapOptions: {
          clickOutsideDeactivates: true
        }
      }, React.createElement(Backdrop, null, React.createElement(Bullseye, null, wizard))), this.container) : wizard;
    }

  }

  _defineProperty$S(Wizard, "propTypes", {
    isOpen: _pt.bool,
    isInPage: _pt.bool,
    isCompactNav: _pt.bool,
    isFullHeight: _pt.bool,
    isFullWidth: _pt.bool,
    width: _pt.oneOfType([_pt.number, _pt.string]),
    height: _pt.oneOfType([_pt.number, _pt.string]),
    title: _pt.string,
    description: _pt.string,
    onClose: _pt.func,
    onGoToStep: _pt.func,
    className: _pt.string,
    steps: _pt.arrayOf(_pt.shape({
      id: _pt.oneOfType([_pt.string, _pt.number]),
      name: _pt.string.isRequired,
      component: _pt.any,
      isFinishedStep: _pt.bool,
      canJumpTo: _pt.bool,
      steps: _pt.arrayOf(_pt.shape({
        id: _pt.oneOfType([_pt.string, _pt.number]),
        name: _pt.string.isRequired,
        component: _pt.any,
        isFinishedStep: _pt.bool,
        canJumpTo: _pt.bool,
        steps: _pt.arrayOf(_pt.shape({
          id: _pt.oneOfType([_pt.string, _pt.number]),
          name: _pt.string.isRequired,
          component: _pt.any,
          isFinishedStep: _pt.bool,
          canJumpTo: _pt.bool,
          steps: _pt.arrayOf(_pt.object),
          nextButtonText: _pt.string,
          enableNext: _pt.bool,
          hideCancelButton: _pt.bool,
          hideBackButton: _pt.bool
        })),
        nextButtonText: _pt.string,
        enableNext: _pt.bool,
        hideCancelButton: _pt.bool,
        hideBackButton: _pt.bool
      })),
      nextButtonText: _pt.string,
      enableNext: _pt.bool,
      hideCancelButton: _pt.bool,
      hideBackButton: _pt.bool
    })).isRequired,
    startAtStep: _pt.number,
    ariaLabelNav: _pt.string,
    hasBodyPadding: _pt.bool,
    footer: _pt.node,
    onSave: _pt.func,
    onNext: _pt.func,
    onBack: _pt.func,
    nextButtonText: _pt.string,
    backButtonText: _pt.string,
    cancelButtonText: _pt.string,
    ariaLabelCloseButton: _pt.string,
    appendTo: _pt.oneOfType([_pt.any, _pt.func])
  });

  _defineProperty$S(Wizard, "currentId", 0);

  _defineProperty$S(Wizard, "defaultProps", {
    isOpen: false,
    isInPage: false,
    isCompactNav: false,
    isFullHeight: false,
    isFullWidth: false,
    title: '',
    description: '',
    className: '',
    startAtStep: 1,
    nextButtonText: 'Next',
    backButtonText: 'Back',
    cancelButtonText: 'Cancel',
    ariaLabelCloseButton: 'Close',
    ariaLabelNav: 'Steps',
    hasBodyPadding: true,
    onBack: null,
    onNext: null,
    onGoToStep: null,
    width: null,
    height: null,
    footer: null,
    onClose: () => undefined,
    appendTo: null
  });

  const WizardFooter = ({
    children
  }) => React.createElement("footer", {
    className: css$1(styles$H.wizardFooter)
  }, children);
  WizardFooter.propTypes = {
    children: _pt.any.isRequired
  };

  var drawer = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      drawer: 'pf-c-drawer',
      drawerSection: 'pf-c-drawer__section',
      drawerMain: 'pf-c-drawer__main',
      drawerContent: 'pf-c-drawer__content',
      drawerPanel: 'pf-c-drawer__panel',
      drawerHead: 'pf-c-drawer__head',
      drawerActions: 'pf-c-drawer__actions',
      drawerBody: 'pf-c-drawer__body',
      pageMain: 'pf-c-page__main',
      drawerClose: 'pf-c-drawer__close',
      modifiers: {
          'noBackground': 'pf-m-no-background',
          'noPadding': 'pf-m-no-padding',
          'padding': 'pf-m-padding',
          'expanded': 'pf-m-expanded',
          'panelLeft': 'pf-m-panel-left',
          'border': 'pf-m-border',
          'noBorder': 'pf-m-no-border',
          'width_25': 'pf-m-width-25',
          'width_33': 'pf-m-width-33',
          'width_50': 'pf-m-width-50',
          'width_66': 'pf-m-width-66',
          'width_75': 'pf-m-width-75',
          'width_100': 'pf-m-width-100',
          'width_25OnLg': 'pf-m-width-25-on-lg',
          'width_33OnLg': 'pf-m-width-33-on-lg',
          'width_50OnLg': 'pf-m-width-50-on-lg',
          'width_66OnLg': 'pf-m-width-66-on-lg',
          'width_75OnLg': 'pf-m-width-75-on-lg',
          'width_100OnLg': 'pf-m-width-100-on-lg',
          'width_25OnXl': 'pf-m-width-25-on-xl',
          'width_33OnXl': 'pf-m-width-33-on-xl',
          'width_50OnXl': 'pf-m-width-50-on-xl',
          'width_66OnXl': 'pf-m-width-66-on-xl',
          'width_75OnXl': 'pf-m-width-75-on-xl',
          'width_100OnXl': 'pf-m-width-100-on-xl',
          'width_25On_2xl': 'pf-m-width-25-on-2xl',
          'width_33On_2xl': 'pf-m-width-33-on-2xl',
          'width_50On_2xl': 'pf-m-width-50-on-2xl',
          'width_66On_2xl': 'pf-m-width-66-on-2xl',
          'width_75On_2xl': 'pf-m-width-75-on-2xl',
          'width_100On_2xl': 'pf-m-width-100-on-2xl',
          'inline': 'pf-m-inline',
          'static': 'pf-m-static',
          'inlineOnLg': 'pf-m-inline-on-lg',
          'staticOnLg': 'pf-m-static-on-lg',
          'inlineOnXl': 'pf-m-inline-on-xl',
          'staticOnXl': 'pf-m-static-on-xl',
          'inlineOn_2xl': 'pf-m-inline-on-2xl',
          'staticOn_2xl': 'pf-m-static-on-2xl'
      }
  };
  });

  var styles$I = unwrapExports(drawer);

  function _extends$2D() { _extends$2D = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2D.apply(this, arguments); }

  function _objectWithoutProperties$2C(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2B(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2B(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerContext = React.createContext({
    isExpanded: false
  });
  const Drawer = (_ref) => {
    let {
      className = '',
      children,
      isExpanded = false,
      isInline = false,
      isStatic = false,
      position = 'right'
    } = _ref,
        props = _objectWithoutProperties$2C(_ref, ["className", "children", "isExpanded", "isInline", "isStatic", "position"]);

    return React.createElement(DrawerContext.Provider, {
      value: {
        isExpanded
      }
    }, React.createElement("div", _extends$2D({
      className: css$1(styles$I.drawer, isExpanded && styles$I.modifiers.expanded, isInline && styles$I.modifiers.inline, isStatic && styles$I.modifiers.static, position === 'left' && styles$I.modifiers.panelLeft, className)
    }, props), children));
  };
  Drawer.propTypes = {
    className: _pt.string,
    children: _pt.node,
    isExpanded: _pt.bool,
    isInline: _pt.bool,
    isStatic: _pt.bool,
    position: _pt.oneOf(['left', 'right'])
  };

  function _extends$2E() { _extends$2E = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2E.apply(this, arguments); }

  function _objectWithoutProperties$2D(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2C(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2C(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerActions = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children
    } = _ref,
        props = _objectWithoutProperties$2D(_ref, ["className", "children"]);

    return React.createElement("div", _extends$2E({
      className: css$1(styles$I.drawerActions, className)
    }, props), children);
  };
  DrawerActions.propTypes = {
    className: _pt.string,
    children: _pt.node
  };

  function _extends$2F() { _extends$2F = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2F.apply(this, arguments); }

  function _objectWithoutProperties$2E(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2D(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2D(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerCloseButton = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      onClose = () => undefined,
      'aria-label': ariaLabel = 'Close drawer panel'
    } = _ref,
        props = _objectWithoutProperties$2E(_ref, ["className", "onClose", "aria-label"]);

    return React.createElement("div", _extends$2F({
      className: css$1(styles$I.drawerClose, className)
    }, props), React.createElement(ButtonWithOuiaContext, {
      variant: "plain",
      onClick: onClose,
      "aria-label": ariaLabel
    }, React.createElement(TimesIcon, null)));
  };
  DrawerCloseButton.propTypes = {
    className: _pt.string,
    onClose: _pt.func,
    'aria-label': _pt.string
  };

  function _extends$2G() { _extends$2G = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2G.apply(this, arguments); }

  function _objectWithoutProperties$2F(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2E(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2E(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerMain = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children
    } = _ref,
        props = _objectWithoutProperties$2F(_ref, ["className", "children"]);

    return React.createElement("div", _extends$2G({
      className: css$1(styles$I.drawerMain, className)
    }, props), children);
  };
  DrawerMain.propTypes = {
    className: _pt.string,
    children: _pt.node
  };

  function _extends$2H() { _extends$2H = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2H.apply(this, arguments); }

  function _objectWithoutProperties$2G(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2F(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2F(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerContent = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children,
      panelContent
    } = _ref,
        props = _objectWithoutProperties$2G(_ref, ["className", "children", "panelContent"]);

    return React.createElement(DrawerMain, null, React.createElement("div", _extends$2H({
      className: css$1(styles$I.drawerContent, className)
    }, props), children), panelContent);
  };
  DrawerContent.propTypes = {
    className: _pt.string,
    children: _pt.node,
    panelContent: _pt.node.isRequired
  };

  function _extends$2I() { _extends$2I = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2I.apply(this, arguments); }

  function _objectWithoutProperties$2H(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2G(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2G(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerContentBody = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children,
      hasPadding = false
    } = _ref,
        props = _objectWithoutProperties$2H(_ref, ["className", "children", "hasPadding"]);

    return React.createElement("div", _extends$2I({
      className: css$1(styles$I.drawerBody, hasPadding && styles$I.modifiers.padding, className)
    }, props), children);
  };
  DrawerContentBody.propTypes = {
    className: _pt.string,
    children: _pt.node,
    hasPadding: _pt.bool
  };

  function _extends$2J() { _extends$2J = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2J.apply(this, arguments); }

  function _objectWithoutProperties$2I(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2H(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2H(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerPanelBody = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children,
      noPadding = false
    } = _ref,
        props = _objectWithoutProperties$2I(_ref, ["className", "children", "noPadding"]);

    return React.createElement("div", _extends$2J({
      className: css$1(styles$I.drawerBody, noPadding && styles$I.modifiers.noPadding, className)
    }, props), children);
  };
  DrawerPanelBody.propTypes = {
    className: _pt.string,
    children: _pt.node,
    noPadding: _pt.bool
  };

  function _extends$2K() { _extends$2K = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2K.apply(this, arguments); }

  function _objectWithoutProperties$2J(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2I(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2I(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerHead = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children,
      noPadding = false
    } = _ref,
        props = _objectWithoutProperties$2J(_ref, ["className", "children", "noPadding"]);

    return React.createElement(DrawerPanelBody, {
      noPadding: noPadding
    }, React.createElement("div", _extends$2K({
      className: css$1(styles$I.drawerHead, className)
    }, props), children));
  };
  DrawerHead.propTypes = {
    className: _pt.string,
    children: _pt.node,
    noPadding: _pt.bool
  };

  function _extends$2L() { _extends$2L = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2L.apply(this, arguments); }

  function _objectWithoutProperties$2K(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2J(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2J(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerPanelContent = (_ref) => {
    let {
      className = '',
      children,
      hasBorder = false,
      width,
      widthOnLg,
      widthOnXl,
      widthOn2Xl
    } = _ref,
        props = _objectWithoutProperties$2K(_ref, ["className", "children", "hasBorder", "width", "widthOnLg", "widthOnXl", "widthOn2Xl"]);

    return React.createElement(DrawerContext.Consumer, null, ({
      isExpanded
    }) => React.createElement("div", _extends$2L({
      className: css$1(styles$I.drawerPanel, hasBorder && styles$I.modifiers.border, width && styles$I.modifiers[`width_${width}`], widthOnLg && styles$I.modifiers[`width_${widthOnLg}OnLg`], widthOnXl && styles$I.modifiers[`width_${widthOnXl}OnXl`], widthOn2Xl && styles$I.modifiers[`width_${widthOn2Xl}On_2xl`], className),
      hidden: !isExpanded,
      "aria-hidden": !isExpanded,
      "aria-expanded": isExpanded
    }, props), children));
  };
  DrawerPanelContent.propTypes = {
    className: _pt.string,
    children: _pt.node,
    hasBorder: _pt.bool,
    width: _pt.oneOf([25, 33, 50, 66, 75, 100]),
    widthOnLg: _pt.oneOf([25, 33, 50, 66, 75, 100]),
    widthOnXl: _pt.oneOf([25, 33, 50, 66, 75, 100]),
    widthOn2Xl: _pt.oneOf([25, 33, 50, 66, 75, 100])
  };

  function _extends$2M() { _extends$2M = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2M.apply(this, arguments); }

  function _objectWithoutProperties$2L(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2K(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2K(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
  const DrawerSection = (_ref) => {
    let {
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      className = '',
      children
    } = _ref,
        props = _objectWithoutProperties$2L(_ref, ["className", "children"]);

    return React.createElement("div", _extends$2M({
      className: css$1(styles$I.drawerSection, className)
    }, props), children);
  };
  DrawerSection.propTypes = {
    className: _pt.string,
    children: _pt.node
  };

  var dataToolbar = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      dataToolbar: 'pf-c-data-toolbar',
      dataToolbarContentSection: 'pf-c-data-toolbar__content-section',
      divider: 'pf-c-divider',
      dataToolbarGroup: 'pf-c-data-toolbar__group',
      dataToolbarItem: 'pf-c-data-toolbar__item',
      dataToolbarToggle: 'pf-c-data-toolbar__toggle',
      pagination: 'pf-c-pagination',
      dataToolbarContent: 'pf-c-data-toolbar__content',
      dataToolbarExpandableContent: 'pf-c-data-toolbar__expandable-content',
      chipGroup: 'pf-c-chip-group',
      button: 'pf-c-button',
      modifiers: {
          'vertical': 'pf-m-vertical',
          'buttonGroup': 'pf-m-button-group',
          'iconButtonGroup': 'pf-m-icon-button-group',
          'filterGroup': 'pf-m-filter-group',
          'toggleGroup': 'pf-m-toggle-group',
          'alignRight': 'pf-m-align-right',
          'separator': 'pf-m-separator',
          'overflowMenu': 'pf-m-overflow-menu',
          'bulkSelect': 'pf-m-bulk-select',
          'searchFilter': 'pf-m-search-filter',
          'chipGroup': 'pf-m-chip-group',
          'label': 'pf-m-label',
          'pagination': 'pf-m-pagination',
          'expanded': 'pf-m-expanded',
          'chipContainer': 'pf-m-chip-container',
          'plain': 'pf-m-plain',
          'show': 'pf-m-show',
          'showOnMd': 'pf-m-show-on-md',
          'showOnLg': 'pf-m-show-on-lg',
          'showOnXl': 'pf-m-show-on-xl',
          'showOn_2xl': 'pf-m-show-on-2xl',
          'alignLeft': 'pf-m-align-left',
          'hidden': 'pf-m-hidden',
          'visible': 'pf-m-visible',
          'alignRightOnMd': 'pf-m-align-right-on-md',
          'alignLeftOnMd': 'pf-m-align-left-on-md',
          'hiddenOnMd': 'pf-m-hidden-on-md',
          'visibleOnMd': 'pf-m-visible-on-md',
          'alignRightOnLg': 'pf-m-align-right-on-lg',
          'alignLeftOnLg': 'pf-m-align-left-on-lg',
          'hiddenOnLg': 'pf-m-hidden-on-lg',
          'visibleOnLg': 'pf-m-visible-on-lg',
          'alignRightOnXl': 'pf-m-align-right-on-xl',
          'alignLeftOnXl': 'pf-m-align-left-on-xl',
          'hiddenOnXl': 'pf-m-hidden-on-xl',
          'visibleOnXl': 'pf-m-visible-on-xl',
          'alignRightOn_2xl': 'pf-m-align-right-on-2xl',
          'alignLeftOn_2xl': 'pf-m-align-left-on-2xl',
          'hiddenOn_2xl': 'pf-m-hidden-on-2xl',
          'visibleOn_2xl': 'pf-m-visible-on-2xl',
          'spaceItemsNone': 'pf-m-space-items-none',
          'spaceItemsSm': 'pf-m-space-items-sm',
          'spaceItemsMd': 'pf-m-space-items-md',
          'spaceItemsLg': 'pf-m-space-items-lg',
          'spaceItemsNoneOnMd': 'pf-m-space-items-none-on-md',
          'spaceItemsSmOnMd': 'pf-m-space-items-sm-on-md',
          'spaceItemsMdOnMd': 'pf-m-space-items-md-on-md',
          'spaceItemsLgOnMd': 'pf-m-space-items-lg-on-md',
          'spaceItemsNoneOnLg': 'pf-m-space-items-none-on-lg',
          'spaceItemsSmOnLg': 'pf-m-space-items-sm-on-lg',
          'spaceItemsMdOnLg': 'pf-m-space-items-md-on-lg',
          'spaceItemsLgOnLg': 'pf-m-space-items-lg-on-lg',
          'spaceItemsNoneOnXl': 'pf-m-space-items-none-on-xl',
          'spaceItemsSmOnXl': 'pf-m-space-items-sm-on-xl',
          'spaceItemsMdOnXl': 'pf-m-space-items-md-on-xl',
          'spaceItemsLgOnXl': 'pf-m-space-items-lg-on-xl',
          'spaceItemsNoneOn_2xl': 'pf-m-space-items-none-on-2xl',
          'spaceItemsSmOn_2xl': 'pf-m-space-items-sm-on-2xl',
          'spaceItemsMdOn_2xl': 'pf-m-space-items-md-on-2xl',
          'spaceItemsLgOn_2xl': 'pf-m-space-items-lg-on-2xl',
          'spacerNone': 'pf-m-spacer-none',
          'spacerSm': 'pf-m-spacer-sm',
          'spacerMd': 'pf-m-spacer-md',
          'spacerLg': 'pf-m-spacer-lg',
          'spacerNoneOnMd': 'pf-m-spacer-none-on-md',
          'spacerSmOnMd': 'pf-m-spacer-sm-on-md',
          'spacerMdOnMd': 'pf-m-spacer-md-on-md',
          'spacerLgOnMd': 'pf-m-spacer-lg-on-md',
          'spacerNoneOnLg': 'pf-m-spacer-none-on-lg',
          'spacerSmOnLg': 'pf-m-spacer-sm-on-lg',
          'spacerMdOnLg': 'pf-m-spacer-md-on-lg',
          'spacerLgOnLg': 'pf-m-spacer-lg-on-lg',
          'spacerNoneOnXl': 'pf-m-spacer-none-on-xl',
          'spacerSmOnXl': 'pf-m-spacer-sm-on-xl',
          'spacerMdOnXl': 'pf-m-spacer-md-on-xl',
          'spacerLgOnXl': 'pf-m-spacer-lg-on-xl',
          'spacerNoneOn_2xl': 'pf-m-spacer-none-on-2xl',
          'spacerSmOn_2xl': 'pf-m-spacer-sm-on-2xl',
          'spacerMdOn_2xl': 'pf-m-spacer-md-on-2xl',
          'spacerLgOn_2xl': 'pf-m-spacer-lg-on-2xl'
      }
  };
  });

  var styles$J = unwrapExports(dataToolbar);

  var global_breakpoint_lg = {"name":"--pf-global--breakpoint--lg","value":"992px","var":"var(--pf-global--breakpoint--lg)"};

  var global_breakpoint_xl = {"name":"--pf-global--breakpoint--xl","value":"1200px","var":"var(--pf-global--breakpoint--xl)"};

  var global_breakpoint_2xl = {"name":"--pf-global--breakpoint--2xl","value":"1450px","var":"var(--pf-global--breakpoint--2xl)"};

  const DataToolbarContext = React.createContext({
    isExpanded: false,
    toggleIsExpanded: () => {},
    chipGroupContentRef: null,
    updateNumberFilters: () => {},
    numberOfFilters: 0
  });
  const DataToolbarContentContext = React.createContext({
    expandableContentRef: null,
    expandableContentId: '',
    chipContainerRef: null
  });
  const globalBreakpoints = breakpoint => {
    const breakpoints = {
      md: parseInt(global_breakpoint_md.value),
      lg: parseInt(global_breakpoint_lg.value),
      xl: parseInt(global_breakpoint_xl.value),
      '2xl': parseInt(global_breakpoint_2xl.value)
    };
    return breakpoints[breakpoint];
  };

  function _extends$2N() { _extends$2N = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2N.apply(this, arguments); }

  function _objectWithoutProperties$2M(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2L(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2L(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  (function (DataToolbarItemVariant) {
    DataToolbarItemVariant["separator"] = "separator";
    DataToolbarItemVariant["bulk-select"] = "bulk-select";
    DataToolbarItemVariant["overflow-menu"] = "overflow-menu";
    DataToolbarItemVariant["pagination"] = "pagination";
    DataToolbarItemVariant["search-filter"] = "search-filter";
    DataToolbarItemVariant["label"] = "label";
    DataToolbarItemVariant["chip-group"] = "chip-group";
  })(exports.DataToolbarItemVariant || (exports.DataToolbarItemVariant = {}));

  const DataToolbarItem = (_ref) => {
    let {
      className,
      variant,
      breakpointMods = [],
      id,
      children
    } = _ref,
        props = _objectWithoutProperties$2M(_ref, ["className", "variant", "breakpointMods", "id", "children"]);

    const labelVariant = variant === 'label';
    return React.createElement("div", _extends$2N({
      className: css$1(styles$J.dataToolbarItem, variant && getModifier(styles$J, variant), formatBreakpointMods(breakpointMods, styles$J), className)
    }, labelVariant && {
      'aria-hidden': true
    }, {
      id: id
    }, props), children);
  };
  DataToolbarItem.propTypes = {
    className: _pt.string,
    variant: _pt.oneOfType([_pt.any, _pt.oneOf(['separator']), _pt.oneOf(['bulk-select']), _pt.oneOf(['overflow-menu']), _pt.oneOf(['pagination']), _pt.oneOf(['search-filter']), _pt.oneOf(['label']), _pt.oneOf(['chip-group'])]),
    breakpointMods: _pt.arrayOf(_pt.any),
    id: _pt.string,
    children: _pt.node
  };

  function _extends$2O() { _extends$2O = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2O.apply(this, arguments); }

  function _objectWithoutProperties$2N(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2M(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2M(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$T(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  (function (DataToolbarGroupVariant) {
    DataToolbarGroupVariant["filter-group"] = "filter-group";
    DataToolbarGroupVariant["icon-button-group"] = "icon-button-group";
    DataToolbarGroupVariant["button-group"] = "button-group";
  })(exports.DataToolbarGroupVariant || (exports.DataToolbarGroupVariant = {}));

  class DataToolbarGroupWithRef extends React.Component {
    render() {
      const _this$props = this.props,
            {
        breakpointMods,
        className,
        variant,
        children,
        innerRef
      } = _this$props,
            props = _objectWithoutProperties$2N(_this$props, ["breakpointMods", "className", "variant", "children", "innerRef"]);

      return React.createElement("div", _extends$2O({
        className: css$1(styles$J.dataToolbarGroup, variant && getModifier(styles$J, variant), formatBreakpointMods(breakpointMods, styles$J), className)
      }, props, {
        ref: innerRef
      }), children);
    }

  }

  _defineProperty$T(DataToolbarGroupWithRef, "propTypes", {
    className: _pt.string,
    variant: _pt.oneOfType([_pt.any, _pt.oneOf(['filter-group']), _pt.oneOf(['icon-button-group']), _pt.oneOf(['button-group'])]),
    breakpointMods: _pt.arrayOf(_pt.any),
    children: _pt.node,
    innerRef: _pt.any
  });

  _defineProperty$T(DataToolbarGroupWithRef, "defaultProps", {
    breakpointMods: []
  });

  const DataToolbarGroup = React.forwardRef((props, ref) => React.createElement(DataToolbarGroupWithRef, _extends$2O({}, props, {
    innerRef: ref
  })));

  function _extends$2P() { _extends$2P = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2P.apply(this, arguments); }

  function _objectWithoutProperties$2O(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2N(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2N(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$U(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DataToolbarChipGroupContent extends React.Component {
    render() {
      const _this$props = this.props,
            {
        className,
        isExpanded,
        chipGroupContentRef,
        clearAllFilters,
        showClearFiltersButton,
        clearFiltersButtonText,
        collapseListedFiltersBreakpoint,
        numberOfFilters
      } = _this$props,
            props = _objectWithoutProperties$2O(_this$props, ["className", "isExpanded", "chipGroupContentRef", "clearAllFilters", "showClearFiltersButton", "clearFiltersButtonText", "collapseListedFiltersBreakpoint", "numberOfFilters"]);

      const clearChipGroups = () => {
        clearAllFilters();
      };

      const collapseListedFilters = typeof window !== 'undefined' ? window.innerWidth < globalBreakpoints(collapseListedFiltersBreakpoint) : false;
      return React.createElement("div", _extends$2P({
        className: css$1(styles$J.dataToolbarContent, (numberOfFilters === 0 || isExpanded) && getModifier(styles$J, 'hidden'), className)
      }, (numberOfFilters === 0 || isExpanded) && {
        hidden: true
      }, {
        ref: chipGroupContentRef
      }, props), React.createElement(DataToolbarGroup, _extends$2P({
        className: css$1(collapseListedFilters && getModifier(styles$J, 'hidden'))
      }, collapseListedFilters && {
        hidden: true
      }, collapseListedFilters && {
        'aria-hidden': true
      })), collapseListedFilters && numberOfFilters > 0 && !isExpanded && React.createElement(DataToolbarGroup, {
        className: css$1(getModifier(styles$J, 'toggle-group-summary'), 'pf-m-filters-applied-message')
      }, React.createElement(DataToolbarItem, null, numberOfFilters, " filters applied")), showClearFiltersButton && !isExpanded && React.createElement(DataToolbarItem, {
        className: css$1(getModifier(styles$J, 'clear'))
      }, React.createElement(ButtonWithOuiaContext, {
        variant: "link",
        onClick: clearChipGroups,
        isInline: true
      }, clearFiltersButtonText)));
    }

  }

  _defineProperty$U(DataToolbarChipGroupContent, "propTypes", {
    className: _pt.string,
    isExpanded: _pt.bool,
    chipGroupContentRef: _pt.any,
    clearAllFilters: _pt.func,
    showClearFiltersButton: _pt.bool.isRequired,
    clearFiltersButtonText: _pt.string,
    numberOfFilters: _pt.number.isRequired,
    collapseListedFiltersBreakpoint: _pt.oneOf(['md', 'lg', 'xl', '2xl'])
  });

  _defineProperty$U(DataToolbarChipGroupContent, "defaultProps", {
    clearFiltersButtonText: 'Clear all filters',
    collapseListedFiltersBreakpoint: 'lg'
  });

  function _extends$2Q() { _extends$2Q = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2Q.apply(this, arguments); }

  function _objectWithoutProperties$2P(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2O(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2O(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function ownKeys$9(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread$9(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys$9(source, true).forEach(function (key) { _defineProperty$V(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys$9(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty$V(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DataToolbar extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$V(this, "chipGroupContentRef", React.createRef());

      _defineProperty$V(this, "staticFilterInfo", {});

      _defineProperty$V(this, "isToggleManaged", () => !(this.props.isExpanded || !!this.props.toggleIsExpanded));

      _defineProperty$V(this, "toggleIsExpanded", () => {
        this.setState(prevState => ({
          isManagedToggleExpanded: !prevState.isManagedToggleExpanded
        }));
      });

      _defineProperty$V(this, "closeExpandableContent", () => {
        this.setState(() => ({
          isManagedToggleExpanded: false
        }));
      });

      _defineProperty$V(this, "updateNumberFilters", (categoryName, numberOfFilters) => {
        const filterInfoToUpdate = _objectSpread$9({}, this.staticFilterInfo);

        if (!filterInfoToUpdate.hasOwnProperty(categoryName) || filterInfoToUpdate[categoryName] !== numberOfFilters) {
          filterInfoToUpdate[categoryName] = numberOfFilters;
          this.staticFilterInfo = filterInfoToUpdate;
          this.setState({
            filterInfo: filterInfoToUpdate
          });
        }
      });

      _defineProperty$V(this, "getNumberOfFilters", () => Object.values(this.state.filterInfo).reduce((acc, cur) => acc + cur, 0));

      this.state = {
        isManagedToggleExpanded: false,
        filterInfo: {}
      };
    }

    componentDidMount() {
      if (this.isToggleManaged()) {
        window.addEventListener('resize', this.closeExpandableContent);
      }

      if ( !DataToolbar.hasWarnBeta) {
        // eslint-disable-next-line no-console
        console.warn('You are using a beta component (DataToolbar). These api parts are subject to change in the future.');
        DataToolbar.hasWarnBeta = true;
      }
    }

    componentWillUnmount() {
      if (this.isToggleManaged()) {
        window.removeEventListener('resize', this.closeExpandableContent);
      }
    }

    render() {
      const _this$props = this.props,
            {
        clearAllFilters,
        clearFiltersButtonText,
        collapseListedFiltersBreakpoint,
        isExpanded,
        toggleIsExpanded,
        className,
        children,
        id
      } = _this$props,
            props = _objectWithoutProperties$2P(_this$props, ["clearAllFilters", "clearFiltersButtonText", "collapseListedFiltersBreakpoint", "isExpanded", "toggleIsExpanded", "className", "children", "id"]);

      const {
        isManagedToggleExpanded
      } = this.state;
      const isToggleManaged = this.isToggleManaged();
      const numberOfFilters = this.getNumberOfFilters();
      const showClearFiltersButton = numberOfFilters > 0;
      return React.createElement("div", _extends$2Q({
        className: css$1(styles$J.dataToolbar, className),
        id: id
      }, props), React.createElement(DataToolbarContext.Provider, {
        value: {
          isExpanded: this.isToggleManaged() ? isManagedToggleExpanded : isExpanded,
          toggleIsExpanded: isToggleManaged ? this.toggleIsExpanded : toggleIsExpanded,
          chipGroupContentRef: this.chipGroupContentRef,
          updateNumberFilters: this.updateNumberFilters,
          numberOfFilters
        }
      }, React.Children.map(children, child => {
        if (React.isValidElement(child)) {
          return React.cloneElement(child, {
            clearAllFilters,
            clearFiltersButtonText,
            showClearFiltersButton,
            isExpanded: isToggleManaged ? isManagedToggleExpanded : isExpanded,
            toolbarId: id
          });
        } else {
          return child;
        }
      }), React.createElement(DataToolbarChipGroupContent, {
        isExpanded: isToggleManaged ? isManagedToggleExpanded : isExpanded,
        chipGroupContentRef: this.chipGroupContentRef,
        clearAllFilters: clearAllFilters,
        showClearFiltersButton: showClearFiltersButton,
        clearFiltersButtonText: clearFiltersButtonText,
        numberOfFilters: numberOfFilters,
        collapseListedFiltersBreakpoint: collapseListedFiltersBreakpoint
      })));
    }

  }

  _defineProperty$V(DataToolbar, "propTypes", {
    clearAllFilters: _pt.func,
    clearFiltersButtonText: _pt.string,
    collapseListedFiltersBreakpoint: _pt.oneOf(['md', 'lg', 'xl', '2xl']),
    isExpanded: _pt.bool,
    toggleIsExpanded: _pt.func,
    className: _pt.string,
    children: _pt.node,
    id: _pt.string.isRequired
  });

  _defineProperty$V(DataToolbar, "hasWarnBeta", false);

  function _extends$2R() { _extends$2R = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2R.apply(this, arguments); }

  function _objectWithoutProperties$2Q(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2P(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2P(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$W(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DataToolbarExpandableContent extends React.Component {
    render() {
      const _this$props = this.props,
            {
        className,
        expandableContentRef,
        chipContainerRef,
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        isExpanded,
        clearAllFilters,
        clearFiltersButtonText,
        showClearFiltersButton
      } = _this$props,
            props = _objectWithoutProperties$2Q(_this$props, ["className", "expandableContentRef", "chipContainerRef", "isExpanded", "clearAllFilters", "clearFiltersButtonText", "showClearFiltersButton"]);

      const {
        numberOfFilters
      } = this.context;

      const clearChipGroups = () => {
        clearAllFilters();
      };

      return React.createElement("div", _extends$2R({
        className: css$1(styles$J.dataToolbarExpandableContent, className),
        ref: expandableContentRef
      }, props), React.createElement(DataToolbarGroup, null), numberOfFilters > 0 && React.createElement(DataToolbarGroup, {
        className: getModifier(styles$J, 'chip-container')
      }, React.createElement(DataToolbarGroup, {
        ref: chipContainerRef
      }), showClearFiltersButton && React.createElement(DataToolbarItem, {
        className: css$1(getModifier(styles$J, 'clear'))
      }, React.createElement(ButtonWithOuiaContext, {
        variant: "link",
        onClick: clearChipGroups,
        isInline: true
      }, clearFiltersButtonText))));
    }

  }

  _defineProperty$W(DataToolbarExpandableContent, "propTypes", {
    className: _pt.string,
    isExpanded: _pt.bool,
    expandableContentRef: _pt.any,
    chipContainerRef: _pt.any,
    clearAllFilters: _pt.func,
    clearFiltersButtonText: _pt.string,
    showClearFiltersButton: _pt.bool.isRequired
  });

  _defineProperty$W(DataToolbarExpandableContent, "contextType", DataToolbarContext);

  _defineProperty$W(DataToolbarExpandableContent, "defaultProps", {
    isExpanded: false,
    clearFiltersButtonText: 'Clear all filters'
  });

  function _extends$2S() { _extends$2S = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2S.apply(this, arguments); }

  function _objectWithoutProperties$2R(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2Q(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2Q(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$X(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DataToolbarContent extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$X(this, "expandableContentRef", React.createRef());

      _defineProperty$X(this, "chipContainerRef", React.createRef());
    }

    render() {
      const _this$props = this.props,
            {
        className,
        children,
        isExpanded,
        toolbarId,
        breakpointMods,
        clearAllFilters,
        showClearFiltersButton,
        clearFiltersButtonText
      } = _this$props,
            props = _objectWithoutProperties$2R(_this$props, ["className", "children", "isExpanded", "toolbarId", "breakpointMods", "clearAllFilters", "showClearFiltersButton", "clearFiltersButtonText"]);

      const expandableContentId = `${toolbarId}-expandable-content-${DataToolbarContent.currentId++}`;
      return React.createElement("div", _extends$2S({
        className: css$1(styles$J.dataToolbarContent, formatBreakpointMods(breakpointMods, styles$J), className)
      }, props), React.createElement(DataToolbarContentContext.Provider, {
        value: {
          expandableContentRef: this.expandableContentRef,
          expandableContentId,
          chipContainerRef: this.chipContainerRef
        }
      }, React.createElement("div", {
        className: css$1(styles$J.dataToolbarContentSection)
      }, children), React.createElement(DataToolbarExpandableContent, {
        id: expandableContentId,
        isExpanded: isExpanded,
        expandableContentRef: this.expandableContentRef,
        chipContainerRef: this.chipContainerRef,
        clearAllFilters: clearAllFilters,
        showClearFiltersButton: showClearFiltersButton,
        clearFiltersButtonText: clearFiltersButtonText
      })));
    }

  }

  _defineProperty$X(DataToolbarContent, "propTypes", {
    className: _pt.string,
    breakpointMods: _pt.arrayOf(_pt.any),
    children: _pt.node,
    isExpanded: _pt.bool,
    clearAllFilters: _pt.func,
    showClearFiltersButton: _pt.bool,
    clearFiltersButtonText: _pt.string,
    toolbarId: _pt.string
  });

  _defineProperty$X(DataToolbarContent, "currentId", 0);

  _defineProperty$X(DataToolbarContent, "defaultProps", {
    isExpanded: false,
    breakpointMods: [],
    showClearFiltersButton: false
  });

  function _objectWithoutProperties$2S(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2R(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2R(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$Y(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DataToolbarFilter extends React.Component {
    constructor(props) {
      super(props);
      this.state = {
        isMounted: false
      };
    }

    componentDidMount() {
      const {
        categoryName,
        chips
      } = this.props;
      this.context.updateNumberFilters(typeof categoryName === 'string' ? categoryName : categoryName.name, chips.length);
      this.setState({
        isMounted: true
      });
    }

    componentDidUpdate() {
      const {
        categoryName,
        chips
      } = this.props;
      this.context.updateNumberFilters(typeof categoryName === 'string' ? categoryName : categoryName.name, chips.length);
    }

    render() {
      const _this$props = this.props,
            {
        children,
        chips,
        deleteChipGroup,
        deleteChip,
        categoryName,
        showToolbarItem
      } = _this$props,
            props = _objectWithoutProperties$2S(_this$props, ["children", "chips", "deleteChipGroup", "deleteChip", "categoryName", "showToolbarItem"]);

      const {
        isExpanded,
        chipGroupContentRef
      } = this.context;
      const chipGroup = chips.length ? React.createElement(DataToolbarItem, {
        variant: "chip-group"
      }, React.createElement(ChipGroup, {
        withToolbar: true
      }, React.createElement(ChipGroupToolbarItem, {
        key: typeof categoryName === 'string' ? categoryName : categoryName.key,
        categoryName: typeof categoryName === 'string' ? categoryName : categoryName.name,
        isClosable: deleteChipGroup !== undefined,
        onClick: () => deleteChipGroup(categoryName)
      }, chips.map(chip => typeof chip === 'string' ? React.createElement(ChipWithOuiaContext, {
        key: chip,
        onClick: () => deleteChip(categoryName, chip)
      }, chip) : React.createElement(ChipWithOuiaContext, {
        key: chip.key,
        onClick: () => deleteChip(categoryName, chip)
      }, chip.node))))) : null;

      if (!isExpanded && this.state.isMounted) {
        return React.createElement(React.Fragment, null, showToolbarItem && React.createElement(DataToolbarItem, props, children), ReactDOM.createPortal(chipGroup, chipGroupContentRef.current.firstElementChild));
      }

      return React.createElement(DataToolbarContentContext.Consumer, null, ({
        chipContainerRef
      }) => React.createElement(React.Fragment, null, showToolbarItem && React.createElement(DataToolbarItem, props, children), chipContainerRef.current && ReactDOM.createPortal(chipGroup, chipContainerRef.current)));
    }

  }

  _defineProperty$Y(DataToolbarFilter, "propTypes", {
    chips: _pt.arrayOf(_pt.oneOfType([_pt.string, _pt.shape({
      key: _pt.string.isRequired,
      node: _pt.node.isRequired
    })])),
    deleteChipGroup: _pt.func,
    deleteChip: _pt.func,
    children: _pt.node.isRequired,
    categoryName: _pt.oneOfType([_pt.string, _pt.shape({
      key: _pt.string.isRequired,
      name: _pt.string.isRequired
    })]).isRequired,
    showToolbarItem: _pt.bool
  });

  _defineProperty$Y(DataToolbarFilter, "contextType", DataToolbarContext);

  _defineProperty$Y(DataToolbarFilter, "defaultProps", {
    chips: [],
    showToolbarItem: true
  });

  function _extends$2T() { _extends$2T = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2T.apply(this, arguments); }

  function _objectWithoutProperties$2T(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2S(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2S(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$Z(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class DataToolbarToggleGroup extends React.Component {
    constructor(...args) {
      super(...args);

      _defineProperty$Z(this, "isContentPopup", () => {
        const viewportSize = window.innerWidth;
        const lgBreakpointValue = parseInt(global_breakpoint_lg.value);
        return viewportSize < lgBreakpointValue;
      });
    }

    render() {
      const _this$props = this.props,
            {
        toggleIcon,
        breakpoint,
        variant,
        breakpointMods,
        className,
        children
      } = _this$props,
            props = _objectWithoutProperties$2T(_this$props, ["toggleIcon", "breakpoint", "variant", "breakpointMods", "className", "children"]);

      return React.createElement(DataToolbarContext.Consumer, null, ({
        isExpanded,
        toggleIsExpanded
      }) => React.createElement(DataToolbarContentContext.Consumer, null, ({
        expandableContentRef,
        expandableContentId
      }) => {
        if (expandableContentRef.current && expandableContentRef.current.classList) {
          if (isExpanded) {
            expandableContentRef.current.classList.add(getModifier(styles$J, 'expanded'));
          } else {
            expandableContentRef.current.classList.remove(getModifier(styles$J, 'expanded'));
          }
        }

        return React.createElement("div", _extends$2T({
          className: css$1(styles$J.dataToolbarGroup, variant && getModifier(styles$J, variant), formatBreakpointMods(breakpointMods, styles$J), getModifier(styles$J, 'toggle-group'), getModifier(styles$J, `show-on-${breakpoint}`), className)
        }, props), React.createElement("div", {
          className: css$1(styles$J.dataToolbarToggle)
        }, React.createElement(ButtonWithOuiaContext, _extends$2T({
          variant: "plain",
          onClick: toggleIsExpanded,
          "aria-label": "Show Filters"
        }, isExpanded && {
          'aria-expanded': true
        }, {
          "aria-haspopup": isExpanded && this.isContentPopup(),
          "aria-controls": expandableContentId
        }), toggleIcon)), isExpanded ? ReactDOM.createPortal(children, expandableContentRef.current.firstElementChild) : children);
      }));
    }

  }

  _defineProperty$Z(DataToolbarToggleGroup, "propTypes", {
    toggleIcon: _pt.node.isRequired,
    breakpoint: _pt.oneOf(['md', 'lg', 'xl']).isRequired,
    breakpointMods: _pt.arrayOf(_pt.any)
  });

  _defineProperty$Z(DataToolbarToggleGroup, "defaultProps", {
    breakpointMods: []
  });

  var overflowMenu = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      overflowMenu: 'pf-c-overflow-menu',
      overflowMenuContent: 'pf-c-overflow-menu__content',
      overflowMenuGroup: 'pf-c-overflow-menu__group',
      overflowMenuItem: 'pf-c-overflow-menu__item',
      overflowMenuControl: 'pf-c-overflow-menu__control',
      divider: 'pf-c-divider',
      modifiers: {
          'buttonGroup': 'pf-m-button-group',
          'iconButtonGroup': 'pf-m-icon-button-group',
          'vertical': 'pf-m-vertical'
      }
  };
  });

  var styles$K = unwrapExports(overflowMenu);

  const OverflowMenuContext = React.createContext({
    isBelowBreakpoint: false
  });

  function _extends$2U() { _extends$2U = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2U.apply(this, arguments); }

  function _objectWithoutProperties$2U(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose$2T(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

  function _objectWithoutPropertiesLoose$2T(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

  function _defineProperty$_(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
  class OverflowMenu extends React.Component {
    constructor(props) {
      super(props);

      _defineProperty$_(this, "handleResize", () => {
        const breakpoints = {
          /* eslint-disable camelcase */
          md: global_breakpoint_md,
          lg: global_breakpoint_lg,
          xl: global_breakpoint_xl
          /* eslint-enable camelcase */

        };
        const {
          breakpoint
        } = this.props;
        let breakpointWidth = breakpoints[breakpoint].value;
        breakpointWidth = Number(breakpointWidth.split('px')[0]);
        const isBelowBreakpoint = window.innerWidth < breakpointWidth;
        this.state.isBelowBreakpoint !== isBelowBreakpoint && this.setState({
          isBelowBreakpoint
        });
      });

      this.state = {
        isBelowBreakpoint: false
      };
    }

    componentDidMount() {
      this.handleResize();
      window.addEventListener('resize', debounce(this.handleResize, 250));
    }

    componentWillUnmount() {
      window.removeEventListener('resize', debounce(this.handleResize, 250));
    }

    render() {
      const _this$props = this.props,
            {
        className,
        breakpoint,
        children
      } = _this$props,
            props = _objectWithoutProperties$2U(_this$props, ["className", "breakpoint", "children"]);

      return React.createElement("div", _extends$2U({}, props, {
        className: css$1(styles$K.overflowMenu, getModifier(styles$K.modifiers, `showOn ${breakpoint}`), className)
      }), React.createElement(OverflowMenuContext.Provider, {
        value: {
          isBelowBreakpoint: this.state.isBelowBreakpoint
        }
      }, children));
    }

  }

  _defineProperty$_(OverflowMenu, "propTypes", {
    children: _pt.any,
    className: _pt.string,
    breakpoint: _pt.oneOf(['md', 'lg', 'xl']).isRequired
  });

  OverflowMenu.contextType = OverflowMenuContext;

  const OverflowMenuControl = ({
    className,
    children,
    hasAdditionalOptions
  }) => React.createElement(OverflowMenuContext.Consumer, null, value => (value.isBelowBreakpoint || hasAdditionalOptions) && React.createElement("div", {
    className: css$1(styles$K.overflowMenuControl, className)
  }, " ", children, " "));
  OverflowMenuControl.propTypes = {
    children: _pt.any,
    className: _pt.string,
    hasAdditionalOptions: _pt.bool
  };

  const OverflowMenuContent = ({
    className,
    children,
    isPersistent
  }) => React.createElement(OverflowMenuContext.Consumer, null, value => (!value.isBelowBreakpoint || isPersistent) && React.createElement("div", {
    className: css$1(styles$K.overflowMenuContent, className)
  }, children));
  OverflowMenuContent.propTypes = {
    children: _pt.any,
    className: _pt.string,
    isPersistent: _pt.bool
  };

  const OverflowMenuGroup = ({
    className,
    children,
    isPersistent = false,
    groupType
  }) => React.createElement(OverflowMenuContext.Consumer, null, value => (isPersistent || !value.isBelowBreakpoint) && React.createElement("div", {
    className: css$1(styles$K.overflowMenuGroup, groupType === 'button' && styles$K.modifiers.buttonGroup, groupType === 'icon' && styles$K.modifiers.iconButtonGroup, className)
  }, children));
  OverflowMenuGroup.propTypes = {
    children: _pt.any,
    className: _pt.string,
    isPersistent: _pt.bool,
    groupType: _pt.oneOf(['button', 'icon'])
  };

  const OverflowMenuItem = ({
    className,
    children,
    isPersistent = false
  }) => React.createElement(OverflowMenuContext.Consumer, null, value => (isPersistent || !value.isBelowBreakpoint) && React.createElement("div", {
    className: css$1(styles$K.overflowMenuItem, className)
  }, " ", children, " "));
  OverflowMenuItem.propTypes = {
    children: _pt.any,
    className: _pt.string,
    isPersistent: _pt.bool
  };

  const OverflowMenuDropdownItem = ({
    children,
    isShared = false
  }) => React.createElement(OverflowMenuContext.Consumer, null, value => (!isShared || value.isBelowBreakpoint) && React.createElement(DropdownItem, {
    component: "button"
  }, " ", children, " "));
  OverflowMenuDropdownItem.propTypes = {
    children: _pt.any,
    isShared: _pt.bool
  };

  var flex = createCommonjsModule(function (module, exports) {
  Object.defineProperty(exports, "__esModule", { value: true });

  exports.default = {
      flex: 'pf-l-flex',
      modifiers: {
          'flex': 'pf-m-flex',
          'inlineFlex': 'pf-m-inline-flex',
          'column': 'pf-m-column',
          'columnReverse': 'pf-m-column-reverse',
          'row': 'pf-m-row',
          'rowReverse': 'pf-m-row-reverse',
          'wrap': 'pf-m-wrap',
          'wrapReverse': 'pf-m-wrap-reverse',
          'nowrap': 'pf-m-nowrap',
          'justifyContentFlexStart': 'pf-m-justify-content-flex-start',
          'justifyContentFlexEnd': 'pf-m-justify-content-flex-end',
          'justifyContentCenter': 'pf-m-justify-content-center',
          'justifyContentSpaceBetween': 'pf-m-justify-content-space-between',
          'justifyContentSpaceAround': 'pf-m-justify-content-space-around',
          'justifyContentSpaceEvenly': 'pf-m-justify-content-space-evenly',
          'alignItemsFlexStart': 'pf-m-align-items-flex-start',
          'alignItemsFlexEnd': 'pf-m-align-items-flex-end',
          'alignItemsCenter': 'pf-m-align-items-center',
          'alignItemsStretch': 'pf-m-align-items-stretch',
          'alignItemsBaseline': 'pf-m-align-items-baseline',
          'alignContentFlexStart': 'pf-m-align-content-flex-start',
          'alignContentFlexEnd': 'pf-m-align-content-flex-end',
          'alignContentCenter': 'pf-m-align-content-center',
          'alignContentStretch': 'pf-m-align-content-stretch',
          'alignContentSpaceBetween': 'pf-m-align-content-space-between',
          'alignContentSpaceAround': 'pf-m-align-content-space-around',
          'alignRight': 'pf-m-align-right',
          'alignLeft': 'pf-m-align-left',
          'grow': 'pf-m-grow',
          'shrink': 'pf-m-shrink',
          'fullWidth': 'pf-m-full-width',
          'flex_1': 'pf-m-flex-1',
          'flex_2': 'pf-m-flex-2',
          'flex_3': 'pf-m-flex-3',
          'flex_4': 'pf-m-flex-4',
          'flexDefault': 'pf-m-flex-default',
          'flexNone': 'pf-m-flex-none',
          'alignSelfFlexStart': 'pf-m-align-self-flex-start',
          'alignSelfFlexEnd': 'pf-m-align-self-flex-end',
          'alignSelfCenter': 'pf-m-align-self-center',
          'alignSelfBaseline': 'pf-m-align-self-baseline',
          'alignSelfStretch': 'pf-m-align-self-stretch',
          'flexOnSm': 'pf-m-flex-on-sm',
          'inlineFlexOnSm': 'pf-m-inline-flex-on-sm',
          'columnOnSm': 'pf-m-column-on-sm',
          'columnReverseOnSm': 'pf-m-column-reverse-on-sm',
          'rowOnSm': 'pf-m-row-on-sm',
          'rowReverseOnSm': 'pf-m-row-reverse-on-sm',
          'wrapOnSm': 'pf-m-wrap-on-sm',
          'wrapReverseOnSm': 'pf-m-wrap-reverse-on-sm',
          'nowrapOnSm': 'pf-m-nowrap-on-sm',
          'justifyContentFlexStartOnSm': 'pf-m-justify-content-flex-start-on-sm',
          'justifyContentFlexEndOnSm': 'pf-m-justify-content-flex-end-on-sm',
          'justifyContentCenterOnSm': 'pf-m-justify-content-center-on-sm',
          'justifyContentSpaceBetweenOnSm': 'pf-m-justify-content-space-between-on-sm',
          'justifyContentSpaceAroundOnSm': 'pf-m-justify-content-space-around