"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPieLegendY = exports.getPieLegendX = exports.getChartLegendY = exports.getChartLegendX = exports.getBulletLegendY = exports.getLegendY = exports.getLegendX = exports.getLegendItemsPerRow = exports.doesLegendFit = exports.getLegendDimensions = exports.getComputedLegend = void 0;

var _lodash = require("lodash");

var _victory = require("victory");

var _victoryCore = require("victory-core");

var _ChartTheme = require("../ChartTheme");

var _chartLabel = require("./chart-label");

var _chartOrigin = require("./chart-origin");

var React = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Returns a legend which has been positioned per the given chart properties
var getComputedLegend = function getComputedLegend(_ref) {
  var _ref$allowWrap = _ref.allowWrap,
      allowWrap = _ref$allowWrap === void 0 ? true : _ref$allowWrap,
      _ref$chartType = _ref.chartType,
      chartType = _ref$chartType === void 0 ? 'chart' : _ref$chartType,
      _ref$dx = _ref.dx,
      dx = _ref$dx === void 0 ? 0 : _ref$dx,
      _ref$dy = _ref.dy,
      dy = _ref$dy === void 0 ? 0 : _ref$dy,
      height = _ref.height,
      legendComponent = _ref.legendComponent,
      padding = _ref.padding,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? _ChartTheme.ChartCommonStyles.legend.position : _ref$position,
      theme = _ref.theme,
      width = _ref.width,
      _ref$orientation = _ref.orientation,
      orientation = _ref$orientation === void 0 ? theme.legend.orientation : _ref$orientation;
  // Get the number of legend items per row
  var legendItemsProps = legendComponent.props ? legendComponent.props : {};
  var legendItemsPerRow = allowWrap ? getLegendItemsPerRow({
    chartType: chartType,
    dx: dx,
    height: height,
    legendData: legendItemsProps.data,
    legendOrientation: legendItemsProps.legendOrientation ? legendItemsProps.legendOrientation : orientation,
    legendPosition: position,
    legendProps: legendItemsProps,
    padding: padding,
    theme: theme,
    width: width
  }) : undefined; // Include new itemsPerRow prop when determining x and y position

  var legendPositionProps = (0, _lodash.defaults)({}, legendComponent.props, {
    itemsPerRow: legendItemsPerRow
  });
  var legendX = getLegendX({
    chartType: chartType,
    dx: dx,
    height: height,
    legendData: legendPositionProps.data,
    legendOrientation: legendPositionProps.legendOrientation ? legendPositionProps.legendOrientation : orientation,
    legendPosition: position,
    legendProps: legendPositionProps,
    padding: padding,
    theme: theme,
    width: width
  });
  var legendY = getLegendY({
    chartType: chartType,
    dy: dy,
    height: height,
    legendData: legendPositionProps.data,
    legendOrientation: legendPositionProps.legendOrientation ? legendPositionProps.legendOrientation : orientation,
    legendProps: legendPositionProps,
    legendPosition: position,
    padding: padding,
    theme: theme,
    width: width
  }); // Clone legend with updated props

  var legendProps = (0, _lodash.defaults)({}, legendComponent.props, {
    itemsPerRow: legendItemsPerRow,
    orientation: orientation,
    standalone: false,
    theme: theme,
    x: legendX > 0 ? legendX : 0,
    y: legendY > 0 ? legendY : 0
  });
  return React.cloneElement(legendComponent, legendProps);
}; // Returns legend dimensions


exports.getComputedLegend = getComputedLegend;

var getLegendDimensions = function getLegendDimensions(_ref2) {
  var legendData = _ref2.legendData,
      legendOrientation = _ref2.legendOrientation,
      legendProps = _ref2.legendProps,
      theme = _ref2.theme;

  if (legendData || legendProps.data) {
    return _victory.VictoryLegend.getDimensions(_objectSpread({
      data: legendData,
      orientation: legendOrientation,
      theme: theme
    }, legendProps));
  }

  return {};
}; // Returns true if the legend is smaller than its container


exports.getLegendDimensions = getLegendDimensions;

var doesLegendFit = function doesLegendFit(_ref3) {
  var _ref3$dx = _ref3.dx,
      dx = _ref3$dx === void 0 ? 0 : _ref3$dx,
      height = _ref3.height,
      legendPosition = _ref3.legendPosition,
      legendData = _ref3.legendData,
      legendOrientation = _ref3.legendOrientation,
      legendProps = _ref3.legendProps,
      padding = _ref3.padding,
      theme = _ref3.theme,
      width = _ref3.width;

  var _Helpers$getPadding = _victoryCore.Helpers.getPadding({
    padding: padding
  }),
      left = _Helpers$getPadding.left,
      right = _Helpers$getPadding.right;

  var chartSize = {
    height: height,
    // Fixed size
    width: width - left - right
  };
  var legendDimensions = getLegendDimensions({
    legendData: legendData,
    legendOrientation: legendOrientation,
    legendProps: legendProps,
    theme: theme
  });
  var occupiedWidth = 0;

  switch (legendPosition) {
    case 'bottom-left':
      occupiedWidth = left + dx;
      break;

    case 'right':
      occupiedWidth = chartSize.width + _ChartTheme.ChartCommonStyles.legend.margin + left + dx;
      break;

    default:
      occupiedWidth = dx;
      break;
  }

  return width - occupiedWidth > legendDimensions.width;
}; // Returns the number of legend items per row


exports.doesLegendFit = doesLegendFit;

var getLegendItemsPerRow = function getLegendItemsPerRow(_ref4) {
  var dx = _ref4.dx,
      height = _ref4.height,
      legendPosition = _ref4.legendPosition,
      legendData = _ref4.legendData,
      legendOrientation = _ref4.legendOrientation,
      legendProps = _ref4.legendProps,
      padding = _ref4.padding,
      theme = _ref4.theme,
      width = _ref4.width;
  var itemsPerRow = legendData ? legendData.length : 0;

  for (var i = itemsPerRow; i > 0; i--) {
    var fits = doesLegendFit({
      dx: dx,
      height: height,
      legendPosition: legendPosition,
      legendData: legendData,
      legendOrientation: legendOrientation,
      legendProps: _objectSpread({}, legendProps, {
        itemsPerRow: i
      }),
      padding: padding,
      theme: theme,
      width: width
    });

    if (fits) {
      itemsPerRow = i;
      break;
    }
  }

  return itemsPerRow;
}; // Returns x coordinate for legend


exports.getLegendItemsPerRow = getLegendItemsPerRow;

var getLegendX = function getLegendX(_ref5) {
  var chartType = _ref5.chartType,
      rest = _objectWithoutProperties(_ref5, ["chartType"]);

  return chartType === 'pie' ? getPieLegendX(rest) : getChartLegendX(rest);
}; // Returns y coordinate for legend


exports.getLegendX = getLegendX;

var getLegendY = function getLegendY(_ref6) {
  var chartType = _ref6.chartType,
      rest = _objectWithoutProperties(_ref6, ["chartType"]);

  switch (chartType) {
    case 'pie':
      return getPieLegendY(rest);

    case 'bullet':
      return getBulletLegendY(rest);

    default:
      return getChartLegendY(rest);
  }
}; // Returns y coordinate for bullet legends


exports.getLegendY = getLegendY;

var getBulletLegendY = function getBulletLegendY(_ref7) {
  var _ref7$dy = _ref7.dy,
      dy = _ref7$dy === void 0 ? 0 : _ref7$dy,
      height = _ref7.height,
      legendPosition = _ref7.legendPosition,
      legendData = _ref7.legendData,
      legendOrientation = _ref7.legendOrientation,
      legendProps = _ref7.legendProps,
      padding = _ref7.padding,
      theme = _ref7.theme,
      width = _ref7.width;

  var _Helpers$getPadding2 = _victoryCore.Helpers.getPadding({
    padding: padding
  }),
      left = _Helpers$getPadding2.left,
      right = _Helpers$getPadding2.right;

  var chartSize = {
    height: height,
    // Fixed size
    width: width - left - right
  };

  switch (legendPosition) {
    case 'bottom':
    case 'bottom-left':
      return chartSize.height + _ChartTheme.ChartCommonStyles.legend.margin + dy;

    case 'right':
      {
        // Legend height with padding
        var legendDimensions = getLegendDimensions({
          legendData: legendData,
          legendOrientation: legendOrientation,
          legendProps: legendProps,
          theme: theme
        });

        var legendPadding = function legendPadding(legendDataArr) {
          return legendDataArr && legendDataArr.length > 0 ? 17 : 0;
        };

        return (chartSize.height - legendDimensions.height) / 2 + legendPadding(legendData);
      }

    default:
      return dy;
  }
}; // Returns x coordinate for chart legends


exports.getBulletLegendY = getBulletLegendY;

var getChartLegendX = function getChartLegendX(_ref8) {
  var _ref8$dx = _ref8.dx,
      dx = _ref8$dx === void 0 ? 0 : _ref8$dx,
      height = _ref8.height,
      legendData = _ref8.legendData,
      legendOrientation = _ref8.legendOrientation,
      legendPosition = _ref8.legendPosition,
      legendProps = _ref8.legendProps,
      padding = _ref8.padding,
      theme = _ref8.theme,
      width = _ref8.width;

  var _Helpers$getPadding3 = _victoryCore.Helpers.getPadding({
    padding: padding
  }),
      top = _Helpers$getPadding3.top,
      bottom = _Helpers$getPadding3.bottom,
      left = _Helpers$getPadding3.left,
      right = _Helpers$getPadding3.right;

  var chartSize = {
    height: Math.abs(height - (bottom + top)),
    width: Math.abs(width - (left + right))
  };
  var legendDimensions = getLegendDimensions({
    legendData: legendData,
    legendOrientation: legendOrientation,
    legendProps: legendProps,
    theme: theme
  });
  var textSizeWorkAround = getTextSizeWorkAround({
    legendData: legendData,
    legendOrientation: legendOrientation,
    theme: theme
  });

  switch (legendPosition) {
    case 'bottom':
      return width > legendDimensions.width - textSizeWorkAround ? Math.round((width - (legendDimensions.width - textSizeWorkAround)) / 2) + dx : dx;

    case 'bottom-left':
      return left + dx;

    case 'right':
      return chartSize.width + _ChartTheme.ChartCommonStyles.legend.margin + left + dx;

    default:
      return dx;
  }
}; // Returns y coordinate for chart legends


exports.getChartLegendX = getChartLegendX;

var getChartLegendY = function getChartLegendY(_ref9) {
  var _ref9$dy = _ref9.dy,
      dy = _ref9$dy === void 0 ? 0 : _ref9$dy,
      height = _ref9.height,
      legendPosition = _ref9.legendPosition,
      legendData = _ref9.legendData,
      legendOrientation = _ref9.legendOrientation,
      legendProps = _ref9.legendProps,
      padding = _ref9.padding,
      theme = _ref9.theme,
      width = _ref9.width;

  var _Helpers$getPadding4 = _victoryCore.Helpers.getPadding({
    padding: padding
  }),
      top = _Helpers$getPadding4.top,
      bottom = _Helpers$getPadding4.bottom,
      left = _Helpers$getPadding4.left,
      right = _Helpers$getPadding4.right;

  var chartSize = {
    height: Math.abs(height - (bottom + top)),
    width: Math.abs(width - (left + right))
  };

  switch (legendPosition) {
    case 'bottom':
    case 'bottom-left':
      return chartSize.height + _ChartTheme.ChartCommonStyles.legend.margin * 2 + top + dy;

    case 'right':
      {
        // Legend height with padding
        var legendDimensions = getLegendDimensions({
          legendData: legendData,
          legendOrientation: legendOrientation,
          legendProps: legendProps,
          theme: theme
        });
        var originX = chartSize.height / 2 + top;

        var legendPadding = function legendPadding(legendDataArr) {
          return legendDataArr && legendDataArr.length > 0 ? 2 : 0;
        };

        return originX - legendDimensions.height / 2 + legendPadding(legendData);
      }

    default:
      return dy;
  }
}; // Returns x coordinate for pie legends


exports.getChartLegendY = getChartLegendY;

var getPieLegendX = function getPieLegendX(_ref10) {
  var _ref10$dx = _ref10.dx,
      dx = _ref10$dx === void 0 ? 0 : _ref10$dx,
      height = _ref10.height,
      legendData = _ref10.legendData,
      legendOrientation = _ref10.legendOrientation,
      legendPosition = _ref10.legendPosition,
      legendProps = _ref10.legendProps,
      padding = _ref10.padding,
      theme = _ref10.theme,
      width = _ref10.width;
  var origin = (0, _chartOrigin.getPieOrigin)({
    height: height,
    padding: padding,
    width: width
  });

  var radius = _victoryCore.Helpers.getRadius({
    height: height,
    width: width,
    padding: padding
  });

  var legendDimensions = getLegendDimensions({
    legendData: legendData,
    legendOrientation: legendOrientation,
    legendProps: legendProps,
    theme: theme
  });
  var textSizeWorkAround = getTextSizeWorkAround({
    legendData: legendData,
    legendOrientation: legendOrientation,
    theme: theme
  });

  switch (legendPosition) {
    case 'bottom':
      return width > legendDimensions.width - textSizeWorkAround ? Math.round((width - (legendDimensions.width - textSizeWorkAround)) / 2) + dx : dx;

    case 'right':
      return origin.x + _ChartTheme.ChartCommonStyles.label.margin + dx + radius;

    default:
      return dx;
  }
}; // Returns y coordinate for pie legends


exports.getPieLegendX = getPieLegendX;

var getPieLegendY = function getPieLegendY(_ref11) {
  var _ref11$dy = _ref11.dy,
      dy = _ref11$dy === void 0 ? 0 : _ref11$dy,
      height = _ref11.height,
      legendPosition = _ref11.legendPosition,
      legendData = _ref11.legendData,
      legendOrientation = _ref11.legendOrientation,
      legendProps = _ref11.legendProps,
      padding = _ref11.padding,
      theme = _ref11.theme,
      width = _ref11.width;
  var origin = (0, _chartOrigin.getPieOrigin)({
    height: height,
    padding: padding,
    width: width
  });

  var radius = _victoryCore.Helpers.getRadius({
    height: height,
    width: width,
    padding: padding
  });

  switch (legendPosition) {
    case 'bottom':
      return origin.y + _ChartTheme.ChartCommonStyles.legend.margin + radius + dy;

    case 'right':
      {
        // Legend height with padding
        var legendDimensions = getLegendDimensions({
          legendData: legendData,
          legendOrientation: legendOrientation,
          legendProps: legendProps,
          theme: theme
        });

        var legendPadding = function legendPadding(legendDataArr) {
          return legendDataArr && legendDataArr.length > 0 ? 2 : 0;
        };

        return origin.y - legendDimensions.height / 2 + legendPadding(legendData);
      }

    default:
      return dy;
  }
}; // Returns an approximation of over-sized text width due to growing character count
//
// See https://github.com/FormidableLabs/victory/issues/864


exports.getPieLegendY = getPieLegendY;

var getTextSizeWorkAround = function getTextSizeWorkAround(_ref12) {
  var legendData = _ref12.legendData,
      legendOrientation = _ref12.legendOrientation,
      theme = _ref12.theme;
  var style = theme.legend.style.labels;

  if (!(legendData && legendData.length)) {
    return 0;
  } // For horizontal legends, account for the growing char count of the last legend item


  var result = legendData[legendData.length - 1].name; // For vertical legends, account for the growing char count of the longest legend item

  if (legendOrientation === 'vertical') {
    legendData.forEach(function (data) {
      if (data.name && data.name.length > result.length) {
        result = data.name;
      }
    });
  }

  var textSize = _victoryCore.TextSize.approximateTextSize(result, style);

  var adjustedTextSize = _victoryCore.TextSize.approximateTextSize(result, _objectSpread({}, style, {
    characterConstant: _chartLabel.overpassFontCharacterConstant
  }));

  return Math.abs(textSize.width - adjustedTextSize.width);
};
//# sourceMappingURL=chart-legend.js.map