---
title: Box shadow
section: utilities
---

import './BoxShadow.css'

## Examples
```hbs title=Basic
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm"}}
  Box shadow small
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-top"}}
  Box shadow small, top
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-right"}}
  Box shadow small, right
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-bottom"}}
  Box shadow small, bottom
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-sm-left"}}
  Box shadow small, left
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md"}}
  Box shadow medium
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-top"}}
  Box shadow medium, top
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-right"}}
  Box shadow medium, right
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-bottom"}}
  Box shadow medium, bottom
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-md-left"}}
  Box shadow medium, left
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg"}}
  Box shadow large
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-top"}}
  Box shadow large, top
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-right"}}
  Box shadow large, right
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-bottom"}}
  Box shadow large, bottom
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-lg-left"}}
  Box shadow large, left
{{/box-shadow}}
{{#> box-shadow box-shadow--modifier="pf-u-box-shadow-inset"}}
  Box shadow inset
{{/box-shadow}}
```

## Documentation
### Overview
Box shadow utility

### Usage
| Class | Applied to | Outcome |
| -- | -- | -- |
| `.pf-u-box-shadow-sm` | `*` |  Applies box-shadow small. |
| `.pf-u-box-shadow-sm-top` | `*` |  Applies box-shadow small top. |
| `.pf-u-box-shadow-sm-right` | `*` |  Applies box-shadow small right. |
| `.pf-u-box-shadow-sm-bottom` | `*` |  Applies box-shadow small bottom. |
| `.pf-u-box-shadow-sm-left` | `*` |  Applies box-shadow small left. |
| `.pf-u-box-shadow-md` | `*` |  Applies box-shadow medium. |
| `.pf-u-box-shadow-md-top` | `*` |  Applies box-shadow medium top. |
| `.pf-u-box-shadow-md-right` | `*` |  Applies box-shadow medium right. |
| `.pf-u-box-shadow-md-bottom` | `*` |  Applies box-shadow medium bottom. |
| `.pf-u-box-shadow-md-left` | `*` |  Applies box-shadow medium left. |
| `.pf-u-box-shadow-lg` | `*` |  Applies box-shadow large. |
| `.pf-u-box-shadow-lg-top` | `*` |  Applies box-shadow large top. |
| `.pf-u-box-shadow-lg-right` | `*` |  Applies box-shadow large right. |
| `.pf-u-box-shadow-lg-bottom` | `*` |  Applies box-shadow large bottom. |
| `.pf-u-box-shadow-lg-left` | `*` |  Applies box-shadow large left. |
