/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by lister-gen. DO NOT EDIT.

package v1beta2

import (
	v1beta2 "github.com/enmasseproject/enmasse/pkg/apis/admin/v1beta2"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// AddressPlanLister helps list AddressPlans.
type AddressPlanLister interface {
	// List lists all AddressPlans in the indexer.
	List(selector labels.Selector) (ret []*v1beta2.AddressPlan, err error)
	// AddressPlans returns an object that can list and get AddressPlans.
	AddressPlans(namespace string) AddressPlanNamespaceLister
	AddressPlanListerExpansion
}

// addressPlanLister implements the AddressPlanLister interface.
type addressPlanLister struct {
	indexer cache.Indexer
}

// NewAddressPlanLister returns a new AddressPlanLister.
func NewAddressPlanLister(indexer cache.Indexer) AddressPlanLister {
	return &addressPlanLister{indexer: indexer}
}

// List lists all AddressPlans in the indexer.
func (s *addressPlanLister) List(selector labels.Selector) (ret []*v1beta2.AddressPlan, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta2.AddressPlan))
	})
	return ret, err
}

// AddressPlans returns an object that can list and get AddressPlans.
func (s *addressPlanLister) AddressPlans(namespace string) AddressPlanNamespaceLister {
	return addressPlanNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// AddressPlanNamespaceLister helps list and get AddressPlans.
type AddressPlanNamespaceLister interface {
	// List lists all AddressPlans in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta2.AddressPlan, err error)
	// Get retrieves the AddressPlan from the indexer for a given namespace and name.
	Get(name string) (*v1beta2.AddressPlan, error)
	AddressPlanNamespaceListerExpansion
}

// addressPlanNamespaceLister implements the AddressPlanNamespaceLister
// interface.
type addressPlanNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all AddressPlans in the indexer for a given namespace.
func (s addressPlanNamespaceLister) List(selector labels.Selector) (ret []*v1beta2.AddressPlan, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta2.AddressPlan))
	})
	return ret, err
}

// Get retrieves the AddressPlan from the indexer for a given namespace and name.
func (s addressPlanNamespaceLister) Get(name string) (*v1beta2.AddressPlan, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta2.Resource("addressplan"), name)
	}
	return obj.(*v1beta2.AddressPlan), nil
}
