/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta2 "github.com/enmasseproject/enmasse/pkg/apis/admin/v1beta2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAddressSpacePlans implements AddressSpacePlanInterface
type FakeAddressSpacePlans struct {
	Fake *FakeAdminV1beta2
	ns   string
}

var addressspaceplansResource = schema.GroupVersionResource{Group: "admin.enmasse.io", Version: "v1beta2", Resource: "addressspaceplans"}

var addressspaceplansKind = schema.GroupVersionKind{Group: "admin.enmasse.io", Version: "v1beta2", Kind: "AddressSpacePlan"}

// Get takes name of the addressSpacePlan, and returns the corresponding addressSpacePlan object, and an error if there is any.
func (c *FakeAddressSpacePlans) Get(name string, options v1.GetOptions) (result *v1beta2.AddressSpacePlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(addressspaceplansResource, c.ns, name), &v1beta2.AddressSpacePlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressSpacePlan), err
}

// List takes label and field selectors, and returns the list of AddressSpacePlans that match those selectors.
func (c *FakeAddressSpacePlans) List(opts v1.ListOptions) (result *v1beta2.AddressSpacePlanList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(addressspaceplansResource, addressspaceplansKind, c.ns, opts), &v1beta2.AddressSpacePlanList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta2.AddressSpacePlanList{ListMeta: obj.(*v1beta2.AddressSpacePlanList).ListMeta}
	for _, item := range obj.(*v1beta2.AddressSpacePlanList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested addressSpacePlans.
func (c *FakeAddressSpacePlans) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(addressspaceplansResource, c.ns, opts))

}

// Create takes the representation of a addressSpacePlan and creates it.  Returns the server's representation of the addressSpacePlan, and an error, if there is any.
func (c *FakeAddressSpacePlans) Create(addressSpacePlan *v1beta2.AddressSpacePlan) (result *v1beta2.AddressSpacePlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(addressspaceplansResource, c.ns, addressSpacePlan), &v1beta2.AddressSpacePlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressSpacePlan), err
}

// Update takes the representation of a addressSpacePlan and updates it. Returns the server's representation of the addressSpacePlan, and an error, if there is any.
func (c *FakeAddressSpacePlans) Update(addressSpacePlan *v1beta2.AddressSpacePlan) (result *v1beta2.AddressSpacePlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(addressspaceplansResource, c.ns, addressSpacePlan), &v1beta2.AddressSpacePlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressSpacePlan), err
}

// Delete takes name of the addressSpacePlan and deletes it. Returns an error if one occurs.
func (c *FakeAddressSpacePlans) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(addressspaceplansResource, c.ns, name), &v1beta2.AddressSpacePlan{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAddressSpacePlans) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(addressspaceplansResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta2.AddressSpacePlanList{})
	return err
}

// Patch applies the patch and returns the patched addressSpacePlan.
func (c *FakeAddressSpacePlans) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta2.AddressSpacePlan, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(addressspaceplansResource, c.ns, name, data, subresources...), &v1beta2.AddressSpacePlan{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta2.AddressSpacePlan), err
}
