/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package v1beta2

import (
	v1beta2 "github.com/enmasseproject/enmasse/pkg/apis/admin/v1beta2"
	scheme "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AddressSpacePlansGetter has a method to return a AddressSpacePlanInterface.
// A group's client should implement this interface.
type AddressSpacePlansGetter interface {
	AddressSpacePlans(namespace string) AddressSpacePlanInterface
}

// AddressSpacePlanInterface has methods to work with AddressSpacePlan resources.
type AddressSpacePlanInterface interface {
	Create(*v1beta2.AddressSpacePlan) (*v1beta2.AddressSpacePlan, error)
	Update(*v1beta2.AddressSpacePlan) (*v1beta2.AddressSpacePlan, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta2.AddressSpacePlan, error)
	List(opts v1.ListOptions) (*v1beta2.AddressSpacePlanList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta2.AddressSpacePlan, err error)
	AddressSpacePlanExpansion
}

// addressSpacePlans implements AddressSpacePlanInterface
type addressSpacePlans struct {
	client rest.Interface
	ns     string
}

// newAddressSpacePlans returns a AddressSpacePlans
func newAddressSpacePlans(c *AdminV1beta2Client, namespace string) *addressSpacePlans {
	return &addressSpacePlans{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the addressSpacePlan, and returns the corresponding addressSpacePlan object, and an error if there is any.
func (c *addressSpacePlans) Get(name string, options v1.GetOptions) (result *v1beta2.AddressSpacePlan, err error) {
	result = &v1beta2.AddressSpacePlan{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("addressspaceplans").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AddressSpacePlans that match those selectors.
func (c *addressSpacePlans) List(opts v1.ListOptions) (result *v1beta2.AddressSpacePlanList, err error) {
	result = &v1beta2.AddressSpacePlanList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("addressspaceplans").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested addressSpacePlans.
func (c *addressSpacePlans) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("addressspaceplans").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a addressSpacePlan and creates it.  Returns the server's representation of the addressSpacePlan, and an error, if there is any.
func (c *addressSpacePlans) Create(addressSpacePlan *v1beta2.AddressSpacePlan) (result *v1beta2.AddressSpacePlan, err error) {
	result = &v1beta2.AddressSpacePlan{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("addressspaceplans").
		Body(addressSpacePlan).
		Do().
		Into(result)
	return
}

// Update takes the representation of a addressSpacePlan and updates it. Returns the server's representation of the addressSpacePlan, and an error, if there is any.
func (c *addressSpacePlans) Update(addressSpacePlan *v1beta2.AddressSpacePlan) (result *v1beta2.AddressSpacePlan, err error) {
	result = &v1beta2.AddressSpacePlan{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("addressspaceplans").
		Name(addressSpacePlan.Name).
		Body(addressSpacePlan).
		Do().
		Into(result)
	return
}

// Delete takes name of the addressSpacePlan and deletes it. Returns an error if one occurs.
func (c *addressSpacePlans) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("addressspaceplans").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *addressSpacePlans) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("addressspaceplans").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched addressSpacePlan.
func (c *addressSpacePlans) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta2.AddressSpacePlan, err error) {
	result = &v1beta2.AddressSpacePlan{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("addressspaceplans").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
