/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package versioned

import (
	adminv1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/admin/v1beta1"
	adminv1beta2 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/admin/v1beta2"
	enmassev1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/enmasse/v1beta1"
	iotv1alpha1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/iot/v1alpha1"
	userv1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/user/v1beta1"
	discovery "k8s.io/client-go/discovery"
	rest "k8s.io/client-go/rest"
	flowcontrol "k8s.io/client-go/util/flowcontrol"
)

type Interface interface {
	Discovery() discovery.DiscoveryInterface
	AdminV1beta1() adminv1beta1.AdminV1beta1Interface
	AdminV1beta2() adminv1beta2.AdminV1beta2Interface
	// Deprecated: please explicitly pick a version if possible.
	Admin() adminv1beta2.AdminV1beta2Interface
	EnmasseV1beta1() enmassev1beta1.EnmasseV1beta1Interface
	// Deprecated: please explicitly pick a version if possible.
	Enmasse() enmassev1beta1.EnmasseV1beta1Interface
	IotV1alpha1() iotv1alpha1.IotV1alpha1Interface
	// Deprecated: please explicitly pick a version if possible.
	Iot() iotv1alpha1.IotV1alpha1Interface
	UserV1beta1() userv1beta1.UserV1beta1Interface
	// Deprecated: please explicitly pick a version if possible.
	User() userv1beta1.UserV1beta1Interface
}

// Clientset contains the clients for groups. Each group has exactly one
// version included in a Clientset.
type Clientset struct {
	*discovery.DiscoveryClient
	adminV1beta1   *adminv1beta1.AdminV1beta1Client
	adminV1beta2   *adminv1beta2.AdminV1beta2Client
	enmasseV1beta1 *enmassev1beta1.EnmasseV1beta1Client
	iotV1alpha1    *iotv1alpha1.IotV1alpha1Client
	userV1beta1    *userv1beta1.UserV1beta1Client
}

// AdminV1beta1 retrieves the AdminV1beta1Client
func (c *Clientset) AdminV1beta1() adminv1beta1.AdminV1beta1Interface {
	return c.adminV1beta1
}

// AdminV1beta2 retrieves the AdminV1beta2Client
func (c *Clientset) AdminV1beta2() adminv1beta2.AdminV1beta2Interface {
	return c.adminV1beta2
}

// Deprecated: Admin retrieves the default version of AdminClient.
// Please explicitly pick a version.
func (c *Clientset) Admin() adminv1beta2.AdminV1beta2Interface {
	return c.adminV1beta2
}

// EnmasseV1beta1 retrieves the EnmasseV1beta1Client
func (c *Clientset) EnmasseV1beta1() enmassev1beta1.EnmasseV1beta1Interface {
	return c.enmasseV1beta1
}

// Deprecated: Enmasse retrieves the default version of EnmasseClient.
// Please explicitly pick a version.
func (c *Clientset) Enmasse() enmassev1beta1.EnmasseV1beta1Interface {
	return c.enmasseV1beta1
}

// IotV1alpha1 retrieves the IotV1alpha1Client
func (c *Clientset) IotV1alpha1() iotv1alpha1.IotV1alpha1Interface {
	return c.iotV1alpha1
}

// Deprecated: Iot retrieves the default version of IotClient.
// Please explicitly pick a version.
func (c *Clientset) Iot() iotv1alpha1.IotV1alpha1Interface {
	return c.iotV1alpha1
}

// UserV1beta1 retrieves the UserV1beta1Client
func (c *Clientset) UserV1beta1() userv1beta1.UserV1beta1Interface {
	return c.userV1beta1
}

// Deprecated: User retrieves the default version of UserClient.
// Please explicitly pick a version.
func (c *Clientset) User() userv1beta1.UserV1beta1Interface {
	return c.userV1beta1
}

// Discovery retrieves the DiscoveryClient
func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	if c == nil {
		return nil
	}
	return c.DiscoveryClient
}

// NewForConfig creates a new Clientset for the given config.
func NewForConfig(c *rest.Config) (*Clientset, error) {
	configShallowCopy := *c
	if configShallowCopy.RateLimiter == nil && configShallowCopy.QPS > 0 {
		configShallowCopy.RateLimiter = flowcontrol.NewTokenBucketRateLimiter(configShallowCopy.QPS, configShallowCopy.Burst)
	}
	var cs Clientset
	var err error
	cs.adminV1beta1, err = adminv1beta1.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	cs.adminV1beta2, err = adminv1beta2.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	cs.enmasseV1beta1, err = enmassev1beta1.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	cs.iotV1alpha1, err = iotv1alpha1.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	cs.userV1beta1, err = userv1beta1.NewForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}

	cs.DiscoveryClient, err = discovery.NewDiscoveryClientForConfig(&configShallowCopy)
	if err != nil {
		return nil, err
	}
	return &cs, nil
}

// NewForConfigOrDie creates a new Clientset for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *Clientset {
	var cs Clientset
	cs.adminV1beta1 = adminv1beta1.NewForConfigOrDie(c)
	cs.adminV1beta2 = adminv1beta2.NewForConfigOrDie(c)
	cs.enmasseV1beta1 = enmassev1beta1.NewForConfigOrDie(c)
	cs.iotV1alpha1 = iotv1alpha1.NewForConfigOrDie(c)
	cs.userV1beta1 = userv1beta1.NewForConfigOrDie(c)

	cs.DiscoveryClient = discovery.NewDiscoveryClientForConfigOrDie(c)
	return &cs
}

// New creates a new Clientset for the given RESTClient.
func New(c rest.Interface) *Clientset {
	var cs Clientset
	cs.adminV1beta1 = adminv1beta1.New(c)
	cs.adminV1beta2 = adminv1beta2.New(c)
	cs.enmasseV1beta1 = enmassev1beta1.New(c)
	cs.iotV1alpha1 = iotv1alpha1.New(c)
	cs.userV1beta1 = userv1beta1.New(c)

	cs.DiscoveryClient = discovery.NewDiscoveryClient(c)
	return &cs
}
