/*
 * Copyright 2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */
package io.enmasse.iot.model.v1;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;

@Buildable(
        editableEnabled = false,
        generateBuilderPackage = false,
        builderPackage = "io.fabric8.kubernetes.api.builder",
        inline = @Inline(
                type = Doneable.class,
                prefix = "Doneable",
                value = "done"
                )
        )
//FIXME: implement missing fields and remove ignore annotation
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class IoTProjectStatus {

    @JsonProperty("isReady")
    private boolean ready = false;
    private String tenantName;
    private ExternalDownstreamStrategy downstreamEndpoint;
    private List<ProjectCondition> conditions;

    public boolean isReady() {
        return ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public ExternalDownstreamStrategy getDownstreamEndpoint() {
        return downstreamEndpoint;
    }

    public void setDownstreamEndpoint(ExternalDownstreamStrategy downstreamEndpoint) {
        this.downstreamEndpoint = downstreamEndpoint;
    }

    public List<ProjectCondition> getConditions() {
        return conditions;
    }

    public void setConditions(List<ProjectCondition> conditions) {
        this.conditions = conditions;
    }

}
