/*
Copyright 2019 The Interconnectedcloud Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/interconnectedcloud/qdr-operator/pkg/apis/interconnectedcloud/v1alpha1"
	scheme "github.com/interconnectedcloud/qdr-operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// InterconnectsGetter has a method to return a InterconnectInterface.
// A group's client should implement this interface.
type InterconnectsGetter interface {
	Interconnects(namespace string) InterconnectInterface
}

// InterconnectInterface has methods to work with Interconnect resources.
type InterconnectInterface interface {
	Create(*v1alpha1.Interconnect) (*v1alpha1.Interconnect, error)
	Update(*v1alpha1.Interconnect) (*v1alpha1.Interconnect, error)
	UpdateStatus(*v1alpha1.Interconnect) (*v1alpha1.Interconnect, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.Interconnect, error)
	List(opts v1.ListOptions) (*v1alpha1.InterconnectList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Interconnect, err error)
	InterconnectExpansion
}

// interconnects implements InterconnectInterface
type interconnects struct {
	client rest.Interface
	ns     string
}

// newInterconnects returns a Interconnects
func newInterconnects(c *InterconnectedcloudV1alpha1Client, namespace string) *interconnects {
	return &interconnects{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the interconnect, and returns the corresponding interconnect object, and an error if there is any.
func (c *interconnects) Get(name string, options v1.GetOptions) (result *v1alpha1.Interconnect, err error) {
	result = &v1alpha1.Interconnect{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("interconnects").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Interconnects that match those selectors.
func (c *interconnects) List(opts v1.ListOptions) (result *v1alpha1.InterconnectList, err error) {
	result = &v1alpha1.InterconnectList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("interconnects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested interconnects.
func (c *interconnects) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("interconnects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a interconnect and creates it.  Returns the server's representation of the interconnect, and an error, if there is any.
func (c *interconnects) Create(interconnect *v1alpha1.Interconnect) (result *v1alpha1.Interconnect, err error) {
	result = &v1alpha1.Interconnect{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("interconnects").
		Body(interconnect).
		Do().
		Into(result)
	return
}

// Update takes the representation of a interconnect and updates it. Returns the server's representation of the interconnect, and an error, if there is any.
func (c *interconnects) Update(interconnect *v1alpha1.Interconnect) (result *v1alpha1.Interconnect, err error) {
	result = &v1alpha1.Interconnect{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("interconnects").
		Name(interconnect.Name).
		Body(interconnect).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *interconnects) UpdateStatus(interconnect *v1alpha1.Interconnect) (result *v1alpha1.Interconnect, err error) {
	result = &v1alpha1.Interconnect{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("interconnects").
		Name(interconnect.Name).
		SubResource("status").
		Body(interconnect).
		Do().
		Into(result)
	return
}

// Delete takes name of the interconnect and deletes it. Returns an error if one occurs.
func (c *interconnects) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("interconnects").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *interconnects) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("interconnects").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched interconnect.
func (c *interconnects) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Interconnect, err error) {
	result = &v1alpha1.Interconnect{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("interconnects").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
