# Preface

What is Apache ActiveMQ Artemis?

-   Apache ActiveMQ Artemis is an open source project to build a multi-protocol,
    embeddable, very high performance, clustered, asynchronous messaging
    system.

-   Apache ActiveMQ Artemis is an example of Message Oriented Middleware (MoM). For a
    description of MoMs and other messaging concepts please see the [Messaging Concepts](messaging-concepts.md).

Why use Apache ActiveMQ Artemis? Here are just a few of the reasons:

-   100% open source software. Apache ActiveMQ Artemis is licensed using the Apache
    Software License v 2.0 to minimise barriers to adoption.

-   Apache ActiveMQ Artemis is designed with usability in mind.

-   Written in Java. Runs on any platform with a Java 8+ runtime, that's
    everything from Windows desktops to IBM mainframes.

-   Amazing performance. Our ground-breaking high performance journal
    provides persistent messaging performance at rates normally seen for
    non-persistent messaging, our non-persistent messaging performance
    rocks the boat too.

-   Full feature set. All the features you'd expect in any serious
    messaging system, and others you won't find anywhere else.

-   Elegant, clean-cut design with minimal third party dependencies. Run
    ActiveMQ Artemis stand-alone, run it in integrated in your favourite JEE
    application server, or run it embedded inside your own product. It's
    up to you.

-   Seamless high availability. We provide a HA solution with automatic
    client failover so you can guarantee zero message loss or
    duplication in event of server failure.

-   Hugely flexible clustering. Create clusters of servers that know how
    to load balance messages. Link geographically distributed clusters
    over unreliable connections to form a global network. Configure
    routing of messages in a highly flexible way.


