/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public abstract class QueueAbstractPacket extends PacketImpl {

   protected SimpleString queueName;
   protected SimpleString oldVersionQueueName;

   protected SimpleString address;
   protected SimpleString oldVersionAddresseName;

   public SimpleString getQueueName(int clientVersion) {

      if (clientVersion < ADDRESSING_CHANGE_VERSION) {
         if (oldVersionQueueName == null) {
            oldVersionQueueName = convertName(queueName);
         }

         return oldVersionQueueName;
      } else {
         return queueName;
      }
   }

   public SimpleString getAddress(int clientVersion) {

      if (clientVersion < ADDRESSING_CHANGE_VERSION) {
         if (oldVersionAddresseName == null) {
            oldVersionAddresseName = convertName(address);
         }

         return oldVersionAddresseName;
      } else {
         return address;
      }
   }

   public QueueAbstractPacket(byte type) {
      super(type);
   }
}
