/**
 * Copyright (C) FuseSource, Inc.
 * http://fusesource.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.fabric8.watcher.matchers;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;

/**
 * Additional matcher support
 */
public class Matchers {

    public static PathMatcher parse(String expression) {
        return parse(expression, FileSystems.getDefault());
    }

    public static PathMatcher parse(String expression, FileSystem fs) {
        if (expression.startsWith(Logical.PREFIX)) {
            return Logical.parse(expression);
        } else if (expression.startsWith(Maven.PREFIX)) {
            return Maven.parse(expression);
        } else {
            return fs.getPathMatcher(expression);
        }
    }

}
