/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="method")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MethodCallExpression
extends ExpressionDefinition {
    @XmlAttribute(required=false)
    private String bean;
    @XmlAttribute(required=false)
    private String method;
    @XmlTransient
    private Class<?> beanType;

    public MethodCallExpression() {
    }

    public MethodCallExpression(String beanName) {
        super(beanName);
    }

    public MethodCallExpression(String beanName, String method) {
        super(beanName);
        this.method = method;
    }

    public MethodCallExpression(Class<?> type) {
        super(type.toString());
        this.beanType = type;
    }

    public MethodCallExpression(Class<?> type, String method) {
        super(type.toString());
        this.beanType = type;
        this.method = method;
    }

    @Override
    public String getLanguage() {
        return "bean";
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public Expression createExpression(RouteContext routeContext) {
        if (this.beanType != null) {
            return new BeanExpression(ObjectHelper.newInstance(this.beanType), this.getMethod());
        }
        return new BeanExpression(this.beanName(), this.getMethod());
    }

    @Override
    public Predicate createPredicate(RouteContext routeContext) {
        if (this.beanType != null) {
            return new BeanExpression(ObjectHelper.newInstance(this.beanType), this.getMethod());
        }
        return new BeanExpression(this.beanName(), this.getMethod());
    }

    protected String beanName() {
        if (this.bean != null) {
            return this.bean;
        }
        return this.getExpression();
    }

    @Override
    public String toString() {
        return "bean{" + this.beanName() + (this.method != null ? ", method=" + this.method : "") + "}";
    }
}

