/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileProcessStrategySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileDeleteProcessStrategy<T>
extends GenericFileProcessStrategySupport<T> {
    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        super.commit(operations, endpoint, exchange, file);
        int retries = 3;
        boolean deleted = false;
        while (retries > 0 && !deleted) {
            --retries;
            if (operations.deleteFile(file.getAbsoluteFilePath())) {
                deleted = true;
                break;
            }
            boolean exits = operations.existsFile(file.getAbsoluteFilePath());
            if (!exits) {
                deleted = true;
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("File was not deleted at this attempt will try again in 1 sec.: " + file));
            }
            Thread.sleep(1000L);
        }
        if (!deleted) {
            throw new GenericFileOperationFailedException("Cannot delete file: " + file);
        }
    }
}

