/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInfo;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.LRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfoCache {
    private final CamelContext camelContext;
    private Map<Method, MethodInfo> methodCache;
    private Map<Class<?>, BeanInfo> classCache;

    public MethodInfoCache(CamelContext camelContext) {
        this(camelContext, 1000, 10000);
    }

    public MethodInfoCache(CamelContext camelContext, int classCacheSize, int methodCacheSize) {
        this(camelContext, MethodInfoCache.createClassCache(classCacheSize), MethodInfoCache.createMethodCache(methodCacheSize));
    }

    public MethodInfoCache(CamelContext camelContext, Map<Class<?>, BeanInfo> classCache, Map<Method, MethodInfo> methodCache) {
        this.camelContext = camelContext;
        this.classCache = classCache;
        this.methodCache = methodCache;
    }

    public synchronized MethodInfo getMethodInfo(Method method) {
        MethodInfo answer = this.methodCache.get(method);
        if (answer == null) {
            answer = this.createMethodInfo(method);
            this.methodCache.put(method, answer);
        }
        return answer;
    }

    protected MethodInfo createMethodInfo(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        BeanInfo info = this.getBeanInfo(declaringClass);
        return info.getMethodInfo(method);
    }

    protected synchronized BeanInfo getBeanInfo(Class<?> declaringClass) {
        BeanInfo beanInfo = this.classCache.get(declaringClass);
        if (beanInfo == null) {
            beanInfo = this.createBeanInfo(declaringClass);
            this.classCache.put(declaringClass, beanInfo);
        }
        return beanInfo;
    }

    protected BeanInfo createBeanInfo(Class<?> declaringClass) {
        return new BeanInfo(this.camelContext, declaringClass);
    }

    protected static Map<Object, Object> createLruCache(int size) {
        return new LRUCache<Object, Object>(size);
    }

    private static Map<Class<?>, BeanInfo> createClassCache(int size) {
        return CastUtils.cast(MethodInfoCache.createLruCache(size));
    }

    private static Map<Method, MethodInfo> createMethodCache(int size) {
        return CastUtils.cast(MethodInfoCache.createLruCache(size));
    }
}

