/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.List;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.resolver.Module;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;

class ExportedPackageImpl
implements ExportedPackage {
    private final Felix m_felix;
    private final BundleImpl m_exportingBundle;
    private final Module m_exportingModule;
    private final Capability m_export;
    private final String m_pkgName;
    private final Version m_version;

    public ExportedPackageImpl(Felix felix, BundleImpl exporter, Module module, Capability export) {
        this.m_felix = felix;
        this.m_exportingBundle = exporter;
        this.m_exportingModule = module;
        this.m_export = export;
        this.m_pkgName = (String)this.m_export.getAttribute("package").getValue();
        this.m_version = this.m_export.getAttribute("version") == null ? Version.emptyVersion : (Version)this.m_export.getAttribute("version").getValue();
    }

    public Bundle getExportingBundle() {
        if (this.m_exportingBundle.isStale()) {
            return null;
        }
        return this.m_exportingBundle;
    }

    public Bundle[] getImportingBundles() {
        if (this.m_exportingBundle.isStale()) {
            return null;
        }
        List<Bundle> list = this.m_felix.getImportingBundles(this);
        return list.toArray(new Bundle[list.size()]);
    }

    public String getName() {
        return this.m_pkgName;
    }

    public String getSpecificationVersion() {
        return this.m_version.toString();
    }

    public Version getVersion() {
        return this.m_version;
    }

    public boolean isRemovalPending() {
        return this.m_exportingBundle.isRemovalPending();
    }

    public String toString() {
        return this.m_pkgName + "; version=" + this.m_version;
    }
}

