/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.AsyncProcessorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueLoadBalancer
extends LoadBalancerSupport {
    @Override
    public boolean process(Exchange exchange, final AsyncCallback callback) {
        List<Processor> list = this.getProcessors();
        if (!list.isEmpty()) {
            Processor processor = this.chooseProcessor(list, exchange);
            if (processor == null) {
                throw new IllegalStateException("No processors could be chosen to process " + exchange);
            }
            AsyncProcessor albp = AsyncProcessorTypeConverter.convert(processor);
            boolean sync = AsyncProcessorHelper.process(albp, exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (doneSync) {
                        return;
                    }
                    callback.done(false);
                }
            });
            if (!sync) {
                return false;
            }
            callback.done(true);
            return true;
        }
        callback.done(true);
        return true;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    protected abstract Processor chooseProcessor(List<Processor> var1, Exchange var2);
}

